/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkSupportVectorMachine.h,v $
  Language:  C++
  Date:      $Date: 2006/09/07 11:48:50 $
  Version:   $Revision: 1.1 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __SupportVectorMachine_h
#define __SupportVectorMachine_h

#include "itkDataObject.h"
#include "itkSVMKernelBase.h"
#include "itkRBFSVMKernel.h"
#include <vector>


namespace itk
{
namespace Statistics
{
template<class TMeasurementVector>
class SupportVectorMachine : 
    public DataObject
{
public:
  /** standard ITK typedefs */
  typedef SupportVectorMachine                          Self;
  typedef DataObject                                    Superclass;
  typedef SmartPointer<Self>                            Pointer;
  typedef SmartPointer<const Self>                      ConstPointer;

  /** standard ITK new and type macros */
  itkTypeMacro(SupportVectorMachine, DataObject);
  itkNewMacro(Self) ;

  /** the type of vector that this svm operates with */
  typedef TMeasurementVector                            MeasurementVectorType;

  /** the kernel associated with this svm */
  typedef SVMKernelBase<MeasurementVectorType,double>   KernelType;

  /** the default kernel for this svm */

  /** label type for the support vector machine */
  typedef double                                        LabelType;

  typedef itk::Statistics::NumericsListSample<MeasurementVectorType> SampleType;


  /** access the number of support vectors associated with this svm */
  void SetNumberOfSupportVectors(unsigned int n);
  unsigned int GetNumberOfSupportVectors() const;

  /** access the support vectors associated with this svm */
  void SetSupportVector(unsigned int index, const MeasurementVectorType& v);
  const MeasurementVectorType& GetSupportVector(unsigned int index) const;

  /** access the alpha value associated with each support vector */
  void SetAlpha(unsigned int index, double alpha);
  double GetAlpha(unsigned int index) const;

  /** access the label associated with each support vector */
//  void SetLabel(unsigned int index, LabelType label);
//  LabelType GetLabel(unsigned int index) const;

  // mjkim for SVMTorch
  typedef vnl_vector<double> YType;  
  void SetY (YType y);
  YType* GetY () ; 

 // void SetY(unsigned int index, double y);
// double GetY(unsigned int index) const;

  void SetL (int l);
  int GetL () ; // const -> error

  /** access MeasurementVectorSize for the SVM    */
  itkGetMacro(MeasurementVectorSize, unsigned int);
   
  /** access the kernel used by this support vector machine */
  itkSetObjectMacro(Kernel, KernelType);
  itkGetObjectMacro(Kernel, KernelType);
  itkGetConstObjectMacro(Kernel, KernelType);


 
  /** use this support vector machine to classify a vector */

  /** clear support vectors as well as associated parameters */
  void Initialize();

  //double *target;

  SupportVectorMachine();
  virtual ~SupportVectorMachine();

//    std::vector<LabelType>                           m_Labels;



protected:
//  SupportVectorMachine();
//  virtual ~SupportVectorMachine();

  unsigned int                                     m_MeasurementVectorSize;
  double                                           m_B;
  std::vector<MeasurementVectorType>               m_SupportVectors;
  std::vector<double>                              m_Alphas;
  typename KernelType::Pointer                     m_Kernel;
  typename SampleType::Pointer			   m_Sample;
  YType						   m_Y;
  int						   m_L;

private:
  // purposely not implemented
  SupportVectorMachine(const Self&); 
  // purposely not implemented
  void operator=(const Self&);                    
};

} // end namespace Statistics
} // end namespace itk

#ifndef ITK_MANUAL_INSTANTIATION
  #include "itkSupportVectorMachine.txx"
#endif

#endif
