#include <cstdlib>
#include <cstdio>
#include <math.h>
#include <string>
#include <vector>

#include "itkFixedArray.h"
#include "itkMatrix.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkShrinkImageFilter.h"

#include "itkVector.h"

#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkRescaleIntensityImageFilter.h"
#include "itkOutputWindow.h"
#include "itkTextOutput.h"
#include "itkImageDuplicator.h"

#include <iostream>
#include <sstream>
#include <vector>
#include <string>

#include <math.h>
#include <stdlib.h>

#include <list>
#include <fstream>
#include <algorithm>

#include "wmlstestCLP.h"

#include "itkImage.h"
#include "itkOrientImageFilter.h"

#define ORIENT  // CAUTION!!!
#define PREPROYES

//MJ
#include "itkWMLPreprocessor.h"
//#include "itkWMLTestingProcessor.h"

#include "itkWMLGetSelectedFeature.h"

#include "itkBinaryThresholdImageFilter.h"

using namespace std;

std::vector<std::string>           SubjectNames;
std::vector<std::string>           ImageNames;

std::string                        DirConnect = "/";


void strtrim(string& str)
{
  string::size_type pos = str.find_last_not_of(' ');
  if(pos != string::npos) 
  {
    str.erase(pos + 1);
    pos = str.find_first_not_of(' ');
    if(pos != string::npos) 
    {
      str.erase(0, pos);
    }
  }
  else str.erase(str.begin(), str.end());
}


//template<class T> int DoIt( int argc, char * argv[], T, int index )
template <class T> int DoIt( int argc, char *argv[] )
{

  PARSE_ARGS;

  cout << "DoIt()" << endl;

  const unsigned int Dimension = 3;

  typedef T PixelType;
  typedef T WritePixelType;

 //MJ_TEMP
  typedef itk::Image<PixelType, Dimension> ImageType;

  typedef itk::OrientImageFilter<ImageType,ImageType> OrientFilterType;


//MJ_TEMP
//  typedef itk::VariableLengthVector<PixelType>       MeasurementVectorType;
  typedef itk::VariableLengthVector<short> MeasurementVectorType;

  typedef itk::WMLGetSelectedFeature<ImageType, MeasurementVectorType> WMLGetSelectedFeatureType;

  unsigned int numSubjects = SubjectNames.size();
  cout << "numSubjects: " << numSubjects << endl;

  typedef typename WMLGetSelectedFeatureType::ImageVectorType ImageVectorType;

// MJ_TEMP
  ImageVectorType T1Images(numSubjects);
  ImageVectorType T2Images(numSubjects);
  ImageVectorType PDImages(numSubjects);
  ImageVectorType FLImages(numSubjects);
  
 // 0318
  ImageVectorType FLThresholdImages(numSubjects);
  
  // Set file types
  typedef itk::ImageFileReader<ImageType> ReaderType;
  typename ReaderType::Pointer T1imgReader = ReaderType::New();
  typename ReaderType::Pointer T2imgReader = ReaderType::New();
  typename ReaderType::Pointer PDimgReader = ReaderType::New();
  typename ReaderType::Pointer FLimgReader = ReaderType::New();

  // 0318
  typedef itk::ImageFileWriter<ImageType> WriterType;
  typedef itk::BinaryThresholdImageFilter<ImageType, ImageType >  FilterType;
  typename FilterType::Pointer filter = FilterType::New();

  typename WriterType::Pointer writer = WriterType::New();
  writer->SetInput( filter->GetOutput() );
  writer->SetFileName( "FL.threshold.mha" );


 // std::vector<ShortImageType::Pointer> outputImages;

  for (unsigned int i=0; i<numSubjects; i++) 
  {
    std::cout << "Reading " << SubjectNames[i] <<" ..." << std::endl;

    // Set filenames for multiprotocol MRIs and masks 
    std::string imagefilename;
    // Read images and masks
    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[0];
    T1imgReader->SetFileName(imagefilename.c_str());
    cout << "\tT1 FileName: " << imagefilename << endl;
    T1imgReader->Update();
    T1Images[i] = T1imgReader->GetOutput();
    T1Images[i]->DisconnectPipeline();

    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[1];
    T2imgReader->SetFileName(imagefilename.c_str());
    cout << "\tT2 FileName: " << imagefilename << endl;
    T2imgReader->Update();
    T2Images[i] = T2imgReader->GetOutput();
    T2Images[i]->DisconnectPipeline();

    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[2];
    PDimgReader->SetFileName(imagefilename.c_str());
    cout << "\tPD FileName: " << imagefilename << endl;
    PDimgReader->Update();
    PDImages[i] = PDimgReader->GetOutput();
    PDImages[i]->DisconnectPipeline();

    imagefilename = DataDirectory + DirConnect + SubjectNames[i] + ImageNames[3];
    FLimgReader->SetFileName(imagefilename.c_str());
    cout << "\tFL FileName: " << imagefilename << endl;
    FLimgReader->Update();
    FLImages[i] = FLimgReader->GetOutput();
    FLImages[i]->DisconnectPipeline();

    // 0318
    filter->SetInput( FLImages[i] );

    filter->SetOutsideValue( 0 );
    filter->SetInsideValue( 255 );

    filter->SetLowerThreshold( 100 );
    filter->SetUpperThreshold( 255 );

    filter->Update();
  
    FLThresholdImages[i] = filter->GetOutput();
    FLThresholdImages[i]->DisconnectPipeline();

    writer->Update();

   // MJ: for proprocessing
   if (PreprocessingSwitch==true)
   {
     std::cout << "Preprocessing applied" << endl;

     typedef itk::WMLPreprocessor<ImageType, ImageType> WMLPreprocessorType;
     typename WMLPreprocessorType::Pointer preprocessor = WMLPreprocessorType::New();

     preprocessor->SetNumImages(numSubjects);
     preprocessor->SetT1Image(T1Images);
     preprocessor->SetT2Image(T2Images);
     preprocessor->SetPDImage(PDImages);
     preprocessor->SetFLImage(FLImages);
   
     preprocessor->preprocessing();
   }
   else
   {
     std::cout << "Preprocessing skipped" << endl;
   }


    typename WMLGetSelectedFeatureType::Pointer feature_selector = WMLGetSelectedFeatureType::New();

    std::ostringstream model;
    model << ModelName;
    feature_selector->SetNumImages(numSubjects);
    feature_selector->SetRadius(1);
    feature_selector->Testing(T1Images[i], T2Images[i], PDImages[i], FLImages[i], FLThresholdImages[i], model);
  }

  return EXIT_SUCCESS;

}

int main(int argc,char *argv[])
  
{

  PARSE_ARGS;

  // Read filelist

  std::fstream pFile;
  std::string buffer;
  pFile.open (SubjectList.c_str());
  if (pFile == NULL) 
  {
    perror ("Error opening file");
  }
  else
  {
    while ( !pFile.eof() )
    {
      getline (pFile, buffer,'\n');
      strtrim( buffer );
      if (buffer.size() > 0)
      {
        SubjectNames.push_back(buffer);
      }
    }
  }
  pFile.close();

  //echo
  std::cout << "Number of training subjects: " << SubjectNames.size() << std::endl;
  for (unsigned int k = 0; k < SubjectNames.size(); k ++)
  {
    std::cout << SubjectNames[k] << std::endl;
  }
  
  std::cout << SuffixList << std::endl;
  std::fstream sFile;
  sFile.open ( SuffixList.c_str() );
  if (sFile == NULL) 
  {
    perror ("Error opening file");
  }
  else
  {
    while ( ! sFile.eof() )
    {
      getline (sFile, buffer,'\n');
      strtrim( buffer );
      if (buffer.size() > 0)
      {
        ImageNames.push_back(buffer);
      }
    }
  }
  sFile.close();


  return DoIt<unsigned short>( argc, argv );
  return EXIT_SUCCESS;



}
