#!/usr/bin/perl

# --------------------------------------------------------------
#
#@Input file  : analyze format MR T1 image
# 
#@Output file : bias-field corrected T1 image in Analyze Format
#
# ---------------------------------------------------------------

# ---------------------------------------------------------------
# get arguments
# ---------------------------------------------------------------
use Getopt::Std;
use IO::File;
use Cwd;

$argc=@ARGV;

if ($argc < 1){&showUsage;}

my $opt_string = 'hi:o:p:d:v:r:m:g:a:t:s:f:';
getopts( "$opt_string");

if($opt_h){&showUsage;}

# --------------------------------------------------------------
# option about input and output
# --------------------------------------------------------------
# input
$input="";
if ($opt_i) {$input = $opt_i;}
open (IN, "$input") || die "\nError open: $input\n\n";
close(IN);
print "\n-----------------------------------------------\n";
print "File information \n";
print "\tInput file: $input\n";

$temp_path="";
if ($opt_p) {$temp_path = $opt_p;}
open (TEMP_PATH, "$temp_path") || die "\nError open: $temp_path\n\n";
close TEMP_PATH;
print "\ttemp path: $temp_path\n";

# dimension 0-x, 1-y, 2-z
@imageSize     = ( 256,256,124);
if ($opt_d) { @imageSize = split(",", $opt_d); }
print "\timage size: $imageSize[0], $imageSize[1], $imageSize[2]\n";

# voxel size 0-x, 1-y, 2-z
@voxelSize     = ( 0.9375, 0.9375, 1.5);
if ($opt_v) { @voxelSize = split(",", $opt_v); }
print "\timage voxel: $voxelSize[0], $voxelSize[1], $voxelSize[2]\n";
	
# orientation 
$orientation = "transverse";
if ($opt_r) {
  $temp    = $opt_r;
  if ( $temp  == 1 ) { $orientation = "transverse"; } 
  elsif ( $temp  == 2 ) {	$orientation = "sagittal"; } 
  elsif ( $temp  == 3 ) {	$orientation = "coronal"; } 
  else {
    print "\nUnknown orientation: $opt_r\n";
    &showUsage;
    exit(1);
  }
}
print "\torientation: $orientation\n";

# output file
$output           = "OUTPUT";
if ($opt_o) {
  $output       = $opt_o;
  @outputPrefix = split("[.]", $output);
}
print "\toutput is  $output\n";
print "-----------------------------------------------\n";

# --------------------------------------------------------------
# N3 specific option 
# --------------------------------------------------------------

print "\n-----------------------------------------------\n";
print "N3 options \n";

# Mask file
$mask     = "";
if ( $opt_m ) {
  $mask = $opt_m;
  open (IN, "$mask") || die "\nError open: $mask\n\n";
  close(IN);
  print "\tMask file: $mask\n";
}

# distance
$distance     = 200;
if ( $opt_g ) {	$distance = $opt_g; }
print "\tdistance [ $distance ], ";

# iteration
$iteration     = 50;
if ( $opt_a ) {	$iteration = $opt_a; } 
print "iteration [ $iteration ]";

# threshold
$threshold     = 0.001;
if ( $opt_t ) {	$threshold = $opt_t; }
print "\n\tstop threshold [ $threshold ], ";

# shrink
$shrink       = 4;
if ( $opt_s ) {	$shrink   = $opt_s; }
print "shrink [ $shrink ], ";

# fwhm
$fwhm     = 0.15;
if ( $opt_f ) {	$fwhm = $opt_f; }
print "fwhm [ $fwhm ]\n";
print "-----------------------------------------------\n";

chdir("$temp_path\/");
# --------------------------------------------------------------
# convert to minc format
# --------------------------------------------------------------
print "\n--------------- N3 correction -------------------------\n";
print "Working ...\n";
srand(time ^ $$ ) ;
#$tempFile = int(100000*rand ());
$tempFile = "tempFile";

# raw to minc format
#$cmd = "rawtominc $tempFile.mnc -$orientation -byte -obyte -clobber -mri -zstep $voxelSize[2] -xstep $voxelSize[0] -ystep $voxelSize[1] -range 0 255 -real_range 0 255  -input $input -zyx $imageSize[2] $imageSize[1] $imageSize[0]";
$cmd = " rawtominc $tempFile.mnc -transverse -byte -obyte -clobber -mri -zstep 1.5 -xstep 0.9375 -ystep 0.9375 -range 0 255 -real_range 0 255 -input ../tmp/tmp.img -zyx 46 256 256";
system($cmd) == 0 or die "$cmd failed: $?";

#$maskFile = int(100000*rand ());
$maskFile = "tempMask";

$nouseOutput = $maskFile.".txt";
if ( $opt_m ) {
  $maskTemp = $maskFile.".img";

# threshold the input mask file to 1.
  $cmd = "extractVentricle  $mask $maskTemp  -t1 >> $nouseOutput  "; system($cmd) == 0 or die "$cmd failed: $?";
  $cmd = "ChangeLineValueInImg $maskTemp $maskTemp -o255 -c1 >> $nouseOutput"; system($cmd) == 0 or die "$cmd failed: $?";

#convert the mask image to mnc file
#  $cmd = "rawtominc $maskFile.mnc $temp-$orientation -byte -obyte -clobber -mri -zstep $voxelSize[2] -xstep $voxelSize[0] -ystep $voxelSize[1] -range 0 255 -real_range 0 255  -input $maskTemp -zyx $imageSize[2] $imageSize[1] $imageSize[0]";
 $cmd = "rawtominc $maskFile.mnc -$orientation -byte -obyte -clobber -mri -zstep $voxelSize[2] -xstep $voxelSize[0] -ystep $voxelSize[1] -range 0 255 -real_range 0 255  -input $maskTemp -zyx $imageSize[2] $imageSize[1] $imageSize[0]";
  system($cmd) == 0 or die "$cmd failed: $?"; 
  $mask = "\-mask " . $maskFile . ".mnc";
}

#$tempOutFile = int(100000*rand ());
$tempOutFile = "tempOutFile";

# nu_correct
#$cmd = "nu_correct -mapping_dir $temp_path -clobber -fwhm $fwhm -stop $threshold -iteration $iteration -shrink $shrink $mask -distance $distance $tempFile.mnc $tempOutFile.mnc";
$cmd = "nu_correct -mapping_dir $temp_path -clobber -fwhm $fwhm -stop $threshold -iteration $iteration -shrink $shrink $mask -distance $distance $tempFile.mnc $tempOutFile.mnc";
system($cmd) == 0 or die "$cmd failed: $?";

# convert back to analyze format

print "\n\nWriting output: $output @outputPrefix[0].imp ... ";

# print "minctoraw -normalize $tempOutFile.mnc > $output\n";
$cmd = "minctoraw -normalize $tempOutFile.mnc > $output"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $tempOutFile.imp @outputPrefix[0].imp"; system ($cmd) == 0 or die "$cmd failed: $?";
print "finished \n";

# remove temporay files
system("rm $tempOutFile.mnc $tempFile.mnc  $tempOutFile.imp");
if ($opt_m) {
  $cmd = "rm $maskFile.mnc $maskFile.img $maskFile.txt"; system($cmd) == 0 or die "$cmd failed: $?";
}

# ----------------------------------------------------------------
#@function:  showUsage
#@arguments: None
# ----------------------------------------------------------------
sub showUsage{
    print "\n";
    print "\nUsage: \n\t$0 [options]\n\n";
    print "\t-h                              : display this (help) message\n";
    print "\t-i <string>                     : input file name, ONLY works on 1-BYTE image\n";
    print "\t-o <string>                     : output file name\n";
    print "\t-p <string>                     : temp_path\n";
    print "\t-d <int>,<int>,<int>            : input dimension [X, Y, Z], default: 256, 256, 124\n";
	print "\t-v <int>,<int>,<int>            : input voxel size [X, Y, Z], default: 0.9375, 0.9375, 1.5\n";
	print "\t-r <int>                        : image orientation, [1] for transverse, [2] for sagital,\n";
	print "\t                                  [3] for coronal, default is transverse\n";
    print "\n----------------------------- N3 options ------------------------------------------------\n";
	print "\t-m <string>                     : mask image, specify region for processing, same dimension\n";
	print "\t                                  as input image\n";
	print "\t-g <int>                        : characteristic distance over which field varies in mm,\n";
	print "\t                                  100-200, default: 200\n";
	print "\t-a <int>                        : maximum number of iterations to run, default: 50\n";
	print "\t-t <float>                      : CV of change in field estimate below which iteration\n";
	print "\t                                  stops (suggest 0.01 to 0.0001), default: 0.001\n";
	print "\t-s <int>                        : specify a smaller workspace; the sampling in each\n";
	print "\t                                  dimension is reduced to that of the finest sampling\n";
	print "\t                                  divided by factor or the current sampling which ever is less\n";
	print "\t                                  less. (suggest 2 or 3), default: 4\n";
	print "\t-f <float>                      : width of deconvolution kernal used to sharpen histogram\n";
	print "\t                                  Larger values give faster convergence while smaller\n";
	print "\t                                  values give greater accuracy.(suggest 0.05 to 0.5)\n";
	print "\t                                  default: 0.15\n";
	print "\nExample: \n\t$0 -i T1.img -o T1_restore.img\n\n";
	print "\t$0 -i T1.img -o T1_restore.img -d192,256,160 -v 1,1,1 -m mask.img -g 100 \n";
	print "\n\nQuestions: Zhiqiang.Lao\@uphs.upenn.edu\n"; 
	print "\n"; 
	exit(1);
} 
	

