#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include <mvcd.h>
#include <cres.h>
#include <matrixSHEN.h>  /*by SHEN*/

#define BACKGROUND      0.0

void show_usage(int argc, char **argv);
void InvertImage(int argc, char **argv, Ivector3d dim);

int main(int argc,char *argv[])
{
  Ivector3d        dim, start;
  int              c, type, direction, zero_filling, slice1, slice2;

  if(argc<2) show_usage(argc, argv);

  dim.x = dim.y = 256; dim.z = 110;
  type = 1;
  while((c=getopt(argc-2,argv+2,"d:")) != -1) {
    switch(c) {
    case 'd':
      sscanf(optarg, "%d,%d", &dim.x, &dim.y);
      break;

    default:
      break;
    }
  }
  printf("image dimension: (%d, %d)\n", dim.x, dim.y);

  InvertImage(argc, argv, dim);

  return 0;
}


void show_usage(int argc, char **argv)
{
  printf("USAGE: %s <input_img> <inverted_img>\n\
\t -d <int>,<int>       : image dimension XY (default: 256,256)\n\
", argv[0]);
  exit(1);
}

void  InvertImage(int argc, char **argv, Ivector3d dim)
{
  float            ***img, ***out, minvalue, maxvalue, *array;
  int              i, j, k, l, m, total_voxel_number;
  FILE             *fp;

  fp = fopen(argv[1],"r");
  fseek(fp,0,SEEK_END);
  dim.z = (ftell(fp))/(dim.x*dim.y*sizeof(float));
  printf("image %s have %d slices\n", argv[1], dim.z);
  rewind(fp);
  fclose(fp);
  printf("dim again: (%d, %d, %d)\n", dim.x, dim.y, dim.z);

  /***** allocate memory and read image data1 *****/
  img = Falloc3d(dim.x, dim.y, dim.z);
  out = Falloc3d(dim.x, dim.y, dim.z);
  fp = fopen(argv[1], "r");
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++) fread(img[k][i], sizeof(float), dim.y, fp);
  fclose(fp);
  printf("%s read ok\n", argv[1]);

  maxvalue = -100000.0; minvalue = 100000.0;
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) {

	img[k][i][j] *= 10000.0;
	if (img[k][i][j] < minvalue) minvalue = img[k][i][j];
	if (img[k][i][j] > maxvalue) maxvalue = img[k][i][j];
      }
  printf("(min, max): (%f, %f)\n", minvalue, maxvalue);

  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) {

	if (fabs(img[k][i][j]) < 0.01) out[k][i][j] = -10000.0;
	else out[k][i][j] = -img[k][i][j];
      }

  maxvalue = -100000.0; minvalue = 100000.0;
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) {

	//	img[k][i][j] *= 10000.0;
	if (out[k][i][j] < minvalue) minvalue = out[k][i][j];
	if (out[k][i][j] > maxvalue) maxvalue = out[k][i][j];
      }
  printf("(min, max): (%f, %f)\n", minvalue, maxvalue);

  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) out[k][i][j] /= 10000.0;

  maxvalue = -100000.0; minvalue = 100000.0;
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) {

	//	img[k][i][j] *= 10000.0;
	if (out[k][i][j] < minvalue) minvalue = out[k][i][j];
	if (out[k][i][j] > maxvalue) maxvalue = out[k][i][j];
      }
  printf("(min, max): (%f, %f)\n", minvalue, maxvalue);

  /* saving ... */
  fp = fopen(argv[2],"w");
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++) fwrite(out[k][i], sizeof(float), dim.y, fp);
  fclose(fp);

  /* free */
  Ffree3d(img, dim.z, dim.x);
  Ffree3d(out, dim.z, dim.x);
}



