/**
  * @(#)This lesionRaterCompare.c,	1.0 2001/01/01
  *
  * Copyright (c) 2004, Dengfeng Liu,SBIA .
  * All Rights Reserved.
  * This program is used to compare and display the result of two raters for lesion
  * labelling result
  *
  *<p>
  *    REVISED DATE      BY AUTHOR          REASON        EFFECT
  *   -------------     ------------     -------------   ----------
  *   07/14/04          Zhiqiang Lao     TP redefined    
  *<p>
  *
  *
  *@param   the parameter name and description applied to method
  *@return description of returning value
  *@exception  some exceptions name and description
  *@deprecated declars an item to be obsolete
  * 
  * The author grants you ("Licensee") a non-exclusive, royalty free,license to use,
  * modify and redistribute this software in source and binary code form,
  * provided that i) this copyright notice and license appear on all copies of
  * the software; and ii) Licensee does not utilize the software in a manner
  * which is disparaging to the world.
  *
  * This software is provided "AS IS," without a warranty of any kind. ALL
  * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,INCLUDING ANY
  * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
  * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. THE AUTHOR/LICENSORS SHALL NOT BE
  * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,MODIFYING
  * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL THE AUTHOR/
  * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
  * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES,HOWEVER
  * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
  * OR INABILITY TO USE SOFTWARE, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGES.
  *
  * This software is not designed or intended for use in on-line control of
  * aircraft, air traffic, aircraft navigation or aircraft communications;
  * or in the design, construction, operation or maintenance of any nuclear
  * facility. Licensee represents and warrants that it will not use or
  * redistribute the Software for such purposes.
  */

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<mvcd.h>

/* for calling of gnuplot */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define RATER1COLOR 4
#define RATER2COLOR 6
#define COMMONCOLOR 1

#define PANIC(a) do { \
	perror(a); \
		if (temp_name) unlink(temp_name);\
			exit(EXIT_FAILURE);\
} while(0)

typedef unsigned char uchar;
typedef struct 
{
  float centerX;
  float centerY;
  float centerZ;
  float volume;
  long  voxelTotal;
  long  overlapVoxelCnt;
} LESIONINFO;

int nbrSize = 1;

void labelThisPoint(int k, int i, int j, uchar ***inpImg, uchar ***inpFlag, int label, uchar ***VoxelInStack, Ivector3d *Stack, Ivector3d dim)
{
  int        kk,ii,jj;
  int        k_plus_nbrSize, k_minus_nbrSize, i_plus_nbrSize;
  int        i_minus_nbrSize, j_plus_nbrSize, j_minus_nbrSize;
  long int   Pointer ;

  Pointer = 0 ;
  Stack[Pointer].x = i;  Stack[Pointer].y = j;  Stack[Pointer].z = k;
  
  do{
    i = Stack[Pointer].x;
    j = Stack[Pointer].y;
    k = Stack[Pointer].z;
    Pointer -- ;
    inpFlag[k][i][j] = label;
    k_plus_nbrSize =k+nbrSize;    k_minus_nbrSize=k-nbrSize;
    i_plus_nbrSize =i+nbrSize;    i_minus_nbrSize=i-nbrSize;
    j_plus_nbrSize =j+nbrSize;    j_minus_nbrSize=j-nbrSize;
    
    if (k_plus_nbrSize>=dim.z) k_plus_nbrSize=dim.z-1;
    if (k_minus_nbrSize<0)     k_minus_nbrSize=0;
    if (j_plus_nbrSize>=dim.y) j_plus_nbrSize=dim.y-1;
    if (j_minus_nbrSize<0)     j_minus_nbrSize=0;
    if (i_plus_nbrSize>=dim.x) i_plus_nbrSize=dim.x-1;
    if (i_minus_nbrSize<0)     i_minus_nbrSize=0;

    for(kk=k_minus_nbrSize; kk<=k_plus_nbrSize; kk++){
      for(ii=i_minus_nbrSize; ii<=i_plus_nbrSize; ii++){
	for(jj=j_minus_nbrSize; jj<=j_plus_nbrSize; jj++){
	  if ( !(kk==k && jj==j && ii==i) && 
	       (kk==k&&jj==j || kk==k&&ii==i || jj==j&&ii==i) &&
	       inpImg[kk][ii][jj] != 0 && inpFlag[kk][ii][jj] == 0 && VoxelInStack[kk][ii][jj]==0) {
	    Pointer ++ ;
	    Stack[Pointer].x = ii; 	    Stack[Pointer].y = jj;	    Stack[Pointer].z = kk;
	    VoxelInStack[kk][ii][jj] = 1;
	    //	    inpFlag[kk][ii][jj] = label;
	  }
	}
      }
    }
  } while(Pointer>=0);
}

void tag2raw(char *argv, uchar ***ratorImg, int xs, int ys, int zs, float xs_res, float ys_res, float zs_res)
{
  float x, y, z ;
  int i,j,k,temp;
  char c, name[80] ;
  FILE *fp, *fp_reg;
  
  fp=myopen(argv,"r");
  /* for reading vertices */
  do{
    fscanf(fp, "%s", name) ;
  }while(strcmp(name,"Points"));
  
  do{
    fscanf(fp, "%f", &x) ; i=(int)(x/xs_res) ;
    fscanf(fp, "%f", &y) ; if(y<0) j=(int)(y/(0-ys_res)) ;  else j=(int)(y/ys_res) ;
    fscanf(fp, "%f", &z) ; k=(int)(z/zs_res) ; 
    
    if(i>=0 && i<xs && j>=0 && j<ys && k>=0 && k<zs ) ratorImg[k][j][i] = 255 ;
    
    fscanf(fp, "%d", &temp) ;
    fscanf(fp, "%d", &temp) ;
    fscanf(fp, "%d", &temp) ;
    fp_reg = fp ;
    fscanf(fp_reg, "%c", &c) ;
  }while(c!=';') ;
  fclose(fp);
}

void ReadImg(char filename[80], unsigned char ***vol, Ivector3d dim)
{
   FILE   *fp;
   int    i, j, k;

   fp = fopen(filename, "r");
   for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++) fread(vol[k][i], 1, dim.y, fp);
   fclose(fp);
}

int GetFileLineNumber(char filename[100])
{
  int           i, c;
  char          str[100];
  FILE          *fp;

  fp = fopen(filename, "r");
  i = 0;
  while((c = fgetc(fp)) != EOF) {
    if (c == '\n') i++;
  }
  fclose(fp);

  return i;
}

void InitializationImg(uchar ***img, Ivector3d dim)
{
  int        i, j, k;
 
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) img[k][i][j] = 0;
}

void InitializationStack(Ivector3d *stack, int len)
{
  int        i;

  for (i=0; i<len; i++) stack[i].x = stack[i].y = stack[i].z = 0;
}

void showUsage(char *progname)
{
  printf("This program was used to compare two rater's result about the same subject for accord project \n");
  printf("USAGE:\033[40;31m %s rater1painting_list rater2painting_list result [options] \n\
\t \033[31;32m -d <int>,<int>,<int>         : image dimension (default: 256,256,46)\n\
\t \033[31;34m -r <float>,<float>,<float>      : image resolution (0.9375,0.9375,3.0)\n\
\t \033[31;36m Conments/Questions to: Zhiqiang.Lao@uphs.upenn.edu\n\
",progname);
  exit(EXIT_FAILURE);
}

int main(int argc, char **argv)
{
  int         i,j,k,x,y,z,c,s,xs=256,ys=256,zs=46, outputFlag = 0;
  uchar       ***rator1Img,***rator1Flag, ***rator2Img,***rator2Flag, ***ratorAllImg;
  uchar       ***ratorAllFlag, ***differenceMap, ***VoxelInStack;
  LESIONINFO  *rator1result, *rator2result;
  float       xs_res = 0.9375, ys_res = 0.9375, zs_res = 3.0, totalVolume[2] = {0.0,0.0}, A = 0.0, B = 0.0, AB = 0.0, ratio;
  int         verboseFlag = 0, plotOutputFlag = 0, tagInput = 0, subno;  
  int         rator1LabelCnt, rator2LabelCnt, ratorAllLabelCnt;
  char        *temp_name, filename[256], outFilename[FILENAME_MAX], Fname1[200], Fname2[200], subID[9];
  FILE        *command,*data1Forplot, *fp, *fpLst1, *fpLst2;
  Ivector3d   *Stack, dim;
  Fvector3d   res;
  extern char *optarg;  
  float       TP = 0.0, TN = 0.0, FP = 0.0, FN = 0.0, CT = 0.0, UMINUSCT = 0.0;  
  float       TPVF = 0.0, TNVF = 0.0, FPVF = 0.0, FNVF = 0.0, FPVFR = 0.0;
  
  if(argc<3) showUsage(argv[0]);

  res.x = res.y = 0.9375; res.z = 3.0;
  dim.x = dim.y = 256; dim.z = 46;
  while((c = getopt(argc-3,argv+3,"d:r:"))!=-1) {
    switch(c)
      {
      case 'd':
	sscanf(optarg, "%d,%d,%d", &dim.x, &dim.y, &dim.z);
	break;

      case 'r':
	sscanf(optarg,"%f,%f,%f",&res.x, &res.y, &res.z);
	break;
      }
  }
  printf("image dimension: (%d, %d, %d)\n", dim.x, dim.y, dim.z);
  printf("voxel size: (%f, %f, %f)\n", res.x, res.y, res.z);

  subno = GetFileLineNumber(argv[1]);
  printf("subject number: %d\n", subno);

  fpLst1 = fopen(argv[1], "r");
  fpLst2 = fopen(argv[2], "r");
  rator1Img    = UCalloc3d(dim.x, dim.y, dim.z); 
  rator1Flag   = UCalloc3d(dim.x, dim.y, dim.z); 
  rator2Img    = UCalloc3d(dim.x, dim.y, dim.z); 
  rator2Flag   = UCalloc3d(dim.x, dim.y, dim.z); 
  ratorAllImg  = UCalloc3d(dim.x, dim.y, dim.z); 
  ratorAllFlag = UCalloc3d(dim.x, dim.y, dim.z); 
  VoxelInStack = UCalloc3d(dim.x, dim.y, dim.z); 
  Stack        = Ivector3dalloc1d(dim.x*dim.y*dim.z);

  for (s=0; s<subno; s++) {

    InitializationImg(rator1Img, dim);
    InitializationImg(rator1Flag, dim);
    InitializationImg(rator2Img, dim);
    InitializationImg(rator2Flag, dim);
    InitializationImg(ratorAllImg, dim);
    InitializationImg(ratorAllFlag, dim);
    InitializationImg(VoxelInStack, dim);
    InitializationStack(Stack, dim.x*dim.y*dim.z);
    fscanf(fpLst1, "%s", Fname1);
    fscanf(fpLst2, "%s", Fname2);

    printf("reading (%s,%s)...", Fname1, Fname2);
    ReadImg(Fname1, rator1Img, dim);
    ReadImg(Fname2, rator2Img, dim);
    printf("files read ok...");
    
    for(k=0; k<dim.z; k++) 
      for(i=0; i<dim.x; i++) 
	for(j=0; j<dim.y; j++) 
	  if(rator1Img[k][i][j] != 0 || rator2Img[k][i][j] != 0) ratorAllImg[k][i][j] = 255;

    /* assume the outer pixel is not lesion pixel */
    rator1LabelCnt = rator2LabelCnt = ratorAllLabelCnt = 0;

    for(k=1; k<dim.z-1; k++)
      for(i=1; i<dim.x-1; i++) 
	for(j=1; j<dim.y-1; j++) 
	  if(rator2Img[k][i][j] > 0 && rator2Flag[k][i][j] == 0){
	    rator2LabelCnt++;
	    labelThisPoint(k, i, j, rator2Img, rator2Flag, rator2LabelCnt, VoxelInStack, Stack, dim);
	  }
    printf("there are %d labels in rater 2's result\n",rator2LabelCnt);

    InitializationImg(VoxelInStack, dim);
    for(k=1; k<dim.z-1; k++)
      for(i=1; i<dim.x-1; i++) 
	for(j=1; j<dim.y-1; j++) 
	  if(rator1Img[k][i][j] > 0 && rator1Flag[k][i][j] == 0){
	    rator1LabelCnt++;
	    labelThisPoint(k, i, j, rator1Img, rator1Flag, rator1LabelCnt, VoxelInStack, Stack, dim);
	  }  
    printf("there are %d labels in rater 1's result\n",rator1LabelCnt);

    /* initialize the stack info */
    InitializationImg(VoxelInStack, dim);  
    for(k=1; k<dim.z-1; k++)
      for(i=1; i<dim.x-1; i++ ) 
	for(j=1; j<dim.y-1; j++) 
	  if(ratorAllImg[k][i][j] > 0 && ratorAllFlag[k][i][j] == 0){
	    ratorAllLabelCnt++;
	    labelThisPoint(k, i, j, ratorAllImg, ratorAllFlag, ratorAllLabelCnt, VoxelInStack, Stack, dim);
	  }
    printf("there are %d labels in these two rater's result\n",ratorAllLabelCnt);
  
    for(k=1; k<dim.z-1; k++) 
      for(i=1; i<dim.x-1; i++ ) 
	for(j=1; j<dim.y-1; j++) {
	  if(rator1Img[k][i][j] != 0 && ratorAllFlag[k][i][j] != 0) rator1Flag[k][i][j] = ratorAllFlag[k][i][j];
	  if(rator2Img[k][i][j] != 0 && ratorAllFlag[k][i][j] != 0) rator2Flag[k][i][j] = ratorAllFlag[k][i][j];
	}

    /* calculate overlap percentage for all painting voxels */
    for(k=1; k<dim.z-1; k++) 
      for(i=1; i<dim.x-1; i++) 
	for(j=1; j<dim.y-1; j++) {
	  if(rator1Flag[k][i][j]>0 && rator2Flag[k][i][j]==0){
	    CT += 1.0;
	    FN += 1.0;
	  } else if(rator2Flag[k][i][j] > 0 && rator1Flag[k][i][j] == 0) {
	    UMINUSCT += 1.0;
	    FP += 1.0;
	  } else if(rator1Flag[k][i][j] > 0 && rator2Flag[k][i][j] > 0 && rator2Flag[k][i][j] == rator1Flag[k][i][j] ){
	    CT += 1.0;
	    TP += 1.0;
	  } else{
	    UMINUSCT += 1.0;
	    TN += 1.0;
	  }
	}
    printf("(TP,TN,FP,FN,CT,UMINUSCT) are (%d,%d,%d,%d,%d,%d)...", (int)TP, (int)TN, (int)FP, (int)FN, (int)CT, (int)UMINUSCT);
    printf("%.2f finished\n", (float)s/subno*100);
  }
  fclose(fpLst1);
  fclose(fpLst2);

  printf("(TP, TN, FP, FN, CT, UMINUSCT) are (%f, %f, %f, %f, %f, %f)\n", TP, TN, FP, FN, CT, UMINUSCT);
  printf("TPVF,FPVF,FNVF are %f, %f, %f\n", TP/CT, FP/CT, FN/CT);
  fp = fopen(argv[3], "w");
  fprintf(fp, "%f %f %f\n", TP/CT, FP/CT, FN/CT);
  fclose(fp);

  UCfree3d(rator1Img, dim.z, dim.x);
  UCfree3d(rator1Flag, dim.z, dim.x); 
  UCfree3d(rator2Img, dim.z, dim.x); 
  UCfree3d(rator2Flag, dim.z, dim.x); 
  UCfree3d(ratorAllImg, dim.z, dim.x); 
  UCfree3d(ratorAllFlag, dim.z, dim.x); 
  UCfree3d(VoxelInStack, dim.z, dim.x); 
  free(Stack);

  return 0;
}

