package bl.coe.BigSparseMath;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/**
 * The Class BigDenseVector.
 * 
 * Stores an arrays of arrays in float (single) format. 
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu
 */
public class BigDenseArrayVector {

	/** The data. */
	protected float [][]data;

	/**
	 * Instantiates a new big dense array vector 
	 * 
	 * @param length the number of vectors to store 
	 */
	BigDenseArrayVector(int length) {
		data = new float[length][];		
	}

	/**
	 * Instantiates a new big dense vector.
	 * 
	 * @param vals the data (not copied) to be stored in this object
	 */
	public BigDenseArrayVector(float [][]vals) {
		data = vals;
	}

	/**
	 * Instantiates a new big dense vector.
	 * 
	 * @param vec the BigDesneArrayVector to clone (Data are copied)
	 */
	public BigDenseArrayVector(BigDenseArrayVector vec) {
		data = vec.data.clone();
	}

	
	/**
	 * Count the number of non empty vectors in the array
	 * 
	 * @return the number of non-empty arrays
	 */
	public int countNonEmpty() {
		int cnt=0;
		for(int i=0;i<data.length;i++)
			if(data[i]!=null)
				cnt++;
		return cnt;
	}

	
	/**
	 * Gets the value at a location
	 * 
	 * @param c the index location
	 * 
	 * @return the float[]
	 */
	public float[] get(int c) {
		return data[c];
	}

	
	/**
	 * Gets the length (equals the number of arrays being stored)
	 * 
	 * @return the length
	 */
	public int getLength() {	
		return data.length;
	}

	
	/**
	 * Sets the value at a location
	 * 
	 * @param c the index location
	 * @param v the value to set (data are not copied)
	 */
	public void set(int c, float []v) {
		data[c]=v;
	}

	/**
	 * Gets the data directly (not copied)
	 * 
	 * @return the data in this structure
	 */
	public float[][] getDataDirect() {
		return data;
	}


	/**
	 * Write the structure to a text file.
	 * Entries are written with one array per line uses Java's default floating
	 * point .toString() method. Multiple entries per line are tab delimited. 
	 * Null lines are represented by "-\n".
	 * 
	 * @param string the file name to use for the output file
	 * 
	 * @throws IOException Signals that an I/O exception has occurred.
	 */
	public void writeTextFile(String string) throws IOException {
		BufferedWriter outFp = new BufferedWriter(new FileWriter(new File(string)));
		for(int i=0;i<data.length;i++){
			if(data[i]==null)
				outFp.write("-"+"\n");
			else {
				for(int j=0;j<data[i].length;j++)
					outFp.write(data[i][j]+" ");
				outFp.write("\n");
			}

		}
		outFp.close();
	}

}
