package bl.coe.BigSparseMath;

/**
 * The Class BigMathPreferences.
 * This class stores general preferences for the bl.coe.BigSparseMath package.
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu
 */
public class BigMathPreferences {
	
	/** The Constant WHITE_SPACE_REGEX. 
	 * This expression is used to separate multiple numeric items in a text field.
	 * */
	public static final String WHITE_SPACE_REGEX = "[\\ \t,;:]+";
	
	/** The verbose flag -- if true internal functions should use system.out to print messages. */	
	protected static boolean verbose = true;
	
	/**
	 * Verbose. Turn on console output.
	 */
	public static void verbose() {
		verbose = true;
	}
	
	/**
	 * Quiet.  Turn off console output.
	 */
	public static void quiet() {
		verbose = false;
	}
	
	/** The update rate milliseconds for thread polling. */
	protected static int updateRateMilliseconds = 20000;
	
	/**
	 * Sets the update rate milliseconds for thread polling.
	 * 
	 * @param ms the new update rate milliseconds
	 */
	public static void setUpdateRateMilliseconds(int ms) {updateRateMilliseconds = ms;};

}
