package bl.coe.BigSparseMath;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * The Class BigMatrix.
 * 
 * Provides a generic representation for a matrix. 
 * 
 * @author bennett landman, bennett.landman@vanderbilt.edu
 */ 
public abstract class BigMatrix {
	
	
	/**
	 * Gets the number of rows.
	 * 
	 * @return the n rows
	 */
	abstract public int getNRows() ;

	/**
	 * Gets the number of columns.
	 * 
	 * @return the m cols
	 */
	abstract public int getMCols();

	/**
	 * Gets the value of the matrix at r,c.
	 * 
	 * @param r the row
	 * @param c the col
	 * 
	 * @return the float value at the location
	 */
	abstract public float get(int r, int c);

	/**
	 * Sets the value of the matrix at location r,c.
	 * 
	 * @param r the row
	 * @param c the col
	 * @param v the value
	 */
	abstract public void set(int r, int c, float v);

	/**
	 * Counts the number of non-zero entries in the matrix.
	 * 
	 * @return the non empty count
	 */
	abstract public long getNonEmptyCount() ;

	/**
	 * Gets a vector that corresponds to a row of the matrix. 
	 * 
	 * @param r the r
	 * 
	 * @return the row direct
	 */
	abstract public BigVector getRowDirect(int r);

	 /**
		 * Extract sub matrix by rows. (Does not copy data)
		 * 
		 * @param vec the vector of row indexes
		 * 
		 * @return the big sparse matrix
		 */
	abstract public BigSparseMatrix extractSubMatrixByRows(BigVector vec);
	
	/**
	 * Write to a BSM file
	 * 
	 * @param BSMFile the filename
	 * 
	 * @throws IOException Signals that an I/O exception has occurred.
	 */
	public void write(String BSMFile) throws IOException {
		write(new File(BSMFile));
	}

	/**
	 * Write to a BSM file
	 * 
	 * @param BSMFile the File Object
	 * 
	 * @throws IOException Signals that an I/O exception has occurred.
	 */
	public void write(File BSMFile) throws IOException {
		write(new FileOutputStream(BSMFile));
	}
	
	/**
	 * Write to a BSM file
	 * 
	 * @param BSMFile the output stream
	 * 
	 * @throws IOException Signals that an I/O exception has occurred.
	 */
	abstract public void write(OutputStream BSMFile) throws IOException;
	
	/**
	 * Compute row column counts.
	 * 
	 * @return the int[][]
	 */
	public abstract int[][] computeRowColumnCounts();
}
