package bl.coe.BigSparseMath;


/**
 * The Interface BigVector.
 * 
 * Provides a common mechanism for accessing vectors of floating point
 * data that may be stored in differing schemes. 
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu
 */
public interface BigVector {
		
		/**
		 * Gets the value at index c.
		 * 
		 * @param c the index
		 * 
		 * @return the float
		 */
		 public float get(int c);


		/**
		 * Sets the vector value.
		 * 
		 * @param c the index location
		 * @param v the value
		 */
		 public void set(int c, float v);
		
		/**
		 * Count the number of non empty (i.e., non-zero) values
		 * 
		 * @return the int
		 */
		public int countNonEmpty();
		
		/**
		 * Gets the length of the vector. This is the NUMBER of
		 * elements stored and NOT the maximal index.
		 * 
		 * @return the length
		 */
		public int getLength(); 
		
		
		/**
		 * Gets the last index of the vector. 
		 * 
		 * @return the length
		 */
		public int getLastIndex(); 
		
		
		
}
