package bl.coe;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import bl.coe.BigSparseMath.BigSparseMatrix;
import bl.coe.BigSparseMath.BigSparseMatrixTools;

/**
 * The Class ReportBSMStats.
 * 
 * <p> <b><i>Program Usage:</i> bl.coe.ReportBSMStats <matrix.bsm> [optional: row-column-counts.txt]</b>
 * 
 * <p> Print simple statistics about the matrix in a BSM file. If a second argument is provide, a row-column
 * histogram of the count of non-zero entries is written to a two column text file. THe first column corresponds 
 * to row counts and the second to column counts. 
 *  
 * @see bl.coe.BigSparseMath.BigSparseMatrix
 * @see bl.coe.BigSparseMath.BigSparseMatrixTools
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu 
 */
public class ReportBSMStats {

	/**
	 * The main method.
	 * 
	 * @param args the arguments
	 */
	public static void main(String []args){
		System.out.println("bl.coe.ReportBSMStats <matrix.bsm> [optional: row-column-counts.txt]");
		if(args.length<1)
			return;
		BigSparseMatrix mat =null;
		long tic=System.currentTimeMillis();
		try {
			System.out.println("Loading matrix (this might take a while)...");
			mat= new BigSparseMatrix(args[0]);
		} catch (IOException e) {
			System.out.println("Failed: "+e.getMessage());
			e.printStackTrace();
			return;
		}
		long toc=System.currentTimeMillis()-tic;
		System.out.println("Done");		
		System.out.println(args[0]);

		BigSparseMatrixTools.printStat(mat);
		if(args.length==2) {
			BufferedWriter fp;
			try {
				fp = new BufferedWriter(new FileWriter(new File(args[1])));

				int [][]rc=mat.computeRowColumnCounts();
				for(int i=0;i<Math.max(rc[0].length,rc[1].length);i++) {
					if(i<rc[0].length)
						fp.write(""+rc[0][i]);
					else
						fp.write("0");
					fp.write("\t");
					if(i<rc[1].length)
						fp.write(""+rc[1][i]);
					else
						fp.write("0");
					fp.write("\n");
				}
				fp.close();
			} catch (IOException e) {		
				e.printStackTrace();
			}
		}

		System.out.println("Loaded in:         "+toc/1000.f+" s");


	}
}
