package bl.coe;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import bl.coe.BigSparseMath.BigSparseMatrix;

/**
 * The Class ScanUMDTextMatrix
 *  
 * <p> <b><i>Program Usage:</i> bl.coe.ScanUMDTextMatrix [inFile.txt] [outFile.bsm]</b>
 * 
 * <p> Determine the number of rows and elements in a UMD Text Matrix formatted matrix. 
 * 
 * @see bl.coe.ConvertFullTextMatrixToBSM
 * @see bl.coe.BigSparseMath.BigMathPreferences
 * @see bl.coe.BigSparseMath.BigSparseMatrix
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu.
 */
public class ScanUMDTextMatrix {
	
	/**
	 * The main method.
	 * 
	 * @param args the arguments
	 */
	public static void main(String []args){
		System.out.println("bl.coe.ScanUMDTextMatrix <inFile1.txt> ... <inFileN.txt> ");
		if(args.length<1)
			return;		
			
		
		Vector<Integer> elements = new Vector<Integer>();
		elements.setSize(300000);
		try {
			System.out.println("Loading text matrix (this might take a while)...");			
			long[] progress=null;
			for(int i=0;i<args.length;i++) {
				System.out.println("Importing file: "+args[i]);
				progress=BigSparseMatrix.scanUMDMatrixTextFile(new File(args[i]),elements,progress);
			}
			int zeros = 0;  
			int rows = 0;
			long numelements = 0; 
			int maxrow =0;
			for(int i=0;i<elements.size();i++) {
				Integer num = elements.get(i);
				if(num==null) {
					zeros++;
				} else {
					rows+=1;
					maxrow = i;
					numelements += num;
				}
			}
			System.out.println("Stats: Rows: "+rows+" out of "+(maxrow+1)+"\tElements: "+numelements+" of "+((maxrow+1l)*(maxrow
					+1l)));
			
			
		} catch (IOException e) {
			System.out.println("Failed: "+e.getMessage());
			e.printStackTrace();
		}
		System.out.println("Done");
		
	}
}
