package bl.coe;

import java.io.IOException;
import bl.coe.BigSparseMath.BigSparseMatrix;
import bl.coe.BigSparseMath.BigSparseMatrixTools;

/**
 * The Class SymmeterizeBSM.
 * 
 * <p> <b><i>Program Usage:</i> bl.coe.SymmeterizeBSM [inFile.bsm] [outFile.bsm]</b>
 * 
 * <p> Symmeterize a triangular matrix (either upper or lower). 
 * 
 * @see bl.coe.ConvertFullTextMatrixToBSM
 * @see bl.coe.BigSparseMath.BigMathPreferences
 * @see bl.coe.BigSparseMath.BigSparseMatrix
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu.
 */
public class SymmeterizeBSM {
	
	/**
	 * The main method.
	 * 
	 * @param args the arguments
	 */
	public static void main(String []args){
		System.out.println("bl.coe.SymmeterizeBSM <inFile.bsm> <outFile.bsm>");
		if(args.length<2)
			return;
		BigSparseMatrix inMat =null;
		
		try {
			System.out.println("Loading matrix (this might take a while)...");
			inMat= new BigSparseMatrix(args[0]);
		} catch (IOException e) {
			System.out.println("Failed: "+e.getMessage());
			e.printStackTrace();
			return;
		}
		
		int N=(int)inMat.getNRows();
		int M=(int)inMat.getMCols();
		System.out.println("Matrix Size: "+N+"x"+M);
		if(N!=M) {
			System.out.println("Error. Input matrix is not square.");
			return;
		}
		System.out.println("Symmeterizing Triangular Matrix...");
		long tic=System.currentTimeMillis();
		BigSparseMatrix outMat = BigSparseMatrixTools.symmeterizeTriangularMatrix(inMat); 
		
		long toc=System.currentTimeMillis()-tic;
		System.out.println("Processing time:   "+toc/1000.f+" s");
		
		
		BigSparseMatrixTools.printStat(outMat);
		
		
		
		
		
		tic=System.currentTimeMillis();
		
		try {
			
			System.out.println("Save BSM matrix (this might take a while)...");
			outMat.write(args[1]);
			
		} catch (IOException e) {
			System.out.println("Failed: "+e.getMessage());
			e.printStackTrace();
		}
		toc=System.currentTimeMillis()-tic;
		System.out.println("Saving time:       "+toc/1000.f+" s");
		System.out.println("Done");
		
	}
}
