package bl.coe.BigSparseMath;

/**
 * The Class KNNWorkerThread.
 * 
 * Enables threading of K-Nearest Neighbors
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu
 * @see bl.coe.BigSparseMath.WorkerThread
 * @see bl.coe.BigSparseMath.WorkerThreadWatcher
 * @see bl.coe.BigSparseMath.BigSparseMatrixTools
 */
public class KNNWorkerThread implements Runnable, WorkerThread {

	/** The status. */
	int status;
	
	/** The k. */
	int startRow, endRow, k;
	
	/** The current row. */
	int []currentRow;
	
	/** The mat. */
	LabeledBigSparseMatrix mat;
	
	/** The result. */
	BigDenseArrayVector result;
	
	/** The th. */
	Thread th;
	
	/** The flag to use similiarity weighting **/
	boolean useSimilarityWeighting;
	/**
	 * Instantiates a new kNN worker thread.
	 * 
	 * @param k the k
	 * @param mat the mat
	 * @param result2 the result2
	 * @param startRow the start row
	 * @param endRow the end row
	 * 
	 */
	public KNNWorkerThread(int k, LabeledBigSparseMatrix mat,
			BigDenseArrayVector result2, int startRow, int endRow) {
		this(k,mat,result2,startRow,endRow,false);
	}
	
	/**
	 * Instantiates a new kNN worker thread.
	 * 
	 * @param k the k
	 * @param mat the mat
	 * @param result2 the result2
	 * @param startRow the start row
	 * @param endRow the end row
	 * @param useSimilarityWeighting the flag to trigger similarity weighting
	 */
	public KNNWorkerThread(int k, LabeledBigSparseMatrix mat,
			BigDenseArrayVector result2, int startRow, int endRow, boolean useSimilarityWeighting) {
		
		System.out.println("KNN-Worker w/ SimWt?="+useSimilarityWeighting);
		this.k=k;
		this.mat=mat;
		this.result=result2;
		this.startRow=startRow;
		this.endRow=endRow;		
		this.useSimilarityWeighting = useSimilarityWeighting;
//		System.out.println(startRow+"::"+endRow);
		currentRow = new int[1];currentRow[0]=startRow;
		status = WORKING;
		th = new Thread(this);th.start();
	}

	/* (non-Javadoc)
	 * @see bl.coe.BigSparseMath.WorkerThread#getStatus()
	 */
	@Override
	public int getStatus() {
//		System.out.println("status:"+status);
		return status;
	}

	/* (non-Javadoc)
	 * @see bl.coe.BigSparseMath.WorkerThread#getUnitsDone()
	 */
	@Override
	public long getUnitsDone() { 
		return currentRow[0]-startRow;
	}

	/* (non-Javadoc)
	 * @see bl.coe.BigSparseMath.WorkerThread#getUnitsTotal()
	 */
	@Override
	public long getUnitsTotal() {
		return endRow-startRow;
	}
	

	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	@Override
	public void run() {
//		System.out.println("Started");
		
		try {
			status = WORKING;
			BigSparseMatrixTools.runKNNonLabeledBigSparseMatrixRowsSubsetRows(k, mat, result, startRow, endRow, currentRow,
					useSimilarityWeighting);
		} catch (RuntimeException e) {
			status = FAILED;
			return;
		}
//		System.out.println("Done");;	
		
		status = SUCCESS;

		
	}

}
