package bl.coe.BigSparseMath;

/**
 * The Interface WorkerThread.
 * 
 * Provides a simple mechanism for WorkerThreadWatcher to keep track of running tasks. 
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu
 * @see bl.coe.BigSparseMath.WorkerThreadWatcher
 */
public interface WorkerThread {

	/** The WORKING. */
	public static int WORKING = 0;
	
	/** The FAILED. */
	public static int FAILED = 1;
	
	/** The SUCCESS. */
	public static int SUCCESS = 2;
	
	/**
	 * Gets the status.
	 * 
	 * @return the status
	 */
	int getStatus();
	
	/**
	 * Gets the units total.
	 * 
	 * @return the units total
	 */
	long getUnitsTotal();
	
	/**
	 * Gets the units done.
	 * 
	 * @return the units done
	 */
	long getUnitsDone();

}
