package bl.coe.BigSparseMath;

import java.util.Vector;

/**
 * The Class WorkerThreadWatcher.
 * 
 * Provide a simple control structure for managing parallel tasks. 
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu
 * @see bl.coe.BigSparseMath.WorkerThread
 */
public class WorkerThreadWatcher {

	
	/** The workers. */
	Vector<WorkerThread> workers;
	
	/** The tic. */
	long tic;

	/**
	 * Instantiates a new worker thread watcher.
	 */
	WorkerThreadWatcher() {
		workers = new Vector<WorkerThread>();
		tic=System.currentTimeMillis();
	}
	
	/**
	 * Watch.
	 * 
	 * @param workerThread the worker thread
	 */
	public void watch(WorkerThread workerThread) {
		workers.add(workerThread);		
	}

	/**
	 * Checks if is not done.
	 * 
	 * @return true, if is not done
	 */
	public boolean isNotDone() {		
		for(WorkerThread worker : workers) {			
			if(worker.getStatus()==WorkerThread.WORKING)
				return true;
		}
		return false;
	}

	/**
	 * Report status.
	 */
	public void reportStatus() {
		int working=0, failed=0, success=0, unknown=0;;
		long units_total = 0;
		long units_done = 0;
		for(WorkerThread worker : workers) {
			switch(worker.getStatus()) {
			case WorkerThread.WORKING: working++;break;
			case WorkerThread.FAILED: failed++;break;
			case WorkerThread.SUCCESS: success++;break;
			default: unknown=0; break;
			}
			units_total+=worker.getUnitsTotal();
			units_done+=worker.getUnitsDone();			
		}
		
		double tdiff =(System.currentTimeMillis()-tic)/1000.f;
		double trem = tdiff/(double)units_done*(units_total-units_done);
		int hh = (int)Math.floor(trem/3600.f);
		int mm = (int)Math.floor(trem/60.f-hh*60);
		double ss = (float)Math.floor(trem-hh*3600-mm*60);				


		System.out.println("Workers: "+working+"w/"+success+"+/"+failed+"-/"+unknown+"u of "+(success+failed+working)+"\t"+units_done+"/"+units_total+" ("+
				(100.*(double)units_done/(double)units_total)+"%)\tEst time:"+hh+":"+mm+":"+ss);

	}

}
