package bl.coe;

import java.io.File;
import java.io.IOException;

import bl.coe.BigSparseMath.BigSparseMatrix;

/**
 * The Class ConvertFullTextMatrixToBSM.
 * 
 * <p> <b><i>Program Usage:</i> bl.coe.ConvertFullTextMatrixToBSM Nrows Mcols [inFile.txt] [outFile.bsm]</b>
 * 
 * <p> Convert a text file that represents a full Nrows x Mcols matrix into the BSM (Binary Sparse Matrix)
 * format. The text file has Nrows lines of text. Each row of text has Mcols of numeric entries separated 
 * by one ore more white space or delimiters. See the preferences class (below) for the permitted 
 * delimiting characters. 
 * 
 * <p> The matrix is saved in a big-endian binary format. See the BigSparseMatrix class below.
 * 
 * @see bl.coe.BigSparseMath.BigMathPreferences
 * @see bl.coe.BigSparseMath.BigSparseMatrix
 * 
 * @author Bennett Landman, bennett.landman@vanderbilt.edu
 */
public class ConvertFullTextMatrixToBSM {
	
	/**
	 * The main method.
	 * 
	 * @param args the arguments
	 */
	public static void main(String []args){
		System.out.println("bl.coe.ConvertFullTextMatrixToBSM Nrows Mcols <inFile.txt> <outFile.bsm>");
		if(args.length<4)
			return;
		int N = Integer.valueOf(args[0]);
		int M = Integer.valueOf(args[1]);
		System.out.println("Matrix Size: "+N+"x"+M);
		BigSparseMatrix mat;
		try {
			System.out.println("Loading text matrix (this might take a while)...");
			mat = BigSparseMatrix.parseFullMatrixTextFile(new File(args[2]), N, M);
			System.out.println("Save BSM matrix (this might take a while)...");
			mat.write(args[3]);
			
		} catch (IOException e) {
			System.out.println("Failed: "+e.getMessage());
			e.printStackTrace();
		}
		System.out.println("Done");
		
	}
}
