/* $Id: bxh_datarec.h,v 1.18 2008-03-07 23:05:08 gadde Exp $ */

/* bxh_datarec.h --
 *
 * Functions and structures to describe common BXH datarec fields,
 * and store BXH datarec data.
 *
 * Author: Syam Gadde (gadde@biac.duke.edu), Nov. 2002.
 */

#ifndef __BXH_DATAREC_H
#define __BXH_DATAREC_H

#include <sys/types.h>
#include "bxh_types.h"
#include "bxh_utils.h"

#ifdef __cplusplus
extern "C" {
#endif

/** \ingroup bxh_datarec */
char * bxh_datarec_getfullfilename(const char * basepath, const char * filename);
/** \ingroup bxh_datarec */
bxhrawdatarec * bxh_datarec_createFromElement(const BXHElementPtr elemp, const char * bxhpath);
/** \ingroup bxh_datarec */
bxhrawdatarec * bxh_datarec_postprocess(const bxhrawdatarec * datarec_in);
/** \ingroup bxh_datarec */
int bxh_datarec_prepareForRead(bxhrawdatarec * datarec);
/** \ingroup bxh_datarec */
int bxh_datarec_prepareForReadPermute(bxhrawdatarec * datarec, const char ** inordereddimnames, int numinordereddims);
/** \ingroup bxh_datarec */
int bxh_datarec_prepareForReadPermuteSelect(bxhrawdatarec * datarec, const char ** inordereddimnames, int numinordereddims, int ** inorderedselectors);
/** \ingroup bxh_datarec */
int bxh_datarec_readRawData(bxhrawdatarec * datarec, void * buf, off_t offset, size_t size, int msbfirst);
/** \ingroup bxh_datarec */
bxhrawdatarec * bxh_datarec_readData(bxhrawdatarec * datarec, void ** bufptr, int msbfirst);
/** \ingroup bxh_datarec */
bxhrawdatarec * bxh_datarec_readCanonicalData(bxhrawdatarec * datarec, void * buf, const char ** ordereddimnames, int numordereddims, int msbfirst);
/** \ingroup bxh_datarec */
bxhrawdatarec * bxh_datarec_readXYZTData(bxhrawdatarec * datarec, void * buf, int msbfirst);
/** \ingroup bxh_datarec */
int bxh_datarec_writeToElement(const BXHElementPtr elemp, bxhrawdatarec * datarec);
/** \ingroup bxh_datarec */
bxhrawdatarec * bxh_datarec_copy(const bxhrawdatarec * datarec);
/** \ingroup bxh_datarec */
int bxh_datarec_addfrag(bxhrawdatarec * datarec, const char * filename, size_t fileoffset, size_t fragsize, const char * bxhpath, int expandfilename);
/** \ingroup bxh_datarec */
int bxh_datarec_addcomment(bxhrawdatarec * datarec, const char * comment);
/** \ingroup bxh_datarec */
int bxh_datarec_setcompression(bxhrawdatarec * datarec, const char * compression);
/** \ingroup bxh_datarec */
void bxh_datarec_free(bxhrawdatarec * datarec);
/** \ingroup bxh_datarec */
void bxh_datarec_datapoints_free(bxhdatapoints * dpstructp);
/** \ingroup bxh_datarec */
void bxh_datarec_dimdata_free(bxhdimension * dimp);
/** \ingroup bxh_datarec */
void bxh_datarec_dimensions_free(bxhrawdatarec * datarec);
/** \ingroup bxh_datarec */
void bxh_datarec_fragdata_free(bxhfrag * fragp);
/** \ingroup bxh_datarec */
void bxh_datarec_frags_free(bxhrawdatarec * datarec);
/** \ingroup bxh_datarec */
int * bxh_datarec_constructSelector(const char * instr, size_t min, size_t max, size_t * retsizep);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef __BXH_DATAREC_H */

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.17  2007/02/01 18:11:39  gadde
 * Fix compression support
 *
 * Revision 1.16  2007/02/01 15:39:22  gadde
 * Add compression field
 *
 * Revision 1.15  2006/05/31 14:32:15  gadde
 * Remove unnecessary consts
 *
 * Revision 1.14  2004/11/12 15:05:57  gadde
 * Change to const arg.
 *
 * Revision 1.13  2004/06/15 16:16:11  gadde
 * Several -Wall fixes and addition of bxh_datarec_addfrag()
 *
 * Revision 1.12  2004/06/03 21:47:12  gadde
 * minor fixes
 *
 * Revision 1.11  2004/05/31 16:38:07  gadde
 * Some memory fixes
 *
 * Revision 1.10  2004/04/07 17:20:36  gadde
 * Minor bug fix and add generic selector parsing routine.
 *
 * Revision 1.9  2004/03/19 15:13:31  gadde
 * Major changes in datarec support, include a new 'prepare' stage
 * that initiates filtering, permutation.
 * bxh_datarec_readData has been changed to bxh_datarec_readRawData
 * to reflect this.
 * Added some fMRI QA measures.
 *
 * Revision 1.8  2003/11/13 21:11:33  gadde
 * Make getfullfilename a public function called bxh_datarec_getfullfilename.
 *
 * Revision 1.7  2003/10/22 15:04:50  gadde
 * Minor bug fixes
 *
 * Revision 1.6  2003/08/12 20:42:22  gadde
 * Add functions to deal with split dimensions and arbitrary
 * permutations of data.
 *
 * Revision 1.5  2003/07/08 17:06:30  gadde
 * Move gdome include to bxh_types.h
 *
 * Revision 1.4  2003/05/16 19:58:00  gadde
 * Require basepath for datarec.
 *
 * Revision 1.3  2003/02/14 18:08:40  gadde
 * Updated documentation.
 *
 * Revision 1.2  2003/02/12 19:29:29  gadde
 * Updated doxygen documentation.
 *
 */
