/* $Id: bxh_dom_utils.h,v 1.14 2009-01-15 20:52:42 gadde Exp $ */

/* dom_utils.h --
 *
 * Author: Syam Gadde (gadde@biac.duke.edu)
 * Date: Aug. 2002
 */

#include <gdome.h>
#include <gdome-xpath.h>

#ifdef __cplusplus
extern "C" {
#endif

extern char * domutil_errorbuf;

/** \defgroup bxh_dom_util DOM utility functions
 *  Some easier-to-use utility functions for use with GDOME.
 *  In general, all \c get*Value() functions return -1 on error and a
 *  non-negative value on success.  The values returned by the
 *  \c get*Value() functions are returned by reference in the last argument.*/
/*@{*/
int domutil_initialize();
GdomeComment * domutil_appendComment(GdomeDocument * doc, GdomeElement * parent, const char * valuestr, int prependnewline);
GdomeElement * domutil_appendNewChildWithTextValue(GdomeDocument * doc, GdomeElement * parent, const char * namestr, const char * valuestr, const char * namespaceURI);
int domutil_setAttributeWithTextValue(GdomeDocument * doc, GdomeElement * parent, const char * namestr, const char * valuestr, const char * namespaceURI);
GdomeXPathResult * domutil_getxpresult(GdomeNode * ctxt, const char * exprstr, unsigned short int nodetype);
int domutil_getNodeArray(GdomeNode * ctxt, const char * path, unsigned short int nodetype, GdomeNode *** retp);
int domutil_getChildArray(GdomeElement * parent, const char * name, const char * ns, GdomeNode *** retp);
void domutil_freeNodeArray(GdomeNode *** nap);
int domutil_getSingleNode(GdomeNode * ctxt, const char * path, GdomeNode ** retp);
int domutil_getDoubleValue(GdomeNode * ctxt, const char * path, double * retp);
int domutil_getDoubleListValue(GdomeNode * ctxt, const char * path, double ** retp);
int domutil_getIntValue(GdomeNode * ctxt, const char * path, int * retp);
int domutil_getIntListValue(GdomeNode * ctxt, const char * path, int ** retp);
int domutil_getUnsignedIntValue(GdomeNode * ctxt, const char * path, unsigned int * retp);
int domutil_getUnsignedIntListValue(GdomeNode * ctxt, const char * path, unsigned int ** retp);
int domutil_getLongLongIntListValue(GdomeNode * ctxt, const char * path, long long int ** retp);
int domutil_getStringValue(GdomeNode * ctxt, const char * path, char ** retp);
int domutil_getElementStringValue(GdomeNode * elem, char ** retp);
void domutil_normalizeNamespaces(GdomeElement * start);
void domutil_prettify(GdomeNode * start, int startindent, int indentstep);
void domutil_removeAutogenComments(GdomeNode * start);
/*@}*/

#ifdef __cplusplus
};
#endif

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.13  2005/05/09 20:34:19  gadde
 * Add function to remove AUTOGEN comments.
 *
 * Revision 1.12  2004/06/10 19:56:24  gadde
 * update docs and html
 *
 * Revision 1.11  2004/06/09 14:23:28  gadde
 * libgdome/ now  part of -I paths
 *
 * Revision 1.10  2003/08/01 20:40:28  gadde
 * Some updates to help ease the migration of code between DOM implementations
 *
 * Revision 1.9  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.8  2003/02/12 21:16:05  gadde
 * Updated docs.
 *
 * Revision 1.7  2002/12/04 17:21:51  gadde
 * Adding new module files
 *
 * Revision 1.6  2002/12/03 20:41:04  gadde
 * Big update --
 *  add new datarec module, convert more programs from domutil_ to bxh_,
 *  add new bxh_getElement* functions, and domutil_prettify.
 *
 * Revision 1.5  2002/11/15 20:52:33  gadde
 * Now BXH files have the correct namespace declarations (at the expense
 * of some fragile code in dom_utils.c that breaks the GDOME abstraction
 * layer).
 *
 * Revision 1.4  2002/09/09 19:50:31  gadde
 * Added domutil_appendNewAttributeWithTextValue().
 *
 * Revision 1.3  2002/08/23 16:52:15  gadde
 * Moved some docs to .c file.
 * unsigned short -> unsigned short int (for gtkdoc)
 *
 * Revision 1.2  2002/08/22 15:38:05  gadde
 * Added documentation.
 *
 * Revision 1.1  2002/08/20 15:32:33  gadde
 * Everything moved from libxml to libgdome (DOM).  All utility functions
 * prefixed with domutil_.  XPath support still shaky in gdome, but dom_utils.c
 * accounts for this, and extra code can be removed when gdome fully supports
 * the DOM level 3 XPath specification.
 *
 * Revision 1.1  2002/08/16 19:41:06  gadde
 * Initial import
 *
 */
