<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
  xmlns="http://www.xcede.org/xcede-2"
  xmlns:xcede2="http://www.xcede.org/xcede-2"
  xmlns:bxh="http://www.biac.duke.edu/bxh"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  exclude-result-prefixes="bxh xcede2"
  version="1.0">

  <xsl:output
    method="xml"
    indent="yes"
    omit-xml-declaration="no"
    />

  <xsl:template match="/">
    <XCEDE
      version="2.0"
      xmlns:xcede="http://www.xcede.org/xcede-2"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
      <xsl:for-each select="/bxh:bxh/bxh:subject[*]">
        <xsl:call-template name="convertsubject"/>
      </xsl:for-each>
      <xsl:for-each select="/bxh:bxh/bxh:acquisitiondata[*]">
        <xsl:call-template name="convertacquisitiondata"/>
      </xsl:for-each>
      <xsl:for-each select="/bxh:bxh/bxh:datarec[@type='image']">
        <xsl:call-template name="convertdatarec"/>
      </xsl:for-each>
    </XCEDE>
  </xsl:template>

  <!--
      /XCEDE/subject
    -->
  <xsl:template name="convertsubject">
    <subject ID="ID_SUBJECT">
      <subjectInfo>
        <sex>
          <xsl:choose>
            <xsl:when test="bxh:sex = 'M'">male</xsl:when>
            <xsl:when test="bxh:sex = 'F'">female</xsl:when>
            <xsl:otherwise>other</xsl:otherwise>
          </xsl:choose>
        </sex>
      </subjectInfo>
    </subject>
    <visit ID="ID_VISIT" subjectID="ID_SUBJECT">
    </visit>
    <data xsi:type="assessment_t" ID="ID_AGE" subjectID="ID_SUBJECT" visitID="ID_VISIT">
      <name>age</name>
      <dataInstance>
        <assessmentItem>
          <value>
            <xsl:attribute name="units">years</xsl:attribute>
            <xsl:value-of select="bxh:age"/>
          </value>
        </assessmentItem>
      </dataInstance>
    </data>
  </xsl:template>

  <!--
      /XCEDE/acquisition
       -->
  <xsl:template name="convertacquisitiondata">
    <acquisition ID="ID_ACQUISITION" subjectID="ID_SUBJECT" visitID="ID_VISIT">
      <acquisitionInfo xsi:type="mrAcquisitionInfo_t">
        <xsl:for-each select="bxh:description">
          <description><xsl:value-of select="." /></description>
        </xsl:for-each>
        <scanner>
          <xsl:for-each select="bxh:scannermanufacturer">
            <manufacturer><xsl:value-of select="." /></manufacturer>
          </xsl:for-each>
          <xsl:for-each select="bxh:institution">
            <institutionName><xsl:value-of select="." /></institutionName>
          </xsl:for-each>
          <xsl:for-each select="bxh:institutionaddress">
            <institutionAddress><xsl:value-of select="." /></institutionAddress>
          </xsl:for-each>
          <xsl:for-each select="bxh:scanner">
            <stationName><xsl:value-of select="." /></stationName>
          </xsl:for-each>
          <xsl:for-each select="bxh:institutionaldepartmentname">
            <institutionalDepartmentName><xsl:value-of select="." /></institutionalDepartmentName>
          </xsl:for-each>
          <xsl:for-each select="bxh:scannermodelname">
            <modelName><xsl:value-of select="." /></modelName>
          </xsl:for-each>
          <xsl:for-each select="bxh:scannerserialnumber">
            <serialNumber><xsl:value-of select="." /></serialNumber>
          </xsl:for-each>
          <xsl:for-each select="bxh:softwareversions">
            <softwareVersions><xsl:value-of select="." /></softwareVersions>
          </xsl:for-each>
          <xsl:for-each select="bxh:spatialresolution">
            <spatialResolution><xsl:value-of select="." /></spatialResolution>
          </xsl:for-each>
          <xsl:for-each select="bxh:datelastcalibration">
            <dateLastCalibration><xsl:value-of select="." /></dateLastCalibration>
          </xsl:for-each>
          <xsl:for-each select="bxh:timelastcalibration">
            <timeLastCalibration><xsl:value-of select="." /></timeLastCalibration>
          </xsl:for-each>
          <xsl:for-each select="bxh:pixelpaddingvalue">
            <pixelPaddingValue><xsl:value-of select="." /></pixelPaddingValue>
          </xsl:for-each>
        </scanner>
        <xsl:for-each select="bxh:rows">
          <rows><xsl:value-of select="." /></rows>
        </xsl:for-each>
        <xsl:for-each select="bxh:columns">
          <columns><xsl:value-of select="." /></columns>
        </xsl:for-each>
        <xsl:for-each select="bxh:slicethickness">
          <sliceThickness><xsl:value-of select="." /></sliceThickness>
        </xsl:for-each>
        <xsl:for-each select="bxh:protocolname">
          <protocolName><xsl:value-of select="." /></protocolName>
        </xsl:for-each>
        <xsl:for-each select="bxh:scanningsequence">
          <scanningSequence><xsl:value-of select="." /></scanningSequence>
        </xsl:for-each>
        <xsl:for-each select="bxh:sequencevariant">
          <sequenceVariant><xsl:value-of select="." /></sequenceVariant>
        </xsl:for-each>
        <xsl:for-each select="bxh:scanoptions">
          <scanOptions><xsl:value-of select="." /></scanOptions>
        </xsl:for-each>
        <xsl:for-each select="bxh:mracquisitiontype">
          <acquisitionType><xsl:value-of select="." /></acquisitionType>
        </xsl:for-each>
        <xsl:for-each select="bxh:tr">
          <tr><xsl:value-of select="." /></tr>
        </xsl:for-each>
        <xsl:for-each select="bxh:te">
          <te><xsl:value-of select="." /></te>
        </xsl:for-each>
        <xsl:for-each select="bxh:echotrainlength">
          <echoTrainLength><xsl:value-of select="." /></echoTrainLength>
        </xsl:for-each>
        <xsl:for-each select="bxh:ti">
          <ti><xsl:value-of select="." /></ti>
        </xsl:for-each>
        <xsl:for-each select="bxh:triggertime">
          <triggerTime><xsl:value-of select="." /></triggerTime>
        </xsl:for-each>
        <xsl:for-each select="bxh:sequencename">
          <sequenceName><xsl:value-of select="." /></sequenceName>
        </xsl:for-each>
        <xsl:for-each select="bxh:angioflag">
          <angioFlag><xsl:value-of select="." /></angioFlag>
        </xsl:for-each>
        <xsl:for-each select="bxh:numaverages">
          <numAverages><xsl:value-of select="." /></numAverages>
        </xsl:for-each>
        <xsl:for-each select="bxh:imagingfrequency">
          <frequency><xsl:value-of select="." /></frequency>
        </xsl:for-each>
        <xsl:for-each select="bxh:imagednucleus">
          <imagedNucleus><xsl:value-of select="." /></imagedNucleus>
        </xsl:for-each>
        <xsl:for-each select="bxh:echonumber">
          <echoNum><xsl:value-of select="." /></echoNum>
        </xsl:for-each>
        <xsl:for-each select="bxh:magneticfield">
          <fieldStrength><xsl:value-of select="." /></fieldStrength>
        </xsl:for-each>
        <xsl:for-each select="bxh:numphaseencodingsteps">
          <numPhaseEncodingSteps><xsl:value-of select="." /></numPhaseEncodingSteps>
        </xsl:for-each>
        <xsl:for-each select="bxh:percentsampling">
          <percentSampling><xsl:value-of select="." /></percentSampling>
        </xsl:for-each>
        <xsl:for-each select="bxh:percentphasefieldofview">
          <percentPhaseFOV><xsl:value-of select="." /></percentPhaseFOV>
        </xsl:for-each>
        <xsl:for-each select="bxh:pixelbandwidth">
          <pixelBandwidth><xsl:value-of select="." /></pixelBandwidth>
        </xsl:for-each>
        <xsl:for-each select="bxh:nominalinterval">
          <nominalInterval><xsl:value-of select="." /></nominalInterval>
        </xsl:for-each>
        <xsl:for-each select="bxh:beatrejectionflag">
          <beatRejectionFlag><xsl:value-of select="." /></beatRejectionFlag>
        </xsl:for-each>
        <xsl:for-each select="bxh:lowrrvalue">
          <lowRRValue><xsl:value-of select="." /></lowRRValue>
        </xsl:for-each>
        <xsl:for-each select="bxh:highrrvalue">
          <highRRValue><xsl:value-of select="." /></highRRValue>
        </xsl:for-each>
        <xsl:for-each select="bxh:intervalsacquired">
          <intervalsAcquired><xsl:value-of select="." /></intervalsAcquired>
        </xsl:for-each>
        <xsl:for-each select="bxh:intervalsrejected">
          <intervalsRejected><xsl:value-of select="." /></intervalsRejected>
        </xsl:for-each>
        <xsl:for-each select="bxh:pvcrejection">
          <pvcRejection><xsl:value-of select="." /></pvcRejection>
        </xsl:for-each>
        <xsl:for-each select="bxh:skipbeats">
          <skipBeats><xsl:value-of select="." /></skipBeats>
        </xsl:for-each>
        <xsl:for-each select="bxh:heartrate">
          <heartRate><xsl:value-of select="." /></heartRate>
        </xsl:for-each>
        <xsl:for-each select="bxh:cardiacnumberofimages">
          <cardiacNumImages><xsl:value-of select="." /></cardiacNumImages>
        </xsl:for-each>
        <xsl:for-each select="bxh:triggerwindow">
          <triggerWindow><xsl:value-of select="." /></triggerWindow>
        </xsl:for-each>
        <xsl:for-each select="bxh:reconstructiondiameter">
          <reconstructionDiameter><xsl:value-of select="." /></reconstructionDiameter>
        </xsl:for-each>
        <xsl:for-each select="bxh:receivecoilname">
          <receiveCoilName><xsl:value-of select="." /></receiveCoilName>
        </xsl:for-each>
        <xsl:for-each select="bxh:transmitcoilname">
          <transmitCoilName><xsl:value-of select="." /></transmitCoilName>
        </xsl:for-each>
        <xsl:for-each select="bxh:acquisitionmatrix">
          <acquisitionMatrix><xsl:value-of select="." /></acquisitionMatrix>
        </xsl:for-each>
        <xsl:choose>
          <xsl:when test="bxh:inplanephaseencodingdirection">
            <phaseEncodingDirection><xsl:value-of select="bxh:inplanephaseencodingdirection" /></phaseEncodingDirection>
          </xsl:when>
          <xsl:when test="bxh:frequencydirection = 1">
            <phaseEncodingDirection>COL</phaseEncodingDirection>
          </xsl:when>
          <xsl:when test="bxh:frequencydirection = 2">
            <phaseEncodingDirection>ROW</phaseEncodingDirection>
          </xsl:when>
        </xsl:choose>
        <xsl:for-each select="bxh:flipangle">
          <flipAngle><xsl:value-of select="." /></flipAngle>
        </xsl:for-each>
        <xsl:for-each select="bxh:sar">
          <SAR><xsl:value-of select="." /></SAR>
        </xsl:for-each>
        <xsl:for-each select="bxh:variableflipangleflag">
          <variableFlipAngleFlag><xsl:value-of select="." /></variableFlipAngleFlag>
        </xsl:for-each>
        <xsl:for-each select="bxh:dBdt">
          <dBdt><xsl:value-of select="." /></dBdt>
        </xsl:for-each>
        <xsl:for-each select="bxh:temporalpositionidentifier">
          <temporalPositionIdentifier><xsl:value-of select="." /></temporalPositionIdentifier>
        </xsl:for-each>
        <xsl:for-each select="bxh:numtemporalpositions">
          <numTemporalPositions><xsl:value-of select="." /></numTemporalPositions>
        </xsl:for-each>
        <xsl:for-each select="bxh:temporalresolution">
          <temporalResolution><xsl:value-of select="." /></temporalResolution>
        </xsl:for-each>

        <xsl:for-each select="bxh:acqParam">
          <xsl:element name="param">
            <xsl:for-each select="@name|text()">
              <xsl:copy-of select=".">
              </xsl:copy-of>
            </xsl:for-each>
          </xsl:element>
        </xsl:for-each>

        <xsl:if test="bxh:examnumber">
          <xsl:element name="param">
            <xsl:attribute name="name">examnumber</xsl:attribute>
            <xsl:value-of select="bxh:examnumber"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:studyid">
          <xsl:element name="param">
            <xsl:attribute name="name">studyid</xsl:attribute>
            <xsl:value-of select="bxh:studyid"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:seriesnumber">
          <xsl:element name="param">
            <xsl:attribute name="name">seriesnumber</xsl:attribute>
            <xsl:value-of select="bxh:seriesnumber"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:runnumber">
          <xsl:element name="param">
            <xsl:attribute name="name">runnumber</xsl:attribute>
            <xsl:value-of select="bxh:runnumber"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:scandate">
          <xsl:element name="param">
            <xsl:attribute name="name">scandate</xsl:attribute>
            <xsl:value-of select="bxh:scandate"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:scantime">
          <xsl:element name="param">
            <xsl:attribute name="name">scantime</xsl:attribute>
            <xsl:value-of select="bxh:scantime"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:operator">
          <xsl:element name="param">
            <xsl:attribute name="name">operator</xsl:attribute>
            <xsl:value-of select="bxh:operator"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:prescribedslicespacing">
          <xsl:element name="param">
            <xsl:attribute name="name">prescribedslicespacing</xsl:attribute>
            <xsl:value-of select="bxh:prescribedslicespacing"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:frequencydirection">
          <xsl:element name="param">
            <xsl:attribute name="name">frequencydirection</xsl:attribute>
            <xsl:value-of select="bxh:frequencydirection"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:examdescription">
          <xsl:element name="param">
            <xsl:attribute name="name">examdescription</xsl:attribute>
            <xsl:value-of select="bxh:examdescription"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:fieldofview">
          <xsl:element name="param">
            <xsl:attribute name="name">fieldofview</xsl:attribute>
            <xsl:value-of select="bxh:fieldofview"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:psdname">
          <xsl:element name="param">
            <xsl:attribute name="name">psdname</xsl:attribute>
            <xsl:value-of select="bxh:psdname"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:psdinternalname">
          <xsl:element name="param">
            <xsl:attribute name="name">psdinternalname</xsl:attribute>
            <xsl:value-of select="bxh:psdinternalname"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:psddate">
          <xsl:element name="param">
            <xsl:attribute name="name">psddate</xsl:attribute>
            <xsl:value-of select="bxh:psddate"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:psdtime">
          <xsl:element name="param">
            <xsl:attribute name="name">psdtime</xsl:attribute>
            <xsl:value-of select="bxh:psdtime"/>
          </xsl:element>
        </xsl:if>

        <xsl:if test="bxh:bandwidth">
          <xsl:element name="param">
            <xsl:attribute name="name">bandwidth</xsl:attribute>
            <xsl:value-of select="bxh:bandwidth" />
          </xsl:element>
        </xsl:if>

        <xsl:for-each select="bxh:*">
          <xsl:if test="local-name() != 'acqParam' and local-name() != 'acquisitionmatrix' and local-name() != 'angioflag' and local-name() != 'pixelbandwidth' and local-name() != 'bandwidth' and local-name() != 'beatrejectionflag' and local-name() != 'byteorder' and local-name() != 'cardiacnumberofimages' and local-name() != 'columns' and local-name() != 'compression' and local-name() != 'datapoints' and local-name() != 'datelastcalibration' and local-name() != 'dBdt' and local-name() != 'description' and local-name() != 'direction' and local-name() != 'echonumber' and local-name() != 'echotrainlength' and local-name() != 'examdescription' and local-name() != 'examnumber' and local-name() != 'fieldofview' and local-name() != 'flipangle' and local-name() != 'frequencydirection' and local-name() != 'gap' and local-name() != 'heartrate' and local-name() != 'highrrvalue' and local-name() != 'imagednucleus' and local-name() != 'imagingfrequency' and local-name() != 'inplanephaseencodingdirection' and local-name() != 'institution' and local-name() != 'institutionaddress' and local-name() != 'institutionaldepartmentname' and local-name() != 'intervalsacquired' and local-name() != 'intervalsrejected' and local-name() != 'lowrrvalue' and local-name() != 'magneticfield' and local-name() != 'mracquisitiontype' and local-name() != 'nominalinterval' and local-name() != 'numaverages' and local-name() != 'numphaseencodingsteps' and local-name() != 'numtemporalpositions' and local-name() != 'operator' and local-name() != 'origin' and local-name() != 'percentphasefieldofview' and local-name() != 'percentsampling' and local-name() != 'pixelpaddingvalue' and local-name() != 'prescribedslicespacing' and local-name() != 'protocolname' and local-name() != 'psddate' and local-name() != 'psdinternalname' and local-name() != 'psdname' and local-name() != 'psdtime' and local-name() != 'pvcrejection' and local-name() != 'receivecoilname' and local-name() != 'reconstructiondiameter' and local-name() != 'rows' and local-name() != 'runnumber' and local-name() != 'sar' and local-name() != 'scandate' and local-name() != 'scanner' and local-name() != 'scannermanufacturer' and local-name() != 'scannermodelname' and local-name() != 'scannerserialnumber' and local-name() != 'scanningsequence' and local-name() != 'scanoptions' and local-name() != 'scantime' and local-name() != 'sequencename' and local-name() != 'sequencevariant' and local-name() != 'seriesnumber' and local-name() != 'size' and local-name() != 'skipbeats' and local-name() != 'slicethickness' and local-name() != 'softwareversions' and local-name() != 'spacing' and local-name() != 'spatialresolution' and local-name() != 'studyid' and local-name() != 'te' and local-name() != 'temporalpositionidentifier' and local-name() != 'temporalresolution' and local-name() != 'ti' and local-name() != 'timelastcalibration' and local-name() != 'tr' and local-name() != 'transmitcoilname' and local-name() != 'triggertime' and local-name() != 'triggerwindow' and local-name() != 'units' and local-name() != 'variableflipangleflag'">
            <xsl:element name="param">
              <xsl:attribute name="name"><xsl:value-of select="local-name()" /></xsl:attribute>
              <xsl:value-of select="string(.)"/>
            </xsl:element>
          </xsl:if>
        </xsl:for-each>

      </acquisitionInfo>

      <xsl:if test="/bxh:bxh/bxh:datarec[@type='image']">
        <dataResourceRef ID="ID_DATARESOURCE" />
      </xsl:if>
    </acquisition>
  </xsl:template>

  <!--
      /XCEDE/resource
    -->
  <xsl:template name="convertdatarec">
    <resource xsi:type="mappedBinaryDataResource_t" ID="ID_DATARESOURCE">
      <!-- If filenameprintfdimensions exists, the output will be invalid -->
      <xsl:if test="bxh:filenameprintfdimensions or bxh:filenameprintforigins">
        <xsl:message terminate="yes">filenameprintfdimensions and filenameprintforigins are not supported!</xsl:message>
      </xsl:if>

      <!-- resource_t -->
      <xsl:variable name="fileoffsetcount" select="count(bxh:fileoffset)"/>
      <xsl:variable name="filerecordsizecount" select="count(bxh:filerecordsize)"/>
      <xsl:variable name="theoffset" select="bxh:fileoffset[1]"/>
      <xsl:variable name="therecordsize" select="bxh:filerecordsize[1]"/>
      <xsl:for-each select="bxh:filename">
	<xsl:variable name="filenum" select="position()"/>
        <xsl:element name="uri">
          <xsl:choose>
            <xsl:when test="$fileoffsetcount = 0">
              <!-- null -->
            </xsl:when>
            <xsl:when test="$fileoffsetcount = 1">
              <xsl:attribute name="offset">
                <xsl:value-of select="$theoffset"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <!-- grab fileoffset with same rank as current filename -->
              <xsl:attribute name="offset">
                <xsl:value-of select="../bxh:fileoffset[$filenum]"/>
              </xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="$filerecordsizecount = 0">
              <!-- null -->
            </xsl:when>
            <xsl:when test="$filerecordsizecount = 1">
              <xsl:attribute name="size">
                <xsl:value-of select="$therecordsize"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <!-- grab filerecordsize with same rank as current filename -->
              <xsl:attribute name="size">
                <xsl:value-of select="../bxh:filerecordsize[$filenum]"/>
              </xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="."/>
        </xsl:element>
      </xsl:for-each>

      <xsl:for-each select="//bxh:history">
        <provenance>
          <xsl:for-each select="bxh:entry">
            <xsl:choose>
              <xsl:when test="bxh:description/xcede2:processStep">
                <xsl:copy-of select="bxh:description/xcede2:processStep" />
              </xsl:when>
              <xsl:when test="bxh:description/bxh:processStep">
                <xsl:for-each select="bxh:description/bxh:processStep">
                  <processStep>
                    <program><xsl:value-of select="bxh:programName"/></program>
                    <programArguments><xsl:value-of select="bxh:programArgument"/></programArguments>
                    <timeStamp><xsl:value-of select="bxh:timeStamp"/></timeStamp>
                    <user><xsl:value-of select="bxh:user"/></user>
                    <architecture><xsl:value-of select="bxh:machine"/></architecture>
                    <platform>
                      <xsl:attribute name="version">
                        <xsl:value-of select="bxh:platormVersion"/>
                      </xsl:attribute>
                      <xsl:value-of select="bxh:platform"/>
                    </platform>
                    <cvs><xsl:value-of select="bxh:cvs"/></cvs>
                    <package>
                      <xsl:attribute name="version">
                        <xsl:value-of select="bxh:version"/>
                      </xsl:attribute>
                      <xsl:value-of select="bxh:programName"/>
                    </package>
                  </processStep>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <processStep>
                  <xsl:variable name="description" select="string(bxh:description)"/>
                  <xsl:variable name="machine" select="substring-after(substring-before($description, ' by '), 'Generated on ')"/>
                  <xsl:variable name="programName" select="substring-after(substring-before($description, ' from'), 'by ')"/>
                  <xsl:variable name="version" select="substring-after($description, '-VERSIONSTR-')"/>
                  <xsl:variable name="timeStamp" select="string(bxh:date)"/>
                  <xsl:variable name="cvs" select="$version"/>
                  <xsl:variable name="inputFile" select="substring-before(substring-after($description, ' from '), '.')"/>
                  <program><xsl:value-of select="$programName"/></program>
                  <programArguments><xsl:value-of select="$inputFile"/></programArguments>
<!--                  <timeStamp><xsl:value-of select="$timeStamp"/></timeStamp> -->
                  <user></user>
                  <hostName><xsl:value-of select="$machine"/></hostName>
                  <platform></platform>
                  <cvs><xsl:value-of select="$cvs"/></cvs>
                  <package>
                    <xsl:attribute name="version">
                      <xsl:value-of select="$version"/>
                    </xsl:attribute>
                  </package>
                </processStep>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </provenance>
      </xsl:for-each>

      <!-- binaryDataResource_t -->
      <xsl:if test="bxh:elementtype">
        <elementType><xsl:value-of select="bxh:elementtype"/></elementType>
      </xsl:if>
      <xsl:if test="bxh:byteorder">
        <byteOrder><xsl:value-of select="bxh:byteorder"/></byteOrder>
      </xsl:if>
      <xsl:if test="bxh:compression">
        <compression><xsl:value-of select="bxh:compression"/></compression>
      </xsl:if>

      <!-- dimensionedBinaryDataResource_t -->
      <!-- mappedBinaryDataResource_t -->
      <xsl:for-each select="bxh:dimension">
        <dimension>
          <xsl:if test="@type">
            <xsl:variable name="label">
              <xsl:choose>
                <xsl:when test="contains(@type, '-split')">
                  <xsl:value-of select="substring-before(@type, '-split')" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="@type" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <xsl:attribute name="label">
              <xsl:value-of select="$label"/>
            </xsl:attribute>
            <xsl:if test="contains(@type, '-split')">
              <xsl:attribute name="splitRank">
                <xsl:value-of select="substring-after(@type, '-split')" />
              </xsl:attribute>
            </xsl:if>
          </xsl:if>
          <xsl:if test="@outputselect">
            <xsl:attribute name="outputSelect">
              <xsl:value-of select="@outputselect"/>
            </xsl:attribute>
          </xsl:if>
	  <xsl:if test="bxh:size">
            <size><xsl:value-of select="bxh:size"/></size>
	  </xsl:if>
	  <xsl:if test="bxh:origin">
            <origin><xsl:value-of select="bxh:origin"/></origin>
	  </xsl:if>
	  <xsl:if test="bxh:spacing">
            <spacing><xsl:value-of select="bxh:spacing"/></spacing>
	  </xsl:if>
	  <xsl:if test="bxh:gap">
            <gap><xsl:value-of select="bxh:gap"/></gap>
	  </xsl:if>
          <xsl:for-each select="bxh:datapoints">
            <xsl:choose>
              <xsl:when test="bxh:value">
                <datapoints>
		  <xsl:if test="@label">
		    <xsl:attribute name="label">
		      <xsl:value-of select="@label" />
		    </xsl:attribute>
		  </xsl:if>
                  <xsl:for-each select="bxh:value">
                    <value><xsl:value-of select="."/></value>
                  </xsl:for-each>
                </datapoints>
              </xsl:when>
              <xsl:otherwise>
                <datapoints>
		  <xsl:if test="@label">
		    <xsl:attribute name="label">
		      <xsl:value-of select="@label" />
		    </xsl:attribute>
		  </xsl:if>
		  <xsl:value-of select="."/>
		</datapoints>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
	  <xsl:if test="bxh:direction">
            <direction><xsl:value-of select="bxh:direction"/></direction>
	  </xsl:if>
	  <xsl:if test="bxh:units">
            <units><xsl:value-of select="bxh:units"/></units>
	  </xsl:if>
          <xsl:for-each select="bxh:measurementframe">
            <measurementFrame>
              <xsl:for-each select="bxh:vector">
                <vector><xsl:value-of select="."/></vector>
              </xsl:for-each>
            </measurementFrame>
          </xsl:for-each>
        </dimension>
      </xsl:for-each>

      <xsl:choose>
        <xsl:when test="bxh:rasorigin">
          <xsl:element name="originCoords">
            <xsl:value-of select="bxh:rasorigin"/>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <!-- The following code converts/permutes the RAS origin, which
               is distributed among the X,Y,Z axes (in BXH files without
               the rasorigin field) to a single RAS origin field outside
               the dimension elements in the XCEDE XML file.
               The code below is a testament to how complicated the
               original design was to work with
               (putting each coordinate of the RAS origin in the X, Y, or Z
               dimension with which its axis was most aligned).
               The new way should be much simpler.
               -->
          <xsl:choose>
            <xsl:when test="bxh:dimension/bxh:origin and bxh:dimension/bxh:direction">
              <xsl:variable name="dirx" select="normalize-space(string(bxh:dimension[@type='x']/bxh:direction))"/>
              <xsl:variable name="diry" select="normalize-space(string(bxh:dimension[@type='y']/bxh:direction))"/>
              <xsl:variable name="dirz" select="normalize-space(string(bxh:dimension[@type='z' or @type='z-split2']/bxh:direction))"/>
              <xsl:variable name="origx" select="normalize-space(string(bxh:dimension[@type='x']/bxh:origin))"/>
              <xsl:variable name="origy" select="normalize-space(string(bxh:dimension[@type='y']/bxh:origin))"/>
              <xsl:variable name="origz" select="normalize-space(string(bxh:dimension[@type='z' or @type='z-split2']/bxh:origin))"/>
              <xsl:variable name="xR" select="number(substring-before($dirx, ' '))"/>
              <xsl:variable name="yR" select="number(substring-before($diry, ' '))"/>
              <xsl:variable name="zR" select="number(substring-before($dirz, ' '))"/>
              <xsl:variable name="xA" select="number(substring-before(substring-after($dirx,' '), ' '))"/>
              <xsl:variable name="yA" select="number(substring-before(substring-after($diry,' '), ' '))"/>
              <xsl:variable name="zA" select="number(substring-before(substring-after($dirz,' '), ' '))"/>
              <xsl:variable name="xS" select="number(substring-after(normalize-space(substring-after($dirx,' ')),' '))"/>
              <xsl:variable name="yS" select="number(substring-after(normalize-space(substring-after($diry,' ')),' '))"/>
              <xsl:variable name="zS" select="number(substring-after(normalize-space(substring-after($dirz,' ')),' '))"/>
              <xsl:variable name="absxR" select="substring('-1', 2-($xR&lt;0))*$xR"/>
              <xsl:variable name="absyR" select="substring('-1', 2-($yR&lt;0))*$yR"/>
              <xsl:variable name="abszR" select="substring('-1', 2-($zR&lt;0))*$zR"/>
              <xsl:variable name="absxA" select="substring('-1', 2-($xA&lt;0))*$xA"/>
              <xsl:variable name="absyA" select="substring('-1', 2-($yA&lt;0))*$yA"/>
              <xsl:variable name="abszA" select="substring('-1', 2-($zA&lt;0))*$zA"/>
              <xsl:variable name="absxS" select="substring('-1', 2-($xS&lt;0))*$xS"/>
              <xsl:variable name="absyS" select="substring('-1', 2-($yS&lt;0))*$yS"/>
              <xsl:variable name="abszS" select="substring('-1', 2-($zS&lt;0))*$zS"/>
              <originCoords>
                <xsl:choose>
                  <xsl:when test="$absxR > $absyR and $absxR > $abszR">
                    <xsl:value-of select="$origx"/>
                  </xsl:when>
                  <xsl:when test="$absyR > $absxR and $absyR > $abszR">
                    <xsl:value-of select="$origy"/>
                  </xsl:when>
                  <xsl:when test="$abszR > $absxR and $abszR > $absyR">
                    <xsl:value-of select="$origz"/>
                  </xsl:when>
                </xsl:choose>
                <xsl:text> </xsl:text>
                <xsl:choose>
                  <xsl:when test="$absxA > $absyA and $absxA > $abszA">
                    <xsl:value-of select="$origx"/>
                  </xsl:when>
                  <xsl:when test="$absyA > $absxA and $absyA > $abszA">
                    <xsl:value-of select="$origy"/>
                  </xsl:when>
                  <xsl:when test="$abszA > $absxA and $abszA > $absyA">
                    <xsl:value-of select="$origz"/>
                  </xsl:when>
                </xsl:choose>
                <xsl:text> </xsl:text>
                <xsl:choose>
                  <xsl:when test="$absxS > $absyS and $absxS > $abszS">
                    <xsl:value-of select="$origx"/>
                  </xsl:when>
                  <xsl:when test="$absyS > $absxS and $absyS > $abszS">
                    <xsl:value-of select="$origy"/>
                  </xsl:when>
                  <xsl:when test="$abszS > $absxS and $abszS > $absyS">
                    <xsl:value-of select="$origz"/>
                  </xsl:when>
                </xsl:choose>
                <xsl:text> </xsl:text>
              </originCoords>
            </xsl:when>
            <xsl:otherwise>
              <originCoords>0 0 0</originCoords>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </resource>
  </xsl:template>

</xsl:stylesheet>

<!--
  $Log: In-line log eliminated on transition to SVN; use svn log instead. $
  Revision 1.1  2008/03/07 18:21:59  gadde
  Add preliminary XCEDE 2 support

  Revision 1.11  2007/08/02 17:51:45  gadde
  Add several missing fields to the acqparam translation.

  Revision 1.10  2007/02/27 18:04:30  gadde
  Add more acquisition data parameters.

  Revision 1.9  2007/02/21 21:49:15  gadde
  Make sure all acquisitiondata and acqParam elements are translated BXH->XCEDE and vice-versa

  Revision 1.8  2007/02/01 15:39:21  gadde
  Add compression field

  Revision 1.7  2006/04/03 17:29:09  gadde
  Fix filerecordsize translation.

  Revision 1.6  2006/02/09 21:40:22  gadde
  Use bxh rasorigin field if it exists.

  Revision 1.5  2006/01/03 17:14:54  gadde
  Add CVS Log.

  -->
