<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
  xmlns="http://www.biac.duke.edu/bxh"
  xmlns:bxh="http://www.biac.duke.edu/bxh"
  xmlns:xcede2="http://www.xcede.org/xcede-2"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exslt="http://exslt.org/common"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  exclude-result-prefixes="xcede2"
  version="1.0">

  <!-- This style sheet converts XCEDE 2 acquisition/data resource XML files to a BIAC XML Header -->

  <xsl:output
    method="xml"
    indent="yes"
    omit-xml-declaration="no"
    />

  <xsl:template name="convertNSattributes">
    <xsl:choose>
      <xsl:when test="namespace-uri()='http://www.xcede.org/xcede-2'">
        <xsl:attribute name="{local-name()}" namespace="http://www.biac.duke.edu/bxh">
	  <xsl:copy/>
        </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="{local-name()}">
          <xsl:copy/>
        </xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="convertNSaux">
    <xsl:choose>
      <!-- element -->
      <xsl:when test="self::*">
        <xsl:call-template name="convertNS"/>
      </xsl:when>
      <!-- attribute -->
      <xsl:when test="count(.|../@*)=count(../@*)">
        <xsl:call-template name="convertNSattributes"/>
      </xsl:when>
      <!-- everything else -->
      <xsl:otherwise>
        <xsl:copy/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="convertNS">
    <xsl:choose>
      <xsl:when test="namespace-uri()='http://www.xcede.org/xcede-2'">
        <xsl:element name="{local-name()}" namespace="http://www.biac.duke.edu/bxh">
          <xsl:for-each select="@*|*|text()">
            <xsl:call-template name="convertNSaux"/>
          </xsl:for-each>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:for-each select="@*|*|text()">
            <xsl:call-template name="convertNSaux"/>
          </xsl:for-each>
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- return the composite ID for an XCEDE 2 hierarchy element (context).
       Populate component IDs but stop at level "stopLevel". -->
  <xsl:template name="getCompositeID">
    <xsl:param name="stopLevel" />
    <xsl:variable name="projectID">
      <xsl:choose>
        <xsl:when test="local-name() = 'project'">
          <xsl:value-of select="@ID" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@projectID" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="subjectID">
      <xsl:choose>
        <xsl:when test="local-name() = 'subject'">
          <xsl:value-of select="@ID" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@subjectID" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="visitID">
      <xsl:choose>
        <xsl:when test="local-name() = 'visit'">
          <xsl:value-of select="@ID" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@visitID" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="studyID">
      <xsl:choose>
        <xsl:when test="local-name() = 'study'">
          <xsl:value-of select="@ID" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@studyID" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="episodeID">
      <xsl:choose>
        <xsl:when test="local-name() = 'episode'">
          <xsl:value-of select="@ID" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@episodeID" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="acquisitionID">
      <xsl:choose>
        <xsl:when test="local-name() = 'acquisition'">
          <xsl:value-of select="@ID" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@acquisitionID" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$stopLevel = 'project'">
        <xsl:value-of select="concat($projectID,':::::')" />
      </xsl:when>
      <xsl:when test="$stopLevel = 'subject'">
        <xsl:value-of select="concat(':',$subjectID,'::::')" />
      </xsl:when>
      <xsl:when test="$stopLevel = 'visit'">
        <xsl:value-of select="concat($projectID,':',$subjectID,':',$visitID,':::')" />
      </xsl:when>
      <xsl:when test="$stopLevel = 'study'">
        <xsl:value-of select="concat($projectID,':',$subjectID,':',$visitID,':',$studyID,'::')" />
      </xsl:when>
      <xsl:when test="$stopLevel = 'episode'">
        <xsl:value-of select="concat($projectID,':',$subjectID,':',$visitID,':',$studyID,':',$episodeID,':')" />
      </xsl:when>
      <xsl:when test="$stopLevel = 'acquisition'">
        <xsl:value-of select="concat($projectID,':',$subjectID,':',$visitID,':',$studyID,':',$episodeID,':',$acquisitionID)" />
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- find elements of type "type" that match the IDs in the
       context element, stopping at level "stopLevel"  -->
  <xsl:template name="findElementsWithMatchingIDs">
    <xsl:param name="type" />
    <xsl:param name="stopLevel" />
    <xsl:variable name="levelNodes">
      <xsl:choose>
        <xsl:when test="$type = 'project'">
          <xsl:copy-of select="/xcede2:XCEDE/xcede2:project" />
        </xsl:when>
        <xsl:when test="$type = 'subject'">
          <xsl:copy-of select="/xcede2:XCEDE/xcede2:subject" />
        </xsl:when>
        <xsl:when test="$type = 'visit'">
          <xsl:copy-of select="/xcede2:XCEDE/xcede2:visit" />
        </xsl:when>
        <xsl:when test="$type = 'study'">
          <xsl:copy-of select="/xcede2:XCEDE/xcede2:study" />
        </xsl:when>
        <xsl:when test="$type = 'episode'">
          <xsl:copy-of select="/xcede2:XCEDE/xcede2:episode" />
        </xsl:when>
        <xsl:when test="$type = 'acquisition'">
          <xsl:copy-of select="/xcede2:XCEDE/xcede2:acquisition" />
        </xsl:when>
        <xsl:when test="$type = 'data'">
          <xsl:copy-of select="/xcede2:XCEDE/xcede2:data" />
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="contextCompositeID">
      <xsl:call-template name="getCompositeID">
        <xsl:with-param name="stopLevel" select="$stopLevel" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:for-each select="exslt:node-set($levelNodes)/*">
      <xsl:variable name="searchCompositeID">
        <xsl:call-template name="getCompositeID" />
      </xsl:variable>
      <xsl:if test="$contextCompositeID = $searchCompositeID">
        <xsl:copy-of select="." />
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="/">
    <bxh>
      <xsl:attribute name="version">1.0</xsl:attribute>
      <xsl:for-each select="xcede2:XCEDE">
        <xsl:for-each select="xcede2:resource">
          <xsl:variable name="resourceID" select="@ID" />
          <xsl:call-template name="dodatarec"/>
          <xsl:for-each select="/xcede2:XCEDE/xcede2:acquisition[xcede2:dataResourceRef[@ID=$resourceID]]">
            <xsl:call-template name="doacquisitiondata"/>
            <xsl:variable name="subjectNode">
              <xsl:call-template name="findElementsWithMatchingIDs">
                <xsl:with-param name="type" select="'subject'" />
                <xsl:with-param name="stopLevel" select="'subject'" />
              </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="dataNodes">
              <xsl:call-template name="findElementsWithMatchingIDs">
                <xsl:with-param name="type" select="'data'" />
                <xsl:with-param name="stoplevel" select="'visit'" />
              </xsl:call-template>
            </xsl:variable>
            <xsl:call-template name="dosubject" select="exslt:node-set($subjectNodes)[1]">
              <xsl:with-param name="assessmentNodes" select="exslt:node-set($dataNodes)/*[@xsi:type='assessment_t']" />
            </xsl:call-template>
          </xsl:for-each>
        </xsl:for-each>
      </xsl:for-each>
    </bxh>
  </xsl:template>

  <!--
       /bxh/datarec
    -->
  <xsl:template name="dodatarec">
    <xsl:call-template name="createdatarec"/>
  </xsl:template>

  <xsl:template name="createdatarec">
    <datarec>
      <xsl:attribute name="type">
        <xsl:value-of select="'image'"/>
      </xsl:attribute>
      <xsl:if test="xcede2:originCoords">
        <xsl:element name="rasorigin">
          <xsl:value-of select="xcede2:originCoords"/>
        </xsl:element>
      </xsl:if>

      <xsl:for-each select="xcede2:dimension">
        <dimension>
          <xsl:attribute name="type">
            <xsl:choose>
              <xsl:when test="@splitRank">
                <xsl:value-of select="@label"/>
                <xsl:value-of select="'-'"/>
                <xsl:value-of select="@splitRank"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="@label"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:if test="@outputSelect">
            <xsl:attribute name="outputselect">
              <xsl:value-of select="@outputSelect"/>
            </xsl:attribute>
          </xsl:if>
	  <xsl:if test="xcede2:size">
            <size><xsl:value-of select="xcede2:size"/></size>
	  </xsl:if>
	  <xsl:if test="xcede2:origin">
            <origin><xsl:value-of select="xcede2:origin"/></origin>
	  </xsl:if>
	  <xsl:if test="xcede2:spacing">
            <spacing><xsl:value-of select="xcede2:spacing"/></spacing>
	  </xsl:if>
	  <xsl:if test="xcede2:gap">
            <gap><xsl:value-of select="xcede2:gap"/></gap>
	  </xsl:if>
	  <xsl:for-each select="xcede2:datapoints">
	    <xsl:call-template name="convertNS" select="xcede:datapoints"/>
	  </xsl:for-each>
	  <xsl:if test="xcede2:direction">
            <direction><xsl:value-of select="xcede2:direction"/></direction>
	  </xsl:if>
	  <xsl:if test="xcede2:units">
            <units><xsl:value-of select="xcede2:units"/></units>
	  </xsl:if>
	  <xsl:if test="xcede2:measurementFrame">
            <measurementframe><xsl:value-of select="xcede2:measurementFrame"/></measurementframe>
	  </xsl:if>
        </dimension>
      </xsl:for-each>
      <xsl:if test="xcede2:compression">
        <compression><xsl:value-of select="xcede2:compression"/></compression>
      </xsl:if>
      <xsl:if test="xcede2:byteOrder">
        <byteorder><xsl:value-of select="xcede2:byteOrder"/></byteorder>
      </xsl:if>
      <elementtype><xsl:value-of select="xcede2:elementType"/></elementtype>
      <xsl:for-each select="xcede2:uri">
        <filename><xsl:value-of select="."/></filename>
        <xsl:if test="@offset">
          <fileoffset>
            <xsl:value-of select="@offset"/>
          </fileoffset>
        </xsl:if>
        <xsl:if test="size">
          <filerecordsize>
            <xsl:value-of select="@size"/>
          </filerecordsize>
        </xsl:if>
      </xsl:for-each>
    </datarec>
  </xsl:template>

  <!--
      /bxh/subject
    -->
  <xsl:template name="dosubject">
    <xsl:param name="assessmentNodes" />
    <subject>
      <xsl:for-each select="$assessmentNodes[xcede2:name='age']">
        <age>
          <xsl:value-of select="xcede2:dataInstance/xcede2:assessmentItem/xcede2:value"/>
        </age>
      </xsl:for-each>
      <xsl:for-each select="xcede2:subjectInfo">
        <sex>
          <xsl:choose>
            <xsl:when test="xcede2:sex = 'male'">M</xsl:when>
            <xsl:when test="xcede2:sex = 'female'">F</xsl:when>
            <xsl:otherwise>O</xsl:otherwise>
          </xsl:choose>
        </sex>
      </xsl:for-each>
    </subject>
  </xsl:template>

  <!--
      /bxh/acquisitiondata
    -->
  <xsl:template name="doacquisitiondata">
    <xsl:for-each select="xcede2:acquisitionInfo">
      <acquisitiondata>
        <xsl:if test="xcede2:description">
          <description>
            <xsl:value-of select="xcede2:description" />
          </description>
        </xsl:if>
        <xsl:for-each select="xcede2:scanner">
          <xsl:for-each select="xcede2:manufacturer">
            <scannermanufacturer><xsl:value-of select="." /></scannermanufacturer>
          </xsl:for-each>
          <xsl:for-each select="xcede2:institutionName">
            <institution><xsl:value-of select="." /></institution>
          </xsl:for-each>
          <xsl:for-each select="xcede2:institutionAddress">
            <institutionaddress><xsl:value-of select="." /></institutionaddress>
          </xsl:for-each>
          <xsl:for-each select="xcede2:stationName">
            <scanner><xsl:value-of select="." /></scanner>
          </xsl:for-each>
          <xsl:for-each select="xcede2:institutionalDepartmentName">
            <institutionaldepartmentname><xsl:value-of select="." /></institutionaldepartmentname>
          </xsl:for-each>
          <xsl:for-each select="xcede2:modelName">
            <scannermodelname><xsl:value-of select="." /></scannermodelname>
          </xsl:for-each>
          <xsl:for-each select="xcede2:serialNumber">
            <scannerSerialNumber><xsl:value-of select="." /></scannerSerialNumber>
          </xsl:for-each>
          <xsl:for-each select="xcede2:softwareVersions">
            <softwareversions><xsl:value-of select="." /></softwareversions>
          </xsl:for-each>
          <xsl:for-each select="xcede2:spatialResolution">
            <spatialresolution><xsl:value-of select="." /></spatialresolution>
          </xsl:for-each>
          <xsl:for-each select="xcede2:dateLastCalibration">
            <datelastcalibration><xsl:value-of select="." /></datelastcalibration>
          </xsl:for-each>
          <xsl:for-each select="xcede2:timeLastCalibration">
            <timelastcalibration><xsl:value-of select="." /></timelastcalibration>
          </xsl:for-each>
          <xsl:for-each select="xcede2:pixelPaddingValue">
            <pixelpaddingvalue><xsl:value-of select="." /></pixelpaddingvalue>
          </xsl:for-each>
        </xsl:for-each>
        <xsl:for-each select="xcede2:rows">
          <rows><xsl:value-of select="." /></rows>
        </xsl:for-each>
        <xsl:for-each select="xcede2:columns">
          <columns><xsl:value-of select="." /></columns>
        </xsl:for-each>
        <xsl:for-each select="xcede2:sliceThickness">
          <slicethickness><xsl:value-of select="." /></slicethickness>
        </xsl:for-each>
        <xsl:for-each select="xcede2:protocolName">
          <protocolname><xsl:value-of select="." /></protocolname>
        </xsl:for-each>
        <xsl:for-each select="xcede2:scanningSequence">
          <scanningsequence><xsl:value-of select="." /></scanningsequence>
        </xsl:for-each>
        <xsl:for-each select="xcede2:sequenceVariant">
          <sequencevariant><xsl:value-of select="." /></sequencevariant>
        </xsl:for-each>
        <xsl:for-each select="xcede2:scanOptions">
          <scanoptions><xsl:value-of select="." /></scanoptions>
        </xsl:for-each>
        <xsl:for-each select="xcede2:acquisitionType">
          <mracquisitiontype><xsl:value-of select="." /></mracquisitiontype>
        </xsl:for-each>
        <xsl:for-each select="xcede2:tr">
          <tr><xsl:value-of select="." /></tr>
        </xsl:for-each>
        <xsl:for-each select="xcede2:te">
          <te><xsl:value-of select="." /></te>
        </xsl:for-each>
        <xsl:for-each select="xcede2:echoTrainLength">
          <echotrainlength><xsl:value-of select="." /></echotrainlength>
        </xsl:for-each>
        <xsl:for-each select="xcede2:ti">
          <ti><xsl:value-of select="." /></ti>
        </xsl:for-each>
        <xsl:for-each select="xcede2:triggerTime">
          <triggertime><xsl:value-of select="." /></triggertime>
        </xsl:for-each>
        <xsl:for-each select="xcede2:sequenceName">
          <sequencename><xsl:value-of select="." /></sequencename>
        </xsl:for-each>
        <xsl:for-each select="xcede2:angioFlag">
          <angioflag><xsl:value-of select="." /></angioflag>
        </xsl:for-each>
        <xsl:for-each select="xcede2:numAverages">
          <numaverages><xsl:value-of select="." /></numaverages>
        </xsl:for-each>
        <xsl:for-each select="xcede2:imagingFrequency">
          <frequency><xsl:value-of select="." /></frequency>
        </xsl:for-each>
        <xsl:for-each select="xcede2:imagedNucleus">
          <imagednucleus><xsl:value-of select="." /></imagednucleus>
        </xsl:for-each>
        <xsl:for-each select="xcede2:echoNumber">
          <echonum><xsl:value-of select="." /></echonum>
        </xsl:for-each>
        <xsl:for-each select="xcede2:magneticField">
          <fieldstrength><xsl:value-of select="." /></fieldstrength>
        </xsl:for-each>
        <xsl:for-each select="xcede2:numPhaseEncodingSteps">
          <numphaseencodingsteps><xsl:value-of select="." /></numphaseencodingsteps>
        </xsl:for-each>
        <xsl:for-each select="xcede2:percentSampling">
          <percentsampling><xsl:value-of select="." /></percentsampling>
        </xsl:for-each>
        <xsl:for-each select="xcede2:percentPhaseFieldOfView">
          <percentphasefov><xsl:value-of select="." /></percentphasefov>
        </xsl:for-each>
        <xsl:for-each select="xcede2:pixelBandwidth">
          <pixelbandwidth><xsl:value-of select="." /></pixelbandwidth>
        </xsl:for-each>
        <xsl:for-each select="xcede2:nominalInterval">
          <nominalinterval><xsl:value-of select="." /></nominalinterval>
        </xsl:for-each>
        <xsl:for-each select="xcede2:beatRejectionFlag">
          <beatrejectionflag><xsl:value-of select="." /></beatrejectionflag>
        </xsl:for-each>
        <xsl:for-each select="xcede2:lowRRValue">
          <lowrrvalue><xsl:value-of select="." /></lowrrvalue>
        </xsl:for-each>
        <xsl:for-each select="xcede2:highRRValue">
          <highrrvalue><xsl:value-of select="." /></highrrvalue>
        </xsl:for-each>
        <xsl:for-each select="xcede2:intervalsAcquired">
          <intervalsacquired><xsl:value-of select="." /></intervalsacquired>
        </xsl:for-each>
        <xsl:for-each select="xcede2:intervalsRejected">
          <intervalsrejected><xsl:value-of select="." /></intervalsrejected>
        </xsl:for-each>
        <xsl:for-each select="xcede2:pvcRejection">
          <pvcrejection><xsl:value-of select="." /></pvcrejection>
        </xsl:for-each>
        <xsl:for-each select="xcede2:skipBeats">
          <skipbeats><xsl:value-of select="." /></skipbeats>
        </xsl:for-each>
        <xsl:for-each select="xcede2:heartRate">
          <heartrate><xsl:value-of select="." /></heartrate>
        </xsl:for-each>
        <xsl:for-each select="xcede2:cardiacNumberOfImages">
          <cardiacnumimages><xsl:value-of select="." /></cardiacnumimages>
        </xsl:for-each>
        <xsl:for-each select="xcede2:triggerWindow">
          <triggerwindow><xsl:value-of select="." /></triggerwindow>
        </xsl:for-each>
        <xsl:for-each select="xcede2:reconstructionDiameter">
          <reconstructiondiameter><xsl:value-of select="." /></reconstructiondiameter>
        </xsl:for-each>
        <xsl:for-each select="xcede2:receiveCoilName">
          <receivecoilname><xsl:value-of select="." /></receivecoilname>
        </xsl:for-each>
        <xsl:for-each select="xcede2:transmitCoilName">
          <transmitcoilname><xsl:value-of select="." /></transmitcoilname>
        </xsl:for-each>
        <xsl:for-each select="xcede2:acquisitionMatrix">
          <acquisitionmatrix><xsl:value-of select="." /></acquisitionmatrix>
        </xsl:for-each>
        <xsl:for-each select="xcede2:phaseEncodingDirection">
          <phaseencodingdirection><xsl:value-of select="." /></phaseencodingdirection>
        </xsl:for-each>
        <xsl:for-each select="xcede2:flipAngle">
          <flipangle><xsl:value-of select="." /></flipangle>
        </xsl:for-each>
        <xsl:for-each select="xcede2:SAR">
          <sar><xsl:value-of select="." /></sar>
        </xsl:for-each>
        <xsl:for-each select="xcede2:variableFlipAngleFlag">
          <variableflipangleflag><xsl:value-of select="." /></variableflipangleflag>
        </xsl:for-each>
        <xsl:for-each select="xcede2:dBdt">
          <dbdt><xsl:value-of select="." /></dbdt>
        </xsl:for-each>
        <xsl:for-each select="xcede2:temporalPositionIdentifier">
          <temporalpositionidentifier><xsl:value-of select="." /></temporalpositionidentifier>
        </xsl:for-each>
        <xsl:for-each select="xcede2:numTemporalPositions">
          <numtemporalpositions><xsl:value-of select="." /></numtemporalpositions>
        </xsl:for-each>
        <xsl:for-each select="xcede2:temporalResolution">
          <temporalresolution><xsl:value-of select="." /></temporalresolution>
        </xsl:for-each>

        <xsl:for-each select="xcede2:param">
          <xsl:choose>
            <xsl:when test="@name = 'examnumber'">
              <examnumber><xsl:value-of select="."/></examnumber>
            </xsl:when>
            <xsl:when test="@name = 'studyid'">
              <studyid><xsl:value-of select="."/></studyid>
            </xsl:when>
            <xsl:when test="@name = 'seriesnumber'">
              <seriesnumber><xsl:value-of select="."/></seriesnumber>
            </xsl:when>
            <xsl:when test="@name = 'runnumber'">
              <runnumber><xsl:value-of select="."/></runnumber>
            </xsl:when>
            <xsl:when test="@name = 'scanningsequence'">
              <scanningsequence><xsl:value-of select="."/></scanningsequence>
            </xsl:when>
            <xsl:when test="@name = 'sequencevariant'">
              <sequencevariant><xsl:value-of select="."/></sequencevariant>
            </xsl:when>
            <xsl:when test="@name = 'magneticfield'">
              <magneticfield><xsl:value-of select="."/></magneticfield>
            </xsl:when>
            <xsl:when test="@name = 'description'">
              <description><xsl:value-of select="."/></description>
            </xsl:when>
            <xsl:when test="@name = 'scandate'">
              <scandate><xsl:value-of select="."/></scandate>
            </xsl:when>
            <xsl:when test="@name = 'scantime'">
              <scantime><xsl:value-of select="."/></scantime>
            </xsl:when>
            <xsl:when test="@name = 'tr'">
              <tr><xsl:value-of select="."/></tr>
            </xsl:when>
            <xsl:when test="@name = 'te'">
              <te><xsl:value-of select="."/></te>
            </xsl:when>
            <xsl:when test="@name = 'echospacing'">
              <echospacing><xsl:value-of select="."/></echospacing>
            </xsl:when>
            <xsl:when test="@name = 'nechos'">
              <nechos><xsl:value-of select="."/></nechos>
            </xsl:when>
            <xsl:when test="@name = 'echonumber'">
              <echonumber><xsl:value-of select="."/></echonumber>
            </xsl:when>
            <xsl:when test="@name = 'nshots'">
              <nshots><xsl:value-of select="."/></nshots>
            </xsl:when>
            <xsl:when test="@name = 'sensefactor'">
              <sensefactor><xsl:value-of select="."/></sensefactor>
            </xsl:when>
            <xsl:when test="@name = 'operator'">
              <operator><xsl:value-of select="."/></operator>
            </xsl:when>
            <xsl:when test="@name = 'flipangle'">
              <flipangle><xsl:value-of select="."/></flipangle>
            </xsl:when>
            <xsl:when test="@name = 'prescribedslicespacing'">
              <prescribedslicespacing><xsl:value-of select="."/></prescribedslicespacing>
            </xsl:when>
            <xsl:when test="@name = 'frequencydirection'">
              <frequencydirection><xsl:value-of select="."/></frequencydirection>
              <xsl:if test="not(../xcede2:phaseEncodingDirection)">
                <xsl:choose>
                  <xsl:when test=". = 1">
                    <phaseencodingdirection>COL</phaseencodingdirection>
                  </xsl:when>
                  <xsl:when test=". = 2">
                    <phaseencodingdirection>ROW</phaseencodingdirection>
                  </xsl:when>
                </xsl:choose>
              </xsl:if>
            </xsl:when>
            <xsl:when test="@name = 'acquisitionmatrix'">
              <acquisitionmatrix><xsl:value-of select="."/></acquisitionmatrix>
            </xsl:when>
            <xsl:when test="@name = 'bandwidth'">
              <bandwidth><xsl:value-of select="."/></bandwidth>
            </xsl:when>
            <xsl:when test="@name = 'pixelbandwidth'">
              <pixelbandwidth><xsl:value-of select="."/></pixelbandwidth>
            </xsl:when>
            <xsl:when test="@name = 'receivecoilname'">
              <receivecoilname><xsl:value-of select="."/></receivecoilname>
            </xsl:when>
            <xsl:when test="@name = 'transmitcoilname'">
              <transmitcoilname><xsl:value-of select="."/></transmitcoilname>
            </xsl:when>
            <xsl:when test="@name = 'institution'">
              <institution><xsl:value-of select="."/></institution>
            </xsl:when>
            <xsl:when test="@name = 'institutionaddress'">
              <institutionaddress><xsl:value-of select="."/></institutionaddress>
            </xsl:when>
            <xsl:when test="@name = 'institutionaldepartmentname'">
              <institutionaldepartmentname><xsl:value-of select="."/></institutionaldepartmentname>
            </xsl:when>
            <xsl:when test="@name = 'examdescription'">
              <examdescription><xsl:value-of select="."/></examdescription>
            </xsl:when>
            <xsl:when test="@name = 'scanner'">
              <scanner><xsl:value-of select="."/></scanner>
            </xsl:when>
            <xsl:when test="@name = 'scannermanufacturer'">
              <scannermanufacturer><xsl:value-of select="."/></scannermanufacturer>
            </xsl:when>
            <xsl:when test="@name = 'scannermodelname'">
              <scannermodelname><xsl:value-of select="."/></scannermodelname>
            </xsl:when>
            <xsl:when test="@name = 'fieldofview'">
              <fieldofview><xsl:value-of select="."/></fieldofview>
            </xsl:when>
            <xsl:when test="@name = 'ti'">
              <ti><xsl:value-of select="."/></ti>
            </xsl:when>
            <xsl:when test="@name = 'psdname'">
              <psdname><xsl:value-of select="."/></psdname>
            </xsl:when>
            <xsl:when test="@name = 'psdinternalname'">
              <psdinternalname><xsl:value-of select="."/></psdinternalname>
            </xsl:when>
            <xsl:when test="@name = 'psddate'">
              <psddate><xsl:value-of select="."/></psddate>
            </xsl:when>
            <xsl:when test="@name = 'psdtime'">
              <psdtime><xsl:value-of select="."/></psdtime>
            </xsl:when>
            <xsl:when test="@name = 'protocolname'">
              <protocolname><xsl:value-of select="."/></protocolname>
            </xsl:when>
            <xsl:when test="@name = 'sliceorder'">
              <sliceorder><xsl:value-of select="."/></sliceorder>
            </xsl:when>
            <xsl:when test="@name = 'bvalues'">
              <bvalues><xsl:value-of select="."/></bvalues>
            </xsl:when>
            <xsl:otherwise>
              <xsl:element name="acqParam">
                <xsl:for-each select="@*|node()">
                  <xsl:copy-of select=".">
                  </xsl:copy-of>
                </xsl:for-each>
              </xsl:element>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </acquisitiondata>
    </xsl:for-each>
    <history>
      <xsl:for-each select="xcede2:provenance/xcede2:processStep">
        <entry>
          <date><xsl:value-of select="xcede2:timeStamp"/></date>
          <description>
            <xsl:copy-of select="." />
          </description>
        </entry>
      </xsl:for-each>
    </history>
  </xsl:template>

</xsl:stylesheet>


<!--
  $Log: In-line log eliminated on transition to SVN; use svn log instead. $
  Revision 1.1  2008/03/07 18:21:59  gadde
  Add preliminary XCEDE 2 support

  Revision 1.9  2007/02/27 18:04:38  gadde
  Add more acquisition data parameters.

  Revision 1.8  2007/02/21 21:49:15  gadde
  Make sure all acquisitiondata and acqParam elements are translated BXH->XCEDE and vice-versa

  Revision 1.7  2007/02/01 15:39:22  gadde
  Add compression field

  Revision 1.6  2006/02/09 21:40:36  gadde
  Write bxh rasorigin field.

  Revision 1.5  2006/01/03 17:14:33  gadde
  Add CVS log.

  -->
