static const char rcsid[] = "$Id: bxh_absorb_afni.cpp,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * afni2bxh.cc --
 * 
 * Creates a BXH file based on given AFNI file(s)
 */

#include "bxh_convert.h"
#include "bxh_datarec.h"
#include "bxh_utils.h"
#include "opts.h"

#include <time.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <math.h>

#include <map>
#include <string>

#ifdef __cplusplus
extern "C" {
#endif

extern size_t opt_hintsize[4];
extern double opt_hintorigin[4];
extern double opt_hintspacing[4];
extern double opt_hintgap[4];
extern char * opt_forceorient;

static int
addopts_afni2bxh_common(opt_data * optsin[], int numoptsin)
{
    return 0;
}

int
addopts_bxhabsorb_afni2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 3;
    opt_data opts[3] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "AFNI USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype afni [opts] afnifile.HEAD output.bxh" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_afni2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_afni2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  afni2bxh [opts] afnifile.HEAD output.bxh\n\n"
	  "This program creates an XML wrapper for AFNI images." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_afni2bxh_common(optsin, numoptsin + numopts);
}

int
main_afni2bxh(int argc, char *argv[])
{
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc != 3) {
	fprintf(stderr, "Wrong number of arguments! use\n %s --help\n", argv[0]);
	return 1;
    }

    if ((docp = createDocFromAFNI(argv[1], argv[2], &opt_hintsize[0], &opt_hintorigin[0], &opt_hintspacing[0], &opt_hintgap[0], opt_forceorient)) == NULL) 
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[2]) != 0)
	goto FAIL;
    goto EXIT;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
    return result;
}

#ifdef __cplusplus
}
#endif

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.7  2007/02/28 20:26:37  gadde
 * Deal better with missing unnecessary fields.
 *
 * Revision 1.6  2005/09/19 16:31:54  gadde
 * Documentation and help message updates.
 *
 * Revision 1.5  2005/05/10 19:48:27  gadde
 * Set gap to 0 (previous gap calculation did not work for sample data).
 *
 * Revision 1.4  2005/03/08 18:09:57  gadde
 * Add support for dimension size/spacing/gap/orientation hints
 *
 * Revision 1.3  2004/06/15 16:16:11  gadde
 * Several -Wall fixes and addition of bxh_datarec_addfrag()
 *
 * Revision 1.2  2004/05/20 17:11:22  gadde
 * Fix opts error.
 *
 * Revision 1.1  2004/04/22 12:56:42  gadde
 * Add AFNI support.
 *
 *
 */
