static const char rcsid[] = "$Id: bxh_absorb_analyze.c,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * analyze2bxh.cc --
 * 
 * Creates a BXH file based on given Analyze 7.5/SPM file.
 */

#include "bxh_convert.h"
#include "bxh_datarec.h"
#include "bxh_utils.h"
#include "opts.h"

#include <time.h>
#include <ctype.h>
#include <string.h>
#if defined(WIN32) && !defined(__MINGW32__)
#include <pstdint.h>
#else
#include <inttypes.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>

#include <math.h>

#include <zlib.h>

#include "nifti1_io.h"

extern size_t opt_hintsize[4];
extern double opt_hintorigin[4];
extern double opt_hintspacing[4];
extern double opt_hintgap[4];
extern char * opt_forceorient;

static char * opt_orient = NULL;
static int opt_strictanalyze = 0;
static char * opt_avwbyteorder = NULL;
static int opt_nofixpixdim = 0;

static int
addopts_analyze2bxh_common(opt_data * optsin[], int numoptsin)
{
    const int numopts = 4;
    opt_data opts[4] = {
	{ OPT_FLAGS_FULL, OPT_VAL_STR, &opt_orient, 1, "orientation",
	  "Orientation of image, letters indication which way the"
	  "X, Y, and Z dimensions (in that order) are pointing "
	  "(e.g. LPS, IRP).  "
	  "Default is RAS (i.e. orientation used by SPM), "
	  "or that specified in accompanying SPM .mat files.  "
	  "This option overrides all info in SPM .mat files and/or "
	  "the Analyze 'orient' field (if --strictanalyze is specified).  "
	  "Equivalent to (and overrides) --forceorientation." },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_strictanalyze, 1, "strictanalyze",
	  "Don't use SPM .mat files and use Analyze convention for "
	  "orientation.  "
	  "The 'orient' field in the analyze header is parsed, and "
	  "the default case (i.e. it is zero) means 'LAS'."},
	{ OPT_FLAGS_FULL, OPT_VAL_STR, &opt_avwbyteorder, 1, "avwbyteorder",
	  "Specify byte order for AVW files (which don't store this info). "
	  "This field should be 'l' for little-endian or 'b' for big-endian."},
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_nofixpixdim, 1, "nofixpixdim",
	  "If the Analyze/NIfTI header field pixdim[X] is 0.0, default "
	  "is to match behavior of reference code nifti1_io.c and "
	  "\"correct\" it to 1.0.  Specify this option if this is not "
	  "desired." }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts;
}

int
addopts_bxhabsorb_analyze2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 4;
    opt_data opts[4] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "ANALYZE/SPM USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype analyze [opts] [analyzefiles...] output.bxh" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "ANALYZE/SPM OPTIONS:" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_analyze2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_analyze2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  analyze2bxh [opts] [analyzefiles...] output.bxh\n\n"
	  "This program creates an XML wrapper for "
	  "Analyze7.5/SPM/NIfTI-1 images." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_analyze2bxh_common(optsin, numoptsin + numopts);
}

int
main_analyze2bxh(int argc, char *argv[])
{
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc < 3) {
	fprintf(stderr, "Not enough arguments! use\n %s --help\n", argv[0]);
	return 1;
    }

    if ((docp = createDocFromAnalyze(&((const char **)argv)[1], argc - 2, argv[argc-1], opt_hintsize, opt_hintorigin, opt_hintspacing, opt_hintgap, opt_forceorient, opt_orient, opt_strictanalyze, opt_avwbyteorder, opt_nofixpixdim)) == NULL)
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[argc-1]) != 0)
	goto FAIL;
    goto EXIT;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
    return result;
}


/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.47  2008/12/08 16:53:34  gadde
 * Fix types for 64-bit machines.
 *
 * Revision 1.46  2008/08/08 20:17:30  gadde
 * Fix extraction of sform.
 *
 * Revision 1.45  2008/05/22 15:49:00  gadde
 * Convert to double before math expressions to avoid accumulating rounding errors.
 *
 * Revision 1.44  2007/09/14 20:45:58  gadde
 * Change default origin from 0,0,0 to half FOV.
 *
 * Revision 1.43  2007/08/17 15:33:57  gadde
 * Fix memory bug.
 *
 * Revision 1.42  2007/02/23 20:08:59  gadde
 * When reading .mat files, use 'mat' matrix (SPM2 convention) if available,
 * otherwise use 'M'.
 *
 * Revision 1.41  2007/01/16 21:49:19  gadde
 * Fix temporal units for output XML file.
 *
 * Revision 1.40  2007/01/16 20:22:40  gadde
 * Make sure output .bxh has units of ms and mm.
 *
 * Revision 1.39  2006/10/20 17:01:49  gadde
 * Fix simple unsigned/signed bug.
 *
 * Revision 1.38  2006/10/04 21:16:30  gadde
 * Deal with negative pixdims (interpret them as reversing the
 * default RAS convention for that dimension).
 * Work better with compressed .mat files and .mat files that
 * need to be byte-swapped.
 *
 * Revision 1.37  2006/09/22 14:19:10  gadde
 * Fix t spacing for NIfTI
 *
 * Revision 1.36  2006/08/04 16:29:26  gadde
 * Fix populating of .mat files.
 *
 * Revision 1.35  2006/07/25 19:27:34  gadde
 * Fix .mat file reading and also only use it if NIFTI transforms are missing.
 *
 * Revision 1.34  2006/05/19 14:37:42  gadde
 * Support gzipped nifti.
 *
 * Revision 1.33  2006/05/05 14:55:18  gadde
 * Actually represent the SPM byteswap this time.
 *
 * Revision 1.32  2006/05/05 14:51:57  gadde
 * Add SPM byte-swap datatypes.
 *
 * Revision 1.31  2006/02/08 19:01:31  gadde
 * Update to support nifti one-file format and sform_code
 *
 * Revision 1.30  2006/01/03 19:23:57  gadde
 * Support compressed elements in Level 5 .mat files.
 *
 * Revision 1.29  2005/12/16 18:25:57  gadde
 * Add level 5 MAT-file support.
 *
 * Revision 1.28  2005/09/19 16:31:55  gadde
 * Documentation and help message updates.
 *
 * Revision 1.27  2005/09/14 14:49:27  gadde
 * Type conversion updates to fix win32 warnings
 *
 * Revision 1.26  2005/08/11 18:55:40  gadde
 * Add pixdim[4] for t-dimension spacing.
 *
 * Revision 1.25  2005/05/10 19:48:54  gadde
 * Fix some memory bugs.
 *
 * Revision 1.24  2005/04/26 18:39:37  gadde
 * Update for new version of NIfTI library.
 *
 * Revision 1.23  2005/03/08 18:09:57  gadde
 * Add support for dimension size/spacing/gap/orientation hints
 *
 * Revision 1.22  2004/09/17 13:54:20  gadde
 * Fix some indexing errors.
 *
 * Revision 1.21  2004/06/18 15:21:51  gadde
 * Standardize frag creation (redux)
 *
 * Revision 1.20  2004/06/15 16:16:11  gadde
 * Several -Wall fixes and addition of bxh_datarec_addfrag()
 *
 * Revision 1.19  2004/04/07 19:31:40  gadde
 * Add units and slice duration.
 *
 * Revision 1.18  2004/04/07 19:02:07  gadde
 * Add NIfTI-1 support.
 *
 * Revision 1.17  2004/02/24 18:01:06  gadde
 * Move history generation to bxh_utils.cpp, and add option to create BIRN files
 *
 * Revision 1.16  2004/02/20 18:42:48  gadde
 * Add version option and rearrange documentation
 *
 * Revision 1.15  2003/11/18 22:10:25  gadde
 * Make sure user-specified orientation trumps all.
 *
 * Revision 1.14  2003/11/17 21:43:27  gadde
 * Fix last-dimension size calculation.
 *
 * Revision 1.13  2003/11/07 16:05:28  gadde
 * Add support for AVW_ImageFile/AVW_VolumeFile.
 *
 * Revision 1.12  2003/11/05 18:38:21  gadde
 * One more byte order fix.
 *
 * Revision 1.11  2003/11/05 18:34:44  gadde
 * Fix some byte-swapping issues.
 *
 * Revision 1.10  2003/11/05 17:23:59  gadde
 * Use .mat files for orientation if they exist.
 * Add option to ignore them and use Analyze .orient field (--strictanalyze).
 *
 * Revision 1.9  2003/09/08 20:22:54  gadde
 * Populate nth dimension if numinfiles > 1
 *
 * Revision 1.8  2003/08/19 19:35:41  gadde
 * New options scheme, so that options are available using whichever form of bxhabsorb you use.
 *
 * Revision 1.7  2003/07/29 17:03:09  gadde
 * Get rid of singleton dimensions (if dim > 3)
 *
 * Revision 1.6  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.5  2003/06/24 14:40:13  gadde
 * Support multiple input files.
 *
 * Revision 1.4  2003/06/18 16:14:15  gadde
 * win32 fixes
 *
 * Revision 1.3  2003/06/18 16:08:17  gadde
 * fopen in binary mode
 *
 * Revision 1.2  2003/06/06 20:07:33  gadde
 * Update documentation.
 *
 * Revision 1.1  2003/06/06 19:41:43  gadde
 * Initial commit.
 *
 */
