static const char rcsid[] = "$Id: bxh_absorb_bxh.c,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * bxh2bxh.cc --
 * 
 * Creates a BXH or XCEDE file based on given BXH or XCEDE file.
 */

#include "bxh_convert.h"
#include "bxh_datarec.h"
#include "bxh_utils.h"
#include "opts.h"

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <math.h>

extern size_t opt_hintsize[4];
extern double opt_hintorigin[4];
extern double opt_hintspacing[4];
extern double opt_hintgap[4];
extern char * opt_forceorient;

extern int ncopts;

int
addopts_bxh2bxh_common(opt_data * optsin[], int numoptsin)
{
    /* no extra options */
    return 0;
}

int
addopts_bxhabsorb_bxh2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 3;
    opt_data opts[3] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "BXH/XCEDE (as input) USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype bxh [opts] bxhfile outputfile\n"
	  "  bxhabsorb --fromtype xcede [opts] xcedefile outputfile"
	}
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_bxh2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_bxh2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  bxh2bxh [opts] bxhfile outputfile\n"
	  "  xcede2bxh [opts] xcedefile outputfile\n"
	  "\n"
	  "This program creates a new XML wrapper from BXH/XCEDE-wrapped "
	  "images." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_bxh2bxh_common(optsin, numoptsin + numopts);
}

int
main_bxh2bxh(int argc, char *argv[])
{
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc != 3) {
	fprintf(stderr, "Usage: %s infile outfile\n", argv[0]);
	return -1;
    }

    if ((docp = createDocFromBXH((const char *)argv[1], (const char *)argv[2])) == NULL)
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[2]) != 0)
	goto FAIL;
    goto EXIT;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
    return result;
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.1  2007/02/23 23:24:40  gadde
 * Add {bxh|xcede}2{bxh|xcede}
 *
 */
