static const char rcsid[] = "$Id: bxh_absorb_mgh.c,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * mgh2bxh.cc --
 * 
 * Creates a BXH file from an .mgh/.mgz file
 */

#include "bxh_convert.h"
#include "bxh_datarec.h"
#include "bxh_utils.h"
#include "opts.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <zlib.h>
#include <math.h>
#include <sys/stat.h>

/* the following is derived from info on the Freesurfer Wiki */
typedef struct {
    int version;
    int width;
    int height;
    int depth;
    int nframes;
    int type; /* 0=UCHAR, 1=INT, 3=FLOAT, 4=SHORT */
    int dof;
    short goodRASFlag; /* specifies whether the direction cosines (below) are populated */
    float spacingX;
    float spacingY;
    float spacingZ;
    /* direction cosines */
    float xr, xa, xs;
    float yr, ya, ys;
    float zr, za, zs;
    float cr, ca, cs;
    /* these come after the image data */
    float TR;
    float flipangle;
    float TE;
    float TI;
} MGH;

static int
addopts_mgh2bxh_common(opt_data * optsin[], int numoptsin)
{
    return 0;
}

int
addopts_bxhabsorb_mgh2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 4;
    opt_data opts[4] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "MGH/MGZ USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype mgh [opts] file.mgh output.bxh" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype mgh [opts] file.mgz output.bxh" },
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_mgh2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_mgh2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  mgh2bxh [opts] file.mgh output.bxh\n\n"
	  "  mgh2bxh [opts] file.mgz output.bxh\n\n"
	  "This program creates an XML wrapper for "
	  "MGH/MGZ images." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_mgh2bxh_common(optsin, numoptsin + numopts);
}

int
main_mgh2bxh(int argc, char *argv[])
{ 
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc < 3) {
	fprintf(stderr, "Not enough arguments! use\n %s --help\n", argv[0]);
	return 1;
    }

    if ((docp = createDocFromMGH(&((const char **)argv)[1], argc - 2, argv[argc-1])) == NULL)
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[argc-1]) != 0)
	goto FAIL;
    goto EXIT;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
    return result;
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.5  2007/02/01 18:11:39  gadde
 * Fix compression support
 *
 * Revision 1.4  2007/01/16 20:38:31  gadde
 * Fix height/width.
 *
 * Revision 1.3  2006/11/02 14:39:49  gadde
 * Add Log.
 *
 */
