/*
 * nrrd2bxh.cc --
 * 
 * Creates a BXH file based on given NRRD file(s)
 */

#include "bxh_convert.h"
#include "bxh_datarec.h"
#include "bxh_utils.h"
#include "opts.h"

#include <time.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <math.h>

#include <map>
#include <string>

#ifdef __cplusplus
extern "C" {
#endif

extern size_t opt_hintsize[4];
extern double opt_hintorigin[4];
extern double opt_hintspacing[4];
extern double opt_hintgap[4];
extern char * opt_forceorient;

static int
addopts_nrrd2bxh_common(opt_data * optsin[], int numoptsin)
{
    return 0;
}

int
addopts_bxhabsorb_nrrd2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 3;
    opt_data opts[3] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "NRRD USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype nrrd [opts] file.nrrd output.bxh\n"
	  "  bxhabsorb --fromtype nrrd [opts] file.nhdr output.bxh\n" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_nrrd2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_nrrd2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  nrrd2bxh [opts] file.nrrd output.bxh\n"
	  "  nrrd2bxh [opts] file.nhdr output.bxh\n\n"
	  "This program creates an XML wrapper for NRRD images." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_nrrd2bxh_common(optsin, numoptsin + numopts);
}

int
main_nrrd2bxh(int argc, char *argv[])
{
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc != 3) {
	fprintf(stderr, "Wrong number of arguments! use\n %s --help\n", argv[0]);
	return 1;
    }

    if ((docp = createDocFromNRRD(argv[1], argv[2], &opt_hintsize[0], &opt_hintorigin[0], &opt_hintspacing[0], &opt_hintgap[0], opt_forceorient)) == NULL) 
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[2]) != 0)
	goto FAIL;
    goto EXIT;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
    return result;
}

#ifdef __cplusplus
}
#endif

