static const char rcsid[] = "$Id: bxh_absorb_ximg.c,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * ximg2bxh.cc --
 * 
 * Creates a BXH file based on given Signa "XIMG" (E*S*I*) files.
 */

#include "bxh_convert.h"
#include "bxh_datarec.h"
#include "bxh_signa.h"
#include "bxh_utils.h"
#include "opts.h"

#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

extern size_t opt_hintsize[4];
extern double opt_hintorigin[4];
extern double opt_hintspacing[4];
extern double opt_hintgap[4];
extern char * opt_forceorient;

static size_t opt_dimzsize = (size_t)-1;
static size_t opt_dimtsize = (size_t)-1;

static int
addopts_ximg2bxh_common(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ OPT_FLAGS_FULL, OPT_VAL_SIZE, &opt_dimzsize, 1, "dimzsize",
	  "Specifies the size of the z dimension "
	  "(i.e. number of slices per timepoint).  "
	  "Default is to use the number of input files.  "
          "Equivalent to (and overrides) --hintsizez." },
	{ OPT_FLAGS_FULL, OPT_VAL_SIZE, &opt_dimtsize, 1, "dimtsize",
	  "Specifies the size of the t dimension "
	  "(i.e. number of timepoints).  "
	  "Default is number of input files divided by number of "
	  "slices per timepoint (as specified by --dimzsize).  "
          "Equivalent to (and overrides) --hintsizet." },
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts;
}

int
addopts_bxhabsorb_ximg2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 4;
    opt_data opts[4] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "XIMG USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype ximg [opts] [ximgfiles...] output.bxh" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "XIMG OPTIONS " }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_ximg2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_ximg2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  ximg2bxh [opts] [ximgfiles...] output.bxh\n\n"
	  "This program creates an XML wrapper for GE Ximg image files." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_ximg2bxh_common(optsin, numoptsin + numopts);
}

int
main_ximg2bxh(int argc, char *argv[])
{
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc < 3) {
	fprintf(stderr, "Usage: %s ximgfile... outfile\n", argv[0]);
	return -1;
    }

    if ((docp = createDocFromXIMG((const char **)argv+1, argc - 2, (const char *)argv[argc-1])) == NULL)
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[argc-1]) != 0)
	goto FAIL;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
}


/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.18  2005/09/19 16:31:59  gadde
 * Documentation and help message updates.
 *
 * Revision 1.17  2005/07/07 15:09:21  gadde
 * Updates for ver11 pfiles.
 *
 * Revision 1.16  2005/03/08 18:09:58  gadde
 * Add support for dimension size/spacing/gap/orientation hints
 *
 * Revision 1.15  2004/06/15 16:16:12  gadde
 * Several -Wall fixes and addition of bxh_datarec_addfrag()
 *
 * Revision 1.14  2004/02/24 18:01:07  gadde
 * Move history generation to bxh_utils.cpp, and add option to create BIRN files
 *
 * Revision 1.13  2004/02/20 18:42:48  gadde
 * Add version option and rearrange documentation
 *
 * Revision 1.12  2004/01/02 18:41:20  gadde
 * Allow more than one timepoint for Signa files
 *
 * Revision 1.11  2003/08/19 19:35:41  gadde
 * New options scheme, so that options are available using whichever form of bxhabsorb you use.
 *
 * Revision 1.10  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.9  2003/06/18 16:11:22  gadde
 * win32 fixes
 *
 * Revision 1.8  2003/05/16 19:57:04  gadde
 * Require a basepath for datarec.
 *
 * Revision 1.7  2003/05/10 18:20:20  gadde
 * Don't null-terminate frags.
 *
 * Revision 1.6  2003/04/28 20:51:02  gadde
 * Fix documentation
 *
 * Revision 1.5  2003/04/28 19:53:22  gadde
 * Remove unused variable.
 *
 * Revision 1.4  2003/04/28 19:47:56  gadde
 * Move to catch-all BXH encapsulation program bxhabsorb -- dicom2bxh, pfile2bxh,
 * etc. will all be symbolic links to bxhabsorb.
 *
 * Also get rid of some unnecessary code.
 *
 * Revision 1.3  2003/04/02 20:22:49  gadde
 * Get rid of warning.
 *
 * Revision 1.2  2003/03/24 18:45:11  gadde
 * Fix record size.
 *
 * Revision 1.1  2003/03/24 16:44:27  gadde
 * Add support for ximg format
 *
 *
 */
