#!/bin/perl

use strict;
use Win32::GuiTest qw/FindWindowLike GetWindowText GetClassName
    GetChildDepth GetDesktopWindow SendKeys SetForegroundWindow/;
use File::Spec;

my $cwd = File::Spec->rel2abs(File::Spec->curdir());
print STDOUT "cwd=", $cwd, "\n";
while (@ARGV > 0) {
  my $arg = shift;
  system('start "c:\Program Files\PST\E-Prime\Program\E-DataAid.exe" ' . "\"$arg\"");
  my ($argvol, $argdirs, $argfile) = File::Spec->splitpath($arg);
  my $foundit = 0;
  for (1..10) {
    last if $foundit;
    my @whnds;
    while (@whnds = FindWindowLike(undef, "$argfile - E-DataAid")) {
      if (@whnds > 1) {
	die "E-DataAid already open???\n";
      }
      my $curhnd = shift @whnds;
      $foundit = 1;
#      my $s = sprintf("0x%08X", $curhnd );
#      my $s .= ", '" .  GetWindowText($curhnd) . "', " . GetClassName($curhnd);
#      next if GetChildDepth(GetDesktopWindow(), $curhnd) > 1;
#      print "+" x GetChildDepth(GetDesktopWindow(), $curhnd), $s, "\n";
      SetForegroundWindow($curhnd);
      sleep 0.5;
      SendKeys('%fe'); # select File|Export menu option
      sleep 0.5;
      SendKeys('{DOWN}{DOWN}{DOWN}'); # select Eprime-Text as export type in pull-down menu
      SendKeys('~'); # click OK
      sleep 2.0;
      SendKeys('~'); # then OK again for Export As file chooser
      # while loop in case OK didn't stick
      while (@whnds = FindWindowLike(undef, "Export As")) {
	sleep 0.5;
        SendKeys('~'); # then OK again for file menu
      }
      # while loop in case it didn't catch the exit command
      while (@whnds = FindWindowLike(undef, "$argfile - E-DataAid")) {
	sleep 0.5;
	SetForegroundWindow($curhnd);
	SendKeys('%{F4}');
      }
    }
    sleep 1;
  }
  if (!$foundit) {
    die "Couldn't find the E-DataAid window!";
  }
  my $newfile = $argfile;
  $newfile =~ s/.edat$/-converted.txt/;
  my $newpath = File::Spec->catpath($argvol, $argdirs, $newfile);
  print STDOUT "argvol=$argvol argdirs=$argdirs argfile=$argfile newfile=$newfile newpath=$newpath\n";
  if (! -e "Untitled.txt") {
    die "Couldn't find the output file from E-DataAid.  You need to run E-DataAid once, open an .edat file, 'export' the file (Export is under the File menu), and specify $cwd as the output directory.  After that, this program should run properly.\n";
  }
  system("move Untitled.txt \"$newpath\"");
}
