#!/bin/bash

CONFIGFLAGS=()
if [ x"${CONFIG_FLAGS}" != x ] ; then
  CONFIGFLAGS=( $CONFIG_FLAGS )
fi

# from COMPILE.sh
#PKGCONFIG=pkg-config-0.23

JPEGLIB=jpeg-6b
LIBPNG=libpng-1.4.8
FREETYPE=freetype-2.3.12
GHOSTSCRIPT=ghostscript-8.64
FONTCONFIG=fontconfig-2.6.0
IMAGEMAGICK=ImageMagick-6.7.1-6

set -o pipefail

cd ${COMPILEDIR}
if [ ${COMPILEDIR} != ${SRCDIR} ] ; then
  for i in ${JPEGLIB} ${LIBPNG} ${GHOSTSCRIPT} ${FREETYPE} ${FONTCONFIG} ${IMAGEMAGICK} ; do
    if [ ! -d ${i} ] ; then
      mkdir ${i}
    fi
  done
fi

if [ ! -d ${INSTALLDIR}/${JPEGLIB} ] ; then
LOGFILE=${COMPILEDIR}/log-${JPEGLIB}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${JPEGLIB} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${JPEGLIB}.tgz
fi
cd ${COMPILEDIR}/${JPEGLIB}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  env CC=${CC} CXX=${CXX} ${SRCDIR}/${JPEGLIB}/configure --prefix=${INSTALLDIR}/${JPEGLIB} "${CONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
fi
if [ $? -ne 0 ] ; then echo "Error configuring ${JPEGLIB}" ; exit 1 ; fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${JPEGLIB}" ; exit 1 ; fi
mkdir "${INSTALLDIR}/${JPEGLIB}"
mkdir "${INSTALLDIR}/${JPEGLIB}/bin"
mkdir "${INSTALLDIR}/${JPEGLIB}/man"
mkdir "${INSTALLDIR}/${JPEGLIB}/man/man1"
mkdir "${INSTALLDIR}/${JPEGLIB}/include"
mkdir "${INSTALLDIR}/${JPEGLIB}/lib"
make install install-lib install-headers 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${JPEGLIB}" ; exit 1 ; fi
make clean
fi

if [ ! -d ${INSTALLDIR}/${GHOSTSCRIPT} ] ; then
LOGFILE=${COMPILEDIR}/log-${GHOSTSCRIPT}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${GHOSTSCRIPT} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${GHOSTSCRIPT}.tgz
fi
if [ ! -f ${COMPILEDIR}/${GHOSTSCRIPT}/configure ] ; then
  cp -r ${SRCDIR}/${GHOSTSCRIPT} ${COMPILEDIR}
  cd ${COMPILEDIR}/${GHOSTSCRIPT}/base
  patch -p1 < ${SRCDIR}/patches/ghostscript-base-unix-dll.mak
fi
cd ${COMPILEDIR}/${GHOSTSCRIPT}
if [ ! -f config.log ] ; then 
  if [ x"${CROSSTARGET}" != x ] ; then
    tempnativedir="${COMPILEDIR}/_tempnative_${GHOSTSCRIPT}"
    rm -rf "${tempnativedir}"
    mkdir -p "${tempnativedir}"
    # we need to do a few things to trick ghostscript when cross-compiling
    ./configure --disable-shared --without-jasper CC=gcc CXX=g++ LD=ld RANLIB=ranlib LDFLAGS= CPPFLAGS=
    mkdir obj
    # these need to be executable in the native build environment, so make
    # them now
    make obj/genarch obj/genconf obj/echogs obj/mkromfs
    cp obj/genarch obj/genconf obj/echogs obj/mkromfs "${tempnativedir}"
    # now cross-compile
    make clean
    if [ x"${CONFIGCACHEFILE}" != x ] ; then
      cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
    fi
    ${SRCDIR}/${GHOSTSCRIPT}/configure --prefix=${INSTALLDIR}/${GHOSTSCRIPT} --disable-cups CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${JPEGLIB}/include" LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${JPEGLIB}/lib" CC=${CC} CXX=${CXX} "${CONFIGFLAGS[@]}" --disable-shared --without-jasper --disable-fontconfig --disable-cairo --disable-gtk 2>&1 | tee -a ${LOGFILE}
    # copy native executables so they are not re-made by cross-compiler
    cp "${tempnativedir}"/* obj
    mkdir soobj
    cp "${tempnativedir}"/* soobj
    # copy pre-created header files (you need some for this particular target)
    cp ${SRCDIR}/patches/ghostscript_${CROSSTARGET}_includes/* obj
    # don't remake the native executables
    cd ${COMPILEDIR}/${GHOSTSCRIPT}/base
    patch -p1 < ${SRCDIR}/patches/ghostscript-base-unix-aux_no-native-deps.mak
    cd ${COMPILEDIR}/${GHOSTSCRIPT}
    rm -rf "${tempnativedir}"
    # OK, *now* really do the cross-compile
  else
    if [ x"${CONFIGCACHEFILE}" != x ] ; then
      cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
    fi
    ${SRCDIR}/${GHOSTSCRIPT}/configure --prefix=${INSTALLDIR}/${GHOSTSCRIPT} --disable-cups CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${JPEGLIB}/include" LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${JPEGLIB}/lib" CC=${CC} CXX=${CXX} "${CONFIGFLAGS[@]}" --disable-shared --without-jasper 2>&1 | tee -a ${LOGFILE}
  fi
fi
if [ $? -ne 0 ] ; then echo "Error configuring ${GHOSTSCRIPT}" ; exit 1 ; fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${GHOSTSCRIPT}" ; exit 1 ; fi
make install-exec install-so 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${GHOSTSCRIPT}" ; exit 1 ; fi
make clean
fi

if [ ! -d ${INSTALLDIR}/${LIBPNG} ] ; then
LOGFILE=${COMPILEDIR}/log-${LIBPNG}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${LIBPNG} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${LIBPNG}.tgz
fi
cd ${COMPILEDIR}/${LIBPNG}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ${SRCDIR}/${LIBPNG}/configure --prefix=${INSTALLDIR}/${LIBPNG} --disable-shared --enable-static CC=${CC} CXX=${CXX} "${CONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
fi
if [ $? -ne 0 ] ; then echo "Error configuring ${LIBPNG}" ; exit 1 ; fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${LIBPNG}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${LIBPNG}" ; exit 1 ; fi
make clean
fi

if [ ! -d ${INSTALLDIR}/${FREETYPE} ] ; then
LOGFILE=${COMPILEDIR}/log-${FREETYPE}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${FREETYPE} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${FREETYPE}.tgz
fi
cd ${COMPILEDIR}/${FREETYPE}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ${SRCDIR}/${FREETYPE}/configure --prefix=${INSTALLDIR}/${FREETYPE} --disable-shared --enable-static CC=${CC} CXX=${CXX} "${CONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
fi
if [ $? -ne 0 ] ; then echo "Error configuring ${FREETYPE}" ; exit 1 ; fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${FREETYPE}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${FREETYPE}" ; exit 1 ; fi
make clean
fi

if [ ! -d ${INSTALLDIR}/${FONTCONFIG} ] ; then
LOGFILE=${COMPILEDIR}/log-${FONTCONFIG}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${FONTCONFIG} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${FONTCONFIG}.tgz
fi
cd ${COMPILEDIR}/${FONTCONFIG}
if [ ! -f config.log ] ; then
  EXTRACONFIGFLAGS=()
  if [ x"${CROSSTARGET}" != x ] ; then
      EXTRACONFIGFLAGS=( "${EXTRACONFIGFLAGS[@]}" --with-arch="${ARCH}" )
  fi
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  if [ x`uname -s` = xDarwin ] ; then
    ${SRCDIR}/${FONTCONFIG}/configure --prefix=${INSTALLDIR}/${FONTCONFIG} --with-freetype-config=${INSTALLDIR}/${FREETYPE}/bin/freetype-config --with-add-fonts=/usr/X11R6/lib/X11/fonts,/Library/Fonts,/Network/Library/Fonts,/System/Library/Fonts --disable-docs --disable-shared --enable-static CC=${CC} CXX=${CXX} "${CONFIGFLAGS[@]}" "${EXTRACONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
  else
    ${SRCDIR}/${FONTCONFIG}/configure --prefix=${INSTALLDIR}/${FONTCONFIG} --with-freetype-config=${INSTALLDIR}/${FREETYPE}/bin/freetype-config --with-add-fonts=/usr/X11R6/lib/X11/fonts --disable-docs --disable-shared --enable-static CC=${CC} CXX=${CXX} "${CONFIGFLAGS[@]}" "${EXTRACONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
  fi
fi
if [ $? -ne 0 ] ; then echo "Error configuring ${FONTCONFIG}" ; exit 1 ; fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${FONTCONFIG}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${FONTCONFIG}" ; exit 1 ; fi
make clean
fi
#mkdir -p "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/etc/fonts"
#cp "${INSTALLDIR}/${FONTCONFIG}/etc/fonts/fonts.conf" "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/etc/fonts"

if [ ! -d ${INSTALLDIR}/${IMAGEMAGICK} ] ; then
LOGFILE=${COMPILEDIR}/log-${IMAGEMAGICK}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${IMAGEMAGICK} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${IMAGEMAGICK}.tgz
fi
cd ${COMPILEDIR}/${IMAGEMAGICK}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ${SRCDIR}/${IMAGEMAGICK}/configure --prefix=${INSTALLDIR}/${IMAGEMAGICK} --without-x --disable-installed --with-fontconfig --enable-static --disable-ltdl-install --disable-hdri --with-dps --with-bzlib --with-jpeg --with-png --with-zlib --with-modules --with-xml --with-x --without-perl --without-fpx --without-gslib --without-jbig --without-jp2 --without-lcms --without-wmf --without-gvc --without-rsvg --without-lqr --disable-largefile --with-freetype --disable-shared CFLAGS="${CFLAGS}" CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${FONTCONFIG}/include -I${INSTALLDIR}/${JPEGLIB}/include -I${INSTALLDIR}/${GHOSTSCRIPT}/include -I${INSTALLDIR}/${FREETYPE}/include -I${INSTALLDIR}/${FREETYPE}/include/freetype2" LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${FONTCONFIG}/lib -L${INSTALLDIR}/${JPEGLIB}/lib -L${INSTALLDIR}/${GHOSTSCRIPT}/lib -L${INSTALLDIR}/${FREETYPE}/lib" PKG_CONFIG="${INSTALLDIR}/${PKGCONFIG}/bin/pkg-config" PKG_CONFIG_PATH="${INSTALLDIR}/${FONTCONFIG}/lib/pkgconfig" CC=${CC} CXX=${CXX} NM=${NM} AR=${AR} RANLIB=${RANLIB} "${CONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
fi
if [ $? -ne 0 ] ; then echo "Error configuring ${IMAGEMAGICK}" ; exit 1 ; fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${IMAGEMAGICK}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${IMAGEMAGICK}" ; exit 1 ; fi
make clean
fi
mkdir -p "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/bin"
mkdir -p "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/lib"
mkdir -p "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/etc"
cp -r "${INSTALLDIR}/${IMAGEMAGICK}/lib"/* "${INSTALLDIR}/${IMAGEMAGICK}/share" "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/lib"
cp -r "${INSTALLDIR}/${IMAGEMAGICK}/etc"/* "${INSTALLDIR}/${IMAGEMAGICK}/share" "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/etc"
cp "${INSTALLDIR}/${IMAGEMAGICK}/bin/convert" "${INSTALLDIR}/${IMAGEMAGICK}/bin/montage" "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/bin"
cp -a "${INSTALLDIR}/${GHOSTSCRIPT}/lib"/* "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/lib"
cp -a "${INSTALLDIR}/${GHOSTSCRIPT}/bin"/gs "${SRCDIR}/external_binaries/${TARGET}.${ARCH}/bin"

