#!/bin/bash

export AR
export ARCH
export ARFLAGS
export CC
export COMPILEDIR
export CONFIG_FLAGS
export CONFIGCACHEFILE
export CONFIGCACHEFILE_SOURCE
export CXX
export CFLAGS
export CFLAGS_FOR_BUILD
export CPPFLAGS
export CPPFLAGS_FOR_BUILD
export CROSSTARGET
export DLLTOOL
export INSTALLDIR
export LD
export LDFLAGS
export LDFLAGS_FOR_BUILD
export LIBS
export LSBDIR
export NATIVECROSSTARGET
export NM
export PKGCONFIG
export PKG_CONFIG_PATH
export RANLIB
export RELEASEDIR
export SRCDIR
export STRIP
export TARGET
export WINDRES
export XSLTPROC

COMPILE_DCMTK=yes
COMPILE_GSL=yes
COMPILE_MINC=yes
COMPILE_NETCDF=yes
COMPILE_GDOME=yes
COMPILE_LIBXSLT=yes
COMPILE_LIBXML=yes
COMPILE_GLIB=yes
COMPILE_LIBICONV=no
COMPILE_GETTEXT=no
COMPILE_ZLIB=yes

CONFIGFLAGS_GSL=()
CONFIGFLAGS_MINC=()
CONFIGFLAGS_NETCDF=()
CONFIGFLAGS_GDOME=()
CONFIGFLAGS_LIBXSLT=()
CONFIGFLAGS_LIBXML=()
CONFIGFLAGS_LIBICONV=( --disable-shared --enable-static )
CONFIGFLAGS_GETTEXT=( --disable-shared --enable-static )
CONFIGFLAGS_ZLIB=()
CONFIGFLAGS_GLIB=( --disable-shared )
CONFIGFLAGS_XMLHEADER=()

if [ x"${SRCDIR}" = x ] ; then
  SRCDIR=${HOME}/commonlibs
fi
if [ x"${RELEASEDIR}" = x ] ; then
  RELEASEDIR=${HOME}/bxh_xcede_tools_releases
fi
if [ ! -d "${RELEASEDIR}" ] ; then
  mkdir -p "${RELEASEDIR}"
fi

: ${BOOST:=boost_1_47_0}
: ${DCMTK:=dcmtk-3.6.1_20131114}
: ${GLIB:=glib-2.12.13}
: ${ZLIB:=zlib-1.2.5}
: ${LIBXML:=libxml2-2.7.8}
: ${LIBXSLT:=libxslt-1.1.26}
: ${GDOME:=gdome2-0.8.1}
: ${NETCDF:=netcdf-3.6.1}
: ${MINC:=minc-1.4}
: ${GSL:=gsl-1.8}
: ${XMLHEADER:=bxh_xcede_tools-1.11.0beta}

# these dependencies will be compiled on Darwin
: ${PKGCONFIG:=pkg-config-0.23}
: ${LIBICONV:=libiconv-1.13}
: ${GETTEXT:=gettext-0.18.1.1}

if [ x"${IDENTIFIER}" = x ] ; then
  ID=
else
  ID="-${IDENTIFIER}"
fi

NATIVETEST=1
if [ x"${NATIVECROSSTARGET}" != x -a x"${CROSSTARGET}" = x ] ; then
  CROSSTARGET="${NATIVECROSSTARGET}"
fi
DOMAC=0
if [ x"${CROSSTARGET}" != x ] ; then
  if [ x"${NATIVECROSSTARGET}" = x ] ; then
    NATIVETEST=0
  fi
  case "${CROSSTARGET}" in
    *-darwin9)
      TARGET=MacOSX
      ARCH=`echo "${CROSSTARGET}" | cut -d - -f 1`
      DOMAC=1
      CONFIGFLAGS=( "${CONFIGFLAGS[@]}" "--host=${CROSSTARGET}" )
      ;;
    i386-mingw32)
      TARGET=mingw32
      ARCH=i386
      CONFIGFLAGS=( "${CONFIGFLAGS[@]}" "--host=${CROSSTARGET}" )
      ;;
  esac
fi

if [ x"${CROSSTARGET}" != x ] ; then
  if [ -f "${SRCDIR}/cross-aux/${CROSSTARGET}" ] ; then
    . "${SRCDIR}/cross-aux/${CROSSTARGET}"
  fi
elif [ x"${TARGET}" != x -a x"${ARCH}" != x ] ; then
  if [ -f "${SRCDIR}/cross-aux/${TARGET}.${ARCH}" ] ; then
    . "${SRCDIR}/cross-aux/${TARGET}.${ARCH}"
  fi
fi

if [ x"${CROSSBUILD}" != x ] ; then
  CONFIGFLAGS=( "${CONFIGFLAGS[@]}" "--build=${CROSSBUILD}" )
fi

if [ x"${LSBDIR}" = x ] ; then
  LSBDIR=/opt/lsb
fi
if [ x"${CC}" = x ] ; then
  if [ -x "${LSBDIR}"/bin/lsbcc ] ; then
    CC="${LSBDIR}"/bin/lsbcc
  fi
fi
if [ x"${CC}" = x ] ; then
  CC=gcc
fi
if [ x"${CXX}" = x ] ; then
  if [ -x "${LSBDIR}"/bin/lsbc++ ] ; then
    CXX="${LSBDIR}"/bin/lsbc++
  fi
fi
if [ x"${CXX}" = x ] ; then
  CXX=g++
fi

if [ x"${CPPFLAGS}" = x ] ; then
  CPPFLAGS=
fi
if [ x"${LDFLAGS}" = x ] ; then
  LDFLAGS=
fi
if [ x"${PKG_CONFIG_PATH}" = x ] ; then
  PKG_CONFIG_PATH=
fi

if [ x"${TARGET}" = x ] ; then
  if [ x`uname -s` = xDarwin ] ; then
    TARGET=darwin`uname -r | tr -d '.'`
    DOMAC=1
  else
    if [ x"${LSBTARGET}" = x ] ; then
      LSBTARGET=`${CC} --lsb-version | sed 's/LSB version //; s/,.*//;'`
      if [ "${LSBTARGET}" = '' ] ; then
        TARGET=`uname -o | tr '/' '_'`
      fi
    fi
    if [ x"${LSBTARGET}" != x ] ; then
      TARGET=lsb`echo ${LSBTARGET} | sed 's/\.//g;'`
      CPPFLAGS="${CPPFLAGS} --lsb-target-version=${LSBTARGET}"
      LD="${CC}"
      LDFLAGS="${LDFLAGS} --lsb-target-version=${LSBTARGET}"
      # we tell DCMTK to ignore libxml because we don't use it.
      # Note: we may still get "dangerous include path /usr/include/libxml2"
      # because it still adds the include path for some reason.
      CONFIGFLAGS_DCMTK=( "${CONFIGFLAGS_DCMTK[@]}" --without-libxml )
      # even though LSB includes libxml2, it is not new enough for
      # our libxslt, and in any case the LSB-included version does wacky
      # things with libz.  So we leave COMPILE_LIBXML=yes .
    fi
  fi
fi
if [ x"${ARCH}" = x ] ; then
  if [ x`uname -s` = xDarwin ] ; then
    ARCH=`uname -m`
  elif [ -f /etc/slackware-version ] ; then
    ARCH=`uname -m`
  else
    ARCH=`uname -i`
  fi
fi
if [ x"${STRIP}" = x ] ; then
  STRIP=strip
fi

if [ x"${COMPILEDIR}" = x ] ; then
  COMPILEDIR=${HOME}/compile-"${TARGET}.${ARCH}${ID}"
fi
if [ x${INSTALLDIR} = x ] ; then
  INSTALLDIR=${HOME}/install-"${TARGET}.${ARCH}${ID}"
fi
if [ ! -d "${COMPILEDIR}" ] ; then
  mkdir -p "${COMPILEDIR}"
fi
if [ ! -d "${INSTALLDIR}" ] ; then
  mkdir -p "${INSTALLDIR}"
fi

CONFIGCACHEFILE=
if [ x"${CROSSTARGET}" != x -a -f "${SRCDIR}"/cross-aux/"${CROSSTARGET}".cache ] ; then
  CONFIGCACHEFILE_SOURCE="${SRCDIR}"/cross-aux/"${CROSSTARGET}".cache
  CONFIGCACHEFILE="${COMPILEDIR}"/"${CROSSTARGET}".cache
  CONFIGFLAGS=( "${CONFIGFLAGS[@]}" --cache-file="${CONFIGCACHEFILE}" )
fi

if [ $DOMAC -eq 1 ] ; then
  CPPFLAGS="${CPPFLAGS} -DDARWIN -D_DARWIN_C_SOURCE"
  LDFLAGS="${LDFLAGS} -Wl,-framework,CoreFoundation"
fi

PKG_CONFIG=`which pkg-config`
PKG_CONFIG=${PKG_CONFIG:-cant_find_pkg-config}
export PKG_CONFIG

set -o pipefail

if [ ${COMPILEDIR} != ${SRCDIR} ] ; then
  cd ${COMPILEDIR}
  for i in ${GLIB} ${ZLIB} ${LIBXML} ${LIBXSLT} ${GDOME} ${MINC} ${GSL} ${XMLHEADER} ${LIBICONV} ${GETTEXT} ; do
    if [ ! -d ${i} ] ; then
      mkdir ${i}
    fi
  done
  if [ $DOMAC -eq 1 ] ; then
    for i in ${PKGCONFIG} ; do
      if [ ! -d ${i} ] ; then
        mkdir ${i}
      fi
    done
  fi
fi

if [ $DOMAC -eq 1 ] ; then
  COMPILE_LIBICONV=yes
  COMPILE_GETTEXT=yes
  CONFIG_FLAGS="${CONFIGFLAGS[*]}"
  #${SRCDIR}/COMPILE-ImageMagick-Darwin.sh || exit 1
  # don't compile pkg-config if cross-compiling
  if [ x"${CROSSTARGET}" = x -a ! -d ${INSTALLDIR}/${PKGCONFIG} ] ; then
    LOGFILE=${COMPILEDIR}/log-${PKGCONFIG}
    rm -f ${LOGFILE}
    touch ${LOGFILE}
    if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${PKGCONFIG} ] ; then
      tar -C ${COMPILEDIR} -xf ${SRCDIR}/${PKGCONFIG}.tgz
    fi
    cd ${COMPILEDIR}/${PKGCONFIG}
    if [ ! -f config.log ] ; then
      if [ x"${CONFIGCACHEFILE}" != x ] ; then
	cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
      fi
      ${SRCDIR}/${PKGCONFIG}/configure --prefix=${INSTALLDIR}/${PKGCONFIG} CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" "${CONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
      if [ $? -ne 0 ] ; then echo "Error configuring ${PKGCONFIG}" ; exit 1 ; fi
    fi
    make 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error building ${PKGCONFIG}" ; exit 1 ; fi
    make install 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error installing ${PKGCONFIG}" ; exit 1 ; fi
    make clean
    PKG_CONFIG=${INSTALLDIR}/${PKGCONFIG}/bin/pkg-config
  fi

fi

if [ "${COMPILE_LIBICONV}" = yes ] ; then
  if [ ! -d ${INSTALLDIR}/${LIBICONV} ] ; then
    LOGFILE=${COMPILEDIR}/log-${LIBICONV}
    rm -f ${LOGFILE}
    touch ${LOGFILE}
    if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${LIBICONV} ] ; then
      tar -C ${COMPILEDIR} -xf ${SRCDIR}/${LIBICONV}.tgz
    fi
    cd ${COMPILEDIR}/${LIBICONV}
    if [ ! -f config.log ] ; then
      if [ x"${CONFIGCACHEFILE}" != x ] ; then
	cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
      fi
      ${SRCDIR}/${LIBICONV}/configure --prefix=${INSTALLDIR}/${LIBICONV} CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_LIBICONV[@]}" 2>&1 | tee -a ${LOGFILE}
      if [ $? -ne 0 ] ; then echo "Error configuring ${LIBICONV}" ; exit 1 ; fi
    fi
    make 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error building ${LIBICONV}" ; exit 1 ; fi
    make install 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error installing ${LIBICONV}" ; exit 1 ; fi
    make clean
  fi
  CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${LIBICONV}/include"
  LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${LIBICONV}/lib"
  CONFIGFLAGS_GETTEXT=( "${CONFIGFLAGS_GETTEXT[@]}" --with-libiconv-prefix="${INSTALLDIR}/${LIBICONV}" )
fi

if [ "${COMPILE_GETTEXT}" = yes ] ; then
  if [ ! -d ${INSTALLDIR}/${GETTEXT} ] ; then
    LOGFILE=${COMPILEDIR}/log-${GETTEXT}
    rm -f ${LOGFILE}
    touch ${LOGFILE}
    if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${GETTEXT} ] ; then
      tar -C ${COMPILEDIR} -xf ${SRCDIR}/${GETTEXT}.tgz
    fi
    cd ${COMPILEDIR}/${GETTEXT}
    if [ ! -f config.log ] ; then
      if [ x"${CONFIGCACHEFILE}" != x ] ; then
	cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
      fi
#      ${SRCDIR}/${GETTEXT}/configure --prefix=${INSTALLDIR}/${GETTEXT} --with-libiconv-prefix=${INSTALLDIR}/${LIBICONV} --disable-shared --enable-static CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" "${CONFIGFLAGS[@]}" 2>&1 | tee -a ${LOGFILE}
      ( unset CFLAGS ; unset CXXFLAGS ; unset CPPFLAGS ; unset LDFLAGS ; ${SRCDIR}/${GETTEXT}/configure --prefix=${INSTALLDIR}/${GETTEXT}  CC="${CC}" CXX="${CXX}" LD="${LD}" RANLIB="${RANLIB}" NM="${NM}" AR="${AR}" ARFLAGS="${ARFLAGS}" STRIP="${STRIP}" WINDRES="${WINDRES}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_GETTEXT[@]}" ) 2>&1 | tee -a ${LOGFILE}
      if [ $? -ne 0 ] ; then echo "Error configuring ${GETTEXT}" ; exit 1 ; fi
    fi
    make 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error building ${GETTEXT}" ; exit 1 ; fi
    make install 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error installing ${GETTEXT}" ; exit 1 ; fi
    make clean
  fi
  if [ x"${CROSSTARGET}" = x ] ; then
    CONFIGFLAGS_GLIB=( "${CONFIGFLAGS_GLIB[@]}" MSGFMT="${INSTALLDIR}/${GETTEXT}/bin/msgfmt" )
  fi
  CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${GETTEXT}/include"
  LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${GETTEXT}/lib -lintl"
fi

if [ "${COMPILE_ZLIB}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${ZLIB} ] ; then
LOGFILE=${COMPILEDIR}/log-${ZLIB}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${ZLIB} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${ZLIB}.tgz
fi
if [ ${COMPILEDIR} != ${SRCDIR} ] ; then
  cp -r ${SRCDIR}/${ZLIB} ${COMPILEDIR}
fi
cd ${COMPILEDIR}/${ZLIB}
if [ ! -f config.log ] ; then
      if [ x"${CONFIGCACHEFILE}" != x ] ; then
	cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
      fi
  env CHOST="${CROSSTARGET}" CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" ./configure --prefix=${INSTALLDIR}/${ZLIB} --static "${CONFIGFLAGS_ZLIB[@]}" 2>&1 | tee -a ${LOGFILE}
fi
if [ $? -ne 0 ] ; then echo "Error configuring ${ZLIB}" ; exit 1 ; fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${ZLIB}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${ZLIB}" ; exit 1 ; fi
make clean
fi
export CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${ZLIB}/include"
export LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${ZLIB}/lib"
fi

# NOTE: DCMTK uses the ARCH variable for something completely different
# so we make it empty whenever running make on DCMTK
if [ "${COMPILE_DCMTK}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${DCMTK} ] ; then
LOGFILE=${COMPILEDIR}/log-${DCMTK}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${DCMTK} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${DCMTK}.tgz
fi
cd ${COMPILEDIR}
if [ ! -d ${COMPILEDIR}/${DCMTK} ] ; then
  cp -r ${SRCDIR}/${DCMTK} ${COMPILEDIR} 2>&1 | tee -a ${LOGFILE}
fi
cd ${COMPILEDIR}/${DCMTK}
if [ ! -f config/config.log ] ; then
  if [ x"${CROSSTARGET}" != x ] ; then
    # we need to build built-in dictionary natively first
    env CPPFLAGS= LDFLAGS= ${SRCDIR}/${DCMTK}/configure --without-libpng --with-private-tags CC=gcc CXX=g++ RANLIB=ranlib AR=ar  2>&1 | tee -a ${LOGFILE}
    cd ${COMPILEDIR}/${DCMTK}/ofstd
    env ARCH= make 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error building ${DCMTK} ofstd" ; exit 1 ; fi
    cd ${COMPILEDIR}/${DCMTK}/oflog
    env ARCH= make 2>&1 | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error building ${DCMTK} oflog" ; exit 1 ; fi
    cd ${COMPILEDIR}/${DCMTK}/dcmdata/libsrc
    env ARCH= make builtindict | tee -a ${LOGFILE}
    if [ $? -ne 0 ] ; then echo "Error building ${DCMTK} builtindict" ; exit 1 ; fi
    cd ${COMPILEDIR}/${DCMTK}
    env ARCH= make clean | tee -a ${LOGFILE}
  fi
  # we put CPPFLAGS and LDFLAGS in env call because dcmtk's configure script
  # doesn't pass arguments with spaces correctly to the underlying configure
  # script
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  env CPPFLAGS="${CPPFLAGS}" LDFLAGS="${LDFLAGS}" ${SRCDIR}/${DCMTK}/configure --prefix=${INSTALLDIR}/${DCMTK} --without-libpng --with-private-tags CC="${CC}" CXX="${CXX}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_DCMTK[@]}" 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error configuring ${DCMTK}" ; exit 1 ; fi
fi
if [ x"${CROSSTARGET}" = x ] ; then
  cd ${COMPILEDIR}/${DCMTK}/ofstd
  env ARCH= make -j4 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error building ${DCMTK} ofstd" ; exit 1 ; fi
  cd ${COMPILEDIR}/${DCMTK}/oflog
  env ARCH= make 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error building ${DCMTK} oflog" ; exit 1 ; fi
  cd ${COMPILEDIR}/${DCMTK}/dcmdata/libsrc
  (env ARCH= make builtindict && rm dcdictbi.o && env ARCH= make) 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error building ${DCMTK} builtindict" ; exit 1 ; fi
fi
cd ${COMPILEDIR}/${DCMTK}
env ARCH= make -j4 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${DCMTK}" ; exit 1 ; fi
env ARCH= make install install-lib install-include 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${DCMTK}" ; exit 1 ; fi
env ARCH= make clean
fi
CONFIGFLAGS_XMLHEADER=( "${CONFIGFLAGS_XMLHEADER[@]}" --with-dcmtk=${INSTALLDIR}/${DCMTK} )
fi

if [ "${COMPILE_GLIB}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${GLIB} ] ; then
LOGFILE=${COMPILEDIR}/log-${GLIB}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${GLIB} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${GLIB}.tgz
fi
cd ${COMPILEDIR}/${GLIB}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  if [ $DOMAC -eq 1 ] ; then
#    ${SRCDIR}/${GLIB}/configure --prefix=${INSTALLDIR}/${GLIB} --enable-static --disable-shared CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${LIBICONV}/include -I${INSTALLDIR}/${GETTEXT}/include" LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${LIBICONV}/lib -L${INSTALLDIR}/${GETTEXT}/lib" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_GLIB[@]}" 2>&1 | tee -a ${LOGFILE}
    ${SRCDIR}/${GLIB}/configure --prefix=${INSTALLDIR}/${GLIB} --enable-static CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" CPPFLAGS="${CPPFLAGS}" LDFLAGS="${LDFLAGS}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_GLIB[@]}" 2>&1 | tee -a ${LOGFILE}
  else
    ${SRCDIR}/${GLIB}/configure --prefix=${INSTALLDIR}/${GLIB} --enable-static --disable-shared CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_GLIB[@]}" 2>&1 | tee -a ${LOGFILE}
  fi
  if [ $? -ne 0 ] ; then echo "Error configuring ${GLIB}" ; exit 1 ; fi
fi
make -j4 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${GLIB}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${GLIB}" ; exit 1 ; fi
make clean
fi
PKG_CONFIG_PATH="${INSTALLDIR}/${GLIB}/lib/pkgconfig:${PKG_CONFIG_PATH}"
CONFIGFLAGS=( "${CONFIGFLAGS[@]}" --with-glib-prefix="${INSTALLDIR}/${GLIB}" )
fi

if [ "${COMPILE_LIBXML}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${LIBXML} ] ; then
LOGFILE=${COMPILEDIR}/log-${LIBXML}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${LIBXML} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${LIBXML}.tgz
  patch -p 1 < ${SRCDIR}/patches/libxml2-2.7.8-trionan.c
fi
cd ${COMPILEDIR}/${LIBXML}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ${SRCDIR}/${LIBXML}/configure --prefix=${INSTALLDIR}/${LIBXML} --without-zlib --with-python=no --enable-static --disable-shared CC="${CC}" CXX="${CXX}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_LIBXML[@]}" 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error configuring ${LIBXML}" ; exit 1 ; fi
fi
make -j4 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${LIBXML}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${LIBXML}" ; exit 1 ; fi
make clean
fi
PKG_CONFIG_PATH="${INSTALLDIR}/${LIBXML}/lib/pkgconfig:${PKG_CONFIG_PATH}"
CONFIGFLAGS_LIBXSLT=( "${CONFIGFLAGS_LIBXSLT[@]}" --with-libxml-prefix="${INSTALLDIR}/${LIBXML}" --with-xml-prefix=${INSTALLDIR}/${LIBXML} )
CONFIGFLAGS_GDOME=( "${CONFIGFLAGS_GDOME[@]}" --with-libxml-prefix="${INSTALLDIR}/${LIBXML}" --with-xml-prefix=${INSTALLDIR}/${LIBXML} )
CONFIGFLAGS_XMLHEADER=( "${CONFIGFLAGS_XMLHEADER[@]}" --with-xml-prefix=${INSTALLDIR}/${LIBXML} )
fi

if [ "${COMPILE_LIBXSLT}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${LIBXSLT} ] ; then
LOGFILE=${COMPILEDIR}/log-${LIBXSLT}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${LIBXSLT} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${LIBXSLT}.tgz
fi
cd ${COMPILEDIR}/${LIBXSLT}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ${SRCDIR}/${LIBXSLT}/configure --prefix=${INSTALLDIR}/${LIBXSLT} --with-python=no CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" --disable-shared --enable-static --without-crypto "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_LIBXSLT[@]}" 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error configuring ${LIBXSLT}" ; exit 1 ; fi
fi
make -j4 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${LIBXSLT}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${LIBXSLT}" ; exit 1 ; fi
make clean
fi
PKG_CONFIG_PATH="${INSTALLDIR}/${LIBXSLT}/lib/pkgconfig:${PKG_CONFIG_PATH}"
PATH=${INSTALLDIR}/${LIBXSLT}/bin:${PATH} 
fi

if [ "${COMPILE_GDOME}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${GDOME} ] ; then
LOGFILE=${COMPILEDIR}/log-${GDOME}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${GDOME} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${GDOME}.tgz
fi
cd ${COMPILEDIR}/${GDOME}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  if [ $DOMAC -eq 1 ] ; then
    env LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${GETTEXT}/lib" CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" ${SRCDIR}/${GDOME}/configure --disable-shared --prefix=${INSTALLDIR}/${GDOME} "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_GDOME[@]}" 2>&1 | tee -a ${LOGFILE}
  else
    env CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" ${SRCDIR}/${GDOME}/configure  --prefix=${INSTALLDIR}/${GDOME} --disable-shared "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_GDOME[@]}" 2>&1 | tee -a ${LOGFILE}
  fi
  if [ $? -ne 0 ] ; then echo "Error configuring ${GDOME}" ; exit 1 ; fi
fi
( cd "${COMPILEDIR}/${GDOME}"/libgdome && env HOST_CC=gcc make ) 2>&1 | tee -a ${LOGFILE} 
if [ $? -ne 0 ] ; then echo "Error building ${GDOME}/libgdome" ; exit 1 ; fi
( cd "${COMPILEDIR}/${GDOME}"/gtk-doc && env HOST_CC=gcc make ) 2>&1 | tee -a ${LOGFILE} 
if [ $? -ne 0 ] ; then echo "Error building ${GDOME}/gtk-doc" ; exit 1 ; fi
( cd "${COMPILEDIR}/${GDOME}"/libgdome && env HOST_CC=gcc make install ) 2>&1 | tee -a ${LOGFILE} 
if [ $? -ne 0 ] ; then echo "Error installing ${GDOME}/libgdome" ; exit 1 ; fi
( cd "${COMPILEDIR}/${GDOME}"/gtk-doc && env HOST_CC=gcc make install ) 2>&1 | tee -a ${LOGFILE} 
if [ $? -ne 0 ] ; then echo "Error installing ${GDOME}/libgdome" ; exit 1 ; fi
( cd "${COMPILEDIR}/${GDOME}" && env HOST_CC=gcc make install-pkgconfigDATA ) 2>&1 | tee -a ${LOGFILE} 
if [ $? -ne 0 ] ; then echo "Error installing ${GDOME} pkgconfigDATA" ; exit 1 ; fi
make clean
fi
PKG_CONFIG_PATH="${INSTALLDIR}/${GDOME}/lib/pkgconfig:${PKG_CONFIG_PATH}"
fi

if [ "${COMPILE_NETCDF}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${NETCDF} ] ; then
LOGFILE=${COMPILEDIR}/log-${NETCDF}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${NETCDF} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${NETCDF}.tgz
fi
cd ${COMPILEDIR}
if [ ! -d ${COMPILEDIR}/${NETCDF} ] ; then
  cp -r ${SRCDIR}/${NETCDF} ${COMPILEDIR} 2>&1 | tee -a ${LOGFILE}
fi
cd ${COMPILEDIR}/${NETCDF}/src
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ./configure --prefix=${INSTALLDIR}/${NETCDF} CC="${CC}" CXX= CPPFLAGS="${CPPFLAGS}" CFLAGS="-Df2cFortran" --disable-shared --enable-static "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_NETCDF[@]}" 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error configuring ${NETCDF}" ; exit 1 ; fi
fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${NETCDF}" ; exit 1 ; fi
mkdir ${INSTALLDIR}/${NETCDF}
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${NETCDF}" ; exit 1 ; fi
make clean
fi
fi

if [ "${COMPILE_MINC}" = yes ] ; then
if [ 1 -eq 0  -a ! -d ${INSTALLDIR}/${MINC} ] ; then
LOGFILE=${COMPILEDIR}/log-${MINC}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${MINC} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${MINC}.tgz
fi
cd ${COMPILEDIR}/${MINC}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ${SRCDIR}/${MINC}/configure --prefix=${INSTALLDIR}/${MINC} CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" --disable-dependency-tracking --disable-shared --enable-static CPPFLAGS="${CPPFLAGS} -I${INSTALLDIR}/${NETCDF}/include" LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${NETCDF}/lib" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_MINC[@]}" 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error configuring ${MINC}" ; exit 1 ; fi
fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${MINC}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${MINC}" ; exit 1 ; fi
make clean
fi
fi

if [ "${COMPILE_GSL}" = yes ] ; then
if [ ! -d ${INSTALLDIR}/${GSL} ] ; then
LOGFILE=${COMPILEDIR}/log-${GSL}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${GSL} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${GSL}.tgz
fi
cd ${COMPILEDIR}/${GSL}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  ${SRCDIR}/${GSL}/configure --prefix ${INSTALLDIR}/${GSL} CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" --enable-static --disable-shared "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_GSL[@]}" 2>&1 | tee -a ${LOGFILE}
  if [ $? -ne 0 ] ; then echo "Error configuring ${GSL}" ; exit 1 ; fi
fi
make -j4 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${GSL}" ; exit 1 ; fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${GSL}" ; exit 1 ; fi
make clean
fi
CONFIGFLAGS=( "${CONFIGFLAGS[@]}" --with-gsl=${INSTALLDIR}/${GSL} )
fi

if [ ! -d ${INSTALLDIR}/${XMLHEADER} ] ; then
LOGFILE=${COMPILEDIR}/log-${XMLHEADER}
rm -f ${LOGFILE}
touch ${LOGFILE}
if [ ${COMPILEDIR} = ${SRCDIR} -a ! -d ${SRCDIR}/${XMLHEADER} ] ; then
  tar -C ${COMPILEDIR} -xf ${SRCDIR}/${XMLHEADER}.tgz
fi
cd ${COMPILEDIR}/${XMLHEADER}
if [ ! -f config.log ] ; then
  if [ x"${CONFIGCACHEFILE}" != x ] ; then
    cp "${CONFIGCACHEFILE_SOURCE}" "${CONFIGCACHEFILE}"
  fi
  if [ $DOMAC -eq 1 ] ; then
    ${SRCDIR}/${XMLHEADER}/configure LDFLAGS="${LDFLAGS} -L${INSTALLDIR}/${GETTEXT}/lib" --prefix=${INSTALLDIR}/${XMLHEADER} CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_XMLHEADER[@]}" 2>&1 | tee -a ${LOGFILE}
  else
    ${SRCDIR}/${XMLHEADER}/configure --prefix=${INSTALLDIR}/${XMLHEADER} CC="${CC}" CXX="${CXX}" CPPFLAGS="${CPPFLAGS}" "${CONFIGFLAGS[@]}" "${CONFIGFLAGS_XMLHEADER[@]}" 2>&1 | tee -a ${LOGFILE}
  fi
  if [ $? -ne 0 ] ; then echo "Error configuring ${XMLHEADER}" ; exit 1 ; fi
fi
make 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error building ${XMLHEADER}" ; exit 1 ; fi
if [ ! -d bxhtestdata ] ; then
  mkdir bxhtestdata && pushd bxhtestdata && ln -s ${SRCDIR}/bxhtestdata/* . && rm convert && mkdir convert && for i in `ls ${SRCDIR}/bxhtestdata/convert` ; do mkdir convert/${i} ; ln -s ${SRCDIR}/bxhtestdata/convert/${i}/* convert/${i} ; done && popd
fi
# we'll skip eventstats and qa tests for now until we can figure out how to compare the outputs reliably and portably
#runvalgrindopts=
runvalgrindopts="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23"
if [ "${ARCH}" = 'x86_64' ] ; then
  # we skip eventstats and qa tests because 64-bit operations make the image files slightly different
  runvalgrindopts="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23"
fi
if [ $NATIVETEST = 0 -a x"${CROSSTARGET}" != x ] ; then
  # see if there is a cross-testing environment available
  if [ "${CROSSTEST_HOST}" != "" -a "${CROSSTEST_KEY}" != "" ] ; then
    turnoffvm=0
    if [ "${CROSSTEST_VMTYPE}" = "VBox" -a "${CROSSTEST_VM}" != "" ] ; then
      VBoxManage list vms | grep "^\"${CROSSTEST_VM}\""
      if [ $? -ne 0 ] ; then
        echo "WARNING: specified VM '${CROSSTEST_VM}' does not exist!  Will not test" 1>&2
      else
        ( VBoxManage list runningvms | grep "^\"${CROSSTEST_VM}\"" ) || ( turnoffvm=1 ; VBoxManage startvm "${CROSSTEST_VM}" ) | tee -a "${LOGFILE}"
        if [ $? -ne 0 ] ; then echo "ERROR: can't find or start VM '${CROSSTEST_VM}'" | tee -a "${LOGFILE}" 1>&2 ; exit 1 ; fi
        sleep 15s
      fi
    fi
    ssh -i "${CROSSTEST_KEY}" "${CROSSTEST_USER}@${CROSSTEST_HOST}" env TARGET="'${TARGET}'" ARCH="'${ARCH}'" COMPILEDIR="'${CROSSTEST_COMPILEDIR}'" XMLHEADER="'${XMLHEADER}'" SRCDIR="'${CROSSTEST_SRCDIR}'" bash <<'EOF'
mkdir -p "${SRCDIR}"
mkdir -p "${SRCDIR}"/external_binaries
EOF
    rsync -avL -e "ssh -i '${CROSSTEST_KEY}'" "${SRCDIR}/bxhtestdata" "${CROSSTEST_USER}@${CROSSTEST_HOST}":${CROSSTEST_SRCDIR}
    rsync -avL -e "ssh -i '${CROSSTEST_KEY}'" "${SRCDIR}/external_binaries/${TARGET}.${ARCH}" "${CROSSTEST_USER}@${CROSSTEST_HOST}":${CROSSTEST_SRCDIR}/external_binaries
    rsync -avL --exclude 'bxhtestdata' -e "ssh -i '${CROSSTEST_KEY}'" --exclude '*.svn*' --exclude '*.o' "${COMPILEDIR}/${XMLHEADER}" "${CROSSTEST_USER}@${CROSSTEST_HOST}":"${CROSSTEST_COMPILEDIR}"
    if [ $? -ne 0 ] ; then echo "ERROR: copying from '${COMPILEDIR}/${XMLHEADER}' to '${CROSSTEST_HOST}:${CROSSTEST_COMPILEDIR}'" | tee -a "${LOGFILE}" 1>&2 ; exit 1 ; fi
    ssh -i "${CROSSTEST_KEY}" "${CROSSTEST_USER}@${CROSSTEST_HOST}" env TARGET="'${TARGET}'" ARCH="'${ARCH}'" COMPILEDIR="'${CROSSTEST_COMPILEDIR}'" XMLHEADER="'${XMLHEADER}'" SRCDIR="'${CROSSTEST_SRCDIR}'" runvalgrindopts="'${runvalgrindopts}'" bash <<'EOF' 2>&1 | tee -a "${LOGFILE}"
cd ${COMPILEDIR}/${XMLHEADER} &&
  rm -rf bxhtestdata &&
  mkdir bxhtestdata &&
  pushd bxhtestdata &&
  ln -s ${SRCDIR}/bxhtestdata/* . &&
  rm -rf convert &&
  mkdir convert &&
  ( for i in `ls ${SRCDIR}/bxhtestdata/convert` ; do
      mkdir convert/${i}
      ln -s ${SRCDIR}/bxhtestdata/convert/${i}/* convert/${i}
    done ) &&
  popd &&
  pushd bxhtestdata &&
  env PATH="${PATH}":"${SRCDIR}/external_binaries/${TARGET}.${ARCH}/bin":"${SRCDIR}/external_binaries/${TARGET}.${ARCH}/test_bin" ./runvalgrind.sh ${runvalgrindopts} &&
  popd
EOF
    if [ $? -ne 0 ] ; then echo "ERROR: testing failed" | tee -a "${LOGFILE}" 1>&2 ; exit 1 ; fi
    if [ "${turnoffvm}" -eq 1 ] ; then
      VBoxManage controlvm "${CROSSTEST_VM}" savestate
      if [ $? -ne 0 ] ; then echo "Warning: can't save state for VM '${CROSSTEST_VM}'" | tee -a "${LOGFILE}" 1>&2 ; fi
    fi
  fi
else
#  pushd bxhtestdata && env PATH="${PATH}":"${SRCDIR}/external_binaries/${TARGET}.${ARCH}/bin":"${SRCDIR}/external_binaries/${TARGET}.${ARCH}/test_bin" ./runvalgrind.sh ${runvalgrindopts} 2>&1 | tee -a ${LOGFILE} && popd
#  if [ $? -ne 0 ] ; then echo "Error testing ${XMLHEADER}" ; exit 1 ; fi
  echo
fi
make install 2>&1 | tee -a ${LOGFILE}
if [ $? -ne 0 ] ; then echo "Error installing ${XMLHEADER}" ; exit 1 ; fi
fi
if [ ! -f "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}.tgz" ] ; then
rm -rf "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}"
#cp -r ${SRCDIR}/bxh_xcede_tools-container ${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}
mkdir "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}"
mkdir "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}"/bin
mkdir "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}"/lib
mkdir "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}"/share
mkdir "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}"/etc
for subdir in bin lib share etc ; do
  if [ -d "${SRCDIR}/external_binaries/${TARGET}.${ARCH}${ID}/${subdir}" ] ; then
    cp -r "${SRCDIR}/external_binaries/${TARGET}.${ARCH}${ID}/${subdir}"/* "${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}/${subdir}"
  fi
done
cp -r ${INSTALLDIR}/${XMLHEADER}/bin/* ${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}/bin
cp -r ${INSTALLDIR}/${XMLHEADER}/lib/* ${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}/lib
"${STRIP}" ${INSTALLDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}/bin/*
cd ${INSTALLDIR}
if [ "${TARGET}" = 'mingw32' ] ; then
    rm -f ${RELEASEDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}.zip
    zip -r ${RELEASEDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}.zip ${XMLHEADER}-${TARGET}.${ARCH}${ID}
else
    tar cvzf ${RELEASEDIR}/${XMLHEADER}-${TARGET}.${ARCH}${ID}.tgz ${XMLHEADER}-${TARGET}.${ARCH}${ID}
fi
rm -rf ${XMLHEADER}-${TARGET}.${ARCH}${ID}
fi
