#!/bin/bash

dryrun=0

if [ ! -d .svn ] ; then
  echo "ERROR: this script must be run from a directory checked out with subversion (SVN)" 1>&2
  exit 1
fi
if [ ! -f XMLH_VERSION ] ; then
  echo "ERROR: cannot find file XMLH_VERSION (must be in current working directory)" 1>&2
fi

if [ $# -ne 1 ] ; then
  echo "ERROR: provide a single argument with a release number (i.e. 1.9.8.4)" 1>&2
  exit 1
fi

if echo $1 | egrep -v -e '^[0-9][0-9.]*(alpha|beta)?$' ; then
  echo "ERROR: argument should be composed of only digits (0-9) and dots (.), followed optionally by 'alpha' or 'beta'" 1>&2
  exit 1
fi

newversion=$1
oldversion=`cat XMLH_VERSION`

newcomps=(`echo $newversion | tr '.' '\n'`)
oldcomps=(`echo $oldversion | tr '.' '\n'`)

ask=0
tagexists=0
compind=0
if [ $newversion = $oldversion ] ; then
  echo "WARNING: new version $newversion is the same as old version $oldversion"
  ask=1
else
  while (( $compind < ${#oldcomps[@]} && $compind < ${#newcomps[@]} )) ; do
    oldcomp="${oldcomps[$compind]}"
    newcomp="${newcomps[$compind]}"
    # 0==alpha, 1==beta, 2==<none>
    oldalphabeta=2
    newalphabeta=2
    oldcompnum="${oldcomp%alpha}"
    if [ "${oldcomp}" != "${oldcompnum}" ] ; then
	oldalphabeta=0
    else
	oldcompnum="${oldcomp%beta}"
	if [ "${oldcomp}" != "${oldcompnum}" ] ; then
	    oldalphabeta=1
	fi
    fi
    newcompnum="${newcomp%alpha}"
    if [ "${newcomp}" != "${newcompnum}" ] ; then
	newalphabeta=0
    else
	newcompnum="${newcomp%beta}"
	if [ "${newcomp}" != "${newcompnum}" ] ; then
	    newalphabeta=1
	fi
    fi
    oldseemsnewer=0
    if [ "${oldcompnum}" -lt "${newcompnum}" ] ; then
        break
    elif [ "${oldcompnum}" -gt "${newcompnum}" ] ; then
	oldseemsnewer=1
    elif [ "${oldcompnum}" -eq "${newcompnum}" -a "${oldalphabeta}" -gt "${newalphabeta}" ] ; then
	oldseemsnewer=1
    fi
    if [ "${oldseemsnewer}" != 0 ] ; then
      echo "WARNING: new version $newversion seems older than old version $oldversion"
      ask=1
      break
    fi
    ((compind++))
  done
fi
numuncommitted=`svn status -q . | wc -l`
if [ $numuncommitted -gt 0 ] ; then
  echo "WARNING: there seem to be one or more uncommitted files in the local directory:"
  svn status -q .
  ask=1
fi
svnurlbase='https://www.nitrc.org/svn/bxh_xcede_tools'
releasetag=RELEASE_`echo $newversion | tr '.' '_'`
svnurl="${svnurlbase}/tags/${releasetag}/bxh_xcede_tools"
if svn ls "${svnurl}" >/dev/null 2>&1 ; then
  echo "WARNING: release ${svnurl} seems to exist already!  If you continue, existing release will be deleted and overwritten." 1>&2
  tagexists=1
  ask=1
fi
if [ $ask -eq 1 ] ; then
  resp=
  while [ "$resp" != y -a "$resp" != n ] ; do
    read -p "Do you wish to continue? (y/n) " resp
  done
  if [ $resp = n ] ; then
    exit 1
  fi
fi

if [ $tagexists -eq 1 ] ; then
  cmd=(svn delete -m "'Overwriting version ${newversion}'" "'${svnurl}'")
  echo "${cmd[@]}"
  if [ $dryrun = 0 ] ; then
    eval "${cmd[@]}"
    if [ $? != 0 ] ; then
      echo " ... command failed.  Exiting."
    fi
  fi
fi
cmd=(echo -n "'${newversion}'" '>' XMLH_VERSION)
echo "${cmd[@]}"
if [ $dryrun = 0 ] ; then
  eval "${cmd[@]}"
  if [ $? != 0 ] ; then
    echo " ... command failed.  Exiting."
  fi
fi
cmd=(svn commit -m "'Version bump to ${newversion}'" XMLH_VERSION)
echo "${cmd[@]}"
if [ $dryrun = 0 ] ; then
  eval "${cmd[@]}"
  if [ $? != 0 ] ; then
    echo " ... command failed.  Exiting."
  fi
fi
cmd=(svn copy -m "'Version bump to ${newversion}'" --parents . "'${svnurl}'")
echo "${cmd[@]}"
if [ $dryrun = 0 ] ; then
  eval "${cmd[@]}"
  if [ $? != 0 ] ; then
    echo " ... command failed.  Exiting."
  fi
fi

if [ -d ${HOME}/commonlibs ] ; then
  svn checkout "${svnurl}" "${HOME}/commonlibs/bxh_xcede_tools-${newversion}"
fi


