<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:param name="rootpath"/>

  <xsl:output
    method="html"
    indent="yes"
    encoding="iso-8859-1"
    omit-xml-declaration="yes"
    />

  <xsl:template match="/">
    <xsl:apply-templates select="/xhtml:html/xhtml:body"/>
  </xsl:template>

  <xsl:template match="/xhtml:html/xhtml:body">
    <xsl:text disable-output-escaping="yes"><![CDATA[<%@ LANGUAGE="VBScript" %>
<%
PathToRoot = "]]></xsl:text>
    <xsl:value-of select="$rootpath"/>
    <xsl:text disable-output-escaping="yes"><![CDATA["
PageTitle = "]]></xsl:text>
    <xsl:value-of select="/xhtml:html/xhtml:head/xhtml:title"/>
    <xsl:text disable-output-escaping="yes"><![CDATA["
%>
<!-- #include file="]]></xsl:text>
    <xsl:value-of select="$rootpath"/>
    <xsl:text disable-output-escaping="yes"><![CDATA[_inc_header.asp" -->
]]></xsl:text>
    <xsl:for-each select="child::* | child::text() | child::comment()">
      <xsl:call-template name="node" />
    </xsl:for-each>
    <xsl:text disable-output-escaping="yes"><![CDATA[
<!-- #include file="]]></xsl:text>
    <xsl:value-of select="$rootpath"/>
    <xsl:text disable-output-escaping="yes"><![CDATA[_inc_footer.asp" -->
]]></xsl:text>
  </xsl:template>

  <xsl:template name="node">
    <xsl:choose>
      <xsl:when test="self::text()">
        <xsl:value-of select="."/>
      </xsl:when>
      <xsl:when test="self::comment()">
        <xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text disable-output-escaping="yes">--&gt;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:for-each select="attribute::*">
          <xsl:value-of select="concat(' ', name(.), '=&quot;', string(.), '&quot;')"/>
        </xsl:for-each>
        <xsl:choose>
          <xsl:when test="child::* | child::text() | child::comment()">
            <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <xsl:for-each select="child::* | child::text() | child::comment()">
              <xsl:call-template name="node" />
            </xsl:for-each>
            <xsl:text disable-output-escaping="yes">&lt;/</xsl:text>
            <xsl:value-of select="name(.)"/>
            <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">/&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
