<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<!--
  This style sheet can be used to transform a "finite-level" RELAX NG schema
  (i.e. one that does not permit arbitrary levels of element nesting)
  into a HTML file
-->
<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  exclude-result-prefixes="rng a"
  xmlns:rng="http://relaxng.org/ns/structure/1.0"
  xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0">
  <xsl:output
    method="xml"
    indent="yes"
    omit-xml-declaration="no"
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
    />
  <xsl:param name="title"/>

  <xsl:template match="/">
    <html xml:lang="en" lang="en">
      <head>
        <meta http-equiv="Content-type" content="text/html; charset=utf-8"/>
        <title><xsl:value-of select="$title"/></title>
        <link rel="stylesheet" type="text/css" href="rng2html.css"/>
      </head>
      <body>
        <script type="text/javascript">
          <xsl:comment>
            <![CDATA[
              function hide(id) { document.getElementById(id).style.display = 'none'; }
              function show(id) { document.getElementById(id).style.display = ''; }
            ]]>
          </xsl:comment>
        </script>
        <h1><xsl:value-of select="$title"/></h1>
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="'/'"/>
            <xsl:with-param name="refid" select="'ID-'"/>
          </xsl:call-template>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="collapsebuttons">
    <xsl:param name="id"/>
    <a href="javascript:;">
      <xsl:attribute name="class">
        <xsl:value-of select="'collapse'"/>
      </xsl:attribute>
      <span class="collapse">
        <xsl:attribute name="id">
          <xsl:value-of select="concat($id,'c')"/>
        </xsl:attribute>
        <xsl:attribute name="onclick"><![CDATA[hide(']]><xsl:value-of select="$id"/><![CDATA[');hide(']]><xsl:value-of select="concat($id,'c')"/><![CDATA[');show(']]><xsl:value-of select="concat($id,'e')"/><![CDATA[');]]></xsl:attribute>
        <xsl:value-of select="'-'"/>
      </span>
    </a>
    <a href="javascript:;">
      <xsl:attribute name="class">
        <xsl:value-of select="'expand'"/>
      </xsl:attribute>
      <span class="expand" style="display:none">
        <xsl:attribute name="id">
          <xsl:value-of select="concat($id,'e')"/>
        </xsl:attribute>
        <xsl:attribute name="onclick"><![CDATA[show(']]><xsl:value-of select="$id"/><![CDATA[');hide(']]><xsl:value-of select="concat($id,'e')"/><![CDATA[');show(']]><xsl:value-of select="concat($id,'c')"/><![CDATA[');]]></xsl:attribute>
        <xsl:value-of select="'+'"/>
      </span>
    </a>
  </xsl:template>

  <xsl:template name="expandtypename">
    <xsl:param name="type" select="''"/>
    <xsl:choose>
      <xsl:when test="$type = 'int'">
        <xsl:value-of select="'32-bit integer'"/>
      </xsl:when>
      <xsl:when test="$type = 'unsignedInt'">
        <xsl:value-of select="'32-bit unsigned integer'"/>
      </xsl:when>
      <xsl:when test="$type = 'long'">
        <xsl:value-of select="'64-bit integer'"/>
      </xsl:when>
      <xsl:when test="$type = 'unsignedLong'">
        <xsl:value-of select="'64-bit unsigned integer'"/>
      </xsl:when>
      <xsl:when test="$type = 'float'">
        <xsl:value-of select="'32-bit float'"/>
      </xsl:when>
      <xsl:when test="$type = 'double'">
        <xsl:value-of select="'64-bit float'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$type"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="type2example">
    <xsl:param name="bracketsok" select="''"/>
    <xsl:choose>
      <xsl:when test="self::rng:group">
        <xsl:for-each select="*">
          <xsl:call-template name="type2example"/>
          <xsl:value-of select="' '"/>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="self::rng:interleave">
        <xsl:value-of select="'...'"/>
      </xsl:when>
      <xsl:when test="self::rng:choice">
        <xsl:value-of select="'...'"/>
      </xsl:when>
      <xsl:when test="self::rng:optional">
        <xsl:value-of select="'...'"/>
      </xsl:when>
      <xsl:when test="self::rng:zeroOrMore">
        <xsl:value-of select="'...'"/>
      </xsl:when>
      <xsl:when test="self::rng:oneOrMore">
        <xsl:value-of select="'...'"/>
      </xsl:when>
      <xsl:when test="self::rng:list">
        <xsl:value-of select="'list of '"/>
        <xsl:for-each select="*">
          <xsl:call-template name="type2example"/>
        </xsl:for-each>
        <xsl:value-of select="'s'"/>
      </xsl:when>
      <xsl:when test="self::rng:ref">
        <xsl:variable name="name" select="@name"/>
        <xsl:choose>
          <xsl:when test="//rng:define[@name=$name]/rng:data">
            <xsl:for-each select="//rng:define[@name=$name]/rng:data">
              <xsl:call-template name="type2example">
                <xsl:with-param name="bracketsok" select="$bracketsok"/>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'...'"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="self::rng:empty">
        <xsl:value-of select="'empty'"/>
      </xsl:when>
      <xsl:when test="self::rng:text">
        <b>
          <xsl:if test="$bracketsok">
            <xsl:value-of select="'['"/>
          </xsl:if>
          <xsl:value-of select="'text'"/>
          <xsl:if test="$bracketsok">
            <xsl:value-of select="']'"/>
          </xsl:if>
        </b>
      </xsl:when>
      <xsl:when test="self::rng:value">
        <span class="exampleliteral">
          <xsl:value-of select="string(.)"/>
        </span>
      </xsl:when>
      <xsl:when test="self::rng:data">
        <xsl:variable name="type" select="normalize-space(string(@type))"/>
        <b>
          <xsl:if test="$bracketsok">
            <xsl:value-of select="'['"/>
          </xsl:if>
          <xsl:call-template name="expandtypename">
            <xsl:with-param name="type" select="$type"/>
          </xsl:call-template>
          <xsl:if test="$bracketsok">
            <xsl:value-of select="']'"/>
          </xsl:if>
        </b>
      </xsl:when>
      <xsl:when test="self::rng:notAllowed">
        <xsl:value-of select="'not allowed'"/>
      </xsl:when>
      <xsl:when test="self::rng:externalRef">
        <xsl:element name="a">
          <xsl:attribute name="href">
            <xsl:value-of select="string(@href)"/>
          </xsl:attribute>
          <xsl:value-of select="string(@href)"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'...'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="type2content">
    <xsl:param name="bracketsok" select="''"/>
    <xsl:param name="startedprinting" select="'yes'"/>
    <xsl:variable name="needtoprint" select="self::rng:group | self::rng:interleave | self::rng:choice | self::rng:optional | self::rng:zeroOrMore | self::rng:oneOrMore | self::rng:value | self::rng:notAllowed"/>
    <xsl:choose>
      <xsl:when test="not($startedprinting) and $needtoprint">
        <p>
          <xsl:value-of select="'Valid content: '"/>
          <xsl:call-template name="type2content"/>
          <xsl:value-of select="'.'"/>
        </p>
      </xsl:when>
      <xsl:when test="$needtoprint or $startedprinting">
        <xsl:choose>
          <xsl:when test="self::rng:group">
            <xsl:for-each select="*">
              <xsl:call-template name="type2content"/>
              <xsl:value-of select="' '"/>
            </xsl:for-each>
          </xsl:when>
          <xsl:when test="self::rng:interleave">
            <xsl:value-of select="'any interleaving of '"/>
            <xsl:for-each select="*">
              <xsl:call-template name="type2content"/>
              <xsl:if test="last() > 2 and position() != last()">
                <xsl:value-of select="', '"/>
              </xsl:if>
              <xsl:if test="position() = last() - 1">
                <xsl:value-of select="' and '"/>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:when test="self::rng:choice">
            <xsl:value-of select="'either '"/>
            <xsl:for-each select="*">
              <xsl:call-template name="type2content"/>
              <xsl:if test="last() > 2 and position() != last()">
                <xsl:value-of select="', '"/>
              </xsl:if>
              <xsl:if test="position() = last() - 1">
                <xsl:value-of select="' or '"/>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:when test="self::rng:optional">
            <xsl:value-of select="'('"/>
            <xsl:for-each select="*">
              <xsl:call-template name="type2content"/>
            </xsl:for-each>
            <xsl:value-of select="')'"/>
            <xsl:value-of select="'?'"/>
          </xsl:when>
          <xsl:when test="self::rng:zeroOrMore">
            <xsl:value-of select="'('"/>
            <xsl:for-each select="*">
              <xsl:call-template name="type2content"/>
            </xsl:for-each>
            <xsl:value-of select="')'"/>
            <xsl:value-of select="'*'"/>
          </xsl:when>
          <xsl:when test="self::rng:oneOrMore">
            <xsl:value-of select="'('"/>
            <xsl:for-each select="*">
              <xsl:call-template name="type2content"/>
            </xsl:for-each>
            <xsl:value-of select="')'"/>
            <xsl:value-of select="'+'"/>
          </xsl:when>
          <xsl:when test="self::rng:list">
            <xsl:value-of select="'list of '"/>
            <xsl:for-each select="*">
              <xsl:call-template name="type2content"/>
            </xsl:for-each>
            <xsl:value-of select="'s'"/>
          </xsl:when>
          <xsl:when test="self::rng:ref">
            <xsl:variable name="name" select="@name"/>
            <xsl:choose>
              <xsl:when test="//rng:define[@name=$name]/rng:data">
                <xsl:for-each select="//rng:define[@name=$name]/rng:data">
                  <xsl:call-template name="type2example">
                    <xsl:with-param name="bracketsok" select="$bracketsok"/>
                  </xsl:call-template>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="'...'"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="self::rng:empty">
            <xsl:value-of select="'empty'"/>
          </xsl:when>
          <xsl:when test="self::rng:text">
            <b>
              <xsl:if test="$bracketsok">
                <xsl:value-of select="'['"/>
              </xsl:if>
              <xsl:value-of select="'text'"/>
              <xsl:if test="$bracketsok">
                <xsl:value-of select="']'"/>
              </xsl:if>
            </b>
          </xsl:when>
          <xsl:when test="self::rng:value">
            <span class="exampleliteral">
              <xsl:value-of select="string(.)"/>
            </span>
          </xsl:when>
          <xsl:when test="self::rng:data">
            <xsl:variable name="type" select="normalize-space(string(@type))"/>
            <b>
              <xsl:if test="$bracketsok">
                <xsl:value-of select="'['"/>
              </xsl:if>
              <xsl:call-template name="expandtypename">
                <xsl:with-param name="type" select="$type"/>
              </xsl:call-template>
              <xsl:if test="$bracketsok">
                <xsl:value-of select="']'"/>
              </xsl:if>
            </b>
          </xsl:when>
          <xsl:when test="self::rng:notAllowed">
            <xsl:value-of select="'not allowed'"/>
          </xsl:when>
          <xsl:when test="self::rng:externalRef">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:value-of select="string(@href)"/>
              </xsl:attribute>
              <xsl:value-of select="string(@href)"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'...'"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="path2exampleaux">
    <xsl:param name="first" select="UNSPECIFIED"/>
    <xsl:param name="rest" select="UNSPECIFIED"/>
    <xsl:param name="indent" select="''"/>
    <xsl:param name="contentnode" select="'UNSPECIFIED'"/>
    <xsl:variable name="opentag" select="concat('&lt;', $first, '&gt;')"/>
    <xsl:variable name="closetag" select="concat('&lt;', '/', $first, '&gt;')"/>
    <xsl:choose>
      <xsl:when test="starts-with($rest, '@')">
        <xsl:value-of select="$indent"/>
        <xsl:value-of select="concat('&lt;', $first, ' ')"/>
        <span class="primaryname">
          <xsl:value-of select="concat(substring-after($rest, '@'), '=')"/>
        </span>
        <xsl:choose>
          <xsl:when test="$contentnode">
            <xsl:for-each select="$contentnode">
              <xsl:value-of select="'&quot;'"/>
              <xsl:call-template name="type2example"/>
              <xsl:value-of select="'&quot;'"/>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'&quot;...&quot;'"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="'&gt;'"/><br/>
        <xsl:value-of select="$indent"/>
        <xsl:value-of select="$closetag"/><br/>
      </xsl:when>
      <xsl:when test="string-length($rest) > 0">
        <xsl:value-of select="$indent"/>
        <xsl:value-of select="$opentag"/><br/>
        <xsl:call-template name="path2example">
          <xsl:with-param name="path" select="$rest"/>
          <xsl:with-param name="indent" select="concat('&nbsp;&nbsp;',$indent)"/>
          <xsl:with-param name="contentnode" select="$contentnode"/>
        </xsl:call-template>
        <xsl:value-of select="$indent"/>
        <xsl:value-of select="$closetag"/><br/>
      </xsl:when>
      <xsl:otherwise>
        <span class="primaryname">
          <xsl:value-of select="$indent"/>
          <xsl:value-of select="$opentag"/><br/>
          <xsl:if test="$contentnode">
            <xsl:value-of select="$indent"/>
            <xsl:value-of select="'&nbsp;&nbsp;'"/>
            <xsl:for-each select="$contentnode">
              <span class="fieldtype">
                <xsl:if test="not(self::rng:value)">
                  <xsl:value-of select="'['"/>
                </xsl:if>
                <xsl:call-template name="type2example"/>
                <xsl:if test="not(self::rng:value)">
                  <xsl:value-of select="']'"/>
                </xsl:if>
              </span>
            </xsl:for-each>
            <br/>
          </xsl:if>
          <xsl:value-of select="$indent"/>
          <xsl:value-of select="$closetag"/><br/>
        </span>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="path2example">
    <xsl:param name="path" select="UNSPECIFIED"/>
    <xsl:param name="indent" select="''"/>
    <xsl:param name="contentnode" select="'UNSPECIFIED'"/>
    <xsl:variable name="normpath" select="normalize-space($path)"/>

    <xsl:choose>
      <xsl:when test="starts-with($normpath, '/')">
        <xsl:call-template name="path2example">
          <xsl:with-param name="path" select="substring-after($normpath, '/')"/>
          <xsl:with-param name="indent" select="$indent"/>
          <xsl:with-param name="contentnode" select="$contentnode"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="contains($normpath, '/')">
        <xsl:call-template name="path2exampleaux">
          <xsl:with-param name="first" select="substring-before($normpath, '/')"/>
          <xsl:with-param name="rest" select="substring-after($normpath, '/')"/>
          <xsl:with-param name="indent" select="$indent"/>
          <xsl:with-param name="contentnode" select="$contentnode"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="string-length($normpath) > 0">
        <xsl:call-template name="path2exampleaux">
          <xsl:with-param name="first" select="$normpath"/>
          <xsl:with-param name="rest" select="''"/>
          <xsl:with-param name="indent" select="$indent"/>
          <xsl:with-param name="contentnode" select="$contentnode"/>
        </xsl:call-template>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="namenode2name">
    <xsl:choose>
      <xsl:when test=". = ../@name">
        <xsl:value-of select="normalize-space(string(.))"/>
      </xsl:when>
      <xsl:when test="self::rng:name">
        <xsl:value-of select="normalize-space(string(.))"/>
      </xsl:when>
      <xsl:when test="self::rng:anyName | self::rng:nsName">
        <xsl:if test="self::rng:anyName">
          <xsl:value-of select="'any name'"/>
        </xsl:if>
        <xsl:if test="self::rng:nsName">
          <xsl:value-of select="'any namespace'"/>
        </xsl:if>
        <xsl:if test="rng:except">
          <xsl:value-of select="' except '"/>
          <xsl:for-each select="rng:except/*">
            <xsl:value-of select="' &quot;'"/>
            <xsl:call-template name="namenode2name"/>
            <xsl:value-of select="'&quot;'"/>
            <xsl:if test="last() > 2 and position() != last()">
              <xsl:value-of select="','"/>
            </xsl:if>
            <xsl:if test="position() = last() - 1">
              <xsl:value-of select="' or '"/>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
      </xsl:when>
      <xsl:when test="self::rng:choice">
        <xsl:value-of select="'either '"/>
        <xsl:for-each select="*">
          <xsl:call-template name="namenode2name"/>
          <xsl:if test="last() > 2 and position() != last()">
            <xsl:value-of select="', '"/>
          </xsl:if>
          <xsl:if test="position() = last() - 1">
            <xsl:value-of select="' or '"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="elementorattributeaux">
    <xsl:param name="path"/>
    <xsl:param name="refid"/>
    <xsl:param name="nameforpath"/>
    <xsl:param name="nameforrefid"/>
    <xsl:param name="auxtype"/>
    <xsl:param name="attchar"/>
    <xsl:param name="attcharforid"/>
    <xsl:param name="cardinality"/>
    <xsl:variable name="newpath" select="concat($path,'/',$attchar,$nameforpath)"/>
    <xsl:variable name="id" select="concat($refid,$attcharforid,$nameforrefid,'-')"/>
    <xsl:variable name="haswildcard" select="rng:anyName | rng:nsName"/>
    <xsl:variable name="children" select="*[not(namespace-uri() != 'http://relaxng.org/ns/structure/1.0' or self::rng:data or (self::rng:ref and //rng:define/@name = @name) or self::rng:value or self::rng:list or self::rng:text or . = ../@name or self::rng:name or self::rng:anyName or self::rng:nsName or self::rng:mixed or self::rng:choice[1][not(../@name or ../rng:name or ../rng:anyName or rng:nsName)])]"/>
    <xsl:variable name="contentnode" select="*[not(self::rng:name) and not(self::rng:anyName) and not(self::rng:nsName) and not(self::rng:choice and not(preceding::rng:choice | ../@name | ../rng:name | ../rng:anyName | ../rng:nsName))][not(descendant-or-self::*[self::rng:element]) and not(*[self::rng:attribute])][not(self::rng:attribute) and not(self::a:documentation)]"/>
    <div>
      <xsl:attribute name="class">
        <xsl:value-of select="$auxtype"/>
      </xsl:attribute>
      <table>
        <xsl:attribute name="class">
          <xsl:value-of select="concat($auxtype, 'header')"/>
        </xsl:attribute>
        <tr>
          <td>
            <xsl:attribute name="class">
              <xsl:value-of select="concat($auxtype, 'title')"/>
            </xsl:attribute>
            <xsl:choose>
              <xsl:when test="$children">
                <xsl:call-template name="collapsebuttons">
                  <xsl:with-param name="id" select="$id"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <span class="collapse">
                  <xsl:value-of select="'&nbsp;'"/>
                </span>
              </xsl:otherwise>
            </xsl:choose>
            <span>
              <xsl:attribute name="class">
                <xsl:value-of select="concat($auxtype, 'label')"/>
              </xsl:attribute>
              <xsl:if test="$haswildcard">
                <xsl:value-of select="'other '"/>
              </xsl:if>
              <xsl:value-of select="$auxtype"/>
              <xsl:if test="$haswildcard">
                <xsl:value-of select="'s'"/>
              </xsl:if>
            </span>
            <xsl:value-of select="'&nbsp;'"/>
            <xsl:for-each select="@name | rng:name | rng:choice[1][not(../@name or ../rng:name or ../rng:anyName or ../rng:nsName)]">
              <span>
                <xsl:attribute name="class">
                  <xsl:value-of select="concat($auxtype, 'name')"/>
                </xsl:attribute>
                <xsl:call-template name="namenode2name"/>
              </span>
            </xsl:for-each>
            <xsl:if test="$cardinality">
              <span>
                <xsl:attribute name="class">
                  <xsl:value-of select="concat($auxtype, 'cardinality')"/>
                </xsl:attribute>
                <xsl:value-of select="concat('[', $cardinality, ']')"/>
              </span>
            </xsl:if>
            <br/>
          </td>
          <td rowspan="2" class="example">
            <xsl:call-template name="path2example">
              <xsl:with-param name="path" select="$newpath"/>
              <xsl:with-param name="contentnode" select="$contentnode"/>
            </xsl:call-template>
          </td>
        </tr>
        <tr>
          <td>
            <xsl:attribute name="class">
              <xsl:value-of select="concat($auxtype, 'doc')"/>
            </xsl:attribute>
            <xsl:for-each select="rng:anyName">
              <p>
                <xsl:value-of select="'Valid names: '"/>
                <xsl:call-template name="namenode2name"/>
                <xsl:value-of select="'.'"/>
              </p>
            </xsl:for-each>
            <xsl:for-each select="rng:nsName">
              <p>
                <xsl:value-of select="'Valid namespaces: '"/>
                <xsl:call-template name="namenode2name"/>
                <xsl:value-of select="'.'"/>
              </p>
            </xsl:for-each>
            <p><i><xsl:value-of select="string(a:documentation)"/></i></p>
            <xsl:if test="$contentnode">
              <xsl:for-each select="$contentnode">
                <xsl:call-template name="type2content">
                  <xsl:with-param name="startedprinting" select="''"/>
                </xsl:call-template>
              </xsl:for-each>
            </xsl:if>
          </td>
        </tr>
      </table>
      <xsl:choose>
        <xsl:when test="$children">
          <table class="subelems">
            <xsl:attribute name="id">
              <xsl:value-of select="$id"/>
            </xsl:attribute>
            <xsl:for-each select="$children">
              <tr class="subelem">
                <td class="subelemspacer">
                  &nbsp;
                </td>
                <td>
                  <div class="subelemcontent">
                    <xsl:choose>
                      <xsl:when test="$haswildcard">
                        <xsl:call-template name="pattern">
                          <xsl:with-param name="path" select="$newpath"/>
                          <xsl:with-param name="refid" select="$id"/>
                          <xsl:with-param name="inwildcard" select="'yes'"/>
                        </xsl:call-template>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:call-template name="pattern">
                          <xsl:with-param name="path" select="$newpath"/>
                          <xsl:with-param name="refid" select="$id"/>
                        </xsl:call-template>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>
                </td>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>

  <xsl:template name="elementorattribute">
    <xsl:param name="path"/>
    <xsl:param name="refid"/>
    <xsl:param name="auxtype"/>
    <xsl:param name="attchar"/>
    <xsl:param name="attcharforid"/>
    <xsl:param name="cardinality"/>
    <xsl:param name="inwildcard"/>
    <xsl:choose>
      <xsl:when test="@name | rng:name">
        <xsl:call-template name="elementorattributeaux">
          <xsl:with-param name="path" select="$path"/>
          <xsl:with-param name="refid" select="$refid"/>
          <xsl:with-param name="nameforpath" select="normalize-space(string(@name | rng:name))"/>
          <xsl:with-param name="nameforrefid" select="normalize-space(string(@name | rng:name))"/>
          <xsl:with-param name="auxtype" select="$auxtype"/>
          <xsl:with-param name="attchar" select="$attchar"/>
          <xsl:with-param name="attcharforid" select="$attcharforid"/>
          <xsl:with-param name="cardinality" select="$cardinality"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="rng:anyName | rng:nsName">
        <xsl:if test="not($inwildcard)">
          <xsl:call-template name="elementorattributeaux">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
            <xsl:with-param name="nameforpath" select="'*'"/>
            <xsl:with-param name="nameforrefid" select="'-'"/>
            <xsl:with-param name="auxtype" select="$auxtype"/>
            <xsl:with-param name="attchar" select="$attchar"/>
            <xsl:with-param name="attcharforid" select="$attcharforid"/>
            <xsl:with-param name="cardinality" select="$cardinality"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:when test="rng:choice">
        <xsl:call-template name="elementorattributeaux">
          <xsl:with-param name="path" select="$path"/>
          <xsl:with-param name="refid" select="$refid"/>
          <xsl:with-param name="nameforpath" select="'*'"/>
          <xsl:with-param name="nameforrefid" select="'-'"/>
          <xsl:with-param name="auxtype" select="$auxtype"/>
          <xsl:with-param name="attchar" select="$attchar"/>
          <xsl:with-param name="attcharforid" select="$attcharforid"/>
          <xsl:with-param name="cardinality" select="$cardinality"/>
        </xsl:call-template>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="grammar">
    <xsl:param name="path"/>
    <xsl:param name="refid"/>
    <xsl:for-each select="*">
      <xsl:choose>
        <xsl:when test="self::rng:start">
          <xsl:for-each select="*">
            <xsl:call-template name="pattern">
              <xsl:with-param name="path" select="'/'"/>
              <xsl:with-param name="refid" select="$refid"/>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:when>
        <xsl:when test="self::rng:define">
          <!-- Will be grabbed when referred to -->
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="pattern">
    <xsl:param name="path"/>
    <xsl:param name="refid"/>
    <xsl:param name="cardinality" select="''"/>
    <xsl:param name="inwildcard" select="''"/>
    <xsl:choose>
      <xsl:when test="self::rng:element">
        <xsl:call-template name="elementorattribute">
          <xsl:with-param name="path" select="$path"/>
          <xsl:with-param name="refid" select="$refid"/>
          <xsl:with-param name="auxtype" select="'element'"/>
          <xsl:with-param name="attchar" select="''"/>
          <xsl:with-param name="attcharforid" select="''"/>
          <xsl:with-param name="cardinality" select="$cardinality"/>
          <xsl:with-param name="inwildcard" select="$inwildcard"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="self::rng:attribute">
        <xsl:call-template name="elementorattribute">
          <xsl:with-param name="path" select="$path"/>
          <xsl:with-param name="refid" select="$refid"/>
          <xsl:with-param name="auxtype" select="'attribute'"/>
          <xsl:with-param name="attchar" select="'@'"/>
          <xsl:with-param name="attcharforid" select="'ATT'"/>
          <xsl:with-param name="cardinality" select="$cardinality"/>
          <xsl:with-param name="inwildcard" select="$inwildcard"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="self::rng:grammar">
        <xsl:call-template name="grammar">
          <xsl:with-param name="path" select="$path"/>
          <xsl:with-param name="refid" select="$refid"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="self::rng:group">
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="self::rng:interleave">
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="self::rng:choice and (not(parent::element | parent::attribute) or preceding::rng:choice or ../@name or ../rng:name or ../rng:nsName or ../rng:choice)">
        <xsl:if test="not($inwildcard) and (.//rng:element | .//rng:attribute)">
          <xsl:variable name="id" select="concat($refid,'c','-')"/>
          <div class="choices">
            <div class="choicesheader">
              <xsl:call-template name="collapsebuttons">
                <xsl:with-param name="id" select="$id"/>
              </xsl:call-template>
              <span class="choicelabel">
                <xsl:value-of select="'CHOICE'"/>
              </span>
            </div>
            <table class="choicescontent">
              <xsl:attribute name="id">
                <xsl:value-of select="$id"/>
              </xsl:attribute>
              <xsl:for-each select="*">
                <tr class="choice">
                  <td class="choicebar">
                    <xsl:choose>
                      <xsl:when test="position() = 1">
                        <img src="images/either.png"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <img src="images/or.png"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                  <td class="choicecontent">
                    <xsl:call-template name="pattern">
                      <xsl:with-param name="path" select="$path"/>
                      <xsl:with-param name="refid" select="$refid"/>
                    </xsl:call-template>
                  </td>
                </tr>
              </xsl:for-each>
            </table>
          </div>
        </xsl:if>
      </xsl:when>
      <xsl:when test="self::rng:optional">
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
            <xsl:with-param name="cardinality" select="'optional'"/>
            <xsl:with-param name="inwildcard" select="$inwildcard"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="self::rng:zeroOrMore">
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
            <xsl:with-param name="cardinality" select="'zero or more'"/>
            <xsl:with-param name="inwildcard" select="$inwildcard"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="self::rng:oneOrMore">
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
            <xsl:with-param name="cardinality" select="'one or more'"/>
            <xsl:with-param name="inwildcard" select="$inwildcard"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="self::rng:mixed">
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
            <xsl:with-param name="inwildcard" select="$inwildcard"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="self::rng:list">
        <xsl:value-of select="'list of '"/>
        <xsl:for-each select="*">
          <xsl:call-template name="pattern">
            <xsl:with-param name="path" select="$path"/>
            <xsl:with-param name="refid" select="$refid"/>
          </xsl:call-template>
        </xsl:for-each>
        <xsl:value-of select="'s'"/>
      </xsl:when>
      <xsl:when test="self::rng:ref">
        <xsl:variable name="name" select="@name"/>
        <xsl:variable name="id" select="concat($refid,'REF',$name,'-')"/>
        <xsl:choose>
          <xsl:when test="contains($refid, concat('-REF', $name, '-'))">
            <xsl:value-of select="'[recursive definition detected]'"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="//rng:define[@name=$name]/*">
              <xsl:call-template name="pattern">
                <xsl:with-param name="path" select="$path"/>
                <xsl:with-param name="refid" select="$id"/>
                <xsl:with-param name="cardinality" select="$cardinality"/>
                <xsl:with-param name="inwildcard" select="$inwildcard"/>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="self::rng:empty">
        <xsl:value-of select="'empty'"/>
      </xsl:when>
      <xsl:when test="self::rng:text">
        <div class="element">
          <table class="elementheader">
            <tr>
              <td class="elementtitle">
                <xsl:value-of select="'text'"/>
              </td>
            </tr>
          </table>
        </div>
      </xsl:when>
      <xsl:when test="self::rng:value">
      </xsl:when>
      <xsl:when test="self::rng:data">
        <xsl:variable name="type" select="normalize-space(string(@type))"/>
        <xsl:choose>
          <xsl:when test="$type = 'int'">
            <xsl:value-of select="'32-bit integer'"/>
          </xsl:when>
          <xsl:when test="$type = 'unsignedInt'">
            <xsl:value-of select="'32-bit unsigned integer'"/>
          </xsl:when>
          <xsl:when test="$type = 'long'">
            <xsl:value-of select="'64-bit integer'"/>
          </xsl:when>
          <xsl:when test="$type = 'unsignedLong'">
            <xsl:value-of select="'64-bit unsigned integer'"/>
          </xsl:when>
          <xsl:when test="$type = 'float'">
            <xsl:value-of select="'32-bit float'"/>
          </xsl:when>
          <xsl:when test="$type = 'double'">
            <xsl:value-of select="'64-bit float'"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$type"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="self::rng:notAllowed">
        <xsl:value-of select="'not allowed'"/>
      </xsl:when>
      <xsl:when test="self::rng:externalRef">
        <xsl:element name="a">
          <xsl:attribute name="href">
            <xsl:value-of select="string(@href)"/>
          </xsl:attribute>
          <xsl:value-of select="string(@href)"/>
        </xsl:element>
      </xsl:when>
      <xsl:when test="self::a:documentation">
        <p><i><xsl:value-of select="string(.)"/></i></p>
      </xsl:when>
      <xsl:otherwise>
        <b>Incorrect grammar (<xsl:value-of select="concat(namespace-uri(.),'-',name(.))"/>)!</b>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
