/* this file stores the DTI tensors used by BIAC */

#ifdef BIAC

#include <limits.h>
#include "biac_dti_tensors.h"

#define DUMMYVAL ((double)ULONG_MAX)

static dti_tensor tensorlist[] = {
    { 6, DUMMYVAL, DUMMYVAL },
    { 0.707, 0.0, 0.707 },
    { -0.707, 0.0, 0.707 },
    { 0.0, 0.707, 0.707 },
    { 0.0, 0.707, -0.707 },
    { 0.707, 0.707, 0.0 },
    { -0.707, 0.707, 0.0 },
    { 7, DUMMYVAL, DUMMYVAL },
    { 1.0, 0.0, 0.0 },
    { 0.333, 0.943, 0.0,  },
    { -0.333, 0.472, 0.817 },
    { 0.577, -0.817, 0.0 },
    { 0.333, -0.472, 0.817 },
    { -0.577, -0.407, 0.707 },
    { 0.577, 0.407, 0.707 },
    { 8, DUMMYVAL, DUMMYVAL },
    { 1.0, 0.0, 0.0 },
    { 0.333, 0.943, 0.0,  },
    { -0.333, 0.472, 0.817 },
    { 0.577, -0.817, 0.0 },
    { 0.333, -0.472, 0.817 },
    { -0.577, -0.407, 0.707 },
    { 0.577, 0.407, 0.707 },
    { 0.0, 1.0, 0.0 },
    { 9, DUMMYVAL, DUMMYVAL },
    { 0.914109572223, -0.182781178690, -0.361931942064 },
    { 0.293329304506, 0.734642489361, -0.611766566546 },
    { -0.480176899428, -0.046026929940, 0.875963279468 },
    { -0.705684904851, 0.704780196051, -0.072757750931 },
    { 0.370605109670, 0.769162968265, 0.520615194684 },
    { -0.904030464226, -0.412626217894, -0.111662545460 },
    { -0.162180419233, -0.247163999394, -0.955304908927 },
    { 0.063327560246, -0.997971078243, -0.006583851785 },
    { 0.610701141906, -0.322016246902, 0.723429092590 },
    { 10, DUMMYVAL, DUMMYVAL },
    { 0.978696890330, 0.074682616274, 0.191245663177 },
    { 0.537258145625, 0.448413180814, -0.714338368164 },
    { -0.227939324473, -0.303819959434, -0.925060590777 },
    { 0.274577116268, 0.833436432027, 0.479573895237 },
    { -0.599426405232, 0.240685139624, 0.763386303437 },
    { -0.424664555168, 0.830194107787, -0.361161679833 },
    { -0.402701180119, -0.893328907767, 0.199487398294 },
    { 0.552788606831, -0.770301636525, -0.317899583084 },
    { 0.290107593166, -0.385278374104, 0.876012647646 },
    { -0.978696887344, -0.074682599351, -0.191245685067 },
    { 11, DUMMYVAL, DUMMYVAL },
    { 0.153486836562, -0.831354332797, 0.534127105044 },
    { 0.092812115769, 0.691598091278, -0.716294626049 },
    { 0.686120068086, 0.724987503180, 0.060269166267 },
    { 0.101393837471, 0.257848797505, 0.960850293931 },
    { -0.143059218646, -0.243142754178, -0.959382958495 },
    { -0.909929380017, 0.200934944687, -0.362841110384 },
    { -0.405338453688, 0.872713317547, 0.272162090194 },
    { 0.896918545883, -0.184616420020, 0.401813264476 },
    { 0.731466092268, -0.415052523977, -0.541007170195 },
    { -0.439821168531, -0.864743799130, -0.242436592901 },
    { -0.773718984882, -0.203685975092, 0.599892453681 },
    { 12, DUMMYVAL, DUMMYVAL },
    { -0.519657468039, 0.854102387855, -0.021569120792 },
    { 0.519657456743, -0.854102395012, 0.021569109539 },
    { -0.118190661273, 0.429081803333, -0.895499734024 },
    { -0.768920201670, 0.071819589916, 0.635298095360 },
    { 0.521506258421, 0.836678341438, -0.167333724625 },
    { 0.119333282457, 0.615878166459, 0.778751341429 },
    { 0.915718081273, 0.043626880273, 0.399445980012 },
    { 0.768920197428, -0.071819593191, -0.635298100124 },
    { 0.118190681568, -0.429081793598, 0.895499736009 },
    { -0.521506259512, -0.836678336747, 0.167333744677 },
    { -0.915718079511, -0.043626889027, -0.399445983095 },
    { -0.119333287884, -0.615878161696, -0.778751344364 },
    { 13, DUMMYVAL, DUMMYVAL },
    { -0.754267365796, 0.173499508397, -0.633228759202 },
    { 0.330321246216, -0.372227441281, 0.867372242037 },
    { -0.533035489131, -0.458931921778, 0.710812674690 },
    { -0.686807855664, -0.708384153523, -0.162747843106 },
    { -0.321357401597, 0.941504078299, -0.101486407881 },
    { 0.617869468935, 0.786068318474, -0.018273424674 },
    { 0.019352413289, 0.576222568464, 0.817063666854 },
    { 0.311368579326, -0.948900371701, 0.051358469549 },
    { -0.882505894394, 0.313694805173, 0.350398224264 },
    { -0.038448968078, -0.536051111410, -0.843309482225 },
    { 0.184148321180, 0.468947287620, -0.863815858410 },
    { 0.936881686583, 0.003852303897, 0.349625321023 },
    { 0.813567705110, -0.236010693892, -0.531419365069 },
    { 14, DUMMYVAL, DUMMYVAL },
    { 0.183504500440, -0.774327848934, -0.605592668948 },
    { 0.153461674965, 0.930458382726, 0.332711154506 },
    { -0.708967620726, -0.280759148895, -0.646946066588 },
    { -0.976939230344, -0.107848809998, 0.184277981311 },
    { 0.372001336525, 0.124628732488, 0.919827529846 },
    { -0.280635908687, -0.474838246429, 0.834129562169 },
    { -0.374884405704, -0.924316474887, 0.071419441413 },
    { 0.609952952660, -0.713378465035, 0.345034144926 },
    { -0.545724577900, 0.497759969260, 0.674106592519 },
    { -0.009781260146, 0.151939133540, -0.988341452459 },
    { 0.836141855120, -0.174860987699, -0.519894636535 },
    { -0.609952964510, 0.713378454079, -0.345034146631 },
    { 0.930390223148, 0.274617378657, 0.242815419632 },
    { 0.421433390542, 0.757547917835, -0.498512837869 },
    { 15, DUMMYVAL, DUMMYVAL },
    { 0.216001983700, -0.898615365314, 0.381881615504 },
    { -0.444561363553, -0.418726663881, 0.791854263732 },
    { -0.635186145240, -0.770065881729, -0.059473512527 },
    { 0.500548727571, -0.192538217024, 0.844026069688 },
    { -0.221229771469, 0.531169628316, -0.817872981685 },
    { -0.891941312897, 0.079142510044, -0.445170930601 },
    { -0.169315707509, 0.513429353508, 0.841262438331 },
    { -0.263965919566, -0.440254059158, -0.858194824444 },
    { 0.598524035730, 0.006919955250, -0.801074960833 },
    { -0.899631198936, 0.223429384229, 0.375157321885 },
    { 0.985305483557, -0.166404497880, 0.038505157549 },
    { 0.627905121857, 0.627079786181, 0.460983838881 },
    { -0.350119335865, 0.936470382954, 0.020968369105 },
    { 0.527048413266, 0.773124394001, -0.352843650184 },
    { 0.420616988873, -0.804160710609, -0.420008214424 },
    { 16, DUMMYVAL, DUMMYVAL },
    { 0.733571208539, -0.509367037098, -0.449909439244 },
    { -0.527936513082, 0.197513112343, 0.825997341768 },
    { 0.210490445990, 0.934016014999, -0.288631002964 },
    { -0.394388830898, 0.876999734693, 0.274461136430 },
    { 0.901500079093, 0.427890594987, -0.064863287901 },
    { -0.126116414468, -0.264945505828, -0.955980401966 },
    { -0.807197676003, -0.422051151370, -0.412679945579 },
    { 0.264549795600, -0.885039709623, 0.383038011218 },
    { -0.616921323093, -0.639391147814, 0.458897636963 },
    { -0.969209372877, 0.238904864368, 0.059646100528 },
    { -0.080651424152, -0.925976042468, -0.368868156063 },
    { 0.393234069013, 0.625539858854, 0.673844827799 },
    { 0.874906967098, -0.244744309460, 0.417897142739 },
    { 0.175293851258, -0.219349658857, 0.959769656152 },
    { -0.509883948542, 0.523218324223, -0.682833028065 },
    { 0.478759086918, 0.286782058057, -0.829786591763 },
    { 17, DUMMYVAL, DUMMYVAL },
    { 0.912696377884, -0.226318895321, 0.340242677244 },
    { -0.937516993909, 0.174499515532, 0.301017948322 },
    { 0.217875182394, 0.779593349993, -0.587166597776 },
    { -0.097521799429, -0.689116202969, -0.718058742333 },
    { -0.529244112066, -0.429928221895, 0.731479592238 },
    { -0.868219130327, -0.253956581808, -0.426264702141 },
    { -0.488636597163, -0.872424666927, 0.010463099477 },
    { -0.090780894434, 0.980271295409, 0.175576241570 },
    { 0.241453202690, -0.865087838370, 0.439685549927 },
    { -0.334318092896, 0.477784149911, 0.812375355889 },
    { 0.278050056752, -0.144343667896, 0.949659450265 },
    { -0.278049987827, 0.144343774391, -0.949659454259 },
    { 0.635522963862, -0.713687640763, -0.294551377228 },
    { 0.573721357879, -0.050347268156, -0.817501655107 },
    { 0.881411428344, 0.431341360377, -0.192505908512 },
    { 0.556850158511, 0.603621752363, 0.570577497838 },
    { -0.673293126781, 0.653755790140, -0.345368979915 },
    { 18, DUMMYVAL, DUMMYVAL },
    { -0.115864955267, 0.878504081289, 0.463471564715 },
    { -0.828166364901, -0.445191611216, 0.340506830107 },
    { 0.253495768810, 0.923311572233, -0.288505867837 },
    { -0.394060866631, -0.892001634136, -0.221470354875 },
    { -0.301636361322, -0.023759230509, 0.953126961372 },
    { 0.641266153580, -0.370493887364, 0.671946426211 },
    { 0.389101298212, 0.376221841256, 0.840866996552 },
    { 0.423305773042, -0.905396870145, -0.032691436801 },
    { -0.095201322600, -0.770256663988, 0.630588122118 },
    { -0.389101207805, -0.376221819797, -0.840867047989 },
    { 0.404032202999, -0.499183509195, -0.766533628152 },
    { -0.131340369752, 0.383991458853, -0.913947628041 },
    { -0.929433392676, -0.008826753533, -0.368884340954 },
    { 0.964071703007, -0.248886818223, -0.092849895935 },
    { 0.827037608987, 0.531769491246, 0.182290980308 },
    { -0.805777212123, 0.401941679568, 0.434932144880 },
    { -0.581600320724, 0.752341956713, -0.309390767645 },
    { 0.669871864060, 0.292136717514, -0.682589059406 },
    { 19, DUMMYVAL, DUMMYVAL },
    { -0.493849369713, 0.150082991549, 0.856497458071 },
    { 0.160995035918, -0.251402381535, 0.954398994639 },
    { 0.216767340524, 0.650955278007, 0.727508863257 },
    { 0.514906117305, -0.792513457502, -0.326793681150 },
    { -0.313466895221, -0.942439288426, -0.116390262620 },
    { 0.027820519392, 0.999490279267, 0.015658874500 },
    { 0.785474997111, 0.078620022781, 0.613879402596 },
    { -0.501855939280, -0.654402699938, 0.565595016353 },
    { -0.028731240581, -0.561058899325, -0.827277116390 },
    { -0.790845401663, -0.362223441679, -0.493313013174 },
    { 0.631801474150, 0.016389327300, -0.774956958297 },
    { 0.402342628259, -0.798230082272, 0.448273516106 },
    { 0.785284752008, 0.617575749685, -0.043909585115 },
    { -0.626007935033, 0.705139068047, 0.333005945877 },
    { -0.979233960994, -0.074186490464, 0.188672240324 },
    { 0.217208195399, 0.709925667115, -0.669944883570 },
    { -0.272097559178, 0.164027352376, -0.948186661983 },
    { 0.974863117801, -0.210944356125, -0.071724334571 },
    { -0.711269733310, 0.555278833773, -0.430999748540 },
    { 20, DUMMYVAL, DUMMYVAL },
    { -0.434938946482, 0.685132899717, -0.584312435739 },
    { -0.474060013098, 0.860976920054, 0.184352507755 },
    { -0.829256490167, -0.550289985613, 0.097542838019 },
    { 0.464421656080, 0.422384590848, -0.778398216068 },
    { 0.240386556712, 0.941384293978, -0.236664138397 },
    { 0.910939837519, -0.098176548471, -0.400686882429 },
    { -0.185116778405, 0.035545557996, -0.982073465510 },
    { 0.266800060066, -0.684012097813, 0.678929435209 },
    { 0.339677264891, 0.071129244772, 0.937848594526 },
    { 0.347081475440, -0.527235773025, -0.775600985720 },
    { -0.403753197462, 0.355548772404, 0.842952208598 },
    { -0.410800740586, -0.675911546523, -0.611871173379 },
    { 0.268568798654, 0.770374026033, 0.578268674928 },
    { -0.865131507158, 0.028438831904, -0.500738163278 },
    { 0.884860772610, -0.185065380644, 0.427518675596 },
    { 0.843316814297, 0.529181929554, 0.093718921021 },
    { -0.464421687775, -0.422384607415, 0.778398188168 },
    { 0.596562711719, -0.798812839696, -0.077530498020 },
    { -0.938578491452, 0.227080195093, 0.259817244193 },
    { -0.156558083055, -0.985288478562, 0.068528684817 },
    { 21, DUMMYVAL, DUMMYVAL },
    { -0.549492281923, -0.499531375822, -0.669721312694 },
    { -0.229274217564, 0.798245119516, 0.556990181538 },
    { 0.051584885924, -0.126471373803, -0.990628079126 },
    { -0.880573755176, -0.472011665596, 0.042365661057 },
    { 0.874734231412, 0.472842236169, -0.106114297292 },
    { 0.464585318035, 0.484632949097, -0.741141947885 },
    { 0.517653358822, 0.668752788677, 0.533670973294 },
    { -0.214762501849, 0.160053900575, 0.963462410637 },
    { 0.178941144896, -0.784300408657, -0.594014255422 },
    { -0.517841089726, -0.483670070722, 0.705623035677 },
    { -0.594929339937, 0.796921583984, -0.104761965723 },
    { 0.586167742727, -0.809073263040, 0.042518612639 },
    { 0.211591983303, -0.690878714671, 0.691314280351 },
    { 0.180352667723, 0.967957510562, -0.174731717191 },
    { 0.511467833181, -0.015518531629, 0.859162284319 },
    { -0.318668087641, 0.525871531163, -0.788612568142 },
    { -0.893219122289, 0.152006707555, -0.423147208943 },
    { -0.254923991529, -0.965694963273, 0.049467124975 },
    { -0.864507633341, 0.245460494780, 0.438606540533 },
    { 0.946614484046, -0.182258255989, 0.265900257086 },
    { 0.793779200124, -0.243314387822, -0.557416083486 },
    { 22, DUMMYVAL, DUMMYVAL },
    { 0.268370018872, -0.725061606257, 0.634242225103 },
    { -0.164287143257, 0.957224109600, -0.238184253388 },
    { 0.957434682736, 0.195909546256, -0.211986504242 },
    { -0.591872052500, 0.738850387217, 0.322160796464 },
    { -0.467436167418, -0.502376750030, 0.727407059644 },
    { 0.704035966340, -0.377129383126, -0.601753094285 },
    { -0.922930714224, 0.021572888337, 0.384361167693 },
    { -0.846507760234, -0.520886911130, -0.110006534704 },
    { 0.467436178435, 0.502376737773, -0.727407061029 },
    { 0.118493974706, -0.139937653967, -0.983044572215 },
    { -0.291271467276, -0.949098924590, 0.119883959279 },
    { 0.461155213711, -0.879338228320, -0.118744048614 },
    { 0.123384179729, 0.777704965935, 0.616401922574 },
    { 0.536066715387, 0.843426372897, -0.035558826703 },
    { -0.633932658146, -0.209698378663, -0.744416533214 },
    { -0.123384160799, -0.777704956507, -0.616401938259 },
    { 0.764649497998, 0.350186218064, 0.540999776238 },
    { 0.875374065824, -0.377879086249, 0.301542104952 },
    { -0.875374082613, 0.377879061851, -0.301542086787 },
    { 0.306758933840, -0.059207804241, 0.949943889094 },
    { -0.302873999755, 0.507579158749, -0.806616847008 },
    { -0.363289222149, 0.245610228245, 0.898719398284 },
    { 23, DUMMYVAL, DUMMYVAL },
    { 0.652755932306, -0.746414814390, -0.129516862607 },
    { -0.571782213729, -0.244225346813, -0.783210750716 },
    { -0.709688239042, -0.669143489929, -0.220430472601 },
    { 0.074260622701, 0.149277887820, -0.986002774907 },
    { -0.016875357639, -0.997959076091, -0.061586563074 },
    { -0.009413501650, 0.687898371154, 0.725745972741 },
    { 0.772596564939, 0.523362459372, 0.359424935090 },
    { 0.263157839075, 0.959418508514, 0.101311782404 },
    { 0.400751973491, 0.108379743006, 0.909753640855 },
    { 0.839823682437, -0.276754944100, 0.467014864147 },
    { 0.009413450197, -0.687898401663, -0.725745944490 },
    { 0.677548194000, 0.538161884565, -0.501308518588 },
    { 0.609302219506, -0.266442386686, -0.746832819232 },
    { -0.975664874445, 0.152681067858, -0.157373899655 },
    { 0.030264912093, 0.815154628228, -0.578452216846 },
    { 0.984938230299, -0.008800677927, -0.172682455866 },
    { 0.298116671784, -0.690842928425, 0.658682395582 },
    { -0.280144459258, -0.117059244474, 0.952793899661 },
    { -0.509780373863, 0.859977207332, 0.023731272475 },
    { -0.684554448284, 0.440828515136, 0.580564748824 },
    { -0.393141091044, -0.758368362464, 0.519920676013 },
    { -0.874060593742, -0.248142537028, 0.417664171058 },
    { -0.587825140081, 0.476911936064, -0.653465079349 },
    { 24, DUMMYVAL, DUMMYVAL },
    { 0.134985506170, -0.985952791173, 0.098366695086 },
    { 0.650088694587, -0.462793906466, -0.602666150790 },
    { -0.206347275695, 0.662332382064, 0.720233724205 },
    { -0.435854930194, 0.350113596741, -0.829126618318 },
    { 0.985232180539, 0.063955280317, -0.158830955895 },
    { -0.614137826481, -0.392074584561, -0.684917695951 },
    { 0.353418655052, -0.587198098366, 0.728212638957 },
    { -0.944785803171, 0.119466198906, -0.305135401821 },
    { 0.021302190861, -0.808690754556, -0.587848177815 },
    { 0.090322707483, 0.786736539321, -0.610645090220 },
    { 0.019144141922, 0.992112273707, 0.123881952644 },
    { 0.685499579269, 0.715694962504, -0.133682637122 },
    { -0.492664112126, -0.044270667252, 0.869092734203 },
    { -0.582890874715, -0.806420953907, -0.099616631511 },
    { 0.048922860209, -0.155267715919, -0.986660270885 },
    { 0.542444409187, 0.622999428166, 0.563582980089 },
    { 0.763772109691, -0.640056077552, 0.083548680702 },
    { -0.913538674752, -0.294880095995, 0.280165698682 },
    { -0.347061443006, -0.702169846181, 0.621695956149 },
    { 0.842177009528, -0.028740243511, 0.538434659941 },
    { 0.207815962624, 0.070701024559, 0.975609497086 },
    { -0.578727030552, 0.786414267629, -0.215934304310 },
    { -0.804218513225, 0.456634532848, 0.380417515892 },
    { 0.575100475666, 0.281355246534, -0.768178799588 },
    { 25, DUMMYVAL, DUMMYVAL },
    { 0.532212965784, 0.104012540712, -0.840196852187 },
    { 0.250139840140, -0.721834058886, 0.645279514479 },
    { -0.633506688611, -0.753135632571, -0.177358378534 },
    { -0.218922463231, 0.850392517067, 0.478440719431 },
    { -0.413149806364, -0.780294228218, 0.469519067675 },
    { 0.734236034340, -0.661803691272, 0.151371463942 },
    { 0.936469940841, 0.054189066241, 0.346536570943 },
    { -0.333112408327, -0.242859001882, 0.911073887576 },
    { 0.103315488089, -0.991677012629, -0.076828461807 },
    { -0.926539655526, 0.372983070696, -0.049070313963 },
    { 0.801488967040, 0.543143312217, -0.250221458126 },
    { -0.916836769339, -0.261947685782, 0.301320009791 },
    { -0.537755795155, 0.438027927278, -0.720382009562 },
    { -0.213559057919, -0.664684481487, -0.715951862105 },
    { -0.124138610474, -0.051815651202, -0.990911067493 },
    { 0.273979937314, 0.960273112918, -0.053014550417 },
    { -0.443315490443, 0.878048334487, -0.180284492503 },
    { 0.024170841904, 0.368771526312, 0.929205753202 },
    { 0.568365159741, 0.637098308775, 0.520640749604 },
    { 0.930930389545, -0.168157726945, -0.324178328533 },
    { -0.825458835938, -0.182178469442, -0.534255290516 },
    { 0.472597880311, -0.629557481175, -0.616691674520 },
    { 0.504263360030, -0.129264527496, 0.853820323992 },
    { 0.149335563174, 0.688742589708, -0.709459325610 },
    { -0.694717409994, 0.344411933027, 0.631465074759 },
    { 26, DUMMYVAL, DUMMYVAL },
    { -0.703824384993, -0.348338404066, -0.619105476751 },
    { 0.845325161743, 0.532312414883, 0.045484765414 },
    { -0.083319091846, -0.572212820354, -0.815861763509 },
    { -0.711194013204, -0.675514410539, 0.194636473295 },
    { -0.351731313044, 0.935360146028, -0.037235475640 },
    { -0.738627936932, 0.391233892407, -0.548967041102 },
    { 0.403271332748, -0.430870142291, 0.807293721434 },
    { 0.462449142984, 0.352105794993, 0.813733555462 },
    { -0.761937509711, -0.035454178350, 0.646679389290 },
    { -0.133412387980, 0.704857370015, -0.696690191311 },
    { 0.575905996365, 0.434906250790, -0.692234668573 },
    { 0.457915809816, -0.797303082418, -0.393218648956 },
    { -0.296085216091, -0.917653971022, -0.265037231876 },
    { 0.947314587535, -0.119907296236, -0.297013993866 },
    { 0.252708633487, 0.861257250157, 0.440879003371 },
    { -0.992384852182, -0.110464440528, -0.054496903944 },
    { -0.355986449265, 0.633264760427, 0.687204038944 },
    { 0.745854671838, -0.637719912163, 0.192390545838 },
    { -0.297369196702, -0.602410667993, 0.740724610055 },
    { 0.896684600027, -0.013961302012, 0.442449782597 },
    { 0.113521449335, -0.948508787021, 0.295709251604 },
    { -0.129673032402, 0.047186330270, 0.990433417703 },
    { -0.163067657459, 0.101850698376, -0.981343657610 },
    { 0.342687463310, 0.909433833423, -0.235574627486 },
    { -0.836129085035, 0.520348495716, 0.173567266974 },
    { 0.510664444324, -0.214368378238, -0.832627181705 },
    { 27, DUMMYVAL, DUMMYVAL },
    { -0.829730901919, 0.547935054664, 0.106366377541 },
    { 0.091879753674, -0.053885725392, 0.994311037585 },
    { -0.262814930663, 0.923764304268, 0.278545907134 },
    { -0.495211363707, -0.810577854268, 0.312616774063 },
    { -0.461716101614, 0.764099274247, -0.450522519532 },
    { -0.383567931204, 0.246962315229, -0.889879349692 },
    { 0.789279891772, -0.062029432017, -0.610892463538 },
    { 0.212053130037, -0.146372161115, -0.966234267914 },
    { 0.669231814426, 0.220621512336, 0.709545577715 },
    { 0.988181027614, 0.097635523892, 0.118175975299 },
    { 0.065147735583, -0.695335052828, 0.715726859114 },
    { -0.565129457850, 0.377659375363, 0.733486258952 },
    { 0.249272749779, 0.534267804060, -0.807725825861 },
    { -0.530473320997, -0.302000602900, 0.792081871753 },
    { 0.685866525839, -0.448469374118, 0.573116331308 },
    { -0.397937113695, -0.447078993140, -0.801103256414 },
    { 0.760024321761, 0.559899232152, -0.329963452774 },
    { 0.300124760181, -0.945645790359, 0.125216482552 },
    { 0.164403157249, 0.953233565630, -0.253608697096 },
    { -0.813025318498, -0.528815092643, -0.243607120738 },
    { -0.950871209950, -0.119517050657, 0.285586443465 },
    { 0.073610628162, 0.613955788988, 0.785900607322 },
    { 0.551995972212, 0.777274769522, 0.301901274139 },
    { -0.217404214476, -0.922149505885, -0.319962023254 },
    { 0.829730901842, -0.547935054237, -0.106366380344 },
    { 0.364037726154, -0.706812814451, -0.606541160404 },
    { -0.886958231041, 0.119315984959, -0.446171258735 },
    { 28, DUMMYVAL, DUMMYVAL },
    { 0.578494808980, -0.809622165552, 0.099275903570 },
    { -0.891214457444, -0.075481529060, 0.447257565184 },
    { -0.037594576188, 0.365568255887, -0.930024998658 },
    { 0.802350101884, -0.314111097292, 0.507512100905 },
    { -0.549731798043, 0.455165553736, 0.700442195269 },
    { -0.248868936478, 0.901154484307, -0.354943443199 },
    { -0.453238734188, -0.601729427360, 0.657644543869 },
    { -0.661593574900, 0.460838904240, -0.591541584329 },
    { 0.355919286690, 0.761440542461, -0.541783869876 },
    { -0.476848536759, -0.707192755038, -0.522009463719 },
    { -0.752718822035, -0.655388349163, 0.062293552913 },
    { 0.382536789792, 0.910272746403, 0.158332345436 },
    { -0.523070327222, -0.144215049468, -0.839999673980 },
    { 0.221403847658, -0.667217677892, 0.711196812810 },
    { -0.261913321688, -0.062909397579, 0.963038846371 },
    { 0.144232427833, 0.616459615198, 0.774063659909 },
    { 0.688002922930, -0.492121128393, -0.533356140894 },
    { -0.121381323070, -0.980071488886, 0.157246466041 },
    { 0.382313822687, -0.002512775561, 0.924029126674 },
    { 0.630059023286, 0.145280273962, -0.762836331839 },
    { -0.957121715964, -0.099711499954, -0.271984627520 },
    { 0.145799904312, -0.876233304688, -0.459301190569 },
    { 0.987630749164, -0.131052312258, -0.086085973055 },
    { -0.844344397001, 0.532494469933, 0.059432135608 },
    { 0.121617123097, -0.339331928687, -0.932771739250 },
    { 0.850038358196, 0.495677224727, -0.178154086350 },
    { 0.773312471880, 0.401360911835, 0.490812835289 },
    { -0.284071117437, 0.913188903997, 0.292215033588 },
    { 29, DUMMYVAL, DUMMYVAL },
    { 0.352352501259, -0.815339945524, -0.459421906410 },
    { 0.584347059442, 0.125398451732, -0.801756660356 },
    { 0.324024097739, 0.624162177302, 0.710935974972 },
    { -0.576315672381, 0.490241522872, -0.653852808375 },
    { -0.055445397696, -0.997101085115, 0.052107906670 },
    { -0.509282560423, -0.756546450959, 0.410205730323 },
    { 0.387616023355, 0.717576573205, -0.578651605049 },
    { -0.050385380197, 0.317982201331, -0.946756902853 },
    { 0.974109616999, -0.207932791451, 0.088737862885 },
    { 0.821630809221, 0.342770400574, 0.455446227155 },
    { -0.791241632740, 0.371798159336, 0.485492334989 },
    { 0.108701540748, -0.695770533230, 0.709991084541 },
    { 0.675001370888, -0.304177191552, 0.672197430402 },
    { -0.291608997845, 0.426535840432, 0.856172511357 },
    { -0.905939813255, -0.228404023295, 0.356517400561 },
    { 0.889253169240, 0.395811711450, -0.229263800184 },
    { -0.963497682222, 0.079408232251, -0.255668826812 },
    { -0.301043346309, -0.771257178423, -0.560834439361 },
    { -0.426496622784, -0.247592496928, 0.869941714265 },
    { 0.791241668523, -0.371798027203, -0.485492377861 },
    { -0.145040025916, 0.932885960209, -0.329677381887 },
    { 0.466792902421, 0.880099579315, 0.086770483104 },
    { -0.195078313996, 0.912997597421, 0.358301323627 },
    { 0.213002485200, -0.011380193625, 0.976985379876 },
    { -0.783762440264, -0.585156860441, -0.208105468237 },
    { -0.575494454631, -0.184329163542, -0.796761502682 },
    { 0.107671005367, -0.353526675198, -0.929207105293 },
    { 0.588148436310, -0.787098368731, 0.185896677772 },
    { -0.713260346099, 0.699742578332, -0.040249257796 },
    { 30, DUMMYVAL, DUMMYVAL },
    { -0.006653594567, 0.898917674061, 0.438067055301 },
    { 0.910432431342, 0.375861444128, -0.172745369774 },
    { -0.739286008328, 0.066128200031, -0.670136746531 },
    { -0.119881642095, 0.594206835081, -0.795328000910 },
    { -0.639562720115, 0.726562214570, 0.251131191606 },
    { 0.639562709633, -0.726562226844, -0.251131182791 },
    { -0.667875921118, -0.544735685623, 0.507153612626 },
    { 0.296407339459, -0.436029585697, -0.849718123563 },
    { 0.016512944080, -0.873455374227, -0.486624117685 },
    { -0.503800715885, -0.553035944290, -0.663578241805 },
    { -0.974931033164, 0.216191593878, -0.052637204613 },
    { 0.464845057365, 0.775384781553, -0.427431296444 },
    { 0.624261678448, -0.609877744888, 0.488207428366 },
    { 0.174067093646, -0.971581735749, 0.160404419108 },
    { 0.288299868987, 0.446205313102, 0.847221343039 },
    { -0.623981779896, 0.663039307921, -0.413552432600 },
    { 0.453897247750, 0.268395653788, -0.849671149041 },
    { 0.965071597501, -0.241653702570, 0.101194366101 },
    { -0.834455827389, 0.067046499165, 0.546981022602 },
    { -0.902483656446, -0.411365491337, -0.127678041907 },
    { 0.819760700810, -0.157436248876, -0.550641644763 },
    { 0.587501166626, 0.769194941197, 0.251359347646 },
    { -0.459446524745, -0.888194833339, -0.004339231413 },
    { -0.274943879059, -0.145673222845, 0.950360550272 },
    { -0.369846150731, 0.465978617157, 0.803789619952 },
    { -0.086213077362, 0.978860576114, -0.185470423036 },
    { 0.818782889412, 0.195206928993, 0.539897059521 },
    { -0.178394546514, -0.035619991487, -0.983314091214 },
    { 0.381425747672, -0.195029367888, 0.903591691349 },
    { -0.059071394774, -0.716929424386, 0.694638590037 },
    { 31, DUMMYVAL, DUMMYVAL },
    { -0.404485801990, 0.801145160285, 0.441086916763 },
    { -0.748942567232, -0.662363704264, -0.018956641627 },
    { -0.236315790505, -0.912424523381, -0.334120242265 },
    { 0.693310892542, 0.482245749539, 0.535498873327 },
    { -0.203714420443, -0.442765397309, 0.873189119177 },
    { 0.399692451068, -0.069366022027, -0.914020951372 },
    { 0.245878456697, 0.627777017425, -0.738538963715 },
    { 0.847226441419, -0.286749277133, -0.447193704142 },
    { 0.234753426819, 0.909610476648, 0.342782160227 },
    { 0.985081948046, 0.166407932485, 0.043840114517 },
    { 0.799395315780, -0.162097726540, 0.578525242457 },
    { -0.420762355261, 0.173028918374, 0.890516722921 },
    { 0.764559207832, 0.336103454008, -0.549985168822 },
    { -0.760888489844, -0.344582260348, 0.549828856897 },
    { 0.084472616020, 0.538920482568, 0.838110428650 },
    { 0.362971995096, -0.671052920431, 0.646482257109 },
    { -0.077719061065, 0.978066559969, -0.193249972363 },
    { -0.076072993014, -0.514704902253, -0.853985809795 },
    { 0.273538375135, -0.959384592857, 0.068977969797 },
    { 0.301800326081, -0.036868539481, 0.952658004729 },
    { -0.996891755320, -0.059015282365, -0.052192189278 },
    { -0.786920352434, 0.187954609377, -0.587732442306 },
    { -0.659628679412, -0.424097649240, -0.620508814769 },
    { 0.420802283612, -0.737952419329, -0.527590432925 },
    { 0.806101843892, -0.582767614707, 0.102867509555 },
    { -0.225406674727, 0.112219296983, -0.967780274842 },
    { -0.737813919337, 0.666892524247, -0.104331114898 },
    { 0.615566050703, 0.776673911335, -0.133626616635 },
    { -0.370512838694, 0.665830974211, -0.647602771878 },
    { -0.287603733017, -0.874312423156, 0.390975548430 },
    { -0.842393883403, 0.314826265898, 0.437329358156 },
    { 32, DUMMYVAL, DUMMYVAL },
    { 0.127839994324, 0.905079981288, -0.405570170652 },
    { 0.160624455635, 0.551408286854, 0.818626096237 },
    { -0.660076326339, -0.746272212908, 0.085889624794 },
    { 0.429182719745, -0.024323513182, 0.902890115008 },
    { 0.017138782122, 0.483370449508, -0.875248119501 },
    { -0.017138782496, -0.483370449559, 0.875248119465 },
    { 0.879670240941, -0.126024235489, 0.458582772542 },
    { 0.372449269958, -0.928034884037, 0.005726719673 },
    { -0.615867796457, -0.445295752660, 0.649937343096 },
    { -0.420650772436, 0.691083196582, 0.587755853268 },
    { -0.857022691548, 0.512647555396, 0.052005673898 },
    { 0.977673466973, 0.189673233358, -0.090435924964 },
    { -0.372449268149, 0.928034884765, -0.005726719413 },
    { -0.271608831281, 0.099041670392, 0.957297963173 },
    { 0.660076322812, 0.746272216769, -0.085889618361 },
    { -0.518036777328, 0.644904845847, -0.561903583490 },
    { 0.420650774711, -0.691083195657, -0.587755852727 },
    { 0.713253817668, 0.491474092923, 0.499722130356 },
    { 0.271608830136, -0.099041670365, -0.957297963501 },
    { -0.429182720907, 0.024323508230, -0.902890114589 },
    { 0.518036776546, -0.644904846374, 0.561903583606 },
    { -0.790991214336, 0.168073897971, 0.588289098713 },
    { 0.615867795454, 0.445295757555, -0.649937340692 },
    { -0.713253819444, -0.491474095234, -0.499722125549 },
    { -0.977673467286, -0.189673230240, 0.090435928118 },
    { -0.160624455963, -0.551408291328, -0.818626093159 },
    { 0.857022693105, -0.512647552636, -0.052005675458 },
    { 0.790991215299, -0.168073890326, -0.588289099602 },
    { -0.188027854368, -0.933619777304, -0.304958419146 },
    { -0.879670240234, 0.126024236041, -0.458582773747 },
    { -0.127839994442, -0.905079980679, 0.405570171973 },
    { 0.188027854008, 0.933619775705, 0.304958424265 },
    { 33, DUMMYVAL, DUMMYVAL },
    { 0.667915327570, -0.468972673021, 0.577887313545 },
    { 0.925772184021, -0.377057844896, -0.027807281334 },
    { 0.119230492287, -0.418553373766, -0.900331696109 },
    { -0.642075588044, 0.586591733938, -0.493608222089 },
    { -0.318217215903, 0.110391873612, -0.941568604905 },
    { -0.675756826269, 0.263492344335, 0.688421742995 },
    { 0.473856735704, 0.494663321902, 0.728538257055 },
    { 0.297013709925, 0.183305083654, -0.937113708375 },
    { -0.935864896293, -0.323744560754, -0.139091176098 },
    { -0.582049800616, -0.803172581035, -0.127011159655 },
    { 0.509111850985, -0.854195126839, 0.105621060740 },
    { 0.074325380545, 0.901479080283, 0.426393252313 },
    { 0.315274059919, -0.073391122046, 0.946158554550 },
    { 0.616131479732, 0.562316410695, -0.551527201456 },
    { -0.048019565629, 0.686073972580, -0.725945332284 },
    { -0.485885831036, -0.513067144277, -0.707585376235 },
    { 0.105410818681, -0.673676584882, 0.731470039227 },
    { -0.061856209331, -0.979884813449, 0.189735504686 },
    { -0.935739888630, 0.351075001374, 0.033722458955 },
    { 0.554025209672, -0.669491701118, -0.494809993009 },
    { 0.277523046469, 0.938610375087, -0.204918331189 },
    { 0.693459587142, 0.698463860026, 0.176810738470 },
    { -0.550311139871, 0.748155405094, 0.370703573172 },
    { -0.019763712941, -0.894061378799, -0.447508264271 },
    { -0.513255576715, -0.682053560238, 0.520933444825 },
    { -0.875185525366, -0.216912078596, 0.432434326054 },
    { 0.874437723283, 0.095825249548, 0.475579845713 },
    { -0.810914263992, 0.025528652095, -0.584607855213 },
    { 0.755434519846, -0.113697490672, -0.645284097774 },
    { -0.312336753414, -0.207510592835, 0.927030261819 },
    { -0.323787685689, 0.935636541632, -0.140519737259 },
    { 0.960827605852, 0.235546019033, -0.146042407368 },
    { -0.124446796961, 0.451553716131, 0.883522629124 },
    { 34, DUMMYVAL, DUMMYVAL },
    { -0.459299588162, -0.331885483769, -0.823951402680 },
    { 0.720718760943, -0.098294556733, 0.686223467787 },
    { 0.473170194847, 0.522354842818, -0.709404951275 },
    { -0.478675685748, 0.331451889160, -0.813024743195 },
    { 0.040634815105, 0.133842735208, -0.990169144153 },
    { -0.393814429144, -0.915612305200, 0.081020379936 },
    { 0.874589075279, 0.387846977033, -0.290978816770 },
    { 0.157607524981, -0.160830744233, 0.974316857998 },
    { -0.736331770499, -0.592858498747, -0.326089442052 },
    { -0.608789118477, 0.716930554772, -0.339685720716 },
    { -0.716625519543, -0.536493019340, 0.445671521346 },
    { 0.422084512112, -0.644231818660, 0.637816610368 },
    { -0.980203505903, -0.179294345638, 0.083991812917 },
    { -0.877369357161, 0.043329267659, -0.477855193212 },
    { 0.223742471133, -0.970040713307, 0.094658972839 },
    { 0.736352360396, 0.589672564790, 0.331770203112 },
    { -0.046494870848, 0.774951160756, -0.630308595394 },
    { 0.155920602404, 0.861774579719, 0.482735268543 },
    { -0.492138784805, 0.760098270467, 0.424323032281 },
    { 0.455781184991, 0.877532648714, -0.148996516234 },
    { -0.144067089414, 0.988837695448, -0.038009022741 },
    { -0.771638645779, 0.181161084368, 0.609716706226 },
    { -0.416578994899, -0.209574799689, 0.884613104326 },
    { 0.604695883616, -0.082142964226, -0.792209203283 },
    { 0.897004480562, -0.280547513079, -0.341578768012 },
    { 0.774418918122, -0.612337373368, 0.159117190876 },
    { 0.397077598256, 0.409553319679, 0.821337603731 },
    { 0.140803926331, -0.482778710888, -0.864348870910 },
    { 0.981199367655, 0.024855198868, 0.191389707150 },
    { -0.151747438164, -0.747963050031, 0.646160963537 },
    { -0.220224053920, 0.424393605501, 0.878288923809 },
    { -0.898000369826, 0.434986524208, 0.066197126454 },
    { 0.492118182913, -0.756912390408, -0.430003868929 },
    { -0.155920600071, -0.861774609495, -0.482735216141 },
    { 35, DUMMYVAL, DUMMYVAL },
    { 0.247706555401, -0.559968959080, 0.790617623936 },
    { 0.710320420361, -0.664304733237, -0.232688894916 },
    { -0.202743162345, 0.848308378540, -0.489150391006 },
    { 0.896147198157, 0.359712994442, -0.259859117340 },
    { -0.683364437138, 0.715577231775, -0.144783532974 },
    { 0.510495381947, 0.169363902724, -0.843036377308 },
    { -0.023723465642, -0.056167961646, 0.998139447804 },
    { 0.841728809657, -0.166949509858, -0.513439842778 },
    { -0.616089048182, -0.189148329736, -0.764628794951 },
    { -0.046285641092, -0.142824355660, -0.988665182384 },
    { 0.618474347090, 0.782483718722, 0.072171406570 },
    { 0.252541177581, 0.778878793037, 0.574082554501 },
    { -0.362902424837, 0.858298798741, 0.362801601604 },
    { 0.440599329793, 0.720747960296, -0.535158488968 },
    { -0.401482718696, -0.898701176703, -0.176487454458 },
    { 0.195336615651, -0.944295311476, -0.264858398603 },
    { 0.375177324963, -0.525178301975, -0.763825717011 },
    { 0.712307989245, -0.213887172304, 0.668483063346 },
    { -0.029720950138, -0.940808228303, 0.337633740436 },
    { -0.811651924370, 0.434708568279, 0.390191766099 },
    { -0.950711574920, -0.154746887521, 0.268702255510 },
    { -0.833054158246, -0.467964780839, -0.295008022474 },
    { -0.955559657092, 0.159227489999, -0.248097456994 },
    { -0.258661620074, 0.491091148171, 0.831819481912 },
    { 0.845683158198, 0.347522815144, 0.405028256908 },
    { -0.233225980227, -0.675545681533, -0.699459558737 },
    { -0.672215750268, -0.676212292018, 0.301434771078 },
    { -0.026965898658, 0.441743627906, -0.896735974250 },
    { -0.600119151834, 0.390288680868, -0.698234737885 },
    { 0.422147044025, 0.293020736113, 0.857864046005 },
    { 0.576576794805, -0.751583390200, 0.320439709256 },
    { 0.072782753148, 0.997259605025, -0.013264653406 },
    { 0.973546970181, -0.197178148703, 0.115442949225 },
    { -0.630258959503, -0.012020347267, 0.776291926544 },
    { -0.353175623936, -0.550566647472, 0.756401576776 },
    { 36, DUMMYVAL, DUMMYVAL },
    { -0.012414841008, 0.127715737042, -0.991733110385 },
    { 0.978766216802, -0.203000108560, 0.028419162058 },
    { 0.562742811278, 0.824097618643, 0.064681089211 },
    { -0.458714238088, 0.051012308692, 0.887118364221 },
    { -0.885258539890, 0.462910182195, 0.045071951069 },
    { -0.081091962167, -0.387626424731, 0.918242804776 },
    { -0.094996269019, 0.649189787895, -0.754671006575 },
    { -0.551767359613, 0.597351617105, 0.581999850865 },
    { 0.291623968085, -0.426189804553, -0.856339717480 },
    { -0.042984505596, 0.482307864120, 0.874946544931 },
    { -0.626829137025, -0.505531562520, 0.592893811970 },
    { 0.414268721911, -0.633116482384, 0.653869211524 },
    { -0.909870398676, -0.408073190021, 0.074914145524 },
    { 0.701786118902, -0.696462603286, 0.149786800290 },
    { 0.540115639916, 0.175242601607, -0.823143441995 },
    { 0.467928998133, 0.698849481959, -0.540973062428 },
    { 0.780519154966, -0.152996547029, 0.606120371979 },
    { -0.301983590862, -0.398957048513, -0.865817061678 },
    { 0.807042883703, -0.280195863257, -0.519780782714 },
    { 0.517814559084, 0.541277510718, 0.662485274396 },
    { -0.702591936124, -0.526881851120, -0.478288705966 },
    { -0.446579827965, 0.891475742527, 0.076403257397 },
    { -0.888442189926, 0.053939602073, 0.455808067598 },
    { 0.886972608087, 0.334369643194, -0.318553816825 },
    { -0.145675305684, -0.845335554639, 0.513990763902 },
    { -0.493009073586, -0.869979071585, 0.008858237146 },
    { 0.158264486792, -0.986105085280, 0.050488741367 },
    { 0.058902431228, 0.903799200512, 0.423883838746 },
    { -0.128637061749, -0.857917197136, -0.497423953186 },
    { 0.484924813270, -0.773083411887, -0.408888693583 },
    { -0.592276587785, 0.138331550349, -0.793771267897 },
    { 0.894238442281, 0.352816987456, 0.275422914277 },
    { 0.333950121813, 0.014997891626, 0.942471420992 },
    { -0.602511091495, 0.647781473585, -0.466218347029 },
    { 0.026512376786, 0.971709692066, -0.234685679626 },
    { -0.940740475992, 0.032275307517, -0.337588005349 },
    { 37, DUMMYVAL, DUMMYVAL },
    { 0.031432736613, -0.112483562329, 0.993156297505 },
    { -0.213121687050, 0.643779923042, -0.734933029056 },
    { -0.027811032599, 0.982178006052, -0.185884132981 },
    { -0.656885127669, -0.630459836257, 0.413548454132 },
    { -0.754951872568, 0.554799455764, 0.349635859130 },
    { 0.685865229259, 0.526752968417, 0.502115721281 },
    { -0.870783264287, -0.000500544098, 0.491666814106 },
    { -0.068236887334, -0.708838346231, 0.702062622648 },
    { -0.302461976637, 0.015482575695, -0.953035698460 },
    { -0.572524719424, 0.797677885569, -0.189540065746 },
    { 0.258151455258, 0.897948406993, 0.356435807021 },
    { -0.427765633018, 0.350022915491, 0.833366979092 },
    { 0.643657001102, -0.218609254534, -0.733427337072 },
    { 0.476476673628, -0.524337796075, 0.705719388352 },
    { -0.686630912277, 0.372393624751, -0.624388483679 },
    { -0.956906303635, 0.265827547203, -0.116901844350 },
    { 0.771366507122, -0.613539925860, 0.169004352207 },
    { 0.326472653574, 0.715541901613, -0.617588368984 },
    { 0.313405445540, -0.929174275224, 0.195990287944 },
    { -0.947125230211, -0.320801151437, -0.006357635877 },
    { -0.610811845747, -0.753468004697, -0.243299928061 },
    { 0.947125196856, 0.320801249295, 0.006357667199 },
    { 0.899763441951, -0.103206374940, 0.423997868744 },
    { -0.796235113908, -0.199531976497, -0.571136265470 },
    { -0.479992234795, -0.266618669748, 0.835776249650 },
    { 0.162262506919, -0.461777756353, -0.872027627192 },
    { -0.241736888697, -0.956688762775, 0.162203230002 },
    { 0.533110989057, 0.076530623097, 0.842576843424 },
    { 0.009205022670, -0.915595628939, -0.401994915174 },
    { 0.760413678397, 0.327720775091, -0.560687195574 },
    { -0.369446609383, -0.561757471665, -0.740228171474 },
    { -0.293978936159, 0.859655628916, 0.417814055253 },
    { 0.553918766948, -0.731095616766, -0.398338045845 },
    { 0.242251846811, 0.199982321900, -0.949379330744 },
    { 0.599742335454, 0.793080610894, -0.106453161946 },
    { 0.116947882933, 0.534523540111, 0.837023164402 },
    { 0.945836904337, -0.226215008320, -0.232850424962 },
    { 38, DUMMYVAL, DUMMYVAL },
    { -0.149752823960, -0.972454906014, -0.178621240299 },
    { 0.263249959377, 0.655340202216, 0.707975054820 },
    { 0.776369653487, -0.615582315025, 0.135309181410 },
    { -0.674891462832, 0.145742107860, 0.723381470175 },
    { 0.144698702745, -0.633126193712, 0.760403516733 },
    { 0.919776603718, -0.262787137435, -0.291468556882 },
    { 0.261939503687, -0.042746990799, 0.964137122605 },
    { 0.921163655846, 0.357546212716, -0.153682220575 },
    { -0.691693142085, -0.722048018658, 0.014396386517 },
    { -0.022695961961, 0.906754242349, -0.421048260052 },
    { -0.281930050303, -0.258018669049, -0.924089721379 },
    { 0.543651350412, 0.792805991401, -0.275502938630 },
    { 0.310153998204, 0.563985683918, -0.765326496166 },
    { 0.242353449298, -0.033908732662, -0.969595278177 },
    { 0.725769107498, 0.184643785831, -0.662695914394 },
    { -0.293230957010, -0.296476962513, 0.908909795607 },
    { 0.289249219514, -0.919412266233, 0.266488224339 },
    { 0.962269688656, -0.023296195135, 0.271098383591 },
    { 0.651984448720, -0.394071304000, 0.647783980962 },
    { -0.911392066306, 0.353681886630, -0.210412985685 },
    { 0.563055188917, -0.428028532263, -0.706937359179 },
    { 0.679625482012, 0.239132962635, 0.693487296482 },
    { 0.686624287870, 0.667098991261, 0.289008690468 },
    { -0.303097415210, 0.769288448166, 0.562429764870 },
    { -0.970654229656, -0.067598693851, 0.230782978231 },
    { -0.783932263701, 0.533598651228, 0.317368374822 },
    { 0.041612783001, -0.701681389674, -0.711274633090 },
    { -0.446070330787, 0.894995489160, -0.002081916210 },
    { 0.451139012802, -0.840046420093, -0.301323087759 },
    { 0.149752683929, 0.972454909159, 0.178621340574 },
    { -0.172922475822, 0.327159175773, 0.929012750754 },
    { -0.913601109238, -0.275562547910, -0.298995477204 },
    { -0.702861972220, 0.063685405163, -0.708469630384 },
    { -0.282166868183, -0.860413085224, 0.424347948356 },
    { -0.542393966233, 0.652011877575, -0.529801186196 },
    { -0.700286649761, -0.463116312945, 0.543251220754 },
    { -0.211061751544, 0.373132817156, -0.903451624491 },
    { -0.529803286236, -0.642682166969, -0.553414952955 },
    { 39, DUMMYVAL, DUMMYVAL },
    { -0.286826988317, -0.847556613056, -0.446517711225 },
    { 0.414418400383, -0.828727621670, 0.376122212194 },
    { -0.804363807083, 0.242245489099, -0.542508975840 },
    { 0.383388631852, 0.920383042731, 0.076864891989 },
    { -0.389078409183, 0.594018887711, -0.704101947555 },
    { -0.634955035479, 0.749744198575, -0.186321602675 },
    { 0.288410213549, -0.075241126751, -0.954546133807 },
    { -0.233052087784, 0.366674907247, 0.900686536357 },
    { -0.160131007009, -0.456450285516, -0.875220656433 },
    { 0.619893406829, 0.621110536763, 0.479535051161 },
    { 0.066290583261, 0.768573255540, 0.636318088254 },
    { 0.870501903110, 0.490296230272, -0.042849075400 },
    { 0.308833150918, -0.672469313830, -0.672612151876 },
    { -0.964248091212, -0.178206119782, -0.196133111599 },
    { 0.848840558030, -0.429358705149, 0.308416616536 },
    { -0.335137636814, 0.079881790660, -0.938776684793 },
    { 0.536078807127, -0.338329600931, 0.773403254249 },
    { -0.183962875668, 0.973683407085, 0.134529859673 },
    { 0.044723522984, -0.151114234443, 0.987504073227 },
    { 0.169256316751, 0.471467319768, -0.865488801563 },
    { 0.402481348684, 0.274650364190, 0.873255942672 },
    { -0.744732533784, 0.220792130865, 0.629781142995 },
    { 0.731477661415, 0.261972869548, -0.629532085339 },
    { -0.547865362132, 0.704657108156, 0.450890125089 },
    { 0.728093500375, -0.661211867238, -0.180772567985 },
    { -0.705323400327, -0.702746605188, -0.093091942978 },
    { 0.508362144009, 0.734121893639, -0.450147726661 },
    { -0.934297603362, 0.347845782738, 0.078046779450 },
    { -0.547614553362, -0.683635973185, 0.482452232987 },
    { -0.901851959324, -0.253542492660, 0.349827454439 },
    { -0.004077991094, -0.683917496790, 0.729547961119 },
    { 0.871707483456, 0.112286447064, 0.476988277732 },
    { 0.989655690796, -0.056412227336, -0.131906308727 },
    { -0.035871710435, 0.909125555500, -0.414974631427 },
    { -0.482591611541, -0.242284976527, 0.841666992711 },
    { -0.183612287558, -0.966630013858, 0.178641944027 },
    { -0.670766218533, -0.370734395476, -0.642361804660 },
    { 0.731577426517, -0.290047482962, -0.616982112090 },
    { 0.236370424255, -0.954914059683, -0.179633407688 },
    { 40, DUMMYVAL, DUMMYVAL },
    { 0.982050879763, 0.102471334601, 0.158353071146 },
    { -0.519547217045, 0.562793826599, -0.642910412112 },
    { -0.046287248147, 0.870833938609, -0.489393238639 },
    { -0.693413914399, 0.584563775377, 0.421262787147 },
    { -0.512687089332, -0.830859920620, 0.216387940374 },
    { 0.885854020493, -0.240337319071, -0.396863487157 },
    { -0.427123601364, 0.075878588191, -0.901003811874 },
    { -0.828462749037, 0.540566664057, -0.146414327056 },
    { -0.037921646030, -0.828653544835, 0.558475828836 },
    { 0.498632457233, -0.453154293246, -0.738929535954 },
    { 0.885350188591, -0.438809514614, 0.153626994526 },
    { -0.217004254475, 0.511554293713, 0.831397232449 },
    { 0.316450270556, 0.736801117800, 0.597480827369 },
    { 0.598175129695, 0.170263497330, -0.783068870337 },
    { 0.602812589282, -0.771840265274, -0.202187010226 },
    { -0.422604694715, -0.842139219788, -0.334972844420 },
    { -0.189379678528, -0.030727688539, 0.981423021188 },
    { -0.983983472662, 0.090022490362, 0.153858625881 },
    { 0.234683459047, -0.420105081734, 0.876604468590 },
    { -0.880686986744, -0.454174005510, -0.134597192014 },
    { 0.711987385121, -0.218567354723, 0.667309729345 },
    { -0.883303693320, 0.077416279819, -0.462364904579 },
    { 0.227823280055, 0.973548688394, 0.017306195180 },
    { -0.823933890828, -0.379478655338, 0.420866836050 },
    { 0.132492231610, -0.071029451321, -0.988635739597 },
    { -0.149565108991, -0.519464853306, -0.841300507757 },
    { 0.733892136284, 0.359116353870, 0.576574172751 },
    { 0.707468499582, 0.699450449972, 0.101278774344 },
    { -0.691072585591, 0.108927856109, 0.714530197828 },
    { 0.881513438863, 0.340632572282, -0.326961018783 },
    { 0.494878654879, 0.714459995046, -0.494613012792 },
    { -0.419663979112, 0.903495828383, -0.087048450473 },
    { -0.649683224705, -0.401296767219, -0.645656729351 },
    { -0.412821791090, -0.486502312727, 0.769995888634 },
    { 0.136329012718, -0.850471577339, -0.508047730465 },
    { 0.069358059842, -0.997087109570, 0.031729410096 },
    { 0.319066996740, 0.205210806234, 0.925248494512 },
    { 0.502132806229, -0.759234097733, 0.414036507748 },
    { 0.062103904443, 0.476606999270, -0.876920106566 },
    { -0.193908574851, 0.889317676396, 0.414141926214 },
    { 41, DUMMYVAL, DUMMYVAL },
    { -0.714830378983, -0.012623816867, -0.699183930401 },
    { -0.971037225821, -0.105250594488, -0.214497129186 },
    { -0.851784621381, 0.431495998370, -0.297109680371 },
    { -0.014168563072, -0.973686527259, 0.227450650591 },
    { -0.872748577856, -0.446925514047, 0.196386111381 },
    { -0.176847607364, -0.915142191780, -0.362270192804 },
    { 0.299432785814, 0.766334068877, 0.568394318813 },
    { -0.731281169663, -0.191533186430, 0.654631873187 },
    { 0.844963547912, -0.533733865726, 0.034128628421 },
    { -0.703391145535, -0.575183355973, -0.417618250791 },
    { 0.278686278605, -0.185631425928, -0.942271156210 },
    { 0.488055051970, -0.790096917793, 0.370876160923 },
    { -0.559699214572, 0.326381343082, 0.761716488003 },
    { -0.324048886757, -0.494285885135, -0.806643528919 },
    { 0.106249369115, -0.649139910820, 0.753212086828 },
    { 0.516800637230, 0.656655601749, -0.549290926605 },
    { 0.955428920561, 0.028614315194, 0.293831241909 },
    { 0.958399527876, -0.084169366394, -0.272737717831 },
    { -0.529438351615, -0.846075716063, 0.062055737270 },
    { 0.144301734910, 0.427328730114, -0.892506115229 },
    { 0.007347457797, 0.871448558577, -0.490431875613 },
    { 0.599066198326, 0.263669993284, 0.756040888223 },
    { -0.421651897335, -0.676574696945, 0.603702208815 },
    { 0.756556547987, 0.570373330765, 0.319838167281 },
    { 0.410165229844, -0.889484234095, -0.201450444337 },
    { 0.436502526176, 0.899163672313, -0.031148596036 },
    { 0.293232844884, -0.158320861358, 0.942840921651 },
    { 0.682284515855, -0.475189584413, -0.555592205030 },
    { -0.434333122864, 0.527243879251, -0.730320909036 },
    { -0.686303230963, 0.680444119714, 0.256872877345 },
    { -0.484615370534, 0.841652466193, -0.238262604691 },
    { -0.253198768504, 0.758371086835, 0.600636061422 },
    { 0.191382675255, -0.683331558175, -0.704578351366 },
    { 0.024167911615, 0.362240325106, 0.931771355492 },
    { 0.673689816125, 0.130005326724, -0.727489275985 },
    { -0.940578253693, 0.193974799781, 0.278722668129 },
    { -0.260065830332, -0.176282747755, 0.949363026844 },
    { 0.872748567324, 0.446925536048, -0.196386108120 },
    { -0.083568070146, 0.989098558346, 0.121245286627 },
    { 0.708984554091, -0.340485490788, 0.617584433599 },
    { -0.234856411857, 0.031725737073, -0.971512194168 },
    { 42, DUMMYVAL, DUMMYVAL },
    { -0.263785465317, 0.456839943795, 0.849537812013 },
    { 0.070334282958, -0.555156279820, 0.828766911512 },
    { -0.704822863257, -0.218854042747, -0.674779696941 },
    { 0.325101048662, 0.944669504107, 0.043690229677 },
    { -0.742858956275, 0.664686145492, -0.079705075582 },
    { -0.055738577392, 0.847857471067, 0.527286373564 },
    { -0.475889015964, 0.680042655540, -0.557737959198 },
    { -0.238376924111, -0.427567978299, -0.871987423066 },
    { -0.874248266196, -0.296530606786, 0.384395067987 },
    { -0.883830572517, 0.234558129974, -0.404754249820 },
    { -0.133379144229, -0.891167555391, 0.433624713437 },
    { 0.473564539822, 0.706936767771, 0.525335162535 },
    { 0.874248267757, 0.296530612292, -0.384395060190 },
    { 0.466291023981, -0.733288655429, 0.494833738516 },
    { 0.788905532742, 0.248932651778, 0.561836804853 },
    { 0.272616839396, 0.355302913336, 0.894114030005 },
    { -0.960076106276, 0.210162399414, 0.184622956403 },
    { 0.073555449150, 0.559287818005, -0.825703780137 },
    { -0.644072714898, -0.746962188512, 0.164978261769 },
    { 0.328564013009, -0.944294178031, 0.018820060886 },
    { 0.015566822872, -0.808500233846, -0.588289933534 },
    { 0.535108039259, -0.722661148523, -0.437516000548 },
    { 0.824006848519, -0.566438044610, 0.012674983741 },
    { 0.997967999948, 0.000047816173, 0.063717099701 },
    { 0.381896197103, -0.374628000425, -0.844872271965 },
    { 0.441440726773, -0.156037903395, 0.883618841724 },
    { -0.632285028959, 0.619939959226, 0.464639741208 },
    { 0.802667199322, 0.591583372686, 0.075858290873 },
    { -0.297804637288, 0.952877893043, 0.057759146117 },
    { -0.575489772852, -0.699357673931, -0.423922593472 },
    { 0.838640829914, -0.244050152854, -0.486950799664 },
    { -0.484745589444, -0.502864114602, 0.715646138647 },
    { 0.544870421820, 0.196624545893, -0.815141099061 },
    { -0.456670266060, 0.233608005532, -0.858416896297 },
    { 0.032526996366, 0.031243070410, -0.998982414790 },
    { -0.202241819700, -0.972758133627, -0.113313105277 },
    { 0.522637499490, 0.713074460967, -0.467305956782 },
    { -0.168480533167, -0.075796774183, 0.982786425917 },
    { 0.807684213254, -0.305059492298, 0.504564086930 },
    { -0.937843127183, -0.306287564215, -0.163212122108 },
    { -0.680046414372, 0.088671419368, 0.727787231055 },
    { -0.005508983755, 0.914783170364, -0.403907665584 },
    { 43, DUMMYVAL, DUMMYVAL },
    { -0.355584897019, -0.086501779508, -0.930632485546 },
    { -0.739537956367, 0.625829085580, 0.247833748173 },
    { -0.603772940856, 0.742382658486, -0.290389779899 },
    { -0.643161683104, -0.765672467612, 0.009419221169 },
    { 0.710733105817, -0.654375620056, -0.258168549928 },
    { -0.786963007724, -0.449643682125, 0.422504181753 },
    { -0.802692693130, -0.066195703012, -0.592707827937 },
    { 0.671191084738, 0.738128467669, -0.068329298138 },
    { -0.935325830289, 0.300134190635, -0.187310060611 },
    { 0.232530524378, -0.810803419904, 0.537147437398 },
    { -0.265888257237, 0.767886007219, 0.582798862886 },
    { 0.855648272977, 0.277741616452, -0.436721452922 },
    { -0.189165680621, -0.959597068717, 0.208302210707 },
    { -0.588042146470, 0.358938620947, 0.724823771938 },
    { -0.017845957452, 0.354003557964, -0.935073795351 },
    { -0.650987616141, -0.574887396425, -0.495701124733 },
    { -0.331089598646, -0.683651448812, 0.650384789341 },
    { 0.869973111256, -0.071484101369, 0.487890160735 },
    { 0.281175273048, 0.899186809818, 0.335266381965 },
    { 0.209566917725, -0.250983185714, -0.945033939858 },
    { -0.167150393154, -0.923188248349, -0.346098546917 },
    { 0.191336167293, 0.587084872313, 0.786588725947 },
    { -0.564960277250, 0.407286073747, -0.717591763652 },
    { -0.959478915650, -0.268197079811, -0.086432267143 },
    { 0.516891085512, -0.408447250539, 0.752326025899 },
    { 0.311410413875, -0.724324847008, -0.615123621833 },
    { 0.175942995999, 0.962380395052, -0.207045978900 },
    { 0.722444805243, -0.263709994295, -0.639163940070 },
    { -0.926780322403, 0.091826463550, 0.364206170456 },
    { 0.946864303768, 0.305461626187, 0.100703451665 },
    { -0.141638384312, 0.783157967654, -0.605476808630 },
    { -0.273714731999, 0.958669082942, 0.077677763213 },
    { 0.320538877706, -0.946881706457, -0.025881689606 },
    { 0.459115605028, 0.110230276532, 0.881511286006 },
    { 0.436151835840, 0.670049726994, -0.600670408335 },
    { 0.736769734734, -0.612935501925, 0.285447768357 },
    { -0.204558970569, -0.584301723549, -0.785332492271 },
    { 0.680319688535, 0.515572322294, 0.520912950382 },
    { 0.974355367406, -0.205095630348, -0.092560252908 },
    { -0.117143222114, 0.186007316511, 0.975540231727 },
    { 0.011137881424, -0.352591670875, 0.935710992362 },
    { -0.541097967782, -0.174467609845, 0.822662775612 },
    { 0.492094986637, 0.196061966009, -0.848175824703 },
    { 44, DUMMYVAL, DUMMYVAL },
    { -0.609667972131, 0.697536734719, -0.376493648652 },
    { 0.682096145343, 0.660971273400, 0.312828745880 },
    { -0.829874632766, 0.295413455566, 0.473327565394 },
    { -0.227851026825, -0.311319708830, 0.922585469465 },
    { 0.204278896628, 0.801328277412, 0.562266061765 },
    { -0.383097561101, 0.671614426000, 0.634169000715 },
    { 0.459960476103, -0.172195185077, -0.871082762233 },
    { -0.682096202097, -0.660971270563, -0.312828628126 },
    { -0.332448883634, -0.740790495593, 0.583701277547 },
    { -0.459960493227, 0.172195212727, 0.871082747725 },
    { -0.127109825608, 0.933607374210, -0.334993079113 },
    { -0.254707123691, 0.075249075792, -0.964086021957 },
    { 0.328677349065, 0.944351047685, -0.013126269360 },
    { 0.227851015287, 0.311319740286, -0.922585461700 },
    { 0.554799335503, 0.346879932491, 0.756222196025 },
    { -0.022597663200, -0.408265850324, -0.912583333771 },
    { 0.914205621881, 0.177456342242, 0.364331343036 },
    { 0.609668041329, -0.697536666518, 0.376493662955 },
    { 0.829874575917, -0.295413522406, -0.473327623350 },
    { 0.186916668534, -0.961855596887, -0.199739755083 },
    { 0.254707141085, -0.075249106861, 0.964086014937 },
    { 0.127109920452, -0.933607361612, 0.334993078236 },
    { -0.204278991106, -0.801328286775, -0.562266014095 },
    { -0.741902996980, -0.632723056654, 0.221904206021 },
    { 0.022597675671, 0.408265817122, 0.912583348316 },
    { -0.186916765868, 0.961855581421, 0.199739738478 },
    { 0.383097513203, -0.671614449671, -0.634169004581 },
    { 0.332448963374, 0.740790510075, -0.583701213751 },
    { 0.669474827363, -0.725784970891, -0.158239159363 },
    { -0.701704541856, 0.234875739317, -0.672639668039 },
    { -0.669474898210, 0.725784903882, 0.158239166971 },
    { -0.974012476830, -0.149208158686, 0.170401350818 },
    { -0.937896861792, 0.324734480680, -0.122053241247 },
    { 0.711774880895, 0.272736630781, -0.647295333798 },
    { 0.937896874463, -0.324734486078, 0.122053129517 },
    { -0.711774908420, -0.272736579238, 0.647295325249 },
    { 0.974012460674, 0.149208119886, -0.170401477139 },
    { -0.914205575434, -0.177456322799, -0.364331469055 },
    { -0.554799311207, -0.346879987730, -0.756222188511 },
    { 0.701704612115, -0.234875680569, 0.672639615258 },
    { 0.226121988910, -0.597471085498, 0.769348521884 },
    { -0.328677357385, -0.944351043220, 0.013126382295 },
    { 0.741903023310, 0.632723072524, -0.221904072743 },
    { -0.226121942268, 0.597471109705, -0.769348516794 },
    { 45, DUMMYVAL, DUMMYVAL },
    { -0.682215705292, 0.307510611766, -0.663339245865 },
    { 0.271537467881, 0.650416421600, 0.709384156892 },
    { 0.705935324191, 0.460125669258, -0.538460478168 },
    { 0.066759812798, 0.760889820380, -0.645437687649 },
    { -0.999320082017, -0.020736390627, -0.030485665179 },
    { 0.307216565399, -0.422734828716, 0.852592075107 },
    { 0.730327729586, 0.410276336142, 0.546163652581 },
    { -0.499062491816, 0.636785239031, 0.587742450921 },
    { 0.817167914692, -0.458082820543, -0.349852438495 },
    { 0.861691356093, -0.475609619329, 0.176871413285 },
    { 0.518380436527, -0.848281643607, -0.108166427995 },
    { -0.832297159793, -0.551924414971, -0.051583698578 },
    { 0.389053649366, 0.143970518695, 0.909895459744 },
    { -0.845856488521, -0.169196587657, -0.505864918286 },
    { 0.646947495484, -0.089111779730, -0.757309731088 },
    { 0.838124930557, 0.545422119064, 0.007830249972 },
    { -0.106693908476, -0.123489166243, 0.986593551426 },
    { -0.614363140731, 0.107416872185, 0.781677393098 },
    { 0.047924885349, -0.982234246805, 0.181436186489 },
    { -0.468770075107, -0.430355511142, 0.771394030774 },
    { -0.144998215171, 0.404312927087, 0.903054026395 },
    { -0.561417657762, -0.621370090859, -0.546543158167 },
    { 0.130619667204, -0.145737649285, -0.980662551605 },
    { -0.860947355152, -0.264538485335, 0.434498609242 },
    { -0.859492526155, 0.473156303799, -0.193379703327 },
    { 0.425762333025, -0.592438257033, -0.683917646636 },
    { -0.527081404057, -0.771589651540, 0.356138460621 },
    { -0.054465623852, -0.753983071132, 0.654631976201 },
    { -0.440684830383, 0.761593170043, -0.475155473097 },
    { 0.489791345760, -0.746504581826, 0.450372453567 },
    { -0.055375104708, 0.990546860810, -0.125501053057 },
    { -0.390443234779, -0.910098983044, -0.138830549515 },
    { -0.560036720408, 0.824880403622, 0.077014229294 },
    { -0.872209640576, 0.341637079851, 0.350049208765 },
    { 0.447233834926, 0.860678981252, 0.243338423043 },
    { -0.213467378326, 0.355571779353, -0.909945266551 },
    { -0.086395528989, 0.911147742697, 0.402921336675 },
    { 0.326190713775, 0.350259148552, -0.878019445743 },
    { 0.071902243489, -0.915601056301, -0.395606841550 },
    { 0.739761969290, -0.193859838081, 0.644337327780 },
    { 0.953031457785, 0.049616741639, -0.298779549872 },
    { 0.447336595501, 0.846620633221, -0.288311417967 },
    { -0.103457561464, -0.598771524420, -0.794209792510 },
    { -0.427465686277, -0.155773291510, -0.890509836390 },
    { 0.973819789840, 0.049188110809, 0.221935906672 },
    { 46, DUMMYVAL, DUMMYVAL },
    { 0.062393200308, 0.996263899701, 0.059710390283 },
    { -0.488252433797, -0.470167805505, 0.735222276293 },
    { 0.884009289522, 0.372387572199, -0.282586397602 },
    { 0.026300392802, 0.785795152648, 0.617927396555 },
    { 0.561048736345, 0.451107444902, 0.694065118414 },
    { 0.295694467415, -0.892360873039, 0.340964593778 },
    { -0.941029805911, 0.246713325138, -0.231506888854 },
    { -0.826471387315, 0.446474838594, 0.342936239632 },
    { 0.527684861363, -0.521815622654, 0.670266471668 },
    { -0.011248944793, -0.705501738235, 0.708618909280 },
    { -0.890774727110, -0.369216143533, -0.264952495545 },
    { -0.359063230265, 0.049691787561, 0.931989443567 },
    { 0.811506056241, -0.542851182438, 0.216264917195 },
    { -0.063253259383, -0.397863631629, -0.915261468546 },
    { 0.239632954600, 0.115057759871, -0.964021658970 },
    { -0.065020534580, 0.556303792211, -0.828431301228 },
    { 0.198930252752, 0.856405633199, -0.476441125392 },
    { -0.781319470824, -0.550597168383, 0.293909242251 },
    { -0.024875062750, -0.995587775725, -0.090477688295 },
    { 0.495919845330, -0.028306349457, 0.867906825407 },
    { 0.524485747287, -0.843368770081, -0.116806757275 },
    { -0.219252881763, -0.806632398679, -0.548882817403 },
    { 0.048251991937, -0.262802290972, 0.963642413520 },
    { 0.477892274654, 0.811293407207, 0.336781800649 },
    { 0.773168231630, 0.013933468897, -0.634047903587 },
    { -0.561048732043, -0.451107443842, -0.694065122581 },
    { -0.982924644221, -0.073876104430, 0.168527341928 },
    { -0.583773382833, -0.795841522367, -0.160763518166 },
    { -0.295694468896, 0.892360871490, -0.340964596547 },
    { 0.457978580918, -0.348203241123, -0.817930389637 },
    { -0.339509257903, -0.881563243264, 0.327993463235 },
    { 0.869263210167, -0.065723276699, 0.489961143714 },
    { 0.077601869340, 0.354561738909, 0.931806805715 },
    { -0.754559246086, 0.023645332092, -0.655805796266 },
    { -0.406976258346, 0.868110635784, 0.284172921268 },
    { -0.565203002687, 0.521139485502, -0.639499180925 },
    { -0.712167054359, 0.692464882558, -0.115371023702 },
    { 0.293186574856, -0.767607295138, -0.569930410467 },
    { 0.515477344526, 0.492057818378, -0.701542736156 },
    { -0.452835858298, 0.528356117453, 0.718177901769 },
    { 0.799246469991, -0.468364848712, -0.376615783921 },
    { -0.773168229919, -0.013933469675, 0.634047905657 },
    { 0.876426127462, 0.412518030822, 0.248407160423 },
    { 0.599591230081, 0.783696282140, -0.162205099086 },
    { 0.994522379734, -0.092816728319, -0.048065488162 },
    { -0.311790222661, 0.075769640020, -0.947125028021 },
    { 47, DUMMYVAL, DUMMYVAL },
    { 0.479599741857, -0.313212335185, -0.819684159111 },
    { -0.062004559736, -0.093410676118, -0.993695063970 },
    { -0.731239245602, -0.597433984815, -0.329183534642 },
    { 0.313352873463, 0.598228719974, 0.737517711849 },
    { 0.771413794082, -0.459344253749, -0.440367590597 },
    { 0.533709864382, -0.845468841969, 0.018336246089 },
    { 0.097540548179, 0.113802901845, 0.988703565783 },
    { -0.633141626241, 0.766323852700, -0.108992815835 },
    { 0.819581794644, 0.544272357316, -0.179034306627 },
    { 0.388674537623, 0.911175403721, -0.136716814832 },
    { -0.223896739304, -0.861370521749, -0.455972668468 },
    { -0.041946331144, 0.451250446054, -0.891410982791 },
    { -0.882406553961, -0.049818792730, 0.467842667377 },
    { 0.058440848044, 0.832802774173, -0.550476345186 },
    { 0.576641621053, 0.755196766591, 0.311708653391 },
    { -0.451692912495, -0.430772866021, -0.781286279607 },
    { 0.063693280986, 0.922949511399, 0.379614759152 },
    { -0.585856791847, -0.400185007130, 0.704715389015 },
    { -0.454369606221, 0.806671839822, 0.377926982074 },
    { 0.048340013083, -0.584773219302, -0.809755225437 },
    { 0.864750138438, -0.152332460970, 0.478541554525 },
    { 0.162119975333, -0.822595395293, 0.545026539942 },
    { -0.159907546060, 0.982225483184, -0.098298916054 },
    { 0.528720193975, 0.598132904979, -0.602239142255 },
    { -0.407718567645, 0.039843109404, 0.912237960310 },
    { 0.818665549442, 0.094907834946, -0.566373746763 },
    { -0.459995770340, -0.887835040633, 0.012362519687 },
    { -0.812132345956, -0.540625100931, 0.219466518848 },
    { -0.335569185903, -0.799202944618, 0.498666195752 },
    { 0.600128324369, 0.188354183421, 0.777411535725 },
    { 0.047392268942, -0.998432906074, 0.029760794902 },
    { -0.991550636154, -0.113994058770, -0.061908727240 },
    { 0.890114384312, -0.453761677624, 0.042387766642 },
    { 0.995416049303, 0.033497066900, -0.089581445064 },
    { 0.403392193128, 0.189589522905, -0.895170682791 },
    { -0.192040425034, 0.564962471751, 0.802457401153 },
    { -0.669442724060, 0.398850290951, 0.626709569587 },
    { -0.848362757458, 0.353222092590, -0.394353629455 },
    { -0.508353967446, 0.174080331430, -0.843369599874 },
    { 0.874549954027, 0.351959445930, 0.333596951922 },
    { 0.347562326304, -0.819476260756, -0.455696266599 },
    { -0.819429171319, -0.136007100076, -0.556810472172 },
    { -0.083487750828, -0.442941688695, 0.892654723775 },
    { 0.411048542604, -0.314893278260, 0.855500624739 },
    { -0.905933785769, 0.396930635400, 0.147411147756 },
    { -0.448773091928, 0.669482800787, -0.591942135189 },
    { 0.612584346699, -0.619220680780, 0.491229240450 },
    { 48, DUMMYVAL, DUMMYVAL },
    { 0.163688549564, 0.984688542446, 0.059954425335 },
    { -0.500277128690, 0.814119712284, 0.294842141799 },
    { -0.297856569007, 0.941384704604, -0.158354988038 },
    { -0.401229778258, 0.220239464714, -0.889105867274 },
    { 0.266172151670, -0.814357665745, -0.515726650385 },
    { 0.207823533419, 0.523782628562, 0.826112060785 },
    { 0.527999192123, 0.532356144669, -0.661674986946 },
    { 0.359430188460, 0.003147648123, 0.933166668894 },
    { -0.594780397179, -0.264621468023, -0.759086133316 },
    { 0.837348035716, -0.522720403083, 0.160036393621 },
    { 0.446821707551, -0.759548130317, 0.472691230502 },
    { 0.859069372620, 0.483292994031, 0.168605145079 },
    { 0.127800517552, 0.868353243385, -0.479196903596 },
    { -0.910665279721, -0.221572739485, -0.348703698614 },
    { 0.734934131339, -0.031922950367, -0.677386704795 },
    { 0.972376422335, -0.136507628858, -0.189340329965 },
    { 0.687018814114, 0.301170637668, 0.661287680257 },
    { 0.731364643691, -0.527911852100, -0.431757842280 },
    { 0.366798643539, -0.414977500246, -0.832617817121 },
    { -0.433579877873, 0.682712229308, -0.588143266098 },
    { -0.132707997577, 0.137360972349, 0.981590826493 },
    { 0.218720840710, -0.482197604217, 0.848319906832 },
    { -0.611591700399, -0.683774431108, -0.398005175049 },
    { 0.315216939765, 0.124597281675, -0.940804867273 },
    { -0.094732178670, -0.180426907922, -0.979015804378 },
    { 0.700386201511, -0.299760593932, 0.647767516212 },
    { 0.070416415701, -0.984450619107, 0.160930130612 },
    { 0.952464936500, -0.001814340212, 0.304642828420 },
    { -0.758351482434, 0.636105478355, -0.142382757019 },
    { -0.141042324284, -0.791517247350, 0.594649064497 },
    { -0.920780504104, -0.125212714031, 0.369438817000 },
    { -0.633604968000, 0.032025935559, 0.772993585987 },
    { -0.038732024763, 0.857423635510, 0.513151575586 },
    { 0.878980883154, 0.348599700461, -0.325378019983 },
    { -0.983058036030, 0.179331496599, -0.037909261722 },
    { -0.174370064971, -0.941864635561, -0.287203914877 },
    { 0.584604945900, 0.791968040545, -0.176135402418 },
    { -0.792624565974, 0.263211445016, -0.549969119703 },
    { 0.008719335205, 0.525263630355, -0.850894877068 },
    { 0.497020718863, 0.760507374782, 0.417850377435 },
    { -0.389131275223, 0.528259657395, 0.754664551315 },
    { 0.510958637160, -0.856943703150, -0.067592608636 },
    { -0.629328372261, -0.532459129340, 0.566068083758 },
    { -0.848387762201, -0.526116947648, 0.058644371812 },
    { -0.470033904253, -0.868701039151, 0.156290221799 },
    { -0.185490948962, -0.637064749774, -0.748158814991 },
    { -0.810361268076, 0.414526677814, 0.414104151854 },
    { -0.273417349062, -0.347984277445, 0.896744052605 },
    { 49, DUMMYVAL, DUMMYVAL },
    { 0.595826092007, -0.305136263796, 0.742888368869 },
    { 0.826401949417, 0.166561819066, 0.537881937258 },
    { 0.514604932878, 0.849298082087, 0.117790198321 },
    { 0.038334880302, 0.636631397462, 0.770214840624 },
    { -0.157533200167, -0.070337093337, -0.985005575693 },
    { -0.785131967327, 0.576413645169, 0.226528372494 },
    { -0.556242066261, -0.282059814813, -0.781688572636 },
    { 0.529851544971, 0.620803118093, 0.577806913127 },
    { -0.980835428359, 0.189204347454, -0.046514270714 },
    { 0.493328376277, -0.852519291606, -0.172736708894 },
    { 0.897128098337, -0.300408284833, 0.323907452180 },
    { 0.870853522386, 0.474638205683, 0.127799515862 },
    { -0.744521608839, 0.577969848544, -0.334123372644 },
    { -0.843623136717, -0.408472377034, -0.348497231546 },
    { 0.193465596372, 0.747435786154, -0.635539777352 },
    { 0.077185457455, 0.939174000812, 0.334655944749 },
    { 0.998568764030, -0.003965847821, -0.053335687441 },
    { -0.381238382928, 0.808002806319, 0.449209038603 },
    { -0.505650603583, 0.321205781477, -0.800714876246 },
    { -0.245768898317, -0.964925834267, -0.092281000130 },
    { -0.038722930046, -0.549512288302, -0.834587790286 },
    { 0.857490994287, 0.313524211266, -0.407935979863 },
    { 0.489795156071, -0.584973373683, -0.646457158033 },
    { 0.350838824202, -0.152097203280, -0.924001385381 },
    { -0.249199756550, -0.522150924662, 0.815633430660 },
    { -0.305844445642, -0.849203149330, 0.430480181005 },
    { -0.316256223390, 0.757447622806, -0.571187447230 },
    { 0.136953363606, -0.238437767025, 0.961452654816 },
    { 0.080289318459, -0.882482857894, -0.463441075936 },
    { 0.515321321275, 0.318552713840, -0.795592926278 },
    { -0.114246093835, 0.200622553508, 0.972984286136 },
    { 0.164227524172, -0.963800527309, 0.210042528699 },
    { -0.678895901090, -0.733201115386, 0.038942006616 },
    { -0.452912700043, -0.727294687138, -0.515667067206 },
    { -0.425139624221, 0.903229939210, -0.058583076330 },
    { 0.593554101574, 0.724239499334, -0.350956800916 },
    { 0.785926823765, -0.158659440765, -0.597617109480 },
    { -0.849155645086, 0.078325284916, -0.522302441275 },
    { 0.066486393704, 0.979309146587, -0.191136482294 },
    { -0.951513069275, -0.277883202724, 0.131923480259 },
    { 0.007869353746, 0.387001655011, -0.922045439385 },
    { 0.847514336955, -0.493928593783, -0.194303867435 },
    { 0.622557438770, -0.712408304545, 0.323877512414 },
    { 0.223754034188, -0.706741814296, 0.671155824015 },
    { -0.865213047085, 0.098712140323, 0.491591595235 },
    { -0.521234317109, -0.092705038586, 0.848363461312 },
    { -0.702689408457, -0.476554263661, 0.528321520505 },
    { 0.421997653268, 0.211103500168, 0.881676410512 },
    { -0.529465143985, 0.429344645215, 0.731662379059 },
    { 50, DUMMYVAL, DUMMYVAL },
    { 0.345950202463, 0.134952798191, 0.928496741877 },
    { 0.540226388282, -0.036546001698, -0.840725781194 },
    { -0.688871061940, 0.120754960957, -0.714755132494 },
    { 0.876940764856, -0.099666781859, -0.470150430743 },
    { 0.490308595945, 0.831528641449, 0.261070103980 },
    { -0.981629370780, -0.168956560826, 0.088642309181 },
    { -0.433932796660, -0.380477138631, -0.816663624121 },
    { -0.302697324356, 0.943161306286, 0.137189941877 },
    { 0.013472161745, -0.698394120564, -0.715586579820 },
    { 0.402856661598, -0.854647062781, -0.327543750187 },
    { 0.202688365634, 0.773632962419, -0.600341124608 },
    { -0.819937946252, -0.106039513309, 0.562545452308 },
    { -0.202688306354, -0.773632958108, 0.600341150177 },
    { 0.100249534757, -0.975743313088, 0.194615050148 },
    { -0.674241338866, 0.564940331322, -0.475648020085 },
    { -0.791117634676, -0.607222663843, -0.073576658115 },
    { 0.191220850496, 0.334239243737, -0.922886078713 },
    { 0.044752760259, 0.867562650205, 0.495310244613 },
    { 0.538943298840, -0.517430363306, -0.664684842436 },
    { -0.495173176245, 0.684494854179, 0.535042353585 },
    { 0.911770457658, 0.341674990332, -0.227887765193 },
    { -0.950991020747, 0.220485441165, -0.216800020047 },
    { -0.252779484830, 0.075086696925, -0.964605888430 },
    { 0.477702903593, 0.547541647280, 0.687021164443 },
    { -0.413067988531, -0.903482924333, 0.114426580342 },
    { 0.153910047829, 0.983076983521, -0.099354625702 },
    { -0.685882957380, -0.586397723182, 0.430931872833 },
    { 0.826414389352, -0.423477316534, 0.371087886427 },
    { -0.147584885441, 0.047875501508, 0.987889992836 },
    { -0.089944251700, -0.954490815455, -0.284354206578 },
    { 0.553588533962, -0.299392663388, 0.777112455296 },
    { 0.994761159095, -0.053420961083, 0.087157542836 },
    { -0.281308266022, 0.883446975409, -0.374682667211 },
    { -0.057242320513, 0.531329643077, 0.845229038267 },
    { 0.067937132138, -0.413833281332, 0.907814166743 },
    { -0.501165211527, -0.727386662227, -0.468766545703 },
    { 0.607783779242, 0.758288104998, -0.235792339800 },
    { -0.262652866869, 0.559028113066, -0.786448371050 },
    { 0.340752102988, -0.730918494857, 0.591308851773 },
    { -0.558071669769, 0.262213195300, 0.787273936830 },
    { -0.445380394417, -0.341572908841, 0.827625671554 },
    { 0.844086056029, 0.471678919713, 0.255024953122 },
    { -0.721725799634, 0.692100635107, 0.010420222026 },
    { 0.582408860142, -0.800575817978, 0.140990351787 },
    { -0.846741859477, -0.272358270440, -0.457000214369 },
    { 0.802971709426, 0.105293788125, 0.586642695381 },
    { 0.626439181439, 0.433869213877, -0.647558072460 },
    { 0.110462185052, -0.275128766076, -0.955040453463 },
    { -0.882099101544, 0.342503580101, 0.323407595261 },
    { 0.838328951329, -0.509568094241, -0.193765132816 },
    { 51, DUMMYVAL, DUMMYVAL },
    { -0.797738543869, -0.581451305640, -0.159773573520 },
    { 0.230060749563, -0.953163359436, 0.196345770870 },
    { 0.064853834751, 0.149002046215, 0.986707844472 },
    { -0.742959991439, 0.098485889487, -0.662050587714 },
    { -0.410706663487, 0.422809199189, -0.807807166128 },
    { -0.618705703929, -0.733203418229, 0.282163072393 },
    { 0.211333390885, 0.939599756260, 0.269240591169 },
    { -0.178312206509, -0.571426219658, -0.801047334742 },
    { 0.343070938501, -0.691762975804, 0.635426090479 },
    { 0.751098608747, -0.338262285885, 0.566947533627 },
    { -0.956121789102, 0.232892821414, 0.177741548713 },
    { -0.678757827764, 0.504465636346, 0.533668654687 },
    { 0.403888733409, -0.221945708632, 0.887476193171 },
    { 0.243219569498, 0.932676139742, -0.266382167888 },
    { -0.272230358412, 0.854519502483, 0.442365292304 },
    { -0.291198313408, 0.480852567270, 0.827033464146 },
    { 0.496306497336, -0.834688044498, -0.238695892455 },
    { 0.627336665467, 0.636340877070, 0.448908672594 },
    { -0.915175200031, -0.298053895187, 0.271326793391 },
    { -0.390006829824, -0.025603297491, 0.920455943458 },
    { -0.221417843034, 0.973020269788, -0.064851317402 },
    { -0.552308207566, -0.463962502004, 0.692599769411 },
    { 0.694359483256, -0.685669113003, 0.218455431348 },
    { 0.312037206503, -0.649502784478, -0.693382228438 },
    { 0.653881962743, -0.303143144686, -0.693211809355 },
    { 0.063247456544, 0.307064364039, -0.949584770085 },
    { 0.759341902013, 0.493235137943, -0.424404258397 },
    { -0.538812431071, 0.737030355050, -0.408004190980 },
    { -0.673811457431, 0.732878229225, 0.094168046402 },
    { 0.635442965817, 0.771657345448, -0.027516875015 },
    { 0.924514315940, 0.022908957797, -0.380458222772 },
    { 0.562299737077, 0.169594434229, -0.809355752164 },
    { -0.776870591894, 0.023185322703, 0.629233282863 },
    { 0.851315167683, 0.147851541729, 0.503390908621 },
    { 0.165466810497, 0.675385154414, 0.718662387927 },
    { -0.059044946248, -0.430880328800, 0.900475339238 },
    { -0.096389554335, 0.780087779549, -0.618200703666 },
    { -0.257240467875, -0.964889510898, 0.053061977401 },
    { -0.440859648253, -0.798861441639, -0.409222638187 },
    { 0.369337877392, 0.634539886385, -0.678932003157 },
    { 0.504034501502, 0.287582446097, 0.814398893659 },
    { 0.833937750071, -0.485034219794, -0.263229243502 },
    { -0.869985734358, 0.402213760144, -0.285217308668 },
    { 0.975327919850, -0.188766606009, 0.114466664218 },
    { -0.156937883116, -0.814625792369, 0.558350534388 },
    { -0.964986939058, -0.115894880020, -0.235305300053 },
    { -0.316620702612, -0.087501695839, -0.944507693935 },
    { -0.657876212252, -0.389181932337, -0.644776172711 },
    { 0.031535704496, -0.929089858394, -0.368507170040 },
    { 0.936441680733, 0.346913775153, 0.052228451969 },
    { 0.191384617080, -0.200228875667, -0.960874771078 },
    { 52, DUMMYVAL, DUMMYVAL },
    { 0.416971183993, -0.800108574471, -0.431232304885 },
    { -0.478160533337, 0.736772429745, -0.478046954939 },
    { -0.218896429162, -0.039479877852, 0.974949071770 },
    { 0.243161798996, -0.838340787703, 0.487910917261 },
    { 0.230875742318, 0.329445213124, -0.915512011477 },
    { 0.410615081877, -0.464321961026, 0.784729489088 },
    { 0.837490267717, -0.528837748436, -0.137625169602 },
    { -0.926520772745, 0.266829853761, 0.265256643300 },
    { 0.851910807978, 0.482655934494, -0.203202421610 },
    { -0.801215206184, -0.248157885467, -0.544492293114 },
    { -0.984515763801, 0.041162384930, -0.170394744330 },
    { -0.770928995335, 0.319775506339, -0.550828566523 },
    { 0.034539937131, -0.999303379203, 0.014133260677 },
    { 0.312643907190, 0.747532471575, 0.586045212623 },
    { -0.078289149167, 0.961561326103, -0.263193133013 },
    { 0.910646449751, 0.308314661046, 0.275072923677 },
    { -0.804267550227, 0.583929202552, -0.110364822557 },
    { 0.647851839596, 0.729720182278, 0.218623991154 },
    { -0.568096921506, -0.692958167045, -0.443931150632 },
    { 0.716831388699, -0.572694080252, 0.397711265391 },
    { -0.701521235840, 0.084769400408, 0.707588937464 },
    { 0.293576563703, -0.021193916490, 0.955700590744 },
    { 0.503411473027, -0.862953389394, 0.043454994641 },
    { -0.440677232733, -0.897422065932, -0.020909618086 },
    { -0.540207910032, -0.392075514725, 0.744615474384 },
    { -0.652501746619, 0.619341032676, 0.436644198293 },
    { 0.612312103503, 0.373868468860, 0.696632080725 },
    { -0.435125495242, 0.897452226614, 0.072424473322 },
    { -0.375800545201, 0.427140890784, 0.822389572920 },
    { -0.294459857877, 0.430822706491, -0.853044657489 },
    { -0.087979663444, -0.878617618448, -0.469351317643 },
    { 0.423079263126, -0.142619073794, -0.894798154280 },
    { 0.707756639883, -0.396494168980, -0.584698993216 },
    { 0.743970173749, -0.090556730259, 0.662048230250 },
    { 0.743824920129, 0.146914637182, -0.652028049686 },
    { -0.240798829805, -0.839629473694, 0.486865762268 },
    { -0.525213942616, -0.006017644395, -0.850948942321 },
    { 0.967933457454, -0.014948622926, -0.250761561275 },
    { -0.913594597626, -0.217140115365, 0.343795115567 },
    { -0.191267338197, 0.815833017992, 0.545741048570 },
    { -0.319697875088, -0.491331424317, -0.810176956068 },
    { -0.673181917375, -0.654879228571, 0.343452037562 },
    { 0.961961294234, -0.171497109789, 0.212648088939 },
    { 0.104889227913, 0.424516691722, 0.899324095261 },
    { 0.541898990433, 0.586983658864, -0.601494528981 },
    { -0.872455645647, -0.479896206606, -0.092308056326 },
    { -0.062364879065, -0.081226949494, -0.994742582046 },
    { 0.129079358522, 0.974960279012, 0.181082780936 },
    { -0.068267747908, -0.514331516090, 0.854869935225 },
    { 0.179325041353, -0.566911263349, -0.804023724172 },
    { 0.440578561317, 0.870449917394, -0.219562001757 },
    { 0.058544481762, 0.743454307625, -0.666219360367 },
    { 53, DUMMYVAL, DUMMYVAL },
    { 0.468258406782, -0.669611946278, 0.576501436146 },
    { 0.752789014546, -0.154499398924, -0.639873921419 },
    { -0.765210725447, -0.568677411433, 0.301759088326 },
    { -0.321908732514, -0.803377230404, -0.500958874161 },
    { -0.527490116410, 0.063522460187, 0.847183022812 },
    { -0.478578652649, -0.877842958762, 0.018820546770 },
    { -0.531818511874, -0.395658446452, -0.748747931002 },
    { -0.353429221698, -0.792459055647, 0.497087950339 },
    { 0.448124303911, -0.892976533845, 0.042160624357 },
    { 0.522724158121, 0.839690652026, 0.147238118083 },
    { -0.161258862951, 0.826534565240, -0.539292306253 },
    { 0.929686876867, 0.233425826217, -0.284946827736 },
    { 0.024635913291, -0.566943363196, 0.823388301292 },
    { -0.469584851084, -0.418946961764, 0.777157326969 },
    { -0.304455003066, 0.466814431258, -0.830295994136 },
    { -0.948193996780, 0.242910595761, 0.204750059675 },
    { 0.539070139184, 0.614676297200, 0.575826740176 },
    { -0.842019684617, -0.128966797105, 0.523803795291 },
    { -0.650975540074, 0.155320439833, -0.743038631025 },
    { 0.273546839212, 0.289083994982, 0.917388996338 },
    { -0.075916060460, -0.084614554278, 0.993517553428 },
    { 0.304099621562, -0.099953222425, -0.947382063105 },
    { -0.745199541096, -0.606986825273, -0.276124316017 },
    { -0.221372453198, -0.048578994977, -0.973978602543 },
    { 0.206613387927, 0.952413250949, -0.224097986036 },
    { 0.725332597573, 0.187438598420, 0.662389156554 },
    { 0.400032972439, -0.211825581185, 0.891685787773 },
    { -0.690068020367, 0.443620524271, 0.571845221815 },
    { -0.624076566815, 0.642685410318, -0.444391608963 },
    { 0.429002178652, -0.517516743521, -0.740360419585 },
    { 0.943878958726, -0.262801413489, -0.200069808673 },
    { -0.034660261006, -0.996493271082, -0.076156595221 },
    { 0.686315961538, 0.663435427139, -0.298033278269 },
    { -0.732057259621, 0.677575692491, 0.070592843699 },
    { -0.870170249530, -0.170273647447, -0.462396606625 },
    { 0.864883117139, 0.467346196069, 0.183206786742 },
    { -0.229743220474, 0.442709077697, 0.866733364519 },
    { 0.088702032301, 0.735049232434, 0.672186414147 },
    { -0.389616109870, 0.802647938204, 0.451614408789 },
    { -0.913833675073, 0.290954467876, -0.283290508004 },
    { 0.804252988328, -0.568980631673, 0.171575556378 },
    { 0.045128090383, 0.967342332511, 0.249423870531 },
    { 0.771682800328, -0.283718128037, 0.569218481342 },
    { 0.145912517352, 0.346438821937, -0.926655103010 },
    { 0.630422680467, 0.307383591295, -0.712799110378 },
    { 0.976554655787, -0.001833259404, 0.215261802049 },
    { -0.975405314228, -0.219969945790, 0.014060438256 },
    { -0.055869574567, -0.522870022104, -0.850579526337 },
    { 0.090489351080, -0.911108524567, 0.402110598968 },
    { 0.316337065116, 0.698882440377, -0.641478133506 },
    { 0.670867163401, -0.659984877703, -0.338167429349 },
    { -0.339017422560, 0.937486273109, -0.078655418963 },
    { 0.192643370857, -0.857653574427, -0.476779695391 },
    { 54, DUMMYVAL, DUMMYVAL },
    { -0.756264223202, 0.237556732782, -0.609615635802 },
    { 0.280897709855, 0.347142128273, 0.894756290493 },
    { 0.017916617952, 0.697854282723, -0.716015638717 },
    { 0.283720472038, -0.853500459898, 0.437080837718 },
    { 0.747460851316, 0.630773829519, 0.208390622974 },
    { -0.428926280251, 0.733314074512, -0.527515605677 },
    { -0.622457805172, -0.735312407024, 0.268070783298 },
    { -0.747428485226, -0.630988528775, -0.207856046407 },
    { -0.047904023334, -0.153805689359, 0.986939215185 },
    { 0.934464044162, -0.324824365348, 0.145828947209 },
    { 0.341111463528, -0.149067435967, -0.928128153319 },
    { 0.248586766917, 0.339160001853, -0.907289982562 },
    { 0.382442564142, 0.772764318279, 0.506530348081 },
    { 0.390657078850, -0.598438590702, -0.699470013584 },
    { -0.983810902544, 0.147726455694, -0.101454434721 },
    { -0.602892458156, 0.419634024408, 0.678548428233 },
    { -0.752897651831, -0.370916833927, 0.543659662084 },
    { 0.965173615503, 0.194793877620, 0.174628855518 },
    { -0.869486279302, -0.219226308270, -0.442643689516 },
    { -0.359710695342, -0.924002289440, -0.129722722626 },
    { -0.200888258240, -0.879458686474, 0.431504723596 },
    { 0.727448247860, -0.205292725471, -0.654731963137 },
    { 0.463200052135, 0.718959124864, -0.518211818156 },
    { -0.120991303056, -0.012081198992, -0.992580046755 },
    { 0.009384565645, 0.957074974297, -0.289688493906 },
    { 0.019092244133, 0.974445065505, 0.223813092842 },
    { -0.543879102646, -0.182187832932, -0.819147798163 },
    { -0.782190093092, 0.569499120436, -0.252684408090 },
    { -0.900012712368, 0.095613357781, 0.425247226199 },
    { -0.421632774317, 0.801959302348, 0.423186815720 },
    { -0.949151249095, -0.301393190272, 0.090961811760 },
    { -0.338669752610, -0.544983236267, 0.767004609410 },
    { 0.802775509119, -0.515650981982, -0.299425360881 },
    { -0.807336749475, 0.545997153377, 0.223817964990 },
    { 0.676909572577, 0.373035729886, 0.634537449471 },
    { 0.961011116076, 0.003964144293, -0.276481320053 },
    { -0.048714538886, 0.707785529287, 0.704745725941 },
    { 0.438666054248, -0.120307680486, 0.890560584613 },
    { 0.626268880927, -0.512397664756, 0.587567801990 },
    { 0.443147774033, 0.895023330099, -0.050530079640 },
    { -0.201184306524, 0.304372889259, 0.931064991873 },
    { -0.036303135198, -0.859938459607, -0.509105026556 },
    { -0.435792101192, 0.898728863601, -0.048699838492 },
    { -0.355120428594, 0.369625960674, -0.858642026919 },
    { -0.540185107383, -0.060331630721, 0.839380809940 },
    { 0.091986657231, -0.995681232727, 0.012543432043 },
    { 0.678511341680, 0.279745881842, -0.679238250399 },
    { 0.827314260764, 0.499803804844, -0.256412305868 },
    { 0.819931867972, -0.075072353884, 0.567517289223 },
    { 0.651967848159, -0.746142310145, 0.134942869314 },
    { -0.482825466766, -0.631040715698, -0.607179696444 },
    { -0.079127269441, -0.493065208674, -0.866386504527 },
    { 0.156236123606, -0.566944938174, 0.808803876573 },
    { 0.429492147162, -0.854249728161, -0.292905953275 },
    { 55, DUMMYVAL, DUMMYVAL },
    { -0.387747134121, -0.296393661931, 0.872813242996 },
    { -0.946163995722, -0.081321931027, 0.313305660232 },
    { 0.922518214794, -0.384882209717, 0.028737223536 },
    { -0.444901340191, -0.161185017106, -0.880955270009 },
    { 0.088648379736, -0.929886599560, 0.357004729282 },
    { -0.398858764491, 0.828672486485, 0.392700389778 },
    { -0.707421617532, 0.031786637059, 0.706076670591 },
    { -0.441719326768, 0.343437931108, -0.828815072158 },
    { 0.984543274106, 0.070601203125, -0.160281039210 },
    { -0.816864993569, 0.449497285481, 0.361502105980 },
    { -0.973222292055, -0.160402482040, -0.164649366846 },
    { 0.365922889995, 0.925434114895, -0.098347026224 },
    { -0.697928959906, -0.475145821454, 0.535846634103 },
    { -0.194286490773, 0.979839225871, -0.046560186303 },
    { 0.421934676133, -0.626891396224, -0.654964355074 },
    { 0.918294577668, -0.058522138943, 0.391548500034 },
    { -0.951258678509, 0.302296624642, -0.061021941069 },
    { 0.482260349695, -0.174024786406, -0.858568767676 },
    { -0.017747824887, 0.566474680917, -0.823888008525 },
    { -0.008439275026, -0.843382140828, -0.537247934542 },
    { -0.022003496707, 0.063860489010, -0.997716234245 },
    { 0.302920122261, -0.640449793751, 0.705736113015 },
    { 0.605795821812, 0.751026435800, 0.262622761778 },
    { -0.801088034306, 0.039519118666, -0.597240488038 },
    { -0.197614702014, -0.693865338491, 0.692458895234 },
    { -0.822315620723, -0.565236505598, 0.065610309056 },
    { -0.531572028134, -0.807120477633, -0.256880737876 },
    { 0.900257095184, 0.382874752951, 0.207229549349 },
    { 0.043757932112, -0.416578339326, -0.908046105978 },
    { -0.654348201408, 0.755830304425, -0.023430369769 },
    { 0.380464261169, 0.645279718315, 0.662465871652 },
    { 0.819307000804, -0.266629899103, -0.507586973175 },
    { 0.721142532083, -0.480787014528, 0.498795845093 },
    { 0.549296621645, -0.805702982944, 0.221621128787 },
    { 0.696135340591, -0.669944149585, -0.258012449344 },
    { -0.364655265727, -0.606149719157, -0.706830287370 },
    { 0.090729077048, -0.273405988981, 0.957610254627 },
    { -0.511611491293, 0.471016167011, 0.718607996331 },
    { 0.693341730595, 0.289001415041, 0.660117737014 },
    { -0.751543758000, 0.486149073628, -0.445915976414 },
    { 0.780508167624, 0.586409922872, -0.216634260053 },
    { 0.100583708102, 0.932608599035, 0.346589265082 },
    { -0.219939025696, 0.158237287980, 0.962594299624 },
    { 0.780300794447, 0.223992497730, -0.583916116532 },
    { -0.755047655881, -0.439220995009, -0.486814086579 },
    { 0.478715333951, 0.665543534564, -0.572611065768 },
    { -0.152870187393, -0.986482345681, -0.059019382124 },
    { 0.388991446276, 0.292599882564, -0.873539331368 },
    { 0.066544469261, 0.886002068699, -0.458881431170 },
    { 0.306611784146, -0.934865622332, -0.178928706485 },
    { -0.072445525400, 0.640718077698, 0.764350698803 },
    { -0.456711407833, -0.838931327882, 0.295988035322 },
    { -0.392354846453, 0.776467536851, -0.493108343755 },
    { 0.550316062949, -0.160226448479, 0.819438659125 },
    { 0.252720179080, 0.232824243654, 0.939108823648 },
    { 56, DUMMYVAL, DUMMYVAL },
    { 0.074538498200, -0.790884370094, -0.607409191095 },
    { 0.683170035013, -0.529546497136, 0.502851081964 },
    { 0.214936703480, -0.035817013269, -0.975970980643 },
    { -0.326091441721, 0.741530490107, 0.586341968374 },
    { 0.832898816396, 0.301764661929, -0.463915563932 },
    { -0.182966598151, -0.219317217515, 0.958343978988 },
    { 0.537763602956, 0.338666792633, 0.772084911718 },
    { -0.273067637409, -0.947869295777, -0.164249394285 },
    { 0.532673456840, 0.728415867693, -0.430893620365 },
    { 0.868727090757, -0.495282538977, -0.002906607957 },
    { -0.758007527162, 0.566726846567, -0.322870361207 },
    { -0.421051702028, 0.563268075532, -0.710946228139 },
    { 0.092287506654, 0.981279437165, -0.169037517471 },
    { -0.792280170550, -0.529745158160, 0.302757656814 },
    { 0.847888420113, 0.529189483797, -0.032306613527 },
    { 0.594497094873, -0.707481742363, -0.382155450584 },
    { -0.695619500465, -0.704923975211, -0.138548546533 },
    { -0.882180781294, -0.048826582604, 0.468372751072 },
    { 0.537711162987, -0.832818451027, 0.131453919032 },
    { 0.139147022774, 0.623136983976, 0.769635241692 },
    { 0.854930425925, -0.281821409049, -0.435511951879 },
    { -0.276544222532, 0.060257123569, -0.959110198071 },
    { -0.565997758283, -0.434567548961, 0.700569470509 },
    { 0.644102083874, -0.034029601835, -0.764182237263 },
    { 0.430185117283, -0.475110276710, -0.767600801089 },
    { -0.570811542768, 0.043326850942, 0.819937172368 },
    { 0.927083158457, -0.152842837627, 0.342280417628 },
    { -0.526401483787, -0.309586350521, -0.791869793235 },
    { 0.643019765557, -0.110451366703, 0.757843042256 },
    { -0.938445275388, 0.123762416842, -0.322495471719 },
    { 0.286683338869, -0.764293208293, 0.577640506692 },
    { 0.502325702230, 0.864383378212, 0.022589031636 },
    { 0.455420826739, 0.420540224976, -0.784689613637 },
    { -0.159865813802, -0.681123196631, 0.714502702996 },
    { -0.064714729123, -0.432632970826, -0.899244525359 },
    { 0.214067015549, -0.956388650228, -0.198736163215 },
    { 0.003271117297, 0.429654975187, -0.902987210368 },
    { 0.569053017361, 0.688397944297, 0.449763197383 },
    { -0.410447463059, -0.714951837268, -0.566018330494 },
    { 0.062124718503, 0.793926757322, -0.604831235437 },
    { -0.376864572550, 0.865421797454, -0.330179052105 },
    { 0.129532938748, 0.917462073592, 0.376144335726 },
    { -0.434932350055, -0.841219491968, 0.321222068371 },
    { -0.975678866204, -0.219108540471, 0.006495962966 },
    { -0.943159339572, 0.304778587405, 0.132515934279 },
    { 0.995128726099, 0.040167615274, -0.090029890452 },
    { -0.243111509941, 0.359434038885, 0.900946150125 },
    { -0.686357415121, 0.713271758361, 0.141974988760 },
    { -0.698590765530, 0.441061495076, 0.563414323457 },
    { 0.018289455790, -0.967252146352, 0.253157621226 },
    { -0.824315339720, -0.353561314349, -0.442152256240 },
    { 0.173326266297, 0.108057400404, 0.978918588867 },
    { 0.868790034924, 0.302232839910, 0.392248882340 },
    { 0.268782736888, -0.387533563648, 0.881801325354 },
    { -0.687494520004, 0.161779890079, -0.707939652888 },
    { -0.287357531035, 0.947091346371, 0.142981225996 },
    { 57, DUMMYVAL, DUMMYVAL },
    { -0.927085818980, -0.318927489805, 0.196969897426 },
    { 0.504180125232, -0.793073812763, -0.341813295281 },
    { -0.001464211017, -0.842011537996, -0.539457529345 },
    { -0.773718134191, -0.612411700577, -0.162210227240 },
    { -0.103405492806, 0.868038538655, -0.485609307435 },
    { -0.685894347607, 0.700921567313, 0.195596268869 },
    { -0.644147669739, -0.703654974610, 0.299905745655 },
    { 0.397525738241, 0.737035558073, -0.546581991628 },
    { 0.926020865763, 0.372839952764, 0.058955286407 },
    { -0.979453510872, -0.054067258226, -0.194287291476 },
    { -0.208729658086, -0.712304549822, 0.670115033512 },
    { -0.290757229887, 0.835348451886, 0.466533168382 },
    { -0.951126455002, 0.251866401393, 0.178666679728 },
    { -0.832841976653, -0.036611328286, 0.552298698681 },
    { 0.248346064348, 0.956021668950, -0.156034614174 },
    { 0.771853458738, -0.390572869448, -0.501692208317 },
    { 0.468875826106, 0.315522010698, 0.824985648638 },
    { -0.767174445642, 0.153700803440, -0.622751501785 },
    { -0.696365101141, 0.428548015582, 0.575692838460 },
    { -0.858793618615, 0.446644756071, -0.250962113675 },
    { -0.303270643589, 0.513348922311, 0.802807449330 },
    { 0.591707102487, 0.663991244556, 0.457163353759 },
    { 0.055872363249, 0.038491558781, -0.997695684529 },
    { -0.596445021452, -0.424136134176, 0.681441029049 },
    { 0.361458344252, -0.581639794003, -0.728726982760 },
    { 0.296001604560, -0.145358354157, 0.944062497388 },
    { 0.151502816145, 0.665921618993, 0.730476073569 },
    { -0.394394300827, -0.895563603590, -0.205958654590 },
    { 0.538616070533, -0.834174580664, 0.118513701898 },
    { -0.784739715088, -0.326493620800, -0.526863829789 },
    { -0.004071783525, 0.206131316601, 0.978515866450 },
    { 0.441276168804, 0.346509530510, -0.827772002493 },
    { 0.683136390793, -0.561301086724, 0.467189213935 },
    { 0.105814573212, -0.989996311480, -0.093330484579 },
    { 0.691035160515, -0.158723292935, 0.705178929926 },
    { 0.007176278836, 0.552839500508, -0.833256855777 },
    { 0.776013079283, 0.496231080195, -0.389305042133 },
    { 0.463068618324, -0.154744136474, -0.872709405788 },
    { 0.860015226983, -0.508486633728, -0.042604608652 },
    { -0.158436504249, -0.314907674464, 0.935805017450 },
    { 0.789460093065, 0.087525606077, -0.607529447631 },
    { -0.538142288017, 0.810191188683, -0.232364187489 },
    { -0.500108339361, 0.586942504707, -0.636702556198 },
    { 0.204578584228, 0.922451222518, 0.327461974817 },
    { 0.642917686640, 0.765923118398, -0.004315658615 },
    { 0.828474758045, 0.257698477096, 0.497213304513 },
    { -0.354663084098, 0.237632615600, -0.904292450915 },
    { 0.949248410000, -0.156790967682, 0.272661050694 },
    { -0.435247051900, -0.651731627274, -0.621132747344 },
    { 0.981059984179, -0.027259764220, -0.191776465440 },
    { -0.047984903259, -0.437790281871, -0.897795699566 },
    { -0.475963915573, 0.043307828941, 0.878397850080 },
    { 0.285627721059, -0.575670202220, 0.766172711103 },
    { 0.196900312977, -0.883385043848, 0.425277710509 },
    { -0.455839259689, -0.211239226976, -0.864632036367 },
    { -0.248699231118, -0.938140834951, 0.240915890382 },
    { -0.198799714840, 0.979543635151, 0.031191989603 },
    { 58, DUMMYVAL, DUMMYVAL },
    { 0.785533742625, 0.470273827084, 0.402217934405 },
    { -0.529502909928, 0.824602312898, -0.199142396143 },
    { -0.440955329689, 0.567065996063, 0.695697170706 },
    { -0.130857962364, -0.489998568398, -0.861845459844 },
    { -0.827616613651, 0.341702405894, 0.445297885259 },
    { -0.541874227095, -0.833935072643, -0.104520890859 },
    { -0.031825565795, 0.931884994739, -0.361355074604 },
    { 0.721374614968, 0.692419110200, 0.013207600460 },
    { -0.075190966550, -0.963301181487, -0.257676448856 },
    { -0.551147401810, 0.776788268159, 0.304690872736 },
    { 0.521973425778, 0.353094534897, 0.776445743248 },
    { 0.934633118994, -0.310286231495, 0.173733668081 },
    { -0.754736183251, -0.515911988597, -0.405226003255 },
    { 0.554777728419, -0.138198249090, 0.820440684022 },
    { -0.797597543386, 0.424413806604, -0.428615304846 },
    { -0.170137855516, -0.049946342427, -0.984153683628 },
    { 0.854339432817, 0.392487402888, -0.340672529137 },
    { -0.912293577178, -0.409500719470, 0.005439650120 },
    { -0.594905738130, 0.194132685609, -0.779999784050 },
    { 0.938512705053, -0.099082080286, -0.330721399095 },
    { -0.597367444615, -0.415034962327, 0.686220165953 },
    { 0.183778401993, -0.744136788385, -0.642250682469 },
    { 0.248831462440, -0.802248832894, 0.542659850570 },
    { 0.446172991144, -0.849064978336, -0.282875104133 },
    { 0.415062493679, 0.767739314026, 0.488159269133 },
    { 0.202999725493, -0.972189970916, 0.116780871291 },
    { -0.663420423737, -0.675405880616, 0.322025212985 },
    { 0.981196535766, 0.182913515545, 0.061611719923 },
    { -0.996615786265, 0.082025040417, -0.005372830959 },
    { -0.173663602929, 0.400602018939, -0.899643804758 },
    { 0.566569895095, 0.460673163196, -0.683212112512 },
    { -0.214508265094, -0.708863804325, 0.671936240371 },
    { -0.900649872108, -0.159267957132, 0.404306227633 },
    { 0.273842727879, 0.194838821048, -0.941832253748 },
    { -0.895681462300, -0.055521199286, -0.441216629924 },
    { -0.570081730411, -0.281803914552, -0.771746962673 },
    { 0.170137869818, 0.049946372760, 0.984153679616 },
    { 0.200582658392, -0.465631020017, 0.861947997474 },
    { -0.241184650005, -0.934272253612, 0.262612491577 },
    { 0.658041910081, -0.503337173112, 0.560029048123 },
    { -0.849749988962, 0.526891122062, 0.017626733984 },
    { -0.361454962105, -0.746646284497, -0.558452895253 },
    { -0.639670204917, 0.057354131737, 0.766506707416 },
    { 0.695127238858, -0.003354291406, -0.718878898373 },
    { 0.302554652264, -0.279956441052, -0.911090046871 },
    { 0.299287735416, 0.951329220463, 0.073481737344 },
    { 0.815412423888, -0.536971438301, -0.216250441430 },
    { 0.461327569556, 0.810289479677, -0.361397056840 },
    { -0.066332438917, 0.855823977997, 0.512996419317 },
    { -0.250256158808, 0.227594856422, 0.941048583395 },
    { 0.615098515145, -0.477988957177, -0.627040966352 },
    { -0.400864997679, 0.680407995707, -0.613475519490 },
    { -0.168662193533, 0.982270232610, 0.081842865300 },
    { 0.091768450383, 0.551454796513, 0.829141820750 },
    { 0.140822583662, 0.681876584957, -0.717783618382 },
    { 0.860302574789, 0.007415609517, 0.509729819165 },
    { 0.634477269498, -0.752325626860, 0.177326663701 },
    { -0.225734396882, -0.266129391249, 0.937133463909 },
    { 59, DUMMYVAL, DUMMYVAL },
    { 0.240825249519, -0.883416325948, 0.401968648333 },
    { -0.882496730659, -0.210114672048, -0.420774696205 },
    { 0.892480472910, -0.396114530193, -0.215805200224 },
    { -0.882311042315, 0.435528517823, 0.178443645930 },
    { -0.619943727785, -0.641743407868, -0.451481088018 },
    { -0.556547226575, -0.340232887893, 0.757955649486 },
    { 0.242907950449, -0.968143627429, -0.060775359131 },
    { 0.212764932177, 0.630307374779, 0.746621521880 },
    { -0.578751647149, -0.693500289943, 0.429073279022 },
    { 0.033377922685, 0.198084158385, 0.979616547673 },
    { 0.325065418106, -0.157074810446, 0.932555616505 },
    { 0.521804068547, 0.261381411339, 0.812034649417 },
    { -0.218682421645, -0.653242143797, -0.724881162696 },
    { 0.175676283831, 0.384347347816, -0.906319457766 },
    { 0.657689539309, -0.294260864791, -0.693437101211 },
    { 0.843316841739, 0.527394918494, 0.103302005723 },
    { 0.250624382796, -0.578228751347, 0.776427028035 },
    { 0.244315786300, -0.511005016124, -0.824126003752 },
    { 0.299831985371, -0.058909499148, -0.952171440161 },
    { -0.139442990306, -0.283235689301, 0.948858891912 },
    { -0.576419560779, -0.817103106363, -0.009110626878 },
    { -0.722270495258, 0.660156118421, -0.206201918008 },
    { -0.184056935634, -0.713352891074, 0.676203147909 },
    { -0.057972596284, 0.996289713980, 0.063608048996 },
    { -0.862868605959, -0.308691203608, 0.400209332307 },
    { -0.546739721679, -0.300193287023, -0.781639090095 },
    { -0.222946378984, -0.932798311522, -0.283164655491 },
    { -0.254149714190, 0.517661245365, 0.816966803380 },
    { 0.623724997866, -0.618162036267, 0.478375191618 },
    { 0.625432084835, 0.605182828090, 0.492532691143 },
    { 0.541931893143, 0.835549883974, -0.090367110090 },
    { 0.169506257763, -0.845715586952, -0.505996812803 },
    { 0.898015327686, 0.020981379582, -0.439463596845 },
    { 0.799038956211, 0.485669264682, -0.354488521395 },
    { 0.872268145317, 0.170471494674, 0.458353304960 },
    { -0.620439221392, 0.555681184596, 0.553419907163 },
    { -0.180570887956, -0.957047903865, 0.226833560414 },
    { 0.437809085276, 0.668897035424, -0.600749499251 },
    { 0.996255653126, 0.086442079376, 0.001562218949 },
    { -0.517790009280, 0.836472836181, 0.179462254029 },
    { -0.998395735558, -0.001748016941, 0.056594166279 },
    { 0.586564032563, -0.686971678961, -0.428966837889 },
    { -0.673401105008, 0.131149556563, -0.727551197915 },
    { -0.880551466457, -0.472557469446, -0.036311884989 },
    { 0.316629972603, 0.894805424339, 0.314751827672 },
    { 0.705838069010, -0.204582498448, 0.678187748095 },
    { -0.138553662556, -0.204630878057, -0.968983532542 },
    { -0.906444922750, 0.261638655228, -0.331515936436 },
    { -0.465551633517, 0.105239509058, 0.878741328414 },
    { 0.656259062013, -0.753521529237, 0.039106885607 },
    { -0.156808777058, 0.850158084146, 0.502635294620 },
    { -0.819400598859, 0.121231083170, 0.560255016098 },
    { 0.162755187301, 0.927317347189, -0.337036031618 },
    { -0.082958104104, 0.706405114781, -0.702929418060 },
    { -0.328485181800, 0.890474555201, -0.314884981981 },
    { 0.618444389795, 0.233325816467, -0.750390298512 },
    { -0.263308051993, 0.244316619475, -0.933262159955 },
    { 0.916204020772, -0.316803881050, 0.245368077125 },
    { -0.529127211962, 0.560432177469, -0.637134340637 },
    { 60, DUMMYVAL, DUMMYVAL },
    { -0.796820400190, 0.485768012456, 0.359314191085 },
    { -0.442713548676, -0.396099102384, -0.804431609839 },
    { -0.293873357738, 0.248022410265, 0.923105266813 },
    { 0.974492140285, 0.136632141121, 0.178035745107 },
    { 0.927217291362, 0.176876011354, -0.330125690012 },
    { -0.113158247032, 0.862908466079, 0.492528364968 },
    { 0.787961630142, 0.094456288496, 0.608436092772 },
    { 0.408386802165, -0.886887138261, -0.215989406696 },
    { 0.712558291408, -0.683664148210, 0.157683270508 },
    { 0.132290140328, 0.071279274824, 0.988644821841 },
    { 0.866669214578, -0.308859184205, 0.391778606914 },
    { -0.712597970650, 0.683607960275, -0.157747547918 },
    { 0.268930395119, 0.908893039133, -0.318731683390 },
    { -0.178471608268, -0.931734955886, 0.316255999188 },
    { 0.308134540054, -0.921661923255, 0.235780415742 },
    { -0.066555452988, -0.989221468019, -0.130427216822 },
    { -0.524805804466, 0.614263622021, -0.589286916757 },
    { 0.756594624676, -0.583423980932, -0.295264343233 },
    { -0.718639753960, -0.328062358540, 0.613132932517 },
    { 0.845120211033, 0.534049497590, -0.023726841939 },
    { 0.965494426003, -0.246464757087, -0.084116804925 },
    { 0.461889175080, 0.363513473221, 0.809021844409 },
    { 0.785885396921, -0.203847402041, -0.583806799881 },
    { -0.298185532393, 0.933136361697, -0.200852977948 },
    { 0.347867355066, 0.785313694402, 0.512123720076 },
    { 0.054548931088, 0.994019523566, 0.094602330237 },
    { -0.310867480933, -0.617657392148, 0.722399304556 },
    { -0.132302190410, -0.071186040980, -0.988649926912 },
    { 0.307858263892, 0.613387811501, -0.727309206634 },
    { -0.592137962885, -0.717422422045, 0.366984606296 },
    { -0.490374174662, 0.842720816549, 0.222159389132 },
    { 0.042048608994, 0.560390905669, 0.827160170297 },
    { 0.653887446985, 0.236196121105, -0.718778546598 },
    { -0.946535247352, -0.024071888584, 0.321701056417 },
    { -0.373938555079, -0.762511448700, -0.527964248436 },
    { 0.544184728800, -0.584129358992, 0.602209160429 },
    { -0.832113700315, 0.285732432563, -0.475335425494 },
    { 0.403885322783, -0.200950717199, -0.892465940693 },
    { -0.526529928733, 0.147792629652, -0.837211784896 },
    { -0.518414699604, -0.852006334605, -0.073016470930 },
    { 0.071363650317, -0.832613660243, -0.549237400576 },
    { 0.015223100058, -0.498309466488, -0.866865579449 },
    { -0.875204528192, -0.467724982776, 0.123492405913 },
    { 0.656209060147, 0.626462816719, -0.420635244184 },
    { -0.353563736523, -0.197090402716, 0.914411317391 },
    { -0.975389910518, -0.129530561803, -0.178427453100 },
    { -0.168461442937, 0.439530137451, -0.882289068569 },
    { -0.097763121791, 0.805473973138, -0.584511805368 },
    { 0.516103924101, -0.184415941362, 0.836437385642 },
    { 0.518465817551, 0.851969244228, 0.073086270400 },
    { 0.129954315313, -0.759803594804, 0.637032474254 },
    { 0.097039253405, -0.389680602784, 0.915823351478 },
    { -0.701815132967, 0.142909457438, 0.697877070918 },
    { 0.464255224557, -0.595632688988, -0.655506511242 },
    { -0.951445913394, 0.306982110215, -0.022641949866 },
    { -0.460347944433, 0.592800695150, 0.660807919055 },
    { -0.757487415960, -0.554764564260, -0.344164339964 },
    { 0.728611215839, 0.532968623364, 0.430197794815 },
    { 0.235742044916, 0.211792332744, -0.948456480841 },
    { -0.778357781765, -0.170421395863, -0.604248054525 },
    { 61, DUMMYVAL, DUMMYVAL },
    { -0.157278464070, -0.361923306111, 0.918844385755 },
    { -0.866848478547, -0.498553183307, 0.004294025510 },
    { -0.288260420915, -0.761037811807, -0.581143165437 },
    { -0.321663930210, 0.370936470921, -0.871170735587 },
    { 0.540635229228, 0.443409661782, 0.714913575725 },
    { 0.131452318057, 0.309689428317, -0.941707356914 },
    { 0.224598720955, -0.142826058419, -0.963927451410 },
    { 0.829440882704, 0.298053946783, -0.472431653158 },
    { 0.014263504325, 0.994228781798, 0.106328180122 },
    { -0.153153577983, 0.098378543215, 0.983293264385 },
    { 0.836809926474, -0.177932045177, -0.517773439116 },
    { 0.042588289090, 0.544548514452, 0.837647391831 },
    { 0.690614705985, -0.040508930386, 0.722087497771 },
    { 0.257207197706, 0.821085085413, 0.509572114582 },
    { -0.278783730469, 0.905497133257, -0.319929012891 },
    { -0.054245556162, 0.713371855033, -0.698683058392 },
    { 0.234624210715, -0.774787625460, -0.587073773201 },
    { -0.672242011807, 0.097322251227, -0.733906708634 },
    { 0.579136659177, 0.112278769661, -0.807461582913 },
    { 0.701172455621, -0.692977223343, 0.167749084668 },
    { -0.528413845933, -0.361896319379, -0.767990795157 },
    { -0.568525730878, -0.024924121564, 0.822287833726 },
    { -0.998724317128, -0.044984321253, 0.022937942759 },
    { -0.122070931406, -0.971776881983, 0.201862278172 },
    { 0.908804588412, -0.248528064969, 0.335123889039 },
    { -0.886331378339, 0.290032489561, -0.360967924849 },
    { 0.911176306992, -0.396604756932, -0.111635139428 },
    { -0.607842574769, -0.729942913293, 0.312587184050 },
    { 0.419942903537, 0.569977441494, -0.706239105372 },
    { -0.915699169785, 0.385618014385, 0.113109581546 },
    { -0.867188696070, -0.266772125459, 0.420495420292 },
    { 0.507992669004, -0.419104652893, -0.752525573095 },
    { 0.652601599544, -0.658157136094, -0.375420213201 },
    { -0.482794815716, -0.869772529782, -0.102004472227 },
    { 0.184604257789, -0.669033682073, 0.719941108882 },
    { 0.873724644209, 0.485749767694, -0.025542303887 },
    { -0.889671114978, -0.183241600629, -0.418219826134 },
    { 0.451800863953, 0.890708613613, 0.050141250156 },
    { 0.678657275935, 0.645869873571, 0.349680437304 },
    { 0.894415835460, 0.218685781060, 0.390124137219 },
    { -0.422318392567, 0.896119419222, 0.136444720646 },
    { -0.833288102004, 0.184557103099, 0.521123416049 },
    { 0.290214125354, 0.159403201404, 0.943592274676 },
    { 0.379906852580, -0.918735241701, -0.107686299128 },
    { -0.435841885204, 0.437528815337, 0.786517887179 },
    { 0.190798499895, 0.913320446602, -0.359780063728 },
    { -0.226263878599, -0.772644454066, 0.593148552087 },
    { -0.211800464205, 0.810857066766, 0.545574358486 },
    { -0.555463608647, -0.458028791655, 0.694024355109 },
    { 0.310031343627, -0.278340486070, 0.909069381171 },
    { 0.621396086084, 0.707575968405, -0.336456762654 },
    { -0.041768191799, -0.966805703634, -0.252075682237 },
    { -0.705329219419, 0.693575791640, -0.146503629599 },
    { 0.306871167077, -0.885729245002, 0.348301293945 },
    { -0.690960115226, -0.597398843907, -0.407048818282 },
    { -0.657741964313, 0.622228697464, 0.424507899141 },
    { -0.240664573260, -0.071172800361, -0.967995348990 },
    { -0.035554059782, -0.506602658773, -0.861446257730 },
    { 0.996055752056, 0.047727709663, -0.074799762870 },
    { 0.617011049149, -0.515249929818, 0.594823398204 },
    { -0.561696385843, 0.598189363920, -0.571547596464 },
    { 62, DUMMYVAL, DUMMYVAL },
    { -0.524446637730, 0.467011808540, 0.711937985261 },
    { 0.289557975534, -0.942783195959, 0.165275600805 },
    { 0.761141349998, -0.113310825819, -0.638611385802 },
    { -0.277472124586, 0.165092359207, 0.946442672859 },
    { -0.675068177284, 0.646178552039, -0.356000329920 },
    { 0.973787207475, -0.068077917531, -0.217034263893 },
    { 0.039542419759, 0.454463300621, -0.889887355472 },
    { -0.735945091091, -0.199299037873, -0.647043056064 },
    { -0.452863076153, -0.689428819595, 0.565334358560 },
    { 0.765911143440, 0.564853529097, 0.307116608182 },
    { 0.929072546806, 0.363193759922, -0.070103463002 },
    { -0.120962872815, -0.542026791155, 0.831609849070 },
    { -0.666873175702, -0.731109219939, 0.144081491002 },
    { 0.681936322801, -0.731390464544, 0.005553379107 },
    { 0.007641776920, 0.021459168095, -0.999740520010 },
    { -0.245631075425, -0.940722601683, 0.233893910712 },
    { -0.022217682992, -0.986480302371, -0.162366830346 },
    { -0.075897739913, 0.584110686859, 0.808117713315 },
    { 0.400812870229, -0.854904172512, -0.329375012533 },
    { 0.955123115635, 0.076777946735, 0.286085618083 },
    { 0.040692677967, -0.147319393956, 0.988251537881 },
    { -0.965704869310, 0.054510296385, 0.253855732611 },
    { 0.493527840383, -0.083400162690, 0.865722059111 },
    { 0.245262097993, 0.945298226039, -0.215076189141 },
    { -0.434203172127, -0.628122022362, -0.645701425071 },
    { 0.667635806421, 0.721644934706, -0.183005514118 },
    { 0.463425891452, 0.265554726743, -0.845409445320 },
    { -0.964439720239, -0.047896049090, -0.259926902238 },
    { 0.463359037189, 0.656890743444, -0.594804971257 },
    { 0.082584800891, -0.833059982300, 0.546983378680 },
    { 0.919643829362, -0.370169778598, 0.131261426660 },
    { -0.380647127645, 0.604706782277, -0.699598078673 },
    { -0.446927622090, -0.860756988767, -0.243624930789 },
    { 0.583265834532, -0.678429798484, 0.446692259611 },
    { -0.364673531850, -0.252129219562, -0.896350417979 },
    { -0.010680901904, -0.812549560018, -0.582794244009 },
    { 0.029155738246, -0.478005623110, -0.877872751145 },
    { 0.037081851618, 0.802058997581, -0.596092526946 },
    { -0.745548810485, 0.077915649174, 0.661880746659 },
    { -0.593265328291, 0.802495094640, 0.063544262734 },
    { 0.458898629090, -0.576932838526, -0.675692643181 },
    { -0.373516884890, 0.809082130380, 0.453730363764 },
    { -0.095266730249, 0.990404254818, 0.100118240824 },
    { 0.399837257336, -0.184146741181, -0.897897625210 },
    { -0.779751556211, -0.533435667669, -0.327771107703 },
    { 0.779965266483, -0.272223194145, 0.563514609970 },
    { -0.470344922738, -0.247538110846, 0.847054034483 },
    { -0.428379248774, 0.198278975337, -0.881576240128 },
    { -0.775461072019, 0.258260503992, -0.576161121441 },
    { -0.781798636322, -0.367738658065, 0.503546593285 },
    { -0.929072658180, -0.363193492400, 0.070103372960 },
    { 0.240772870342, 0.290237643287, 0.926169819918 },
    { 0.719821463167, 0.241284207696, 0.650875558214 },
    { 0.437821915123, 0.876042607758, 0.202141831471 },
    { -0.286981629219, 0.910819429296, -0.296731379716 },
    { 0.349182620289, -0.507166485900, 0.787942671308 },
    { 0.094985826395, 0.864323851941, 0.493884573307 },
    { -0.920503153335, 0.380832635584, -0.087409658358 },
    { -0.797797875442, 0.493474251560, 0.346412633990 },
    { 0.796110301002, 0.330471733753, -0.506948539626 },
    { 0.793890591660, -0.486914792355, -0.364213829308 },
    { 0.440894227045, 0.612933127347, 0.655686862732 },
    { 63, DUMMYVAL, DUMMYVAL },
    { -0.305898016741, -0.402190891363, 0.862941997042 },
    { 0.105300591310, -0.283924014813, 0.953047186283 },
    { 0.191361420533, -0.974287877270, -0.118928293256 },
    { 0.961932036030, 0.141638694924, 0.233720427349 },
    { 0.810795759854, -0.456529514743, -0.366320949403 },
    { 0.007104006246, 0.522256654792, 0.852758769888 },
    { 0.077505548513, 0.369262268585, -0.926087612999 },
    { 0.536699864440, -0.277799146233, 0.796731378736 },
    { 0.244792310865, 0.935310898857, -0.255480423949 },
    { -0.626545944987, -0.532344652149, 0.569253326867 },
    { 0.033206099902, 0.990785793403, 0.131304480198 },
    { 0.753250136816, -0.112750621503, -0.647998093159 },
    { -0.758419386024, 0.030261473859, -0.651063958535 },
    { -0.826009276358, 0.553911641102, 0.104357890077 },
    { 0.311297317031, 0.132481650958, 0.941032726619 },
    { 0.015241286812, -0.497309406689, -0.867439368022 },
    { -0.406197115373, 0.908241635908, 0.100503901744 },
    { 0.311059746832, 0.834683539340, 0.454472466774 },
    { 0.519909245707, 0.369342852507, -0.770246865316 },
    { 0.611065605545, 0.682221116368, -0.401463789277 },
    { -0.563996318977, 0.689868337718, 0.453861023657 },
    { 0.267658262435, -0.899062113029, 0.346477086496 },
    { -0.564508958173, -0.797402612285, 0.213257379858 },
    { -0.886005232840, -0.448539367906, 0.117503884270 },
    { 0.394186205091, -0.047315141443, -0.917811807021 },
    { 0.619772748141, -0.784163380052, 0.031137341682 },
    { -0.283398258769, -0.928436651394, -0.240189115646 },
    { -0.240138677073, 0.664203929288, -0.707931180336 },
    { -0.199512238516, 0.920137652389, -0.336959296263 },
    { -0.681274570393, -0.699933023769, -0.214379854400 },
    { -0.207293695224, -0.772068743014, 0.600782140198 },
    { -0.434462835643, 0.421976719730, 0.795724633558 },
    { 0.452657040766, -0.477161605975, -0.753271800367 },
    { 0.622647278029, -0.624103317747, 0.472022685833 },
    { -0.730991761309, -0.414625853265, -0.541974581233 },
    { 0.209077148654, 0.725540336893, -0.655650795357 },
    { -0.864707594541, -0.169849868725, 0.472685728615 },
    { -0.909601416050, 0.303734808767, -0.283496789863 },
    { -0.430070930817, -0.265085927556, -0.862999678724 },
    { 0.843196776964, 0.279369004813, -0.459317052228 },
    { 0.983019623762, -0.045394803945, -0.177796881506 },
    { 0.210795714680, -0.653523740029, 0.726960719634 },
    { -0.142865429360, 0.823026860015, 0.549741991108 },
    { -0.954934376908, -0.177266190351, -0.238069388117 },
    { -0.584494323373, -0.040517677874, 0.810385527835 },
    { 0.856730547708, -0.225554140890, 0.463829815936 },
    { 0.554219890034, 0.829863207740, 0.064555169658 },
    { 0.071418452176, -0.827295816717, -0.557208252210 },
    { -0.035097773746, -0.073503041626, -0.996677204089 },
    { -0.167368165303, 0.088259684370, 0.981935906950 },
    { 0.721224182261, 0.159112241354, 0.674180223363 },
    { -0.802427048672, 0.292066730934, 0.520392021693 },
    { -0.620202896821, 0.739272394417, -0.262344608537 },
    { 0.495306770814, -0.766556444180, -0.408732700763 },
    { 0.873680790595, 0.483299368129, -0.055709935480 },
    { 0.436613504450, 0.521773437256, 0.732885480757 },
    { 0.742630145678, 0.546374192554, 0.387266973082 },
    { -0.365813372274, -0.683527642911, -0.631641146571 },
    { -0.380731045363, 0.221029724184, -0.897880689248 },
    { -0.987371841978, 0.095541460058, 0.126367223122 },
    { 0.902129541111, -0.424516805322, 0.077121806609 },
    { -0.632555176384, 0.475833691872, -0.611110666336 },
    { -0.154591914713, -0.968141961892, 0.196983454962 },
    { 64, DUMMYVAL, DUMMYVAL },
    { -0.423806441292, 0.082350629831, 0.902001371443 },
    { 0.576553675474, 0.698195351349, 0.424392637367 },
    { 0.874259277468, 0.329956749191, 0.356088836421 },
    { 0.164222204074, 0.691011907275, 0.703941483146 },
    { 0.614744538933, 0.301699706949, -0.728743053949 },
    { -0.027463383232, -0.980691694696, 0.193622216017 },
    { -0.305495241852, -0.420772491913, 0.854179821381 },
    { -0.548022972297, 0.025689305821, -0.836068706149 },
    { -0.952503621263, -0.035636038987, 0.302434991702 },
    { -0.704385576621, -0.232813506894, 0.670551139329 },
    { 0.184877066837, -0.942623741895, -0.277994516805 },
    { -0.589044986427, 0.481207826526, -0.649203382350 },
    { 0.928190612130, -0.348169889647, -0.131300858704 },
    { 0.378837326891, -0.693564880846, -0.612739778218 },
    { -0.212441145516, 0.860116655246, 0.463754352066 },
    { -0.206941838141, 0.353230185889, -0.912361502587 },
    { 0.103546086102, 0.916153905473, -0.387221163600 },
    { -0.783029317522, 0.573186334856, -0.241500545415 },
    { 0.132156800515, 0.300882672279, 0.944459738475 },
    { -0.570060089327, 0.615368906953, 0.544382772425 },
    { -0.731788825003, -0.667457591198, -0.137787806252 },
    { -0.555888239321, 0.822630323549, 0.119447127057 },
    { -0.843953813849, -0.471370827406, 0.256030277820 },
    { 0.237756764518, 0.170533554135, -0.956237432775 },
    { -0.850397103561, 0.130767855048, -0.509631763474 },
    { 0.874452461821, -0.016452506716, -0.484832143157 },
    { 0.158994870791, -0.419825204332, -0.893570046985 },
    { 0.414371651839, -0.088882513524, 0.905757160028 },
    { -0.540095360707, -0.644849437266, 0.540801446559 },
    { -0.262914336079, -0.939216913539, -0.220788679979 },
    { 0.649926364196, -0.728995696442, -0.214851101212 },
    { 0.341828563416, -0.778885268661, 0.525824087976 },
    { 0.932276792647, -0.200223055518, 0.301281778292 },
    { -0.114393871249, -0.793423048024, 0.597824312892 },
    { -0.034563017246, -0.102491957092, 0.994133188547 },
    { -0.979733645341, 0.176173131176, -0.095315329505 },
    { 0.530314516411, 0.712392354616, -0.459634253257 },
    { 0.776941548713, 0.629156373683, 0.022892953874 },
    { 0.748840783587, -0.616756040766, 0.242589090883 },
    { 0.539579283325, 0.385902753665, 0.748286884637 },
    { 0.623233457409, -0.437638175482, 0.648114870163 },
    { -0.510613935554, -0.694169668012, -0.507347889352 },
    { -0.120540750194, 0.992708379826, -0.000012878736 },
    { -0.115397575683, -0.088617053988, -0.989358588819 },
    { -0.423708314967, 0.848340416524, -0.317474095826 },
    { -0.470457283908, -0.864679500933, 0.176066194044 },
    { -0.950341937338, -0.265419019854, -0.162489833641 },
    { 0.425304693280, 0.902980613680, -0.061171310211 },
    { -0.757621573762, -0.317869414262, -0.570060160375 },
    { 0.720020685343, -0.424259785756, -0.549157397171 },
    { 0.205915582057, 0.928320419803, 0.309548011208 },
    { 0.521679615382, -0.157562976554, -0.838465435969 },
    { 0.406661886705, -0.906493202999, 0.113561361469 },
    { -0.190263122487, 0.722931086926, -0.664206735721 },
    { -0.256868106960, 0.495037593055, 0.830034069837 },
    { 0.763334885339, 0.007388940533, 0.645960723560 },
    { 0.992556139632, 0.118584054954, -0.027751244832 },
    { 0.228047298712, 0.592357044298, -0.772727352706 },
    { -0.748750884418, 0.222148774528, 0.624517441757 },
    { 0.844793740617, 0.410698700389, -0.343001622901 },
    { -0.356516064332, -0.422891613542, -0.833102022005 },
    { -0.074581141228, -0.759898081423, -0.645749610316 },
    { 0.175720557912, -0.500149758645, 0.847922463704 },
    { -0.857356215654, 0.464648046997, 0.221455439990 },
    { 65, DUMMYVAL, DUMMYVAL },
    { -0.279080461045, -0.928071902500, -0.246569746834 },
    { -0.702592346265, -0.699110967278, -0.132694575629 },
    { -0.476789330474, 0.842357053875, -0.251210127451 },
    { -0.184505052403, 0.980755304050, 0.063850757361 },
    { -0.384990924103, 0.007619976935, 0.922888901391 },
    { -0.195208521438, 0.422223151365, -0.885223838139 },
    { -0.595165279043, 0.517730153027, -0.614600503798 },
    { 0.024295007465, -0.165318439410, 0.985940954725 },
    { 0.171265134695, -0.925719056650, -0.337212813802 },
    { 0.941369674022, -0.026320456449, -0.336348584661 },
    { 0.346323107537, -0.646772791323, -0.679518404158 },
    { 0.524523674479, 0.714936815473, 0.462320521708 },
    { 0.183802191060, 0.678842390306, -0.710907704055 },
    { 0.743875140339, -0.634159182128, 0.210931048708 },
    { 0.615356962913, -0.725505958556, -0.308183244666 },
    { -0.542167865503, 0.100648997459, -0.834220465420 },
    { -0.787538863268, -0.261455244482, -0.558053486662 },
    { 0.004644531108, -0.990142394568, 0.139987380899 },
    { 0.014784312351, -0.426784477144, -0.904232511126 },
    { 0.069702069726, 0.950263537679, -0.303547081082 },
    { -0.851213111503, 0.166797342549, -0.497609169253 },
    { 0.569495711781, 0.463759653209, -0.678676372301 },
    { 0.826630268403, 0.386253424245, 0.409256266438 },
    { -0.818257303631, 0.541923712772, -0.191764633312 },
    { 0.944118279343, -0.214250029577, 0.250474748103 },
    { 0.458775282838, -0.103361011887, 0.882520108031 },
    { -0.672766224840, -0.287842731013, 0.681565968133 },
    { -0.887321666110, 0.387282522875, 0.250344778908 },
    { 0.898501468499, -0.412078384168, -0.151282901898 },
    { 0.708478207687, -0.376486415020, -0.596922615201 },
    { -0.611273235468, 0.546916428270, 0.572037981334 },
    { 0.654421347795, -0.441686907646, 0.613714408471 },
    { 0.115865258274, 0.254169239628, 0.960194375922 },
    { -0.942662012775, -0.088085877952, 0.321914907665 },
    { 0.847344423352, 0.418466881531, -0.326944792399 },
    { 0.701410982601, 0.061175463387, -0.710126887370 },
    { 0.381486512083, 0.923843491707, 0.031324813308 },
    { 0.521853856076, 0.358581894847, 0.774007479025 },
    { -0.129170093657, -0.751585653547, -0.646864817630 },
    { 0.232249474405, -0.534756651137, 0.812462618034 },
    { 0.981644110196, 0.181828800356, 0.057559780045 },
    { 0.129109997383, 0.917947772269, 0.375103313719 },
    { 0.256284024963, 0.251860623547, -0.933212047102 },
    { -0.816364833353, -0.512586157753, 0.266090003091 },
    { 0.136343562255, 0.650454835306, 0.747207427867 },
    { -0.734501581877, 0.148655870153, 0.662124503767 },
    { 0.372121886567, -0.798632959378, 0.472980652598 },
    { -0.266417512126, 0.809405506871, 0.523339693391 },
    { -0.423596407574, -0.338883335927, -0.840073906345 },
    { 0.757067605308, 0.651942331571, 0.042659551085 },
    { -0.989990572766, 0.110052302113, -0.088358115841 },
    { -0.430202780615, -0.885134226761, 0.177378037441 },
    { -0.224480553751, 0.773505738206, -0.592703428327 },
    { 0.797202103455, -0.002704995941, 0.603706459502 },
    { 0.423526450195, -0.904851547661, 0.043232194959 },
    { 0.511346522210, 0.778254385579, -0.364478868455 },
    { -0.936762912381, -0.318182740177, -0.145722303852 },
    { -0.068295464132, -0.822990245903, 0.563935089108 },
    { -0.252241546640, -0.470915167922, 0.845347920545 },
    { -0.551047542449, -0.643527368717, -0.531243006235 },
    { -0.106755258258, -0.007580199851, -0.994256433424 },
    { -0.605878188930, 0.776042581837, 0.175127186223 },
    { -0.499410764235, -0.676685378435, 0.541004424361 },
    { -0.282471560611, 0.437970370727, 0.853458711251 },
    { 0.384007069037, -0.190623065587, -0.903438662996 },
    { 66, DUMMYVAL, DUMMYVAL },
    { -0.026729856455, 0.693836546641, 0.719636270153 },
    { 0.585825674833, 0.139451409165, -0.798349286458 },
    { -0.875194645932, 0.483753955614, 0.004054893345 },
    { -0.882784526907, -0.381410068742, 0.274258707275 },
    { -0.364758246224, -0.132861874766, 0.921574274839 },
    { 0.334509407153, -0.223562211576, -0.915490794100 },
    { 0.152054079259, 0.668714400505, -0.727805336294 },
    { 0.434859945175, -0.600942582506, -0.670645092888 },
    { -0.480366020405, 0.062840565105, -0.874814008700 },
    { -0.008910827753, -0.531809568996, -0.846817087376 },
    { 0.730910012526, -0.243661670668, -0.637494740242 },
    { -0.784361547104, -0.103882665407, -0.611543420578 },
    { -0.316969545309, 0.942770392359, -0.103509877005 },
    { -0.592153876489, 0.778443469629, 0.208277581971 },
    { 0.935942903143, -0.283886461852, 0.208373124065 },
    { 0.432431011498, -0.875020211471, -0.217584580823 },
    { -0.693676026704, -0.529370569526, -0.488446895881 },
    { 0.560147040408, 0.068045378383, 0.825593798186 },
    { -0.331812920186, -0.774751937193, -0.538200354713 },
    { 0.565919799971, 0.535067547179, -0.627245964481 },
    { 0.738799963819, -0.586943176156, -0.331168116558 },
    { 0.871649605125, 0.129092089046, 0.472823644112 },
    { -0.826071194157, -0.042873091476, 0.561932629603 },
    { -0.320199538293, 0.739957485465, -0.591553188971 },
    { -0.171336327457, 0.312708328979, 0.934268357529 },
    { -0.006790265155, -0.991648382774, -0.128791992146 },
    { -0.153282539563, -0.944297369529, 0.291216313015 },
    { 0.444379657033, 0.836091579062, -0.321679330758 },
    { 0.380526862875, -0.384311607486, 0.841132507386 },
    { -0.988460415068, 0.060644871203, 0.138809968810 },
    { 0.948857262747, -0.221567644413, -0.224894806258 },
    { 0.153456431419, -0.765712364156, 0.624608436570 },
    { 0.144695124860, 0.988000950213, 0.054013361497 },
    { -0.423278297299, -0.388024603459, -0.818701649043 },
    { -0.451830325974, 0.637491173535, 0.624062785459 },
    { -0.171461714445, 0.920272586191, 0.351709038248 },
    { 0.199917062195, 0.269101075008, -0.942134692957 },
    { -0.953592537066, -0.228378334252, -0.196225914945 },
    { 0.828516202250, 0.509882335541, 0.231475498730 },
    { 0.736890954288, -0.668589353252, 0.099899940975 },
    { 0.557891953726, 0.821804722715, 0.115730573710 },
    { 0.565641870401, -0.659539955345, 0.495031637123 },
    { -0.805942153655, 0.405256147392, 0.431537599708 },
    { 0.876404802681, 0.180685964522, -0.446393552891 },
    { -0.429877632259, -0.895371294900, -0.116256034479 },
    { 0.310470735710, 0.820715982275, 0.479617763126 },
    { 0.608934002818, 0.509742942874, 0.607751192843 },
    { -0.584470035322, -0.747582202106, 0.315460978419 },
    { -0.650194023642, 0.700647069590, -0.293839097968 },
    { -0.650943307456, 0.405728518122, -0.641605159004 },
    { -0.772980970559, -0.629486895725, -0.079035860623 },
    { 0.314956827952, -0.924402669332, 0.215132288276 },
    { -0.293541021773, -0.700833625249, 0.650127601519 },
    { 0.749078763664, -0.280244490422, 0.600286624385 },
    { -0.216902544888, 0.416783326843, -0.882748517125 },
    { 0.801709964682, 0.555483312526, -0.220679455398 },
    { 0.276339578403, 0.411128057151, 0.868683002039 },
    { 0.987767670499, 0.155310976521, 0.013911494826 },
    { -0.057796039437, -0.434192548935, 0.898964097323 },
    { 0.022303949746, 0.923674127157, -0.382529267699 },
    { -0.916363949054, 0.219673595461, -0.334694822683 },
    { -0.614174447946, -0.409096748087, 0.674855242400 },
    { -0.572723501913, 0.229269213765, 0.787034572288 },
    { -0.082565423258, -0.082303760969, -0.993181273390 },
    { 0.095707684961, -0.842392067314, -0.530297693720 },
    { 0.124785564705, -0.022657472314, 0.991924998067 },
    { 67, DUMMYVAL, DUMMYVAL },
    { -0.097564247635, -0.168914827991, -0.980789986933 },
    { 0.921400238383, 0.272107306575, 0.277451282960 },
    { 0.425359963460, 0.156673565222, 0.891359801341 },
    { -0.273077211253, -0.713858868804, 0.644852194013 },
    { 0.834826638917, 0.546136429515, -0.069278303325 },
    { -0.450785866399, 0.446802008558, 0.772761326545 },
    { -0.312947170618, -0.344631465228, 0.885038542425 },
    { 0.000012897318, 0.591510641501, -0.806297191379 },
    { 0.229274337995, 0.905443497900, 0.357218910540 },
    { -0.794656450525, -0.544535039968, -0.268333218008 },
    { 0.475671294138, -0.307041028040, 0.824295230505 },
    { 0.174430350943, 0.184406723301, -0.967247751650 },
    { -0.115400719067, -0.993303342402, 0.005580681936 },
    { -0.506140474977, -0.845449683712, -0.170401443368 },
    { 0.092832082538, -0.131591048811, 0.986947820467 },
    { -0.794404181773, 0.319650859458, 0.516473933543 },
    { -0.291602159835, 0.092008608842, 0.952104299055 },
    { -0.905340912290, -0.166130404129, 0.390843346314 },
    { -0.257332978633, 0.864540381901, -0.431682367221 },
    { -0.925397124585, 0.230090723583, -0.301161784978 },
    { -0.662518133282, -0.038653475869, 0.748047880737 },
    { 0.319028091657, 0.639393257554, 0.699569395363 },
    { 0.372674073511, -0.920495217576, 0.117484421741 },
    { -0.480650653180, 0.875513057370, -0.049516017326 },
    { -0.970891783137, 0.195631548786, 0.138193496793 },
    { 0.798141344289, 0.332499127773, -0.502408921663 },
    { -0.428925176305, 0.575130793744, -0.696597274771 },
    { 0.110037713554, -0.569762761736, 0.814409047675 },
    { -0.806996628173, 0.585950610503, 0.073609266867 },
    { 0.602784345427, -0.741013981846, -0.295887329261 },
    { -0.291782174265, 0.225126225094, -0.929613546349 },
    { 0.438588611599, 0.897569716173, -0.044817790930 },
    { -0.124552808920, 0.729055813003, 0.673026165403 },
    { -0.206076395340, 0.934284086665, 0.290939451929 },
    { -0.649743952934, -0.481705270939, 0.588041518581 },
    { -0.978472645692, -0.193363473660, -0.072123842705 },
    { 0.897325326683, -0.399060255783, -0.188568741702 },
    { 0.307388084043, -0.307473058111, -0.900540329094 },
    { -0.802009397510, -0.571456764248, 0.173833520647 },
    { 0.985039018607, 0.104638879180, -0.136926391849 },
    { -0.462260198908, -0.843166989227, 0.274563174485 },
    { 0.670188435999, 0.407465394796, 0.620338143513 },
    { -0.703187034033, 0.612854020537, -0.360469062028 },
    { 0.585318108394, 0.706051244251, -0.398615544701 },
    { 0.185343620875, 0.850091267629, -0.492942774470 },
    { 0.256925508779, -0.702896620534, -0.663268892517 },
    { -0.835921110446, -0.177973697904, -0.519192892830 },
    { -0.693677579693, 0.216221475501, -0.687066000442 },
    { 0.030802220770, -0.909306858180, 0.414984651358 },
    { 0.734544759461, -0.665737845479, 0.131290203160 },
    { 0.206076389003, -0.934284080867, -0.290939475036 },
    { -0.134246679477, -0.562414835645, -0.815884416873 },
    { -0.515128407703, -0.194070292524, -0.834852948211 },
    { 0.574220995286, 0.040861248363, -0.817680015015 },
    { 0.632538956428, -0.451346779975, -0.629428751176 },
    { 0.643268640307, 0.703508878469, 0.302126983753 },
    { 0.785060647895, -0.019630408689, 0.619107766210 },
    { 0.746368728443, -0.442886365196, 0.496774988023 },
    { -0.532881955960, -0.581946057514, -0.614309048571 },
    { 0.854841753287, -0.106092479511, -0.507927123343 },
    { -0.563310570045, 0.710557765216, 0.421650167753 },
    { -0.186937290424, -0.858820020302, -0.476951383454 },
    { 0.960594851669, -0.191329334692, 0.201619980737 },
    { 0.037751182932, 0.375678664099, 0.925980771684 },
    { 0.421656516994, -0.730137315887, 0.537685113821 },
    { 0.435310552026, 0.487067080491, -0.757146209392 },
    { 0.009193791383, 0.995959048710, -0.089336708537 },
    { 68, DUMMYVAL, DUMMYVAL },
    { -0.024507028168, 0.488179521983, -0.872399082924 },
    { 0.160206217487, 0.540030663377, 0.826257133398 },
    { 0.412177058084, 0.899172287350, 0.146966902569 },
    { 0.134869306340, 0.952628880582, -0.272595829183 },
    { -0.656251815505, 0.132223270270, 0.742866449266 },
    { -0.991507584588, -0.122721971319, 0.043035188614 },
    { 0.108829666997, 0.860345917888, 0.497956830614 },
    { -0.879331815488, -0.122438081906, 0.460200471936 },
    { 0.771354609907, 0.622865813706, 0.130576582479 },
    { 0.823093557194, -0.065626927564, 0.564101145616 },
    { 0.561040189556, 0.789641046259, -0.248396706431 },
    { -0.365489080795, 0.917687331094, -0.155780917218 },
    { -0.807716095518, -0.521364868484, 0.275269654977 },
    { -0.616212001493, -0.360676110834, 0.700139637708 },
    { 0.938078853203, -0.282122888197, 0.201034179008 },
    { -0.469605950033, 0.511060675094, -0.719921688843 },
    { 0.620176931755, 0.523944501269, -0.583834508152 },
    { 0.516538263206, 0.257779359165, 0.816540277410 },
    { 0.970337713997, -0.035212131764, -0.239175305106 },
    { -0.535089655736, -0.761460932007, -0.365863785243 },
    { 0.101598195521, -0.293939004491, 0.950409210975 },
    { 0.347667662682, -0.867940005575, 0.354693308433 },
    { -0.028905152690, -0.819834012769, 0.571871212472 },
    { -0.843766777605, -0.510678372817, -0.165121847577 },
    { -0.544105926449, -0.836912312602, 0.059384525077 },
    { -0.226557694504, -0.531715050056, 0.816058035071 },
    { 0.095993449454, -0.457147253555, -0.884195479648 },
    { 0.510181891505, -0.184672160064, 0.840006327880 },
    { -0.164925150495, -0.954067186024, -0.250110973943 },
    { 0.258909134204, -0.963650727916, -0.065903981767 },
    { -0.914280574528, -0.121268135431, -0.386503648585 },
    { -0.415115756031, 0.859630211581, 0.297850312125 },
    { -0.652692100612, -0.017745110208, -0.757415429512 },
    { -0.657364669026, -0.435206352567, -0.615196816151 },
    { 0.863591433547, -0.473337606842, -0.173670221550 },
    { -0.203657471337, 0.809418469603, -0.550786143104 },
    { -0.660765402942, 0.672279133254, -0.333811098178 },
    { -0.315821867111, -0.298936936829, -0.900496116623 },
    { 0.974573181501, 0.169993451774, 0.145977190865 },
    { 0.072575110055, -0.013402088718, -0.997272900173 },
    { 0.474320488589, -0.143502792353, -0.868577585879 },
    { 0.149722584192, -0.837711588591, -0.525188006454 },
    { 0.323053740920, -0.602644240443, 0.729695964042 },
    { 0.244251661210, 0.732631502036, -0.635289074533 },
    { -0.127098204582, -0.974321810376, 0.185857623512 },
    { 0.114832560483, 0.130516467124, 0.984773544965 },
    { 0.689543952098, -0.505778744373, 0.518379204700 },
    { -0.237198723301, -0.690557635239, -0.683276604369 },
    { -0.902420130464, 0.287062709168, 0.321298784839 },
    { 0.455421248668, -0.569045825947, -0.684673888968 },
    { -0.468234274336, -0.742691917829, 0.478712209505 },
    { 0.880128132889, 0.409177669573, -0.240724125130 },
    { 0.376912333149, 0.300555020140, -0.876129997768 },
    { 0.561668035243, -0.768046868807, -0.307624812883 },
    { -0.801759041763, 0.300735939993, -0.516469102027 },
    { -0.310173672978, 0.163595826085, -0.936498103724 },
    { 0.770420128228, -0.310885738631, -0.556599392326 },
    { -0.032927264863, 0.992435620913, 0.118268058119 },
    { -0.318704705356, -0.097591062354, 0.942816681722 },
    { -0.246845589345, 0.699388747052, 0.670762726691 },
    { 0.794244436183, 0.359954760814, 0.489498054910 },
    { 0.678586818820, -0.722026555501, 0.134898415392 },
    { 0.768693602459, 0.124438023812, -0.627395667636 },
    { -0.635397391694, 0.534204139847, 0.557580569603 },
    { -0.945850049020, 0.303815875469, -0.114296100468 },
    { -0.283400882534, 0.340032611207, 0.896694910822 },
    { -0.744795651861, 0.660010960327, 0.098310575309 },
    { 0.504883002620, 0.671444602051, 0.542453039481 },
    { 69, DUMMYVAL, DUMMYVAL },
    { -0.594820281417, -0.318521104627, 0.738060389618 },
    { 0.157185792005, 0.223470348375, 0.961953029097 },
    { 0.820774674620, 0.070372228791, 0.566900946302 },
    { 0.145136522566, 0.926913492609, 0.346073354993 },
    { -0.930957937130, -0.350746446455, -0.101460581478 },
    { -0.431551261799, -0.208335000478, -0.877701564323 },
    { -0.275634965222, -0.038463393118, 0.960492547257 },
    { 0.479669690190, -0.877393457075, -0.009884826452 },
    { 0.845623359852, 0.531572252598, -0.048498180804 },
    { -0.257386595833, 0.962845565369, 0.081734677671 },
    { -0.615378251766, 0.151707711336, 0.773494911150 },
    { 0.475436054183, -0.756717197367, 0.448708860611 },
    { -0.232211384468, 0.898116130285, -0.373450518067 },
    { -0.706759442545, -0.612947937757, -0.353250500314 },
    { 0.763924535521, 0.451241175422, -0.461303268613 },
    { -0.844185532585, 0.365644351496, 0.391988513599 },
    { -0.776927095994, 0.446250627637, -0.444122353460 },
    { -0.287595768194, 0.264374609173, -0.920540460893 },
    { 0.217766081683, 0.254942325361, -0.942115886931 },
    { -0.599889499887, 0.774250852104, -0.201663595976 },
    { 0.534611300313, 0.792428105710, -0.293680872476 },
    { -0.866954853091, -0.065819761698, 0.494021296780 },
    { -0.054017760027, -0.796660477958, 0.602008442185 },
    { 0.141014279411, -0.953338817002, 0.266945824091 },
    { 0.642829426550, 0.138926224546, -0.753305935524 },
    { 0.780034454621, -0.608619342967, 0.145357301055 },
    { -0.038339434153, 0.601785401479, -0.797737060914 },
    { 0.514562488938, -0.102197574451, 0.851340766529 },
    { 0.943142588964, -0.292352832188, -0.158151441326 },
    { -0.056257681436, -0.811368185143, -0.581821915553 },
    { 0.338957299966, -0.842164771999, -0.419364335158 },
    { -0.537380360206, 0.563595740295, 0.627361291431 },
    { 0.931785599560, -0.228842539813, 0.281791923988 },
    { 0.550455787090, 0.823575546429, 0.136827430666 },
    { -0.620278212071, 0.749220750991, 0.232213707422 },
    { 0.156974621043, 0.983930337079, -0.085088542853 },
    { -0.940004426795, 0.054004758509, -0.336860748181 },
    { 0.527877649107, 0.343569008548, 0.776727445078 },
    { -0.995013541610, 0.027274795124, 0.095938196587 },
    { 0.471490914397, 0.696340452421, 0.541115784249 },
    { 0.387406341731, -0.179268785698, -0.904311356150 },
    { 0.712737565617, -0.619415705054, -0.329134238405 },
    { -0.832273706094, -0.447617088588, 0.327046510680 },
    { -0.297443033462, -0.934140403720, 0.197254525887 },
    { 0.283742521754, -0.557888697213, 0.779904085686 },
    { -0.495693523073, -0.695911393790, 0.519610684240 },
    { 0.118529024415, -0.212877271657, 0.969862947835 },
    { -0.421300768374, -0.594265204199, -0.685094540663 },
    { 0.107921402909, 0.642477127118, 0.758667326253 },
    { -0.666622226064, -0.742069414278, 0.070340543857 },
    { 0.688851250780, -0.406602371223, 0.600132040483 },
    { 0.426105072712, 0.556335601186, -0.713389911522 },
    { 0.160439266661, 0.846486629000, -0.507660938657 },
    { -0.660905823367, 0.154069960742, -0.734483451030 },
    { 0.930100729945, 0.081660894623, -0.358111896543 },
    { 0.416393701873, -0.558934350327, -0.717083451953 },
    { -0.231448839904, 0.407452797612, 0.883410240050 },
    { 0.019177761231, -0.988722252290, -0.148527846885 },
    { -0.770757646045, -0.257478534972, -0.582784226873 },
    { 0.753080221218, -0.266934038985, -0.601345490747 },
    { -0.891482521047, 0.452155775618, -0.028531898685 },
    { -0.381138931036, -0.883591029007, -0.272029426178 },
    { 0.802863830003, 0.459017759202, 0.380410787452 },
    { -0.209173640413, -0.487473204722, 0.847712370344 },
    { -0.002446326456, -0.494399083910, -0.869231592451 },
    { -0.443985288362, 0.614687536035, -0.651948078272 },
    { -0.038119243929, -0.087923609142, -0.995397590010 },
    { -0.227991396017, 0.823435125016, 0.519590721850 },
    { 0.985725387531, 0.145869280342, 0.084069099140 },
    { 70, DUMMYVAL, DUMMYVAL },
    { 0.941185652514, -0.108014794218, -0.320159915873 },
    { 0.780122378286, 0.183596396098, -0.598081464550 },
    { -0.368961337144, -0.401319302459, 0.838337849060 },
    { -0.982816867454, 0.170760453881, 0.070084751817 },
    { 0.016505140471, 0.935885846990, 0.351916555083 },
    { -0.772525178757, -0.620065022059, 0.136836459345 },
    { 0.081974750340, -0.432818037680, 0.897746448929 },
    { -0.358942700828, 0.285800236584, -0.888525949138 },
    { 0.230896897547, 0.968998462562, -0.087912469284 },
    { -0.194746289754, -0.177448747768, -0.964668764158 },
    { 0.618311176663, 0.772258437493, -0.145973266510 },
    { -0.023547179357, 0.380965546982, 0.924289339091 },
    { -0.919998950519, -0.191619832982, 0.341882685509 },
    { -0.937116306388, 0.053020568863, -0.344966444136 },
    { 0.496434239528, -0.403189866566, 0.768759375437 },
    { -0.800265429582, -0.317385573347, -0.508764818013 },
    { 0.467483704067, 0.115087528777, -0.876478092796 },
    { -0.096044578338, 0.615721274622, -0.782088710410 },
    { -0.149433612759, -0.727217563449, 0.669943438500 },
    { -0.205643124472, -0.035082763319, 0.977998008728 },
    { 0.047568971964, 0.183493909107, -0.981869226642 },
    { 0.091392832472, -0.839328853709, -0.535886578955 },
    { 0.020079848896, -0.991025925936, -0.132152993878 },
    { -0.045013619998, -0.564715988081, -0.824056810433 },
    { 0.710333038092, -0.703700219082, 0.015263572965 },
    { -0.411726606372, -0.911000246035, -0.023659106697 },
    { -0.802028206836, 0.575958664719, 0.158184613582 },
    { -0.846195520045, 0.215226369845, 0.487473847072 },
    { 0.275329772234, -0.760445398523, 0.588146505886 },
    { 0.660312290725, -0.619508871214, 0.424495509052 },
    { -0.220855167692, 0.703311342933, 0.675704188092 },
    { 0.441686947135, -0.850085849013, -0.286821704265 },
    { -0.460733677171, -0.525520113098, -0.715229396383 },
    { -0.690600960130, -0.663305221997, -0.288264629012 },
    { 0.902068886058, 0.370740794901, -0.220959244662 },
    { -0.683596310287, -0.470265262207, 0.558163656755 },
    { 0.619066177657, 0.559109462852, 0.551501293044 },
    { 0.254129526609, -0.258569923088, -0.931965545812 },
    { -0.615674811138, 0.561033910905, 0.553340291090 },
    { 0.935518543326, -0.349851488209, 0.049081476039 },
    { -0.054072929220, -0.953828417783, 0.295444525680 },
    { -0.505912028393, 0.638049452353, -0.580470426361 },
    { 0.628594612750, 0.576123474040, -0.522446701092 },
    { 0.992288619279, 0.082666815645, 0.092355257781 },
    { -0.952074979521, -0.295372983472, -0.079423132680 },
    { 0.259231963948, 0.829217835739, -0.495173272461 },
    { -0.462072422301, -0.795726152787, 0.391546889045 },
    { -0.564667878337, 0.808533124964, -0.165603058578 },
    { 0.636870135878, -0.002465737073, 0.770967152457 },
    { 0.229398984078, -0.036476008582, 0.972648758238 },
    { 0.313959847118, 0.507177239989, -0.802620995013 },
    { 0.214573658017, 0.711925887222, 0.668670080375 },
    { -0.186051075637, 0.981995197911, -0.032717404155 },
    { 0.822531314861, 0.544697123992, 0.163545954361 },
    { -0.320219905774, -0.834373350887, -0.448642756852 },
    { 0.765443143550, -0.520818533384, -0.377948209780 },
    { -0.581868275240, -0.103392490117, -0.806684140948 },
    { 0.362034593011, -0.916093258737, 0.172348759089 },
    { 0.453357661614, 0.848254841274, 0.273734460584 },
    { 0.423488457004, -0.595751266551, -0.682449965336 },
    { 0.674389446853, -0.240053897258, -0.698264276892 },
    { -0.441686967348, 0.850085857731, 0.286821647300 },
    { -0.655319594103, -0.066894099514, 0.752383817632 },
    { -0.449717839843, 0.302106767872, 0.840526837961 },
    { 0.855266998289, 0.211527783571, 0.473047945154 },
    { -0.165580944074, 0.882118062049, -0.440965617216 },
    { 0.856821275743, -0.236803656336, 0.458018918583 },
    { -0.834890156133, 0.481956439654, -0.265850366689 },
    { 0.402054982454, 0.346473651705, 0.847530412291 },
    { -0.720105038083, 0.265655952763, -0.640995825953 },
    { 71, DUMMYVAL, DUMMYVAL },
    { -0.536988123833, 0.654278727103, 0.532506433879 },
    { -0.793079716677, -0.424952690385, 0.436394058083 },
    { 0.132555430204, 0.839558017318, 0.526850446978 },
    { -0.008803746881, 0.275962036372, 0.961128216484 },
    { -0.469560998723, -0.578133363136, -0.667288755268 },
    { -0.985366693353, 0.161160892371, -0.055494561902 },
    { 0.732102366720, -0.101694015771, 0.673561023070 },
    { 0.441705805778, -0.887070265299, -0.134172745237 },
    { 0.206707053513, 0.684238936456, -0.699349177354 },
    { -0.230668722535, 0.915748456769, 0.328932674524 },
    { -0.853463316707, 0.474228409122, 0.216119834854 },
    { 0.992615961380, 0.119369903908, -0.021549460634 },
    { 0.511984920287, -0.812327290742, 0.279277306838 },
    { -0.001200878940, -0.971494186977, -0.237060335271 },
    { 0.284973447516, -0.730320283116, 0.620823983332 },
    { -0.762601080062, -0.539953786837, -0.356215525726 },
    { -0.162866912578, 0.821598104621, -0.546306620197 },
    { -0.812201450343, 0.229285210482, -0.536429954715 },
    { -0.304305017198, -0.117723673651, 0.945272232307 },
    { -0.432714165261, 0.290777429775, 0.853350418946 },
    { -0.161444792199, 0.981612318531, -0.101847116700 },
    { 0.728270481922, -0.201128579693, -0.655110219422 },
    { -0.050953381976, 0.042092952691, -0.997813577879 },
    { -0.125477914322, -0.832124446441, 0.540207551459 },
    { -0.938578503266, -0.342655139285, 0.040716688568 },
    { -0.172683314090, 0.638025054518, 0.750402893679 },
    { -0.697399133897, -0.716118674077, 0.028434005653 },
    { 0.120540628036, -0.972008107997, 0.201668527490 },
    { -0.941999678205, -0.011569808621, 0.335414289783 },
    { 0.377676559212, -0.088679204687, -0.921681298106 },
    { 0.211013973604, 0.970010941352, 0.120631159325 },
    { 0.626237762497, 0.268412706501, -0.731970548459 },
    { -0.759543107025, 0.286233472941, 0.584093029867 },
    { 0.293311703344, -0.801644491630, -0.520897642268 },
    { 0.938598673718, -0.258963459126, 0.227970297478 },
    { 0.044029558474, -0.425792834342, -0.903748781578 },
    { 0.829210711815, 0.524313869612, 0.193660944807 },
    { 0.440528916823, 0.129316426806, 0.888375784902 },
    { 0.578140629403, 0.813034333593, -0.068764707752 },
    { 0.571936064561, 0.642367966385, -0.510149521040 },
    { -0.681324777253, -0.113918273602, 0.723062358888 },
    { 0.230972675466, 0.917543247100, -0.323675783599 },
    { 0.254544889759, 0.330185752213, -0.908946790595 },
    { 0.838893550114, 0.491413288799, -0.234031175636 },
    { 0.526618848329, 0.756218443284, 0.388337809931 },
    { -0.419796405035, -0.850213845624, -0.317659243576 },
    { 0.887449793296, 0.126971161780, -0.443070184571 },
    { 0.117046495829, -0.135373680378, 0.983856739813 },
    { -0.334320839694, -0.256847293581, -0.906785004247 },
    { -0.168832088795, 0.476132032218, -0.863014492167 },
    { -0.817836034617, 0.528860141306, -0.226828506629 },
    { -0.096640295060, -0.753968347898, -0.649763329019 },
    { -0.517767625838, -0.749109290922, 0.413221436871 },
    { -0.299774498165, -0.949169758503, 0.095979267518 },
    { -0.586971045486, 0.801229895569, 0.116170763137 },
    { 0.791347168280, -0.611048605445, 0.019729699394 },
    { -0.441743367339, -0.493756294662, 0.749044403820 },
    { 0.428758285500, -0.490626757834, -0.758585339374 },
    { -0.538397655763, 0.551655318184, -0.637027765633 },
    { 0.291480881199, 0.542729310154, 0.787707935593 },
    { 0.707016149345, -0.502839731479, 0.497272932112 },
    { -0.932547358719, -0.139271662136, -0.333104830153 },
    { 0.665427641285, 0.406791891842, 0.625880508521 },
    { 0.907745990670, 0.145095334345, 0.393629979009 },
    { 0.689600499982, -0.598409847025, -0.407868612924 },
    { 0.427761240326, -0.374272662593, 0.822763815023 },
    { -0.702436782263, -0.187504470370, -0.686603699754 },
    { -0.482684669068, 0.166688014207, -0.859785215136 },
    { -0.030757409461, -0.520970735906, 0.853020207318 },
    { 0.932397283239, -0.272281729254, -0.237693008148 },
    { -0.505945200818, 0.810908746997, -0.294017784857 },
    { 72, DUMMYVAL, DUMMYVAL },
    { 0.440581285455, -0.735847637557, -0.514214337809 },
    { -0.054949218985, 0.431898834000, 0.900246622055 },
    { 0.926373049850, -0.129165673815, 0.353764330056 },
    { -0.553463369283, 0.757226696542, 0.346822762957 },
    { -0.825786475347, -0.067427970601, -0.559937644667 },
    { -0.428938068287, -0.261403155131, 0.864685216747 },
    { -0.229550743246, -0.506458999541, -0.831147242105 },
    { 0.691861275351, -0.418819155126, 0.588148357958 },
    { -0.035937419078, -0.812908893917, -0.581281026785 },
    { -0.175391944307, 0.874259309639, -0.452668007907 },
    { 0.612345292875, 0.416490876063, 0.671988535951 },
    { 0.241012992634, 0.243649370326, -0.939440110769 },
    { 0.775797382415, -0.561164991804, -0.288500040576 },
    { -0.818932162951, -0.484395379290, -0.307751895212 },
    { -0.944618049120, -0.051778179548, 0.324061354376 },
    { -0.450438213893, -0.755731476412, -0.475368647498 },
    { 0.962419218058, -0.267718876512, -0.045561517445 },
    { -0.618228900737, -0.782942016577, -0.069244674686 },
    { 0.015455519129, -0.823575651010, 0.566995832430 },
    { 0.087176196002, 0.622984839801, -0.777361048824 },
    { 0.264190217012, 0.849994486603, -0.455755309327 },
    { -0.190243186874, 0.259856861225, -0.946721681130 },
    { -0.494938955676, 0.507972371851, 0.704981914372 },
    { -0.039668471130, -0.151830102756, -0.987610263361 },
    { -0.424027117958, 0.900022947368, -0.100795324536 },
    { 0.324168456219, 0.226390189363, 0.918510911287 },
    { 0.987114042159, 0.155688550828, -0.036972191088 },
    { 0.545449375310, -0.836704703246, -0.049093976613 },
    { 0.663759633316, 0.104970857557, -0.740543225101 },
    { -0.624265894415, 0.286705923301, -0.726699254585 },
    { 0.610374563968, 0.705047804188, 0.361040836293 },
    { -0.036611233963, -0.459904930371, 0.887213093100 },
    { 0.881249310320, 0.299936388243, 0.365291412531 },
    { 0.133742730868, -0.976099041283, 0.171299572520 },
    { 0.381430480756, -0.209751668649, 0.900286080004 },
    { -0.962419206436, 0.267718923855, 0.045561484759 },
    { 0.826786394498, 0.562289665747, 0.015955866195 },
    { -0.461528699704, -0.081064056057, -0.883413763853 },
    { 0.377806916252, -0.156997422804, -0.912476708341 },
    { 0.465676319109, -0.798183255508, 0.382163651395 },
    { -0.726076774579, 0.079488190744, 0.683003766423 },
    { -0.014158422740, -0.043601405685, 0.998948675602 },
    { -0.612345320345, -0.416490889297, -0.671988502717 },
    { 0.220295844773, 0.909046600041, 0.353700466116 },
    { -0.333577270773, 0.595641992320, -0.730709806564 },
    { -0.225574097872, -0.961392416006, -0.157610116474 },
    { 0.266079675818, 0.659593761853, 0.702949269465 },
    { -0.188624632059, 0.950077274226, 0.248543600160 },
    { 0.639680670764, 0.687588210241, -0.343556534777 },
    { 0.463570570556, 0.885971576199, -0.012517678770 },
    { -0.767783418622, 0.640642997536, -0.009228856787 },
    { 0.795772165512, -0.572205546444, 0.198311555931 },
    { -0.366821899927, -0.649403685490, 0.666120519881 },
    { -0.894381752026, -0.430176411650, 0.122595010104 },
    { 0.644349985875, -0.376216665530, -0.665788341953 },
    { -0.812326347819, 0.408030220488, 0.416698024722 },
    { 0.504182205701, 0.504077524023, -0.701217621876 },
    { -0.615087303371, 0.666427516904, -0.421357299623 },
    { -0.739003698755, -0.347645163539, 0.577075708633 },
    { 0.209607468308, -0.534928377423, -0.818484172270 },
    { 0.333577342163, -0.595642055933, 0.730709722119 },
    { -0.981835893700, -0.103342682197, -0.159118094127 },
    { -0.292178982846, -0.918431923744, 0.266672539703 },
    { -0.872546071964, 0.324597145274, -0.365102787691 },
    { 0.054182375446, 0.993852802991, -0.096544684878 },
    { 0.188624554673, -0.950077286707, -0.248543611180 },
    { -0.639680700759, -0.687588137403, 0.343556624706 },
    { 0.894053175426, -0.111301697479, -0.433913414921 },
    { -0.155249849071, 0.762803613432, 0.627716601420 },
    { -0.377806863178, 0.156997390302, 0.912476735908 },
    { 0.851885742298, 0.326266173207, -0.409684105488 },
    { 0.704364202914, 0.004109695785, 0.709826866252 },
    { 73, DUMMYVAL, DUMMYVAL },
    { -0.079567118813, 0.477215632324, 0.875176732934 },
    { 0.832474349486, -0.536020432951, -0.140244618107 },
    { -0.159522434821, 0.978511607527, -0.130643127347 },
    { 0.540957910257, -0.753704595753, -0.373221009151 },
    { 0.224184342212, 0.158404824049, -0.961586861612 },
    { 0.255436651453, -0.343937226182, -0.903581375162 },
    { -0.596497767417, -0.774612126389, -0.210158195458 },
    { 0.953360743392, 0.151192418251, 0.261235804634 },
    { 0.251813307806, 0.954049844138, -0.162415987244 },
    { -0.835163974073, -0.540839638281, 0.099968105290 },
    { 0.071809016805, 0.558161057516, -0.826619440237 },
    { -0.069833230633, 0.845601563879, -0.529227092149 },
    { 0.839932735667, -0.271161869239, -0.470089608719 },
    { -0.700751651715, 0.590360236610, 0.400527044841 },
    { 0.701796704599, 0.558305999485, -0.442465587761 },
    { 0.529920789560, 0.626162422135, 0.571930570873 },
    { 0.581221122147, -0.050429313478, -0.812181563145 },
    { -0.349608889397, 0.097874789871, 0.931769365220 },
    { 0.347396843002, 0.769053000417, -0.536537898030 },
    { -0.914357078626, 0.072111381115, -0.398435793422 },
    { -0.919078578581, 0.238511413428, 0.313698696295 },
    { -0.284081810865, 0.781310456618, 0.555744091390 },
    { 0.154003248151, -0.980788401011, 0.119737679956 },
    { -0.443909811651, -0.183127146511, -0.877159351162 },
    { 0.089018363458, -0.669104686648, 0.737817490490 },
    { -0.679012805781, -0.548907245676, 0.487485841056 },
    { -0.729295530557, 0.138581760673, 0.670017257030 },
    { 0.519630286838, -0.021680146249, 0.854116114038 },
    { 0.743094657454, 0.260258993995, 0.616502705678 },
    { -0.942917376112, 0.323957911353, -0.077188687628 },
    { -0.192570583935, -0.316168275931, 0.928953277349 },
    { -0.484009942205, 0.465361597766, 0.741062048125 },
    { -0.542973452343, -0.585976723813, -0.601507364211 },
    { 0.807348238634, -0.176982287136, 0.562908599699 },
    { -0.892912824332, -0.188521456553, 0.408859815294 },
    { -0.483576928003, 0.808780557404, -0.334704891910 },
    { -0.172822453743, -0.539845582064, -0.823831989551 },
    { -0.503281798250, -0.833360737083, 0.228511079464 },
    { 0.137758334881, 0.760081073859, 0.635058581811 },
    { -0.624625828973, 0.210872386649, -0.751914496687 },
    { -0.586576255923, -0.247250842860, 0.771229743133 },
    { 0.946025086249, -0.274765380117, 0.171873564216 },
    { 0.003939180133, 0.964303513032, 0.264770122209 },
    { 0.788703319132, 0.562092402193, 0.248996397137 },
    { 0.986184869875, -0.032606771683, -0.162407514819 },
    { 0.226127407959, -0.314267973623, 0.922009780927 },
    { -0.333662696596, -0.647163461573, 0.685455074316 },
    { 0.178873052975, -0.721984762589, -0.668387936388 },
    { -0.438468444595, 0.881858018293, 0.173412394789 },
    { -0.068866536873, -0.127113151923, -0.989494642081 },
    { 0.630748405435, 0.769720942560, -0.098418085872 },
    { -0.740949413915, 0.671201711852, -0.021959690915 },
    { -0.749519308983, -0.210497312072, -0.627623842019 },
    { -0.123940622075, -0.901298145951, 0.415090802481 },
    { -0.381376029040, 0.595753991092, -0.706844754222 },
    { -0.746273405438, 0.487913753414, -0.452787117270 },
    { 0.828758272122, 0.162055322447, -0.535628414907 },
    { 0.915802997382, 0.383067373080, -0.120682466283 },
    { 0.163833840032, -0.940684955532, -0.297103159352 },
    { 0.563861362508, -0.480330635566, -0.671820544794 },
    { 0.731941048521, -0.596554087308, 0.329219565649 },
    { 0.411861402185, 0.875733821438, 0.251913595069 },
    { 0.072188751383, 0.076071944491, 0.994485718065 },
    { 0.495935380718, 0.400896778985, -0.770279086274 },
    { 0.346788038968, 0.379105916305, 0.857914191660 },
    { -0.858921254576, -0.420254289582, -0.292644170496 },
    { 0.544085100402, -0.838287768933, 0.035284840636 },
    { 0.360585624442, -0.813925245957, 0.455525741796 },
    { 0.534668509831, -0.482683205416, 0.693647250268 },
    { -0.222530616424, -0.844884988879, -0.486466319822 },
    { -0.234718535219, 0.265153726245, -0.935200893222 },
    { -0.992847921611, -0.119380045705, -0.001187113958 },
    { -0.232348130838, -0.970261177371, -0.067879258849 },
    { 74, DUMMYVAL, DUMMYVAL },
    { 0.067968718869, -0.110442746012, -0.991555673227 },
    { -0.189149264561, 0.456280131839, 0.869500429560 },
    { -0.891845737985, -0.123243923010, -0.435226510083 },
    { 0.643073457873, -0.324808473468, 0.693509901402 },
    { -0.988421068780, 0.143238932899, -0.050063948048 },
    { -0.240422258151, -0.284694254831, 0.927979697543 },
    { -0.193999002138, -0.484454073908, -0.853034956754 },
    { 0.457884951867, -0.752213624625, -0.473831229218 },
    { 0.833330459276, -0.065195895421, -0.548916970829 },
    { -0.418150005773, 0.114166494530, 0.901175112949 },
    { 0.464752911784, 0.051392114572, 0.883947725574 },
    { 0.912081694071, -0.186968769313, 0.364896783545 },
    { 0.548246463080, 0.482132969623, 0.683354677546 },
    { -0.483521903001, -0.862086274482, -0.151703080612 },
    { 0.979354352986, -0.118899617891, -0.163486795039 },
    { 0.244384576789, 0.284652097842, -0.926957044216 },
    { -0.661063437549, 0.115057306964, -0.741455964741 },
    { 0.496992602816, -0.042704229476, -0.866703352671 },
    { 0.358776860958, -0.675391424885, 0.644302403560 },
    { -0.182627898917, 0.265984568791, -0.946519550618 },
    { -0.043220567850, 0.636937536960, -0.769702901467 },
    { 0.819661068713, 0.438124135642, 0.369056871234 },
    { 0.904689039483, 0.308349561080, -0.294037905756 },
    { 0.540160926289, 0.769997065973, 0.339603728047 },
    { -0.623107185946, -0.257416482634, 0.738562244696 },
    { -0.359643207079, -0.104632551956, -0.927204827788 },
    { -0.854294937849, 0.304659605902, -0.421144492660 },
    { -0.761241483038, 0.116551735569, 0.637908376993 },
    { -0.878027991945, 0.359470012216, 0.315987587855 },
    { 0.886969443118, -0.456272514576, 0.071418480929 },
    { -0.572856561606, 0.492608592485, 0.655112306735 },
    { 0.607317015883, -0.406000254268, -0.682883471577 },
    { -0.457384074011, -0.839549219889, 0.293184099542 },
    { -0.957285238216, -0.285395027959, -0.046418215283 },
    { 0.376138023576, 0.600326164426, -0.705782320213 },
    { 0.790515721868, 0.612419400195, -0.005231801308 },
    { 0.978277537151, 0.166866698779, 0.122998232285 },
    { 0.072488705895, -0.764661585098, -0.640342133389 },
    { -0.024418636477, -0.604066412175, 0.796559790521 },
    { 0.780090129746, 0.100189660831, 0.617593249101 },
    { -0.823502059276, 0.565133119331, -0.049688185760 },
    { 0.639137743034, 0.664779546099, -0.386744231397 },
    { -0.231198515098, 0.766349142467, 0.599379878255 },
    { -0.462522634579, 0.486894172057, -0.740949983278 },
    { 0.676875694166, -0.628023684385, 0.383960344955 },
    { 0.436812006339, 0.896622574794, -0.072548118434 },
    { 0.800722854404, -0.496477873329, -0.335190440988 },
    { -0.248999943281, 0.938291553257, 0.240016643864 },
    { 0.329181388541, -0.904768202380, 0.270248244027 },
    { -0.046859104961, -0.873387468490, 0.484766494475 },
    { 0.016266555273, 0.037246261491, 0.999173716220 },
    { -0.023573059359, 0.992112253905, -0.123116150539 },
    { 0.246171664061, -0.456886639151, -0.854783078201 },
    { 0.186309497544, 0.745363315289, 0.640095539233 },
    { -0.627720656965, 0.655284519220, -0.420201113385 },
    { -0.772914264846, -0.473756356029, 0.422088206799 },
    { 0.621567126935, -0.782350936315, -0.039765803924 },
    { 0.210996825905, 0.871641997774, -0.442403172654 },
    { -0.422974389062, -0.631980065536, 0.649379598511 },
    { -0.241551076262, 0.846981766383, -0.473576778327 },
    { -0.620372984974, 0.722234644659, 0.305801369468 },
    { -0.099980745766, -0.990798373698, 0.091227370638 },
    { 0.208983023334, 0.397319801811, 0.893567608548 },
    { 0.259940329157, -0.316406906321, 0.912314471501 },
    { 0.675200852465, 0.306462582838, -0.670957892979 },
    { -0.479252028413, 0.872324537263, -0.096785303382 },
    { -0.622441031367, -0.343514036924, -0.703253346175 },
    { -0.409182082053, -0.711286342820, -0.571525819404 },
    { -0.120411278012, -0.934363237815, -0.335360200303 },
    { 0.165817762392, 0.948248603304, 0.270793382504 },
    { -0.939447810878, -0.098037439305, 0.328369412599 },
    { 0.257204939173, -0.952747039884, -0.161612800411 },
    { -0.755788955430, -0.548338825643, -0.357921202422 },
    { -0.765590991461, -0.640467787609, 0.060592465120 },
    { 75, DUMMYVAL, DUMMYVAL },
    { -0.555031771059, 0.828939929901, 0.069269948251 },
    { -0.334674948469, 0.827283096755, 0.451215421602 },
    { 0.911103699418, 0.012458439877, 0.411988878712 },
    { -0.828666466702, 0.555049278303, -0.072333848365 },
    { -0.646677368035, 0.044291081306, -0.761476645596 },
    { -0.907553270267, 0.319281040351, 0.272775876683 },
    { 0.997059472396, 0.076532525662, -0.003896283089 },
    { -0.104252357801, 0.294040073255, 0.950090459490 },
    { 0.264011576697, -0.628746358680, -0.731420469919 },
    { 0.387781267677, -0.266755483761, 0.882307882954 },
    { 0.123124983037, 0.869868462656, 0.477670489174 },
    { 0.309443074681, 0.168927449505, 0.935792979422 },
    { 0.761942040160, -0.636809504869, -0.117974497012 },
    { -0.577373844212, -0.799834538960, 0.164024858810 },
    { -0.460602510519, -0.715722505350, -0.524963448860 },
    { 0.868331169593, 0.463151423436, -0.177459118904 },
    { 0.338868274357, 0.449287599348, -0.826625033317 },
    { -0.007382296687, -0.278380191634, -0.960442590997 },
    { -0.440182014646, -0.314748522922, -0.840935884179 },
    { 0.598372801871, 0.128418926423, -0.790859386565 },
    { -0.760538364294, 0.153111586922, 0.630981963599 },
    { 0.664821095838, 0.392851033399, 0.635358934844 },
    { -0.814959010954, 0.345652030911, -0.465152108446 },
    { 0.458391772826, -0.888139651455, 0.032938459560 },
    { 0.889871429988, 0.138519969614, -0.434673505184 },
    { -0.948342112372, -0.098298077087, 0.301636745015 },
    { 0.060804154523, -0.996393684323, -0.059181759294 },
    { 0.662198532753, -0.677852350046, 0.319388939629 },
    { 0.635666031792, -0.575281858883, -0.514761574776 },
    { 0.415117258464, -0.270568026650, -0.868602673655 },
    { -0.677716444955, 0.604208461484, 0.419085379498 },
    { -0.895552342828, -0.066343370481, -0.439982452433 },
    { -0.481770591202, 0.444078965945, 0.755440910633 },
    { 0.318644132903, 0.943165097463, 0.094369038850 },
    { -0.353364267643, -0.919281003638, -0.173367040420 },
    { -0.267615470832, 0.080015924859, -0.960197589843 },
    { 0.755209429614, -0.214483614973, -0.619399302818 },
    { -0.594461526840, 0.692389833567, -0.408915408710 },
    { 0.660475615102, 0.015892995422, 0.750679275424 },
    { -0.729707710027, -0.406776576751, -0.549599376395 },
    { -0.114379773163, 0.984895604384, 0.129991984198 },
    { 0.180054061241, 0.091100462253, -0.979429038169 },
    { -0.078040282186, 0.454243565590, -0.887452814225 },
    { 0.371628900932, -0.852703785406, -0.367135144526 },
    { 0.681443524581, 0.728244794547, 0.072761542192 },
    { 0.218322531808, 0.758559401528, -0.613940474687 },
    { 0.520677063201, 0.797150989459, -0.305688887369 },
    { -0.114248571601, 0.651402792804, 0.750081105891 },
    { -0.031359398096, -0.111959263820, 0.993217856966 },
    { -0.824433644794, -0.493348753222, 0.277337651656 },
    { 0.662661604552, 0.501873872081, -0.555879676166 },
    { -0.486472591339, 0.438722670037, -0.755557302044 },
    { -0.715694832151, -0.270083935905, 0.644077304986 },
    { -0.111385733983, -0.773560330399, 0.623857061753 },
    { -0.738181359968, -0.647529410683, -0.189192870099 },
    { 0.931902304482, -0.270993299677, -0.241082405892 },
    { 0.389021909811, -0.649402821514, 0.653404873793 },
    { -0.947577552932, -0.305879697836, -0.092381771100 },
    { -0.204901067514, -0.943083523253, 0.261933237104 },
    { 0.048551992095, -0.503634501842, 0.862551443462 },
    { 0.110925255062, 0.956266362305, -0.270647800866 },
    { -0.357750188050, -0.393111391815, 0.847040870664 },
    { -0.509970299591, -0.656919777628, 0.555325759620 },
    { -0.202525132818, 0.756867885038, -0.621397276447 },
    { 0.872505736074, 0.407530922316, 0.269540883492 },
    { -0.447914267944, 0.020357739288, 0.893844713037 },
    { 0.724734917609, -0.365015064977, 0.584399949981 },
    { -0.297805254485, 0.922603705617, -0.245182447952 },
    { 0.289117226203, 0.551153976809, 0.782713564058 },
    { -0.034828904527, -0.882254573612, -0.469482496745 },
    { 0.517624851616, 0.727960265236, 0.449598004029 },
    { 0.920637438747, -0.345544904062, 0.181728989581 },
    { -0.986154213443, 0.138336630239, -0.091448586884 },
    { 0.219407716515, -0.900969233939, 0.374318972842 },
    { -0.150407092768, -0.614277276121, -0.774623220983 },
    { 76, DUMMYVAL, DUMMYVAL },
    { -0.995492518226, -0.083924583361, 0.044173639931 },
    { -0.912279075007, -0.226637429954, -0.341148596140 },
    { -0.906793256946, 0.060540801431, 0.417205944970 },
    { -0.384168135389, -0.687517300864, 0.616226261015 },
    { -0.940326642487, 0.224103530123, -0.256053535839 },
    { -0.581510545268, -0.350033132603, 0.734385656057 },
    { 0.509846052987, 0.734953606723, 0.447101999791 },
    { 0.293242079328, 0.896750025026, -0.331433968576 },
    { -0.464662890488, 0.143005901972, -0.873863667974 },
    { 0.427254964897, 0.184931224471, 0.885016179053 },
    { -0.162373647662, -0.450742390778, 0.877761981235 },
    { 0.914515247935, 0.369018957851, -0.165791646474 },
    { 0.009495020330, -0.813607198202, -0.581337399126 },
    { 0.691735782269, 0.396475762139, 0.603579802151 },
    { -0.251359235533, 0.918834607450, 0.304239213226 },
    { 0.414067693744, -0.772662240581, 0.481187081059 },
    { -0.207259303012, -0.173079551263, -0.962853597516 },
    { -0.149654453692, -0.977708099165, -0.147276669290 },
    { -0.070105690093, 0.678398680767, 0.731341522239 },
    { 0.064855557457, 0.657368224649, -0.750773450442 },
    { 0.464068654258, -0.340135117041, -0.817892649613 },
    { -0.091897675996, 0.893537779146, -0.439482712271 },
    { -0.848958305414, -0.333863742196, 0.409639838536 },
    { -0.309503965198, -0.917433969913, 0.250044408807 },
    { 0.308290733044, 0.564149262780, 0.765958506202 },
    { 0.481353732926, -0.222255042924, 0.847880463092 },
    { -0.305203650731, -0.051174651934, 0.950911082373 },
    { 0.922457467256, -0.230072695639, 0.310062535345 },
    { 0.909984572185, -0.390637711705, -0.139033293056 },
    { -0.322648259079, 0.537052036783, -0.779405677873 },
    { 0.898176124940, -0.007933612220, -0.439564223276 },
    { -0.437960643123, 0.689554519372, 0.576805894464 },
    { -0.387748682114, 0.364055794299, 0.846826037717 },
    { 0.999377966478, -0.008121635180, -0.034317913102 },
    { 0.780375946822, 0.602519657139, 0.167282528625 },
    { -0.381661492852, -0.811205075853, -0.443035923807 },
    { -0.312721384117, -0.561513838356, -0.766098913490 },
    { 0.359581891241, 0.333431919468, -0.871506751880 },
    { -0.760860278496, 0.621456804771, -0.186770116485 },
    { -0.594845651993, -0.282848715936, -0.752432890163 },
    { -0.465411876590, 0.755723861444, -0.460731191014 },
    { 0.670612201927, -0.463893956999, 0.578862394086 },
    { -0.000533511241, -0.814143556610, 0.580663400428 },
    { 0.082494209738, -0.488158687062, -0.868847398342 },
    { 0.655790819430, -0.708757519657, -0.260002268222 },
    { 0.237281622904, -0.546476536929, 0.803156787942 },
    { 0.926725050139, 0.231356790526, 0.296065392982 },
    { -0.579584217485, -0.811216729117, -0.077521308315 },
    { -0.055867268679, 0.265959596673, -0.962363933877 },
    { 0.408692100600, -0.690601775928, -0.596690836189 },
    { 0.205942910796, -0.058359756556, -0.976822223492 },
    { -0.398258062032, 0.913005541664, -0.088382107443 },
    { 0.008208784225, 0.291485664275, 0.956539974797 },
    { -0.787037910132, 0.039143176883, -0.615661546403 },
    { -0.702288201573, -0.559149192684, -0.440617137947 },
    { 0.022678636141, 0.999669543973, -0.012102987879 },
    { 0.135955125489, 0.896035629249, 0.422653942332 },
    { -0.733832881051, 0.422398187460, 0.532042361020 },
    { 0.773089705438, -0.012388191595, 0.634175717018 },
    { -0.661717826013, 0.048503529928, 0.748182415138 },
    { 0.769817173707, -0.608602147118, 0.192314704557 },
    { 0.741839076611, 0.373173614227, -0.557150103704 },
    { 0.449638314388, 0.648571986417, -0.614149627264 },
    { 0.432726249595, 0.898576047970, 0.072863426541 },
    { 0.630456437446, 0.030297415554, -0.775633126610 },
    { -0.916747568900, 0.376478645906, 0.133557942830 },
    { 0.753776185638, -0.383411784129, -0.533682364105 },
    { 0.481396380456, -0.872725641535, 0.081286404101 },
    { -0.656528929114, 0.725795710097, 0.205402902709 },
    { -0.663328766013, -0.676601598445, 0.319695519457 },
    { 0.103661715178, -0.974687525926, 0.198087040489 },
    { 0.251982984696, -0.932518233391, -0.258678023451 },
    { -0.695426721818, 0.427805448935, -0.577376976025 },
    { 0.669937197567, 0.703028119582, -0.238611848811 },
    { 0.103572136917, -0.125757198137, 0.986639721262 },
    { -0.867584830514, -0.497072007335, -0.014696305206 },
    { 77, DUMMYVAL, DUMMYVAL },
    { -0.090160392317, -0.808370646005, -0.581728460998 },
    { 0.623603493946, 0.554783495212, 0.550757619811 },
    { -0.833778164522, 0.244260212046, 0.495127176772 },
    { -0.544338238952, 0.420662965814, 0.725767559765 },
    { 0.542629038889, 0.197158872993, 0.816506034855 },
    { 0.956907002302, -0.270760200106, -0.104966199241 },
    { 0.350375241549, -0.200897978383, 0.914809921454 },
    { -0.725404191865, 0.603773194069, 0.330524868275 },
    { 0.501823582193, -0.861269851315, -0.079920808124 },
    { 0.141628784761, 0.196608990460, 0.970199047720 },
    { 0.006113476798, -0.545624845282, 0.838007251528 },
    { -0.036989645101, 0.184697228449, -0.982099129395 },
    { -0.147851471710, 0.489163721304, 0.859568959464 },
    { -0.059823556597, 0.966038362314, 0.251378250082 },
    { 0.362928347118, 0.294578343342, -0.884028627643 },
    { 0.926522128317, 0.129102248256, -0.353396880624 },
    { -0.262191336743, 0.762206235772, -0.591859237562 },
    { 0.843555984878, 0.161348126634, 0.512230497342 },
    { 0.264519354366, 0.963911069086, -0.030082587297 },
    { -0.253581474575, -0.949607130406, -0.184235538470 },
    { -0.907427374374, 0.277815454881, -0.315268351197 },
    { 0.328826618949, -0.121800320408, -0.936502929317 },
    { -0.049711087015, -0.169013161797, 0.984359364748 },
    { -0.922949963985, -0.132857370760, 0.361264837777 },
    { 0.390381022817, -0.577807478333, 0.716757403175 },
    { 0.792761703408, -0.603910718982, 0.082587681332 },
    { 0.012008345156, 0.787219305448, 0.616556213801 },
    { 0.671128140253, 0.041360362828, -0.740186692495 },
    { 0.841287477814, 0.508332705382, -0.183938142623 },
    { 0.927129442137, -0.206020743728, 0.313027875238 },
    { 0.709846006388, -0.524940676240, 0.469633829322 },
    { 0.454046838295, -0.822801256131, 0.341818024016 },
    { 0.856533441303, 0.462164048523, 0.229684253232 },
    { 0.122535300682, -0.983512184673, 0.132999558975 },
    { 0.990779248104, 0.122621032833, 0.057624333701 },
    { 0.543670870021, -0.412729557319, -0.730805239175 },
    { 0.383652462063, -0.754971357144, -0.531816733701 },
    { 0.070843899462, -0.842060224226, 0.534710875787 },
    { 0.704051643659, 0.420581574779, -0.572208372901 },
    { 0.123780579090, 0.882963377490, -0.452828932657 },
    { -0.330017609571, 0.117460168949, 0.936638396652 },
    { 0.153128124939, -0.551882506481, -0.819742323168 },
    { -0.325424275957, -0.706023867571, 0.628990730487 },
    { 0.720291909221, -0.605630689915, -0.338217434417 },
    { 0.294167095216, 0.545462003968, 0.784816489582 },
    { 0.381299358355, 0.645997361561, -0.661285269891 },
    { 0.623315166085, 0.774321433292, 0.109107844230 },
    { -0.263221511530, -0.933627948024, 0.243008828103 },
    { -0.869527332949, -0.478646107372, 0.121737919944 },
    { -0.609042609984, -0.789325169266, -0.077671593181 },
    { -0.379147171450, 0.398570920853, -0.835097984330 },
    { -0.142961960127, 0.976090331157, -0.163736200575 },
    { -0.885675179372, -0.115782307535, -0.449637558380 },
    { 0.143953923403, -0.951171480280, -0.273038610895 },
    { -0.701176308123, 0.151146478197, -0.696782984189 },
    { -0.604509882615, -0.727098837666, 0.325415245626 },
    { 0.833778247923, -0.244260214177, -0.495127035275 },
    { -0.790515592192, 0.607141722420, -0.080399175361 },
    { -0.504645944934, 0.820117650975, -0.269702630358 },
    { -0.666428235814, -0.034599818973, 0.744765908884 },
    { -0.815531484830, -0.494452215799, -0.300708170062 },
    { 0.540078841546, 0.784016338739, -0.305995466476 },
    { -0.296834028142, -0.513763502297, -0.804945105858 },
    { -0.059099043814, -0.227491891948, -0.971984949533 },
    { 0.012665023005, 0.572637323192, -0.819710981554 },
    { -0.641808578685, -0.338396729886, -0.688163789754 },
    { -0.991098250268, -0.118829493028, -0.060031740791 },
    { -0.418349610580, -0.046801080883, -0.907079523612 },
    { -0.498845220624, -0.717580633862, -0.486036500447 },
    { -0.400083618918, -0.348025777717, 0.847827314916 },
    { -0.706494813161, -0.421469420245, 0.568531975156 },
    { -0.959399117694, 0.261678836856, 0.105249794822 },
    { -0.651381200770, 0.538938954756, -0.534085512189 },
    { 0.351012014805, 0.847185243869, 0.398832957556 },
    { 0.691218690893, -0.187431870647, 0.697915478568 },
    { -0.381945259454, 0.753176794358, 0.535576824760 },
    { -0.461407131527, 0.875954773676, 0.140736254927 },
    { 78, DUMMYVAL, DUMMYVAL },
    { -0.846268358178, 0.001042716362, -0.532755834027 },
    { -0.111772010976, -0.497068009470, 0.860482661955 },
    { 0.444850908114, 0.620956003962, 0.645384622294 },
    { -0.582705921713, -0.764732800195, -0.275022822881 },
    { 0.840147692478, 0.542357020457, -0.000846868144 },
    { -0.984026345119, 0.146870744783, 0.100603858965 },
    { 0.536080018944, -0.830659032306, -0.150412051837 },
    { -0.271416911614, -0.957321639847, -0.099338501959 },
    { 0.500228509152, -0.101991352935, 0.859865804971 },
    { 0.850909095537, -0.219110818348, -0.477434980302 },
    { -0.260548962006, -0.269393475129, -0.927114552769 },
    { -0.082280521177, 0.125914429632, -0.988623018266 },
    { -0.536079981590, 0.830659027483, 0.150412211603 },
    { 0.748114727856, 0.149162483898, -0.646587122793 },
    { -0.837669209753, 0.528702537646, 0.137054448007 },
    { 0.455223111856, -0.704320924410, 0.544705382635 },
    { 0.912520875125, -0.313395720902, 0.262847435940 },
    { 0.692717775103, -0.381789730232, 0.611864924592 },
    { -0.619879184739, -0.266398970015, -0.738093073468 },
    { -0.500228522303, 0.101991328652, -0.859865800201 },
    { 0.151315465594, 0.866096459232, 0.476424761298 },
    { 0.642506793409, -0.583882062752, -0.496252715075 },
    { -0.151315341767, -0.866096470668, -0.476424779836 },
    { -0.455223177851, 0.704320964537, -0.544705275596 },
    { -0.642506721492, 0.583882041049, 0.496252833723 },
    { -0.850909117587, 0.219110818974, 0.477434940715 },
    { -0.266879550206, 0.826367997192, 0.495874216812 },
    { 0.702443477506, -0.675603648164, 0.223903710324 },
    { -0.148838337662, 0.232061518915, 0.961246378761 },
    { 0.496926374420, 0.454554493883, -0.739218770390 },
    { 0.266879670929, -0.826368023186, -0.495874108520 },
    { 0.326816316865, -0.918089610276, 0.224282327736 },
    { 0.345847999053, -0.536943301360, -0.769468032264 },
    { 0.545918606930, 0.821028710059, -0.166987220671 },
    { -0.840147699043, -0.542357010436, 0.000846772976 },
    { 0.984026341718, -0.146870724154, -0.100603922347 },
    { 0.346697198704, 0.771161205771, -0.533958282195 },
    { -0.692717770243, 0.381789762615, -0.611864909887 },
    { -0.545918636922, -0.821028708338, 0.166987131081 },
    { -0.053220005598, -0.609115609132, -0.791293754377 },
    { 0.729240885086, 0.545441362968, -0.413160321282 },
    { 0.148838370189, -0.232061565312, -0.961246362523 },
    { -0.797885275153, -0.440394372095, -0.411621045041 },
    { 0.082280472914, -0.125914453250, 0.988623019275 },
    { -0.444850807963, -0.620956027544, -0.645384668636 },
    { 0.973210169079, 0.159644296151, 0.165455932220 },
    { -0.345847887855, 0.536943264510, 0.769468107958 },
    { -0.089703683273, -0.960381384616, 0.263857623144 },
    { -0.063613966512, 0.787907492402, -0.612499017698 },
    { -0.936422848912, -0.215940197026, 0.276553935687 },
    { 0.260549008945, 0.269393434271, 0.927114551450 },
    { 0.837669233834, -0.528702527432, -0.137054340225 },
    { 0.351451457837, 0.125683214014, -0.927731428000 },
    { 0.797885307836, 0.440394365911, 0.411620988305 },
    { 0.298398575652, -0.460934678450, 0.835761636025 },
    { -0.702443495419, 0.675603674257, -0.223903575395 },
    { 0.136756870214, -0.981176242621, -0.136347861611 },
    { -0.298398653586, 0.460934689218, -0.835761602261 },
    { -0.575883788353, 0.202997853970, 0.791927858833 },
    { -0.326816357871, 0.918089625888, -0.224282204075 },
    { 0.111771908861, 0.497068009202, -0.860482675373 },
    { 0.936422821990, 0.215940201310, -0.276554023501 },
    { 0.575883775601, -0.202997846707, -0.791927869968 },
    { 0.582705966324, 0.764732797783, 0.275022735069 },
    { -0.351451526633, -0.125683218224, 0.927731401368 },
    { -0.912520855494, 0.313395767817, -0.262847448158 },
    { 0.271416925942, 0.957321642371, 0.099338438487 },
    { -0.346697293844, -0.771161192777, 0.533958239188 },
    { -0.729240937370, -0.545441359662, 0.413160233365 },
    { 0.619879224356, 0.266398934642, 0.738093052964 },
    { -0.973210159864, -0.159644267885, -0.165456013696 },
    { 0.063613863889, -0.787907490418, 0.612499030909 },
    { 0.846268385889, -0.001042697848, 0.532755790044 },
    { -0.496926473319, -0.454554475313, 0.739218715326 },
    { -0.136756839188, 0.981176234773, 0.136347949204 },
    { 0.089703609925, 0.960381388713, -0.263857633167 },
    { -0.748114788842, -0.149162458660, 0.646587058054 },
    { 0.053220132935, 0.609115582507, 0.791293766308 },
    { 79, DUMMYVAL, DUMMYVAL },
    { -0.572638433733, -0.256543209801, 0.778633935632 },
    { 0.779640941223, 0.005616623668, 0.626201609952 },
    { 0.490115275066, -0.507122594378, -0.708952531146 },
    { -0.409646609193, 0.902523156437, -0.132821713857 },
    { 0.846385240359, -0.277077911265, -0.454818486861 },
    { 0.991836129934, -0.059816846667, -0.112618986912 },
    { -0.366985235114, 0.471949828077, 0.801614119753 },
    { 0.923852783708, 0.360152828298, -0.129560697376 },
    { 0.712310457790, 0.565699600177, -0.415448882635 },
    { 0.477548622564, -0.239600235527, 0.845304111088 },
    { 0.633352624197, -0.119243056850, -0.764621178634 },
    { -0.350781455208, -0.614433700343, -0.706699086291 },
    { 0.519151687125, 0.772379431010, 0.365939257676 },
    { -0.657042132704, 0.544883983735, 0.520957848699 },
    { 0.132648918118, -0.982270792441, -0.132470203594 },
    { 0.670497543597, -0.638048184077, -0.378586263389 },
    { -0.726562066266, 0.645039375611, -0.236710303481 },
    { 0.705761884177, -0.661768825509, 0.252907462184 },
    { 0.874749654041, -0.479498649288, -0.069957759296 },
    { 0.608063656326, 0.299271834200, -0.735319630576 },
    { 0.425303465487, -0.658063450012, 0.621344878472 },
    { -0.877491588071, 0.226283892098, 0.422852353714 },
    { 0.364578760111, 0.859582961957, -0.358049520582 },
    { -0.715664828814, -0.411778010264, -0.564147784771 },
    { -0.680322809574, 0.435659829114, -0.589373725296 },
    { -0.110935211176, 0.080246065569, -0.990582630517 },
    { 0.382185724929, 0.621434120387, -0.683925219361 },
    { 0.468717036021, 0.191048648336, 0.862441159797 },
    { -0.795602401771, 0.019998451006, -0.605488959646 },
    { -0.949204427392, -0.163314105831, -0.268959955859 },
    { 0.023031158227, -0.798183428860, 0.601974068914 },
    { -0.400820509478, 0.763587269908, -0.506238481761 },
    { 0.932770804264, -0.247252109008, 0.262307112569 },
    { -0.854135305640, -0.166120154855, 0.492805208790 },
    { -0.817287761240, -0.541670837843, -0.196553857141 },
    { -0.681427999234, -0.554057676213, 0.478200766717 },
    { 0.722929537988, -0.396640793117, 0.565728702064 },
    { -0.000087946951, 0.784210707793, -0.620494607589 },
    { 0.138386460263, 0.885749970946, 0.443053243510 },
    { 0.084552677329, 0.445541302989, -0.891259665915 },
    { 0.708738619278, 0.404740911620, 0.577818625526 },
    { -0.279848209571, 0.101581883667, 0.954654964116 },
    { -0.911768491383, -0.380088149749, 0.155599539015 },
    { 0.638915428175, 0.766548915504, -0.064728940828 },
    { -0.524655622752, -0.768832969595, -0.365557577377 },
    { 0.870052944457, 0.138642918930, -0.473060265581 },
    { -0.995959048907, 0.028668382940, 0.085109909641 },
    { -0.640925239928, 0.148794138985, 0.753043917064 },
    { -0.145703406356, 0.975937178468, 0.162225586947 },
    { 0.310164126744, 0.123758625811, -0.942593240491 },
    { 0.525906521583, -0.847270094429, -0.074536686554 },
    { -0.028803343909, 0.675529182131, 0.736770446930 },
    { -0.025329734183, 0.966218276499, -0.256477380533 },
    { -0.201155286424, -0.290284746069, 0.935559360460 },
    { -0.485562993788, 0.173001892260, -0.856912436797 },
    { 0.371895990239, 0.587168842212, 0.718975745891 },
    { 0.076377581289, -0.643595221530, -0.761545570469 },
    { -0.609088008228, 0.771532925814, 0.183708308516 },
    { 0.349259801349, -0.890368980622, 0.291994297046 },
    { -0.924540401483, 0.263698659282, -0.275114636322 },
    { 0.815743875529, 0.538098864640, 0.212159235977 },
    { 0.071229820843, 0.339917858747, 0.937753785344 },
    { -0.880810247774, 0.463190433108, 0.098122016351 },
    { 0.139980234603, -0.059527488961, 0.988363299591 },
    { -0.323835967275, -0.611401389380, 0.722023965920 },
    { -0.137321637305, -0.323682032228, -0.936147803469 },
    { -0.326043017652, 0.809858077412, 0.487673912663 },
    { -0.502289686418, -0.218712814307, -0.836582199055 },
    { 0.950601930667, 0.157017275178, 0.267771441172 },
    { 0.250963009383, -0.266506697784, -0.930586776156 },
    { -0.649250277406, -0.754508608853, 0.095868850287 },
    { -0.037281965088, -0.972077474408, 0.231679603824 },
    { -0.381464090336, -0.840274404580, 0.385258449346 },
    { 0.136187511624, -0.491795206529, 0.859994439815 },
    { -0.295250531024, 0.512538668474, -0.806307160609 },
    { -0.311440330609, -0.947636596296, -0.070638529369 },
    { 0.277140805106, 0.959527700100, 0.049995668675 },
    { -0.122176558910, -0.880684535245, -0.457676346159 },
    { 0.305647922143, -0.827165171633, -0.471568792994 },
    { 80, DUMMYVAL, DUMMYVAL },
    { 0.711232872256, -0.246877788332, -0.658178668031 },
    { 0.132620590915, -0.741235820500, 0.658013098101 },
    { -0.774784994552, 0.510587871988, 0.372838084421 },
    { -0.959875673977, 0.115437707635, -0.255563741881 },
    { -0.215761764072, 0.697323052922, -0.683511097955 },
    { -0.075239560611, 0.942655638957, 0.325175882966 },
    { 0.550365893301, 0.522872600631, -0.650923672176 },
    { -0.907062568112, 0.420911563307, -0.008423384387 },
    { -0.410993949830, 0.159840409647, 0.897516025844 },
    { 0.117530937528, -0.447658725152, -0.886446921434 },
    { -0.491621395996, 0.780112784172, -0.386952770982 },
    { 0.310162455214, 0.280136476557, -0.908472787638 },
    { 0.173344234084, 0.648173776883, -0.741500189798 },
    { -0.487390963579, 0.803799649605, 0.341110204944 },
    { 0.927894958799, -0.106401013251, -0.357337053514 },
    { 0.112485653305, 0.993106434480, -0.032963428135 },
    { -0.763364539691, 0.122624178506, -0.634222272068 },
    { 0.322787548415, 0.874896345155, 0.361060360359 },
    { 0.032847350886, 0.059016860837, 0.997716423477 },
    { -0.779253671044, 0.485567363698, -0.396217177158 },
    { 0.127982375796, -0.389140070479, 0.912244768159 },
    { -0.246143700787, -0.216310273134, 0.944787354011 },
    { -0.241729973887, -0.576959167794, 0.780182503280 },
    { 0.780854009094, -0.515981369492, -0.352179276532 },
    { -0.312975620345, 0.949316276707, -0.029066610543 },
    { -0.610925412708, -0.259295444507, -0.748021398468 },
    { 0.318244082056, 0.849456463452, -0.420885282394 },
    { 0.463787280935, -0.553621455231, -0.691668014549 },
    { -0.544841472017, -0.806953335516, 0.227978254816 },
    { -0.079365236340, 0.919555156488, -0.384862928116 },
    { 0.403905827535, -0.914390082396, 0.027401819288 },
    { 0.181695344801, 0.694933055148, 0.695740505175 },
    { 0.407130407519, -0.086414632302, 0.909272974743 },
    { 0.726987796031, -0.686411583134, 0.018107538790 },
    { 0.683368133641, 0.662696338470, -0.306335693157 },
    { 0.481321943069, -0.798406140561, -0.361769017241 },
    { -0.526082522833, 0.454621622713, -0.718718553630 },
    { 0.785084447125, -0.492294536535, 0.375883625848 },
    { -0.257012945715, -0.277168241049, -0.925808895987 },
    { -0.239221494300, -0.846887899013, 0.474925218504 },
    { -0.825154631450, -0.536690669340, -0.176303600759 },
    { -0.421445367795, 0.101321736974, -0.901175736236 },
    { 0.995567571899, 0.093633448800, -0.008831027679 },
    { 0.125253044233, -0.782487349007, -0.609938704752 },
    { 0.021240988482, -0.005969018981, -0.999756565980 },
    { -0.103117302198, 0.433304016839, 0.895329241664 },
    { 0.866254383931, 0.291274445288, -0.405909521744 },
    { -0.822849648954, -0.523784908060, 0.220381091079 },
    { -0.863654620224, -0.210864377303, 0.457861235911 },
    { -0.547146443056, -0.819859078258, -0.168706436299 },
    { -0.868831813452, -0.239851964020, -0.433130829300 },
    { -0.602102876500, -0.209897223438, 0.770334525841 },
    { 0.104232357260, -0.968421592298, -0.226484514417 },
    { 0.943719544859, -0.330704684108, 0.005275657369 },
    { -0.591308200839, -0.565096680951, 0.575343682331 },
    { -0.250552550948, -0.626357338936, -0.738173355774 },
    { -0.113667303871, 0.374232835918, -0.920342071489 },
    { 0.881579466045, 0.471591794556, -0.020465198619 },
    { -0.244398688743, -0.875875416924, -0.416066743406 },
    { 0.718918503570, -0.203844642438, 0.664532577812 },
    { 0.670960151892, 0.141321491479, -0.727901580311 },
    { 0.471994272429, -0.507669565057, 0.720758641647 },
    { -0.517875496916, 0.500573600820, 0.693708180618 },
    { 0.557687433168, 0.563867223595, 0.609129281057 },
    { 0.396580423871, -0.145485742210, -0.906398293366 },
    { 0.686627792175, 0.680947845587, 0.254661160373 },
    { 0.488416454981, 0.872052374429, -0.031209337640 },
    { -0.207019265652, -0.977779679277, 0.033013973439 },
    { -0.597733809603, -0.601074019843, -0.530494406687 },
    { -0.956887804971, 0.132167038367, 0.258645708773 },
    { 0.870797878961, 0.316714296544, 0.376036046625 },
    { 0.485790591401, -0.773385707862, 0.407286199350 },
    { -0.672899548530, 0.739459442281, -0.020147724683 },
    { -0.982022794308, -0.188390970995, 0.011835265418 },
    { 0.679311241870, 0.188080736966, 0.709339039565 },
    { 0.107220219457, -0.951692314937, 0.287724802943 },
    { 0.932020647728, -0.083300580088, 0.352701751578 },
    { 0.320581597509, 0.338475053952, 0.884681907349 },
    { -0.755996985614, 0.163875795573, 0.633729659530 },
    { -0.208076095053, 0.740356287486, 0.639200208267 },
    { 81, DUMMYVAL, DUMMYVAL },
    { 0.115246872918, 0.509156925344, -0.852922847424 },
    { -0.051040201801, -0.256148295583, 0.965289049182 },
    { 0.534928400819, 0.747376572480, 0.394055662191 },
    { 0.028736461161, 0.148889223858, -0.988436247220 },
    { -0.663732793355, 0.113273431318, 0.739342889857 },
    { -0.999026769963, 0.002708383999, -0.044024737964 },
    { -0.698444254231, 0.693793880686, 0.175572420540 },
    { -0.417630032986, -0.908300820357, 0.023974471555 },
    { 0.016528508924, 0.805518252855, -0.592340402733 },
    { 0.350473786518, -0.906592090322, 0.235072130907 },
    { 0.564569183288, 0.825383074175, -0.002101939031 },
    { 0.657932793353, -0.073470681732, -0.749484154840 },
    { 0.331740740493, 0.880358692135, -0.338993590323 },
    { -0.695179090871, 0.164222114892, -0.699826498924 },
    { 0.430884134481, 0.242572086487, -0.869193675489 },
    { -0.615831260039, 0.519666855498, -0.592197786601 },
    { 0.451762402688, -0.697726944869, 0.555956690688 },
    { -0.714624914836, -0.686778451496, -0.132840466936 },
    { 0.629075520841, -0.777219865969, -0.013902122929 },
    { 0.423284174510, -0.163398398108, 0.891140545091 },
    { 0.288038759329, -0.160462540421, -0.944079152532 },
    { -0.777111294573, -0.242888926413, 0.580605722735 },
    { 0.890975881941, -0.448969739598, -0.067735889491 },
    { 0.098152186641, -0.513298794711, -0.852578732790 },
    { 0.819783969747, 0.551471503358, 0.154380775776 },
    { -0.925399484291, 0.077535590375, 0.370977124227 },
    { -0.559040355687, -0.198409080177, -0.805051375763 },
    { -0.343077711058, -0.538327168942, -0.769741218432 },
    { 0.503775907880, -0.455624840801, -0.733904516327 },
    { 0.205160592311, 0.976382440395, 0.067723418785 },
    { -0.010896307736, 0.440484492349, 0.897694091814 },
    { 0.129851145116, 0.092056178795, 0.987250900257 },
    { -0.372544871397, 0.809051064433, -0.454584088960 },
    { -0.447966790518, -0.792724949715, -0.413416144694 },
    { -0.101036308868, -0.964796606196, -0.242815100362 },
    { 0.940648749138, 0.187253732805, 0.283047646688 },
    { -0.183480616270, 0.952614246274, 0.242612780473 },
    { -0.754692646682, 0.430834084405, 0.494793897253 },
    { -0.071545111583, 0.974279499285, -0.213683771686 },
    { -0.118237693070, 0.737408433842, 0.665017781444 },
    { 0.631341343906, -0.672960115123, -0.385399521183 },
    { -0.917125416825, -0.331514067489, 0.221312884556 },
    { -0.694022400184, -0.484285189355, -0.532729540587 },
    { 0.292924588527, -0.776239060848, -0.558254517089 },
    { -0.921697618704, 0.379465285622, 0.080495942028 },
    { -0.458680512164, 0.755419309314, 0.467925052627 },
    { -0.087113590724, -0.792463715322, -0.603665869674 },
    { 0.324287776520, 0.601612742431, 0.729999689140 },
    { 0.287666814647, -0.939527947704, -0.185836054719 },
    { -0.273420935042, 0.542023331544, -0.794639352375 },
    { -0.161621873082, -0.214070842237, -0.963354578878 },
    { 0.930195594808, 0.333402073289, -0.153555243889 },
    { -0.432776382840, 0.464542695645, 0.772596069352 },
    { 0.996643379226, -0.068624095039, -0.044639760579 },
    { -0.729452580584, 0.644835426498, -0.228224024617 },
    { -0.183861907417, -0.599771578974, 0.778761100759 },
    { 0.169059720232, 0.877469523314, 0.448849692714 },
    { -0.898303097768, 0.284281450048, -0.335015823057 },
    { 0.917113414447, -0.220337562443, 0.332196242632 },
    { 0.435536815235, 0.631383130303, -0.641609714190 },
    { -0.699165706456, -0.664184921205, 0.264623705213 },
    { -0.359824682092, 0.171122908389, -0.917193081298 },
    { 0.725691781664, 0.340887831438, -0.597634440442 },
    { -0.872787656105, -0.109626262668, -0.475629887500 },
    { -0.449652161731, -0.244929468206, 0.858965941732 },
    { 0.763278025119, 0.026767694707, 0.645515411815 },
    { 0.662875000567, -0.365242377741, 0.653601361018 },
    { 0.471565363809, 0.253038249228, 0.844747152753 },
    { 0.823895700036, -0.338367803361, -0.454646131746 },
    { 0.708446492948, 0.631554512994, -0.315027719013 },
    { -0.913541496537, -0.366285027872, -0.176853647011 },
    { 0.713765288835, 0.425183796813, 0.556558937923 },
    { -0.028426364643, -0.986836413636, 0.159203751572 },
    { -0.291878199753, 0.119448904740, 0.948967373341 },
    { 0.750226488650, -0.585954924510, 0.306295677688 },
    { -0.550370578756, -0.563810672289, 0.615800090819 },
    { -0.439115319500, 0.896950968639, -0.051543147344 },
    { 0.230187520263, -0.513657511617, 0.826540783189 },
    { -0.328991422510, -0.844765165972, 0.422062149778 },
    { 0.905258004380, 0.037958608671, -0.423163194920 },
    { 0.060689553037, -0.831067586718, 0.552850291180 },
    { 82, DUMMYVAL, DUMMYVAL },
    { 0.388379135812, -0.583943361027, 0.712861696249 },
    { 0.055354725235, 0.336823320033, 0.939939309464 },
    { -0.627279433897, -0.266886181089, -0.731636711868 },
    { -0.718077406888, 0.504559568973, -0.479358403572 },
    { 0.170530743927, -0.113798121257, -0.978759037237 },
    { 0.934724422054, 0.160600293095, 0.317013880884 },
    { -0.890122395485, -0.063346359141, 0.451297418383 },
    { -0.404919379713, -0.675980939479, 0.615702903513 },
    { -0.750737638040, 0.284449441988, 0.596222704853 },
    { -0.606108478728, -0.739299760908, 0.293374122129 },
    { 0.458830257771, -0.331009407549, -0.824565077279 },
    { 0.562536892209, 0.723197370174, 0.400671696875 },
    { 0.202001522078, -0.026029250841, 0.979039255178 },
    { 0.332265064949, -0.888733108467, -0.315837598346 },
    { -0.686774442774, -0.385847455085, 0.616005362117 },
    { -0.176208755603, -0.911453060703, 0.371757706825 },
    { -0.202550947566, -0.025504985771, 0.978939533036 },
    { 0.542972947425, 0.729593967455, -0.415780015175 },
    { 0.511724938606, -0.858566352536, 0.031644991738 },
    { 0.241716988482, -0.868483937860, 0.432791574731 },
    { -0.478855651462, 0.871973186613, 0.101784217294 },
    { 0.009387665337, -0.793134398303, -0.608974299924 },
    { 0.507399107974, -0.232624673815, 0.829717967962 },
    { -0.172608239760, 0.954107702243, -0.244713890264 },
    { 0.600391399294, -0.701723901918, 0.383554081103 },
    { 0.622522911215, 0.019979108775, -0.782346509052 },
    { 0.089912814895, 0.827931014130, -0.553575578904 },
    { -0.465846180972, 0.058293244424, -0.882943505174 },
    { -0.100304969209, 0.640504618404, 0.761375562357 },
    { 0.758349778797, -0.338100800714, -0.557309125670 },
    { -0.863115789184, -0.432726857844, 0.260343236827 },
    { -0.313203633754, 0.745845185082, -0.587893224738 },
    { 0.765056689208, -0.380982519094, 0.519172979308 },
    { -0.399087396115, -0.818341974269, -0.413576671745 },
    { 0.938642870226, -0.278630791788, -0.203259548464 },
    { -0.547508163071, 0.792447284233, -0.268816132482 },
    { 0.885582401142, 0.055557688395, -0.461147648858 },
    { -0.495893370324, 0.592233632677, 0.635097700826 },
    { -0.996681946576, -0.070768504206, 0.040210896319 },
    { 0.140483728401, 0.849965034176, 0.507763490941 },
    { -0.446497249969, 0.433770950494, -0.782612910881 },
    { 0.251089315253, 0.943483400929, -0.216317424025 },
    { 0.483829367742, 0.221072110457, 0.846779938879 },
    { 0.713086552703, 0.410749458758, 0.568148264525 },
    { -0.341050366133, -0.939817937659, 0.020661360412 },
    { 0.340000541361, 0.583286137691, 0.737683477822 },
    { -0.336620389174, -0.375587266354, 0.863493438855 },
    { -0.066147490110, 0.989611605330, 0.127645525372 },
    { -0.766380208868, 0.143989447140, -0.626041863270 },
    { 0.850049674167, 0.503769674007, 0.153725947709 },
    { -0.818881615488, 0.569964667037, -0.067625277415 },
    { 0.772169302752, -0.001478696414, 0.635415125209 },
    { 0.989069786342, 0.124419798926, -0.079124404456 },
    { -0.039561894334, 0.541288710495, -0.839905583031 },
    { 0.072671187352, -0.388058074226, 0.918765383304 },
    { -0.018425873564, -0.705292287427, 0.708677131336 },
    { 0.697895750890, -0.649376790454, -0.302078309233 },
    { -0.714118669818, 0.625596933719, 0.314106672866 },
    { 0.122736851169, -0.989196264418, 0.080164928909 },
    { 0.426448734840, -0.659864705400, -0.618643715818 },
    { -0.100201426701, 0.182831062767, -0.978024783211 },
    { -0.340000601037, -0.583286057245, -0.737683513926 },
    { 0.081492602492, -0.507913494503, -0.857544656470 },
    { -0.899906611123, -0.152373064348, -0.408595815590 },
    { 0.683955170168, 0.381010655300, -0.622122339856 },
    { -0.376591820948, 0.308468021257, 0.873513640567 },
    { 0.848499000816, 0.460277845719, -0.261139331306 },
    { -0.694274249604, -0.543340466977, -0.471979240309 },
    { 0.636666084261, 0.770248564883, -0.037060024936 },
    { 0.954711569793, -0.212849249824, 0.207896645843 },
    { -0.275489365253, 0.853555485870, 0.442208821908 },
    { 0.325488378987, 0.930961765853, 0.165431271723 },
    { -0.897661356919, -0.421824613832, -0.127546397282 },
    { 0.821700987463, -0.565127920075, 0.073742261651 },
    { 0.319907412720, 0.248309123240, -0.914331354927 },
    { 0.352036404054, 0.585257515154, -0.730440970358 },
    { -0.061643844092, -0.963225649225, -0.261527025678 },
    { -0.934102851707, 0.286419390881, 0.213109819014 },
    { -0.945637610530, 0.224364767527, -0.235435682605 },
    { -0.225225877763, -0.252695016265, -0.940966807460 },
    { -0.667210940871, -0.738278603203, -0.098864879683 },
    { -0.600757146832, -0.035265893583, 0.798653346127 },
    { 83, DUMMYVAL, DUMMYVAL },
    { 0.300443179830, 0.800609590698, 0.518418922278 },
    { 0.001140309214, 0.963633772370, -0.267223974305 },
    { 0.378139673242, -0.916698763473, -0.129126931999 },
    { -0.473086960367, -0.809836055756, 0.346921159238 },
    { -0.368909760672, 0.637896436330, 0.676013110079 },
    { 0.570951465852, 0.140441968892, 0.808882239276 },
    { -0.096508139991, -0.915779737944, 0.389914927242 },
    { 0.890529365324, 0.358841212385, -0.279625524209 },
    { 0.729752775322, -0.195810000330, 0.655072004196 },
    { 0.824082677625, -0.439563401590, 0.357311847580 },
    { -0.068018265137, -0.037985589603, 0.996960686582 },
    { 0.275733635312, -0.222214742902, -0.935196006404 },
    { -0.039214055189, 0.042381702811, -0.998331632847 },
    { -0.445106875905, -0.795935301869, -0.410325315160 },
    { 0.267282601758, 0.812462590630, -0.518135647899 },
    { 0.842346043977, -0.337069459954, -0.420520298395 },
    { -0.643577292284, 0.765086331475, -0.021240862650 },
    { -0.998615596849, 0.042429929164, 0.031090044089 },
    { 0.726292383261, 0.559495480469, 0.399329665004 },
    { -0.708439498058, 0.240690272092, -0.663461883240 },
    { -0.894320089165, 0.446349797685, 0.031039269032 },
    { -0.735670943570, 0.561698277965, 0.378527815778 },
    { -0.256122959135, -0.680665209426, 0.686364263698 },
    { 0.047363242445, 0.633746817237, 0.772089175489 },
    { 0.033554497070, -0.438848951422, 0.897934125402 },
    { 0.763026180617, 0.645494197498, -0.033590008772 },
    { 0.317139581095, -0.903029865726, 0.289757739691 },
    { 0.422990644574, 0.890703818079, -0.166510129011 },
    { -0.635296827129, 0.335756661328, 0.695460570998 },
    { -0.737001401116, -0.096502971785, 0.668966449973 },
    { -0.915385620075, -0.214596023904, 0.340613730031 },
    { -0.771913732719, -0.575242523734, 0.270638556248 },
    { 0.957142362035, -0.083604431857, 0.277288293607 },
    { -0.422449754050, -0.110652001058, -0.899606769631 },
    { -0.459295868739, 0.822241374542, 0.336104785670 },
    { -0.088369866998, 0.885388517644, 0.456374779574 },
    { 0.314623895359, -0.116400402541, 0.942052414018 },
    { 0.024111122562, -0.999427519073, 0.023733686805 },
    { 0.562994274876, -0.488006553390, -0.666998538458 },
    { -0.478715143699, -0.498539167208, -0.722696692917 },
    { 0.867169444314, 0.036630314501, -0.496664247665 },
    { 0.941480325776, 0.310151663782, 0.131987657112 },
    { -0.358005367527, -0.332750648541, 0.872415705222 },
    { 0.992777179229, -0.029765756777, -0.116221650846 },
    { 0.481011218132, 0.510426419407, 0.712806480331 },
    { 0.161480306316, -0.738465211425, 0.654670330920 },
    { -0.928074277884, -0.126014422015, -0.350426169363 },
    { 0.513555074337, 0.831770254822, 0.210759172554 },
    { 0.306320999048, -0.810393733885, -0.499429115714 },
    { 0.668861180782, -0.736803584046, 0.098717776413 },
    { -0.143730104266, -0.723768862172, -0.674907616847 },
    { 0.622338967603, -0.104242980610, -0.775775489685 },
    { 0.906255313158, -0.421217455395, -0.035737412380 },
    { -0.683008876470, -0.725672232996, -0.083058322416 },
    { -0.212771620861, 0.354795702697, 0.910411031735 },
    { -0.355298979955, -0.934520657338, -0.020827286244 },
    { 0.197746451481, 0.291444763571, 0.935925365995 },
    { 0.665164200861, -0.680112936479, -0.308225533542 },
    { -0.125380600216, -0.369260466655, -0.920829198524 },
    { 0.199856200958, -0.578473593027, -0.790838669458 },
    { -0.910743031199, 0.257080312519, -0.323197840399 },
    { -0.101055371317, 0.757084462079, -0.645454048873 },
    { 0.634395766573, 0.638626458909, -0.435543634250 },
    { 0.337315298705, 0.542337857512, -0.769472571030 },
    { -0.024678651332, 0.450487017662, -0.892441825043 },
    { 0.135187367811, 0.981907492132, 0.132597332099 },
    { 0.659617083709, 0.317504020755, -0.681246284161 },
    { -0.621735009154, -0.481439772150, 0.617787442559 },
    { -0.262077628890, 0.964508259706, 0.032235592053 },
    { -0.716694066738, 0.589923468106, -0.371940743239 },
    { -0.924920169831, -0.376791605602, -0.050505102586 },
    { -0.752363001210, -0.505773890688, -0.422069527339 },
    { -0.389466306252, 0.852240556953, -0.349287888966 },
    { -0.050546054927, -0.934202488735, -0.353144172220 },
    { -0.452828722465, 0.045781466804, 0.890421363967 },
    { -0.374758349945, 0.272688011069, -0.886113665263 },
    { 0.338365371475, 0.178493587899, -0.923931228212 },
    { -0.724581472578, -0.157416194429, -0.670970812576 },
    { 0.550378529468, -0.669310617768, 0.499105971957 },
    { -0.896200213225, 0.193613426464, 0.399172918555 },
    { 0.827756717775, 0.202001789406, 0.523463554849 },
    { 0.441195624025, -0.439317832547, 0.782525567216 },
    { -0.453075743448, 0.586974887778, -0.670956669105 },
    { 84, DUMMYVAL, DUMMYVAL },
    { -0.615230569124, 0.290575435512, -0.732841908663 },
    { -0.211042755660, 0.545683604034, 0.810981109257 },
    { 0.953151468261, 0.154203421251, 0.260237551913 },
    { 0.316038362621, 0.008276240826, -0.948710312577 },
    { -0.091778087791, -0.586142923130, 0.804992705722 },
    { 0.642800332632, -0.386550340467, -0.661352074657 },
    { -0.567116500811, -0.816730617937, 0.106442342292 },
    { 0.174865665643, 0.892547657509, -0.415668952479 },
    { 0.742454186166, 0.444637072443, 0.501058534758 },
    { 0.059460055001, 0.292850288482, -0.954307712635 },
    { 0.200588266264, -0.970578013264, 0.133201605117 },
    { -0.350195736049, -0.769649460224, 0.533856399072 },
    { -0.408824017150, -0.875932229956, -0.256136002010 },
    { -0.023202706030, -0.579633224569, -0.814547088515 },
    { 0.638473703955, -0.352407757673, 0.684222260446 },
    { 0.714778288453, -0.585214000099, 0.382905435380 },
    { 0.417327815881, -0.808401117624, 0.415120617552 },
    { 0.508527137455, 0.319980828623, 0.799382524068 },
    { -0.981635431074, 0.122154811706, -0.146526729429 },
    { 0.950136706201, 0.257489979113, -0.175895281876 },
    { 0.184073200246, -0.303897156808, 0.934753216114 },
    { -0.480102566863, -0.438679980656, 0.759645575162 },
    { -0.735630087057, 0.542592383783, 0.405514340161 },
    { -0.607948113487, 0.760412318211, -0.228412341217 },
    { -0.804320945690, -0.257420362145, 0.535539516262 },
    { 0.904683971519, -0.238771919898, 0.352895001304 },
    { -0.970622938535, -0.151069786997, 0.187267270622 },
    { -0.933304129269, -0.276031641446, -0.229673540509 },
    { -0.842483530879, 0.538705089998, -0.004280912094 },
    { 0.128303499645, 0.107541647659, 0.985886913392 },
    { -0.415912808983, -0.682085963396, -0.601477575528 },
    { 0.470365228993, 0.874259154439, -0.120114454721 },
    { -0.405698132869, 0.743605776209, 0.531469166158 },
    { -0.176970160021, 0.949494018551, 0.259119029014 },
    { -0.523919056950, 0.633594098788, -0.569269127694 },
    { -0.062398594788, -0.985323791184, -0.158881848852 },
    { -0.816537328761, 0.129621530663, 0.562552263819 },
    { 0.328953600504, -0.597970702804, 0.730903938492 },
    { 0.489355432488, 0.687281796042, -0.536819330430 },
    { 0.090719182637, 0.994556009477, -0.051267669300 },
    { -0.357749995200, -0.381228996080, -0.852454921672 },
    { 0.415912713509, 0.682085892690, 0.601477721728 },
    { 0.309049137433, -0.908649394492, -0.280793355587 },
    { 0.753618093076, 0.360233921480, -0.549810232356 },
    { 0.445175489949, 0.381400513978, -0.810155806673 },
    { 0.160830422356, 0.482817974385, 0.860825405559 },
    { -0.044686027089, -0.846653824255, -0.530264519705 },
    { -0.297873773546, 0.111372161149, -0.948086207449 },
    { -0.563332051563, 0.376859696928, 0.735278021236 },
    { -0.252022217032, 0.184383697812, 0.949993396873 },
    { -0.826212536554, 0.407133109403, -0.389378319465 },
    { -0.248520199283, 0.510003968088, -0.823488714606 },
    { 0.479303996617, -0.059733459520, 0.875613837625 },
    { 0.017378662450, 0.801468918876, 0.597783869109 },
    { 0.317933218436, -0.372636353597, -0.871814554015 },
    { 0.854519001157, -0.518967251675, 0.021685671533 },
    { 0.130219709305, 0.649186075596, -0.749399937657 },
    { -0.855554144827, -0.509047581934, 0.094327432893 },
    { 0.889045392186, -0.010710039579, -0.457693768457 },
    { -0.716449712417, -0.401588724551, -0.570461485020 },
    { -0.550604815573, 0.819452361246, 0.159160814010 },
    { -0.563586568692, -0.048586960397, 0.824626877363 },
    { 0.338886600686, -0.698797401937, -0.629950841671 },
    { -0.944435574195, 0.240435372424, 0.224125585067 },
    { -0.216341381657, -0.954671492285, 0.204447422095 },
    { -0.039225038990, -0.177653597718, -0.983311037024 },
    { -0.676666586362, -0.599697484822, 0.427182932242 },
    { 0.784108546407, 0.046196943869, 0.618901954940 },
    { 0.866244981575, -0.368665591862, -0.337202184562 },
    { 0.638018970079, -0.685676702394, -0.350398706638 },
    { 0.744750746010, 0.623678161363, -0.237427625513 },
    { -0.858162522035, 0.008117907659, -0.513313924758 },
    { -0.188732032101, 0.827930301428, -0.528120853628 },
    { 0.576552697922, -0.816568692557, 0.028329434438 },
    { 0.599442974242, 0.764010664541, 0.238654195648 },
    { -0.275197415057, 0.948170831328, -0.158866161798 },
    { 0.647941918469, 0.000962696101, -0.761689138367 },
    { -0.597731382437, -0.097272027363, -0.795773427014 },
    { -0.198691072490, -0.210599653814, 0.957167510693 },
    { 0.991869370710, -0.122366656702, -0.034950719245 },
    { 0.039893427754, -0.852146685503, 0.521780165211 },
    { 0.853390538138, 0.507750244747, 0.117958799487 },
    { -0.721232805544, -0.641221314723, -0.262027604943 },
    { 0.248906518744, 0.922190475425, 0.295990324101 },
    { 85, DUMMYVAL, DUMMYVAL },
    { 0.752591299074, 0.175398229307, 0.634698194195 },
    { 0.197265402326, -0.689325292198, 0.697077472439 },
    { 0.034103256950, -0.713282507110, -0.700046450541 },
    { 0.652715697414, -0.724827713106, -0.220424600856 },
    { 0.641062874070, -0.191382438116, -0.743243670588 },
    { -0.003493167630, 0.864192966030, -0.503148402803 },
    { -0.873807549946, 0.159990856851, 0.459198531555 },
    { 0.938623697776, 0.254474008041, -0.232870206780 },
    { 0.229638269814, -0.172642441394, -0.957841767969 },
    { -0.816370325039, 0.574300379585, -0.060980049237 },
    { 0.349753813223, -0.872084742852, 0.342257901912 },
    { 0.583026818395, -0.601767232701, 0.545853393027 },
    { 0.367527833266, -0.928340230222, -0.055746827057 },
    { -0.323510399413, 0.696369706605, -0.640632697569 },
    { 0.717751918506, -0.241130295328, 0.653213873212 },
    { -0.880139421407, 0.317905385098, -0.352548954064 },
    { -0.496727993049, -0.363177730040, 0.788265968646 },
    { -0.293062551927, 0.924228602129, -0.244777106088 },
    { -0.459921221371, 0.781943057453, 0.420758273874 },
    { -0.341625752312, -0.933704878543, -0.107177633592 },
    { 0.931631384265, 0.306541127116, 0.195180688693 },
    { -0.609976489884, 0.705339205217, -0.361144413459 },
    { 0.900019162246, -0.135881764316, -0.414127581449 },
    { -0.027233447662, -0.892454898046, 0.450313884177 },
    { 0.382942551416, -0.775220402819, -0.502382652336 },
    { -0.267954530632, -0.092311749941, 0.958998910498 },
    { 0.869188927757, -0.405504104681, 0.282978848947 },
    { 0.375820260848, 0.782619086653, -0.496252452632 },
    { -0.620980562876, 0.415263110693, 0.664785446161 },
    { 0.099945684340, 0.609363133208, -0.786566864335 },
    { -0.804243071969, -0.225398008332, 0.549898917102 },
    { 0.130212185871, 0.250309501570, -0.959369553444 },
    { -0.388148021894, -0.874447793868, 0.291002008410 },
    { -0.489083359033, -0.243066254884, -0.837685062332 },
    { 0.477677536665, 0.481653316472, -0.734734138105 },
    { 0.387187666845, -0.381890419136, 0.839193314091 },
    { 0.702887708863, -0.487507168872, -0.517962961058 },
    { 0.362109239175, 0.744577226511, 0.560786637381 },
    { -0.263519364836, -0.842020848734, -0.470699941209 },
    { 0.475434807142, 0.025784555520, 0.879373015764 },
    { 0.677128144188, -0.716731610311, 0.166713152240 },
    { -0.979613366671, -0.120011767535, 0.161105020073 },
    { 0.119997969441, 0.981139889192, -0.151542090411 },
    { -0.966757292911, -0.061617346609, -0.248160510963 },
    { 0.107633848948, 0.247484985423, 0.962894665346 },
    { -0.069523691793, -0.455227206121, 0.887656829573 },
    { -0.235019747246, 0.403314079923, -0.884366140996 },
    { -0.407518635558, -0.581616244297, -0.704024932828 },
    { 0.228685066351, 0.948361903764, 0.219801819642 },
    { -0.854973682381, -0.466937890290, 0.225807460122 },
    { 0.362869766026, -0.493830305831, -0.790226019533 },
    { 0.776755109816, 0.200114947751, -0.597164556099 },
    { -0.967802862055, 0.243841758165, 0.062440509079 },
    { 0.929283448933, -0.038020779819, 0.367405350861 },
    { -0.634481698394, 0.429180222879, -0.642835368266 },
    { -0.179867627662, 0.972587650287, 0.147380117483 },
    { -0.886005879883, -0.431075697633, -0.170784436419 },
    { -0.667075144557, -0.744108860102, 0.036231972511 },
    { -0.293779442241, 0.622548853527, 0.725345823927 },
    { -0.794382712893, 0.013987662152, -0.607256495037 },
    { 0.721469879425, 0.515113519078, 0.462751850936 },
    { -0.274895699740, -0.689790023895, 0.669792562813 },
    { -0.755220088351, -0.364305929126, -0.544907155537 },
    { 0.715210097094, 0.564134645592, -0.412585286526 },
    { -0.620381430082, -0.612910445842, 0.489354336435 },
    { 0.584506192768, 0.778555617610, 0.228481204707 },
    { 0.481775061791, 0.123674804863, -0.867523678339 },
    { 0.120716231505, -0.129901484905, 0.984151002474 },
    { -0.156792575272, -0.024977142215, -0.987315669230 },
    { 0.894074013926, -0.430641663882, -0.123204768376 },
    { 0.456307208595, 0.419705255162, 0.784621711510 },
    { 0.082474962607, 0.592684532047, 0.801200927368 },
    { 0.807709426776, 0.588771070912, -0.030888637944 },
    { -0.089002527858, -0.412198713664, -0.906736329088 },
    { -0.043478153454, 0.861318270502, 0.506202021994 },
    { -0.625042312178, -0.694144106404, -0.357051911536 },
    { -0.505785172657, 0.134424847413, -0.852121657698 },
    { 0.501819478351, 0.852847071314, -0.144322846764 },
    { -0.286495076262, 0.286846597384, 0.914133251144 },
    { -0.617027660335, 0.041325712790, 0.785855617683 },
    { 0.074344553830, -0.944386862136, -0.320322247027 },
    { 0.997466222871, -0.068976641227, -0.017417152371 },
    { -0.550302855753, 0.833383810517, 0.051363326596 },
    { -0.774922423842, 0.540235699781, 0.328086308323 },
    { -0.003209599128, -0.996882383561, 0.078836614715 },
    { 86, DUMMYVAL, DUMMYVAL },
    { -0.866205000983, 0.471519106870, 0.165404438055 },
    { 0.384540291625, 0.645196721958, 0.660189332005 },
    { 0.828613396824, -0.288428618085, 0.479800761642 },
    { -0.482983754198, -0.111770489433, 0.868466493811 },
    { 0.408891213702, -0.896653176941, -0.169767651923 },
    { 0.923401228416, -0.374667002828, 0.083395493597 },
    { -0.021003422614, -0.907905222600, 0.418648973501 },
    { 0.233506693836, 0.896641470668, -0.376176417406 },
    { 0.872684735027, 0.054410805650, -0.485243049903 },
    { -0.641298223678, 0.161407720413, -0.750122747355 },
    { 0.016847869092, 0.999092641397, 0.039115766817 },
    { -0.227379169925, 0.906043423643, 0.356908990581 },
    { 0.314725364539, -0.761627740272, 0.566454879195 },
    { -0.368803626075, -0.906127328333, 0.207164548710 },
    { -0.873433858343, -0.486534652480, -0.019933063904 },
    { -0.375253677473, -0.506417781650, -0.776354112485 },
    { 0.724634368192, -0.686097909519, -0.064611848678 },
    { -0.673844265053, -0.239487443419, -0.698984742966 },
    { -0.153565115493, 0.119223118339, 0.980919774170 },
    { -0.288904456220, -0.944633590220, -0.155568619601 },
    { 0.364207799570, -0.489216788344, -0.792476884669 },
    { -0.421775260893, 0.548055778031, -0.722316062029 },
    { 0.689824137217, -0.292838551560, -0.662108935473 },
    { -0.609894647355, 0.744243568574, 0.272268304737 },
    { -0.002938775640, 0.479857914112, -0.877341293832 },
    { -0.744353928687, 0.456679525448, -0.487217651451 },
    { 0.663740206228, 0.433183959287, -0.609754537542 },
    { 0.054954809384, -0.997343979308, 0.047801211941 },
    { -0.382629816653, -0.741645848371, 0.550959035685 },
    { -0.407008074307, 0.913352242009, -0.011493888232 },
    { 0.342408909490, 0.308907590462, -0.887317439960 },
    { -0.953437915722, 0.112963775393, 0.279634272423 },
    { 0.194165329549, 0.908239372165, 0.370676499999 },
    { 0.350108840342, -0.134304738182, -0.927030763900 },
    { 0.628832237964, 0.079791769313, -0.773436028413 },
    { 0.040805190555, -0.930812355929, -0.363212464644 },
    { -0.306685516987, 0.240871901473, -0.920828279730 },
    { -0.354339128073, -0.142039771311, -0.924266458162 },
    { -0.072592176892, -0.254874326348, 0.964245535962 },
    { 0.529927167791, 0.289509382714, 0.797095674407 },
    { 0.338819343755, -0.770599712857, -0.539793974440 },
    { -0.008266640371, -0.687152407448, -0.726466263219 },
    { -0.326280782312, -0.797307614325, -0.507780877183 },
    { -0.906442846718, -0.283273886299, 0.313236765044 },
    { 0.026768725858, 0.058591600456, -0.997923073023 },
    { -0.528806293570, 0.265841936239, 0.806034719362 },
    { 0.583184980641, -0.119091984604, 0.803562304715 },
    { 0.593379676787, 0.722302296879, -0.355218173942 },
    { 0.743561856489, 0.668662417136, 0.002517435945 },
    { 0.248000293168, 0.015513062051, 0.968635741388 },
    { 0.401741207688, 0.915423346893, -0.024578405330 },
    { 0.811263643585, 0.117185394928, 0.572816623198 },
    { -0.630016739896, -0.768344894448, -0.112805277481 },
    { -0.651782608584, -0.598387924904, -0.465952060277 },
    { 0.919740098505, 0.362047375234, 0.151657011998 },
    { -0.007525425820, 0.748478818500, 0.663115997562 },
    { -0.749854748338, 0.399829263268, 0.527118977679 },
    { -0.351932539096, -0.468105624529, 0.810568079935 },
    { 0.875631885001, 0.401849796525, -0.267928242265 },
    { 0.399888280561, -0.890891784475, 0.215409357794 },
    { 0.563875579363, -0.495306684905, 0.660844625375 },
    { 0.735472688357, 0.481023993667, 0.477174854950 },
    { 0.897735713139, -0.321592108762, -0.301079897928 },
    { 0.551664529517, 0.771390390006, 0.317211464292 },
    { -0.690573297839, -0.661369164032, 0.292744511783 },
    { -0.207927048404, 0.480801951884, 0.851819127284 },
    { 0.969030145668, -0.009149989065, 0.246772880370 },
    { -0.994992736592, -0.083469051420, -0.054976100118 },
    { 0.662800967065, -0.609219432892, -0.435369453045 },
    { 0.327144580999, 0.656430523717, -0.679761274754 },
    { 0.268369596020, -0.397886535579, 0.877305000976 },
    { 0.167318695289, 0.404310411788, 0.899187158008 },
    { -0.011877264432, -0.657889226989, 0.753021045922 },
    { -0.440791373746, 0.661576101932, 0.606646541392 },
    { 0.991798332885, 0.032462290923, -0.123621464778 },
    { -0.473721596500, 0.775380198812, -0.417580406987 },
    { -0.080991627955, 0.765319322285, -0.638534800256 },
    { -0.878385988238, -0.313208185778, -0.361024497823 },
    { 0.692466310705, -0.647850557025, 0.317458760001 },
    { -0.009349876606, -0.350187547730, -0.936632938361 },
    { -0.940921471985, 0.296794412477, -0.163033310339 },
    { -0.785875145902, -0.013123494266, 0.618245929183 },
    { -0.884245699076, 0.059504094361, -0.463215723415 },
    { -0.680833653450, -0.409212628436, 0.607462394769 },
    { -0.142481357672, 0.943025732941, -0.300668471455 },
    { -0.725068523019, 0.674230569178, -0.140316700763 },
    { 87, DUMMYVAL, DUMMYVAL },
    { -0.126204671951, -0.866855514593, 0.482321363405 },
    { -0.816176819480, 0.309965688586, 0.487623493326 },
    { -0.131228088294, -0.971596636396, -0.196924262058 },
    { -0.085567602394, -0.237225948126, -0.967678683735 },
    { -0.773792309783, 0.421435021053, -0.472903779167 },
    { -0.131104487098, 0.820683711303, -0.556138345616 },
    { -0.895758346856, 0.431491887276, -0.106919293178 },
    { -0.464572573753, 0.874218263646, 0.141119634439 },
    { 0.378561159600, -0.692363878268, -0.614266805641 },
    { -0.629833411852, -0.364579346315, 0.685851130753 },
    { 0.898784767045, -0.334877376920, 0.282918866381 },
    { 0.927739821346, 0.055961373303, 0.369008331325 },
    { -0.365689636491, -0.473882702279, -0.801065711564 },
    { 0.885722792832, -0.407817768001, -0.221765196457 },
    { -0.441425563333, -0.053758561894, -0.895686043801 },
    { -0.315246222265, 0.919300838382, -0.235596663596 },
    { -0.194688100736, 0.873231080169, 0.446725893652 },
    { 0.871172579683, -0.128895696979, -0.473755459820 },
    { 0.994906537195, -0.100776636307, -0.002247625620 },
    { 0.470762174487, 0.249814003081, -0.846153614267 },
    { -0.221165587968, 0.618269077622, 0.754207617540 },
    { 0.053112437498, 0.014830421520, 0.998478406166 },
    { 0.096534753546, -0.985296645263, 0.140966528621 },
    { 0.156340626654, 0.448237305479, -0.880136879374 },
    { -0.490151051087, -0.704231649536, 0.513624114416 },
    { 0.008876420780, -0.591679950276, -0.806124088212 },
    { 0.393960335130, 0.199176367732, 0.897287038177 },
    { 0.737687705278, -0.252438539767, 0.626172207242 },
    { -0.971919301299, 0.165451189216, 0.167328347118 },
    { 0.553132780408, 0.558768724032, -0.617917179144 },
    { 0.288884019896, -0.930375859191, -0.225713942157 },
    { 0.714109135930, 0.136057852944, 0.686685082576 },
    { -0.672367216091, -0.283203011626, -0.683899393867 },
    { -0.540181866759, 0.683366427656, 0.491135293353 },
    { -0.660176657480, -0.594870788150, -0.458579901789 },
    { -0.784383862341, 0.068653458600, -0.616464645476 },
    { 0.720466538959, 0.690422089299, 0.065156003930 },
    { 0.619548149391, -0.728099497543, -0.293310777614 },
    { 0.648145814381, -0.626403232091, 0.433042716283 },
    { -0.635925429903, 0.014539977932, 0.771613528034 },
    { -0.975641435484, -0.209816289585, 0.064038379055 },
    { 0.782026991666, 0.447426021914, 0.433870648028 },
    { 0.504582588684, 0.805196460052, -0.311536630135 },
    { 0.162793399928, 0.723898224034, 0.670424992210 },
    { 0.078445149296, 0.419297002292, 0.904453637519 },
    { 0.795497455198, 0.535723562181, -0.283167907251 },
    { -0.831400529798, -0.548473543259, -0.089162387797 },
    { 0.303526700739, -0.838305329124, 0.452897027040 },
    { 0.384487245443, 0.922661348361, 0.029420984559 },
    { -0.320761589856, -0.771574983718, -0.549348748041 },
    { 0.176190215197, 0.921520727130, 0.346058604197 },
    { 0.525109899463, 0.752843636349, 0.396845124317 },
    { -0.656940479945, 0.731640669633, -0.182019604297 },
    { 0.777907124910, -0.625470642673, 0.060390232402 },
    { -0.896345583823, -0.269328644676, -0.352174211886 },
    { 0.216915937157, -0.000649665757, -0.976190070704 },
    { -0.073119751963, 0.995496189915, 0.060339354804 },
    { -0.320773570615, -0.181457832772, 0.929611408773 },
    { -0.878068470777, -0.090524153577, 0.469894816151 },
    { 0.437455935926, -0.173360597411, 0.882370901259 },
    { -0.965594462484, 0.082354151499, -0.246668051743 },
    { 0.932801995534, 0.347648799577, 0.094977625161 },
    { -0.546277011313, 0.390118455201, 0.741207810146 },
    { 0.603592771367, -0.113460781014, -0.789178317952 },
    { -0.508790146807, -0.838578781721, -0.194725995595 },
    { -0.821221393216, -0.454324970490, 0.345230712009 },
    { 0.081270896108, -0.677314308235, 0.731191062108 },
    { 0.326752123760, -0.374358503675, -0.867806868114 },
    { 0.124676503688, 0.952715733101, -0.277107382310 },
    { -0.306225215190, -0.938822589594, 0.157601595328 },
    { 0.952729459834, 0.179813401726, -0.244895318297 },
    { -0.139203049540, 0.182028811769, -0.973389964343 },
    { -0.496610622485, 0.672138450210, -0.549188304123 },
    { -0.275026616523, 0.214540099234, 0.937194166662 },
    { 0.435242797301, -0.523613447433, 0.732388329416 },
    { 0.069967445067, -0.352665488466, 0.933130006953 },
    { 0.771849646302, 0.232953810195, -0.591591620815 },
    { 0.485375714765, -0.867953642140, 0.105199289979 },
    { -0.206677482012, 0.543763949706, -0.813391163850 },
    { -0.279439077092, -0.543126673047, 0.791787357324 },
    { -0.776374074232, 0.594446047457, 0.209468836637 },
    { 0.491120720573, 0.511739360628, 0.704927843547 },
    { -0.641223659115, -0.748520900695, 0.168963546998 },
    { 0.670694232799, -0.450483345356, -0.589265646077 },
    { -0.521354829107, 0.317730504100, -0.791982619084 },
    { 0.049095316364, -0.853526768039, -0.518730860998 },
    { 0.225488398112, 0.743195098645, -0.629933351766 },
    { 88, DUMMYVAL, DUMMYVAL },
    { -0.824298580801, -0.563946853579, 0.049957942591 },
    { -0.404654504581, -0.681612677245, -0.609638327323 },
    { -0.206043625467, -0.047469308112, -0.977390755630 },
    { -0.238620386951, 0.847731760299, 0.473720564797 },
    { 0.026096361188, 0.991120092952, -0.130383822920 },
    { -0.288629220826, 0.321031196621, -0.902015600576 },
    { 0.429964312551, -0.764695405840, 0.479970443068 },
    { 0.482319305838, -0.485508746705, 0.729142883178 },
    { -0.315414669487, -0.884989334943, 0.342501771251 },
    { 0.014650296461, -0.597113553877, -0.802022925227 },
    { 0.412241136531, -0.458759002911, -0.787145108986 },
    { 0.668013227941, -0.719849166599, 0.188614698905 },
    { 0.422566620628, 0.496502107668, 0.758236841767 },
    { -0.278185823173, 0.890566719953, -0.359866037711 },
    { 0.727351943566, 0.460829117959, -0.508523032154 },
    { 0.141554535094, 0.751534947986, 0.644327196035 },
    { 0.095606103780, 0.376092792571, 0.921636416542 },
    { -0.396062010351, -0.096065501063, 0.913184703914 },
    { 0.902385288240, -0.063483003188, 0.426228459719 },
    { -0.593239227320, 0.757052968179, 0.273748100523 },
    { 0.130748289842, -0.635329733723, 0.761091987969 },
    { 0.112519311445, 0.166029267488, -0.979680400380 },
    { 0.650422290594, -0.153091156700, 0.743985175685 },
    { -0.665908620243, 0.243175835421, 0.705288042259 },
    { 0.656438289859, -0.579063714338, -0.483501795595 },
    { -0.176141734576, 0.602610611672, 0.778353737089 },
    { -0.324076753118, 0.644309686335, -0.692704328111 },
    { 0.707566802435, 0.128467615424, -0.694870701555 },
    { 0.319509147102, -0.767766546336, -0.555381342184 },
    { 0.317684631388, 0.885078186358, -0.340166252019 },
    { -0.972060227144, 0.001359352866, -0.234727644228 },
    { 0.404842324158, 0.658438421177, -0.634477373977 },
    { -0.547000071157, -0.836229273563, 0.038878325449 },
    { 0.437817548153, 0.798659643828, 0.412866283257 },
    { -0.131652092531, -0.381089376948, 0.915116721140 },
    { 0.922618718766, -0.253491594983, -0.290717579544 },
    { -0.524103018163, 0.584243146432, 0.619657947742 },
    { 0.410274944382, 0.911067341979, 0.040382773450 },
    { -0.550133482568, -0.040381230089, -0.834099818735 },
    { -0.239161775144, -0.701388664564, 0.671457806963 },
    { -0.511651627000, -0.452386854203, 0.730451057041 },
    { -0.824218076756, 0.565427788818, -0.030918887141 },
    { -0.709836834534, -0.128556534547, 0.692535115185 },
    { -0.975529965185, -0.199806746471, 0.091752662577 },
    { -0.910760696052, 0.054446437509, 0.409329378337 },
    { 0.023019776519, 0.815721146127, -0.577987112010 },
    { -0.818624617236, -0.013190705370, -0.574177447613 },
    { -0.068274743732, -0.844236512057, -0.531604431018 },
    { 0.062983319827, -0.892544427650, 0.446539523553 },
    { 0.423854360003, 0.345088357823, -0.837413581692 },
    { -0.620542595039, -0.666880742856, 0.412549345594 },
    { 0.805496928223, -0.577978245708, -0.130827543400 },
    { -0.274587976193, 0.956554266238, 0.098007035833 },
    { -0.862635646707, 0.352458579497, -0.362812197659 },
    { 0.142252723642, -0.961733751781, -0.234163091246 },
    { -0.670204977463, -0.384428338452, -0.634854424871 },
    { -0.561080442344, 0.819604118152, -0.115921640466 },
    { 0.396997046039, 0.114339758585, 0.910669953959 },
    { 0.312858511418, -0.940069471846, 0.135605825596 },
    { -0.017617528543, 0.014870975671, 0.999734203061 },
    { 0.920042264989, 0.116573556895, -0.374075976865 },
    { 0.999665378402, 0.023565530779, 0.010667566935 },
    { -0.880359971447, -0.366784408886, -0.300724987441 },
    { -0.970967726511, 0.229868860293, 0.066196534213 },
    { -0.657971101826, -0.682746177909, -0.317697475144 },
    { -0.326935952262, 0.276806028605, 0.903599084576 },
    { 0.651014336431, 0.717508198175, -0.247714188759 },
    { -0.623030605848, 0.641390013092, -0.447718343697 },
    { 0.903427005269, 0.411295963065, -0.121058981148 },
    { 0.090601571187, 0.955860544292, 0.279503086143 },
    { -0.815701221658, 0.442967882901, 0.372036250523 },
    { 0.932079021326, -0.335870066131, 0.135720288394 },
    { 0.733148094859, -0.240544213107, -0.636107186365 },
    { 0.052523667553, 0.533740267173, -0.844015753138 },
    { -0.629177343831, 0.333571713207, -0.702044003007 },
    { 0.103185834295, -0.263833097730, -0.959033252887 },
    { 0.512350446580, -0.837018228358, -0.192087233531 },
    { -0.323833189733, -0.398895909359, -0.857912652153 },
    { 0.763902226846, -0.450064696562, 0.462488007118 },
    { 0.915606775365, 0.298787964207, 0.269053870725 },
    { 0.718335832623, 0.206663228379, 0.664292060471 },
    { -0.093335849573, -0.993751786577, 0.061202988977 },
    { 0.695784597297, 0.531618750339, 0.482975463613 },
    { 0.732262384659, 0.669107244457, 0.126835702499 },
    { 0.437502400113, -0.072969384794, -0.896251705035 },
    { -0.835706923470, -0.361207919247, 0.413669889088 },
    { 0.253382449370, -0.253034702674, 0.933686657072 },
    { -0.317496946047, -0.913881217517, -0.253015433364 },
    { 89, DUMMYVAL, DUMMYVAL },
    { 0.085732791801, 0.966837267085, -0.240573455280 },
    { 0.124952079023, -0.074516869390, 0.989360507663 },
    { -0.351440612992, -0.534317225962, -0.768761730044 },
    { -0.774712701099, 0.299019099190, 0.557142539281 },
    { -0.550252199330, -0.826327145302, -0.120024856051 },
    { 0.852133697732, 0.393635819505, 0.344846346642 },
    { 0.135408790044, 0.655780110090, -0.742709167029 },
    { -0.823257565001, -0.510551537986, -0.248161456977 },
    { -0.421349158266, 0.226860573207, -0.878065582489 },
    { -0.648517949781, 0.645496966102, 0.403432938125 },
    { -0.881180623677, 0.221495782215, -0.417684482495 },
    { 0.955466849316, -0.294237882757, 0.022520395418 },
    { -0.947891814113, 0.065404807332, 0.311806542452 },
    { -0.337857312802, 0.911531424287, 0.234441674460 },
    { -0.570224980719, -0.666204340768, -0.480640455752 },
    { -0.111021435522, -0.920464874674, 0.374724772794 },
    { 0.605951840214, 0.637362708488, 0.476015908525 },
    { 0.810529214877, 0.355763638123, -0.465268337222 },
    { 0.347803217626, 0.810271986279, -0.471690820411 },
    { -0.763661571308, -0.126377849297, 0.633126878054 },
    { 0.566504218791, 0.360700032340, 0.740924056002 },
    { 0.551417478755, -0.816361429199, 0.171734623881 },
    { -0.087123706242, -0.444936908807, 0.891313977783 },
    { 0.471099352758, -0.857405697422, -0.207173525962 },
    { 0.312373193052, -0.770768634348, -0.555282541206 },
    { -0.032716356906, -0.715263782349, -0.698088362351 },
    { -0.300026803071, 0.942019455398, -0.150277287339 },
    { -0.702793688429, 0.036317916915, -0.710466072670 },
    { -0.641799790245, -0.572933381324, 0.509745397043 },
    { 0.266528998109, -0.871523336546, 0.411593691671 },
    { 0.315329985817, -0.395541109878, 0.862620559946 },
    { -0.084408622383, 0.395347918173, -0.914644853516 },
    { 0.872917118021, -0.333480581644, -0.356098872129 },
    { 0.793973696582, 0.100713261283, 0.599552006199 },
    { -0.973054667713, -0.230460949337, -0.007236330075 },
    { -0.265100083678, -0.867538408653, -0.420831385646 },
    { 0.425823040827, 0.901803133551, -0.073660343590 },
    { -0.881243666843, -0.324634382892, 0.343543471912 },
    { -0.056569778786, 0.019313102476, -0.998211833330 },
    { 0.774179965247, -0.624982834695, -0.100208970388 },
    { 0.311579616994, -0.110552697819, -0.943767049265 },
    { 0.274956499508, 0.293302636728, -0.915626827188 },
    { -0.529748982985, 0.754051404580, -0.388294339743 },
    { 0.311866543163, -0.490639830367, -0.813641085561 },
    { 0.776216074451, -0.547762367080, 0.312161808962 },
    { -0.651042352777, 0.448452652797, -0.612400255625 },
    { -0.030464070377, -0.363150093733, -0.931232489681 },
    { -0.397001615454, -0.168448648025, -0.902227670993 },
    { 0.507353103051, -0.629758407451, 0.588215247225 },
    { -0.635268258121, 0.771930219592, 0.023621522081 },
    { -0.492451834374, -0.367545099303, 0.788924451896 },
    { 0.594255916481, 0.142049624515, -0.791632370424 },
    { 0.618964682010, -0.279499589886, -0.734004565162 },
    { -0.684047234462, -0.338659276108, -0.646056712473 },
    { -0.468315194288, 0.455186305469, 0.757288786469 },
    { 0.980489526722, 0.092169299281, 0.173623466898 },
    { -0.816109436557, 0.536872668797, -0.213853045480 },
    { 0.832470750360, -0.015681259888, -0.553847043762 },
    { -0.210387062051, -0.977516043497, -0.014130422061 },
    { 0.977157879167, 0.049695163313, -0.206622530053 },
    { 0.708918221805, 0.698238672732, 0.099487238856 },
    { 0.292035436609, 0.655124067049, 0.696798220820 },
    { -0.127686807153, 0.845948718388, -0.517751721520 },
    { 0.368975553581, 0.877285975592, 0.306963121383 },
    { -0.776629337681, -0.618602959453, 0.119068259454 },
    { 0.635875189989, -0.592195811326, -0.494941273087 },
    { 0.520628068515, 0.519941592412, -0.677205400712 },
    { 0.224108962039, 0.308022171328, 0.924606681300 },
    { 0.078700919570, -0.947236393893, -0.310723960040 },
    { -0.471673924652, -0.836996662399, 0.277417187528 },
    { 0.673190387389, 0.674315692468, -0.303501316665 },
    { 0.178139840747, -0.982348125137, 0.057082030265 },
    { 0.489856022603, -0.007709368966, 0.871769260040 },
    { -0.910071152216, -0.155279519632, -0.384263931026 },
    { -0.985598737974, 0.156872909977, -0.063134917597 },
    { -0.326885698692, 0.612302423387, -0.719882964310 },
    { -0.545782470895, 0.092188201104, 0.832840218794 },
    { 0.894100426332, -0.203197731529, 0.399117914325 },
    { -0.167018185845, 0.248118795693, 0.954223238462 },
    { 0.103452300669, -0.705298088761, 0.701321771712 },
    { -0.324632113940, 0.751937023232, 0.573763630506 },
    { 0.663006375173, -0.296359114941, 0.687454595934 },
    { 0.029046367234, 0.866516382246, 0.498302787320 },
    { -0.064560701873, 0.583154772521, 0.809791594831 },
    { -0.294618086630, -0.702395765044, 0.647950902676 },
    { 0.906327289141, 0.415694882989, -0.075951360850 },
    { -0.257434264847, -0.119383691734, 0.958892660015 },
    { -0.876894401285, 0.448813904654, 0.172111266289 },
    { 0.030784418528, 0.991140241151, 0.129202716484 },
    { 90, DUMMYVAL, DUMMYVAL },
    { -0.872321327352, 0.488116045970, -0.028252920426 },
    { 0.931793342597, 0.269756331431, 0.242884104761 },
    { -0.381271571140, 0.299331268055, 0.874661523679 },
    { 0.394846222489, -0.359372227604, 0.845546014486 },
    { -0.646608982388, -0.400169045451, 0.649431720012 },
    { 0.119326666251, -0.950960937151, -0.285367206830 },
    { 0.344547096919, 0.918825403662, -0.192476428662 },
    { 0.985540781390, -0.091863629714, 0.142374301591 },
    { -0.593294854015, -0.021162265219, 0.804707011732 },
    { -0.456802947828, 0.657385085264, -0.599312870317 },
    { 0.276553955448, 0.795971704695, -0.538467227463 },
    { -0.420754015231, 0.818248051176, 0.391709312392 },
    { 0.115907577897, 0.569244673722, -0.813956961285 },
    { -0.195416772901, -0.835797892546, -0.513083002725 },
    { 0.866491250551, -0.443866327028, 0.228419781214 },
    { -0.244103152449, 0.965899431816, 0.086324611686 },
    { -0.986269982063, 0.136851239292, -0.092429761368 },
    { -0.932318318320, -0.140464518009, -0.333245063739 },
    { -0.823454454830, -0.485484693578, 0.293644978030 },
    { 0.668876873013, 0.148812486286, -0.728325869837 },
    { -0.750657691367, -0.407553967313, -0.520012301892 },
    { -0.010224896888, 0.186287735940, -0.982442024204 },
    { -0.136280364452, -0.550154381344, -0.823867597951 },
    { -0.716049663098, 0.610384310175, -0.338679603563 },
    { -0.468257481954, -0.280731412130, -0.837809527779 },
    { 0.141947885091, 0.982248454428, 0.122632669759 },
    { 0.228630599647, -0.011304952263, 0.973447608739 },
    { 0.019520486149, -0.354503660185, 0.934850846679 },
    { 0.712478142636, -0.390034162577, 0.583308021794 },
    { 0.580491905980, 0.811057067755, 0.072218972135 },
    { -0.755618958748, 0.244478153591, 0.607676247353 },
    { 0.157515240181, -0.759959431280, -0.630595442355 },
    { -0.464230081097, -0.609169808690, -0.642963899442 },
    { 0.522537108843, 0.582930996909, 0.622210914983 },
    { 0.175620145566, 0.666328395556, 0.724682022509 },
    { -0.867218390127, -0.479555352807, -0.134010922760 },
    { 0.745399666283, -0.659030253527, -0.100291886222 },
    { 0.825576269226, 0.354580704047, -0.438971921664 },
    { 0.876136926401, -0.070682407607, -0.476852265856 },
    { 0.856965288519, 0.511616803400, -0.062118763288 },
    { 0.483328748171, -0.569146870897, -0.665180547325 },
    { -0.196933921951, 0.648642682724, 0.735173245251 },
    { 0.215775553306, -0.420264496433, -0.881373169341 },
    { -0.659140491561, -0.749505085980, 0.061448665359 },
    { -0.540906732759, 0.550398049035, 0.635988910339 },
    { -0.041173730334, 0.888343584176, 0.457329640833 },
    { -0.863524758024, 0.260843253401, -0.431608375075 },
    { -0.610875935082, 0.790900374776, 0.036155070421 },
    { -0.758589028357, 0.564234980691, 0.325855140549 },
    { 0.020894873709, 0.362778088696, 0.931641273568 },
    { 0.535179392643, 0.535127634662, -0.653621780781 },
    { 0.865484566246, -0.066316586141, 0.496526510865 },
    { 0.456811078864, -0.657883418112, 0.598759589819 },
    { 0.641799011845, 0.696929481065, -0.319973947091 },
    { 0.615515006310, -0.223055843372, -0.755901691852 },
    { -0.111025215376, -0.870461729290, 0.479551644135 },
    { 0.742096836189, 0.589784715292, 0.318506319131 },
    { 0.311278034838, -0.070669381422, -0.947687619185 },
    { -0.294903491930, -0.939575586219, -0.173866754239 },
    { 0.402461220799, 0.310340722050, 0.861227961686 },
    { 0.485727298965, -0.797091150504, -0.358768294068 },
    { 0.411641460501, -0.911344826633, -0.001383822948 },
    { 0.976998526315, 0.138845401864, -0.161851271111 },
    { -0.403164514287, 0.872580776846, -0.275791882221 },
    { 0.939509665929, -0.303214615770, -0.159318813732 },
    { -0.250764827220, 0.458566731219, -0.852545338647 },
    { -0.976175661628, -0.189611622908, 0.105491753725 },
    { 0.764779977912, -0.463738009473, -0.447279156630 },
    { -0.354703728243, -0.292196456059, 0.888147789637 },
    { -0.345192948757, -0.918534739278, 0.192706411072 },
    { -0.398290701057, 0.087654333026, -0.913061463076 },
    { 0.023353315504, -0.996256673780, 0.083230178439 },
    { -0.599947706228, -0.737385960755, -0.310362199170 },
    { 0.362737689998, 0.844133591594, 0.394790891229 },
    { 0.626853113836, -0.731907882273, 0.267144203645 },
    { -0.100892173134, -0.186377597601, -0.977284073600 },
    { -0.029437232469, 0.966331245076, -0.255611764468 },
    { -0.939405502857, 0.199884536817, 0.278502195942 },
    { -0.620385173812, 0.332859953170, -0.710159480462 },
    { -0.279366063484, -0.622470783226, 0.731084623422 },
    { 0.108961186570, -0.670438444015, 0.733920808131 },
    { 0.355341659754, 0.292404183531, -0.887824362302 },
    { -0.111031199968, 0.798154680482, -0.592132737364 },
    { 0.598666476953, -0.037627208526, 0.800114143451 },
    { -0.532287398787, -0.713547847594, 0.455543185974 },
    { 0.744966172707, 0.276237912584, 0.607221555261 },
    { -0.158152187680, 0.017492069521, 0.987259800172 },
    { 0.257789745850, -0.891974033485, 0.371384935779 },
    { -0.863190368882, -0.127551465881, 0.488500778527 },
    { -0.734039445230, -0.041853684195, -0.677815876154 },
    { 91, DUMMYVAL, DUMMYVAL },
    { 0.587939247451, -0.570376951136, 0.573583102018 },
    { 0.726128764150, 0.443857200784, 0.525097898669 },
    { 0.140119709258, 0.684546986921, 0.715375348873 },
    { -0.220061448906, 0.523597896337, -0.823054191203 },
    { -0.959882092293, 0.173113664886, -0.220585647594 },
    { -0.046798480296, 0.831337623064, -0.553793877467 },
    { 0.783617809591, -0.247574903916, 0.569780480047 },
    { 0.448729066294, 0.402059954330, -0.798116544238 },
    { -0.623973807950, -0.781443031137, 0.001864424678 },
    { -0.221441758511, 0.944155134640, -0.243997191215 },
    { -0.814937280712, -0.499822538078, -0.293350743881 },
    { -0.616422193875, -0.051248897044, -0.785746288219 },
    { -0.574960824004, 0.794342054104, -0.196063132540 },
    { -0.002844058433, -0.524465762804, -0.851426787797 },
    { -0.975152329627, 0.128005261635, 0.180810915094 },
    { -0.348778689605, -0.301806129754, 0.887280387319 },
    { -0.206888608519, -0.875080747386, -0.437528043924 },
    { 0.260952293881, -0.624494512317, 0.736145708677 },
    { -0.747138299174, 0.529890404516, -0.401248702314 },
    { 0.693513970236, 0.120831325242, -0.710238103686 },
    { -0.324345084104, -0.634355873927, -0.701707126678 },
    { 0.375038266393, 0.041420287473, -0.926083505159 },
    { 0.432891748589, 0.429463968934, 0.792568882427 },
    { 0.587570147154, 0.781984691461, -0.207993424163 },
    { 0.064010133369, 0.366428214919, 0.928241922204 },
    { -0.864128093165, -0.497268177163, 0.077504829422 },
    { 0.140209964329, 0.599213453088, -0.788215962501 },
    { -0.179687498186, 0.866356852323, 0.465980908867 },
    { -0.677477069908, 0.717771468695, 0.160713840341 },
    { -0.361380151314, 0.922597411091, 0.134975565506 },
    { 0.597134185311, -0.761495120694, 0.252103046179 },
    { -0.312170678440, 0.278311795783, 0.908345755674 },
    { 0.302359841889, -0.324565348179, -0.896234266682 },
    { -0.099551580177, -0.569654160826, 0.815833083380 },
    { -0.551204902729, -0.743923214823, -0.377824569945 },
    { -0.085851532345, -0.836783279618, 0.540761738056 },
    { 0.713322761314, -0.693367205763, -0.102041933359 },
    { 0.444017060799, -0.823698701176, -0.352660317304 },
    { 0.289078040997, 0.063889255450, 0.955171214627 },
    { 0.927083945690, -0.354627098024, -0.121470074469 },
    { 0.178021359314, 0.901112007540, 0.395354961389 },
    { 0.414963538428, 0.904404200360, 0.099288993078 },
    { -0.387690049047, -0.868778876659, 0.308090391509 },
    { 0.843836236257, -0.478347013791, 0.243155384018 },
    { 0.730642474093, -0.521866146373, -0.440246862932 },
    { 0.483850397169, 0.720054861535, 0.497403045365 },
    { -0.691319686431, -0.612918597286, 0.382632832168 },
    { -0.909647223463, -0.232219043317, 0.344407091633 },
    { 0.365923866243, 0.762531447782, -0.533521803919 },
    { -0.686753087081, -0.320698035073, 0.652321215112 },
    { 0.884139677665, -0.152149656936, -0.441755036500 },
    { 0.625470464197, 0.093906991106, 0.774576126303 },
    { 0.117111202673, -0.790406803101, -0.601283670010 },
    { -0.293806636550, -0.953144217078, -0.072067758189 },
    { 0.201002510193, 0.947641462595, -0.248140382178 },
    { 0.275672501929, -0.860650294076, 0.428118842129 },
    { 0.363793896592, -0.931226609774, 0.021702581689 },
    { 0.060623787935, 0.261873871277, -0.963196154415 },
    { 0.869034232821, 0.107702844103, 0.482886735743 },
    { -0.826495860040, 0.069958820891, 0.558578872422 },
    { -0.313366953041, 0.134044865092, -0.940123995484 },
    { -0.805952315674, 0.189701039853, -0.560762320719 },
    { -0.871451256805, -0.166523096466, -0.461348854293 },
    { -0.520594952443, 0.694408792188, 0.496766871704 },
    { 0.880142096707, 0.237708474659, -0.410907009772 },
    { -0.611787818639, 0.381734438026, 0.692816342035 },
    { -0.982135960994, -0.173677686877, -0.072422477199 },
    { 0.090571713083, -0.970057395377, -0.225356194643 },
    { -0.112251367542, -0.018160748515, 0.993513873934 },
    { -0.336662132211, -0.288228634624, -0.896427834752 },
    { 0.970272851018, -0.124125909710, 0.207757919504 },
    { -0.430322773668, -0.631724567773, 0.644783980054 },
    { 0.638666058797, -0.255014547810, -0.725998103128 },
    { -0.557897742477, 0.001643799133, 0.829908071333 },
    { -0.236574236251, 0.611379511884, 0.755147484396 },
    { 0.670184402019, 0.533283770083, -0.516198884014 },
    { 0.928657850351, 0.325897051276, 0.177160122351 },
    { 0.850669558874, 0.505507517673, -0.144303330462 },
    { -0.876949181323, 0.479226863611, -0.036079725205 },
    { -0.550744716308, 0.383003818315, -0.741611982519 },
    { -0.422078090954, 0.721502376434, -0.548893802057 },
    { 0.487804789085, -0.274936975933, 0.828526491435 },
    { -0.826593416726, 0.423456127935, 0.370713138613 },
    { -0.011840280859, -0.120469009911, -0.992646475539 },
    { 0.126472788716, -0.298528994896, 0.945983653623 },
    { 0.992251870112, 0.064376466696, -0.106263337022 },
    { 0.717587807400, 0.671700251614, 0.184082890710 },
    { 0.430656906266, -0.601529124317, -0.672827869283 },
    { 0.007356389032, 0.997326570770, 0.072702096094 },
    { -0.635775708701, -0.422683962934, -0.645854097846 },
    { -0.005336951862, -0.984177027484, 0.177107581759 },
    { 92, DUMMYVAL, DUMMYVAL },
    { 0.342074491476, 0.939191981330, 0.030057685975 },
    { 0.753999254344, -0.592515874737, -0.283566681104 },
    { -0.339817989101, 0.931229738920, -0.131662096421 },
    { -0.883645353426, 0.466948018451, -0.033621978430 },
    { -0.396327154075, -0.811017226926, -0.430320629963 },
    { 0.235722001172, 0.413561336621, 0.879432862142 },
    { -0.047234118896, -0.592180893175, 0.804419497383 },
    { 0.259556205109, -0.958517318932, -0.117792723450 },
    { 0.041125055320, 0.370876082852, -0.927771340899 },
    { -0.718206463641, -0.262790517705, -0.644298548336 },
    { -0.841267489125, -0.536555168480, -0.066163153782 },
    { 0.979213990678, 0.169490389385, -0.111413501727 },
    { 0.839242891830, 0.541338394274, 0.051226081225 },
    { -0.354748467868, -0.194483507802, -0.914510628554 },
    { -0.987185984167, -0.150656138276, 0.052598105144 },
    { -0.514259560015, 0.621063914361, 0.591453057488 },
    { 0.592342741292, -0.805539380293, -0.015374772751 },
    { 0.973712192361, -0.129411930705, 0.187448976092 },
    { -0.657300873020, 0.747249014836, -0.097849231746 },
    { -0.662883441095, -0.065026332602, 0.745893504188 },
    { 0.596368723272, 0.759161217255, 0.260803742532 },
    { 0.301873252293, 0.871010812013, -0.387572838196 },
    { -0.572539084323, -0.815459926927, -0.084994732188 },
    { -0.886438627129, -0.076776398605, 0.456433943688 },
    { -0.569367243398, 0.427589857894, -0.702130939050 },
    { 0.559196590824, 0.638459516620, -0.528837043377 },
    { -0.144719478034, -0.714509436328, -0.684494366723 },
    { 0.810385805548, -0.293868527643, -0.506868952123 },
    { 0.055442889786, -0.902056072059, -0.428043138986 },
    { -0.193250636624, 0.534341831433, 0.822880914000 },
    { 0.592668397222, -0.126120887449, 0.795510963271 },
    { 0.347783934709, 0.095912105413, -0.932655993812 },
    { -0.494433739034, 0.736397020292, -0.461795091149 },
    { 0.344541693812, -0.891774662337, 0.293306960092 },
    { 0.572312265810, 0.271190807567, 0.773895481505 },
    { -0.666722804832, -0.429370572236, 0.609197515765 },
    { -0.915617046035, -0.243041894949, -0.320274979213 },
    { -0.472069459838, 0.849014417427, 0.237328767933 },
    { 0.286089563695, 0.027872477916, 0.957797414133 },
    { -0.600246589506, 0.059688913451, -0.797584644660 },
    { 0.448239875729, -0.792715727807, -0.413137735742 },
    { -0.292873724008, 0.223893070044, -0.929568112067 },
    { 0.857676436543, -0.506590252935, 0.088076363632 },
    { 0.826578749511, -0.321712310943, 0.461810307209 },
    { 0.554220295552, -0.503715791978, -0.662653955629 },
    { -0.237457584250, 0.601325649803, -0.762903243256 },
    { 0.625730545100, -0.100984090920, -0.773474950021 },
    { -0.486546046222, 0.301489057978, 0.819986154045 },
    { -0.949660506911, 0.212870786672, 0.229849841842 },
    { 0.621511004034, 0.766548478558, -0.161640038002 },
    { 0.101778374662, 0.715888736443, 0.690756454538 },
    { -0.087285303739, 0.977285492043, 0.193117432650 },
    { 0.645555921414, -0.677158044045, 0.353149452373 },
    { -0.784457543347, 0.475984802167, -0.397573679701 },
    { -0.699594141074, -0.582073016278, -0.414438223981 },
    { -0.136934518072, 0.864545426784, -0.483539184334 },
    { -0.345951713425, -0.909201718997, 0.231667102003 },
    { 0.750750653791, 0.461798027480, 0.472351603838 },
    { -0.051448618249, -0.419480537679, -0.906305201457 },
    { 0.280714050172, -0.381214052056, 0.880837935463 },
    { -0.028965446920, -0.213555112613, 0.976501519078 },
    { -0.647670056454, -0.705331254606, 0.288151556042 },
    { 0.224718830597, -0.659302015439, -0.717511184312 },
    { 0.137013987569, 0.708892397974, -0.691880578789 },
    { 0.283879730625, -0.722412142972, 0.630502176227 },
    { -0.864849849666, -0.410783536985, 0.288602881611 },
    { -0.001397919879, -0.037017247642, -0.999313649060 },
    { 0.029770514009, 0.986082303290, -0.163570803124 },
    { 0.383058143095, 0.453429951679, -0.804778067500 },
    { -0.199987820948, -0.968057834573, -0.151224668604 },
    { -0.047338875188, -0.858626250955, 0.510411590844 },
    { -0.769028687856, 0.297155416656, 0.565944816751 },
    { 0.013170650710, -0.987461630964, 0.157308808827 },
    { -0.751974635149, 0.587732662196, 0.298503711669 },
    { -0.350265286030, -0.029157028544, 0.936196612411 },
    { -0.205303474739, 0.830342529006, 0.518055757409 },
    { 0.231830327282, 0.892828374239, 0.386150480390 },
    { 0.826969296501, 0.452476768566, -0.333746245752 },
    { -0.371085142929, -0.397381072410, 0.839275937930 },
    { 0.461050912564, 0.637273964644, 0.617506234795 },
    { 0.825449757874, 0.054369895338, 0.561851058294 },
    { 0.678985242228, 0.273351240746, -0.681364909589 },
    { -0.453164258841, -0.513577993977, -0.728614986541 },
    { 0.957632490852, -0.231704976361, -0.171034547369 },
    { -0.387393365263, -0.708071333896, 0.590390859233 },
    { -0.066145301814, 0.208003221042, 0.975889060849 },
    { 0.567453674542, -0.483961848563, 0.666166087687 },
    { 0.938109392316, 0.237704065012, 0.251887962247 },
    { 0.885889981711, 0.069678553551, -0.458632575685 },
    { 0.309514800659, -0.299516489201, -0.902491252517 },
    { -0.842680590337, 0.113387445068, -0.526338968698 },
    { -0.973163572475, 0.136509818102, -0.185250454167 },
    { 93, DUMMYVAL, DUMMYVAL },
    { 0.975243081118, 0.218744300229, -0.032432450557 },
    { 0.328323638640, 0.149628108212, -0.932638739032 },
    { -0.593902733769, -0.122967303463, -0.795084011348 },
    { -0.930892740761, 0.359239261626, 0.066225811468 },
    { -0.984014965187, -0.038135173456, 0.173954755132 },
    { -0.352359601723, 0.503249872574, -0.789038831001 },
    { -0.077238888572, -0.978134295736, -0.193099595020 },
    { 0.151370462087, -0.617133827776, 0.772161137213 },
    { 0.148452157135, 0.955166020488, 0.256163678820 },
    { -0.741553354284, 0.664249085519, -0.094190101060 },
    { 0.651355869378, 0.265241823120, 0.710902459340 },
    { -0.425928712289, -0.765732156869, 0.481911813493 },
    { 0.083646215060, -0.980899743835, 0.175610373416 },
    { 0.165122419491, -0.292140628910, -0.942012972056 },
    { 0.515658483750, -0.742698892788, -0.427193963895 },
    { 0.829905399713, 0.505204348738, -0.236697261378 },
    { 0.041013820862, 0.706505267076, -0.706518346607 },
    { -0.441800834625, -0.496536643747, -0.747170250974 },
    { 0.614246477984, -0.143064657648, 0.776037220767 },
    { -0.342164442594, 0.233597101941, 0.910140587046 },
    { -0.848249415247, 0.008665554055, -0.529526050073 },
    { -0.010118749780, 0.397565736720, -0.917517899493 },
    { -0.146998885992, 0.989093772122, 0.009210725596 },
    { 0.438660982091, -0.886560962325, 0.146922438289 },
    { 0.335783670910, 0.801625225549, -0.494617351206 },
    { 0.582467964568, 0.784989307983, -0.211004399489 },
    { -0.000510788542, 0.030090166167, 0.999547057919 },
    { -0.229604360171, -0.818122297899, -0.527216979498 },
    { 0.662682034485, 0.570653565261, 0.484981473488 },
    { -0.615555118760, 0.622577375124, -0.483207313430 },
    { 0.883090725656, 0.195267040189, -0.426639840234 },
    { 0.894001555458, 0.303818880625, 0.329325532892 },
    { -0.362893970837, -0.137963446075, 0.921560661854 },
    { 0.256801045712, 0.960034101738, -0.111300253465 },
    { 0.364548296831, 0.507805555417, 0.780537031258 },
    { -0.568917504106, -0.683381359060, -0.457518077907 },
    { -0.016633196898, 0.935149827905, -0.353861747197 },
    { -0.776216134962, -0.608688772226, -0.164275653676 },
    { 0.355971134595, 0.500502647411, -0.789165160958 },
    { -0.280816344226, -0.943638794336, 0.175179926473 },
    { -0.662979972965, 0.030445060754, 0.748017816448 },
    { 0.138891876192, -0.838346719387, -0.527146872154 },
    { 0.892522229154, -0.444758142408, 0.074794820866 },
    { 0.634993542968, 0.541362232608, -0.551099023310 },
    { -0.626972458201, 0.398294355559, 0.669527552075 },
    { -0.440146264732, -0.882152674650, -0.167564686764 },
    { 0.036982162707, 0.396925399579, 0.917105526540 },
    { -0.563753878601, -0.377763556073, 0.734490476497 },
    { 0.969702352887, -0.133592198110, -0.204524989697 },
    { -0.761654924080, -0.364561649484, -0.535701951042 },
    { -0.051271021407, -0.853734243544, 0.518178660082 },
    { -0.062663934726, -0.344454228105, 0.936709408528 },
    { -0.364137411511, 0.146590943715, -0.919736397431 },
    { -0.241044994005, -0.253009815992, -0.936954291242 },
    { 0.808617381777, -0.134473089148, -0.572760786178 },
    { -0.900799200583, -0.408090760465, 0.148400577668 },
    { -0.846510451809, -0.178768985351, 0.501459574498 },
    { -0.938351628661, -0.273541448615, -0.211355853664 },
    { 0.978051676197, -0.097282177357, 0.184258233619 },
    { 0.358471011796, 0.780839842963, 0.511651906420 },
    { -0.980262657761, 0.082786254892, -0.179531495285 },
    { 0.295694806299, -0.936376977111, -0.189110386453 },
    { 0.328972401980, -0.803990399451, 0.495355020491 },
    { -0.256100247834, -0.598565945248, 0.759033248448 },
    { -0.480362169242, 0.715179051076, 0.507711641843 },
    { 0.517851436977, 0.838604040651, 0.169035949505 },
    { -0.072399906413, -0.593088026708, -0.801875829619 },
    { 0.672856564547, -0.661697235202, 0.330788168581 },
    { -0.431943732241, 0.874289410556, -0.221455726426 },
    { 0.849315775148, 0.006611058971, 0.527843734437 },
    { -0.011481385528, 0.032654252477, -0.999400759246 },
    { -0.718030723188, -0.535367180554, 0.444762703635 },
    { -0.870976767088, 0.218275928593, 0.440176203570 },
    { 0.810576992326, -0.354570173080, 0.466095410698 },
    { 0.828284394176, -0.463465384261, -0.314872672609 },
    { 0.520396540207, -0.513264896008, 0.682456289785 },
    { 0.680846924790, -0.727509182581, -0.084722218239 },
    { -0.180934585511, 0.896930469393, 0.403458063298 },
    { 0.794082785319, 0.596491021392, 0.116751837071 },
    { -0.659022978882, 0.285347404624, -0.695891925502 },
    { -0.635933053868, -0.757989379321, 0.145056029986 },
    { 0.297657240385, -0.263165770838, 0.917684011142 },
    { -0.854398422577, 0.384486937696, -0.349532731283 },
    { -0.757457672460, 0.577072128453, 0.305361479224 },
    { 0.034671520560, 0.738970291417, 0.672845297275 },
    { 0.357984452092, 0.131944834601, 0.924357989462 },
    { 0.305515709546, -0.582351583499, -0.753343735898 },
    { 0.649693079225, 0.198968780837, -0.733696345267 },
    { 0.506961349717, -0.166692182430, -0.845697289939 },
    { -0.274004725649, 0.572777099997, 0.772559256006 },
    { 0.626035214643, -0.452211471998, -0.635283160976 },
    { -0.498203010950, 0.853917267109, 0.150396345743 },
    { -0.285732970274, 0.782156613000, -0.553703623285 },
    { 94, DUMMYVAL, DUMMYVAL },
    { -0.019370004784, 0.041482513216, 0.998951452280 },
    { 0.778504979270, -0.213911081884, -0.590061053027 },
    { -0.248131495339, -0.505649130407, 0.826286704443 },
    { -0.147465029393, 0.855196872600, -0.496882656371 },
    { 0.240472609680, -0.863554268317, 0.443223363176 },
    { -0.196433249892, -0.976974649647, -0.083273719053 },
    { 0.217795110610, 0.941656390656, -0.256609687526 },
    { 0.932312498253, 0.336436599240, -0.132679389105 },
    { 0.106045362921, 0.985096629223, 0.135421608675 },
    { 0.999857695902, 0.004726330350, 0.016194126927 },
    { -0.315165844717, -0.030514767625, -0.948545907840 },
    { -0.312655245929, 0.261040476361, 0.913293253503 },
    { -0.499802831217, 0.659104910294, -0.561941142055 },
    { -0.190570238008, 0.609500013710, 0.769540588711 },
    { 0.158940718169, 0.513198516010, -0.843424644692 },
    { -0.325791312455, -0.621505558574, -0.712454111778 },
    { -0.884899816383, 0.452138648575, 0.111906020525 },
    { -0.266189177524, -0.861576765605, -0.432236970582 },
    { 0.930892496095, -0.319654356833, 0.176805692419 },
    { 0.752299709624, 0.650895727157, -0.101881790665 },
    { 0.370194034333, -0.751759677612, -0.545723156977 },
    { 0.527316773182, -0.467594551154, -0.709431008944 },
    { 0.491778182234, -0.635059852030, 0.595695563034 },
    { -0.539604955455, -0.325255804997, -0.776553380886 },
    { 0.103910376622, -0.932409175619, -0.346144135948 },
    { -0.072267268369, -0.960456373877, 0.268888444903 },
    { 0.494980084134, -0.844293189129, -0.205338080006 },
    { -0.300896715939, 0.936205924283, 0.181602956129 },
    { 0.473893173145, 0.880489458197, 0.012789622784 },
    { 0.505877698275, 0.506863095830, -0.697981057389 },
    { -0.697056717492, 0.598515661001, 0.394830262436 },
    { 0.027976801188, -0.725701215759, -0.687440938584 },
    { 0.445873011766, -0.343904326936, 0.826394016976 },
    { 0.189633060854, 0.677542494747, 0.710616260751 },
    { 0.908665994040, 0.347669036272, 0.231197648114 },
    { -0.546069988399, -0.824819044452, -0.146564360197 },
    { 0.099879799861, -0.083532065825, -0.991486973973 },
    { -0.762572650548, -0.467358028482, 0.447280030684 },
    { 0.206312846707, 0.777475967872, -0.594109525815 },
    { 0.063985108011, -0.317961153664, 0.945942181485 },
    { -0.983637629722, 0.076692301027, 0.163019337377 },
    { 0.356577023033, 0.853454788579, 0.380089134936 },
    { 0.735107562131, -0.593534844623, 0.327617551904 },
    { -0.445872932275, 0.343904369017, -0.826394042352 },
    { 0.761753763800, 0.312641661209, 0.567438450418 },
    { 0.533132754034, 0.751910067717, -0.387815312542 },
    { -0.634019445884, 0.068665313298, 0.770262563670 },
    { 0.476866446997, -0.137420281680, -0.868167067972 },
    { 0.919055584997, 0.061373348100, -0.389320104579 },
    { -0.946689555512, 0.256873731790, -0.194408773979 },
    { -0.739920841258, 0.378698737029, -0.555971595718 },
    { -0.155776190569, -0.367092791874, -0.917047796249 },
    { -0.859358862505, -0.107417951620, 0.499963727788 },
    { -0.031733603931, 0.876738729129, 0.479918929848 },
    { 0.689152818290, 0.150445438516, -0.708826186785 },
    { -0.765209745058, 0.596704935848, -0.241655261896 },
    { 0.201072708478, -0.447386751181, -0.871444123724 },
    { 0.348237619359, 0.204715711369, -0.914779775674 },
    { -0.838201806302, 0.259955343741, 0.479417303789 },
    { 0.508436378225, -0.841701092332, 0.181746307979 },
    { -0.837542638894, -0.517116907053, -0.176387166410 },
    { -0.974546005681, -0.145376521876, -0.170662678107 },
    { -0.483619633692, -0.675509672773, 0.556595662845 },
    { -0.727875170919, -0.669734525220, 0.147150947285 },
    { 0.149560545943, -0.627633110422, 0.764008063962 },
    { -0.626119089579, 0.775227340527, 0.083650798952 },
    { -0.429634064552, -0.870562617703, 0.239865168864 },
    { -0.937552950297, -0.311006590571, 0.155786283126 },
    { -0.874678175121, 0.038853976283, -0.483144345403 },
    { 0.928504210504, -0.295803196395, -0.224455786470 },
    { -0.138175786281, 0.979366166243, -0.147476657487 },
    { -0.136591380441, -0.794832808073, 0.591255953036 },
    { -0.469386132007, 0.849284174261, -0.241646540278 },
    { 0.781323560468, -0.622527038357, -0.044649528245 },
    { 0.201657322590, -0.979347116052, 0.014613368040 },
    { -0.553184387572, 0.444959608970, 0.704271240170 },
    { 0.446597366274, 0.333613151528, 0.830212658037 },
    { 0.665408276226, -0.000956787332, 0.746479008739 },
    { 0.913461523419, -0.007523569188, 0.406855553164 },
    { 0.756063062942, -0.314546533167, 0.573959165209 },
    { 0.337500666938, -0.004567674187, 0.941314206930 },
    { -0.332440508740, -0.141935001744, 0.932382841664 },
    { 0.085784401978, 0.383375239017, 0.919600164466 },
    { -0.185772903056, 0.607563146188, -0.772240540172 },
    { 0.536234270142, 0.602595793279, 0.591042399028 },
    { -0.394618646969, 0.770598404984, 0.500454015570 },
    { -0.609085530713, -0.639851737352, -0.468619857116 },
    { 0.702553891670, 0.660057918480, 0.265972881233 },
    { -0.591824351485, -0.319444820555, 0.740066850771 },
    { -0.800533566265, -0.319150004416, -0.507236911082 },
    { 0.774959065191, 0.436416155856, -0.457142632213 },
    { -0.643505880176, 0.032064339832, -0.764769285661 },
    { -0.080127193188, 0.253809118680, -0.963929750649 },
    { 0.715778202661, -0.570369291107, -0.402914924466 },
    { 95, DUMMYVAL, DUMMYVAL },
    { 0.860281839097, 0.375186668719, -0.345181287059 },
    { 0.345512635167, 0.851499751882, 0.394422605189 },
    { -0.164594980599, -0.507792405648, -0.845609463717 },
    { 0.210676598460, -0.354034382527, -0.911194286006 },
    { -0.793338801231, 0.597531817798, -0.116487223252 },
    { -0.132775361880, 0.969051085073, -0.208112224042 },
    { -0.631315319976, -0.485793265048, 0.604521191025 },
    { 0.919148252958, 0.021080981620, 0.393347278240 },
    { 0.378622784776, 0.326097289790, 0.866201676539 },
    { 0.544134051812, -0.187552087012, -0.817766683301 },
    { 0.788725466852, -0.303156839003, -0.534797222229 },
    { -0.282312372154, 0.950048011317, 0.133073290789 },
    { -0.091147726198, 0.266310007088, -0.959568169613 },
    { 0.065811567751, -0.588550837555, 0.805777108861 },
    { -0.061105995219, -0.837481511281, 0.543038466051 },
    { -0.866963152538, 0.446967896874, 0.220441809340 },
    { -0.923167753623, -0.028717094335, -0.383323136744 },
    { -0.423400646923, 0.111887837620, -0.899006676270 },
    { 0.507844212619, -0.823501240017, 0.252863527222 },
    { 0.465169327043, -0.879245488811, -0.102688205671 },
    { -0.704482922160, -0.651092966251, 0.282456654522 },
    { 0.319707084085, -0.750432078638, 0.578479970039 },
    { -0.790424523525, -0.143836901042, 0.595432631377 },
    { -0.636764106128, 0.602323737688, -0.481391304621 },
    { 0.952234379486, -0.002993413706, -0.305353444389 },
    { 0.167290101114, -0.950650765915, 0.261298953949 },
    { 0.502232171191, -0.532244549725, -0.681526657959 },
    { 0.501177452889, -0.043447583433, 0.864253127393 },
    { -0.151812643996, -0.265820787333, 0.951993818333 },
    { -0.255995971083, 0.107219497700, 0.960713298597 },
    { 0.021462969689, -0.894673001816, -0.446205738145 },
    { 0.376668827732, -0.811157193500, -0.447375235846 },
    { 0.691548748624, -0.634709694027, -0.344824495338 },
    { -0.696161193505, 0.236463632478, -0.677823386417 },
    { -0.105476893584, -0.134630133059, -0.985266132673 },
    { 0.347439042317, 0.700737583577, -0.623099471061 },
    { 0.854144478846, 0.382565907893, 0.352250671221 },
    { -0.627703775605, 0.756002373896, 0.185602749860 },
    { -0.593249422245, -0.733844604756, -0.330948967481 },
    { 0.662192311710, 0.688491564022, 0.295771378909 },
    { 0.962764871496, 0.270030003201, 0.012946025863 },
    { 0.215809618722, -0.277288505479, 0.936235703868 },
    { -0.388559593418, 0.455154554201, 0.801159019267 },
    { -0.303887117964, -0.577324870326, 0.757857911247 },
    { 0.239302982036, 0.666359120785, 0.706186664371 },
    { -0.965051795468, 0.021619743154, 0.261165883624 },
    { -0.977952573866, 0.202647741785, -0.050424756000 },
    { 0.798548731671, 0.600818397192, -0.036567427337 },
    { -0.494165180620, -0.217422918294, 0.841741081843 },
    { 0.632265072684, 0.463348699690, -0.620925809062 },
    { 0.249612008105, 0.433539628171, -0.865873683753 },
    { -0.894319296691, -0.343978438831, 0.286132537797 },
    { -0.975709556806, -0.209647515343, -0.063551397060 },
    { -0.125899598358, 0.696264871964, 0.706657285537 },
    { 0.120678604432, 0.067917079427, 0.990365561171 },
    { -0.825621669123, -0.401308902133, -0.396610671243 },
    { -0.273447241269, -0.936007028693, -0.221624566506 },
    { 0.751211437346, -0.216853773741, 0.623422663379 },
    { 0.517520859366, 0.187983645573, -0.834766020582 },
    { 0.107481542755, -0.989146482812, -0.100184597159 },
    { 0.138118458136, -0.673366897269, -0.726292167922 },
    { -0.503093411044, 0.845800485816, -0.177534666921 },
    { -0.410752702652, 0.478828583098, -0.775890072931 },
    { 0.785740532195, 0.077313809514, -0.613705459423 },
    { -0.866436388051, 0.334074803454, -0.371055266987 },
    { 0.028521714595, 0.849387677471, -0.526998183258 },
    { 0.715002496712, 0.191154945163, 0.672481387576 },
    { -0.003404554154, 0.410044274659, 0.912059264429 },
    { 0.279386533995, 0.920369308137, -0.273611953799 },
    { -0.819471253230, 0.231472108026, 0.524297175594 },
    { 0.221184311325, 0.030615014916, -0.974751363828 },
    { 0.574906894190, 0.537129212402, 0.617231133529 },
    { -0.821938365167, -0.565933755638, -0.064314136054 },
    { 0.492576510372, 0.870041904866, 0.019886307017 },
    { -0.196174420873, -0.966252994844, 0.166945340005 },
    { -0.014346830887, 0.908508173683, 0.417620721222 },
    { 0.123711698226, 0.989305174970, 0.077270217417 },
    { -0.330813336664, 0.786956620537, -0.520828007770 },
    { -0.530727845128, -0.846928584586, 0.032247899414 },
    { 0.891661477757, -0.366583496846, 0.265624450915 },
    { 0.674103054380, -0.574364074429, 0.464425432207 },
    { -0.724401502336, -0.136080047595, -0.675814089865 },
    { -0.640468469904, 0.546212162123, 0.539863328082 },
    { -0.407992976568, -0.797698074350, 0.444094036494 },
    { 0.994541816202, -0.090700119660, 0.051575809432 },
    { -0.385657473339, 0.794080683558, 0.469791636003 },
    { -0.066905099596, 0.610721831656, -0.789013657668 },
    { 0.476652367636, -0.449505072560, 0.755478464398 },
    { -0.564555901587, -0.517463903279, -0.643045677060 },
    { 0.910131887430, -0.375648331539, -0.174780658241 },
    { -0.286565249212, -0.756147374380, -0.588320921065 },
    { -0.590315843945, 0.146986219790, 0.793676417427 },
    { 0.609740397053, 0.718912140096, -0.333739393875 },
    { -0.434542996599, -0.256003406489, -0.863501383886 },
    { 0.762136175479, -0.646118211263, 0.040984229901 },
    { 96, DUMMYVAL, DUMMYVAL },
    { -0.514547478389, -0.503834249549, -0.693824143040 },
    { 0.099236761805, 0.210610523308, -0.972520062815 },
    { 0.029347100298, -0.687766957691, 0.725338100208 },
    { 0.013311276596, 0.975086028764, 0.221427293766 },
    { -0.396567786882, 0.631390674467, -0.666393132170 },
    { -0.073840039394, 0.269488426781, 0.960168545836 },
    { 0.505982980907, -0.264334626824, 0.821041063586 },
    { 0.463127398484, 0.565714457330, 0.682261068464 },
    { -0.930374358872, 0.222484732101, -0.291383074894 },
    { 0.116531588697, -0.164726736580, -0.979431207942 },
    { 0.475455936312, 0.667388493849, -0.573179074028 },
    { -0.307778310030, 0.528230358568, 0.791356556909 },
    { -0.997481795293, -0.022625289940, 0.067217291777 },
    { 0.465921661777, 0.852966806262, -0.235296902875 },
    { 0.998739283396, -0.003331190033, -0.050087393364 },
    { 0.564164308679, 0.106861313172, 0.818718078803 },
    { 0.133873341698, -0.813357480475, -0.566151514471 },
    { 0.091931086053, 0.984952500411, -0.146346326745 },
    { -0.278652058681, 0.955158694993, -0.100124410472 },
    { -0.193545755169, 0.410618429576, -0.891028925427 },
    { 0.826020630876, 0.491013840463, 0.276758605720 },
    { -0.217029533721, -0.344872663883, -0.913214666549 },
    { 0.928604149125, 0.366326133622, -0.059156555460 },
    { 0.306338026811, 0.469869129919, -0.827876810932 },
    { 0.439414525206, 0.093378042861, -0.893417828426 },
    { -0.077180997728, -0.985547883451, 0.150792781706 },
    { 0.071553991107, 0.611147333176, 0.788275943759 },
    { -0.185855402714, 0.870558919369, -0.455614900095 },
    { -0.789832645655, 0.094778047050, -0.605955042602 },
    { -0.540852199489, -0.736098985248, -0.406985481590 },
    { 0.289231558533, 0.333721793843, 0.897203917659 },
    { 0.719385524560, -0.613451612362, -0.325824471678 },
    { 0.912028523337, -0.398804913518, -0.095700645626 },
    { -0.211357830546, -0.880042533047, -0.425268159512 },
    { -0.805878469106, -0.506578204105, -0.306493745707 },
    { 0.061181353201, -0.978093311456, -0.198973154234 },
    { 0.141973614575, -0.521537282090, -0.841333677059 },
    { 0.651635415086, 0.350718594740, -0.672582896831 },
    { 0.409285234718, -0.858514996898, -0.308929760208 },
    { 0.008166629121, 0.668551434422, -0.743621063245 },
    { -0.950081652890, -0.146572159569, -0.275429582438 },
    { 0.393461200348, -0.608046827969, 0.689541397465 },
    { 0.734275548028, 0.332345089411, 0.591934254046 },
    { -0.707863836638, 0.467003455662, -0.529940148677 },
    { 0.227610190719, -0.025166094404, 0.973427074194 },
    { -0.768532114215, -0.271355168199, -0.579417605973 },
    { 0.802596447368, -0.556759753854, 0.214143688119 },
    { 0.937980391915, -0.222095301546, 0.266207553264 },
    { 0.802248218245, -0.069373009130, 0.592946188053 },
    { -0.181367826871, -0.856348463826, 0.483500796152 },
    { -0.773053254904, 0.555813714248, 0.305711923445 },
    { 0.232964600258, 0.832587807525, 0.502518693967 },
    { 0.179428094227, 0.856427036219, -0.484085003523 },
    { -0.470138623722, -0.844076891885, 0.257883452494 },
    { -0.189950929330, -0.665819287403, -0.721528461649 },
    { -0.684023532204, -0.728693988988, -0.033419721787 },
    { 0.448577737446, -0.284616588056, -0.847213911165 },
    { -0.237085107731, -0.472665137244, 0.848751035184 },
    { 0.449252800860, -0.632171986537, -0.631292721609 },
    { 0.892908828601, 0.207862719436, -0.399383166488 },
    { -0.345202263103, 0.902510289088, 0.257508399163 },
    { -0.431486010857, 0.177440700858, 0.884496817470 },
    { 0.533261720261, -0.759104243203, 0.373353298707 },
    { -0.506731141641, 0.693943644168, 0.511532764161 },
    { -0.235218134564, 0.031942738957, -0.971417567578 },
    { -0.452963136368, -0.650595118521, 0.609549332579 },
    { -0.914954180388, -0.401491474004, 0.040785341636 },
    { -0.733792779429, 0.007175378174, 0.679335462645 },
    { 0.628422816300, -0.777771530858, -0.012498389535 },
    { 0.728080973202, -0.013414411411, -0.685359868994 },
    { -0.619458525213, 0.782939701164, 0.057241242850 },
    { 0.572606528978, 0.729286894837, 0.374516205245 },
    { -0.801122394473, 0.571451531399, -0.177893384746 },
    { -0.938085422630, 0.340250243094, 0.065003937757 },
    { 0.373109979591, 0.919399568090, 0.124472395837 },
    { 0.144247829853, -0.382847707140, 0.912480244564 },
    { 0.711664575612, -0.432542269573, 0.553570877894 },
    { -0.743809460364, -0.585354507108, 0.322657074433 },
    { -0.532798502838, 0.777816133994, -0.333358391332 },
    { -0.682802488002, -0.375240833735, 0.626877244025 },
    { 0.912525032568, -0.166473841838, -0.373610124221 },
    { -0.536350815076, -0.127640081379, -0.834287607959 },
    { -0.896476486974, 0.185482253552, 0.402400598806 },
    { 0.942479033628, 0.146182764602, 0.300605839105 },
    { -0.357312211508, -0.929485340845, -0.091569561868 },
    { 0.310676459331, -0.947003483187, 0.081636636684 },
    { -0.141091995569, 0.813648778328, 0.563975810041 },
    { 0.752276683311, 0.561794520618, -0.344189930634 },
    { 0.194158903167, -0.879613720723, 0.434260316673 },
    { 0.705095011115, 0.709112838838, -0.000084237254 },
    { -0.658718705837, 0.380225753269, 0.649244209163 },
    { 0.710685377105, -0.374087673412, -0.595805930962 },
    { -0.525178458170, 0.265894603505, -0.808385827994 },
    { -0.901986603969, -0.208280910211, 0.378205273235 },
    { -0.469777660148, -0.195652668967, 0.860830403246 },
    { -0.134882704899, -0.105672074271, 0.985210672211 },
    { 97, DUMMYVAL, DUMMYVAL },
    { 0.694970815171, 0.697961547436, -0.172815636916 },
    { -0.585521676202, -0.275670542477, 0.762345144084 },
    { 0.730286943741, -0.313206846307, 0.607109916924 },
    { 0.263369078986, -0.850651304070, 0.455004491317 },
    { 0.571131894199, -0.023848268249, -0.820511803407 },
    { -0.702300187714, -0.693939951663, 0.158813695326 },
    { 0.579987122698, -0.785600141671, 0.215516484082 },
    { -0.079339965114, -0.505674943589, 0.859068112179 },
    { 0.787206744697, -0.212944421211, -0.578757474750 },
    { -0.079694661363, -0.991096181372, -0.106663584318 },
    { 0.827435543147, 0.541204136427, 0.149828250515 },
    { 0.908044912655, 0.373967131035, -0.188687629448 },
    { -0.508513976923, -0.346859496620, -0.788100263214 },
    { -0.896263965702, -0.002861161904, -0.443511800900 },
    { -0.262737790798, 0.854885334454, -0.447370001478 },
    { 0.368377886729, 0.079999326587, 0.926227747541 },
    { 0.533088530745, 0.836401629437, 0.127471301333 },
    { -0.076676275743, -0.789457799058, 0.608996824495 },
    { -0.789056892121, -0.339063845419, -0.512274271973 },
    { -0.094353882457, 0.931772427289, 0.350567380982 },
    { -0.847673795871, 0.242343546023, 0.471930865164 },
    { 0.908905554073, -0.054136624552, 0.413472997495 },
    { 0.688118653017, 0.031981461422, 0.724893030381 },
    { -0.675786224089, -0.008496739926, -0.737048699031 },
    { -0.717839273880, 0.692872852689, 0.068073393348 },
    { 0.560688681865, 0.368447912797, 0.741535122286 },
    { -0.549876119333, 0.424480742619, 0.719341610456 },
    { 0.254211980918, -0.598938796637, 0.759373812190 },
    { 0.693609367040, -0.578647530644, -0.429037389085 },
    { 0.828695252937, -0.473014460881, 0.299201433080 },
    { -0.192838143403, 0.474386617552, 0.858935845996 },
    { 0.267129851495, -0.959184735603, 0.092770067518 },
    { -0.983159281772, 0.017843020602, 0.181877577729 },
    { -0.959807669032, 0.223338652149, -0.169967893804 },
    { -0.218455728516, 0.975601788796, -0.021868799140 },
    { -0.595578064702, -0.779563038557, -0.193825276374 },
    { 0.532704083886, 0.362411967444, -0.764777042585 },
    { 0.173514556642, 0.982433525081, 0.068680910233 },
    { 0.272045586576, 0.176526158839, -0.945954393230 },
    { -0.908298976665, 0.393897531027, 0.140846384545 },
    { -0.216357633960, 0.622465921257, -0.752147293488 },
    { -0.398572382468, -0.581921266170, 0.708877772195 },
    { -0.838303654722, -0.513339945010, -0.183654793942 },
    { -0.908258584657, -0.377405606354, 0.180641500465 },
    { 0.343845129543, 0.648580973698, 0.679053199276 },
    { -0.795171356616, 0.547616976731, -0.260419201315 },
    { -0.573038186673, -0.628834840020, -0.525541606908 },
    { -0.688398736458, 0.588569963979, 0.423901612577 },
    { -0.675806360504, 0.066513452838, 0.734072015332 },
    { 0.627204038696, 0.642029344968, 0.440923365274 },
    { -0.148156406841, -0.358572347723, -0.921669979201 },
    { 0.975188365907, 0.181582830974, 0.126630669647 },
    { -0.373396861143, 0.144171177942, 0.916400270373 },
    { 0.015360863904, -0.825976369446, -0.563495413448 },
    { -0.856953802853, -0.164012100006, 0.488600256680 },
    { -0.547825456586, 0.632240446731, -0.547867946345 },
    { 0.175837379255, 0.411284730483, 0.894385871159 },
    { -0.294727791591, -0.876721563720, -0.380124753958 },
    { -0.370825427004, -0.006892863419, -0.928677011195 },
    { 0.975360544971, -0.204484346289, 0.082812797548 },
    { -0.766612947849, 0.325103178264, -0.553726025822 },
    { -0.361078509855, 0.726572019753, 0.584564290590 },
    { 0.271420862358, -0.236408305097, -0.932974720321 },
    { 0.388896090307, -0.731033675323, -0.560668883110 },
    { 0.721644090089, 0.500006540501, -0.478772667031 },
    { -0.121578411563, 0.320828900756, -0.939301605599 },
    { -0.974821624110, -0.177773751228, -0.134607928972 },
    { -0.482767299990, 0.341439619384, -0.806445733063 },
    { 0.181540178365, 0.524459029725, -0.831856892608 },
    { -0.018801243306, 0.115670841736, 0.993109646324 },
    { 0.826584109570, 0.313287643972, 0.467557014642 },
    { 0.044974430716, 0.959857886408, -0.276857614094 },
    { 0.434814449201, 0.698465220648, -0.568403668454 },
    { -0.389384304851, -0.918577846398, 0.067783502728 },
    { 0.811871236084, 0.154433836493, -0.563041105219 },
    { 0.908803084060, -0.329222070942, -0.256300180274 },
    { 0.089053935469, 0.795049494227, -0.599971414575 },
    { -0.258949179087, -0.644589309211, -0.719339937096 },
    { -0.422657805133, -0.804863715317, 0.416599063280 },
    { -0.018859748485, -0.029714130043, -0.999380498290 },
    { -0.703798090641, -0.518964989252, 0.485122239792 },
    { 0.221099798433, -0.932409043115, -0.285881540940 },
    { -0.518388938182, 0.832274160428, -0.196450071661 },
    { 0.543505678583, -0.821569149432, -0.172121207436 },
    { -0.273198116999, -0.204773444513, 0.939909902752 },
    { -0.447019623801, 0.860759787419, 0.243446183579 },
    { 0.968609886143, 0.025077547466, -0.247317619831 },
    { 0.552990100314, -0.625515095054, 0.550393327371 },
    { 0.125540555842, -0.223330440347, 0.966624582376 },
    { 0.144215015282, -0.566979360336, -0.811009515555 },
    { 0.456857803474, -0.293539386257, 0.839711602946 },
    { -0.006736660754, 0.740444165759, 0.672084112887 },
    { -0.071579102055, -0.957578736520, 0.279140458395 },
    { 0.802176326797, -0.595986165202, -0.036244056263 },
    { 0.520546605210, -0.422898272186, -0.741746778345 },
    { 0.395914127537, 0.883483420515, -0.250417749554 },
    { 0.278378317478, 0.871640924770, 0.403419893689 },
    { 98, DUMMYVAL, DUMMYVAL },
    { -0.118260058214, 0.988813558770, -0.090897220106 },
    { 0.708083430921, 0.646783941985, -0.283352055304 },
    { -0.480097102220, 0.463196495933, 0.744953541233 },
    { -0.141970797802, 0.586980432587, 0.797055998241 },
    { 0.311992580885, -0.574245157830, 0.756903645242 },
    { 0.122477907182, 0.765282014695, 0.631935598172 },
    { -0.238438330656, -0.106901904773, 0.965255999841 },
    { -0.654837999776, 0.747911903659, 0.108696726788 },
    { -0.643108336807, -0.760531977152, -0.089458252046 },
    { 0.722141514976, -0.041258274252, 0.690513857323 },
    { -0.342632234224, -0.935840983090, 0.082491250683 },
    { 0.547081416660, 0.199382412870, -0.812987439622 },
    { 0.598345528269, 0.797643038799, 0.075816960213 },
    { -0.366970603927, -0.872105404489, -0.323673816232 },
    { 0.168476322476, 0.422282437322, 0.890670125184 },
    { -0.611579494031, 0.388877456189, -0.689017304971 },
    { -0.033579149031, 0.376837086246, -0.925670703425 },
    { -0.466524102938, 0.866500341757, -0.177573700510 },
    { 0.291057211666, -0.941473791096, -0.170037643526 },
    { 0.831930862596, -0.379855451045, 0.404476051419 },
    { -0.590985230099, 0.664032112348, -0.458036910713 },
    { -0.803418543381, 0.571002480320, -0.168744812128 },
    { 0.424591457501, 0.873046480715, -0.239816464673 },
    { -0.550900765046, -0.278843283962, 0.786609668172 },
    { -0.500488580296, -0.446640898962, -0.741635414720 },
    { 0.612796137035, -0.389269006151, 0.687713992358 },
    { -0.197568695162, 0.257428137001, 0.945884435316 },
    { -0.708099752686, -0.476559432867, 0.521043037754 },
    { -0.110814773227, -0.026440207669, -0.993489306159 },
    { 0.776993450254, -0.616086778422, 0.129299109492 },
    { 0.921440408280, -0.026381007490, 0.387623033930 },
    { -0.626508447185, -0.639608299883, -0.445408114348 },
    { -0.772885691274, -0.297015955731, -0.560739895376 },
    { 0.867622596020, -0.451730692174, -0.207774908553 },
    { 0.666516937226, 0.459192114135, -0.587279979828 },
    { -0.001227152888, 0.947171637655, 0.320724777524 },
    { 0.574075038268, -0.679558706514, 0.456768885584 },
    { 0.965461853574, -0.248606992751, 0.077961352281 },
    { 0.096973112770, 0.919155630613, -0.381771059814 },
    { 0.655713695943, -0.586472375072, -0.475488908630 },
    { 0.903162496878, 0.311517121480, -0.295388874633 },
    { -0.575929009363, -0.761428072545, 0.297545066359 },
    { 0.374335951703, 0.847029778133, 0.377376668885 },
    { 0.855188311352, 0.517618802968, 0.026902173532 },
    { 0.089718314811, -0.979237657297, 0.181780731982 },
    { -0.987218578697, -0.158790407189, -0.013604575003 },
    { 0.775746356227, -0.267058707699, -0.571749278481 },
    { 0.005756776743, -0.876515914065, -0.481338458791 },
    { -0.970952196086, 0.227482943119, -0.074184523351 },
    { -0.411325003438, -0.672802648924, 0.614937669319 },
    { 0.398554183990, 0.719539295551, -0.568698307173 },
    { -0.868123561918, -0.441670458312, -0.226470058721 },
    { -0.167370337398, -0.394939960575, -0.903332495652 },
    { 0.353290214581, -0.787391936892, -0.505173200000 },
    { 0.307968455868, 0.471450139926, -0.826371705562 },
    { -0.026709276226, -0.707765213103, 0.705942644756 },
    { 0.113872499028, 0.048346998522, 0.992318306643 },
    { -0.068747840927, -0.987566031416, -0.141375627180 },
    { 0.230123270165, 0.098448169469, -0.968169013374 },
    { -0.369148033193, 0.230920045110, -0.900225339765 },
    { -0.910582883224, -0.248241816638, 0.330476645546 },
    { 0.809091671198, 0.093788175730, -0.580150364726 },
    { -0.951799065630, 0.112467722152, 0.285358634249 },
    { -0.934105020991, -0.043626067520, -0.354322700362 },
    { 0.234391675052, -0.842007933856, 0.485883918225 },
    { 0.435078392222, -0.494193657833, -0.752648271890 },
    { 0.676679640980, 0.623461899128, 0.391663023298 },
    { 0.091312460000, -0.631564476401, -0.769927494507 },
    { -0.280645513862, 0.794762875437, 0.538135733227 },
    { 0.617334409716, -0.769236147288, -0.164845310175 },
    { 0.040987570959, 0.710211971468, -0.702793692779 },
    { -0.536604275021, 0.106897310833, 0.837035732192 },
    { -0.861505478467, 0.460891851795, 0.213042276369 },
    { -0.247829087654, 0.846332444423, -0.471489275413 },
    { 0.955758269182, -0.088796228984, -0.280430669879 },
    { -0.787883555461, -0.055127800360, 0.613351798450 },
    { -0.725946883003, 0.042482885358, -0.686437417038 },
    { -0.347003578520, 0.916852025086, 0.197410436883 },
    { -0.833912474727, -0.536324204613, 0.130178078185 },
    { -0.464160497163, -0.120783430148, -0.877477290803 },
    { 0.453896887207, 0.198169078090, 0.868738529290 },
    { -0.607462988732, 0.651634410304, 0.454270087755 },
    { 0.991328556062, 0.129769207925, 0.020679618249 },
    { 0.408282503282, -0.171985466861, 0.896507889928 },
    { -0.304459972584, 0.592789658884, -0.745590065260 },
    { 0.438665404302, 0.579880991003, 0.686520720257 },
    { 0.227291929182, 0.972960437333, 0.041065390696 },
    { -0.849609296980, 0.314015445561, -0.423743250606 },
    { 0.889378042844, 0.321486251749, 0.325043515307 },
    { 0.533977690260, -0.154443699283, -0.831273101968 },
    { -0.767343100706, 0.312746395070, 0.559798408510 },
    { 0.461234886466, -0.871839934338, 0.164795353089 },
    { -0.269001805983, -0.706268603629, -0.654845545076 },
    { 0.185668654680, -0.278543972524, -0.942305898337 },
    { -0.183024305402, -0.891852558532, 0.413643708366 },
    { 0.086959278019, -0.340427806510, 0.936240883812 },
    { 0.704817920113, 0.318921859255, 0.633656489887 },
    { -0.244249415154, -0.458562729788, 0.854436917535 },
    { 99, DUMMYVAL, DUMMYVAL },
    { -0.720018612991, 0.004551503663, -0.693939825029 },
    { -0.357469722837, -0.698158501956, -0.620314519741 },
    { 0.140190470924, -0.836973183750, 0.528982534254 },
    { 0.964249815104, -0.264433703051, -0.017236901203 },
    { -0.879923339666, -0.453798375953, -0.140719402687 },
    { 0.704689453551, -0.155741191945, -0.692212001619 },
    { 0.714554907338, 0.604436491263, 0.352232611250 },
    { -0.436677815388, 0.447643236820, 0.780338399720 },
    { -0.857798014912, -0.464518038052, 0.220012631313 },
    { -0.855306149447, 0.443683116660, -0.267575564484 },
    { 0.392915679430, 0.798300371180, 0.456435960713 },
    { -0.359679065490, 0.575857526905, -0.734179186953 },
    { 0.666810394100, -0.506927828183, 0.546249096415 },
    { 0.278045249700, 0.325187117494, 0.903849643323 },
    { -0.969531376663, -0.119212323713, 0.214003111052 },
    { 0.246203649013, -0.942718853160, -0.225088709423 },
    { 0.773578122158, -0.609732899376, 0.172634528227 },
    { -0.080201701357, 0.363686957162, -0.928062220053 },
    { -0.131668993200, -0.010236590894, -0.991240883154 },
    { -0.842315500242, -0.268420948450, -0.467391476693 },
    { 0.561641789802, 0.179807009852, -0.807606302078 },
    { -0.023047670393, -0.010528785922, 0.999678923233 },
    { 0.829294854298, 0.273992277376, 0.487030057156 },
    { 0.558075702029, -0.829787686956, -0.001976203535 },
    { -0.226914030446, -0.301660289907, 0.926018948121 },
    { 0.672146610818, -0.484993586638, -0.559464167294 },
    { 0.163401546106, 0.971327754825, 0.172691422592 },
    { -0.691259082183, 0.714827371690, -0.105748333238 },
    { 0.273076970173, -0.779149657561, -0.564229367796 },
    { -0.595546426788, -0.408083179020, -0.691948388640 },
    { -0.432226022073, 0.243634161884, -0.868229843421 },
    { 0.224651378341, 0.638304998316, 0.736273378124 },
    { -0.894026043313, 0.228496920087, 0.385365529579 },
    { -0.226664685870, 0.950391740838, 0.213022672799 },
    { 0.539176714165, -0.275689018147, 0.795791452690 },
    { -0.418666694707, -0.546060295122, 0.725628246993 },
    { 0.899547902517, -0.217278073292, -0.378950933424 },
    { 0.558335201889, 0.495049501192, 0.665723511453 },
    { 0.984039137447, 0.087333861681, -0.155047646152 },
    { 0.509228572781, 0.852744132034, 0.116248466422 },
    { 0.299756289094, 0.449655741324, -0.841401141812 },
    { 0.797058351428, -0.092798417336, 0.596729786552 },
    { -0.082483305032, 0.340692688165, 0.936549516375 },
    { 0.415304305040, -0.166967864618, -0.894228195932 },
    { 0.367893121328, 0.711161780123, -0.599085614726 },
    { -0.975697983865, 0.219039838697, 0.005915517406 },
    { 0.813967510943, -0.547632670707, -0.193792025388 },
    { -0.045214427347, 0.990627290133, -0.128892310104 },
    { -0.395132930721, 0.909403372382, -0.129828630739 },
    { -0.667975379128, -0.628337960730, -0.398748416905 },
    { 0.085523475709, -0.304955797044, -0.948518685610 },
    { -0.075472798926, -0.882148027613, -0.464885699931 },
    { 0.555860572853, -0.751814855348, -0.354673718826 },
    { 0.329097647488, -0.028673434142, 0.943860462458 },
    { 0.606665083993, 0.724305053338, -0.327627327268 },
    { 0.335999887557, 0.922388160150, -0.190536499329 },
    { 0.926952718148, 0.357489049308, 0.113843040821 },
    { 0.011595399821, 0.870907926952, 0.491309402999 },
    { 0.762455022348, 0.646824059432, -0.016762309986 },
    { -0.001335488893, 0.671027568864, -0.741431195927 },
    { -0.127275817029, 0.643691999650, 0.754626713008 },
    { -0.689950034255, 0.371740022048, -0.621110542689 },
    { -0.590640696880, -0.721308198178, 0.361743072401 },
    { -0.260208797223, 0.842476146722, -0.471725899281 },
    { 0.487339914471, -0.783390399491, 0.385745109819 },
    { -0.375644751676, 0.762622426914, 0.526590974577 },
    { 0.155941322446, -0.356910524936, 0.921030499573 },
    { -0.451681325596, -0.121838451318, -0.883820893557 },
    { -0.907020132329, 0.120825612998, -0.403380280620 },
    { 0.380447160399, -0.505331503839, -0.774532135791 },
    { 0.888324545697, -0.314443042167, 0.334671592380 },
    { 0.606472804357, 0.149699629888, 0.780884599916 },
    { -0.374490888612, 0.094492369084, 0.922403255920 },
    { -0.833090468932, -0.105135589519, 0.543053200332 },
    { -0.565101083746, -0.186835569315, 0.803587727126 },
    { 0.251653302518, -0.956145086365, 0.149857229227 },
    { -0.712558884453, -0.436976136488, 0.548918657296 },
    { -0.081225777344, -0.960886648341, 0.264762576916 },
    { 0.970513251978, 0.027279182872, 0.239499214858 },
    { -0.838591971307, 0.519736829610, 0.163208864973 },
    { -0.567834855077, 0.790855999096, 0.228276950334 },
    { 0.862559694143, 0.417635490383, -0.285607022343 },
    { -0.413376875518, -0.867993891092, -0.275147530996 },
    { -0.049288497126, -0.626777786168, 0.777637608927 },
    { -0.681027166780, 0.528305660104, 0.507045488698 },
    { -0.270947275498, -0.807773004285, 0.523536385983 },
    { -0.255226031478, -0.419998893241, -0.870896436169 },
    { -0.682141331926, 0.187571065723, 0.706753350598 },
    { 0.006402943424, -0.642569685469, -0.766200497019 },
    { 0.093075065458, 0.886414054704, -0.453439252616 },
    { -0.399431814167, -0.910090584499, 0.110405406740 },
    { -0.092530442649, -0.989904568285, -0.107364160093 },
    { -0.983080757461, -0.116181578787, -0.141612376087 },
    { 0.648988121490, 0.463212162726, -0.603530372448 },
    { 0.346538800170, -0.602555926161, 0.718913914057 },
    { 0.842688021996, 0.138616839213, -0.520252121063 },
    { -0.583003036128, 0.677201320844, -0.448894008551 },
    { 0.207106772922, 0.116225101436, -0.971389988833 },
    { -0.682351758372, -0.730776448080, -0.019022638586 },
    { 100, DUMMYVAL, DUMMYVAL },
    { 0.231680914182, 0.115922169480, 0.965860240732 },
    { -0.024253081763, -0.178521125154, 0.983637126129 },
    { 0.929444787231, -0.342597629349, -0.136964418202 },
    { -0.922374824652, 0.377900824841, -0.080097749237 },
    { 0.998267688749, -0.018171715476, 0.055959006041 },
    { 0.150770937637, 0.899367734580, 0.410372760256 },
    { -0.435084119263, -0.336720796204, -0.835057431898 },
    { -0.500205939696, 0.240736490211, 0.831769174816 },
    { -0.890106539553, -0.390700416151, -0.234656201844 },
    { 0.723670139680, -0.609626845000, -0.323506783222 },
    { -0.117938187852, -0.514885836799, -0.849107271733 },
    { -0.038943002073, 0.214996001146, -0.975838184373 },
    { -0.431714913422, 0.640248962322, -0.635376659766 },
    { 0.181865442560, 0.981878481765, 0.053287970967 },
    { -0.784466635694, -0.461423285229, 0.414367770625 },
    { -0.158057207472, 0.957910477335, 0.239636050247 },
    { -0.660683839545, 0.312845560806, -0.682366850930 },
    { 0.473283590005, 0.360501127402, 0.803767118371 },
    { 0.318537965044, -0.753810808793, 0.574719783349 },
    { -0.798719883316, 0.249254177740, 0.547648521293 },
    { 0.123356231320, -0.534095863238, 0.836376021336 },
    { 0.246685773982, 0.416843104779, -0.874864535179 },
    { -0.671598223749, -0.043804117963, -0.739619513741 },
    { -0.262375077822, -0.909823633549, 0.321528030463 },
    { -0.101866153495, -0.790940491528, -0.603354311854 },
    { 0.243867201957, -0.367892714117, -0.897320309984 },
    { -0.586553136919, -0.392085416042, 0.708677955137 },
    { -0.591565025595, -0.741070728142, 0.317592500515 },
    { -0.705145651169, -0.410671032143, -0.578030201630 },
    { 0.773658529144, -0.630437574870, 0.063253019491 },
    { -0.586632874152, 0.748283675058, 0.309731194110 },
    { 0.497126662846, 0.760141772494, -0.418389252726 },
    { 0.681196772321, -0.593637313548, 0.428445676070 },
    { 0.393160045105, -0.811550532672, -0.432216279023 },
    { 0.367687425673, 0.670363487378, 0.644529868813 },
    { -0.967821758742, 0.138627218759, 0.210008422509 },
    { -0.657427127521, -0.685687239067, -0.312446126846 },
    { 0.556027328293, -0.200244677107, -0.806681894852 },
    { -0.684160630478, -0.053113982599, 0.727394759780 },
    { -0.792499038532, -0.608556824207, 0.040048291311 },
    { 0.476579568120, -0.840855082921, 0.256582627580 },
    { -0.359579943478, 0.359501430140, -0.861081288832 },
    { 0.907757935094, 0.325872368526, 0.264164211630 },
    { 0.763729774882, 0.632884063174, 0.127179375448 },
    { -0.131839070862, 0.978062850269, -0.161280874002 },
    { 0.952526166736, 0.003620005194, -0.304435210260 },
    { 0.191159826953, 0.927523352305, -0.321182738465 },
    { -0.072295789581, -0.177036691038, -0.981545377879 },
    { 0.070233326904, -0.940175356266, -0.333373033197 },
    { 0.102098471640, -0.939931308341, 0.325737682328 },
    { 0.114866291182, 0.451008443026, 0.885097237296 },
    { -0.305336116319, 0.793815303800, 0.525953533617 },
    { -0.880100470841, -0.109160024424, -0.462068447628 },
    { 0.811175301523, -0.303533825127, -0.499861828111 },
    { -0.502129353412, -0.864726024238, -0.010724525487 },
    { 0.581220995674, -0.012459095228, 0.813650370327 },
    { -0.377417110665, -0.119757738272, 0.918267068288 },
    { -0.055770089214, -0.775849617867, 0.628448142335 },
    { 0.532953630370, 0.191528929771, -0.824182684201 },
    { 0.556006277048, 0.507558832764, -0.658210491535 },
    { -0.453647258753, 0.829656001766, -0.325384516164 },
    { 0.004682131802, 0.730439698706, 0.682961143987 },
    { 0.778598753375, 0.034043065753, -0.626597997856 },
    { -0.124639125249, 0.843617941683, -0.522277566938 },
    { -0.147378598320, 0.184666838236, 0.971688071149 },
    { -0.263582914517, 0.516716553180, 0.814572311612 },
    { -0.880256593113, 0.239326343942, -0.409720918890 },
    { 0.217389797051, 0.724694636567, -0.653880233582 },
    { 0.533050840406, -0.839029816069, -0.109021875285 },
    { -0.886535332504, -0.120126330552, 0.446793877453 },
    { -0.719396097886, 0.569856867757, -0.397155391020 },
    { 0.756610189753, 0.611270828160, -0.232140034037 },
    { -0.992171102710, -0.006772464792, -0.124702191911 },
    { 0.912947971222, -0.015010115822, 0.407799826219 },
    { 0.326732494334, -0.235331362356, 0.915349674735 },
    { -0.233774700949, -0.465649792914, 0.853533631180 },
    { 0.941362217867, 0.322759373027, -0.098303417520 },
    { -0.583415932714, 0.536068025013, 0.610128611044 },
    { 0.751061243899, -0.256582440016, 0.608335811365 },
    { 0.213091292917, -0.672850480400, -0.708423836350 },
    { -0.372871117982, 0.013730617860, -0.927781547299 },
    { 0.757274120262, 0.225573766215, 0.612904872535 },
    { 0.484677187998, 0.821437646309, 0.300546529944 },
    { 0.259862089054, 0.004338555212, -0.965635993328 },
    { 0.222770667837, -0.974800908324, -0.011679840806 },
    { -0.830642828609, 0.486386494344, 0.271036287978 },
    { -0.328248193938, -0.885152697655, -0.329784512994 },
    { -0.726328689988, 0.685377343649, -0.052005104690 },
    { -0.083908141717, 0.587393250363, -0.804940117761 },
    { 0.495853808891, -0.478630813184, 0.724597505433 },
    { -0.954273367254, -0.273952553549, 0.119634188063 },
    { -0.435866748185, 0.899530390599, 0.029415203799 },
    { 0.505067526765, 0.860814276838, -0.062494593358 },
    { 0.546295883970, -0.528571970352, -0.649748012167 },
    { -0.144745446849, -0.989374514793, -0.013668397629 },
    { 0.905179719991, -0.345500245963, 0.247546469490 },
    { 0.676132849757, 0.552946673103, 0.486923347339 },
    { -0.403028587220, -0.682673181046, 0.609528740720 },
    { -0.434877489035, -0.650227082127, -0.622965738384 },
    { 0.815013295539, 0.345950099582, -0.464835300612 },
    { 101, DUMMYVAL, DUMMYVAL },
    { -0.509171857080, 0.860663704296, -0.001417062341 },
    { 0.900245123345, 0.403434911199, 0.163703971608 },
    { -0.743540133202, -0.660968002185, -0.101337902113 },
    { 0.675577477098, 0.666863650011, 0.314464536525 },
    { -0.678950405748, 0.096833703521, 0.727770279963 },
    { -0.571226480693, -0.713948056773, -0.404942563810 },
    { -0.185734988279, 0.981924321379, 0.036429949391 },
    { -0.314386625558, 0.879295594662, 0.357771305276 },
    { 0.035348366976, -0.855089249006, 0.517274462145 },
    { 0.695315759748, 0.360508512721, -0.621747220743 },
    { 0.786986352179, -0.165385867111, -0.594390441077 },
    { -0.427828375305, -0.095969593427, 0.898750643072 },
    { -0.944982871268, 0.298042552086, -0.134825851213 },
    { 0.078287005966, 0.958490005076, 0.274167931869 },
    { 0.678450030581, 0.621046717867, -0.392436657604 },
    { -0.125864268917, -0.287772832283, 0.949391901593 },
    { 0.318895475604, -0.672946142115, 0.667419782035 },
    { -0.053818651020, -0.618267500149, 0.784122982103 },
    { -0.834031347685, 0.233636633002, -0.499805597006 },
    { 0.795958552105, 0.327599647971, 0.509046612777 },
    { -0.040349096275, -0.112659648812, -0.992814058099 },
    { 0.609051380231, 0.063325317035, -0.790598710131 },
    { -0.948850480216, -0.314336368893, -0.029587385568 },
    { -0.295306277938, 0.122732761503, -0.947486607538 },
    { 0.815166616293, -0.551147235054, 0.178157550988 },
    { 0.463170214096, -0.076439077416, 0.882966828493 },
    { 0.132052724466, 0.855318160179, -0.500991938886 },
    { -0.224127602248, 0.747729838965, -0.625033523766 },
    { 0.600293327154, -0.798819832770, 0.039176474410 },
    { -0.441971993419, 0.337032200438, 0.831306232926 },
    { 0.584522023061, -0.370897088775, 0.721643509009 },
    { 0.114683084571, -0.975760657280, 0.186383823918 },
    { -0.888227753637, 0.397243193787, 0.230758104210 },
    { 0.189321127963, 0.297785399270, 0.935671612527 },
    { 0.935307270637, -0.226041233235, -0.272223566891 },
    { 0.843884918311, -0.289272391435, 0.451862510285 },
    { -0.336207619830, -0.650735760102, -0.680813782831 },
    { -0.994736170371, 0.028645457278, 0.098383886554 },
    { 0.411804355811, 0.655108486757, -0.633443006997 },
    { 0.056272507390, 0.265871278460, -0.962364727223 },
    { 0.695140314168, -0.497675280745, -0.518747779324 },
    { 0.544008021437, 0.557801018722, 0.626827963739 },
    { 0.532397494701, -0.774472076834, -0.341681005970 },
    { -0.043509487904, 0.802111475060, 0.595587194322 },
    { 0.339710900339, 0.817489090440, 0.465089336798 },
    { -0.601668508873, 0.197098322792, -0.774046030016 },
    { -0.815198692614, -0.534275535209, 0.223608461462 },
    { -0.700447313748, -0.253445564213, 0.667187310014 },
    { -0.780536841757, -0.110239599036, -0.615312497406 },
    { -0.615081980013, -0.432953970839, -0.658957522909 },
    { -0.701157600758, 0.438163026343, 0.562486605392 },
    { -0.169485968078, 0.147786151712, 0.974388916186 },
    { -0.173414899856, 0.933279296557, -0.314510774260 },
    { -0.775944807621, 0.630623097113, -0.014972137885 },
    { 0.436555798077, 0.855758917655, -0.277661142438 },
    { 0.239401838498, -0.398106110895, 0.885549707352 },
    { -0.213136505098, -0.402336948598, -0.890335784964 },
    { 0.525728836159, 0.262536006711, 0.809125476061 },
    { 0.811618151715, -0.555238620269, -0.181620622089 },
    { -0.069669995540, -0.988838269517, -0.131700297871 },
    { -0.547942520491, 0.532364957833, -0.645249212250 },
    { -0.399830222649, 0.657621182481, 0.638490542929 },
    { 0.148830548006, 0.981971172709, -0.116542198148 },
    { 0.083763853879, 0.604875013478, -0.791902667538 },
    { 0.308433405774, -0.944992046882, -0.108898418407 },
    { -0.258845187722, 0.459826855768, -0.849445955613 },
    { 0.020125736159, -0.692578053473, -0.721062129495 },
    { 0.402289150998, -0.851391784994, 0.336593920674 },
    { 0.171801133885, -0.406234789744, -0.897472933295 },
    { -0.321900103433, -0.770412460724, 0.550313514073 },
    { -0.759033319762, 0.546277845960, -0.354187710832 },
    { -0.400963645791, -0.468169461040, 0.787429686069 },
    { 0.385580484435, 0.357882375304, -0.850439824720 },
    { -0.559179213180, -0.798450404033, 0.223149187422 },
    { 0.946632406344, 0.051749941792, 0.318133668108 },
    { -0.484295814579, -0.165863520034, -0.859038332500 },
    { -0.237789845564, -0.944653262398, 0.226022572296 },
    { 0.894563258411, 0.130273047656, -0.427534220566 },
    { 0.303705845799, -0.026346174314, -0.952401511090 },
    { -0.887299868598, 0.113231835307, 0.447076609386 },
    { -0.429843588699, -0.895893999145, -0.112287272435 },
    { 0.168443605732, -0.881385973162, -0.441345123460 },
    { 0.889750317569, 0.409126721320, -0.202385024863 },
    { -0.901025451981, -0.229979455250, 0.367780620812 },
    { 0.429843638412, 0.895893976262, 0.112287264699 },
    { -0.209090312806, -0.875491284595, -0.435656116322 },
    { 0.631372427575, -0.618081663540, 0.468341664700 },
    { -0.121039482552, 0.513452835636, 0.849538480141 },
    { 0.994270012439, 0.091698513666, -0.054941104437 },
    { 0.965572460193, -0.245047575723, 0.087301258578 },
    { 0.753859472646, -0.007749596230, 0.656989984140 },
    { 0.380123925234, -0.645116936149, -0.662819689024 },
    { -0.956871393726, -0.050861666004, -0.286024870948 },
    { -0.835331903886, -0.409066079993, -0.367267685142 },
    { 0.220202494781, 0.609556448061, 0.761545663713 },
    { -0.629889435009, -0.574016385639, 0.523205971566 },
    { 0.131137150464, -0.049311298254, 0.990137083253 },
    { 0.506581177953, -0.314698350189, -0.802708202607 },
    { -0.499434582785, 0.790070452197, -0.355462766100 },
    { 0.711534317071, 0.701776435833, -0.035053526793 },
    { -0.635400378028, 0.700402672603, 0.325119140950 },
    { 102, DUMMYVAL, DUMMYVAL },
    { -0.507155132111, 0.078324583123, 0.858288373248 },
    { 0.152391546186, 0.975598685083, -0.158063349056 },
    { 0.462428618041, 0.826148519624, -0.321929179695 },
    { -0.543784098426, 0.419745011991, 0.726713822084 },
    { 0.714455465677, 0.692113613598, -0.102626182993 },
    { 0.214106888208, 0.008207375934, 0.976775756969 },
    { -0.369272351067, -0.253782997757, 0.893997830415 },
    { -0.790736259174, -0.612156211554, -0.000970094675 },
    { 0.739516326001, -0.257429520670, 0.621969167616 },
    { -0.828057943270, 0.332280055970, -0.451563956702 },
    { -0.190999784371, 0.980693358458, 0.041947813369 },
    { -0.385354935070, -0.750973343037, 0.536228134347 },
    { -0.163977930407, -0.698909967658, -0.696158096590 },
    { 0.345999807852, -0.344945773046, 0.872523092316 },
    { 0.198649514105, -0.969475796178, -0.143718652828 },
    { 0.074669611227, -0.977106135754, 0.199218595092 },
    { -0.705335691322, -0.615811572952, -0.351109198350 },
    { -0.933935995608, 0.004200594961, -0.357415599981 },
    { 0.567675555089, -0.789832759152, -0.232182421223 },
    { 0.914006038453, 0.246452224667, -0.322264274514 },
    { -0.775716425941, 0.625644047281, 0.082665304861 },
    { 0.209727271297, -0.034550721954, -0.977149281986 },
    { 0.116422557082, 0.354157596743, 0.927910655652 },
    { 0.546208119119, -0.062001741403, 0.835351707170 },
    { -0.146127287493, 0.034127947919, 0.988676943709 },
    { -0.934590367165, 0.339826318685, -0.105161393727 },
    { -0.475750309597, 0.734112701911, -0.484499931694 },
    { -0.267832677025, 0.486209678684, -0.831784711011 },
    { 0.772697362448, 0.131339926423, 0.621038331984 },
    { 0.998245088048, 0.058622300964, 0.008376754558 },
    { -0.916335131540, -0.327538174716, -0.230322970652 },
    { 0.951155771259, -0.308586750361, 0.008770193986 },
    { -0.790468537394, -0.439368181263, 0.426749449541 },
    { -0.774301137575, -0.287280265768, -0.563850864370 },
    { -0.176718334186, -0.978252079697, -0.108597877192 },
    { 0.655571260121, 0.484567001005, 0.579155544254 },
    { 0.472867660432, 0.284012119735, 0.834106283133 },
    { -0.429669207861, 0.166346647048, -0.887532064115 },
    { 0.443541711991, -0.890449776257, 0.101832930273 },
    { -0.183788093563, 0.900836984216, 0.393337850370 },
    { -0.624922757385, -0.726805562426, 0.285000388998 },
    { -0.295477873483, -0.927841042369, 0.227604539449 },
    { -0.938064747992, -0.320554765058, 0.131450261212 },
    { -0.502208969386, 0.856952309609, -0.115839933199 },
    { -0.922414091990, -0.061816755624, 0.381222942152 },
    { 0.939749333389, -0.142708361222, -0.310653366363 },
    { 0.624031949310, -0.700999663855, 0.345229774954 },
    { -0.045473761849, -0.848475578513, 0.527277279664 },
    { 0.190120000668, -0.645593162893, -0.739637650050 },
    { 0.430144697817, 0.633608460210, -0.643051987083 },
    { -0.162961047554, 0.754613310183, -0.635611869834 },
    { -0.509644172234, 0.824386580762, 0.246271360835 },
    { -0.401347165879, -0.818338637570, -0.411390722672 },
    { -0.521535815119, -0.548680737162, -0.653413989914 },
    { -0.045615572089, -0.899313873243, -0.434918126749 },
    { 0.735062736238, 0.628748235105, 0.253689634487 },
    { -0.521890700267, -0.850153382804, -0.069780532254 },
    { 0.731833618612, -0.292009748991, -0.615751460545 },
    { 0.805387522304, 0.053028936624, -0.590371807251 },
    { 0.128166672617, 0.830689561265, 0.541782388820 },
    { -0.244927064913, 0.365814136281, 0.897881256387 },
    { -0.584697921090, 0.448497682176, -0.676001605143 },
    { 0.634614552954, 0.338435532708, -0.694784685625 },
    { 0.299468382702, -0.833528611201, -0.464272271487 },
    { -0.732839577848, 0.622271160156, -0.275181315460 },
    { 0.309369198061, -0.831272411283, 0.461819096110 },
    { -0.001611720713, -0.311262943933, 0.950322462162 },
    { 0.897614164875, 0.296313369928, 0.326323762263 },
    { 0.936845633246, -0.071468831686, 0.342363061040 },
    { 0.148019207302, 0.967174286168, 0.206553175830 },
    { 0.543171842132, -0.013235023228, -0.839517232744 },
    { -0.174633197814, -0.073798473582, -0.981864059592 },
    { -0.783317137311, 0.198967515287, 0.588919510847 },
    { 0.810844174154, -0.494301992106, -0.313364429763 },
    { -0.529293022281, -0.190253221780, -0.826832878015 },
    { 0.842288595775, -0.424472632575, 0.332224179767 },
    { 0.153382525709, 0.847759107638, -0.507718717621 },
    { 0.729370199188, 0.540891885888, -0.418873585127 },
    { -0.186666531900, -0.579149582504, 0.793562453090 },
    { 0.769193650588, -0.638734402657, 0.018960241477 },
    { 0.528950678439, -0.549245784579, 0.646946866367 },
    { 0.910690498250, 0.412835056668, -0.014492494047 },
    { -0.715926245535, -0.158741394661, 0.679890270982 },
    { 0.168915756483, -0.637585619561, 0.751632919011 },
    { -0.999938906948, 0.008638318836, 0.006896507714 },
    { 0.554187057729, -0.603650150756, -0.573134539648 },
    { -0.729070396905, 0.072780852151, -0.680558082691 },
    { 0.336016510616, 0.309042524451, -0.889710977045 },
    { 0.460182232490, 0.783009165621, 0.418484120910 },
    { -0.073274120947, 0.644817137296, 0.760816510500 },
    { -0.388871580631, 0.702580405958, 0.595952738849 },
    { 0.081091219547, -0.364726982098, -0.927576650548 },
    { -0.710583644180, 0.556860585141, 0.430089727080 },
    { -0.919175742256, 0.298523067461, 0.256904521255 },
    { -0.259495612020, -0.414412028601, -0.872309978100 },
    { 0.462475035296, 0.884434856996, 0.062384496942 },
    { -0.184849469592, 0.931029783773, -0.314665243267 },
    { 0.111176601820, 0.579650550737, -0.807245317260 },
    { -0.028731412421, 0.256424959596, -0.966137022392 },
    { 0.430112843794, -0.357786161708, -0.828849807923 },
    { 0.325499427639, 0.597810159271, 0.732579781375 },
    { -0.548945080476, -0.480787500175, 0.683741675120 },
    { 103, DUMMYVAL, DUMMYVAL },
    { 0.986749062313, -0.158684369435, 0.033846106439 },
    { 0.832374372678, 0.324298991767, -0.449425263696 },
    { -0.532032136997, 0.536168099176, 0.655336230212 },
    { -0.763213015117, 0.058702276236, -0.643474891756 },
    { 0.721325433241, -0.594471489752, 0.355377640310 },
    { 0.632504588183, -0.772048727180, -0.062279280560 },
    { -0.004295670985, 0.711783274665, -0.702386017172 },
    { -0.489956900041, -0.122981568661, -0.863028255547 },
    { -0.785756711409, 0.611428926304, 0.093493628417 },
    { 0.414021650744, -0.836497193238, -0.358968687241 },
    { -0.755881814324, -0.624752190822, 0.195773805290 },
    { 0.497988655784, -0.562285017345, -0.660183957681 },
    { -0.518680132751, -0.732666570952, 0.440647949841 },
    { 0.851930441290, 0.501425043655, -0.150955121801 },
    { -0.203191269064, 0.522680637795, 0.827960300407 },
    { -0.550164752808, 0.834396900417, -0.033174649073 },
    { 0.487564634413, -0.155996620843, 0.859037706713 },
    { -0.917016525209, -0.169186742506, -0.361187677882 },
    { 0.701447900300, -0.608798097827, -0.370588342028 },
    { 0.653856731194, 0.660040796774, 0.369888526001 },
    { -0.263381867171, -0.688783437609, 0.675431246035 },
    { 0.878049340048, 0.436535886589, 0.196126938895 },
    { 0.481530648484, 0.529592192932, 0.698326817297 },
    { 0.165791518176, -0.923453026969, 0.346045776572 },
    { -0.447942264784, -0.416612785700, 0.791063533612 },
    { -0.569874787847, 0.732231753141, -0.372933487190 },
    { 0.946310700734, 0.090767640784, 0.310253594762 },
    { 0.929083203864, -0.011529099576, -0.369691060428 },
    { -0.713077281012, 0.410360855705, -0.568440638422 },
    { 0.119489243224, -0.171501080486, 0.977910885585 },
    { -0.497003850136, 0.249449916934, -0.831120876824 },
    { 0.087008765265, -0.744475734807, 0.661955704749 },
    { -0.080436160384, 0.193164636923, 0.977863716039 },
    { 0.076216408159, 0.997076273659, -0.005473904863 },
    { -0.422677665552, 0.235624192896, 0.875114181559 },
    { 0.781858450837, -0.044583884050, 0.621859823544 },
    { -0.806537214879, 0.438276922991, 0.396750626702 },
    { 0.576563261638, 0.201250875757, 0.791879340769 },
    { -0.072981222991, -0.462482086643, 0.883619862059 },
    { -0.161294520227, 0.442479491141, -0.882154168876 },
    { -0.817847195439, 0.521384696379, -0.243482983584 },
    { 0.500286974332, -0.212070207505, -0.839487445054 },
    { -0.431488919456, -0.491700374869, -0.756338584061 },
    { 0.382333600080, 0.908633563148, 0.167946617028 },
    { -0.704136715443, -0.455747521669, 0.544504988460 },
    { -0.954736411695, 0.295776783223, 0.031535356202 },
    { 0.275183529543, 0.142627323133, 0.950753107681 },
    { -0.440291344077, -0.889069052166, 0.125298654471 },
    { 0.345589629510, 0.750190791196, -0.563721194190 },
    { -0.939929116233, 0.098639915008, 0.326807930787 },
    { 0.190097411974, -0.760428488284, -0.620976238006 },
    { -0.926954818683, 0.183703500102, -0.327120449024 },
    { 0.728802429455, 0.063344797144, -0.681787690924 },
    { 0.901887808361, -0.342557539891, -0.263159102054 },
    { 0.981519966523, 0.178599696090, -0.068707378591 },
    { 0.058461244131, 0.733377308891, 0.677303481269 },
    { -0.567466980070, -0.089769821329, 0.818487999734 },
    { 0.112404599988, 0.228774739493, -0.966968109335 },
    { 0.585480131777, 0.443328776445, -0.678728672792 },
    { -0.567021497167, 0.745251051426, 0.350838270573 },
    { 0.490162176129, -0.835254709619, 0.249179877101 },
    { -0.997976395092, -0.060669566622, -0.019034666387 },
    { -0.322810422035, -0.920972121649, -0.218182910815 },
    { 0.646806570150, -0.395833296713, 0.651887461165 },
    { 0.450510053018, 0.154354882076, -0.879326596043 },
    { -0.903808911540, -0.422390037355, -0.068673923459 },
    { -0.205341559917, 0.072842064919, -0.975975858999 },
    { 0.039004291516, 0.933905508520, 0.355385940069 },
    { 0.056360132904, -0.951279439572, -0.303135222742 },
    { -0.075217264158, -0.995980711980, 0.048629050334 },
    { 0.889013065566, -0.277141325711, 0.364483819717 },
    { -0.811556135414, -0.125165338414, 0.570710326814 },
    { -0.252256133862, 0.834462183539, -0.489938472844 },
    { 0.174697482063, 0.465002102704, 0.867901972715 },
    { -0.156923150039, -0.283760042047, -0.945967950577 },
    { -0.279126376429, 0.938640612545, 0.202588910017 },
    { -0.270628450346, 0.789034199950, 0.551529938601 },
    { 0.167220551283, -0.118483131967, -0.978774251126 },
    { -0.097942186858, -0.598981003957, -0.794750957805 },
    { 0.351492108800, 0.790970338278, 0.500818551389 },
    { 0.663809338774, 0.747743530996, 0.015387449753 },
    { -0.722692676359, 0.218487747714, 0.655727382101 },
    { -0.242246846752, -0.131036204162, 0.961325115888 },
    { 0.399801423793, 0.893622109414, -0.203956728499 },
    { -0.503314771070, -0.713833110241, -0.486946128382 },
    { -0.706170493040, -0.299390199788, -0.641629755412 },
    { 0.428674479267, -0.694113697398, 0.578311651197 },
    { -0.419535566399, 0.588181520228, -0.691398877485 },
    { -0.768108674344, -0.515873081939, -0.379320481557 },
    { 0.263817211807, 0.505743288737, -0.821355102651 },
    { -0.242062598886, 0.956647171716, -0.161962610091 },
    { 0.083502806793, 0.923229826286, -0.375065286468 },
    { 0.297422914375, -0.469793282773, 0.831164172391 },
    { 0.217996540477, -0.454060271372, -0.863890489762 },
    { 0.776117051188, 0.339663523151, 0.531291834960 },
    { -0.651604219335, -0.747469696546, -0.129232326027 },
    { 0.286327628147, -0.957794011862, -0.025438557370 },
    { 0.855694109526, -0.515807796414, 0.041592163696 },
    { -0.175967150320, -0.822353601411, -0.541082356259 },
    { 0.751100455590, -0.291263630713, -0.592464009908 },
    { 0.637334070258, 0.669366663857, -0.381776835606 },
    { -0.919406282031, -0.288959011538, 0.266823496366 },
    { -0.180493945033, -0.902385532050, 0.391308429955 },
    { 104, DUMMYVAL, DUMMYVAL },
    { -0.004195745353, 0.777996426614, -0.628254690310 },
    { 0.974027129578, -0.140058625755, 0.177917768075 },
    { -0.726746991074, 0.685508849679, 0.043777025673 },
    { 0.664611020310, 0.525035392349, -0.531629597054 },
    { -0.207111144406, 0.512007320951, 0.833638697012 },
    { -0.344499066170, -0.470347033992, 0.812461728959 },
    { -0.910686381319, -0.324409785038, 0.255751063050 },
    { -0.688818522606, -0.026598961083, -0.724445676490 },
    { 0.366499242621, 0.930360506229, -0.010374661764 },
    { -0.862016051737, 0.249598955583, 0.441167414843 },
    { 0.814222046417, -0.121674951104, -0.567659814855 },
    { -0.661414975393, -0.367377188129, -0.653883959100 },
    { -0.578537132702, -0.800511392864, -0.156449020388 },
    { -0.259262193572, -0.964829614969, -0.043438796741 },
    { 0.343786000901, 0.694313881824, -0.632249491175 },
    { -0.356902061355, 0.730622228395, 0.582075663446 },
    { -0.530330461756, -0.156422070212, 0.833235703318 },
    { 0.497022502501, 0.449130612860, 0.742462338843 },
    { -0.019374123524, 0.212849683558, 0.976892857762 },
    { -0.370057883706, 0.187542235082, 0.909881900450 },
    { -0.359982138894, 0.760417719905, -0.540534689850 },
    { -0.917887248086, 0.382761243322, 0.104770369910 },
    { -0.163975643934, 0.935560677212, -0.312790996436 },
    { 0.528337359513, 0.782503095984, -0.329467053465 },
    { 0.916070937719, 0.187798858306, 0.354324181908 },
    { -0.824087465672, -0.462508993320, -0.327055469334 },
    { -0.397856216216, 0.018464955697, -0.917261945482 },
    { 0.351450544218, 0.187653432971, 0.917207012655 },
    { 0.567180652325, -0.076961758492, 0.819989631251 },
    { 0.664859920998, -0.714792409529, -0.216871152369 },
    { 0.716542837892, 0.516155785764, 0.469200987092 },
    { 0.826881824621, -0.415266565343, -0.379236242756 },
    { -0.194843757468, -0.918737800520, 0.343448342654 },
    { 0.100750901649, 0.505396257180, -0.856985343541 },
    { 0.002480298109, -0.779100553179, -0.626894070922 },
    { 0.827380482304, -0.446808839973, 0.340298983284 },
    { 0.513477521653, 0.007670321091, -0.858068762356 },
    { 0.202537717170, 0.924688398074, 0.322381512484 },
    { -0.841262941669, -0.116994310330, 0.527815303231 },
    { -0.553221983546, 0.458107810632, 0.695760498131 },
    { 0.071480441376, -0.993339112510, 0.090376734055 },
    { 0.041210562964, -0.959737750584, -0.277858128556 },
    { 0.911133650909, 0.183921693724, -0.368793005301 },
    { 0.150651954701, 0.514657585653, 0.844056608336 },
    { -0.197323346605, -0.139637278788, 0.970342685476 },
    { -0.268581625683, 0.543763235643, -0.795100908004 },
    { -0.317905274059, -0.633589319128, -0.705337374178 },
    { -0.067921828088, -0.124563691504, -0.989884090198 },
    { -0.355023557548, 0.934751359911, -0.014077241611 },
    { -0.839702601200, 0.486245203796, -0.241795664403 },
    { 0.893701967989, -0.448032202905, -0.023747369816 },
    { -0.717888229779, -0.605427201355, 0.343648648191 },
    { 0.358719730368, -0.363891900564, 0.859594578710 },
    { 0.719150565009, 0.208901087215, -0.662708684573 },
    { 0.582110151810, -0.321893302792, -0.746680971217 },
    { 0.691165459541, -0.710688296894, 0.131196235448 },
    { 0.541339218272, -0.692435690041, 0.476953525951 },
    { 0.322543519504, -0.823349120310, -0.466970988511 },
    { -0.640148455409, 0.547409588776, -0.539029402866 },
    { 0.263122745083, -0.247899131946, -0.932369262364 },
    { 0.003142571379, -0.447192325239, 0.894432305148 },
    { -0.974027164594, 0.140058679503, -0.177917534066 },
    { 0.384279236186, -0.914048399667, -0.129788257180 },
    { -0.576809151061, -0.664457586755, -0.475170831025 },
    { 0.859669018425, 0.487688580583, 0.152082303797 },
    { 0.352264224255, 0.726316282075, 0.590232644558 },
    { -0.433784427059, -0.715017887330, 0.548252215352 },
    { 0.580847650273, -0.604121168704, -0.545576411418 },
    { 0.015513599655, 0.999879068169, -0.001085017484 },
    { -0.002480094741, 0.779100574235, 0.626894045558 },
    { -0.036636891093, -0.476957934512, -0.878162209912 },
    { 0.677237841304, 0.735526752175, -0.018689653296 },
    { -0.970070438676, -0.226011766613, -0.088780771335 },
    { 0.840063473741, 0.493799065880, -0.224623780177 },
    { -0.891885709356, -0.122527761225, -0.435346791853 },
    { -0.501060803293, 0.819448382631, 0.278284781486 },
    { -0.155263635193, 0.934049464618, 0.321628358877 },
    { -0.510832637690, -0.838527759774, 0.189528922223 },
    { 0.161330659812, -0.104703351300, 0.981330538825 },
    { -0.144476814114, 0.253454753314, -0.956497327862 },
    { 0.146469669487, -0.879535988337, 0.452728485011 },
    { 0.287328092130, -0.577636182408, -0.764054322837 },
    { -0.569426156232, 0.782326634765, -0.252426007249 },
    { 0.268949258734, -0.659275337024, 0.702155485786 },
    { 0.723952699872, 0.192266773901, 0.662514887381 },
    { 0.838564970153, -0.128893323177, 0.529334773157 },
    { -0.680013845124, 0.136525633942, 0.720376236225 },
    { 0.197323804365, 0.139637116196, -0.970342615787 },
    { 0.194843123857, 0.918737820580, -0.343448648450 },
    { -0.540139780131, 0.315631022358, -0.780144906825 },
    { 0.982392521300, 0.186575488764, -0.009722195589 },
    { 0.434837478375, 0.384213571991, -0.814430045184 },
    { -0.983071230649, 0.026632770049, 0.181277828293 },
    { -0.719987725622, 0.566014022349, 0.401554232275 },
    { 0.639701132688, -0.406921535306, 0.652071564280 },
    { -0.811976596034, -0.583689984692, 0.000096250221 },
    { -0.282716206232, -0.871070772319, -0.401630746265 },
    { -0.380338464799, -0.323867955955, -0.866286441831 },
    { -0.100038026972, -0.729363346928, 0.676772857994 },
    { 0.971208043861, -0.131340045943, -0.198757963040 },
    { 0.549281365421, 0.779808530932, 0.300314229909 },
    { -0.664978764635, -0.409523504433, 0.624574848918 },
    { -0.826701858338, 0.233600719548, -0.511854218746 },
    { 0.400632126182, -0.890517340285, 0.215575430239 },
    { 105, DUMMYVAL, DUMMYVAL },
    { -0.111844648954, -0.300308057122, 0.947262289616 },
    { -0.442610183957, -0.232172987380, 0.866136206949 },
    { -0.574052002893, 0.796510172715, -0.189831090016 },
    { 0.443457208963, -0.311608137720, 0.840384478870 },
    { 0.952997600609, -0.035142075421, -0.300932895791 },
    { -0.533161125826, 0.104010488456, 0.839595755229 },
    { -0.742687789893, -0.050661568581, -0.667718692424 },
    { -0.912216892627, -0.231020955303, -0.338363205767 },
    { -0.806299375338, 0.589687044381, 0.046373559469 },
    { -0.481162319745, 0.100485080918, -0.870853357673 },
    { -0.161625285069, -0.056138074568, -0.985254172186 },
    { 0.826051513119, -0.555028529241, 0.097888862509 },
    { 0.400956230434, 0.653994813834, -0.641502053585 },
    { 0.789928486289, -0.332926351531, -0.514949542194 },
    { -0.510210332029, -0.845700051539, -0.156450758767 },
    { -0.254649815795, 0.902836847145, 0.346466591107 },
    { 0.259414160285, -0.767271431516, -0.586514146311 },
    { 0.501109341687, 0.034144336875, -0.864710120175 },
    { -0.935574324389, -0.103002688717, 0.337773784745 },
    { -0.221193028930, -0.588981991745, 0.777286213278 },
    { 0.543866508472, -0.298204534132, -0.784399946957 },
    { -0.446470766380, 0.439048526025, -0.779679579419 },
    { 0.633336617604, 0.566835292318, 0.526860968553 },
    { -0.098068549596, -0.399539316669, -0.911455371379 },
    { 0.369647557894, 0.859085860693, -0.354022833869 },
    { 0.780251260903, -0.000535362855, -0.625465972892 },
    { 0.554446428089, -0.830911523561, 0.046639022206 },
    { 0.926528517964, 0.055613224842, 0.372091486898 },
    { -0.926902026587, -0.372165823374, 0.048427605979 },
    { -0.941495592467, 0.233122711105, 0.243392380598 },
    { 0.560682182574, -0.597492798864, -0.573269435300 },
    { 0.181205879267, -0.115144582786, 0.976681193826 },
    { -0.772951971695, 0.498967295668, 0.391888871118 },
    { -0.211258365081, 0.685757729750, -0.696495685034 },
    { 0.042395296138, 0.846021029726, 0.531461246119 },
    { 0.984866022613, -0.157021797712, 0.073369425138 },
    { 0.084655753694, 0.554403618999, -0.827931175042 },
    { 0.145981450133, -0.515481633423, 0.844374384867 },
    { 0.059712931662, -0.796157237581, 0.602136212863 },
    { -0.562018896569, 0.811068067459, 0.162183075099 },
    { -0.739243892779, -0.172009090477, 0.651100099664 },
    { 0.432472467024, 0.386015548504, 0.814837138070 },
    { 0.674765963072, 0.331921349501, -0.659180637477 },
    { 0.208537268955, -0.978014420492, -0.000027701598 },
    { 0.909295760157, -0.370092606233, -0.190296304146 },
    { 0.375222946271, 0.859254028625, 0.347692759319 },
    { -0.456381552573, -0.249513232934, -0.854083734221 },
    { -0.729393626446, -0.679748955368, 0.076982435501 },
    { 0.389093006659, -0.666933144590, 0.635457955191 },
    { 0.629547389728, 0.766661467868, -0.126096303567 },
    { 0.884192499473, 0.297224684964, -0.360362471026 },
    { -0.513135613629, 0.703015908384, 0.492402756476 },
    { 0.046218537790, 0.977839614159, -0.204189950161 },
    { -0.798664036240, -0.549321786233, -0.245726132893 },
    { 0.316793474353, -0.885906011047, 0.338839835613 },
    { 0.383894482035, 0.369205272657, -0.846352463992 },
    { 0.868613658516, 0.399010606305, 0.293770060244 },
    { -0.998505252372, -0.044708855121, -0.031438499639 },
    { 0.982617857875, 0.185548722177, 0.005815245707 },
    { -0.281261371917, -0.810489406430, 0.513808293755 },
    { -0.162710911203, 0.317284881553, -0.934267340387 },
    { -0.248635513508, 0.372972428828, 0.893908244037 },
    { -0.394327711324, -0.902391535503, 0.173767582520 },
    { 0.066521197421, 0.549824144934, 0.832627371603 },
    { -0.261052281992, 0.885867756560, -0.383523172643 },
    { -0.948651759667, 0.301035757074, -0.097145827724 },
    { 0.075811270734, 0.830479052424, -0.551867008178 },
    { -0.535015537682, 0.667033263282, -0.518483365320 },
    { 0.745211605644, -0.100666292697, 0.659185831407 },
    { -0.557721441379, 0.429649923374, 0.710174441367 },
    { -0.913757424958, 0.115647223409, -0.389452292396 },
    { 0.207971040333, -0.186365645911, -0.960216586197 },
    { 0.734528055883, 0.249322357882, 0.631115597161 },
    { -0.376907631652, -0.567011254643, -0.732419875694 },
    { -0.791950307135, 0.515924898989, -0.326552001421 },
    { 0.712827741786, -0.654759049540, -0.251330852834 },
    { 0.131965613991, 0.231556321077, 0.963829210438 },
    { -0.592842890456, -0.702257012627, 0.394173052671 },
    { -0.233274575064, 0.680409499883, 0.694712807639 },
    { 0.859529004390, 0.507070444469, -0.063948846421 },
    { 0.876215078352, -0.317774473928, 0.362307217964 },
    { 0.671775086533, 0.709806482765, 0.211879659570 },
    { -0.796204508433, 0.173062652648, 0.579747961626 },
    { -0.701538020260, -0.385830940737, -0.599148471832 },
    { -0.036790907664, -0.961297204653, 0.273045991437 },
    { -0.258437779331, -0.859334166183, -0.441310214073 },
    { 0.663487714430, -0.439197474133, 0.605714150004 },
    { -0.563258561565, -0.683930503439, -0.463658127601 },
    { 0.352636916146, 0.935730225398, 0.007493373620 },
    { -0.723500390697, 0.311800274583, -0.615895911199 },
    { -0.162802506111, -0.983120255737, -0.083485967466 },
    { -0.551098580788, -0.498058785218, 0.669498170812 },
    { 0.425252553561, -0.859631293707, -0.283185989359 },
    { -0.186536175921, 0.045521990910, 0.981392889426 },
    { -0.273706094140, 0.961510266913, -0.024144992256 },
    { 0.682029274724, 0.596640113646, -0.422914463229 },
    { 0.142810715091, 0.156248038502, -0.977339066097 },
    { 0.249012891263, -0.507831072332, -0.824681867122 },
    { 0.633269107640, -0.686047335005, 0.358202863531 },
    { 0.046883896713, 0.983199792148, 0.176408811992 },
    { 0.330564766069, 0.684090150791, 0.650190434430 },
    { -0.814869789106, -0.428708090908, 0.390123825974 },
    { -0.061228737603, -0.710225413405, -0.701306569088 },
    { 0.490166312434, 0.050834824218, 0.870145279135 },
    { 0.068632574499, -0.936019289072, -0.345191917928 },
    { 106, DUMMYVAL, DUMMYVAL },
    { 0.788565042821, 0.557993233507, 0.258473837365 },
    { -0.670704874059, -0.665031927114, -0.328462338530 },
    { 0.904248168507, -0.374711559287, -0.204759608049 },
    { 0.229092670741, 0.234161526301, -0.944820050493 },
    { -0.084728912625, 0.949613895069, -0.301752318395 },
    { 0.253064725760, 0.909212506640, -0.330591685232 },
    { 0.732963893870, -0.459258155516, -0.501842482134 },
    { 0.249232784254, -0.184948298379, -0.950619348730 },
    { 0.300930455510, -0.904680034862, -0.301653601784 },
    { -0.812424674086, 0.476777442372, -0.335632863976 },
    { 0.997794853045, -0.059090372988, -0.030228447825 },
    { -0.431553072245, -0.882633441415, -0.186333448235 },
    { 0.198765877372, -0.494583604173, 0.846096439229 },
    { 0.855898988320, 0.266938114934, 0.442923203939 },
    { 0.628269319542, 0.776893038943, 0.041410966716 },
    { 0.509995461128, 0.041742443651, -0.859163661957 },
    { -0.269196780833, 0.919336118965, 0.286974203641 },
    { -0.462432045156, -0.557019048745, 0.689845187667 },
    { -0.266634401182, -0.833345777666, -0.484190986031 },
    { -0.115734875326, -0.315054195626, -0.941990601042 },
    { 0.161775784405, -0.178056077778, 0.970631046663 },
    { 0.360263257688, 0.427988752020, 0.828876355860 },
    { 0.448782823739, 0.034801850123, 0.892962937834 },
    { 0.566899899858, 0.768051081816, -0.297862450237 },
    { -0.510839033899, 0.298670886663, -0.806126034132 },
    { 0.596504913717, 0.575549261048, 0.559396939586 },
    { 0.172569777008, -0.983614960383, 0.052165906250 },
    { 0.763818800515, 0.199022906845, -0.613979415397 },
    { -0.033504559444, 0.017809810683, -0.999279868275 },
    { 0.940752041828, -0.052436230563, 0.335016473508 },
    { 0.417754209600, -0.681060395964, -0.601363581713 },
    { 0.200115816742, -0.759570144589, 0.618875476440 },
    { -0.765673693807, 0.537845930683, 0.352796753755 },
    { -0.187841871094, -0.978223784789, 0.088281698762 },
    { -0.376214201894, -0.001286287165, -0.926531823392 },
    { -0.017013880985, 0.999185841393, 0.036581172937 },
    { 0.833274028087, 0.538588797989, -0.124805852414 },
    { 0.914385750921, -0.364389510288, 0.176405734896 },
    { 0.645813142897, 0.264982721411, 0.716037388560 },
    { 0.510838916490, -0.298670957701, 0.806126082214 },
    { 0.959212001798, 0.266567888571, 0.094095145406 },
    { -0.483897916303, -0.241368540009, 0.841180143900 },
    { -0.125857263364, -0.693769832485, 0.709114496251 },
    { 0.776402887086, -0.370466654442, 0.509855876568 },
    { 0.126396995698, 0.545295300608, -0.828659661510 },
    { -0.157840832535, -0.405306495778, 0.900451506781 },
    { 0.084520774210, -0.811361763310, -0.578401528149 },
    { -0.788759662716, 0.222097024650, -0.573176330734 },
    { 0.379827408487, -0.860695824041, 0.339018934928 },
    { -0.748842719193, -0.350131984361, 0.562709672424 },
    { 0.728039448062, -0.150486574969, -0.668814139220 },
    { -0.964167946602, 0.223797581536, 0.142459865380 },
    { -0.733793623643, -0.025034489363, 0.678911034115 },
    { 0.504927439973, -0.863117178040, 0.008775952135 },
    { 0.616102694441, -0.722498767035, -0.313708465833 },
    { -0.172470327151, -0.616993935904, -0.767836225578 },
    { 0.510268231099, -0.595528035441, 0.620461675960 },
    { -0.361662038982, 0.929283806168, -0.075047832435 },
    { -0.332453979393, 0.556658995767, 0.761318011095 },
    { -0.258700087690, 0.609565864346, -0.749335520080 },
    { 0.016742028543, 0.794427636305, -0.607128022048 },
    { 0.461014594979, 0.818508584642, 0.342796207801 },
    { -0.047241117675, -0.968476340295, -0.244585067186 },
    { -0.180676362891, -0.064586484422, 0.981419705285 },
    { -0.457100115408, -0.333695696506, -0.824443246456 },
    { 0.492501248452, -0.378130692632, -0.783874798397 },
    { -0.845650044978, 0.533654150860, 0.009447152953 },
    { -0.909308325369, -0.087552578720, -0.406808204655 },
    { 0.116671366134, 0.927882948463, 0.354148311130 },
    { -0.895627919473, -0.395760669459, -0.203037243800 },
    { 0.322187368680, 0.946576070715, 0.013749247709 },
    { 0.260606405165, 0.730350998202, 0.631404562078 },
    { -0.665515665706, -0.636671752006, 0.389535593877 },
    { 0.167956616734, -0.532420682033, -0.829649800963 },
    { -0.993198483222, -0.115258835575, -0.016497689163 },
    { -0.000087664061, -0.924255175820, 0.381775277205 },
    { -0.582837233741, 0.562012266142, -0.586892640668 },
    { 0.928301647074, 0.245208062087, -0.279515756851 },
    { 0.917608357816, -0.082436141844, -0.388843392876 },
    { 0.381730890662, 0.696219531098, -0.607914378537 },
    { -0.959134557951, 0.192670188762, -0.207217513995 },
    { -0.193642063675, 0.289702800061, 0.937323337388 },
    { -0.931577046894, -0.100939978393, 0.349249662079 },
    { -0.503326594840, -0.849943022901, 0.155753641206 },
    { -0.624355914506, 0.747761186361, -0.225904626321 },
    { -0.750451575331, -0.365451614483, -0.550697331168 },
    { 0.496418499412, 0.405709981096, -0.767442561161 },
    { 0.712365812257, 0.512528415192, -0.479426295845 },
    { -0.497786196464, -0.609036406831, -0.617481625447 },
    { -0.601132591411, 0.785684715195, 0.146079210887 },
    { 0.776156914844, -0.630280269524, -0.018089372256 },
    { -0.750714706135, -0.660580556223, 0.007794788803 },
    { -0.852981954355, 0.223536611802, 0.471649412943 },
    { -0.116253850785, 0.796705963255, 0.593080644004 },
    { -0.891824720430, -0.407604588139, 0.196232432995 },
    { 0.752738555571, -0.061730253871, 0.655418982571 },
    { 0.029205005873, 0.550827359203, 0.834108079319 },
    { -0.162744987850, 0.334216699023, -0.928338982820 },
    { -0.334392488754, -0.823533211303, 0.458229978663 },
    { -0.486608217203, 0.130530952233, 0.863813702982 },
    { -0.487183924049, 0.721654039720, 0.491800031623 },
    { -0.679478860452, -0.061043261012, -0.731151282898 },
    { -0.358653232759, 0.810639963598, -0.462850632548 },
    { 0.135027743633, 0.184947749174, 0.973427880495 },
    { 0.680725242119, -0.661892141242, 0.313866114936 },
    { -0.623597881816, 0.395315692841, 0.674426559966 },
    { 107, DUMMYVAL, DUMMYVAL },
    { -0.494482351835, -0.562247733258, -0.662845902280 },
    { -0.887425308329, 0.404017790239, 0.221914279188 },
    { -0.612988085421, 0.387949737890, -0.688288172209 },
    { 0.825968294436, 0.383802859766, -0.412882236748 },
    { -0.675142442318, -0.675487902918, 0.296477276687 },
    { -0.157229518524, -0.713907564233, -0.682359779175 },
    { 0.431870777416, 0.732670966710, 0.526004644614 },
    { -0.556752413423, 0.818384392689, -0.142385869914 },
    { -0.339438035692, 0.608871901593, -0.716977564067 },
    { -0.825586679173, -0.078988940977, 0.558719412922 },
    { 0.674053443052, -0.194361714069, -0.712653829017 },
    { 0.363732331615, 0.340463253041, -0.867054533618 },
    { 0.111998337966, -0.189905836222, -0.975393328694 },
    { 0.853883256721, -0.134024006886, 0.502912467006 },
    { -0.503394189424, 0.112153541891, -0.856747263255 },
    { -0.942201422140, -0.032016553276, -0.333513748493 },
    { -0.113335843695, -0.878419428643, 0.464256711224 },
    { -0.416297076718, -0.715641289755, 0.560851395928 },
    { 0.492689214913, -0.869917796978, -0.022368817799 },
    { 0.613105958190, -0.293763794391, 0.733351155407 },
    { 0.474316881390, 0.876740884998, -0.079680089117 },
    { 0.245851426145, -0.722400746486, -0.646292687362 },
    { 0.592579008969, 0.484149989380, -0.643777062277 },
    { 0.558279782167, 0.401496087585, 0.726033454104 },
    { -0.357195331697, 0.827453081637, -0.433281539767 },
    { -0.957794863093, 0.062107431637, 0.280662906646 },
    { 0.575942948949, -0.568515811997, -0.587434669615 },
    { 0.679147363924, 0.157242800652, -0.716961337673 },
    { -0.646387258187, 0.624438393221, -0.438474863047 },
    { -0.078029142581, -0.659933304217, 0.747261324366 },
    { 0.074094592660, 0.819522115789, 0.568237180297 },
    { 0.386499800008, -0.845873868732, -0.367580335151 },
    { 0.647230484218, 0.049071313577, 0.760713287962 },
    { 0.251500395806, 0.573504449905, 0.779641069242 },
    { -0.829049868754, -0.558815053327, 0.020051216743 },
    { -0.985597108110, -0.167728299149, 0.021576796569 },
    { -0.214586343729, -0.053619846757, -0.975232081670 },
    { 0.595818897127, 0.708704011068, -0.377807446356 },
    { -0.247952725975, -0.956008893007, -0.156736856459 },
    { -0.001129357868, -0.902068387587, -0.431591645734 },
    { -0.534870755967, -0.229692124805, -0.813114261475 },
    { -0.785929920345, 0.296591874387, 0.542537943700 },
    { -0.033635316164, 0.776528014930, -0.629184319207 },
    { 0.308003198395, 0.677079051901, -0.668354686716 },
    { 0.958192599449, 0.255556176047, -0.128677827327 },
    { -0.363882962222, -0.460765769111, 0.809496198769 },
    { 0.415384657676, -0.013173753729, -0.909550459502 },
    { 0.246274023872, -0.502433546990, 0.828800118259 },
    { 0.787061161628, 0.606943914536, -0.110244330764 },
    { 0.213525792406, -0.793445965734, 0.569956345204 },
    { -0.592218625173, -0.196287478690, 0.781503887199 },
    { 0.040722582586, 0.516343887087, -0.855412568025 },
    { 0.034604061223, -0.002746738352, 0.999397325579 },
    { 0.941808614667, -0.281699386829, 0.183417525878 },
    { 0.132963633184, 0.990781982033, -0.025917876629 },
    { 0.888462650185, 0.424488274992, 0.174481585334 },
    { -0.769993318730, 0.031713092117, -0.637263343445 },
    { -0.472606934096, 0.489038901922, 0.733132756226 },
    { 0.533608581784, -0.778342967999, 0.330823375252 },
    { -0.887797625668, -0.339914289289, 0.310279957127 },
    { -0.388580688172, -0.816176647684, -0.427622179680 },
    { 0.502786162970, -0.597760878130, 0.624410127162 },
    { 0.760467048810, -0.641427519729, 0.101294642545 },
    { -0.687411605941, -0.634098443419, -0.354096664868 },
    { 0.636163717827, 0.748389696130, 0.187639513021 },
    { -0.977353957237, 0.200634113614, -0.067269567617 },
    { 0.887405260745, 0.026509753189, -0.460227265803 },
    { -0.896056221820, -0.367899920057, -0.248461055622 },
    { -0.083841505431, -0.987273134092, 0.135138302000 },
    { 0.077412762627, 0.167617840376, -0.982807979094 },
    { -0.710578045742, 0.689950094139, 0.138013435967 },
    { 0.827928728088, -0.336707585832, -0.448510894907 },
    { 0.985273862833, -0.090449516007, -0.145101000246 },
    { -0.853663917798, 0.309238747128, -0.419081510836 },
    { -0.406954566540, -0.885910537522, 0.222599416619 },
    { -0.761673407147, -0.322044229184, -0.562264293099 },
    { 0.155109257902, -0.979584757972, -0.127885965073 },
    { 0.977694699443, 0.071517874293, 0.197479792227 },
    { -0.246489191083, 0.330592769107, -0.911016739524 },
    { -0.071870520923, 0.956822147433, 0.281648728747 },
    { 0.237891852235, -0.940412616408, 0.242964148676 },
    { 0.769434663155, -0.477875697316, 0.423798439179 },
    { 0.405365454381, -0.383370967807, -0.829882852840 },
    { 0.081961342788, -0.514414619026, -0.853615802350 },
    { 0.302255446455, 0.915114625980, 0.266846147445 },
    { -0.429863937393, 0.870171628991, 0.240869947127 },
    { -0.300129867317, 0.782588841263, 0.545414308829 },
    { 0.358458027199, 0.181086972006, 0.915814037513 },
    { -0.239570635291, -0.400397624319, -0.884470266966 },
    { -0.836674951178, 0.528352309453, -0.144287432463 },
    { -0.594741681367, 0.151713949944, 0.789471474999 },
    { 0.281344278445, 0.880346341327, -0.381884427933 },
    { 0.895062047702, -0.426130777672, -0.131440066512 },
    { -0.050763828641, 0.945303316550, -0.322218362949 },
    { -0.249571099118, 0.967428348645, -0.042386987665 },
    { 0.837608741643, 0.217462960883, 0.501120201715 },
    { -0.634454243577, 0.616982603547, 0.465618169456 },
    { -0.577672465980, -0.812950703342, -0.073523302324 },
    { -0.307274406530, -0.094950390213, 0.946872146855 },
    { 0.339978802391, -0.176926655555, 0.923640283053 },
    { -0.040504339281, -0.342001716794, 0.938825981857 },
    { 0.712116692159, 0.538928869108, 0.449939430136 },
    { 0.685772600640, -0.674986316105, -0.272230441506 },
    { -0.679524155593, -0.458215588547, 0.572961950201 },
    { 0.052375659470, 0.342136350320, 0.938189484105 },
    { -0.279922116787, 0.255596481907, 0.925372382865 },
    { -0.130969752838, 0.601760969434, 0.787864620038 },
    { 108, DUMMYVAL, DUMMYVAL },
    { -0.021579027669, 0.236162255172, 0.971474001092 },
    { -0.584505896711, 0.811043619396, 0.023687637008 },
    { -0.356611204577, 0.348195460183, 0.866941964769 },
    { -0.936279066888, -0.165832004295, 0.309646984903 },
    { -0.619717802321, 0.695031752479, 0.364528062751 },
    { -0.841545569631, 0.104108995233, 0.530058837627 },
    { -0.795524148445, 0.353325904585, -0.492241947003 },
    { 0.788337477976, -0.241367333501, -0.565920339921 },
    { -0.831509847817, 0.551837782568, 0.063768602880 },
    { 0.893881681947, -0.214585696691, 0.393609600309 },
    { 0.686426320140, 0.367404772248, -0.627560865851 },
    { -0.202050593747, -0.277093097793, -0.939358809360 },
    { 0.069796464808, 0.310670155093, -0.947951743621 },
    { 0.950820805580, 0.171478215779, 0.257943825647 },
    { -0.516045660299, -0.534831163385, 0.669068384516 },
    { -0.195181043867, -0.701067992084, 0.685862982374 },
    { 0.395757785218, 0.627630956167, -0.670414169226 },
    { 0.624328720602, 0.654762779767, -0.426027406236 },
    { -0.759817516433, -0.517217353820, 0.393908048444 },
    { 0.277446510020, 0.415608381153, 0.866194613001 },
    { -0.742950146753, 0.613608390110, -0.267413206531 },
    { -0.506230868847, -0.120831658575, -0.853891104130 },
    { -0.941312284262, 0.297011831536, -0.160359456925 },
    { -0.731605356523, -0.299330195165, -0.612499009443 },
    { -0.281411446251, 0.128196148487, -0.950985460158 },
    { 0.520585854483, 0.621476494566, 0.585454810224 },
    { 0.618402062908, -0.551452029614, -0.559892442907 },
    { -0.337006328543, 0.887867927149, 0.313236776994 },
    { 0.365457335654, -0.292664567285, 0.883622310081 },
    { 0.788101889969, 0.427274726343, 0.443093352754 },
    { 0.738714732716, -0.538706955705, 0.405086854320 },
    { -0.628659785857, -0.606232609901, -0.487102552178 },
    { -0.360952650879, -0.928192549393, 0.090397870961 },
    { -0.893710452995, -0.328683787287, -0.305366327847 },
    { -0.927455290523, 0.015584070835, -0.373609181924 },
    { -0.150810244897, -0.906347937652, 0.394702021717 },
    { 0.948485680774, -0.179433681816, -0.261110067206 },
    { -0.828581121234, 0.414412046086, 0.376451831704 },
    { 0.402884213971, 0.912630146902, 0.069213619311 },
    { 0.977972531731, 0.174418368280, -0.114664554183 },
    { -0.024003402814, -0.998894248628, 0.040424209468 },
    { 0.186997476842, -0.952749716246, -0.239374020828 },
    { 0.027384193268, -0.826425355508, -0.562379976290 },
    { 0.891911041382, -0.446320006673, 0.072754009536 },
    { -0.262771549279, 0.964684070365, -0.018323680679 },
    { 0.583782997461, -0.016970957343, 0.811732344115 },
    { 0.406448663087, 0.330448350601, -0.851823556765 },
    { 0.596989468245, -0.767658873394, -0.233030961257 },
    { 0.025805608492, -0.021074047377, -0.999444823438 },
    { 0.308576148239, 0.865303428711, 0.395007261957 },
    { -0.468957062581, 0.823225638514, -0.319966906959 },
    { -0.661210966830, -0.738802885094, 0.130270312503 },
    { -0.069877100001, 0.841923555359, 0.535053191587 },
    { 0.396554663170, 0.870439133357, -0.291684957169 },
    { 0.362516068996, -0.005484362563, -0.931961384118 },
    { 0.072969781232, 0.611531800378, -0.787847871199 },
    { -0.551418612627, 0.290997491556, -0.781829887864 },
    { -0.174355659640, -0.944864346357, -0.277184903873 },
    { -0.471726395122, -0.773795372336, 0.422746886324 },
    { 0.150908426162, -0.778364526773, 0.609405702610 },
    { 0.108624116378, -0.524136058244, 0.844678751828 },
    { 0.483587960903, -0.783126803643, 0.390966870062 },
    { -0.139014279177, 0.928159177416, -0.345247116663 },
    { 0.186911175585, -0.934915045369, 0.301658864257 },
    { 0.817789473759, 0.076885932393, 0.570358597734 },
    { 0.821894155188, -0.503707252051, -0.266024438537 },
    { -0.495743892020, -0.838903265086, -0.224676000838 },
    { 0.035212387553, -0.169205555690, 0.984951556010 },
    { -0.086953100308, 0.563970123010, 0.821204516974 },
    { 0.396835243562, -0.917464529016, 0.027939711247 },
    { 0.851443568027, 0.439947148896, -0.285465158371 },
    { -0.085192396935, -0.590068923650, -0.802845514932 },
    { 0.643110972897, 0.717238661276, 0.268285257349 },
    { -0.436818897121, -0.476823623734, -0.762776823826 },
    { 0.588773174148, 0.319476770857, 0.742482822890 },
    { -0.766204273112, -0.618964771815, -0.172666218806 },
    { 0.878658599806, 0.111032877834, -0.464360598056 },
    { 0.688567273578, -0.718947371069, 0.094814489348 },
    { -0.758765506338, -0.236662804005, 0.606848929794 },
    { -0.320838925232, -0.762695510703, -0.561567397566 },
    { -0.225751295793, 0.746758732829, -0.625609900331 },
    { 0.283979009180, -0.600099625490, -0.747821076082 },
    { 0.166698238741, -0.335875335364, -0.927038001538 },
    { -0.994585215969, -0.092831289884, -0.046718302554 },
    { -0.255994489759, 0.470618824694, -0.844384238991 },
    { 0.873755776944, 0.478841212824, 0.085216988673 },
    { 0.680240782208, -0.309167958683, 0.664595855799 },
    { 0.022983938931, 0.975863358502, 0.217169160070 },
    { -0.274296249334, -0.001676239118, 0.961643779070 },
    { -0.502123051766, -0.226714856179, 0.834549468200 },
    { 0.370951862243, -0.795148043884, -0.479723153711 },
    { 0.449158606076, -0.581622624593, 0.678212112211 },
    { 0.989647518656, -0.122156697343, 0.075336114262 },
    { -0.607103039914, 0.100224360185, 0.788277220623 },
    { -0.969373432855, 0.177097101759, 0.170152179604 },
    { 0.145152745807, 0.841016600360, -0.521173443589 },
    { 0.682265111449, 0.726328599287, -0.083433108280 },
    { 0.289330664502, 0.074423997958, 0.954331616948 },
    { -0.371452492344, 0.676784103473, 0.635599184407 },
    { 0.512609901370, -0.307272607601, -0.801757216142 },
    { -0.748858905141, 0.040255050535, -0.661505760441 },
    { 0.201547956025, 0.698610066484, 0.686529239311 },
    { -0.902004085005, -0.424476757812, 0.078791577667 },
    { -0.542235635169, 0.594751277392, -0.593507737097 },
    { -0.215393350073, -0.404171036058, 0.888960898103 },
    { 0.110692126262, 0.986666730345, -0.119314778691 },
    { -0.623907732019, 0.431690262947, 0.651446589371 },
    { 0.658999241187, 0.037219156354, -0.751222160559 },
    { 109, DUMMYVAL, DUMMYVAL },
    { -0.162784650069, 0.612260060000, -0.773717504410 },
    { 0.491823423428, 0.467845703492, -0.734322897568 },
    { -0.552611605725, 0.280704220214, 0.784745534535 },
    { -0.974656364925, 0.093425719683, 0.203264864678 },
    { 0.978008444009, 0.163712368284, -0.129219750495 },
    { -0.671350508872, -0.740444882751, -0.032091585277 },
    { -0.240797421787, 0.404906351518, 0.882081316071 },
    { 0.487175059860, -0.114555941267, -0.865758278835 },
    { -0.902319261668, -0.430966648731, -0.009364705313 },
    { -0.029364231178, -0.982465856550, -0.184115677338 },
    { -0.270828008177, 0.814380751841, -0.513260344288 },
    { -0.528993417856, -0.633462219487, 0.564704861276 },
    { 0.326360105025, 0.217377077405, -0.919911021821 },
    { -0.016192594777, 0.147018131987, 0.989001248099 },
    { -0.030197868308, 0.903456445156, 0.427614944145 },
    { 0.249914135280, -0.389229841946, -0.886590691991 },
    { 0.928857238556, -0.370138276803, -0.014895852675 },
    { 0.757462187188, 0.635687901837, 0.148835232514 },
    { -0.515443411328, 0.574168855421, -0.636119654768 },
    { -0.015771131195, 0.298733161191, -0.954206355997 },
    { -0.372144645093, 0.832807967839, 0.409803918763 },
    { 0.356314179661, -0.681407366642, 0.639315419851 },
    { -0.359680312610, 0.344187075343, -0.867274656546 },
    { -0.952141893963, 0.281767292670, -0.118460991645 },
    { 0.768629468315, 0.429523206949, 0.474044887251 },
    { -0.487861036571, -0.838903644340, 0.241313664156 },
    { -0.772142026149, 0.346745049575, 0.532507804684 },
    { 0.425758782078, 0.734527405605, -0.528392798872 },
    { 0.183616410633, -0.132491091168, 0.974028297591 },
    { -0.646981478172, -0.045895547360, 0.761123226314 },
    { -0.742556149216, -0.113500427312, -0.660096976407 },
    { 0.025358889418, -0.738008320397, 0.674314945520 },
    { 0.637691242275, 0.736660439628, -0.225125023515 },
    { -0.511370459968, 0.038453439767, -0.858499613071 },
    { 0.477460583041, 0.495167020695, 0.725838145359 },
    { -0.884098963176, 0.417588518877, 0.209735195456 },
    { 0.451605865085, -0.386804657761, 0.804011380116 },
    { -0.549954806319, 0.831208040095, 0.081504018844 },
    { -0.197765875116, 0.972583522560, 0.122351748185 },
    { 0.870913063761, 0.184929884632, -0.455314587007 },
    { -0.693069647938, 0.268839043891, -0.668864733400 },
    { -0.477723920072, -0.331854559777, 0.813420191135 },
    { 0.583178087978, -0.415260729382, -0.698184677815 },
    { -0.021953160236, 0.964312534597, -0.263854873700 },
    { -0.434000567774, -0.298058220372, -0.850179277824 },
    { -0.154321527897, -0.974742402306, 0.161437651041 },
    { 0.659083742139, -0.526428754056, 0.537104633895 },
    { 0.674400378482, 0.196991267695, 0.711602817557 },
    { 0.929359657707, 0.318000451528, 0.187526903281 },
    { -0.246748884721, -0.838277021982, 0.486216641331 },
    { -0.755011943637, -0.588906094175, 0.288351482065 },
    { 0.885835666618, -0.306479349128, 0.348375631044 },
    { -0.593999337210, 0.735148087384, -0.326683450773 },
    { -0.926297793796, -0.254783693904, 0.277592626935 },
    { 0.502559957963, 0.861767401958, 0.069212958135 },
    { -0.348354784141, -0.613930834778, -0.708334578059 },
    { -0.196079261257, -0.005474456263, -0.980572768148 },
    { 0.755681575271, -0.638409324497, -0.146215222161 },
    { 0.803074825538, -0.428813145899, -0.413751266452 },
    { -0.145192654142, 0.702613298333, 0.696601497406 },
    { 0.122229788044, -0.856443319256, -0.501562279100 },
    { 0.340534439503, -0.904624877755, -0.256300850679 },
    { 0.539316309761, -0.842016769084, 0.012069739285 },
    { -0.858555847055, 0.013859075973, 0.512532714566 },
    { -0.745447150019, -0.349864462130, 0.567365318527 },
    { -0.902714074646, 0.107493017657, -0.416596388116 },
    { 0.321850972698, 0.913324790657, -0.249499054397 },
    { 0.560267288473, 0.700587460968, 0.441902449644 },
    { 0.757435529159, -0.616575535586, 0.214769709418 },
    { 0.724000977785, 0.495255238345, -0.480150844068 },
    { 0.889839579177, 0.069625868176, 0.450929885694 },
    { 0.115095039529, -0.467205695973, 0.876625330187 },
    { -0.522495330313, -0.752110698340, -0.401656728119 },
    { 0.740699095299, -0.186937698348, 0.645305468100 },
    { -0.348029989614, 0.919569963425, -0.182390264805 },
    { 0.141218234610, -0.067708138042, -0.987660375968 },
    { -0.014960938711, -0.646793993191, -0.762518000236 },
    { 0.329142034939, 0.234282981052, 0.914755161574 },
    { -0.776145475286, -0.553010120828, -0.302948852869 },
    { 0.654651419987, 0.170325609331, -0.736492162290 },
    { -0.247279427392, -0.571558897156, 0.782415050897 },
    { -0.894989603718, -0.244874590962, -0.372867327528 },
    { 0.501563167817, -0.055317801225, 0.863350641140 },
    { -0.797054450365, 0.459143480025, -0.392290030340 },
    { 0.175837788783, 0.565185423595, -0.806006519199 },
    { -0.481090610679, 0.590805703288, 0.647688540333 },
    { 0.862954344577, 0.481834899938, -0.152134573245 },
    { -0.342046706583, 0.032899799479, 0.939106838283 },
    { 0.949350929013, -0.144424546661, -0.279059785537 },
    { -0.674377338357, 0.650115574601, 0.350092766523 },
    { 0.563031470608, -0.706322200449, -0.429074017225 },
    { -0.649138712246, -0.451111691250, -0.612468100623 },
    { 0.211454145065, -0.974429029862, 0.075994804407 },
    { 0.468651534513, -0.813211637739, 0.345039956300 },
    { 0.298141666536, 0.890542470476, 0.343577727674 },
    { -0.153211927261, -0.248540619180, 0.956427553954 },
    { -0.992450567507, -0.087489512225, -0.085950313006 },
    { 0.103132103258, 0.487881679219, 0.866795960051 },
    { -0.786170228471, 0.615496435747, -0.055682218419 },
    { 0.334553744042, -0.655666842055, -0.676886094241 },
    { 0.088392433135, 0.818805325002, -0.567225367479 },
    { -0.212839824462, -0.855607317320, -0.471842481844 },
    { 0.223521587377, 0.728174500437, 0.647919745717 },
    { -0.374291125313, -0.919784711288, -0.117907753746 },
    { 0.139074142111, 0.988849626814, 0.053242826230 },
    { 0.780191110481, -0.131149705109, -0.611638443834 },
    { -0.104040874989, -0.353766209657, -0.929529432152 },
    { 0.989910715918, -0.054356736452, 0.130851517810 },
    { 0.122243039385, -0.910416932642, 0.395218481451 },
    { 110, DUMMYVAL, DUMMYVAL },
    { -0.914673420430, -0.398910151556, 0.065140041021 },
    { -0.171085712703, -0.311903741478, -0.934583187823 },
    { -0.353335475739, -0.522079090680, 0.776265073708 },
    { -0.451072174321, 0.181861107601, 0.873762228009 },
    { -0.149812348684, -0.306372963107, 0.940048864506 },
    { 0.092578296397, -0.815997328941, -0.570594092326 },
    { -0.785992504349, 0.303707071002, -0.538495866401 },
    { -0.733302237932, -0.675381949377, -0.078275476997 },
    { 0.829083585800, 0.503837620299, -0.242421245208 },
    { -0.777236643378, 0.623402217058, 0.085281158278 },
    { 0.082785289227, 0.595646657136, -0.798969120636 },
    { 0.707622267227, -0.293962937892, 0.642539117930 },
    { 0.384640724002, 0.663048185310, -0.642198269537 },
    { 0.687152990006, -0.691379810743, -0.223192127152 },
    { 0.573191025747, 0.479458342843, 0.664508649667 },
    { -0.518586805883, 0.372732461905, -0.769505189460 },
    { 0.080343010750, -0.536751352567, 0.839906534170 },
    { 0.229598470619, 0.484091492427, 0.844357725878 },
    { 0.791899331436, -0.153947225889, -0.590927830207 },
    { 0.187015894789, -0.316459975818, -0.929988246593 },
    { 0.356825052319, 0.011116396577, -0.934105083898 },
    { 0.599398849059, -0.617499754052, 0.509328060775 },
    { -0.115933435057, -0.744913946184, 0.657010389123 },
    { 0.627262815881, -0.505108762543, -0.592795494092 },
    { 0.860409316613, 0.496097112342, 0.116548114573 },
    { 0.473350008722, -0.880020651772, -0.038773982230 },
    { -0.016721151823, 0.823243933609, -0.567441476152 },
    { -0.829122163489, 0.428092725964, 0.359573436156 },
    { 0.419464165718, -0.456437242955, 0.784675000827 },
    { 0.650347446259, 0.112631638739, -0.751240516146 },
    { 0.340632629310, 0.724206071427, 0.599579000597 },
    { -0.857884323915, -0.077430953527, -0.507975328355 },
    { -0.838579568851, -0.446460258307, -0.312181909242 },
    { -0.593207441917, -0.672171730103, -0.443046381437 },
    { -0.951175544694, 0.173881145783, -0.255010647457 },
    { 0.649761914123, 0.665139796700, 0.367965359514 },
    { -0.968958760380, -0.159811519336, -0.188624491970 },
    { 0.680628238554, 0.458314333353, -0.571570794151 },
    { 0.887553516073, -0.460373870840, -0.017454373506 },
    { -0.486397597878, -0.230877562777, -0.842681984965 },
    { 0.136578825601, -0.988527801109, 0.064490393332 },
    { -0.291793544377, 0.645111190364, -0.706178504011 },
    { -0.599398997130, 0.617499469623, -0.509328231355 },
    { -0.291599348726, 0.788561289194, 0.541424891382 },
    { -0.952066743351, 0.299885321312, 0.060313433558 },
    { 0.159809797285, 0.141550968987, 0.976946340323 },
    { 0.959889316383, -0.102791222996, -0.260857173122 },
    { 0.091645910057, 0.990765060749, 0.099928081979 },
    { 0.816422107613, 0.351194885346, 0.458385312492 },
    { 0.465946279010, 0.222355362346, 0.856418214375 },
    { 0.182128504289, -0.204152168069, 0.961847753129 },
    { 0.275836310785, 0.873864787128, -0.400343182121 },
    { -0.506425920900, -0.689335609823, 0.518024327296 },
    { 0.074583367655, 0.885652593684, 0.458319544172 },
    { -0.538232682262, -0.828002896001, 0.157215724273 },
    { 0.732702599664, 0.092995687109, 0.674165189419 },
    { 0.227176103891, -0.936408691589, -0.267450519045 },
    { -0.396760019641, -0.553746777024, -0.732083324321 },
    { 0.969111157870, 0.212678332997, -0.124865889521 },
    { -0.115485608953, 0.376864021032, 0.919041121918 },
    { -0.386205706963, 0.521665312867, 0.760730210561 },
    { 0.898151794738, -0.078915928088, 0.432545523504 },
    { 0.410775973084, -0.858209111483, 0.307798994321 },
    { 0.592496645565, 0.730816032106, -0.338903603124 },
    { -0.029181291308, 0.678272948646, 0.734230385760 },
    { 0.962319758155, 0.171701809540, 0.210853436457 },
    { -0.879818234718, -0.253108994789, 0.402312951090 },
    { -0.665652601708, -0.390878297425, 0.635704939765 },
    { -0.898836335280, 0.103772357353, 0.425822193209 },
    { -0.657887229142, 0.049041370510, -0.751518022212 },
    { 0.698934087432, -0.695734768084, 0.165663133815 },
    { -0.265875185995, -0.801221064086, -0.536055213516 },
    { 0.847357213806, -0.413611692817, 0.333033211220 },
    { 0.842934810930, -0.407680100804, -0.351080959224 },
    { 0.436151166846, 0.372885302232, -0.818980287332 },
    { -0.826604919096, 0.507060400681, -0.244159902089 },
    { -0.528823213651, 0.825082164962, 0.198960874960 },
    { -0.469722501212, -0.177958409085, 0.864691607737 },
    { -0.450571971881, -0.870344950899, -0.198707233384 },
    { 0.394017432792, 0.877376891390, 0.273788336332 },
    { 0.525829765933, -0.258875947130, -0.810238422476 },
    { 0.135999991746, 0.285960704384, -0.948541236738 },
    { 0.314675774878, -0.582069078008, -0.749783132067 },
    { 0.494546622219, -0.117104625679, 0.861225954728 },
    { -0.269197573089, -0.885755083688, 0.378114530750 },
    { 0.446744041598, -0.766421469720, -0.461538613822 },
    { -0.011397249594, 0.972962835829, -0.230680347660 },
    { -0.164577427495, 0.028451460591, 0.985953743717 },
    { -0.045576015824, -0.601257879900, -0.797754215683 },
    { -0.209868435190, -0.976065399375, 0.057022592484 },
    { 0.658544751434, 0.752396966811, 0.014751769111 },
    { -0.599811673974, 0.779439089163, -0.180833243761 },
    { 0.271041004174, -0.738560344884, 0.617304941679 },
    { 0.375894294524, 0.923117716295, -0.080976300271 },
    { -0.698199669777, -0.365894611427, -0.615335968762 },
    { -0.010281988829, -0.015281617910, -0.999830362041 },
    { -0.596271636658, 0.640152259230, 0.484422563801 },
    { -0.679001626325, 0.320789608851, 0.660341440697 },
    { 0.864842674759, 0.185673366817, -0.466446726616 },
    { -0.110505821025, -0.956115807589, -0.271350374975 },
    { -0.332405995677, 0.848464487088, -0.411842528387 },
    { -0.725104815425, -0.035616456457, 0.687716856473 },
    { 0.069744670739, -0.918209449824, 0.389906510791 },
    { -0.340458256403, 0.070449726360, -0.937616665649 },
    { -0.310009532392, 0.948083554620, -0.070934218012 },
    { -0.991194536064, -0.038177628465, 0.126790616220 },
    { 0.985214814362, -0.150618101677, 0.081645312229 },
    { -0.190659951778, 0.373722833906, -0.907733455484 },
    { -0.754326154264, -0.580852470822, 0.305945191389 },
    { -0.206724698494, 0.944930739173, 0.253714006705 },
    { 111, DUMMYVAL, DUMMYVAL },
    { -0.561467100731, -0.002032843239, 0.827496563343 },
    { -0.322561945911, -0.937294651350, 0.132032297566 },
    { -0.792666273108, 0.593941298438, 0.137527864405 },
    { -0.556359095181, -0.825712943844, -0.093073581524 },
    { 0.309851152108, -0.789736987883, 0.529440982081 },
    { -0.603321364839, -0.565465849579, 0.562362608722 },
    { 0.561025617937, 0.323854623935, -0.761819163958 },
    { 0.152335265408, -0.176287250614, 0.972479702711 },
    { -0.132583681649, 0.390909148995, -0.910830173299 },
    { -0.378752823591, 0.652889623900, 0.655958411507 },
    { 0.254992844901, 0.826466797546, -0.501927566093 },
    { -0.294356415399, 0.184170868739, 0.937782166509 },
    { -0.823443925816, -0.109000202085, -0.556829468492 },
    { -0.453419996492, 0.376134645997, -0.808042718463 },
    { -0.676752965406, 0.141893263537, -0.722406897515 },
    { 0.994840015388, -0.017089275670, -0.100006501985 },
    { -0.645656815479, 0.517051905236, -0.561947154026 },
    { -0.322597551461, 0.664458502392, -0.674111057906 },
    { -0.063208117734, -0.447379889690, 0.892107598978 },
    { 0.824704586501, 0.280286574952, 0.491224776355 },
    { -0.782822788814, 0.151205325466, 0.603593763109 },
    { 0.444259234766, -0.806087038985, -0.390969842706 },
    { -0.994473719570, 0.066858229974, 0.080944414072 },
    { -0.474877449130, 0.791183828163, -0.385382353464 },
    { -0.903072430189, 0.304340755972, 0.303046019752 },
    { -0.899689023693, -0.329902555351, -0.285874036280 },
    { -0.353748081869, 0.070882048532, -0.932651076110 },
    { 0.594967970670, 0.625384457699, -0.504883544935 },
    { -0.738147632119, -0.235344797579, 0.632258570088 },
    { -0.018003503173, -0.999820652782, 0.005876746090 },
    { 0.905403782171, 0.012421808530, -0.424369756113 },
    { -0.920679691230, -0.082385175030, 0.381525345281 },
    { 0.805078303196, -0.459356471523, 0.375287300335 },
    { -0.930614910180, 0.354660741293, -0.090397165529 },
    { -0.613813856968, -0.744913898402, 0.261411233428 },
    { -0.389235458634, -0.517299429351, -0.762166030557 },
    { 0.045815537437, 0.159850393821, 0.986077475721 },
    { 0.012709695315, 0.716479730381, 0.697492121531 },
    { 0.530889762146, -0.247686763783, -0.810436504296 },
    { 0.731948562705, -0.606929509908, -0.309657668333 },
    { 0.005139120236, -0.748079368848, 0.663589366511 },
    { 0.860554470206, 0.486255845810, 0.151661650477 },
    { -0.467832572645, -0.739974173058, -0.483291741270 },
    { 0.826842351808, -0.561065534342, 0.039207032919 },
    { 0.196949235043, -0.753470070840, -0.627290882417 },
    { 0.210524816849, 0.336996041845, -0.917667134244 },
    { 0.346990921633, 0.587499978969, -0.731054768821 },
    { -0.004779742691, 0.992909231060, 0.118778840437 },
    { -0.048607268089, -0.539167926484, -0.840794434175 },
    { 0.557319699147, -0.561482194439, -0.611663713384 },
    { 0.678519180058, 0.067177801489, 0.731504521709 },
    { 0.359209750108, 0.671204661478, 0.648423208897 },
    { 0.151640529432, -0.225047087002, -0.962475432656 },
    { 0.293210751402, -0.948041371885, -0.123470694728 },
    { 0.593241190136, -0.804137371487, -0.037788597548 },
    { 0.958263769108, -0.244817143628, 0.147631686983 },
    { 0.460666028936, -0.233751493237, 0.856240065165 },
    { 0.213959432972, 0.442789782760, 0.870723015273 },
    { -0.530034488417, 0.363888313303, 0.765929981480 },
    { 0.334410316647, 0.940555531955, 0.059371975119 },
    { -0.584402097389, 0.810217258280, -0.044968688584 },
    { -0.241892466355, 0.953495290208, -0.179818703898 },
    { 0.383872664604, 0.042748572307, -0.922395976214 },
    { 0.654995502949, 0.751805132164, 0.075960084049 },
    { 0.142066905742, 0.897585421075, 0.417321705841 },
    { -0.006872862662, -0.933824416834, 0.357665657121 },
    { -0.335822821521, 0.929927025190, 0.149862471512 },
    { 0.553366074688, 0.394317111502, 0.733689309559 },
    { -0.703811397448, 0.500984562705, 0.503650657453 },
    { 0.486882987037, 0.840022611479, -0.239388740623 },
    { 0.770982579285, 0.601295076416, -0.209833489981 },
    { -0.149783057926, 0.477426477771, 0.865811176806 },
    { 0.799539124822, 0.339883149283, -0.495193530563 },
    { 0.717991129433, -0.263665720636, 0.644180972877 },
    { -0.304745183730, -0.619154620039, 0.723725037206 },
    { 0.935523879375, 0.312326765655, -0.165066842748 },
    { -0.681189130383, -0.429946947551, -0.592559693989 },
    { -0.967174173570, 0.009365627467, -0.253941731507 },
    { -0.105688290986, 0.867627259768, -0.485852779406 },
    { -0.834158901484, -0.433040823075, 0.341547321210 },
    { 0.016940399623, 0.659375268979, -0.751623095388 },
    { 0.313190475367, -0.925508983638, 0.212943296077 },
    { -0.812743653402, -0.582142505883, 0.023618990229 },
    { -0.762159845255, 0.597461134393, -0.249304157950 },
    { -0.724474787047, -0.617274802617, -0.306770436951 },
    { 0.119203920470, 0.968753382935, -0.217502433081 },
    { 0.682062026522, 0.579453021077, 0.446122839969 },
    { 0.968451495762, 0.164185311225, 0.187469688041 },
    { -0.326087725119, -0.826855263680, 0.458232657557 },
    { 0.053073605001, -0.929609447178, -0.364704631406 },
    { 0.602908876994, -0.736757794414, 0.306086325098 },
    { -0.203518251000, -0.139069528034, 0.969143945904 },
    { -0.551859408013, -0.189602855240, -0.812097254688 },
    { -0.962041555137, -0.268474355701, 0.048964951970 },
    { 0.707699474627, 0.027290900503, -0.705986303240 },
    { 0.259372642908, -0.524729450816, 0.810792720464 },
    { -0.201667615609, 0.866442293687, 0.456736165117 },
    { 0.462177934143, 0.813812667826, 0.352279007148 },
    { -0.212536355546, -0.249430792774, -0.944781761672 },
    { -0.553070211072, 0.757057891172, 0.347817036729 },
    { -0.006940858629, 0.067343786571, -0.997705687511 },
    { -0.159364801410, -0.778822662108, -0.606661455063 },
    { 0.292082182854, -0.493177611400, -0.819428973171 },
    { 0.896774828495, -0.066052417845, 0.437529410526 },
    { 0.386305673878, 0.119226190945, 0.914632735978 },
    { -0.452642136857, -0.332905985571, 0.827217444637 },
    { -0.270069763814, -0.928703361330, -0.254110978369 },
    { 0.546165188549, -0.559345633276, 0.623567197143 },
    { -0.854977161171, 0.271538731558, -0.441905839677 },
    { 0.917659485416, -0.327973725197, -0.224353079778 },
    { 0.781722251312, -0.300740056080, -0.546320181280 },
    { 112, DUMMYVAL, DUMMYVAL },
    { -0.453580417559, 0.796276357201, -0.400260874643 },
    { 0.093267420430, 0.702603283130, -0.705442991901 },
    { 0.245891796552, 0.124799426798, 0.961229591440 },
    { -0.664430270682, 0.051701168950, 0.745559792727 },
    { -0.160971557143, 0.976390260766, 0.144049354293 },
    { -0.612532688617, -0.510442265644, 0.603533262397 },
    { 0.763426829128, -0.544681398015, -0.347133477534 },
    { 0.168847088906, 0.984835038277, -0.039882426590 },
    { -0.583573419378, -0.551289022344, -0.596257057013 },
    { 0.318175477253, -0.948031390627, 0.000920901883 },
    { -0.091512861170, 0.308032676780, 0.946964237063 },
    { 0.930906532543, 0.107528765797, 0.349071041759 },
    { -0.142133956826, -0.829414464195, 0.540249557983 },
    { 0.115925612932, -0.753599907250, -0.647030472280 },
    { 0.479162344873, -0.122210352616, 0.869176666144 },
    { 0.838834605368, -0.544144827096, -0.016214560761 },
    { 0.413049195595, 0.797525717449, 0.439707962203 },
    { -0.439560725797, 0.849466698602, 0.291877879091 },
    { 0.216062693719, 0.465063827869, 0.858505997877 },
    { -0.476999237645, -0.769663899576, 0.424369189476 },
    { -0.671158686180, -0.699776208134, -0.244661555000 },
    { 0.365565397510, -0.502617777658, 0.783413881499 },
    { 0.652533751894, -0.347305270719, 0.673482554763 },
    { -0.882367511873, 0.082974998674, 0.463187568471 },
    { 0.574954631635, -0.793938930457, -0.197707223605 },
    { 0.692439553287, 0.639688196288, 0.333656225138 },
    { 0.412014162209, 0.708005791284, -0.573560920606 },
    { 0.573969613450, 0.428237314952, -0.697976851277 },
    { -0.150849325625, 0.852209727459, 0.500982096868 },
    { -0.459140666274, 0.330466965323, -0.824609867394 },
    { -0.378868543245, -0.391823717337, -0.838410878670 },
    { -0.077712126077, 0.450449144394, -0.889413511127 },
    { -0.717679377017, 0.692325399145, 0.074979020418 },
    { 0.894552656874, 0.405570851140, 0.187850549069 },
    { -0.138772899879, 0.848425561789, -0.510799518757 },
    { 0.272099518507, 0.447418297457, -0.851926475190 },
    { 0.447464611806, 0.136867027782, -0.883766280126 },
    { -0.518257808694, -0.260813848423, 0.814484487390 },
    { -0.129097989901, -0.177340378893, -0.975645478141 },
    { 0.369295893409, -0.868496696206, 0.330656969972 },
    { -0.014038849492, -0.482235152519, -0.875929317000 },
    { -0.051519870263, -0.028767697078, 0.998257543209 },
    { 0.016953146996, -0.577451888377, 0.816248679887 },
    { -0.905247551656, 0.420855442022, -0.058374370588 },
    { -0.151196124402, 0.968771732471, -0.196522421956 },
    { 0.548450405729, -0.652515006496, 0.522901825157 },
    { 0.944372660155, -0.258051154524, -0.203886930430 },
    { -0.854118135507, -0.519740700923, -0.018756716199 },
    { -0.828219003070, -0.411764769286, -0.380135578089 },
    { 0.193884621943, -0.773665239498, 0.603200506106 },
    { -0.316218378505, -0.602306265209, 0.732961868030 },
    { 0.739338352981, 0.028929849670, 0.672712318610 },
    { 0.497519776833, 0.558781538897, 0.663503778022 },
    { 0.615456927055, -0.461358644133, -0.639031276561 },
    { -0.227730254216, -0.680149348880, -0.696803985733 },
    { -0.672464590110, 0.622324053449, 0.400629688798 },
    { 0.627713642659, -0.765377476883, 0.142031337037 },
    { -0.372033771647, 0.043446263547, 0.927201863101 },
    { -0.305420751566, 0.631354945360, -0.712817716869 },
    { -0.127447711924, 0.605203398701, 0.785802727742 },
    { 0.176540941326, -0.272259036060, 0.945890222658 },
    { -0.202461799960, -0.324409692008, 0.923995438998 },
    { 0.963406020291, -0.232153919046, 0.133990290462 },
    { 0.468652213505, 0.875777717514, 0.115665432529 },
    { 0.996188698546, 0.087142311045, 0.003780808721 },
    { 0.685492711719, 0.629132347245, -0.366459045229 },
    { -0.969312907016, -0.215668989580, -0.117980401875 },
    { 0.122846154022, 0.137576416040, -0.982843605154 },
    { -0.688407878383, -0.238181505999, -0.685101571433 },
    { -0.369446232951, -0.920406640151, -0.127910506702 },
    { 0.447938054490, -0.727817601263, -0.519262013469 },
    { -0.027625256868, -0.997130901993, -0.070475594880 },
    { 0.317306824625, -0.504273608861, -0.803134177117 },
    { 0.539382864411, -0.188891921599, -0.820600979487 },
    { -0.478404788545, -0.051648731779, -0.876619225664 },
    { 0.812011445323, 0.337072200079, -0.476465890278 },
    { -0.282163773941, -0.937807470559, 0.202239345426 },
    { -0.938296253609, -0.250605963066, 0.238320774880 },
    { -0.422884422270, 0.657076853544, 0.624034273048 },
    { 0.176185085756, 0.904988537489, -0.387239670709 },
    { 0.940105711912, 0.060076194340, -0.335547465054 },
    { -0.798692400934, -0.232927289850, 0.554829096509 },
    { -0.699204818584, 0.363345796592, 0.615704843060 },
    { -0.095392389498, -0.908276593251, -0.407349876860 },
    { 0.135424257301, 0.940782405220, 0.310787285073 },
    { 0.820722659271, -0.212930308178, -0.530165069029 },
    { -0.973175192390, 0.117985577258, -0.197508097241 },
    { 0.762523200387, 0.358419800771, 0.538603393312 },
    { 0.524902133798, 0.252417592737, 0.812873365790 },
    { 0.865936778232, -0.205063068727, 0.456182676074 },
    { 0.792191074782, -0.512657186526, 0.331082935439 },
    { -0.773159213961, -0.552940058298, 0.310615714022 },
    { 0.733342356477, 0.679656083352, -0.016631192379 },
    { -0.466051908067, 0.882367822999, -0.064981873807 },
    { 0.470659389483, 0.853010572946, -0.225505435710 },
    { -0.713263107487, 0.142592953306, -0.686238288909 },
    { -0.611138704492, -0.785865161558, 0.094474503023 },
    { 0.049886280609, -0.959950924424, 0.275691098340 },
    { 0.904784809871, 0.397868863097, -0.151871049265 },
    { -0.880823197875, 0.382628642132, 0.278829367726 },
    { -0.413049144789, -0.797525702557, -0.439708036941 },
    { -0.722195394525, 0.638855740068, -0.265136107517 },
    { -0.987931268718, 0.074962790755, 0.135544783343 },
    { 0.221977415746, -0.193205256371, -0.955718450073 },
    { -0.424552035175, 0.369266053142, 0.826678989346 },
    { -0.214235892714, 0.148320991874, -0.965455263408 },
    { 0.728558976619, 0.078037861211, -0.680523261767 },
    { -0.883777629480, -0.069260169529, -0.462752774759 },
    { 0.237033798122, -0.914627815300, -0.327522423700 },
    { -0.616296851019, 0.524448386228, -0.587479430794 },
    { 0.153265383291, 0.744867998427, 0.649369992535 },
    { -0.842596637035, 0.330250984429, -0.425400040598 },
    { 113, DUMMYVAL, DUMMYVAL },
    { 0.520451304068, 0.211355039208, 0.827320667876 },
    { -0.353069253780, -0.111750065651, 0.928899362075 },
    { 0.862002820871, 0.109571565421, -0.494919396328 },
    { -0.465726994884, 0.873858494878, 0.139533856705 },
    { 0.151573797743, -0.384813739517, 0.910463491699 },
    { 0.075732171636, 0.975689323213, -0.205657440293 },
    { -0.188264173642, -0.435077089559, 0.880491071541 },
    { 0.365341657947, 0.249082856049, -0.896929876741 },
    { 0.634765560770, 0.061367597305, -0.770264046196 },
    { 0.891588387051, -0.023122939714, 0.452255986952 },
    { 0.967869149649, 0.199904771469, -0.152536525142 },
    { -0.847053763905, -0.375167847306, -0.376495693737 },
    { -0.915359365849, 0.302585331861, -0.265630096742 },
    { 0.543485832828, -0.254050398798, -0.800050963618 },
    { -0.310541349924, -0.431835015500, -0.846807291759 },
    { 0.259481535856, -0.439118970612, -0.860141768663 },
    { 0.554676793071, 0.542286773442, 0.631077420431 },
    { 0.702378912175, 0.687226534197, -0.185428030314 },
    { -0.319617242643, -0.897508072546, -0.303848774754 },
    { 0.451153699403, 0.791003139298, 0.413248560960 },
    { 0.283999191769, 0.952273093809, 0.111894655290 },
    { 0.122472285464, -0.979086709296, 0.162449238144 },
    { -0.437637707612, -0.835832413477, 0.331447452031 },
    { -0.887483946956, -0.399692022101, 0.229387295561 },
    { 0.294708010752, -0.083940377824, -0.951893482155 },
    { -0.806965674446, -0.258483431256, 0.531029863596 },
    { -0.228686842918, 0.209131866942, 0.950771365842 },
    { -0.561253909617, 0.147385851504, -0.814414795860 },
    { 0.570732244548, -0.533626954154, -0.624104942165 },
    { 0.825459308244, 0.428482382972, -0.367450374766 },
    { -0.277399544152, -0.037090728485, -0.960038421504 },
    { 0.135991198103, 0.185619314002, 0.973165897629 },
    { 0.769916086127, 0.275690668714, 0.575520525704 },
    { -0.548132559609, 0.229119853641, 0.804397159222 },
    { 0.253175707390, 0.840158975422, -0.479619596352 },
    { 0.756622555180, 0.554335105798, 0.346749043939 },
    { 0.273683368650, -0.710149352371, -0.648679667518 },
    { -0.990710559167, 0.135112465407, 0.015401611797 },
    { -0.038684857630, -0.613981508506, -0.788371859596 },
    { -0.634648544160, 0.762177701348, -0.127696425017 },
    { 0.794570905345, -0.223757398548, -0.564437510248 },
    { 0.232143340786, -0.898846776968, -0.371731006055 },
    { -0.111140206448, -0.898243203508, 0.425214065927 },
    { 0.953146650795, -0.150693957460, -0.262302865525 },
    { -0.789788253268, 0.226963341212, -0.569843975792 },
    { 0.542712528750, -0.756355159229, -0.365225935888 },
    { -0.731528646421, 0.559816587949, -0.389193046344 },
    { -0.856841691107, 0.515307272630, -0.016755033716 },
    { 0.555880397444, 0.671997727381, -0.489301581984 },
    { -0.644076713916, -0.083239491754, 0.760418551591 },
    { 0.211614901053, 0.718322810909, 0.662745405853 },
    { -0.956467062529, -0.050605743185, 0.287419235706 },
    { 0.358181129102, 0.559500992839, -0.747438905709 },
    { -0.823299182316, 0.127428927380, 0.553118725831 },
    { -0.045278431252, 0.489687732020, 0.870721418579 },
    { 0.996283078233, -0.047748656032, 0.071694447991 },
    { -0.695141131846, 0.449929505188, 0.560662329015 },
    { -0.083276483872, 0.992954402847, 0.084300540339 },
    { 0.111460670611, 0.910791843522, 0.397535830687 },
    { 0.048195853158, 0.431974938200, -0.900596920106 },
    { 0.498675979213, -0.357215004503, 0.789759272383 },
    { 0.914484611653, -0.305518471047, 0.265285429113 },
    { -0.621969426032, -0.695768626695, -0.359249288362 },
    { -0.704498727508, -0.684999993479, 0.185624760938 },
    { 0.755723355061, -0.607462142929, 0.244687464991 },
    { -0.654875112186, -0.568018274418, 0.498491551951 },
    { 0.682098614795, -0.061830891737, 0.728641489706 },
    { -0.279502625711, 0.324646849211, -0.903594325745 },
    { -0.133832180480, 0.743165230296, 0.655587055964 },
    { 0.050062336432, 0.707164881898, -0.705274125629 },
    { 0.230111854132, -0.852522349880, 0.469312451938 },
    { -0.023142911417, -0.109857965800, 0.993677831594 },
    { -0.131775223910, 0.875737466752, -0.464455788737 },
    { -0.026947193461, -0.699792204014, 0.713838020819 },
    { 0.688124917527, -0.722774723754, -0.063881112864 },
    { -0.011578022439, -0.986540253584, -0.163108177155 },
    { -0.559202655291, 0.473911211456, -0.680220959668 },
    { -0.509806280179, -0.400240994088, 0.761514742694 },
    { 0.376807150845, -0.923657903095, -0.069802930613 },
    { -0.063985799984, -0.846152821968, -0.529085266547 },
    { -0.946835394719, -0.033352452952, -0.319984920252 },
    { -0.229148792970, 0.899553692503, 0.371878992395 },
    { -0.539417172696, -0.196158905382, -0.818871661275 },
    { -0.236704891027, -0.967886096100, 0.084659905151 },
    { -0.624285148368, -0.469173485261, -0.624615317020 },
    { 0.904957712269, -0.422648894850, -0.049187912005 },
    { -0.972124113489, -0.229498171120, -0.048013512956 },
    { -0.534265631467, -0.843718675892, -0.051952199027 },
    { -0.365613517412, -0.700351631629, -0.613053299445 },
    { 0.748931760010, -0.363958630616, 0.553746633441 },
    { 0.424422772500, 0.886070237738, -0.186399688780 },
    { 0.352585103226, -0.079595473415, 0.932388494993 },
    { -0.897573199426, 0.337036320855, 0.284198645487 },
    { 0.936410817333, 0.249656414172, 0.246589651129 },
    { 0.555446966922, -0.649259967078, 0.519557660022 },
    { -0.483895559388, 0.716809400025, 0.502025269921 },
    { -0.784004170546, -0.117111401908, -0.609608382578 },
    { 0.483561588713, -0.843651655163, 0.233281106528 },
    { 0.612279560618, 0.780837232575, 0.124124759313 },
    { -0.021473068823, -0.268189633460, -0.963126797374 },
    { 0.872129249303, 0.488842246817, 0.020587137672 },
    { -0.312698860578, 0.934178142768, -0.171844756010 },
    { -0.381985715227, 0.514669847193, 0.767594855215 },
    { -0.349757435109, -0.688497876922, 0.635327010333 },
    { 0.793073355961, -0.497266945615, -0.351795731729 },
    { -0.820057388074, -0.562596916997, -0.104836011234 },
    { 0.023142928964, 0.109857699293, -0.993677860650 },
    { 0.647532036229, 0.375729032035, -0.662970554809 },
    { 0.294258653381, -0.625878063034, 0.722280066957 },
    { -0.460024058665, 0.763403125182, -0.453424231721 },
    { -0.269595756590, 0.629784396080, -0.728484551987 },
    { -0.713309291843, 0.653655671288, 0.252832192497 },
    { 0.295687071803, 0.452161611926, 0.841498088096 },
    { 114, DUMMYVAL, DUMMYVAL },
    { 0.920396875840, 0.172305801596, 0.350970513975 },
    { -0.521813731256, -0.382155799004, -0.762671210392 },
    { 0.939627789336, -0.186175904636, -0.287120445180 },
    { -0.112477190591, -0.812123089344, 0.572542548070 },
    { 0.825217301195, -0.007929144724, -0.564759713924 },
    { 0.819812856095, -0.524919560431, 0.228836920224 },
    { 0.278185715122, -0.804176137324, -0.525274640604 },
    { 0.743327709321, 0.300075132017, 0.597845156960 },
    { 0.501879686100, -0.567354463285, -0.652859627845 },
    { -0.452877091022, 0.889431222716, 0.061761156763 },
    { 0.523539824601, -0.253482204824, 0.813420447182 },
    { 0.623582871276, -0.190035804898, -0.758307850090 },
    { -0.177341440023, -0.983911082976, -0.021656279648 },
    { 0.767804564291, -0.385655137520, -0.511611440410 },
    { 0.585195231658, 0.164992601859, -0.793929456675 },
    { -0.201751547477, -0.521546795840, -0.829026690065 },
    { 0.517541305626, 0.078252168370, 0.852072529258 },
    { 0.218701538878, -0.048521186221, 0.974584696874 },
    { -0.695979225614, -0.162669473745, 0.699393708740 },
    { 0.734998324704, -0.393055684029, 0.552525738708 },
    { -0.353331078573, 0.654312181756, 0.668605053615 },
    { -0.981391964010, -0.188718722314, 0.035426781164 },
    { -0.820164421891, 0.445981632886, 0.358372298305 },
    { -0.406664914167, 0.472979818576, -0.781609710025 },
    { 0.029493692853, -0.941778860732, -0.334936859065 },
    { 0.273761253889, -0.830381010959, 0.485306246105 },
    { 0.947498228521, 0.158626300611, -0.277641502129 },
    { 0.928360693881, 0.368527163036, 0.048313064087 },
    { -0.629686588462, -0.708548342564, -0.318518518396 },
    { 0.837883992411, 0.478953770878, -0.261827616234 },
    { -0.657261476300, 0.531838956045, -0.533998760866 },
    { -0.103993712120, -0.786837079227, -0.608336024408 },
    { -0.321278857681, -0.884973400071, -0.337048923413 },
    { -0.450685100311, -0.375053563673, 0.810072691019 },
    { -0.862645956131, -0.452846639516, 0.225326153497 },
    { 0.240229578808, 0.626176965167, 0.741749390131 },
    { 0.760490609293, 0.336151917018, -0.555568107312 },
    { 0.613371453127, 0.675641103443, -0.409004351843 },
    { 0.998640588008, 0.033972011461, 0.039533257151 },
    { -0.064963847133, 0.505660185183, 0.860283369412 },
    { -0.877479025691, -0.442697825198, -0.184524239703 },
    { -0.312745875037, 0.181597161167, -0.932315659368 },
    { 0.024465657202, -0.956833139033, 0.289606242450 },
    { -0.306557468932, 0.874476434810, 0.375916856770 },
    { -0.604264533053, 0.149289759353, 0.782672946924 },
    { 0.012729556130, 0.060315087726, -0.998098215905 },
    { -0.044761643124, 0.778624014422, 0.625892194766 },
    { -0.257668153501, -0.185905797109, -0.948180445523 },
    { 0.198119611914, 0.294192708213, 0.934986240439 },
    { -0.027314305814, 0.868893837670, -0.494244299469 },
    { 0.481614480960, 0.397849976751, 0.780873157259 },
    { -0.833110640672, 0.148981924082, 0.532664103067 },
    { -0.042036543814, 0.396608653326, -0.917024811601 },
    { 0.955368983957, -0.292799040387, 0.039227878364 },
    { -0.272767045157, 0.927854055561, -0.254332441217 },
    { 0.287546265434, 0.320361663159, -0.902599329721 },
    { 0.594001716299, -0.701955532237, 0.392963601107 },
    { -0.392569276613, 0.753780654364, -0.526976363954 },
    { -0.742036860575, -0.670314866264, 0.007699195621 },
    { -0.597166717471, 0.763708982186, -0.245235605231 },
    { 0.138091704120, -0.658307396419, 0.739974359740 },
    { 0.767470130039, -0.043435564136, 0.639611562799 },
    { 0.407644180801, -0.888460711642, -0.210864377570 },
    { 0.620027724892, -0.693208140736, -0.367461690496 },
    { 0.359150029037, -0.359334767172, -0.861330239655 },
    { -0.418321087082, -0.672038016885, 0.611042037804 },
    { -0.592233466181, 0.710182993247, 0.380656850245 },
    { -0.916672545847, 0.396860531452, 0.047044258575 },
    { 0.267527113324, 0.958012707532, 0.103154717993 },
    { 0.917655153900, -0.173613766669, 0.357445490311 },
    { -0.098774004376, 0.132308859587, 0.986274840871 },
    { -0.652048868850, 0.239357474361, -0.719402718996 },
    { 0.566569810603, 0.624609442840, 0.537458550615 },
    { -0.697471623918, -0.466923436429, 0.543613684838 },
    { 0.210223069569, -0.377020187597, 0.902032171913 },
    { -0.323329303053, -0.895572162713, 0.305628308833 },
    { 0.051900077810, -0.294435202920, -0.954261124224 },
    { -0.621273470087, 0.457284109639, 0.636325795830 },
    { -0.349883885850, 0.343640811065, 0.871488530844 },
    { -0.779052587906, -0.110321478026, -0.617176017651 },
    { -0.159346178575, -0.535509602242, 0.829360151731 },
    { -0.980893369267, 0.129261157492, -0.145395155671 },
    { -0.437765908118, -0.670049251702, -0.599495629662 },
    { 0.662929904662, -0.748633499183, 0.008474987111 },
    { 0.792177187191, 0.525821766371, 0.309785044999 },
    { -0.542056297895, -0.051465211604, -0.838764747654 },
    { 0.138066643141, -0.613503643029, -0.777528701748 },
    { 0.731211861509, 0.681816779795, -0.021332894292 },
    { 0.155687868859, -0.987547083082, -0.022628437580 },
    { -0.119479449688, 0.992205707891, 0.035390596658 },
    { -0.135435861467, 0.665449512071, -0.734053182210 },
    { -0.486279924021, -0.873688160500, -0.014171580551 },
    { -0.741059159135, -0.440571501819, -0.506683406524 },
    { 0.335019231358, -0.025543368323, -0.941864985523 },
    { -0.097743834636, -0.230327940841, 0.968191707493 },
    { 0.316103523503, 0.817535295321, -0.481367430695 },
    { -0.970100911542, 0.104228368949, 0.219181816154 },
    { -0.612780245165, -0.721404604860, 0.322607760637 },
    { 0.503215186853, 0.516316227882, -0.692958893836 },
    { 0.470817565705, 0.868181317069, -0.156818431684 },
    { 0.407807739139, -0.896164583786, 0.174876775659 },
    { -0.832175188771, 0.491675067698, -0.256398289774 },
    { 0.017156860283, 0.943433407180, 0.331117876839 },
    { -0.728642378266, 0.681902158202, 0.063951006511 },
    { -0.864621490135, 0.206249545108, -0.458138411333 },
    { 0.551674171993, 0.803188930735, 0.224818036422 },
    { 0.123820982146, 0.969624084207, -0.210944304748 },
    { -0.932608725257, -0.147376838120, -0.329425307406 },
    { 0.197158242820, 0.637192941082, -0.745059583606 },
    { 0.301777342103, 0.831374451480, 0.466633643471 },
    { 0.462195123004, -0.566544542396, 0.682204477963 },
    { 0.835850349920, -0.519307205019, -0.177972524156 },
    { -0.894178020996, -0.177518253312, 0.411014521043 },
    { -0.383343928680, -0.057056908398, 0.921841603286 },
    { 115, DUMMYVAL, DUMMYVAL },
    { 0.663894265614, 0.558985145559, -0.496769575487 },
    { -0.031218232813, -0.264803827127, -0.963796843261 },
    { -0.916885918641, -0.027820817815, 0.398178621092 },
    { 0.496238346383, 0.798159490155, -0.341597616875 },
    { -0.598512246820, 0.393682145431, -0.697708720581 },
    { -0.117476579620, -0.560616603510, 0.819700114133 },
    { -0.568287958139, 0.816424489331, 0.102468775027 },
    { -0.456103470838, 0.280187989623, 0.844668168194 },
    { -0.169581700528, -0.748441275711, -0.641153416632 },
    { 0.303512268618, 0.379052049612, -0.874185247235 },
    { 0.965365587370, 0.021447645911, -0.260017847864 },
    { -0.654262587667, 0.656452085938, 0.375514480741 },
    { -0.860578412797, -0.373484174775, 0.346286538318 },
    { -0.486625098091, -0.638550335637, -0.596195842627 },
    { 0.381601913377, 0.640463755517, -0.666472923364 },
    { 0.683062939954, 0.157394940885, 0.713198326306 },
    { -0.867105790597, 0.324093632618, 0.378273532260 },
    { -0.037927941094, -0.965054960262, 0.259288246858 },
    { -0.345965934802, 0.849476153607, 0.398368970190 },
    { -0.655193166107, -0.690053561246, 0.307486581332 },
    { -0.753014637900, 0.504545071697, -0.422378060196 },
    { -0.422058018597, -0.394685652016, 0.816143532126 },
    { 0.081225790921, 0.274965679135, 0.958016829804 },
    { -0.406903996948, -0.847544917186, -0.340729732515 },
    { 0.579214243345, 0.711087058894, 0.398580048397 },
    { 0.595440159901, -0.797837682563, -0.094371861587 },
    { 0.488717132438, -0.672382194887, 0.555929625458 },
    { 0.158224944387, -0.047333795737, 0.986267904149 },
    { 0.180074638466, -0.794176206697, -0.580394070695 },
    { -0.593810937392, -0.310681001720, -0.742203399213 },
    { -0.285877128020, -0.470564578092, -0.834771373203 },
    { -0.699242592940, 0.694487205662, -0.169550338808 },
    { -0.371135226846, -0.703415553321, 0.606189081673 },
    { -0.654574710114, 0.434656790298, 0.618551067841 },
    { 0.996263833453, 0.005618223504, 0.086178940108 },
    { 0.870400063009, -0.249501175554, -0.424444217431 },
    { -0.114894321943, 0.062092362911, -0.991435239062 },
    { -0.735357994592, 0.117670124988, 0.667384717741 },
    { 0.283588568745, 0.948044220440, -0.144186267609 },
    { -0.064229195558, -0.820822184899, 0.567561055056 },
    { 0.290024283373, -0.919309902547, -0.265998530321 },
    { -0.838251185673, -0.543385203107, 0.045469448670 },
    { -0.839264518717, 0.532941118733, 0.107744287954 },
    { 0.770173490937, 0.611883109486, -0.180088462107 },
    { -0.032429241667, 0.382271419293, -0.923480864055 },
    { 0.503825758932, 0.517004358650, 0.692001515730 },
    { 0.043793477477, -0.997273221418, -0.059399100775 },
    { 0.681004340030, -0.491353576763, -0.542959253962 },
    { -0.009864466616, 0.919457037800, 0.393066721994 },
    { 0.054136738732, 0.659596299788, -0.749667883016 },
    { 0.757909517474, 0.415830470018, 0.502651154905 },
    { 0.794261572032, -0.562677400136, -0.229221941727 },
    { 0.304927393371, -0.273848903081, -0.912154626724 },
    { 0.276782814290, 0.779433130187, 0.562027818956 },
    { 0.205526529938, 0.058974540529, -0.976872995359 },
    { -0.176023672758, 0.822810993383, -0.540368148392 },
    { -0.729698598845, -0.208463528482, 0.651216486382 },
    { -0.144967024923, -0.240495413332, 0.959763782319 },
    { -0.647635717654, 0.044278064060, -0.760662494318 },
    { 0.854003502180, 0.297809463207, -0.426599978772 },
    { 0.063878666706, -0.561233930790, -0.825188457790 },
    { -0.975528380032, 0.008493726032, -0.219709436234 },
    { 0.739495347668, -0.193606396499, 0.644719469236 },
    { 0.404656629680, 0.246082538936, 0.880736280669 },
    { -0.916235529020, -0.338340678462, -0.214564770313 },
    { 0.938469014305, 0.332570416551, -0.093128015249 },
    { 0.744633364544, -0.482041334955, 0.461689618470 },
    { 0.187069330126, -0.369839397129, 0.910068066717 },
    { 0.336244945946, -0.936532337141, 0.099229621661 },
    { 0.199111219613, -0.657956567585, 0.726256068750 },
    { 0.336852370038, 0.908885776116, 0.245880309852 },
    { -0.978738022583, -0.186994730924, 0.084290294559 },
    { 0.393566111000, -0.555964045086, -0.732126831119 },
    { 0.888374422614, 0.043189691244, 0.457083729545 },
    { -0.844898329241, 0.192361825553, -0.499143006879 },
    { 0.921296604729, -0.257388524403, 0.291485357473 },
    { -0.487714552682, -0.069450270887, 0.870236275374 },
    { 0.508959482041, 0.045289244369, -0.859598237542 },
    { -0.377216200348, -0.131741350001, -0.916707235106 },
    { 0.594144267576, -0.764161771378, 0.251096348978 },
    { 0.615065844412, -0.248424731326, -0.748317552850 },
    { -0.198615895212, 0.091029201044, 0.975840873671 },
    { -0.842386248298, -0.137638525922, -0.521000043053 },
    { -0.378653260539, 0.242570021397, -0.893186146894 },
    { -0.291536522399, 0.568243586584, -0.769484036490 },
    { 0.173957576625, 0.860478643606, -0.478868735076 },
    { -0.574543260477, -0.818376715428, 0.012633031523 },
    { 0.570679021206, 0.820906269341, 0.020936850604 },
    { -0.981110446485, 0.163815126526, 0.102892643663 },
    { -0.919446574872, 0.354627470664, -0.169874521358 },
    { -0.072545325005, 0.742724776651, 0.665655377781 },
    { 0.052367619146, 0.995512560345, 0.078818618743 },
    { -0.071944227806, 0.966296014671, -0.247176131770 },
    { -0.282086872570, -0.958736294078, -0.035379580852 },
    { 0.611591645083, 0.324487484148, -0.721570185287 },
    { -0.747242573155, -0.456211508404, -0.483217959584 },
    { 0.788024661494, 0.023854410654, -0.615181355349 },
    { -0.074403903294, -0.926277181200, -0.369424745737 },
    { -0.696461453407, -0.672090780683, -0.251466551333 },
    { 0.788914847654, 0.592153637567, 0.164217638112 },
    { -0.493439510664, 0.701656613379, -0.513999461300 },
    { -0.636634307324, -0.510772802452, 0.577761112410 },
    { 0.253590103952, -0.871421581926, 0.419900566482 },
    { -0.177431283900, 0.469482310388, 0.864930343858 },
    { 0.496613880855, -0.411628040322, 0.764157712624 },
    { -0.407498782193, 0.881556974205, -0.238331793393 },
    { 0.477430058576, -0.093688412848, 0.873660700997 },
    { 0.952534286172, -0.294831704063, -0.075846555263 },
    { -0.397576990493, 0.638633265818, 0.658847545660 },
    { 0.822462350537, -0.556511340425, 0.117689463961 },
    { 0.924458178169, 0.295246158697, 0.241260818598 },
    { -0.270502198913, 0.959715650911, 0.075989668898 },
    { -0.361716997573, -0.878823431465, 0.311175497066 },
    { 0.508297563675, -0.743832366389, -0.433989628303 },
    { 0.185099981444, 0.557956951111, 0.808963557632 },
    { 116, DUMMYVAL, DUMMYVAL },
    { 0.821140411544, -0.548553764906, 0.157534731208 },
    { 0.462023808200, -0.247690891271, 0.851576903772 },
    { -0.745753922593, 0.547303549330, -0.379881444437 },
    { -0.483650546275, -0.343031887259, 0.805239885631 },
    { -0.589853275660, -0.266971905160, -0.762101774731 },
    { -0.480914699627, -0.790094956486, -0.380093424592 },
    { -0.245473740581, -0.124276669213, 0.961404156520 },
    { 0.570970944981, 0.065803061166, -0.818328868566 },
    { 0.752221851917, -0.428152029557, -0.500847406986 },
    { 0.154623941686, -0.744011327434, -0.650029677252 },
    { 0.761184760363, 0.629170610999, 0.157296226420 },
    { -0.331478444054, 0.579588525342, 0.744445553697 },
    { -0.109159582480, 0.929348351628, 0.352697925821 },
    { -0.886065937136, -0.342014206575, -0.312911229501 },
    { 0.805845421704, 0.177234169637, 0.564978942467 },
    { 0.325103338019, -0.751007865139, 0.574712977154 },
    { -0.058809075944, 0.762840493922, 0.643906727266 },
    { -0.164457951172, 0.861322571147, -0.480704702212 },
    { 0.901968829626, 0.424549288377, -0.078804391510 },
    { -0.127799915777, 0.991310444406, 0.031157412263 },
    { 0.395445876475, 0.897255633484, -0.196353983816 },
    { -0.921297277412, 0.309151436749, -0.235874364416 },
    { -0.319921295003, -0.036528195480, -0.946739698089 },
    { -0.728548480461, -0.654535248137, -0.201991882421 },
    { 0.782780920566, 0.206413591132, -0.587066827366 },
    { -0.005655354628, 0.698006841307, -0.716068758188 },
    { -0.814272728826, 0.208947120589, -0.541572731855 },
    { 0.059335613211, -0.945067046278, -0.321446049974 },
    { 0.383784652539, -0.893056248082, 0.234861402186 },
    { 0.299694649070, -0.096673096048, -0.949124559697 },
    { -0.661221180561, -0.521900590874, 0.538893610672 },
    { -0.811667382919, -0.129700759921, -0.569538209765 },
    { 0.526194007253, 0.697930239614, -0.485811946502 },
    { 0.778204728929, 0.488209794209, -0.395029868126 },
    { 0.731586522684, -0.152683454047, 0.664431277625 },
    { -0.395465308853, 0.786132946042, 0.474975979014 },
    { -0.366961732203, -0.635179873749, 0.679621670551 },
    { -0.736778808580, -0.647498571193, 0.194685868853 },
    { 0.678104952913, 0.717446492564, -0.159512391814 },
    { -0.860902225638, 0.378458328573, 0.340024486508 },
    { -0.248594934735, -0.955183948611, 0.160699043992 },
    { -0.679606200471, 0.693342157493, 0.239608148699 },
    { -0.962519149362, -0.014837193680, -0.270807578911 },
    { 0.566776822946, -0.497978055166, 0.656339766846 },
    { 0.255170677128, -0.448671454538, -0.856493929586 },
    { 0.539968038618, 0.455176275145, 0.707989460244 },
    { 0.006552517037, -0.712509126902, 0.701632245982 },
    { -0.290782788209, 0.243517103885, 0.925280925015 },
    { 0.256154304245, 0.660247461372, 0.706015766232 },
    { -0.642133675239, 0.547861285098, 0.536201786099 },
    { -0.785154946711, 0.160834429638, 0.598050161691 },
    { -0.990071911351, -0.134339248560, 0.041359118103 },
    { -0.529693513463, -0.848155833952, -0.007514195126 },
    { -0.307315459344, -0.361310087677, -0.880347788656 },
    { 0.932702837055, -0.055185803150, 0.356398575866 },
    { 0.612658133132, -0.690861245207, 0.383875958845 },
    { -0.596853340154, 0.426086853960, -0.679864753631 },
    { 0.274897202545, 0.357312744136, 0.892613651538 },
    { -0.331138117684, 0.294144354278, -0.896563799104 },
    { 0.945452484833, -0.176360048391, -0.273891825827 },
    { 0.997709702550, 0.067012383873, 0.009202708553 },
    { -0.005183318960, 0.096024941552, -0.995365432293 },
    { 0.302660389982, 0.260968490887, -0.916674497900 },
    { -0.637951119995, 0.759723274908, -0.125852747529 },
    { -0.559720789516, 0.326761412776, 0.761537666110 },
    { 0.485360078044, -0.591475435927, -0.643880736889 },
    { -0.431158734995, 0.890518513418, 0.145185820582 },
    { 0.200912002500, 0.974691963189, 0.098030322584 },
    { 0.088305540629, -0.236278907170, 0.967664409556 },
    { -0.897186997000, -0.441643879053, 0.002485258481 },
    { -0.030794167412, 0.486211201244, 0.873298566951 },
    { -0.603727406061, 0.085019956124, -0.792644199014 },
    { 0.963471516534, -0.254743379728, 0.082634419665 },
    { 0.223969149427, 0.835114571343, -0.502415637531 },
    { -0.684480928218, -0.505467181312, -0.525346350061 },
    { -0.876353443017, -0.343105953076, 0.338057610291 },
    { -0.170054169549, -0.824433066744, -0.539807093209 },
    { -0.315665421405, 0.597527451543, -0.737099916146 },
    { -0.546893416182, -0.008251110549, 0.837161579692 },
    { 0.505370943694, 0.851152965508, 0.141911375781 },
    { 0.055529868204, -0.997898225287, 0.033400085422 },
    { 0.364534550861, -0.831541664683, -0.419109796025 },
    { 0.856998623092, -0.485612196877, -0.172435942491 },
    { -0.976755585352, 0.199360202289, 0.078765704634 },
    { 0.296251392499, 0.579214202211, -0.759437963497 },
    { 0.055710444227, 0.968658583001, -0.242067957363 },
    { 0.091823979638, -0.923454667961, 0.372558496058 },
    { -0.072387853317, -0.582503126287, -0.809598731816 },
    { 0.632206855540, -0.774699654835, 0.012447353403 },
    { -0.489591971609, 0.731116672076, -0.475150621539 },
    { 0.510978289362, 0.726921074419, 0.458788556272 },
    { 0.746506379454, 0.487567690617, 0.452775852382 },
    { -0.146130459030, -0.457706316954, 0.877012437975 },
    { 0.218393230699, 0.878841900430, 0.424194897228 },
    { -0.754814037999, -0.191637270578, 0.627320432128 },
    { -0.247189829857, -0.950274650809, -0.189407697957 },
    { 0.925612037525, 0.291360436616, 0.241560451986 },
    { 0.818194264137, -0.374151330661, 0.436542011607 },
    { 0.306721577433, 0.021624067621, 0.951553610490 },
    { -0.408329862873, -0.615046421371, -0.674525479612 },
    { -0.349504903590, 0.913544917084, -0.208043281163 },
    { -0.500422005064, -0.786669578986, 0.361564365425 },
    { -0.933220746046, -0.004484966652, 0.359275554725 },
    { -0.011744704617, 0.419280295730, -0.907780863164 },
    { 0.557629327712, -0.279688245853, -0.781552313033 },
    { 0.938864334714, 0.161406348587, -0.304108124914 },
    { 0.241224652286, -0.509062293436, 0.826236194155 },
    { 0.354114974261, -0.929494304610, -0.103164541880 },
    { 0.000456651539, 0.129999490713, 0.991513955466 },
    { 0.803464371353, -0.117069853316, -0.583729092483 },
    { 0.579012257941, 0.129575901788, 0.804956452754 },
    { -0.002621796981, -0.248226056860, -0.968698586185 },
    { 0.567912755802, 0.418899635991, -0.708518310818 },
    { -0.849017543446, 0.528319756715, 0.006888075552 },
    { 0.640912967637, -0.700246422924, -0.314460673370 },
    { -0.200391279105, -0.852248283456, 0.483235138007 },
    { 117, DUMMYVAL, DUMMYVAL },
    { 0.896888344429, 0.112058127582, -0.427825050306 },
    { -0.385742399984, 0.830907314161, -0.400993561205 },
    { 0.012204400927, -0.517642397352, -0.855510023940 },
    { 0.104301919875, -0.755847660232, -0.646386435526 },
    { -0.736838287649, -0.240592690381, 0.631810489933 },
    { -0.110306981928, -0.216326983056, -0.970069588298 },
    { 0.207520875625, 0.969944987060, -0.127050416204 },
    { 0.185710875796, 0.629921911466, -0.754128540812 },
    { 0.310405512780, 0.404739236103, 0.860136366162 },
    { -0.748311426792, 0.539662246494, 0.385739119409 },
    { -0.361899097370, 0.224701292609, 0.904731105038 },
    { 0.983665952235, -0.070557120702, 0.165598874187 },
    { -0.174249810529, 0.170120208123, -0.969894900656 },
    { 0.228331599990, -0.788022664178, 0.571738542681 },
    { 0.162961990794, 0.851844618942, -0.497799291619 },
    { 0.598473311983, -0.758183497273, -0.258819395152 },
    { -0.189842342684, -0.378715166977, 0.905833708374 },
    { -0.095724344224, 0.949038188848, -0.300272153274 },
    { 0.260303475764, 0.800234572795, 0.540246914853 },
    { -0.854243680817, 0.516679248230, 0.057535104354 },
    { 0.825568580626, -0.505528455034, -0.250753863050 },
    { 0.701121621448, 0.651140477595, -0.290593445170 },
    { -0.980282486621, 0.171489184569, -0.098171818767 },
    { -0.152207419508, 0.786010802708, 0.599182709592 },
    { -0.637876850554, 0.626745416043, -0.447552574562 },
    { 0.721129258403, -0.691300944180, 0.045558723102 },
    { 0.180374984842, 0.344997590884, -0.921108857371 },
    { 0.436726195018, 0.839701327235, -0.322756737536 },
    { 0.988903583774, 0.104035654862, -0.106048500777 },
    { 0.077421636484, -0.995935449363, -0.046026849837 },
    { 0.687586847034, 0.321999216486, 0.650800147793 },
    { 0.007450040172, -0.620839973918, 0.783901922237 },
    { 0.323612378606, -0.504487178607, 0.800479678090 },
    { -0.497889568828, -0.865976647994, 0.046801948478 },
    { 0.936283357034, 0.317927020226, 0.149318067060 },
    { 0.956287290288, -0.205181307094, -0.208363263684 },
    { 0.521960935525, -0.641003759562, 0.562735250373 },
    { 0.785420564517, 0.615755047211, 0.062930586101 },
    { -0.706335802849, 0.353432235993, -0.613331385284 },
    { 0.915134585459, -0.395355628021, 0.078883571734 },
    { 0.735670637470, -0.034287496291, 0.676471049464 },
    { 0.584273424312, -0.240527831385, -0.775094141361 },
    { -0.076771167776, 0.996015459948, 0.045380517211 },
    { 0.422920615628, -0.733959605344, -0.531452209140 },
    { 0.367503436311, -0.519693178456, -0.771271822749 },
    { -0.986956167437, -0.116081531790, 0.111546409785 },
    { 0.178003658044, -0.945263449704, 0.273480727614 },
    { 0.559490247409, 0.755395788821, 0.341098028851 },
    { -0.567320941861, -0.597489933798, -0.566703386205 },
    { 0.548501548378, 0.836146409610, -0.002287601960 },
    { -0.440719068023, -0.813013442720, 0.380494211570 },
    { 0.762690609998, -0.544712028535, 0.348700214209 },
    { 0.254872871618, -0.262753385629, -0.930591466570 },
    { -0.655654235800, 0.069307768495, 0.751873630541 },
    { -0.326848838346, -0.447575763975, -0.832373577413 },
    { 0.484172792749, 0.643235348512, -0.593148373669 },
    { 0.445324127323, -0.188493757921, 0.875303675788 },
    { 0.119728925280, -0.277342436118, 0.953281782884 },
    { 0.652993127187, -0.359993705175, 0.666336632702 },
    { -0.610524828269, 0.769043942880, 0.189290380067 },
    { -0.438171805752, -0.822113432718, -0.363503744669 },
    { -0.689660789084, -0.702029852549, -0.177544591951 },
    { -0.246416492633, -0.716885843985, -0.652191382074 },
    { -0.647795385613, -0.573196435529, 0.501803731230 },
    { -0.727735848497, -0.661862165393, 0.179830500287 },
    { -0.409497998695, -0.081184354869, -0.908691636139 },
    { 0.116781962842, 0.031970298336, -0.992642872930 },
    { -0.945258201592, 0.239090974846, 0.222086555356 },
    { 0.771493697073, 0.502269724107, 0.390541418575 },
    { -0.452650478515, 0.286782204726, -0.844312448891 },
    { -0.123720552734, -0.020538362908, 0.992104531025 },
    { -0.962097804668, -0.161759867897, -0.219548535388 },
    { -0.476937058051, 0.700136216067, 0.531357056609 },
    { -0.387759671141, 0.919462197628, -0.065051553171 },
    { -0.676484024136, 0.041567809843, -0.735283266690 },
    { -0.431215240618, -0.118702046787, 0.894406641493 },
    { 0.503022026718, 0.141696615567, 0.852578975681 },
    { 0.199223189392, 0.067921717666, 0.977597443265 },
    { 0.500519056491, -0.816789076612, 0.286942988093 },
    { -0.804288006730, -0.465489753177, -0.369377979740 },
    { 0.437222157856, 0.052045478018, -0.897846341474 },
    { -0.869817018857, -0.376209763493, 0.319193620800 },
    { 0.491464483591, 0.371839331407, -0.787526617320 },
    { -0.323444940868, 0.900930077141, 0.289323981599 },
    { 0.873717176665, -0.234988448375, 0.425909291200 },
    { 0.011623464533, 0.932604269492, 0.360713420319 },
    { -0.896480689640, -0.442226935688, -0.027526540934 },
    { 0.890941369171, 0.403695415039, -0.207974730617 },
    { -0.128007114887, 0.492177067341, -0.861031888447 },
    { -0.892389537113, 0.133501965865, -0.431066281634 },
    { -0.025882329958, 0.328770771799, 0.944055022023 },
    { 0.706661863537, 0.086923655836, -0.702191774858 },
    { -0.807094960588, 0.255913728131, 0.532076957167 },
    { -0.315577345654, -0.670526980121, 0.671419770218 },
    { -0.829345243487, -0.181836403071, -0.528319968981 },
    { 0.244985853324, -0.914283941300, -0.322593872156 },
    { -0.258863278675, 0.540504548198, 0.800527723649 },
    { 0.826623222047, -0.209706618794, -0.522223307415 },
    { 0.667068064286, -0.501625808644, -0.550810081345 },
    { -0.664504055644, 0.734370817078, -0.138325207598 },
    { -0.131047945609, 0.763884516348, -0.631907336273 },
    { -0.083277200855, -0.907612146175, -0.411467009532 },
    { 0.738938099497, 0.403290792564, -0.539747183175 },
    { 0.090821912403, 0.628369079165, 0.772595418428 },
    { 0.892349180489, 0.140577979802, 0.428894825891 },
    { 0.489721500060, 0.587944770656, 0.643811928312 },
    { -0.176044850292, -0.962370331807, 0.207006171753 },
    { -0.413936558950, 0.587610884676, -0.695248137987 },
    { -0.856799464648, 0.438901934571, -0.270665419307 },
    { -0.567605201884, 0.423694866570, 0.705908630657 },
    { 0.414708376741, -0.909801226231, -0.016694041105 },
    { -0.901671110845, -0.045250984203, 0.430048318560 },
    { -0.243423741356, -0.961117101058, -0.130379446995 },
    { 0.296953299462, 0.933895593077, 0.199142559918 },
    { -0.495591446641, -0.416151994130, 0.762369094204 },
    { -0.607176797771, -0.312108281247, -0.730701551269 },
    { -0.092610332593, -0.855533810395, 0.509396923399 },
    { 118, DUMMYVAL, DUMMYVAL },
    { -0.118639388291, 0.989573638075, -0.081662172226 },
    { -0.157678472901, 0.907259554640, -0.389894344276 },
    { -0.607716619337, 0.725439648566, 0.323137473639 },
    { -0.060156122151, -0.979334998878, 0.193091172613 },
    { 0.108685924131, 0.573836626411, 0.811725874963 },
    { -0.490032535797, 0.600284906745, 0.632080805432 },
    { 0.660205155309, 0.487096673077, 0.571721946387 },
    { -0.309979012072, -0.708106639699, -0.634427299924 },
    { -0.227094789023, 0.427113751875, 0.875215287662 },
    { 0.250591093463, -0.967639056273, 0.029643897390 },
    { -0.958025967742, 0.108271529735, -0.265449658092 },
    { 0.760043334744, 0.644331000124, -0.084685840556 },
    { 0.584042945456, -0.132170592037, 0.800889987741 },
    { -0.686558608643, 0.726551347595, -0.027575645171 },
    { -0.487630171594, -0.688618497424, 0.536676234575 },
    { -0.822683232521, -0.551744141389, -0.137006209246 },
    { -0.629851946015, -0.196479699757, -0.751453427488 },
    { -0.569176684520, -0.502287536258, -0.650957089767 },
    { 0.020729206322, -0.069576584627, 0.997361217853 },
    { -0.742775794960, 0.435952238253, 0.508163127730 },
    { 0.421350757101, -0.721417215744, 0.549564136675 },
    { 0.805222591615, 0.545796631752, 0.231781394249 },
    { -0.039503696335, 0.363863789287, -0.930614098766 },
    { -0.644828864950, 0.137445513086, -0.751867319319 },
    { -0.228670047268, 0.579932184913, -0.781913467325 },
    { 0.793672265592, -0.559111141913, -0.239747921405 },
    { 0.363305705604, 0.110308424927, 0.925116757856 },
    { 0.943607325111, -0.330491274948, 0.019512385297 },
    { -0.302036371768, -0.952952736316, -0.025595165123 },
    { -0.723263688233, -0.212425110998, 0.657088433546 },
    { -0.252931036842, 0.108132953401, 0.961422464368 },
    { -0.558985174355, 0.466131983281, -0.685752542113 },
    { 0.060978917392, 0.840237317074, 0.538779010941 },
    { 0.950379079628, 0.301523463295, 0.076571574933 },
    { -0.746418260810, -0.478651165494, 0.462334123445 },
    { -0.967494135837, 0.250909163502, 0.031617855585 },
    { -0.592526893506, -0.802557782807, -0.069374964710 },
    { 0.556856862609, -0.823610245064, -0.107594603909 },
    { 0.664692181375, 0.188595485322, 0.722921881627 },
    { -0.033629917770, -0.609610994308, -0.791987035405 },
    { -0.701759933499, -0.680576326106, 0.210591690434 },
    { 0.997732845548, 0.005046869111, -0.067109597129 },
    { 0.264012480522, -0.084692961479, -0.960793688783 },
    { 0.867442526647, 0.256093602127, 0.426567145844 },
    { -0.159480587157, -0.849572537791, 0.502784690848 },
    { 0.565369026289, 0.122631583797, -0.815671109436 },
    { 0.824682999414, -0.073983039203, 0.560735642159 },
    { -0.805554854880, -0.379581674572, -0.454971568461 },
    { 0.888641644793, 0.390901247868, -0.239817100212 },
    { 0.174323170952, 0.921107701505, -0.348097736702 },
    { -0.029313922311, -0.862913749172, -0.504500302723 },
    { -0.836841917012, 0.513954931921, 0.188536293284 },
    { 0.243327643249, -0.736711402063, -0.630910427954 },
    { -0.951009100650, -0.233396095508, -0.202750963211 },
    { -0.667941760161, 0.634054623159, -0.389651818785 },
    { 0.221563356368, 0.974824434971, -0.025039970021 },
    { 0.410340394502, 0.416930524658, 0.811042352931 },
    { -0.907162981956, -0.156177842065, 0.390722159362 },
    { 0.759363837784, 0.297917412437, -0.578456374529 },
    { 0.184777050706, -0.901242131648, 0.391943952212 },
    { -0.415653816233, -0.867909081132, 0.271966416933 },
    { -0.055156106952, 0.050538678663, -0.997197897022 },
    { 0.293941774677, -0.223160918165, 0.929407035536 },
    { -0.846358874193, -0.049070299611, -0.530347774363 },
    { 0.289013509225, -0.901680770069, -0.321625528174 },
    { -0.862844883533, 0.468920381176, -0.188712434882 },
    { -0.325218672762, -0.409065606552, -0.852583218474 },
    { -0.336768266053, -0.876116640043, -0.344973575828 },
    { -0.807991447330, 0.314565672713, -0.498195000569 },
    { -0.391019381710, 0.738190285126, -0.549708055310 },
    { -0.513155299876, -0.054550759615, 0.856560478212 },
    { 0.234668248184, -0.422925661560, -0.875251219987 },
    { 0.486193369492, -0.527880500374, -0.696389391639 },
    { -0.251308995584, -0.270422667389, 0.929362883755 },
    { -0.305386154995, 0.851772203645, 0.425703428968 },
    { 0.192712983840, 0.561712475630, -0.804574919185 },
    { 0.664326522742, -0.398176071466, 0.632555204937 },
    { 0.371664550116, 0.735556872869, -0.566411113028 },
    { 0.279838262287, 0.245346751462, -0.928167828847 },
    { 0.924002143667, 0.095020802600, -0.370393150008 },
    { -0.452683609048, 0.863557136649, -0.222140995411 },
    { -0.994220905122, -0.074905256571, 0.076902499023 },
    { -0.495779622541, -0.425988554581, 0.756793444236 },
    { 0.780088272889, -0.068648448041, -0.621892014004 },
    { 0.102624919780, -0.718496793324, 0.687917497831 },
    { 0.375303365454, -0.498844770627, 0.781217817703 },
    { -0.049858376304, -0.275573891824, -0.959986027220 },
    { -0.049891219113, 0.970418086836, 0.236219395894 },
    { 0.775659680235, -0.626244924056, 0.078545245251 },
    { 0.555985892480, -0.713191880861, -0.426892291378 },
    { 0.011317183172, 0.771803435675, -0.635760472226 },
    { 0.687429002489, -0.614310330064, 0.387381188127 },
    { 0.537899165406, -0.216278510542, -0.814793282823 },
    { -0.400763696264, 0.909928933652, 0.106854084898 },
    { -0.528442612531, 0.298787862662, 0.794653520969 },
    { -0.918559441423, 0.181927109078, 0.350928881050 },
    { -0.369386746157, -0.072818795690, -0.926418293622 },
    { 0.035349402767, -0.443045096260, 0.895802133512 },
    { 0.919748142213, -0.241993510916, -0.309034780518 },
    { -0.362961072839, 0.261877553901, -0.894247955752 },
    { 0.574368372685, 0.733570084238, 0.363284879910 },
    { 0.507830294968, 0.459803198910, -0.728484323637 },
    { 0.875345637200, -0.340646424825, 0.343118097293 },
    { 0.075597533590, 0.272495502463, 0.959182575974 },
    { -0.759916495201, 0.116460109554, 0.639502903203 },
    { 0.674933842735, 0.596832324933, -0.433884182525 },
    { 0.286221617737, 0.908888340643, 0.303313649187 },
    { -0.617362314097, -0.686876509266, -0.383489809710 },
    { 0.493389225373, 0.829422409778, -0.261964765655 },
    { -0.183577239823, 0.695225617229, 0.694953766928 },
    { -0.010931338174, -0.982769014840, -0.184514414928 },
    { 0.492371498288, -0.841609947200, 0.221952707683 },
    { 0.361069169813, 0.699702429395, 0.616478357210 },
    { 0.966680405289, -0.022011670230, 0.255038194009 },
    { -0.220915168730, -0.616197360027, 0.755974405467 },
    { 0.740153627005, -0.397215287581, -0.542579601297 },
    { -0.903649665186, -0.402908708041, 0.145195921408 },
    { 0.535155025955, 0.842631926109, 0.059837574297 },
    { 119, DUMMYVAL, DUMMYVAL },
    { -0.893143610776, -0.432674603866, 0.122829872992 },
    { 0.016727442121, 0.827229363218, 0.561615325032 },
    { 0.966885905734, 0.221666365406, 0.126473980487 },
    { -0.503597055313, -0.094956724423, -0.858704388231 },
    { 0.889942497415, 0.433831882633, -0.140684927785 },
    { -0.895589385290, 0.399241336046, -0.196280433433 },
    { -0.889447078514, 0.436566406425, 0.135254084241 },
    { -0.246238695004, -0.910710626681, -0.331621259170 },
    { 0.311216980840, -0.515762592589, 0.798206075474 },
    { -0.509455812202, 0.516647063066, -0.688135588121 },
    { -0.699312487880, -0.714699893787, 0.012888216135 },
    { 0.036434956569, -0.380042821481, 0.924251019897 },
    { -0.949369329746, -0.147615056209, 0.277322323150 },
    { 0.258133007268, 0.910104258565, 0.324156735394 },
    { -0.671998684944, -0.547915147289, -0.498203531506 },
    { 0.979835492116, 0.092838963054, -0.176927486075 },
    { 0.077433991705, -0.391374057294, -0.916968006097 },
    { 0.456185509532, 0.811924247667, -0.364244144693 },
    { -0.535121651439, 0.225115071139, -0.814228483233 },
    { 0.848618835956, 0.335978597415, 0.408612840399 },
    { 0.363836964813, 0.729829501552, 0.578767277669 },
    { -0.559846951826, -0.318839823991, 0.764795761735 },
    { 0.184098052716, -0.976654328524, 0.110698823666 },
    { 0.885600900613, -0.440373871690, 0.147586916651 },
    { 0.075897371194, 0.250739161068, -0.965074847954 },
    { 0.617579526681, -0.712118570085, -0.333890207049 },
    { -0.776327250955, 0.047072988669, -0.628569911117 },
    { 0.114182653287, 0.551478997249, -0.826337241858 },
    { -0.517254685264, -0.606786733721, 0.603537447349 },
    { -0.484337185958, 0.854443408562, -0.187999871979 },
    { 0.117372082276, -0.067686705715, 0.990778635302 },
    { 0.893825120824, 0.014596371010, 0.448178088863 },
    { -0.012576090410, -0.827719460699, -0.561001191024 },
    { -0.565201221618, -0.773714629540, -0.286204911063 },
    { 0.635268851579, 0.404018992442, -0.658180932540 },
    { 0.425619409479, 0.904670124950, -0.020495933717 },
    { -0.230225360284, 0.088605761069, -0.969095094708 },
    { -0.912908675065, 0.152360800630, 0.378660715447 },
    { 0.856333171033, 0.263994077136, -0.443847527227 },
    { -0.839434973275, -0.500962489285, -0.210678688937 },
    { -0.770831786120, 0.350704647782, -0.531812568046 },
    { 0.694224594379, -0.112963706049, 0.710838528553 },
    { -0.229974785309, 0.412087445144, -0.881643655723 },
    { 0.536116650616, -0.555405602896, -0.635691397774 },
    { -0.170752911353, 0.688014010663, -0.705322737756 },
    { -0.414853954564, 0.330035970597, 0.847922434244 },
    { 0.675884568103, -0.735475829100, 0.047490582327 },
    { 0.141462588442, 0.594715162955, 0.791392577058 },
    { -0.423739146245, 0.758226154258, -0.495518147941 },
    { 0.695593460458, 0.228514594625, 0.681124671269 },
    { 0.113396451589, 0.992602501011, 0.043376488488 },
    { 0.409643978140, 0.637011091701, -0.652999755148 },
    { 0.409774482006, -0.720082614405, 0.559969554823 },
    { -0.179538019453, 0.081946297351, 0.980332037588 },
    { 0.567739133499, 0.779267718888, 0.265356549936 },
    { 0.610133758173, -0.437127475022, 0.660799793976 },
    { 0.407699424733, 0.005695972969, -0.913098425672 },
    { 0.444054619637, 0.439685074875, 0.780700025433 },
    { 0.875005586642, -0.072302079052, -0.478683227940 },
    { 0.049567126536, -0.691226272798, 0.720936432538 },
    { 0.222169942795, -0.637646147428, -0.737596032520 },
    { 0.164984937243, 0.946577958198, -0.277074249141 },
    { 0.094233494268, -0.071875053501, -0.992952176715 },
    { -0.214065801192, 0.645440741516, 0.733199892219 },
    { -0.642926172057, 0.703157188846, 0.303670718144 },
    { -0.116331165171, 0.953516196985, 0.277981873683 },
    { -0.697645052129, 0.620485577239, -0.358174579888 },
    { 0.337625325821, -0.812645209580, -0.474991476461 },
    { 0.135622218406, 0.802353670228, -0.581235926062 },
    { -0.441032798676, -0.452441574540, -0.775104310477 },
    { -0.699469805520, -0.270166649161, -0.661628273917 },
    { -0.708815680282, -0.624514939565, 0.327965579974 },
    { 0.384560852172, 0.330339413800, -0.861967993992 },
    { -0.456763762286, -0.830918537233, 0.317712527207 },
    { -0.136951584792, -0.603999054941, -0.785130183507 },
    { -0.255472710574, -0.534798051251, 0.805434502942 },
    { 0.403273809262, -0.222030447231, 0.887734597312 },
    { -0.782007247461, -0.069612771654, 0.619369620616 },
    { -0.431486146352, 0.891385074147, 0.138752856166 },
    { 0.641815962070, 0.563432373810, 0.520207872850 },
    { 0.460284298818, 0.095980406040, 0.882567915754 },
    { -0.788554860046, -0.363401884764, 0.496105132858 },
    { -0.222691334743, -0.792074150037, 0.568354739818 },
    { -0.511321014273, -0.001057600594, 0.859389144593 },
    { -0.348972913453, 0.810505553558, 0.470423908117 },
    { 0.679573614944, 0.094187790672, -0.727535814898 },
    { -0.727351902903, 0.685939764271, -0.021115139942 },
    { 0.789949778985, -0.403900157223, -0.461350202859 },
    { -0.108327135113, -0.993200990901, -0.042626558289 },
    { 0.840354916604, -0.307733506976, 0.446210379556 },
    { -0.990835115060, 0.130711335777, 0.034063491650 },
    { 0.125408706060, -0.955385780424, -0.267414784574 },
    { -0.219181560869, -0.255180697045, -0.941723024690 },
    { 0.810354038697, 0.560008158337, 0.172386758668 },
    { 0.689301215460, -0.620279889858, 0.374321643247 },
    { -0.145000083937, 0.901963737874, -0.406738725988 },
    { 0.705532530949, 0.588407699736, -0.394968640101 },
    { 0.830049644178, -0.534164840221, -0.160267001190 },
    { 0.426627250356, -0.896664168075, -0.118247870778 },
    { 0.187861540365, 0.258702657266, 0.947513048340 },
    { 0.448121126346, -0.856267462752, 0.256891977988 },
    { 0.956691902635, -0.233071324674, -0.174408603709 },
    { 0.685696519046, 0.722407159634, -0.089152562931 },
    { -0.528797522036, 0.566941270830, 0.631625503062 },
    { -0.185679560277, 0.978653343217, -0.088095032246 },
    { -0.942362629616, 0.097524978775, -0.320064919694 },
    { -0.421090382645, -0.907017141385, -0.001671788609 },
    { -0.100638633565, 0.394113688012, 0.913535038384 },
    { -0.375216557707, -0.725006606843, -0.577562078790 },
    { -0.980716363517, -0.177721775837, -0.081304272483 },
    { 0.658672026345, -0.228086129256, -0.717027112006 },
    { -0.692405426437, 0.236158641511, 0.681765224605 },
    { -0.778493990011, 0.444657311947, 0.442975148794 },
    { -0.141352592684, -0.949368034891, 0.280570452595 },
    { 0.135499888474, -0.881779568317, 0.451779341186 },
    { 0.386551506633, -0.326518727890, -0.862533160555 },
    { -0.262184582701, -0.228745763346, 0.937515130729 },
    { 0.982554656802, -0.116001946673, 0.145361256067 },
    { -0.888804347013, -0.226623295269, -0.398332417426 },
    { 120, DUMMYVAL, DUMMYVAL },
    { 0.724686299811, 0.205319010699, 0.657779500069 },
    { -0.376764771879, 0.913415238207, 0.154015938402 },
    { 0.211628432269, 0.446956593292, -0.869162361339 },
    { -0.927968159873, -0.372617345682, -0.005604280363 },
    { -0.632281170842, 0.530981585464, 0.564162278867 },
    { 0.250980187312, 0.139351455921, -0.957909242731 },
    { -0.313350999480, -0.935749234882, -0.161816317291 },
    { 0.941066760394, 0.337080944105, 0.027745082491 },
    { -0.784866626739, -0.593441135906, 0.178359178195 },
    { -0.451023784160, 0.789360484294, -0.416518393300 },
    { 0.232374646565, 0.848563702752, -0.475333215761 },
    { -0.622129917440, 0.086711781816, -0.778097315713 },
    { 0.626743064768, -0.546475344500, -0.555479818372 },
    { 0.699032257333, 0.461715593738, -0.546051841594 },
    { -0.847425075856, 0.424297461561, 0.319127568415 },
    { -0.710472902499, 0.598604852107, -0.370000656551 },
    { -0.078296811476, -0.703369257909, 0.706499325082 },
    { -0.964248223664, 0.260202246121, 0.050201138182 },
    { -0.247932109684, 0.148242443863, 0.957368187703 },
    { -0.935620485203, 0.079343598221, 0.343975146036 },
    { -0.563899761161, -0.735574925150, 0.375428540277 },
    { -0.075326698394, -0.986246601287, 0.147117401955 },
    { 0.622650067435, -0.099717851192, 0.776120637322 },
    { 0.743239213488, -0.347634182132, 0.571616958239 },
    { 0.885040686643, 0.288412529524, 0.365405522400 },
    { -0.385339121973, -0.908257907772, 0.163037830108 },
    { 0.096595217548, 0.163190497553, 0.981854482831 },
    { -0.220056120273, -0.449104639520, 0.865956307611 },
    { 0.291420666995, 0.949640493615, 0.115138732555 },
    { 0.075557503079, -0.449012724009, -0.890325017848 },
    { 0.096606077564, -0.870639269950, -0.482342748881 },
    { -0.120581655840, 0.476949077718, -0.870620262536 },
    { 0.510358025640, 0.435899868355, 0.741300202639 },
    { 0.094092772560, -0.892728807189, 0.440660671000 },
    { 0.248217380051, -0.692948023250, 0.676912970266 },
    { 0.410792348289, 0.624129307125, -0.664614365309 },
    { -0.353352401087, -0.156658545198, 0.922279882065 },
    { 0.521077496916, 0.310698408434, -0.794949521168 },
    { 0.053554377159, 0.981759124946, -0.182430669770 },
    { -0.998081743272, -0.059026267324, 0.018674407991 },
    { 0.843326886633, -0.420666405993, -0.334424187450 },
    { -0.569417896648, -0.330050422708, 0.752881117739 },
    { 0.685790997724, 0.541005544580, 0.486830266288 },
    { -0.121024309220, 0.877024482767, -0.464952872026 },
    { -0.081166057810, 0.176689973978, -0.980914228745 },
    { 0.546822110913, -0.607670666334, 0.575953071260 },
    { 0.909916663148, -0.095100398596, -0.403741972444 },
    { -0.537269655266, -0.753285718011, -0.379344097845 },
    { -0.426408329942, -0.608740398476, -0.669037415560 },
    { 0.730241192188, -0.234793819578, -0.641575921867 },
    { -0.953538825159, 0.038138476289, -0.298846391213 },
    { -0.766633487547, 0.228936503225, 0.599884299897 },
    { 0.659093068294, -0.712190737192, -0.241620945254 },
    { -0.299516479331, 0.641944202127, 0.705831084583 },
    { 0.803855305618, 0.562897189593, -0.192258684012 },
    { -0.821909799839, 0.569193602852, -0.021975518214 },
    { -0.564020640943, -0.277460582145, -0.777750822530 },
    { 0.207844621262, 0.465097425447, 0.860514380039 },
    { -0.897676903607, 0.353529690689, -0.263045498977 },
    { -0.612443227939, -0.789850623978, -0.032392658956 },
    { 0.726164029031, -0.617039858363, 0.303228653220 },
    { 0.051074714752, 0.707842219686, -0.704521657257 },
    { -0.360466412535, -0.045513182310, -0.931661159258 },
    { 0.549542960918, -0.027743117692, -0.835004702697 },
    { 0.521428636743, 0.791641413891, 0.318458864844 },
    { -0.096925358657, -0.683349613603, -0.723628896906 },
    { -0.702219870816, -0.466797001186, -0.537575866939 },
    { -0.729649131129, -0.466655670154, 0.499844606808 },
    { 0.459932071918, -0.395740489123, -0.794891158896 },
    { 0.367719706894, 0.699764253746, 0.612464044937 },
    { 0.348729477237, -0.918897390784, -0.184432472512 },
    { -0.231491444091, -0.852213848686, -0.469194274710 },
    { -0.275824493016, 0.947753738521, -0.160261349591 },
    { 0.769587854131, 0.125856288745, -0.626014959372 },
    { 0.427704706610, 0.158151974355, 0.889975638403 },
    { 0.417659822041, -0.780724460230, -0.464789834496 },
    { -0.267087138396, -0.397688585216, -0.877785993106 },
    { -0.586457647877, 0.479718667596, -0.652638818342 },
    { -0.585225529468, 0.045121505709, 0.809614185511 },
    { -0.443385335568, 0.776003381619, 0.448584658586 },
    { 0.990134325050, 0.056715934762, -0.128130094442 },
    { -0.793520567601, -0.122398799530, 0.596107073156 },
    { 0.448581312003, -0.394432167842, 0.801996303915 },
    { -0.903906924891, -0.282046838473, -0.321561583590 },
    { -0.239025430492, -0.854831187231, 0.460576253094 },
    { 0.121007863277, -0.450943293106, 0.884311734304 },
    { 0.297722312651, -0.138915488385, 0.944491350747 },
    { -0.311925519900, 0.661902721133, -0.681606380392 },
    { -0.425202984746, -0.622136127301, 0.657380453672 },
    { -0.780342582115, -0.584947990251, -0.221136390579 },
    { 0.421057462658, -0.827982279309, 0.370345728057 },
    { -0.801313983973, -0.115529215574, -0.586982878318 },
    { 0.863306136357, -0.049088664446, 0.502287584907 },
    { -0.048206007311, 0.989081742112, 0.139260505094 },
    { 0.980171365539, 0.004687039469, 0.198096253973 },
    { 0.963473604817, -0.261134755206, -0.059390676404 },
    { 0.034822714580, 0.714357972227, 0.698913489686 },
    { -0.029329066623, -0.155643263271, 0.987377830645 },
    { 0.376485129459, 0.906216352346, -0.192434066729 },
    { -0.471502133830, 0.360343115427, 0.804884200962 },
    { 0.576433226080, 0.722951294699, -0.380875519513 },
    { 0.790809977136, 0.585644866037, 0.177875436603 },
    { -0.139032233208, 0.881275358908, 0.451689915662 },
    { -0.398815150136, 0.307436793793, -0.863961280292 },
    { 0.573431845380, -0.816599492418, 0.065887689952 },
    { 0.616352434117, 0.787403790716, -0.010244380074 },
    { 0.014401206908, -0.983317523610, -0.181326371498 },
    { -0.051747228970, -0.146705613880, -0.987825737238 },
    { 0.905616892852, -0.326330570903, 0.270862330115 },
    { -0.914525551033, -0.260268523308, 0.309682599258 },
    { -0.587613403850, 0.802920152298, -0.100148473024 },
    { 0.273076069435, -0.181865873027, -0.944645046846 },
    { 0.184228818855, 0.890284043024, 0.416478168743 },
    { 0.246646838377, -0.961631764248, 0.120123632597 },
    { 0.258383120742, -0.651544742990, -0.713251435889 },
    { 0.894816923893, 0.280183945761, -0.347562410585 },
    { -0.796615125758, 0.244257640632, -0.552939912113 },
    { -0.119353852215, 0.441091353370, 0.889490346178 },
    { 0.828977500763, -0.559274659140, -0.002856374044 },
    { -0.670499759065, 0.705167929303, 0.230582446377 },
    { 121, DUMMYVAL, DUMMYVAL },
    { 0.393518421368, 0.873047076066, -0.287979261436 },
    { 0.163886373917, 0.634492066171, -0.755354932737 },
    { 0.661981246399, 0.681436783910, -0.312129362526 },
    { -0.000922612602, -0.985769584004, -0.168099601543 },
    { 0.522240521136, -0.097275843286, 0.847232110107 },
    { -0.540304012937, -0.763245601692, -0.354298920549 },
    { 0.245187542093, -0.968039196978, 0.052755874712 },
    { 0.888034384779, -0.347809188286, 0.300705337488 },
    { -0.541265657361, 0.138185918971, -0.829419158182 },
    { -0.347683993610, -0.444988158967, -0.825288664024 },
    { -0.637916784016, -0.769548151102, -0.029288561002 },
    { -0.661034722728, -0.108777426073, 0.742428829535 },
    { -0.916780981081, 0.399335728359, -0.006603694679 },
    { 0.163317315430, -0.522471030042, 0.836870048005 },
    { -0.497417145798, 0.685164717744, -0.532095379255 },
    { 0.169427518365, -0.914284646805, 0.367937359664 },
    { 0.118976238374, 0.853819883380, -0.506790155239 },
    { -0.189135426949, -0.861189168554, 0.471784915230 },
    { -0.562385513396, 0.202070625917, 0.801804213299 },
    { -0.000769527045, 0.001407538285, -0.999998713331 },
    { -0.891778910793, 0.301003459265, -0.337827310583 },
    { 0.945696918575, 0.261076408196, 0.193639994011 },
    { -0.347819864366, -0.935334602297, -0.064579591973 },
    { 0.758975408036, -0.634097354244, -0.147908334237 },
    { 0.036920676411, -0.855302335742, -0.516812130400 },
    { 0.805387504251, 0.317555221261, 0.500509389968 },
    { -0.119368928340, 0.501347563193, -0.856972391520 },
    { 0.590661030386, -0.484948997183, -0.644937219669 },
    { -0.096383205578, -0.981751949284, 0.163931045744 },
    { 0.421193710672, 0.418237146368, -0.804781676909 },
    { 0.387170109250, -0.705331860190, 0.593806596043 },
    { 0.348528527156, 0.936728520796, 0.032673293171 },
    { 0.294273735505, -0.485091889469, -0.823461491124 },
    { -0.462294099488, -0.680792770535, 0.568159633524 },
    { 0.974823896006, 0.178041549436, -0.134237023394 },
    { -0.976076710883, -0.159881550827, 0.147350412886 },
    { -0.994130254616, 0.086061165959, -0.065563042719 },
    { 0.920527395996, -0.020568627683, 0.390136187472 },
    { -0.016533990546, 0.634007723056, 0.773149942936 },
    { -0.108186440404, -0.335259287515, 0.935893639388 },
    { -0.817318864139, 0.473291180696, 0.328611218005 },
    { -0.945292811799, -0.280442922793, -0.166653133833 },
    { 0.010815000146, 0.988897069201, 0.148208037226 },
    { -0.299629973284, -0.711553383932, -0.635542021368 },
    { 0.301971143185, -0.905342278140, -0.298611433297 },
    { 0.657419835373, 0.132988005593, -0.741696265614 },
    { -0.606759068352, 0.493178115560, 0.623392957376 },
    { -0.236422592253, 0.969599892791, -0.063090457060 },
    { -0.774840373154, 0.066133511454, -0.628688122039 },
    { 0.546222951224, -0.198175686488, -0.813859253705 },
    { 0.994124894988, -0.077164749156, 0.075903192646 },
    { -0.243775671892, 0.211706479255, -0.946442702141 },
    { -0.213078115194, 0.899016579682, -0.382579281041 },
    { -0.701001925360, 0.397332227935, -0.592219048399 },
    { 0.785294610813, -0.172043107886, -0.594738214055 },
    { 0.244543563337, -0.197528677080, -0.949305465781 },
    { -0.517623810285, 0.822304159060, -0.236392599331 },
    { -0.779844290494, -0.549921047437, -0.299048029871 },
    { 0.581421955456, 0.555590551373, 0.594363229801 },
    { -0.436303445673, -0.403839944984, 0.804084947086 },
    { -0.371103373441, -0.109310902922, 0.922135246438 },
    { 0.570462836929, -0.718243584496, -0.398369558342 },
    { 0.848832502864, 0.413663004736, -0.329190371357 },
    { 0.487764333960, -0.824016183745, 0.288241710102 },
    { -0.428608041673, -0.868531919724, 0.248892448730 },
    { 0.750978289313, -0.636393567329, 0.176167069692 },
    { -0.267891136421, 0.194317227050, 0.943649910877 },
    { 0.380010251004, 0.099671825752, -0.919596507324 },
    { -0.929941978100, -0.025784195092, -0.366801162281 },
    { -0.272692751588, 0.909507763926, 0.313742395269 },
    { 0.856436020092, 0.515671952419, -0.024490426230 },
    { 0.531560019041, -0.845600047281, -0.049035764454 },
    { 0.290533284912, 0.133095957188, 0.947563125358 },
    { 0.634449208329, 0.772946489501, 0.005284545394 },
    { 0.951435565144, -0.136116352460, -0.276120814086 },
    { -0.590578197047, 0.714991197309, 0.374172394683 },
    { 0.082042966854, 0.977458538141, -0.194534721335 },
    { -0.857622444795, -0.391490798394, 0.333494673055 },
    { 0.670881834140, 0.439761722635, -0.597098980007 },
    { -0.181950467526, 0.736137094424, -0.651917330327 },
    { 0.663620932559, -0.570464019851, 0.483919476696 },
    { -0.026008552931, 0.851581168942, 0.523577184260 },
    { -0.051507714991, -0.349836138800, -0.935393837528 },
    { 0.127032451764, 0.308744042716, -0.942623929405 },
    { -0.436118790876, 0.463146241035, -0.771554249331 },
    { 0.293338813880, 0.725831757078, 0.622190164410 },
    { 0.536167264436, 0.776211029615, 0.331694290050 },
    { -0.868931855802, -0.095264363759, 0.485676982130 },
    { 0.813756633748, -0.428152970012, -0.393046021860 },
    { -0.007950251617, -0.634481400845, -0.772897241217 },
    { 0.303238355525, 0.473287948485, 0.827070140652 },
    { -0.591863345059, -0.531990120059, -0.605544625057 },
    { 0.774596102681, 0.564551011674, 0.285101793978 },
    { -0.322058883491, -0.123807659880, -0.938589228001 },
    { -0.246433877277, -0.895530870890, -0.370533134028 },
    { -0.747708874911, 0.662957551837, 0.037665937431 },
    { 0.925020422822, -0.378182782917, -0.036262929665 },
    { -0.017516297723, -0.014403054569, 0.999742832599 },
    { 0.749525267665, 0.040856143047, 0.660713741879 },
    { 0.234867145483, -0.222035443632, 0.946328529499 },
    { -0.602415610327, -0.208948703389, -0.770347890104 },
    { -0.794904055009, 0.215858857452, 0.567038355837 },
    { -0.335216615017, 0.728148338734, 0.597854344983 },
    { -0.676918810252, -0.667467894987, 0.310270097639 },
    { -0.503406873739, 0.859189452604, 0.091515047980 },
    { -0.684063569009, -0.416948700268, 0.598507155262 },
    { 0.482169965211, -0.425327895195, 0.765903588069 },
    { 0.746512220546, -0.278372833198, 0.604341021537 },
    { -0.949123827433, 0.168561575775, 0.265990517447 },
    { 0.071897786910, -0.765306322965, 0.639638132280 },
    { 0.318589346261, -0.725382311979, -0.610181390996 },
    { -0.805109668527, -0.290597750084, -0.517060314944 },
    { 0.558088861984, 0.272656826691, 0.783705988868 },
    { -0.190243010186, -0.618487497903, 0.762417741145 },
    { -0.749539560176, 0.592014284154, -0.296157956315 },
    { 0.437463020062, 0.693122420405, -0.572893896294 },
    { 0.245923608082, 0.904634610000, 0.348077292249 },
    { -0.851094508502, -0.523940466383, 0.033533942259 },
    { 0.868063296077, 0.126691242607, -0.480016086241 },
    { -0.318923304344, 0.485389932839, 0.814054383346 },
    { 0.020281636229, 0.343995163314, 0.938752354377 },
    { 122, DUMMYVAL, DUMMYVAL },
    { -0.529104472687, -0.844878517813, -0.078922412034 },
    { 0.919369476438, -0.177191809560, -0.351230449164 },
    { -0.832375519217, 0.534841918672, -0.145241581647 },
    { -0.022698370286, -0.296993089526, 0.954609809692 },
    { 0.962368036839, -0.270481547197, -0.026220112453 },
    { -0.164922514762, 0.011154878245, 0.986243445005 },
    { 0.895206142428, 0.412653061698, -0.168295612630 },
    { -0.793278416366, -0.419547178802, -0.441236352636 },
    { 0.175813975595, 0.019993095678, 0.984220362577 },
    { -0.745982152347, 0.418801707980, 0.517798954975 },
    { -0.124104727576, 0.991753957193, -0.031970376676 },
    { -0.881268910864, -0.172559429571, 0.439986761177 },
    { 0.605674669252, -0.737062414771, 0.299828603970 },
    { -0.296272830075, -0.899238245980, -0.321858644635 },
    { -0.270311674842, 0.803022233717, 0.531118527826 },
    { -0.605674650384, 0.737062432645, -0.299828598146 },
    { 0.427442407268, -0.688200572364, 0.586236266933 },
    { 0.242466095489, 0.793152652472, -0.558676169542 },
    { -0.388167621965, -0.893022733342, 0.227675855093 },
    { 0.718734210575, -0.495654211741, 0.487594131356 },
    { 0.832375531373, -0.534841898494, 0.145241586289 },
    { 0.745982156385, -0.418801681955, -0.517798970207 },
    { -0.885822829462, -0.091776560313, -0.454857096000 },
    { 0.836430209368, -0.503614820083, -0.216232786250 },
    { 0.164922483527, -0.011154882330, -0.986243450182 },
    { -0.175814007068, -0.019993110737, -0.984220356649 },
    { 0.754446953416, -0.166036930523, 0.635013017335 },
    { -0.667551185359, 0.741247586580, 0.070195657382 },
    { -0.919369474665, 0.177191828822, 0.351230444086 },
    { -0.269806268727, 0.891883883483, -0.362970681651 },
    { -0.039097095215, 0.954389080980, 0.295994762203 },
    { 0.769555287737, -0.063315297075, -0.635433578175 },
    { -0.210823176060, -0.547937008588, -0.809517524860 },
    { -0.718734211263, 0.495654226021, -0.487594115825 },
    { 0.039097129490, -0.954389081464, -0.295994756116 },
    { 0.296272860486, 0.899238232068, 0.321858655511 },
    { 0.592364938024, -0.699355438056, -0.400007189263 },
    { 0.022698330221, 0.296993082499, -0.954609812831 },
    { 0.270311695993, -0.803022227781, -0.531118526037 },
    { 0.985941173029, 0.085004837446, -0.143854721637 },
    { 0.986227597311, -0.010784782826, 0.165041857603 },
    { -0.962368031115, 0.270481567529, 0.026220112798 },
    { 0.885822822580, 0.091776556198, 0.454857110233 },
    { -0.388345317658, -0.266188531001, -0.882231024288 },
    { 0.287985360887, -0.318006832671, -0.903291805725 },
    { 0.210823174220, 0.547936995792, 0.809517534001 },
    { 0.342862196283, 0.291050735333, -0.893160110967 },
    { 0.881268905286, 0.172559434749, -0.439986770318 },
    { 0.126091060307, -0.596738988831, -0.792466796604 },
    { 0.269806293229, -0.891883879402, 0.362970673466 },
    { 0.429894250718, -0.899142610728, 0.082057898904 },
    { 0.700462873449, 0.692357784985, -0.173183314699 },
    { -0.287985374776, 0.318006832478, 0.903291801365 },
    { -0.464712841049, -0.530764624267, 0.708753052191 },
    { -0.342862229809, -0.291050737247, 0.893160097473 },
    { 0.486497695969, -0.001020639656, -0.873681263455 },
    { -0.199548397321, 0.559381113520, -0.804532912293 },
    { -0.985941173783, -0.085004825003, 0.143854723819 },
    { 0.529104490997, 0.844878506125, 0.078922414400 },
    { -0.769555296602, 0.063315312559, 0.635433565896 },
    { 0.034730117967, 0.311891899075, 0.949482628697 },
    { 0.124104766311, -0.991753952243, 0.031970379877 },
    { 0.197264820702, 0.980105558046, 0.021901725963 },
    { -0.690832792226, -0.185440017018, -0.698829058693 },
    { 0.608568096629, 0.698573290313, 0.376351205427 },
    { -0.535416776510, 0.404559659175, -0.741390826488 },
    { 0.747770408185, 0.468469956193, -0.470505384441 },
    { -0.700462871257, -0.692357790480, 0.173183301594 },
    { 0.388345299764, 0.266188509002, 0.882231038802 },
    { -0.938633634805, -0.308892659830, -0.153467339571 },
    { -0.536788068481, -0.712832113887, 0.451363431115 },
    { 0.667551215239, -0.741247559113, -0.070195663264 },
    { 0.448355589319, -0.576209708124, -0.683344450325 },
    { 0.363378255504, 0.724561063600, 0.585634278832 },
    { 0.297314226680, -0.271694132036, 0.915306806066 },
    { -0.050452951816, -0.806139885421, -0.589570169519 },
    { 0.050452971982, 0.806139881080, 0.589570173729 },
    { 0.140759163800, 0.578690001356, -0.803308620729 },
    { 0.535416751124, -0.404559670344, 0.741390838726 },
    { 0.793278416897, 0.419547166772, 0.441236363119 },
    { 0.062830627732, 0.947494976339, -0.313537209964 },
    { -0.608568082878, -0.698573310244, -0.376351190668 },
    { -0.363378239857, -0.724561084148, -0.585634263117 },
    { 0.690832779308, 0.185439992453, 0.698829077982 },
    { -0.577897171790, 0.290671942805, 0.762590768698 },
    { -0.754446970272, 0.166036925854, -0.635012998529 },
    { -0.126091055159, 0.596738986698, 0.792466799029 },
    { -0.062830608166, -0.947494979274, 0.313537205015 },
    { -0.895206143236, -0.412653062484, 0.168295606403 },
    { 0.938633632697, 0.308892663847, 0.153467344379 },
    { -0.836430194785, 0.503614848085, 0.216232777441 },
    { -0.429894211391, 0.899142628933, -0.082057905453 },
    { 0.900491493793, -0.266296399847, 0.343804155058 },
    { 0.464712823115, 0.530764618349, -0.708753068382 },
    { -0.486497721944, 0.001020650215, 0.873681248978 },
    { -0.747770414628, -0.468469957128, 0.470505373270 },
    { 0.791284759004, 0.598418738653, 0.125552552328 },
    { -0.242466101201, -0.793152660374, 0.558676155845 },
    { -0.034730134364, -0.311891907540, -0.949482625316 },
    { -0.079875556920, 0.790141678446, -0.607697312311 },
    { -0.297314267428, 0.271694110177, -0.915306799319 },
    { 0.536788063016, 0.712832107810, -0.451363447212 },
    { 0.655195528249, 0.248139526339, -0.713544389110 },
    { -0.986227598967, 0.010784792182, -0.165041847098 },
    { -0.900491494866, 0.266296409324, -0.343804144908 },
    { -0.369924609964, 0.898655604548, 0.235741144814 },
    { -0.427442409847, 0.688200571700, -0.586236265831 },
    { 0.577897162767, -0.290671920686, -0.762590783967 },
    { 0.369924645364, -0.898655589231, -0.235741147652 },
    { -0.555757285308, -0.481457213302, -0.677740947256 },
    { 0.555757284919, 0.481457184627, 0.677740967944 },
    { -0.655195545254, -0.248139520646, 0.713544375476 },
    { 0.388167634795, 0.893022725870, -0.227675862528 },
    { -0.791284757273, -0.598418740099, -0.125552556349 },
    { 0.079875552702, -0.790141688924, 0.607697299241 },
    { -0.197264787556, -0.980105564843, -0.021901720352 },
    { -0.592364916123, 0.699355461921, 0.400007179970 },
    { 0.520748080257, -0.046486708352, 0.852443794543 },
    { -0.140759187098, -0.578690010316, 0.803308610192 },
    { -0.448355580225, 0.576209722357, 0.683344444290 },
    { -0.520748112012, 0.046486684143, -0.852443776465 },
    { 0.199548368505, -0.559381129738, 0.804532908165 },
    { 123, DUMMYVAL, DUMMYVAL },
    { -0.559762157613, 0.399021879670, -0.726256061214 },
    { 0.328025750125, 0.771482105847, 0.545173795787 },
    { 0.858347129239, 0.354882259248, 0.370538510545 },
    { -0.888346649260, 0.068193762735, 0.454081315925 },
    { 0.991366094266, -0.076816760629, -0.106265951398 },
    { 0.195152625036, 0.946623353115, 0.256553464755 },
    { -0.629273781482, -0.578536719338, -0.518950645357 },
    { 0.212200691286, -0.359206646639, 0.908813210527 },
    { -0.026844583342, -0.570268482842, 0.821019625723 },
    { -0.094253127803, -0.239320755171, 0.966354967931 },
    { -0.803147337280, 0.311622401605, -0.507785223729 },
    { -0.751320511273, 0.652630684883, 0.097932009527 },
    { 0.419249403499, 0.495148062902, 0.760958825081 },
    { -0.448258998189, 0.138330594514, -0.883135616519 },
    { 0.532527501951, -0.670360499383, -0.516750675407 },
    { -0.216023935320, -0.942600696938, -0.254632255421 },
    { -0.861086630980, 0.384148795683, 0.333105864138 },
    { 0.156206948716, -0.005013060859, 0.987711627143 },
    { -0.362649362686, 0.810638554695, 0.459728804172 },
    { 0.522838044377, 0.774224373334, -0.356674920745 },
    { -0.234023117625, 0.380512945271, -0.894674845348 },
    { 0.887406050698, 0.039505524414, 0.459292733150 },
    { -0.984085357609, -0.130942201351, -0.120125554505 },
    { 0.143610089422, -0.421457552747, -0.895404753979 },
    { -0.457253712038, 0.243447580432, 0.855366774202 },
    { 0.710160568995, -0.355770868146, -0.607535229944 },
    { 0.580716040839, 0.555223286790, -0.595395651411 },
    { -0.299493089803, -0.713547163439, 0.633367456306 },
    { 0.746856407004, 0.624184792265, 0.229344396970 },
    { 0.734674036327, -0.678378730562, -0.007507214454 },
    { -0.685684870377, -0.724227651849, 0.073010730951 },
    { -0.704927604028, 0.055343579648, -0.707116794646 },
    { 0.799362749246, -0.294792487325, 0.523561442941 },
    { -0.649159511943, 0.633803016969, 0.420577773706 },
    { 0.380999070910, 0.923119162415, -0.051872150022 },
    { 0.121717908062, 0.625382212137, 0.770767046260 },
    { -0.185714107146, 0.689310794055, 0.700257737984 },
    { -0.468123778312, -0.184372380275, -0.864214645543 },
    { -0.812663615184, -0.255135818495, 0.523911789022 },
    { 0.891681294451, -0.294348057281, -0.343894882633 },
    { -0.888863045150, -0.036643572793, -0.456705304918 },
    { -0.409711535798, -0.910417157494, 0.057245583006 },
    { 0.614766746256, 0.591843423775, 0.521328312518 },
    { 0.451379237489, 0.192206930918, 0.871385838576 },
    { -0.808699817501, 0.532088192593, -0.250772327973 },
    { -0.687428099357, 0.029382774643, 0.725657812450 },
    { -0.173796607611, 0.427166368963, 0.887312590021 },
    { -0.326493336219, -0.444122280256, 0.834360534532 },
    { -0.705663414198, -0.281178964454, -0.650367231502 },
    { -0.422788412158, -0.493132260434, -0.760309497681 },
    { -0.610848210806, 0.618957140560, -0.493717045993 },
    { -0.591173487441, -0.278773866946, 0.756834882161 },
    { -0.168956297086, -0.320701111328, -0.931989574442 },
    { 0.663862906181, 0.745533405480, -0.058872600678 },
    { 0.200291077296, -0.690610989974, -0.694938806574 },
    { 0.108625225933, -0.948506931260, 0.297548587027 },
    { 0.813165678242, -0.512684871763, 0.275528223588 },
    { -0.949720371852, -0.209905608461, 0.232316273270 },
    { 0.346092925444, -0.815739329753, 0.463453377216 },
    { -0.370392146217, 0.826635753106, -0.423654328087 },
    { -0.349275574481, -0.761752420868, -0.545655406252 },
    { 0.226591188877, 0.908691560677, -0.350622418960 },
    { 0.979682144367, 0.146258601030, 0.137227248140 },
    { 0.802693763371, 0.301080520873, -0.514813793712 },
    { 0.004211353770, 0.862563804616, 0.505930773393 },
    { -0.171865908641, 0.015323249446, -0.985001171306 },
    { 0.600957269809, 0.255710434305, -0.757273090537 },
    { 0.916273589496, -0.399540521480, -0.028461919957 },
    { 0.125465909884, -0.107334646224, -0.986274596234 },
    { -0.390667168805, -0.083579991608, 0.916729812006 },
    { 0.552259541131, -0.386718195891, 0.738551579916 },
    { 0.332453407743, 0.454296413565, -0.826492286898 },
    { -0.756254201882, -0.615009343389, -0.223255659906 },
    { -0.591903910796, -0.552020645092, 0.587301428379 },
    { 0.147087593483, 0.328917675953, 0.932833534072 },
    { 0.697424299097, 0.289223164622, 0.655705199061 },
    { 0.893741846392, 0.448528196843, 0.006925940034 },
    { 0.442593503040, -0.187103777359, -0.876985272148 },
    { 0.512871300249, -0.838329233013, -0.184843518839 },
    { 0.289836364185, -0.859219840638, -0.421587650969 },
    { -0.223048110771, -0.904430144368, 0.363669704869 },
    { -0.920399399294, 0.390636552564, 0.016371608989 },
    { 0.885379051924, -0.007097069405, -0.464815625835 },
    { -0.711302445674, 0.335807326953, 0.617480582644 },
    { 0.438860877956, -0.129154701609, 0.889224489571 },
    { 0.363788284537, 0.122651167195, -0.923371417805 },
    { 0.697196977935, -0.039281856671, 0.715802563347 },
    { 0.025214237981, -0.803502990347, 0.594766497633 },
    { -0.092812042612, -0.994169209486, 0.054895424728 },
    { -0.900595903419, -0.434639133639, 0.003980232871 },
    { 0.607151675453, -0.607952052589, 0.511625981306 },
    { 0.750089096343, -0.581914727706, -0.314231757189 },
    { -0.038819469854, 0.800793299394, -0.597681470690 },
    { 0.497040997659, 0.828647560921, 0.257475176330 },
    { 0.446843411730, -0.475189116192, -0.757975111232 },
    { 0.563267735536, -0.794962910360, 0.225307410568 },
    { 0.305469665972, -0.619671624813, 0.722976735845 },
    { -0.315925423903, 0.639796196434, -0.700608273974 },
    { -0.513347893251, -0.819923600056, -0.253375670826 },
    { -0.791177327942, -0.522644060268, 0.317618673913 },
    { 0.782304181358, 0.546638595909, -0.298640943763 },
    { 0.067122491294, 0.255893642669, -0.964371823937 },
    { -0.524513994813, -0.772588022970, 0.357760836326 },
    { -0.312367028131, 0.946761249803, -0.077910048191 },
    { 0.288391576076, 0.724386116338, -0.626174938260 },
    { -0.986707700652, 0.096690675598, 0.130609443484 },
    { 0.326172227046, -0.943303189303, 0.061569240333 },
    { 0.025168347147, 0.571905151099, -0.819933565875 },
    { -0.868314946150, -0.344293179810, -0.357059323682 },
    { 0.120482565145, -0.974969923272, -0.186862516872 },
    { -0.164429847036, 0.959678306613, 0.227992046397 },
    { 0.691335388263, -0.050134295141, -0.720792573065 },
    { 0.051604436340, 0.998191414167, -0.030836388149 },
    { -0.034590210773, -0.857325874120, -0.513610614068 },
    { -0.143719729704, 0.117760825944, 0.982586905656 },
    { -0.472415503813, 0.542156693046, 0.694902663646 },
    { -0.954618486576, 0.187815328522, -0.231147025636 },
    { -0.119091047182, -0.626219725488, -0.770497357484 },
    { 0.954747512632, -0.189668634923, 0.229091676082 },
    { -0.090945272735, 0.944756468087, -0.314903434999 },
    { -0.595522860009, 0.784424585947, -0.173293370240 },
    { 0.948641815484, 0.227313554802, -0.220016485105 },
    { -0.501695009509, 0.848495512018, 0.168396803767 },
    { 124, DUMMYVAL, DUMMYVAL },
    { 0.610488527553, -0.636399942195, 0.471485812406 },
    { 0.550888408408, 0.040944558200, 0.833573934714 },
    { 0.014286877970, 0.847556364778, -0.530513047570 },
    { -0.184249190551, 0.391619053891, 0.901491404513 },
    { 0.311698624520, -0.127235091968, -0.941623703421 },
    { 0.104589405640, 0.139696362332, -0.984655260779 },
    { 0.685838522219, -0.453471797604, -0.569200184662 },
    { -0.946659097056, -0.234831655429, 0.220659573936 },
    { -0.806437275268, 0.186677791858, 0.561079604946 },
    { 0.993115050806, 0.037773805179, 0.110885686653 },
    { -0.850085517861, -0.132215627088, 0.509778030398 },
    { 0.899918043248, 0.123622433342, -0.418168637528 },
    { 0.334896803593, -0.810150454856, 0.481144854944 },
    { 0.190955609692, -0.973349747379, -0.126989071987 },
    { -0.573812190947, -0.663879520447, -0.479586855379 },
    { -0.751865076161, -0.368489448879, -0.546730677129 },
    { 0.025155511669, -0.890632874996, 0.454026741733 },
    { 0.087521686524, -0.712997233486, -0.695683045236 },
    { 0.921739759258, -0.181823221611, 0.342543620998 },
    { -0.400994945086, -0.510243673090, 0.760824847181 },
    { -0.206947646339, -0.739907068304, 0.640086089483 },
    { 0.285568243016, -0.940267147584, 0.185333401615 },
    { 0.485737342236, 0.856904608588, 0.172550648037 },
    { -0.463876839200, -0.495290961313, -0.734510137231 },
    { -0.959041243371, 0.101614324156, 0.264413355639 },
    { -0.301523900818, 0.946670845589, -0.113567809467 },
    { -0.919199030225, -0.151449369620, -0.363505476266 },
    { -0.546373166426, 0.257574263907, 0.796951605546 },
    { -0.998436645521, 0.007534557411, -0.055384973817 },
    { -0.635098520714, -0.043345047324, 0.771214027271 },
    { -0.405432845584, 0.761387856264, 0.505878186973 },
    { 0.041099899179, 0.632426737428, -0.773529068667 },
    { 0.415182240973, -0.562152652101, 0.715267853686 },
    { 0.946389445086, -0.321295754018, 0.033407434499 },
    { -0.114663461052, 0.389136214155, -0.914016026956 },
    { 0.861612499584, -0.423618328378, -0.279591509926 },
    { -0.792830340806, 0.015792946646, -0.609237747956 },
    { -0.106378390649, -0.468364542813, 0.877107914135 },
    { -0.427431225731, 0.404069989785, -0.808721206984 },
    { -0.080653732008, 0.886068300340, 0.456484329026 },
    { 0.316938443721, -0.856071276826, -0.408279306217 },
    { 0.499283336462, -0.859477969235, -0.109607346157 },
    { 0.715633167163, 0.178244928155, -0.675350217030 },
    { 0.820844977818, -0.509573759421, 0.257969196032 },
    { 0.463730452454, -0.385403997654, -0.797757999683 },
    { -0.048257146357, -0.986521705368, 0.156352718757 },
    { 0.326683977810, 0.699257020070, -0.635859417266 },
    { -0.803971348507, 0.496922003115, -0.326647506649 },
    { 0.546451686728, 0.459403382819, -0.700242162345 },
    { -0.801843155777, -0.530910810665, -0.274192021498 },
    { -0.032705808806, 0.992919590344, 0.114197273093 },
    { -0.311697394139, -0.881147002830, 0.355562503494 },
    { 0.458869813964, 0.527499337004, 0.714970589110 },
    { -0.821489041527, -0.565412026367, 0.073925605112 },
    { 0.571645592393, 0.808833230258, -0.137877200173 },
    { 0.163743630599, -0.449585380087, -0.878100796863 },
    { -0.606120893380, -0.197082075045, -0.770568697979 },
    { -0.538596465641, 0.110768928899, -0.835250915348 },
    { 0.508733739007, 0.724872610156, 0.464488624018 },
    { -0.326953464565, -0.218067647015, -0.919536803687 },
    { -0.408498570804, 0.541541641515, 0.734752725858 },
    { -0.250857529556, -0.738046198628, -0.626385112016 },
    { -0.787650549163, -0.479084913030, 0.387407096618 },
    { 0.203946947100, -0.381703607061, 0.901503188639 },
    { 0.216244357902, 0.917800755331, 0.332986713233 },
    { 0.347458165223, 0.276034270294, 0.896146140450 },
    { 0.782491101621, -0.045020734249, 0.621032051807 },
    { -0.610131990151, -0.763055312020, 0.213273405262 },
    { -0.716186507733, 0.330247380504, -0.614828068497 },
    { -0.265598063405, 0.668003674719, -0.695146573952 },
    { 0.584809201718, -0.788092998377, 0.192113569263 },
    { 0.129395051666, 0.508579505565, 0.851236634035 },
    { 0.910839600334, 0.380746369034, 0.159384519107 },
    { -0.560037186438, 0.610947101058, -0.559555171110 },
    { -0.307964519085, 0.089821383277, 0.947148337955 },
    { -0.385179746718, -0.219441270716, 0.896371625736 },
    { -0.622495260146, -0.770481207209, -0.137325745704 },
    { 0.975744772317, -0.100361900435, -0.194549809141 },
    { -0.918438722964, 0.191155191169, -0.346309117769 },
    { -0.153071228192, -0.500541556626, -0.852072384948 },
    { -0.307424152513, 0.850858769658, -0.426063075787 },
    { 0.108749740882, -0.681841874828, 0.723370687538 },
    { -0.125841852670, -0.979087818448, -0.159846400910 },
    { -0.365981922353, -0.866965403540, -0.338272407351 },
    { 0.632754048085, -0.118766163788, -0.765190769005 },
    { 0.311697577432, 0.881146939585, -0.355562499545 },
    { 0.450518988207, 0.159514861299, -0.878400620611 },
    { 0.261840127027, 0.964458614649, -0.035487018869 },
    { 0.590246211617, 0.681706227175, -0.432303168508 },
    { 0.256116240167, 0.417529142506, -0.871822164596 },
    { 0.627913918626, -0.691350794321, -0.357432776881 },
    { 0.769897652105, -0.636310168591, -0.048651563501 },
    { 0.679925328378, 0.288758285408, 0.674032788845 },
    { -0.013570179773, -0.181149381665, -0.983361963746 },
    { -0.658250483487, 0.686987704628, 0.307821692996 },
    { 0.839478877838, -0.174667391811, -0.514554677272 },
    { 0.894709847944, 0.174425591917, 0.411181226319 },
    { -0.008890368540, -0.894567604139, -0.446844226741 },
    { -0.328972089957, 0.914818489117, 0.234274403207 },
    { -0.381575952548, -0.923808736547, 0.031260369740 },
    { 0.524543533512, -0.274132157822, 0.806043200765 },
    { 0.735009150933, 0.658988074796, 0.159675500066 },
    { 0.809506797642, 0.568493166788, -0.146677414371 },
    { -0.064455563682, -0.153321618745, 0.986071985981 },
    { 0.037245539778, 0.173111719685, 0.984197694711 },
    { -0.592333084940, 0.757313895032, -0.274985783044 },
    { 0.745591350274, 0.495346285429, 0.445786491393 },
    { 0.264484372931, -0.068376901440, 0.961962897322 },
    { -0.798153062364, 0.602401142664, -0.008034448076 },
    { -0.238427369322, 0.095676657766, -0.966435909265 },
    { 0.210723549892, 0.751671512462, 0.624968417502 },
    { 0.737970440761, -0.360870872232, 0.570238408157 },
    { -0.945947849263, -0.311920120448, -0.088817255841 },
    { -0.005269310052, 0.971981822481, -0.234996959847 },
    { 0.788116380280, 0.428891570210, -0.441502652469 },
    { 0.405044025448, -0.657101425925, -0.635733476777 },
    { -0.660366375728, -0.353642156061, 0.662460168814 },
    { -0.946389434400, 0.321295783563, -0.033407453080 },
    { -0.537675015295, -0.669867997595, 0.512037541324 },
    { -0.864913641432, 0.414286411259, 0.283356952113 },
    { -0.564458613441, 0.824697650356, 0.035500129728 },
    { -0.675499631744, 0.482699666523, 0.557405848060 },
    { -0.112306603073, 0.690903091165, 0.714170949791 },
    { 0.954183213861, 0.265610704158, -0.137787329690 },
    { 125, DUMMYVAL, DUMMYVAL },
    { 0.457480144894, 0.185531734172, 0.869649292901 },
    { 0.321017823699, -0.939078288772, -0.122798715076 },
    { 0.175325171930, 0.898012878091, -0.403526894853 },
    { -0.998948001322, -0.036948266531, -0.027160932501 },
    { -0.353101141341, 0.854993801367, 0.379875221103 },
    { 0.734994883687, 0.074684592572, 0.673947128925 },
    { -0.323566179358, -0.061517505092, 0.944203645483 },
    { -0.597434317122, 0.135808564506, 0.790334277715 },
    { 0.097103839781, 0.708154847569, -0.699347950711 },
    { 0.706961521065, -0.697818226082, 0.115130930168 },
    { -0.898135058623, 0.351627495686, -0.264029393722 },
    { 0.876722518879, 0.470655320789, -0.099202791808 },
    { -0.776672269751, -0.571330181011, -0.265258382839 },
    { -0.319134040230, 0.254313845204, 0.912950125967 },
    { 0.603796604829, 0.636841337520, 0.479440059677 },
    { -0.381861022306, -0.794984936010, 0.471360913908 },
    { -0.247586763426, 0.632860743513, -0.733613027349 },
    { -0.951795173424, -0.131585194844, 0.277076315020 },
    { -0.029556820787, 0.122203531594, 0.992064862401 },
    { -0.588057946289, 0.644333661309, 0.488898746889 },
    { 0.205191480378, 0.949401140897, 0.237768648152 },
    { 0.741190503294, -0.538332604121, 0.401041949386 },
    { 0.501455941210, -0.738094910868, 0.451395438142 },
    { 0.788783533495, 0.579705173290, 0.204358629245 },
    { 0.040933149222, -0.133432754694, -0.990212188003 },
    { -0.743739608149, 0.345644548963, 0.572172387522 },
    { 0.703726681631, 0.605398288201, -0.371835541879 },
    { -0.148940767513, -0.940191204717, 0.306361137134 },
    { -0.425972455832, -0.499451032362, -0.754384605586 },
    { 0.543842536429, -0.483037495425, 0.686228878425 },
    { 0.509336709856, 0.172617342603, -0.843077320906 },
    { -0.480886348032, -0.861372040456, 0.163665904196 },
    { 0.915062348713, 0.040540094685, 0.401269733086 },
    { -0.658141807031, -0.650393616527, 0.379259153374 },
    { 0.035718999953, -0.835430627761, -0.548433969810 },
    { 0.509863721245, -0.422454224313, -0.749380687047 },
    { -0.102174815774, 0.161546082602, -0.981561597770 },
    { -0.810130265240, 0.584313397356, -0.047610996750 },
    { 0.955631907659, 0.259972410852, 0.138499107069 },
    { 0.779227415058, -0.361103569373, -0.512258575144 },
    { 0.320949890727, 0.462889988284, -0.826271157907 },
    { -0.960493525707, 0.275813183666, 0.037138588971 },
    { -0.812593093629, -0.001919194898, 0.582828260191 },
    { -0.442013042383, 0.754539768073, -0.485071343990 },
    { 0.520848022501, 0.823845799005, 0.223596594155 },
    { -0.265036101439, 0.704089277643, 0.658797506099 },
    { -0.041677980270, -0.595956236148, -0.801934604913 },
    { 0.906430378738, -0.272494982633, 0.322692505245 },
    { -0.781605762996, 0.265037686085, -0.564665791602 },
    { -0.113202678964, 0.482512949197, 0.868542691716 },
    { -0.789125419243, -0.071187688291, -0.610092932053 },
    { -0.783839951940, -0.321077978810, 0.531510922998 },
    { -0.924689651976, 0.180330503021, 0.335305766740 },
    { -0.551800117839, -0.511596716226, 0.658623891079 },
    { -0.555911505338, 0.484840562377, -0.675197769032 },
    { 0.752749813135, 0.156637862210, -0.639399952258 },
    { -0.478269016258, 0.471854685153, 0.740683403478 },
    { 0.993739767864, -0.078929231414, 0.079066112810 },
    { 0.977582806287, 0.122266216704, -0.171414203337 },
    { 0.294620889890, -0.371625807004, 0.880393543144 },
    { 0.757430972927, -0.246326386854, 0.604666546446 },
    { 0.667627024160, 0.742414378729, -0.055633145404 },
    { 0.403639873249, 0.696360837409, -0.593427701448 },
    { 0.343836961618, 0.937793664437, -0.048157935663 },
    { -0.018216112518, -0.227423766048, 0.973625494675 },
    { 0.447218097441, -0.879804519807, 0.161058934087 },
    { 0.284838776734, -0.657873530020, -0.697186696494 },
    { 0.588079626870, -0.634245213818, -0.501891782369 },
    { 0.214533216711, 0.169140291475, -0.961960009942 },
    { 0.382890537349, -0.132534265629, -0.914237116312 },
    { 0.801524647033, -0.548033899089, -0.239200931536 },
    { -0.199324007681, -0.338052179509, -0.919777507820 },
    { 0.612214245143, 0.451963904385, -0.648785285882 },
    { 0.183897749152, 0.353278904138, 0.917265301725 },
    { 0.370160560978, 0.554541085605, 0.745295473938 },
    { -0.591353063289, -0.195984017099, 0.782235143407 },
    { -0.587345595642, 0.137268344939, -0.797610526985 },
    { 0.341160976994, -0.838057170849, -0.425757402948 },
    { 0.194573714443, -0.401131725123, -0.895116980482 },
    { -0.550548485314, -0.689400775964, -0.470768452021 },
    { -0.712404087220, 0.577527728935, -0.398675480589 },
    { -0.020154473971, -0.807127436378, 0.590033133498 },
    { 0.596131588868, -0.781693546516, -0.183254817370 },
    { -0.234351495900, -0.971924301405, -0.021036366298 },
    { -0.005096072414, 0.458929135516, -0.888458259358 },
    { -0.933265384090, -0.355988475487, -0.047832292219 },
    { -0.307765502597, -0.371581620135, 0.875903816060 },
    { -0.101819660777, 0.981774293208, 0.160474277923 },
    { -0.334643564766, -0.040458849455, -0.941475844651 },
    { 0.665947268335, -0.140640784988, -0.732621597686 },
    { 0.861268761717, 0.321777491657, -0.393287891948 },
    { -0.265693944618, 0.934515735588, -0.236827084034 },
    { -0.583936988612, 0.791724101329, -0.179417225220 },
    { 0.892418950932, -0.053855826165, -0.447982104560 },
    { -0.559668575766, -0.211020828552, -0.801399585236 },
    { 0.314972683558, 0.800156206433, 0.510433398122 },
    { 0.077979171028, 0.686480401681, 0.722954982688 },
    { -0.539029883804, -0.826228683113, -0.163685514228 },
    { -0.344791211833, 0.340560681593, -0.874721351286 },
    { 0.894103503385, -0.444169465456, 0.057379536342 },
    { -0.278204186561, -0.896774834173, -0.344089127078 },
    { 0.828914312843, 0.353187203875, 0.433773974535 },
    { -0.942513852711, 0.049052630901, -0.330547238453 },
    { 0.090339091365, -0.991128948248, 0.097479518443 },
    { 0.272578156539, -0.677098724532, 0.683548437066 },
    { 0.535488920923, -0.151844665169, 0.830779641799 },
    { -0.634430444310, 0.751887919761, 0.179339252397 },
    { -0.863744118028, -0.440432902539, 0.244877432471 },
    { 0.019230501850, -0.535675440214, 0.844204957668 },
    { 0.474775520430, 0.824370847136, -0.308222178944 },
    { -0.389548592246, 0.919402291142, 0.054326064855 },
    { 0.209447493134, -0.895694088291, 0.392254825107 },
    { -0.898116196269, -0.265438187579, -0.350613557317 },
    { -0.258943286384, -0.644057902505, 0.719817888537 },
    { 0.032444362758, 0.990951883474, -0.130237198847 },
    { -0.706521035127, -0.413671850913, -0.574198246850 },
    { 0.249988467412, -0.037680846372, 0.967515333200 },
    { -0.122962115170, 0.853771691990, -0.505919179503 },
    { 0.024945989651, -0.968391028234, -0.248186450146 },
    { -0.823256532351, 0.494365776633, 0.279018208788 },
    { -0.741842057328, -0.669159192164, 0.043546957680 },
    { 0.947514326187, -0.246304458146, -0.203839926332 },
    { -0.028752414679, 0.878487702627, 0.476898998723 },
    { 0.626332523279, 0.379957509843, 0.680690723455 },
    { -0.264339581507, -0.737268708115, -0.621739043075 },
    { 126, DUMMYVAL, DUMMYVAL },
    { -0.082147465781, 0.751996153141, -0.654028729894 },
    { 0.530444852427, 0.291433094457, -0.796049627843 },
    { -0.344992539732, 0.816023719173, -0.463773045009 },
    { 0.905204899074, 0.250447380516, -0.343336861238 },
    { -0.498079196023, -0.282015792961, -0.819990370071 },
    { 0.328212091771, 0.939959284239, 0.093559429176 },
    { -0.777318090900, -0.240397241319, 0.581365420305 },
    { -0.243214948339, -0.268469205860, 0.932078738310 },
    { -0.539018970503, 0.826735565549, -0.161142341096 },
    { -0.197976639243, -0.362004946343, -0.910910351866 },
    { 0.613985335602, -0.331069155218, 0.716529986902 },
    { -0.301008349574, 0.946529581671, 0.116084988297 },
    { -0.125480311371, -0.796685262476, 0.591225239661 },
    { 0.042269540549, 0.998158928712, -0.043497574343 },
    { 0.336373725372, -0.907491985655, -0.251616797632 },
    { -0.525898570164, -0.731040317831, -0.434753663130 },
    { -0.015988463823, 0.961912310684, 0.272890226242 },
    { 0.960814619100, -0.262907193898, -0.087835500344 },
    { -0.599784169955, -0.765885364187, 0.231686336231 },
    { 0.774100258833, 0.586697689882, -0.237812131655 },
    { 0.836939852621, -0.418818260056, -0.352310868606 },
    { -0.841148415555, 0.114406876514, -0.528564480093 },
    { -0.632883574254, 0.644062835665, -0.429699249655 },
    { -0.744244746891, -0.174612086024, -0.644678506032 },
    { -0.470050023985, 0.117555665367, 0.874776337410 },
    { 0.125983500687, -0.015754464561, 0.991907230743 },
    { 0.817819311222, -0.574156197121, -0.038938868751 },
    { -0.778390966003, 0.617678601720, -0.112163492379 },
    { -0.668693375482, -0.476885077916, -0.570464540570 },
    { -0.631975411468, -0.764591997828, -0.126515438414 },
    { -0.969840666033, 0.051468477060, -0.238243737332 },
    { -0.045102865575, -0.623559246180, -0.780473957298 },
    { 0.905731142872, -0.369326837631, 0.207963419468 },
    { -0.936299905150, 0.263796780639, 0.231848541382 },
    { 0.467163808102, -0.327001417836, -0.821479183627 },
    { 0.785948568735, 0.606315560677, 0.121104451547 },
    { 0.687997978061, -0.684536444067, 0.240974353258 },
    { 0.172944276175, 0.555645285177, -0.813233419381 },
    { 0.779242125516, 0.124652342501, -0.614201516874 },
    { 0.033175945151, -0.599792775875, 0.799467311822 },
    { 0.216959200116, -0.780035847839, 0.586918036502 },
    { 0.841811600907, -0.154310921823, 0.517244012034 },
    { 0.925683907438, 0.374891098097, -0.050655385477 },
    { 0.656274310022, -0.697304936729, -0.288218415822 },
    { -0.357772730420, 0.838505538613, 0.410983132359 },
    { -0.610945254439, 0.634528456875, 0.473412646106 },
    { 0.717841265722, 0.448134904740, -0.532802988337 },
    { 0.513654469988, -0.655037663224, 0.554152276202 },
    { 0.288791428721, -0.045965012349, -0.956287994454 },
    { -0.591337735055, 0.790330980229, 0.160301668081 },
    { -0.996884821052, -0.016864451462, 0.077047023522 },
    { -0.799400982337, -0.533946725339, -0.275425060477 },
    { 0.341592986166, -0.504358094035, 0.793055574839 },
    { -0.789675505872, 0.350355826271, 0.503650067432 },
    { -0.263948625884, -0.909625349155, 0.320800322738 },
    { 0.312195139881, 0.918385224455, -0.243110621195 },
    { -0.134090598829, 0.503469632153, -0.853544398848 },
    { 0.650874849771, 0.000856997626, 0.759184559571 },
    { -0.382928314568, -0.581784314634, -0.717560392684 },
    { 0.996221564524, 0.056768367959, -0.065726302014 },
    { 0.064681946038, 0.298776707358, 0.952128523361 },
    { 0.616498748827, 0.341685640994, 0.709351968654 },
    { 0.754860638408, -0.464075886743, 0.463485693335 },
    { 0.323763011343, 0.461203294837, 0.826116839992 },
    { 0.931088027793, 0.271848439382, 0.243256059547 },
    { 0.406889157178, -0.859772830177, 0.308596653028 },
    { -0.338162439167, 0.643899022312, 0.686323694624 },
    { 0.426548198857, -0.750350403952, -0.505005846839 },
    { 0.288993234978, -0.597145488278, -0.748264776644 },
    { 0.621013712828, -0.511341723185, -0.594029974505 },
    { -0.559260749697, 0.402191242555, 0.724892832258 },
    { 0.070455522994, -0.323322698679, 0.943662255152 },
    { 0.565326788520, 0.774562637686, 0.283651797955 },
    { 0.270727167688, 0.875273806092, 0.400752498490 },
    { 0.242179489452, 0.790492001537, -0.562557988473 },
    { 0.144762225299, -0.363371967444, -0.920328588822 },
    { -0.532191270197, -0.186357528832, 0.825859142574 },
    { -0.917967252353, -0.295683142427, 0.264400459325 },
    { -0.805253217772, 0.555105938924, 0.208385824468 },
    { -0.951470124572, -0.299282726355, -0.071655088810 },
    { 0.398333731834, 0.156047502934, 0.903869135944 },
    { -0.449698310823, -0.723771466139, 0.523379684403 },
    { 0.832308568164, 0.167747891657, 0.528321012458 },
    { -0.740635609365, -0.533892555079, 0.407943174684 },
    { 0.243214974594, 0.268469284191, -0.932078708897 },
    { -0.392300372449, 0.302467685896, -0.868685050387 },
    { -0.941096485268, 0.330289279105, -0.072432020023 },
    { -0.410817662263, 0.594999004774, -0.690800284229 },
    { 0.586984475802, 0.807028817857, -0.064449300356 },
    { 0.551909492074, -0.833853269131, -0.009199897743 },
    { 0.458560132264, 0.573696456358, -0.678671482427 },
    { 0.112803652115, -0.826983587686, -0.550793501929 },
    { 0.570964860592, -0.021232275747, -0.820699895477 },
    { 0.759972618941, 0.490424223250, 0.426527489980 },
    { -0.082502643561, -0.996023799416, 0.033614056628 },
    { -0.068709079248, 0.218247211657, -0.973471734070 },
    { 0.390376254163, -0.186722899939, 0.901521457772 },
    { -0.072570496117, 0.824848538232, 0.560676744721 },
    { -0.909449577908, 0.004925229648, 0.415785049461 },
    { 0.924285765898, -0.084449167132, -0.372242073292 },
    { 0.071070247779, -0.938724870072, 0.337260490110 },
    { 0.969840621743, -0.051468593728, 0.238243892421 },
    { -0.021685896816, -0.091459130968, -0.995572674013 },
    { 0.238611362857, -0.970040089497, 0.045681968923 },
    { -0.332824949961, -0.023140207532, -0.942704663974 },
    { -0.261461317347, 0.369565375163, 0.891661041546 },
    { 0.006471005597, 0.923289445963, -0.384050419945 },
    { 0.015988461216, -0.961912257871, -0.272890412558 },
    { 0.753119413401, -0.217154154881, -0.621011450923 },
    { -0.306092529999, -0.914311297469, -0.265221067036 },
    { -0.609740701595, 0.075696498922, -0.788978020524 },
    { -0.657193457058, 0.379275132925, -0.651342562363 },
    { -0.182850913589, 0.040343000312, 0.982312570278 },
    { -0.031515570350, 0.583481462190, 0.811514726980 },
    { 0.540278329829, 0.739849742666, -0.400901090787 },
    { -0.209050670616, -0.808424608583, -0.550224926146 },
    { 0.514720105357, 0.635161347436, 0.575876094194 },
    { -0.841653148524, 0.394441842512, -0.368830056333 },
    { -0.726609212992, 0.079363503433, 0.682451819485 },
    { -0.895722779844, -0.232811097419, -0.378787136248 },
    { 0.217404262462, 0.716176525855, 0.663194217765 },
    { -0.562857887198, -0.466482990101, 0.682337613477 },
    { -0.820555098485, -0.566930390840, 0.072658532137 },
    { -0.245108900140, 0.950629582893, -0.190328724058 },
    { -0.278884751845, -0.550023157789, 0.787208880212 },
    { -0.398843450774, -0.916455630020, 0.032140005914 },
    { 127, DUMMYVAL, DUMMYVAL },
    { 0.103652862809, -0.936615841744, 0.334674243147 },
    { 0.140084278105, -0.086368570039, 0.986365482535 },
    { -0.050756794838, 0.410763308977, -0.910328101168 },
    { -0.793879346368, -0.348120667203, 0.498565526762 },
    { 0.132573254188, 0.158865185374, -0.978358924501 },
    { 0.753172423342, -0.644243404318, -0.132972691595 },
    { -0.904497088002, -0.058840837962, 0.422401199789 },
    { 0.530430129912, 0.600957391460, 0.597908095723 },
    { 0.413898854116, -0.540632246965, 0.732396417320 },
    { 0.427444881208, -0.864065425836, 0.265860514939 },
    { -0.408789072280, 0.410647141974, -0.815021729264 },
    { 0.592980493645, -0.181702907266, -0.784447695928 },
    { 0.607084821368, 0.309437594923, 0.731912832592 },
    { -0.584134645830, 0.765247940372, 0.270522282441 },
    { 0.405930467826, 0.695665727852, -0.592680057352 },
    { -0.800031087580, -0.534514946751, -0.272477578169 },
    { -0.992671991607, -0.046991520869, 0.111328855407 },
    { -0.467578063692, 0.685689395599, 0.557853750653 },
    { 0.793879351218, 0.348120649621, -0.498565531317 },
    { -0.184665109508, -0.418971320000, -0.889022963903 },
    { -0.422876252166, -0.264573790163, 0.866704323811 },
    { -0.879565352607, 0.312600185240, -0.358672433680 },
    { 0.518648806752, -0.851994686763, -0.071473554419 },
    { 0.402205780096, 0.113785910441, 0.908451031725 },
    { -0.106383374893, -0.825117428645, 0.554854761620 },
    { 0.720882859186, 0.100418992979, -0.685743340603 },
    { 0.699944827698, -0.690781424707, 0.181378778966 },
    { 0.823979311569, -0.178867096882, -0.537647334001 },
    { -0.440894869088, -0.742478837383, 0.504318243226 },
    { -0.679632759115, 0.390520223948, -0.620961566785 },
    { 0.587699520860, -0.649733175984, 0.482136985936 },
    { -0.282005903827, 0.889162428080, 0.360364879946 },
    { 0.124578399630, -0.349984170767, -0.928434867160 },
    { -0.136762862277, 0.968562819518, -0.207802752986 },
    { 0.837856286499, -0.427733359675, -0.339176968844 },
    { -0.279519772062, -0.915106534181, 0.290600633389 },
    { -0.231775573915, 0.268747634129, 0.934908975509 },
    { 0.072100068112, -0.628230544576, -0.774679264625 },
    { -0.549422917459, 0.362419581115, 0.752852246457 },
    { 0.645201312156, -0.470778851124, -0.601732947516 },
    { 0.238503858566, 0.956932275586, 0.165518969880 },
    { -0.562156926809, -0.482166466129, 0.671933842414 },
    { -0.973289559578, 0.031509252327, -0.227408443630 },
    { 0.275444466958, 0.447056990923, -0.851040770169 },
    { -0.193504155775, 0.639596955233, -0.743956905039 },
    { -0.250485317798, 0.157469058593, -0.955228036206 },
    { -0.693541377842, 0.617835130728, -0.370513304024 },
    { 0.275088781634, -0.783361543552, 0.557378555654 },
    { -0.341728795683, -0.936253054357, -0.081557638570 },
    { 0.823582268615, 0.163475363156, 0.543128025850 },
    { 0.330062094648, 0.441912417141, 0.834129743657 },
    { 0.872899126339, -0.143014519731, 0.466469680025 },
    { 0.033156052990, -0.843469650466, -0.536152613435 },
    { 0.061249819153, 0.902872009352, 0.425523905770 },
    { -0.489144067863, 0.066906124674, 0.869633055579 },
    { 0.890781672435, 0.407751668593, -0.200615524856 },
    { 0.581619199700, -0.711513286424, -0.394294242644 },
    { -0.948726415825, -0.294596924574, -0.114589877162 },
    { -0.716758112579, 0.486982331138, 0.499105216574 },
    { 0.906257451780, -0.421479433266, 0.032442540403 },
    { -0.062936583620, -0.099177146874, -0.993077479344 },
    { -0.439984369768, 0.847276560179, -0.297550306555 },
    { 0.303554844954, -0.894042106348, -0.329458902113 },
    { 0.218840608976, 0.717718532766, 0.661051356240 },
    { 0.670199140297, 0.697445262333, 0.253777891855 },
    { -0.815160108507, 0.083839055970, -0.573136118381 },
    { -0.763893308135, 0.165260984908, 0.623823549294 },
    { 0.967192056349, -0.175156813375, -0.184009828172 },
    { -0.269586298843, -0.596083638787, 0.756311789573 },
    { 0.018468839972, 0.528101584496, 0.848980340410 },
    { -0.881844022118, -0.199582169571, -0.427221345726 },
    { -0.071719980077, -0.994699332691, 0.073685018837 },
    { -0.526525387911, -0.690039580610, -0.496604866142 },
    { -0.170014127569, 0.847766231938, -0.502381938781 },
    { 0.453407934605, 0.842198052311, -0.291759636551 },
    { 0.111678479247, 0.690387675533, -0.714767636890 },
    { -0.649079711355, 0.758883523067, -0.052833007910 },
    { -0.912111884475, -0.356450964871, 0.202471281526 },
    { -0.297387822829, 0.541034069900, 0.786665505816 },
    { -0.710754837534, -0.434833579208, -0.552944228034 },
    { 0.564000074418, 0.435278481689, -0.701738241395 },
    { 0.829055608644, -0.437329011332, 0.348439569543 },
    { 0.774462349149, 0.457842958618, 0.436563735317 },
    { -0.126743856391, 0.763250467524, 0.633549302495 },
    { 0.396243931394, -0.450576318886, -0.799982329612 },
    { 0.730791206749, 0.676833841476, -0.088544695896 },
    { -0.009260711903, -0.970364186113, -0.241469636858 },
    { -0.688213009282, -0.136537296982, 0.712545030428 },
    { 0.182994990688, 0.972197228165, -0.146100591826 },
    { 0.880931450147, 0.457648757405, 0.120488152898 },
    { -0.467313323472, -0.453947185193, -0.758650255889 },
    { -0.124635335513, -0.360770496560, 0.924289284777 },
    { 0.669003315330, 0.625220523362, -0.401912753274 },
    { 0.449784518252, -0.218660153826, 0.865957056828 },
    { 0.922845029030, 0.083406448231, -0.376032467731 },
    { 0.977472420394, -0.137918068881, 0.159769439022 },
    { 0.319757410131, -0.108512216939, -0.941265264121 },
    { 0.949980002307, 0.173876891908, 0.259431728355 },
    { 0.060035643266, -0.646809260615, 0.760285145140 },
    { -0.078150485913, 0.990157807172, 0.116103481638 },
    { -0.700534022261, -0.618080613052, 0.356690957869 },
    { -0.966840363885, 0.255039636505, 0.013209639420 },
    { 0.183754939093, -0.391579914762, 0.901609279408 },
    { -0.908875746378, 0.253235142343, 0.331386240402 },
    { -0.793047992294, -0.608005625792, 0.037470534064 },
    { 0.501177341986, 0.864913733389, 0.027303949795 },
    { -0.180980582436, -0.042442019433, 0.982570457406 },
    { 0.463523796688, 0.166813454750, -0.870240748999 },
    { -0.284131027000, -0.873254293620, -0.395849085095 },
    { 0.989159658111, 0.136342809137, -0.054532643094 },
    { 0.670632611280, -0.035050530932, 0.740961106246 },
    { -0.666217434422, -0.167219207791, -0.726768234458 },
    { -0.387628059832, -0.148846279885, -0.909719337046 },
    { 0.408364059776, 0.820673171608, 0.399667787150 },
    { -0.241168244074, -0.693034259310, -0.679368378328 },
    { -0.813889211208, 0.545149101702, 0.200989573841 },
    { -0.567207783046, 0.128440370757, -0.813497634915 },
    { -0.850225156217, 0.514301781960, -0.112298089067 },
    { 0.346423164403, -0.711419929086, -0.611451286420 },
    { 0.089676263999, 0.229288514727, 0.969218729023 },
    { -0.467353120030, 0.665595991963, -0.581861698929 },
    { 0.239300957175, -0.970929691605, 0.005530448034 },
    { 0.148022818198, 0.880867394072, -0.449624153436 },
    { 0.678373227861, -0.358475519575, 0.641330699084 },
    { -0.553623819180, -0.819504851754, 0.148028594492 },
    { -0.596057291923, -0.779413068476, -0.192953293401 },
    { -0.383709888582, 0.922850075653, 0.033383517953 },
    { 128, DUMMYVAL, DUMMYVAL },
    { 0.380131243436, 0.885350358681, -0.267684478720 },
    { 0.353409998634, 0.123275541120, -0.927310365426 },
    { -0.732205046926, -0.573159119566, 0.367919003198 },
    { 0.554455405618, -0.427950529689, -0.713748938577 },
    { 0.330801432568, -0.390805609800, 0.858976942391 },
    { -0.609564894219, -0.429578676155, 0.666252805420 },
    { 0.342920772720, 0.519794512717, 0.782444252446 },
    { -0.150285167978, 0.512724825283, -0.845297357043 },
    { -0.268116371869, -0.883234431056, 0.384721393910 },
    { 0.604811051666, -0.730304245077, 0.317583534532 },
    { -0.625006508199, -0.475466933685, -0.619110700667 },
    { -0.996771215969, 0.001341316794, 0.080282899085 },
    { -0.921398252048, 0.297318139756, 0.250254240513 },
    { 0.143840640635, 0.911242590956, 0.385936277809 },
    { -0.670239313882, -0.167420231761, -0.723014334660 },
    { -0.307277991144, 0.946316666581, -0.100324487085 },
    { 0.010212171966, -0.697695681134, -0.716321469782 },
    { 0.817127611813, 0.212656465180, 0.535798183863 },
    { 0.312259204147, -0.928299532356, 0.201876614925 },
    { -0.395504668626, 0.659516047551, -0.639229724057 },
    { 0.506122685415, -0.583162614316, 0.635422058613 },
    { -0.781418562553, 0.575821678156, -0.240446303909 },
    { -0.668108716277, 0.503442902747, -0.547883187284 },
    { -0.938476377326, -0.318731146066, -0.132938127443 },
    { -0.193241987250, -0.142688036864, -0.970720175179 },
    { 0.626738607366, -0.308285183856, 0.715652823268 },
    { 0.128128061486, 0.374650453564, -0.918270242088 },
    { 0.580546636069, 0.814005197884, -0.019003714540 },
    { -0.533902925476, 0.483482396362, 0.693680357640 },
    { -0.520856948808, -0.721309516263, -0.456531073014 },
    { -0.211770022824, 0.651703744549, 0.728310158362 },
    { 0.342848581141, -0.804947885333, 0.484266199840 },
    { 0.794755089677, -0.407834177924, -0.449483738025 },
    { 0.805191182245, -0.581480770303, 0.116392756656 },
    { -0.221966040256, 0.214501587694, -0.951167780074 },
    { 0.811007706511, 0.585028365542, -0.002882965699 },
    { 0.856046878045, 0.417893681682, 0.304218035955 },
    { 0.017805336631, 0.979165496692, -0.202281734408 },
    { -0.470993030393, 0.022763571858, -0.881843174900 },
    { -0.459466791881, 0.381030490557, -0.802312926747 },
    { 0.319108924802, -0.716907026920, -0.619849827672 },
    { 0.193073082848, 0.639398696255, -0.744239270602 },
    { 0.763062830282, -0.469693871314, 0.443985117196 },
    { 0.679506066156, 0.453986196414, -0.576340211614 },
    { 0.099580272540, 0.733396529158, 0.672468066409 },
    { -0.690207703473, 0.198557702028, -0.695836306204 },
    { -0.560156120732, -0.794657507047, 0.233975569023 },
    { -0.935421349139, -0.302128469684, 0.183589998042 },
    { 0.643999630775, 0.504652650842, 0.574969718820 },
    { 0.039735746837, 0.467726972664, 0.882979359592 },
    { -0.738238027319, 0.521063957398, 0.428365459999 },
    { 0.959147130153, 0.149029162237, -0.240472641943 },
    { 0.559168931230, -0.829010718597, 0.008445993001 },
    { -0.763908258568, -0.577449289611, -0.288091114787 },
    { 0.257344797960, -0.485918637454, -0.835258482589 },
    { 0.932666801728, -0.294016440318, 0.209014281277 },
    { -0.814411134668, -0.577851815739, 0.053120455347 },
    { 0.408323416120, 0.730588309725, 0.547277543428 },
    { -0.071895083242, -0.980605262358, -0.182330514292 },
    { -0.368687917062, -0.896061986820, -0.247269358369 },
    { 0.956647161559, 0.289050534109, 0.035721100381 },
    { 0.468931079214, -0.166812212329, -0.867339223582 },
    { -0.321542858950, -0.944485986793, 0.067501189692 },
    { -0.010696348007, -0.988208811696, 0.152738117791 },
    { 0.137129096366, -0.138508465971, 0.980821602425 },
    { -0.088869719153, 0.755406686792, -0.649201748741 },
    { 0.050342577958, 0.068998326316, -0.996345751138 },
    { 0.849334793374, 0.438473172220, -0.293890602108 },
    { 0.592201158974, -0.644230483212, -0.484009165007 },
    { -0.614078714966, -0.784415962069, -0.087171843370 },
    { 0.150963737128, 0.865976576448, -0.476754149553 },
    { -0.527704944636, 0.766658560642, -0.365735071877 },
    { -0.729354643091, -0.069580344666, 0.680588260432 },
    { -0.319422048613, -0.488512932430, 0.811988097024 },
    { -0.277132497924, 0.379653036938, 0.882644407527 },
    { 0.177308935449, -0.669120626444, 0.721691851607 },
    { -0.826305207606, 0.557825117854, 0.077787156871 },
    { 0.440301393526, -0.846123410227, -0.300349558888 },
    { 0.159438842448, -0.220380961684, -0.962294906588 },
    { 0.959060994321, 0.064157615083, 0.275836563203 },
    { -0.566532325431, 0.182727708054, 0.803524554044 },
    { -0.919536463329, 0.002974717023, 0.392993439726 },
    { -0.147437292783, -0.722031511661, 0.675968002842 },
    { 0.234043644006, -0.967058936359, -0.100102878619 },
    { -0.854913929665, -0.001204248456, -0.518768467287 },
    { 0.040464632563, -0.886735857263, 0.460502044464 },
    { -0.170812097429, -0.215264616269, 0.961501103668 },
    { 0.624437255854, 0.146061320169, -0.767296685938 },
    { 0.736120750687, -0.648295089688, -0.194524335482 },
    { 0.919776154727, -0.135175957853, -0.368428128153 },
    { 0.856447413075, -0.154008089977, 0.492726432067 },
    { -0.322992332060, -0.620846129188, -0.714301083089 },
    { -0.621504617415, 0.744993623191, 0.242314902424 },
    { -0.869402727843, 0.296437783594, -0.395301830602 },
    { 0.441580599097, 0.426971965190, -0.789114386793 },
    { -0.414695849131, -0.336103099860, -0.845613421711 },
    { 0.673938158750, 0.677308291309, 0.295060733926 },
    { -0.053786726628, 0.989387246976, 0.134980974804 },
    { 0.446728004331, 0.699584509070, -0.557687730559 },
    { -0.153051724247, 0.867436705183, 0.473422361328 },
    { -0.828205762967, -0.293402868084, 0.477482953820 },
    { 0.689746855320, -0.001588625224, 0.724048860124 },
    { 0.830612366026, 0.161350573466, -0.532962559517 },
    { 0.917218578442, -0.376797440728, -0.129359066253 },
    { 0.249059145045, 0.968305334577, 0.018823424197 },
    { -0.226600388783, 0.887531223902, -0.401174015113 },
    { 0.556408633612, 0.275839210611, 0.783787064407 },
    { -0.019351235885, 0.149807661711, 0.988525768082 },
    { -0.449014756028, 0.731277475646, 0.513438411576 },
    { -0.951171137893, 0.297021508684, -0.083974340241 },
    { 0.996904778600, -0.076607336338, -0.017668571641 },
    { 0.425217993883, 0.867583279452, 0.257854437414 },
    { -0.784508934404, 0.245658956342, 0.569383358564 },
    { 0.737621945626, -0.147444161624, -0.658918875533 },
    { -0.462452266718, -0.691662934481, 0.554743441667 },
    { 0.654314355799, 0.688675825058, -0.312407317096 },
    { -0.595467028197, 0.800905204991, -0.063006911916 },
    { -0.087159395895, -0.443835936004, -0.891859238680 },
    { -0.972970919525, -0.010758321670, -0.230676934852 },
    { -0.315662146960, 0.064664196127, 0.946665701669 },
    { 0.007412448934, -0.464374233232, 0.885608055017 },
    { -0.488999795842, -0.192850698288, 0.850698423553 },
    { 0.127889880841, -0.893514781117, -0.430436423068 },
    { -0.186818949054, -0.842177746588, -0.505801664120 },
    { -0.843010539416, -0.307368093009, -0.441427327920 },
    { 0.279165202026, 0.215635870153, 0.935717885626 },
    { -0.353121560457, 0.909954903059, 0.217456289722 },
    { 0.433090136760, -0.069554649621, 0.898662942463 },
    { 129, DUMMYVAL, DUMMYVAL },
    { 0.255112148211, 0.190646287407, 0.947930263750 },
    { 0.609021478426, -0.247036607043, 0.753701368976 },
    { -0.185196023970, -0.046670597355, -0.981592730234 },
    { 0.767781677246, 0.351520940453, -0.535671844050 },
    { -0.739142439253, -0.522583852958, 0.424940667767 },
    { -0.168090162014, -0.985771622014, 0.000081649427 },
    { -0.353533977748, -0.333099550761, -0.874104350670 },
    { 0.662021207043, 0.716623696060, 0.219495785087 },
    { 0.349840421699, -0.149571656967, 0.924791867815 },
    { 0.350192611107, 0.216669993167, -0.911273421750 },
    { 0.766178173217, 0.006316768006, 0.642597156333 },
    { 0.149976836875, 0.976820643560, -0.152736304515 },
    { 0.727794772626, -0.187908879478, -0.659549105035 },
    { -0.704043627531, -0.276533988905, 0.654103603043 },
    { -0.886905110834, -0.241142593722, 0.394017225347 },
    { 0.660407441620, 0.744575252080, -0.097312409503 },
    { -0.918822860876, -0.376814516083, 0.117368525596 },
    { -0.866685568628, 0.434344172456, -0.245359460762 },
    { -0.165437255061, -0.255684090995, 0.952499952887 },
    { 0.177122387260, 0.497932570099, -0.848935106805 },
    { -0.518068542114, -0.733605722959, -0.439804080146 },
    { -0.669005821118, -0.725318787126, -0.162307942976 },
    { -0.450116925304, 0.303550343147, 0.839792797498 },
    { 0.503896336080, -0.419339097756, -0.755144491855 },
    { -0.981135224844, -0.023367691173, 0.191905241145 },
    { -0.522883823086, -0.756809632864, 0.392213828364 },
    { 0.184288892404, -0.981559237030, -0.050784528530 },
    { -0.697999910635, 0.696408940366, -0.166765441661 },
    { 0.070027553480, -0.851711600907, 0.519310591683 },
    { -0.169131306188, 0.519983306333, -0.837264571329 },
    { -0.839539157823, 0.033165678620, 0.542285939559 },
    { 0.393765623531, -0.484075954235, 0.781421207965 },
    { -0.656237318428, -0.293899774605, -0.694964390735 },
    { -0.135773176436, 0.917575849504, -0.373657871545 },
    { 0.941004323745, 0.247896329112, -0.230343814126 },
    { 0.049468610600, -0.970943111475, 0.234141689676 },
    { -0.250509460886, 0.786085285093, 0.565079582507 },
    { -0.982448071091, -0.144864668284, -0.117516022279 },
    { 0.970203648248, -0.126741459090, 0.206498143997 },
    { 0.831603277987, 0.438862712118, 0.340346159011 },
    { 0.072279250635, 0.886719155183, 0.456623312764 },
    { 0.589803222585, -0.751951210451, -0.294451245083 },
    { -0.487817060921, -0.869222028756, 0.080545513837 },
    { -0.908269499367, 0.261308574129, 0.326748137877 },
    { 0.935895088474, -0.352085190047, -0.011679140377 },
    { -0.882080434846, -0.222699165672, -0.415137553194 },
    { -0.234913514542, -0.764681643613, 0.600064683685 },
    { 0.866469713123, 0.497840294332, 0.037219317294 },
    { -0.506133330025, 0.578197995783, 0.639934473138 },
    { 0.877519875203, 0.048475039940, -0.477083891078 },
    { 0.321500610929, 0.696197656346, 0.641830336203 },
    { 0.815226502538, -0.530418680480, -0.232511877025 },
    { 0.099776902476, -0.810623950345, -0.577003796226 },
    { 0.538353327867, 0.105224895233, 0.836124043308 },
    { 0.415216451279, 0.908588458434, 0.045412683107 },
    { -0.624688983649, 0.626831062768, -0.465667791946 },
    { -0.228759126864, 0.530643817383, 0.816141164842 },
    { 0.133410238634, 0.470008175276, 0.872521646380 },
    { 0.093520697311, -0.650104609801, 0.754067553665 },
    { 0.837166996712, -0.477068630265, 0.267501292768 },
    { -0.451784616887, 0.891220496746, 0.040208035568 },
    { -0.013922704950, 0.736115732376, -0.676712484616 },
    { 0.599245077433, 0.612612625405, 0.515374726163 },
    { -0.222066327503, -0.812939583959, -0.538345408657 },
    { 0.989459687236, -0.054462859180, -0.134176467029 },
    { 0.142048300480, -0.025267981151, -0.989537169317 },
    { 0.841775257122, -0.247895865593, 0.479543591678 },
    { 0.259470821061, -0.306574328001, -0.915798599272 },
    { 0.304707343448, -0.892724522274, -0.331958374168 },
    { 0.734651827302, -0.677756008823, 0.030552989165 },
    { 0.481744717479, -0.084838111011, -0.872195231643 },
    { -0.499908758941, -0.560388786930, 0.660345091764 },
    { -0.321075620970, 0.240581979525, -0.915986220828 },
    { 0.015402438732, 0.704419419051, 0.709616831075 },
    { -0.032087921579, -0.952320882543, -0.303406166649 },
    { -0.774368097935, 0.345459425086, -0.530105493765 },
    { -0.866197328372, -0.468249103329, -0.174484857659 },
    { -0.208021858955, 0.940215743544, 0.269668800176 },
    { 0.803787197246, 0.528492769922, -0.273169423040 },
    { 0.041192336149, -0.028511109042, 0.998744365743 },
    { -0.744871013958, -0.653435135188, 0.134869183535 },
    { 0.329919412752, 0.688799991504, -0.645529048761 },
    { -0.614723413048, 0.016141716175, 0.788577561467 },
    { 0.449605240234, 0.429370233083, 0.783260065940 },
    { -0.363431974513, -0.903339532592, -0.227804496791 },
    { 0.378778854050, -0.728871732101, 0.570326729050 },
    { 0.109740990429, 0.980666653314, 0.162017993130 },
    { -0.436478169962, 0.854834996071, -0.280613500459 },
    { -0.729227468048, -0.503099237959, -0.463808642232 },
    { 0.122536275172, -0.375011001339, 0.918886070273 },
    { -0.321951409065, 0.025541483312, 0.946411603284 },
    { -0.981365752703, 0.187526452146, -0.041893784351 },
    { -0.456806229983, -0.283853573698, 0.843062997022 },
    { 0.650139408825, -0.512670422214, 0.560792107006 },
    { 0.188894429814, -0.588342877753, -0.786238864838 },
    { 0.512303240057, 0.433881225241, -0.741142680332 },
    { -0.163630371172, 0.984791463352, -0.058402699755 },
    { -0.881872881393, 0.464671784244, 0.079877118068 },
    { 0.001893215024, 0.257460575422, -0.966286949017 },
    { 0.347428727504, -0.893844009430, 0.283436352839 },
    { -0.323836911630, 0.747296534415, -0.580239213012 },
    { 0.424506592331, -0.696342471600, -0.578706588276 },
    { 0.976197228422, 0.196914091615, 0.090905509978 },
    { -0.473011869153, 0.504363007225, -0.722411052368 },
    { -0.450882376135, -0.564464325311, -0.691436987977 },
    { -0.930401935096, 0.107025188442, -0.350567893865 },
    { 0.711619578873, 0.324682040438, 0.623040245555 },
    { 0.484405427425, -0.874799283123, -0.008808866450 },
    { 0.386552901623, 0.849677788372, 0.358642593948 },
    { 0.893603892528, -0.251741880412, -0.371615539106 },
    { -0.503642132496, -0.054984631371, -0.862160827623 },
    { -0.046350418654, -0.343999761452, -0.937825038486 },
    { -0.741646070897, 0.532177558220, 0.408348077075 },
    { 0.166054343395, 0.875232522027, -0.454306050396 },
    { 0.610340786293, -0.724539120485, 0.320198668757 },
    { -0.780657352117, -0.001384964979, -0.624957742938 },
    { 0.659958791978, 0.133378313508, -0.739367715266 },
    { -0.495156704464, 0.785590607573, 0.371035355886 },
    { -0.605791589696, 0.225823023002, -0.762902688510 },
    { -0.105790309294, 0.264282119725, 0.958625772475 },
    { -0.136086508251, -0.614368690833, -0.777194682172 },
    { 0.693965328510, -0.497839713033, -0.520161266294 },
    { 0.437322286353, 0.849850420707, -0.294114739996 },
    { -0.252924752311, -0.913310646830, 0.319206409796 },
    { 0.595059292802, 0.644393808018, -0.480271858679 },
    { -0.708475494739, 0.308320250361, 0.634823673607 },
    { -0.693878524348, 0.706054851845, 0.141489008882 },
    { -0.204295094935, -0.538676073025, 0.817368706604 },
    { 0.909845870014, 0.127900025369, 0.394743051020 }
};

dti_tensor *
get_tensor_list(int numdirs) {
    return &tensorlist[(((numdirs + 1) * numdirs) / 2) - 20];
}

#endif /* #ifdef BIAC */
