/* $Id: bxh_convert.h,v 1.1 2009-01-15 20:55:18 gadde Exp $ */

/* bxh_convert.h --
 *
 * Utility functions for image format conversion
 *
 * Author: Syam Gadde (gadde@biac.duke.edu), Dec. 2008.
 */

#include "bxh_config.h"
#include "bxh_types.h"

#ifdef __cplusplus
#ifdef HAVE_DCMTK
#include <dcxfer.h>
#include <ofstd.h>
#include <ofconsol.h>
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef BXHDocPtr todocfn(const char *filename);
extern todocfn bxh_pfile2doc;
extern todocfn bxh_signafive2doc;
#ifndef WIN32
extern todocfn bxh_iowasignafive2doc;
#endif
extern todocfn bxh_ximg2doc;
extern todocfn bxh_analyze2doc;
extern todocfn bxh_afni2doc;
#ifdef __cplusplus
#ifdef HAVE_DCMTK
extern todocfn bxh_dicom2doc;
#endif
#endif
#ifdef HAVE_MINC
extern todocfn bxh_minc2doc;
#endif
extern todocfn bxh_mgh2doc;
extern todocfn bxh_bxh2doc;

extern BXHDocPtr createDocFromAFNI(const char *ifname, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient);
extern BXHDocPtr createDocFromNRRD(const char *ifname, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient);
extern BXHDocPtr createDocFromAnalyze(const char **inifnames, int numinfiles, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient, char * orient, int strictanalyze, char * avwbyteorder, int nofixpixdim);
extern BXHDocPtr createDocFromBXH(const char *ifname, const char *ofname);
extern BXHDocPtr createDocFromIowaSigna5(const char *imagedir, const char *ofname);
extern BXHDocPtr createDocFromMGH(const char **ifnames, int numinfiles, const char *ofname);
extern BXHDocPtr createDocFromMINC(const char *ifname, const char *ofname);
extern BXHDocPtr createDocFromPFile(const char *pfname, const char **ifnames, int numfiles, const char *ofname, size_t *hintsize, double *hintorigin, double *hintspacing, double *hintgap, const char *forceorient, float forceversion, int msbfirst, const char * dimorder, const char * elemtype, int usemrorigin);
extern BXHDocPtr createDocFromSigna5(const char **ifnames, int numfiles, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient, size_t dimzsize, size_t dimtsize);
extern BXHDocPtr createDocFromXIMG(const char **ifnames, int numfiles, const char *ofname);

extern int createBXHFromAFNI(const char *ifname, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient);
extern int createBXHFromNRRD(const char *ifname, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient);
extern int createBXHFromAnalyze(const char **inifnames, int numinfiles, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient, char * orient, int strictanalyze, char * avwbyteorder, int nofixpixdim);
extern int createBXHFromBXH(const char *ifname, const char *ofname);
#ifdef __cplusplus
#ifdef HAVE_DCMTK
extern int createBXHFromDICOM(int numinfiles, const char **ifnames, const char *ofname, const OFBool isDataset, const E_TransferSyntax xfer, const OFBool showFullData, const OFBool loadIntoMemory, const OFBool stopOnErrors, const OFBool searchForOthers, const OFBool forceConcat, const int filenameSort, const int printfields, const int cornerorigin, size_t *hintsize, double *hintorigin, double *hintspacing, double *hintgap, char *forceorient, char *progname);
#endif
#endif
extern int createBXHFromIowaSigna5(const char *imagedir, const char *ofname);
extern int createBXHFromMGH(const char **ifnames, int numinfiles, const char *ofname);
extern int createBXHFromMINC(const char *ifname, const char *ofname);
extern int createBXHFromPFile(const char *pfname, const char **ifnames, int numfiles, const char *ofname, size_t *hintsize, double *hintorigin, double *hintspacing, double *hintgap, const char *forceorient, float forceversion, int msbfirst, const char * dimorder, const char * elemtype, int usemrorigin);
extern int createBXHFromSigna5(const char **ifnames, int numfiles, const char *ofname, size_t * hintsize, double * hintorigin, double * hintspacing, double * hintgap, char * forceorient, size_t dimzsize, size_t dimtsize);
extern int createBXHFromXIMG(const char **ifnames, int numfiles, const char *ofname);
#ifdef __cplusplus
}
#endif


/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 */
