/* $Id: bxh_dicom.h,v 1.6 2006-10-27 13:56:05 gadde Exp $ */

/* bxh_dicom.h --
 *
 * Extract DICOM data into BXH files using these functions.
 *
 * Author: Syam Gadde (gadde@biac.duke.edu), Nov. 2002.
 */

#include "bxh_utils.h"

/** \defgroup bxh_DICOM DICOM to BXH conversion functions
 *  \ingroup bxh_convert */
/*@{*/
int bxh_DICOM_readFiles(BXHDocPtr docp, int numfiles, const char **filenames, int isDataset, int searchforothers, const char * basepath, int forceconcat, int filenamesort, int printfields, int cornerorigin);
int bxh_DICOM_readFilesStart(BXHDocPtr docp, int numfiles, const char **filenames, int isDataset, int searchforothers, const char * basepath, int forceconcat, int filenamesort, int printfields, int cornerorigin, void ** contp);
int bxh_DICOM_readFilesCont(BXHDocPtr docp, const char * basepath, void ** contp);
void bxh_DICOM_freeCont(void * cont);
/*@}*/

