/* $Id: bxh_dom_utils-xerces.h,v 1.4 2004-06-10 19:56:24 gadde Exp $ */

/* dom_utils.h --
 *
 * Author: Syam Gadde (gadde@biac.duke.edu)
 * Date: Aug. 2002
 */

#include <xercesc/dom/DOM.hpp>
#include <pathan/XPathEvaluator.hpp>

XERCES_CPP_NAMESPACE_USE

#ifdef __cplusplus
extern "C" {
#endif

extern char * domutil_errorbuf;

/** \defgroup bxh_dom_util_xerces DOM utility functions
 *  Some easier-to-use utility functions for use with Xerces-C.
 *  In general, all \c get*Value() functions return -1 on error and a
 *  non-negative value on success.  The values returned by the
 *  \c get*Value() functions are returned by reference in the last argument.*/
/*@{*/
int domutil_initialize();
DOMComment * domutil_appendComment(DOMDocument * doc, DOMElement * parent, const char * valuestr, int prependnewline);
DOMElement * domutil_appendNewChildWithTextValue(DOMDocument * doc, DOMElement * parent, const char * namestr, const char * valuestr, const char * namespaceURI);
int domutil_setAttributeWithTextValue(DOMDocument * doc, DOMElement * parent, const char * namestr, const char * valuestr, const char * namespaceURI);
XPathResult * domutil_getxpresult(DOMNode * ctxt, const char * exprstr, XPathResult::resultType nodetype);
int domutil_getNodeArray(DOMNode * ctxt, const char * path, XPathResult::resultType nodetype, DOMNode *** retp);
void domutil_freeNodeArray(DOMNode *** nap);
int domutil_getSingleNode(DOMNode * ctxt, const char * path, DOMNode ** retp);
int domutil_getDoubleValue(DOMNode * ctxt, const char * path, double * retp);
int domutil_getDoubleListValue(DOMNode * ctxt, const char * path, double ** retp);
int domutil_getIntValue(DOMNode * ctxt, const char * path, int * retp);
int domutil_getIntListValue(DOMNode * ctxt, const char * path, int ** retp);
int domutil_getUnsignedIntValue(DOMNode * ctxt, const char * path, unsigned int * retp);
int domutil_getUnsignedIntListValue(DOMNode * ctxt, const char * path, unsigned int ** retp);
int domutil_getStringValue(DOMNode * ctxt, const char * path, char ** retp);
void domutil_normalizeNamespaces(DOMElement * start);
void domutil_prettify(DOMNode * start, int startindent, int indentstep);
/*@}*/

#ifdef __cplusplus
};
#endif

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.3  2003/08/01 20:40:28  gadde
 * Some updates to help ease the migration of code between DOM implementations
 *
 * Revision 1.2  2003/08/01 17:55:55  gadde
 * Merge in XERCES-specific files
 *
 * Revision 1.9.2.1  2003/07/25 17:21:51  gadde
 * Committing branch that compiles with Xerces/Pathan
 *
 * Revision 1.9  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.8  2003/02/12 21:16:05  gadde
 * Updated docs.
 *
 * Revision 1.7  2002/12/04 17:21:51  gadde
 * Adding new module files
 *
 * Revision 1.6  2002/12/03 20:41:04  gadde
 * Big update --
 *  add new datarec module, convert more programs from domutil_ to bxh_,
 *  add new bxh_getElement* functions, and domutil_prettify.
 *
 * Revision 1.5  2002/11/15 20:52:33  gadde
 * Now BXH files have the correct namespace declarations (at the expense
 * of some fragile code in dom_utils.c that breaks the GDOME abstraction
 * layer).
 *
 * Revision 1.4  2002/09/09 19:50:31  gadde
 * Added domutil_appendNewAttributeWithTextValue().
 *
 * Revision 1.3  2002/08/23 16:52:15  gadde
 * Moved some docs to .c file.
 * unsigned short -> unsigned short int (for gtkdoc)
 *
 * Revision 1.2  2002/08/22 15:38:05  gadde
 * Added documentation.
 *
 * Revision 1.1  2002/08/20 15:32:33  gadde
 * Everything moved from libxml to libgdome (DOM).  All utility functions
 * prefixed with domutil_.  XPath support still shaky in gdome, but dom_utils.c
 * accounts for this, and extra code can be removed when gdome fully supports
 * the DOM level 3 XPath specification.
 *
 * Revision 1.1  2002/08/16 19:41:06  gadde
 * Initial import
 *
 */
