/* $Id: bxh_utils.h,v 1.21 2009-01-15 20:55:19 gadde Exp $ */

/* bxh_utils.h --
 *
 * Create and modify BXH files using these functions.
 * These are high-level C functions that are intended to not change
 * even if the underlying dom_utils functions use a different DOM
 * model.
 *
 * Author: Syam Gadde (gadde@biac.duke.edu), Nov. 2002.
 */

#ifndef __BXH_UTILS_H
#define __BXH_UTILS_H

#include <bxh_config.h>

#include "bxh_types.h"
#include "bxh_datarec.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_LIBXSLT
/** set this to non-zero if you want to write XCEDE-style XML headers */
extern int bxh_doXCEDE;
extern int bxh_doXCEDE2;
#endif

/** \addtogroup bxh_util_document */
/*@{*/
BXHDocPtr bxh_createDocument();
BXHDocPtr bxh_readFile(const char * filename);
BXHDocPtr bxh_readBuffer(char * buf);
int bxh_writeFile(BXHDocPtr docp, const char * filename);
void bxh_freeDocument(BXHDocPtr docp);
/*@}*/

/** \addtogroup bxh_util_section */
/*@{*/
BXHElementPtr bxh_getDatarec(BXHDocPtr docp, const char * type, const char * subtype);
BXHElementPtr * bxh_getDatarecArray(BXHDocPtr docp);
BXHElementPtr * bxh_getHistoryArray(BXHDocPtr docp);
BXHElementPtr bxh_getAcquisitionData(BXHDocPtr docp);
BXHElementPtr bxh_getSubject(BXHDocPtr docp);
BXHElementPtr bxh_getRootElement(BXHDocPtr docp);
int bxh_addHistoryEntry(BXHDocPtr docp, time_t date, const char * desc);
int bxh_addAutoHistoryEntry(BXHDocPtr docp, const char * programName, const char ** programArguments, int numargs);
/*@}*/

/** \addtogroup bxh_util_elementval */
/*@{*/
int bxh_getElementStringValue(BXHElementPtr elemp, char ** retp);
int bxh_getElementDoubleValue(BXHElementPtr elemp, double * retp);
int bxh_getElementIntValue(BXHElementPtr elemp, int * retp);
int bxh_getElementUnsignedIntValue(BXHElementPtr elemp, unsigned int * retp);
int bxh_getElementDoubleListValue(BXHElementPtr elemp, double ** retp);
int bxh_getElementIntListValue(BXHElementPtr elemp, int ** retp);
int bxh_getElementUnsignedIntListValue(BXHElementPtr elemp, unsigned int ** retp);
int bxh_getElementLongLongIntListValue(BXHElementPtr elemp, long long int ** retp);
/*@}*/

/** \addtogroup bxh_util_element */
/*@{*/
BXHElementPtr bxh_getChildElement(BXHElementPtr parentp, const char * qname);
BXHElementPtr * bxh_getChildElementArray(BXHElementPtr parentp, const char * qname);
char * bxh_getChildElementStringValue(BXHElementPtr parentp, const char * qname);
int bxh_setChildElement(BXHElementPtr parentp, const char * qname, const char * value);
int bxh_appendChildElement(BXHElementPtr parentp, const char * qname, const char * value);
BXHElementPtr bxh_appendAndReturnChildElement(BXHElementPtr parentp, const char * qname, const char * value);
BXHElementPtr bxh_removeChildElement(BXHElementPtr parentp, BXHElementPtr childp);
int bxh_element_unref(BXHElementPtr elemp);
char * bxh_getElementName(BXHElementPtr elemp);
/*@}*/

/** \addtogroup bxh_util_attribute */
/*@{*/
char * bxh_getAttributeStringValue(BXHElementPtr parentp, const char * name);
int bxh_setAttribute(BXHElementPtr parentp, const char * name, const char * value);
void bxh_removeAttribute(BXHElementPtr parentp, const char * name);
int bxh_attribute_unref(BXHAttributePtr attrp);
/*@}*/

/** \addtogroup bxh_util_comment */
/*@{*/
BXHCommentPtr bxh_appendComment(BXHElementPtr parentp, const char * valuestr, int prependnewline);
int bxh_comment_unref(BXHCommentPtr commentp);
/*@}*/

/** \addtogroup bxh_util_misc */
/*@{*/
void bxh_normalizeNamespaces(BXHElementPtr start);
void bxh_prettify(BXHDocPtr start, int startindent, int indentstep);
void bxh_removeAutogenComments(BXHElementPtr start);
/*@}*/

/** \addtogroup bxh_util_dataconv */
/*@{*/
char * bxh_convertBufToChar(const void * inbuf, size_t bufsize, const char * elemtype);
unsigned char * bxh_convertBufToUnsignedChar(const void * inbuf, size_t bufsize, const char * elemtype);
short * bxh_convertBufToShort(const void * inbuf, size_t bufsize, const char * elemtype);
unsigned short * bxh_convertBufToUnsignedShort(const void * inbuf, size_t bufsize, const char * elemtype);
int * bxh_convertBufToInt(const void * inbuf, size_t bufsize, const char * elemtype);
unsigned int * bxh_convertBufToUnsignedInt(const void * inbuf, size_t bufsize, const char * elemtype);
float * bxh_convertBufToFloat(const void * inbuf, size_t bufsize, const char * elemtype);
double * bxh_convertBufToDouble(const void * inbuf, size_t bufsize, const char * elemtype);
/*@}*/

/** \addtogroup bxh_util_dataread */
/*@{*/
struct bxhdataread {
    BXHDocPtr docp;
    bxhrawdatarec * readdatarec;
    bxhrawdatarec * datarec;
    BXHElementPtr imagedatap;
    BXHElementPtr acqdatap;
    BXHElementPtr subjectp;
    BXHElementPtr * historyarray;
    size_t * dimsizes;
    size_t * pagesizes;
    void * dataptr;
    size_t dataptrsize;
};
int bxh_dataReadFileStart(const char * inputfile, const char * type, const char * subtype, int numorddims, const char ** dimorder, const char ** dimselect, struct bxhdataread * out_bdr);
int bxh_dataReadDocStart(BXHDocPtr docp, const char * type, const char * subtype, int numorddims, const char ** dimorder, char ** dimselect, struct bxhdataread * out_bdr);
int bxh_dataReadFinish(struct bxhdataread * bdr, const char * elemtype);
void bxh_datareaddata_free(struct bxhdataread * bdr);
enum {
    FROM_INVALID = 0,
    FROM_PFILE,
    FROM_SIGNA5,
#ifndef WIN32
    FROM_IOWASIGNA5,
#endif
    FROM_XIMG,
    FROM_ANALYZE,
    FROM_AFNI,
    FROM_NRRD,
    FROM_DICOM,
    FROM_MINC,
    FROM_MGH,
    FROM_BXH,
    FROM_MAX
};
int bxh_autodetect_format(const char * filename);
void bxh_check_supported_type(int fromtype);
/*@}*/



#ifdef __cplusplus
}
#endif

#endif /* #ifndef __BXH_UTILS_H */
/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.20  2008/04/21 16:58:18  gadde
 * Export bxh_doXCEDE2 global.
 *
 * Revision 1.19  2007/05/11 15:50:17  gadde
 * Add dataptrsize field to reflect size of data (returned by bxh_dataReadFinish) in memory
 *
 * Revision 1.18  2007/02/23 23:26:10  gadde
 * Fix a nasty memory error due to our onconventional use of gdome2 and libxslt, as well as some other minor memory issues.
 *
 * Revision 1.17  2007/01/16 19:34:34  gadde
 * Memory fixes.
 *
 * Revision 1.16  2007/01/12 16:24:07  gadde
 * Add bxh_getElementName.
 *
 * Revision 1.15  2006/05/31 14:32:16  gadde
 * Remove unnecessary consts
 *
 * Revision 1.14  2005/05/09 20:34:09  gadde
 * Add function to remove AUTOGEN comments.
 *
 * Revision 1.13  2005/02/25 21:48:04  gadde
 * XCEDE updates
 *
 * Revision 1.12  2004/11/12 15:03:14  gadde
 * Add some functions for easier data reading.
 *
 * Revision 1.11  2004/05/27 22:02:30  gadde
 * Some updates to support phantomqa
 *
 * Revision 1.10  2004/02/24 18:01:07  gadde
 * Move history generation to bxh_utils.cpp, and add option to create BIRN files
 *
 * Revision 1.9  2003/08/08 19:27:12  gadde
 * Add missing declaration.
 *
 * Revision 1.8  2003/07/28 20:56:55  gadde
 * Slight integration of libxml2/Xerces branches
 *
 * Revision 1.7  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.6  2003/06/18 18:52:50  gadde
 * Add function to read BXH file from memory buffer.
 *
 * Revision 1.5  2003/04/17 19:34:25  gadde
 * Add bxh_appendAndReturnChildElement for convenience.
 *
 * Revision 1.4  2003/02/12 19:31:36  gadde
 * Updated doxygen documentation.
 *
 * Revision 1.3  2003/01/06 18:41:57  gadde
 * Many changes/updates to comments.
 * Minor bug fixes.
 *
 * Revision 1.2  2002/12/03 20:41:03  gadde
 * Big update --
 *  add new datarec module, convert more programs from domutil_ to bxh_,
 *  add new bxh_getElement* functions, and domutil_prettify.
 *
 * Revision 1.1  2002/11/25 16:23:10  gadde
 * Mega-update to merge in new library functions.
 *
 */
