#!/usr/bin/perl -w

use strict;

my $doheader = 0;
if ($#ARGV >= 0 && $ARGV[0] eq '--header') {
  shift;
  $doheader = 1;
}

if (($doheader && scalar(@ARGV) < 1) || (!$doheader && scalar(@ARGV) < 3)) {
  die "Usage: $0 --header gen3.tpl...\n       $0 gen3.tpl maxalignsize suffix\n";
}

my %block2offset =
  (
   'EXAMHDR'    => 36872,
   'SERIESHDR'  => 37912,
   'MRHDR'      => 38940,
   'RDBHDR'     => 0,
  );

my %type2size =
  (
   'String'          => 1,
   'Int16_B'         => 2,
   'Uint16_B'        => 2,
   'Int32_B'         => 4,
   'Uint32_B'        => 4,
   'Unix_DateTime_B' => 4,
   'IEEE_Float32_B'  => 4,
   'Uint64_B'        => 8,
   'IEEE_Float64_B'  => 8,
   'Pointer32'       => 4,
   'Pointer64'       => 8,
  );

my @tplarray = ();
my $maxalignsize = 0;
my $suffix = "";
if (!$doheader) {
  $suffix = pop;
  $maxalignsize = pop;
}
# leave tpl file(s) on command-line

my ($lastblock, $lastgetype, $lastgehowmany, $lastname) = undef;
my ($lastoffset, $lastsize) = undef;
while (<>) {
  next if /^\#/;
  my ($block, $getype, $gehowmany, $name, $descr);
  ($block) = /block=\"([^\"]*)\"/;
  ($getype) = /intype=\"([^\"]*)\"/;
  ($gehowmany) = /inlength=\"([^\"]*)\"/;
  (undef, $name) = /(name|keyword)=\"([^\"]*)\"/;
  ($descr) = /\# (.*)/;
  next if (!defined($block));
  next if (!exists($block2offset{$block}));
  my $size = $type2size{$getype};
  my $offset = undef;
  if (!defined($lastblock) || $lastblock ne $block) {
    $lastoffset = $block2offset{$block};
    $offset = $lastoffset;
  } elsif ($lastblock eq $block && $name eq $lastname) {
    # $offset = $lastoffset;
    next;
  } else {
    $offset = $lastoffset;
    $offset += $lastgehowmany * $lastsize;
    my $alignsize = $size;
    if ($maxalignsize != 0 && $alignsize > $maxalignsize) {
      $alignsize = $maxalignsize;
    }
    my $tmpcorrect = (($offset - $block2offset{$block}) % $alignsize);
    $tmpcorrect = ($alignsize - $tmpcorrect) % $alignsize;
    $offset += $tmpcorrect;
  }
  push @tplarray, [$block, $getype, $gehowmany, $offset, $size, $name, $descr];
  ($lastblock, $lastgetype, $lastgehowmany, $lastname) =
    ($block, $getype, $gehowmany, $name);
  ($lastoffset, $lastsize) = ($offset, $size);
}

print STDOUT "/* This file automatically generated by $0.  DO NOT EDIT! */\n";
if ($doheader) {
  print STDOUT "#include <sys/types.h>\n";
  print STDOUT "#ifndef _SIGNAMAPSGEN_H\n";
  print STDOUT "#define _SIGNAMAPSGEN_H\n";
} else {
  print STDOUT "#include \"bxh_signamaps.h\"\n";
}

# give a canonical order to these lists
my @rdbarray = grep { $_->[0] eq 'RDBHDR' } @tplarray;
my @exarray = grep { $_->[0] eq 'EXAMHDR' } @tplarray;
my @searray = grep { $_->[0] eq 'SERIESHDR' } @tplarray;
my @mrarray = grep { $_->[0] eq 'MRHDR' } @tplarray;

my %rdbhash = map { ($_->[5] => $_) } @rdbarray;
my %exhash = map { ($_->[5] => $_) } @exarray;
my %sehash = map { ($_->[5] => $_) } @searray;
my %mrhash = map { ($_->[5] => $_) } @mrarray;

for my $ahf ([ \@rdbarray, \%rdbhash, \&getrdborder ],
	     [ \@exarray, \%exhash, \&getexorder ],
	     [ \@searray, \%sehash, \&getseorder ],
	     [ \@mrarray, \%mrhash, \&getmrorder ])
{
  my ($arrayref, $hashref, $funcref) = @$ahf;
  @$arrayref = map {
    my $key = $_->[0];
    if (exists($hashref->{$key})) {
      my $hashent = $hashref->{$key};
      # make sure "howmany" is the same in both
      if ($hashent->[2] != $_->[1]) {
	$hashent->[2] = [$hashent->[2], $_->[1]];
      }
      $hashent;
    } else {
      $_;
    }
    
  } &{$funcref}();
}

# now generate structs
foreach my $instref ([\@rdbarray, 'rdb'], [\@exarray, 'ex'], [\@searray, 'se'], [\@mrarray, 'mr']) {
  my ($arrayref, $type) = @$instref;
  if ($doheader) {
    print STDOUT "struct signa${type}map {\n";
  } else {
    print STDOUT "struct signa${type}map signa${type}map${suffix}align${maxalignsize} = {\n";
  }
  foreach my $entry (@$arrayref) {
    if (scalar(@$entry) == 2) {
      my ($name, $gehowmany) = @$entry;
      $name =~ s/^[A-Z]+_//;
      if ($gehowmany == 1) {
	if ($doheader) {
	  print STDOUT "    off_t $name;\n";
	} else {
	  print STDOUT "    -1, /* $name */\n";
	}
      } else {
	for (my $valnum = 0; $valnum < $gehowmany; $valnum++) {
	  if ($doheader) {
	    print STDOUT "    off_t $name$valnum;\n";
	  } else {
	    print STDOUT "    -1, /* $name$valnum */\n";
	  }
	}
      }
      next;
    }

    my ($block, $getype, $gehowmany, $offset, $size, $name, $descr) = @$entry;
    $name =~ s/^[A-Z]+_//;
    my $tmpoffset = $offset - $block2offset{$block};
    if ($getype eq 'String' || (!ref($gehowmany) && $gehowmany == 1)) {
      if ($doheader) {
	print STDOUT "    off_t $name;\n";
      } else {
	print STDOUT "    $tmpoffset, /* $name */\n";
      }
    } else {
      my $defmaxval = $gehowmany;
      my $undefmaxval = $gehowmany;
      if (ref($gehowmany)) {
	($defmaxval, $undefmaxval) = @$gehowmany;
      }
      for (my $valnum = 0; $valnum < $defmaxval; $valnum++) {
	if ($doheader) {
	  print STDOUT "    off_t $name$valnum;\n";
	} else {
	  print STDOUT "    $tmpoffset, /* $name$valnum */\n";
	}
	$tmpoffset += $size;
      }
      for (my $valnum = $defmaxval; $valnum < $undefmaxval; $valnum++) {
	if ($doheader) {
	  print STDOUT "    off_t $name$valnum;\n";
	} else {
	  print STDOUT "    -1, /* $name$valnum */\n";
	}
      }
    }
  }
  print STDOUT "};\n";
}

if ($doheader) {
  print STDOUT "#endif /* #ifndef _SIGNAMAPSGEN_H */\n";
}

print STDOUT <<EOM if (!$doheader);
struct signamaps signamaps${suffix}align${maxalignsize} = {
    ${maxalignsize},
    &signardbmap${suffix}align${maxalignsize},
    &signaexmap${suffix}align${maxalignsize},
    &signasemap${suffix}align${maxalignsize},
    &signamrmap${suffix}align${maxalignsize}
};
EOM


sub getrdborder {
  return
    (
     ['RDB_csi_dims', 1],
     ['RDB_halfecho', 1],
     ['RDB_numdwell', 1],
     ['RDB_rdb_hdr_algor_num', 1],
     ['RDB_rdb_hdr_alt', 1],
     ['RDB_rdb_hdr_arw', 1],
     ['RDB_rdb_hdr_baseline_views', 1],
     ['RDB_rdb_hdr_bp_corr', 1],
     ['RDB_rdb_hdr_cheart', 1],
     ['RDB_rdb_hdr_clip_max', 1],
     ['RDB_rdb_hdr_clip_min', 1],
     ['RDB_rdb_hdr_ctr', 1],
     ['RDB_rdb_hdr_ctrr', 1],
     ['RDB_rdb_hdr_dab0e', 1],
     ['RDB_rdb_hdr_dab0s', 1],
     ['RDB_rdb_hdr_dab1e', 1],
     ['RDB_rdb_hdr_dab1s', 1],
     ['RDB_rdb_hdr_dab2e', 1],
     ['RDB_rdb_hdr_dab2s', 1],
     ['RDB_rdb_hdr_dab3e', 1],
     ['RDB_rdb_hdr_dab3s', 1],
     ['RDB_rdb_hdr_dacq_ctrl', 1],
     ['RDB_rdb_hdr_data_collect_type', 1],
     ['RDB_rdb_hdr_data_collect_type1', 1],
     ['RDB_rdb_hdr_datacq', 1],
     ['RDB_rdb_hdr_data_format', 1],
     ['RDB_rdb_hdr_da_xres', 1],
     ['RDB_rdb_hdr_da_yres', 1],
     ['RDB_rdb_hdr_ddaover', 1],
     ['RDB_rdb_hdr_default_offset', 1],
     ['RDB_rdb_hdr_dp_type', 1],
     ['RDB_rdb_hdr_excess', 716],
     ['RDB_rdb_hdr_exec_ctrl', 1],
     ['RDB_rdb_hdr_fast_rec', 1],
     ['RDB_rdb_hdr_fd_ctrl', 1],
     ['RDB_rdb_hdr_fd_df_dec', 1],
     ['RDB_rdb_hdr_fd_te', 1],
     ['RDB_rdb_hdr_fd_tr', 1],
     ['RDB_rdb_hdr_fermi_ecc', 1],
     ['RDB_rdb_hdr_fermi_radius', 1],
     ['RDB_rdb_hdr_fermi_width', 1],
     ['RDB_rdb_hdr_file_contents', 1],
     ['RDB_rdb_hdr_frame_size', 1],
     ['RDB_rdb_hdr_freq_scale', 1],
     ['RDB_rdb_hdr_gradcoil', 1],
     ['RDB_rdb_hdr_hdbestky', 1],
     ['RDB_rdb_hdr_hniter', 1],
     ['RDB_rdb_hdr_hnover', 1],
     ['RDB_rdb_hdr_ileaves', 1],
     ['RDB_rdb_hdr_im_size', 1],
     ['RDB_rdb_hdr_im_size_y', 1],
     ['RDB_rdb_hdr_incrpass', 1],
     ['RDB_rdb_hdr_initpass', 1],
     ['RDB_rdb_hdr_kissoff_views', 1],
     ['RDB_rdb_hdr_kydir', 1],
     ['RDB_rdb_hdr_lock_mode', 1],
     ['RDB_rdb_hdr_logo', 1],
     ['RDB_rdb_hdr_maxcoef1a', 1],
     ['RDB_rdb_hdr_maxcoef1b', 1],
     ['RDB_rdb_hdr_maxcoef1c', 1],
     ['RDB_rdb_hdr_maxcoef1d', 1],
     ['RDB_rdb_hdr_maxcoef2a', 1],
     ['RDB_rdb_hdr_maxcoef2b', 1],
     ['RDB_rdb_hdr_maxcoef2c', 1],
     ['RDB_rdb_hdr_maxcoef2d', 1],
     ['RDB_rdb_hdr_maxcoef3a', 1],
     ['RDB_rdb_hdr_maxcoef3b', 1],
     ['RDB_rdb_hdr_maxcoef3c', 1],
     ['RDB_rdb_hdr_maxcoef3d', 1],
     ['RDB_rdb_hdr_mb_factor', 1],
     ['RDB_rdb_hdr_mb_slice_fov_shift_factor', 1],
     ['RDB_rdb_hdr_mb_slice_order_sign', 1],
     ['RDB_rdb_hdr_mcReconEnable', 1],
     ['RDB_rdb_hdr_method_ctrl', 1],
     ['RDB_rdb_hdr_navs', 1],
     ['RDB_rdb_hdr_nechoes', 1],
     ['RDB_rdb_hdr_nframes', 1],
     ['RDB_rdb_hdr_npasses', 1],
     ['RDB_rdb_hdr_npomp', 1],
     ['RDB_rdb_hdr_nslices', 1],
     ['RDB_rdb_hdr_ntran', 1],
     ['RDB_rdb_hdr_nwin', 1],
     ['RDB_rdb_hdr_ovl', 1],
     ['RDB_rdb_hdr_pasframe', 1],
     ['RDB_rdb_hdr_pcbestky', 1],
     ['RDB_rdb_hdr_pccoil', 1],
     ['RDB_rdb_hdr_pccon', 1],
     ['RDB_rdb_hdr_pcconfitwt', 1],
     ['RDB_rdb_hdr_pcconfix', 1],
     ['RDB_rdb_hdr_pcconnorm', 1],
     ['RDB_rdb_hdr_pcconnpts', 1],
     ['RDB_rdb_hdr_pcconorder', 1],
     ['RDB_rdb_hdr_pcconslope', 1],
     ['RDB_rdb_hdr_pcctrl', 1],
     ['RDB_rdb_hdr_pcdiscbeg', 1],
     ['RDB_rdb_hdr_pcdiscend', 1],
     ['RDB_rdb_hdr_pcdiscmid', 1],
     ['RDB_rdb_hdr_pcextcorr', 1],
     ['RDB_rdb_hdr_pcfitorig', 1],
     ['RDB_rdb_hdr_pcgraph', 1],
     ['RDB_rdb_hdr_pcileave', 1],
     ['RDB_rdb_hdr_pclin', 1],
     ['RDB_rdb_hdr_pclinavg', 1],
     ['RDB_rdb_hdr_pclinfitwt', 1],
     ['RDB_rdb_hdr_pclinfix', 1],
     ['RDB_rdb_hdr_pclinnorm', 1],
     ['RDB_rdb_hdr_pclinnpts', 1],
     ['RDB_rdb_hdr_pclinorder', 1],
     ['RDB_rdb_hdr_pclinslope', 1],
     ['RDB_rdb_hdr_pcmultegrp', 1],
     ['RDB_rdb_hdr_pcshotfirst', 1],
     ['RDB_rdb_hdr_pcshotlast', 1],
     ['RDB_rdb_hdr_pcspacial', 1],
     ['RDB_rdb_hdr_pcspare', 1],
     ['RDB_rdb_hdr_pctemporal', 1],
     ['RDB_rdb_hdr_pcthrespct', 1],
     ['RDB_rdb_hdr_pcthrespts', 1],
     ['RDB_rdb_hdr_phase_scale', 1],
     ['RDB_rdb_hdr_point_size', 1],
     ['RDB_rdb_hdr_ps_aps_freq', 1],
     ['RDB_rdb_hdr_ps_aps_or_mps', 1],
     ['RDB_rdb_hdr_ps_aps_r1', 1],
     ['RDB_rdb_hdr_ps_aps_r2', 1],
     ['RDB_rdb_hdr_ps_aps_tg', 1],
     ['RDB_rdb_hdr_ps_command', 1],
     ['RDB_rdb_hdr_ps_filler1', 1],
     ['RDB_rdb_hdr_ps_filler2', 1],
     ['RDB_rdb_hdr_ps_mps_bitmap', 1],
     ['RDB_rdb_hdr_ps_mps_freq', 1],
     ['RDB_rdb_hdr_ps_mps_r1', 1],
     ['RDB_rdb_hdr_ps_mps_r2', 1],
     ['RDB_rdb_hdr_ps_mps_tg', 1],
     ['RDB_rdb_hdr_ps_powerspec', 1],
     ['RDB_rdb_hdr_ps_scalei', 1],
     ['RDB_rdb_hdr_ps_scaleq', 1],
     ['RDB_rdb_hdr_ps_snr_warning', 1],
     ['RDB_rdb_hdr_raw_pass_size', 1],
     ['RDB_rdb_hdr_rc_xres', 1],
     ['RDB_rdb_hdr_rc_yres', 1],
     ['RDB_rdb_hdr_rc_zres', 1],
     ['RDB_rdb_hdr_rdbm_rev', 1],
     ['RDB_rdb_hdr_rec_noise_mean', 16],
     ['RDB_rdb_hdr_rec_noise_std', 16],
     ['RDB_rdb_hdr_recon', 1],
     ['RDB_rdb_hdr_recon_ctrl', 1],
     ['RDB_rdb_hdr_recv_freq_e', 1],
     ['RDB_rdb_hdr_recv_freq_s', 1],
     ['RDB_rdb_hdr_ref', 1],
     ['RDB_rdb_hdr_refframep', 1],
     ['RDB_rdb_hdr_refframes', 1],
     ['RDB_rdb_hdr_reps', 1],
     ['RDB_rdb_hdr_rotation', 1],
     ['RDB_rdb_hdr_run_char', 1],
     ['RDB_rdb_hdr_run_int', 1],
     ['RDB_rdb_hdr_sarr', 1],
     ['RDB_rdb_hdr_scalei', 1],
     ['RDB_rdb_hdr_scaleq', 1],
     ['RDB_rdb_hdr_scan_date', 1],
     ['RDB_rdb_hdr_scan_seq', 1],
     ['RDB_rdb_hdr_scan_time', 1],
     ['RDB_rdb_hdr_scan_type', 1],
     ['RDB_rdb_hdr_scnframe', 1],
     ['RDB_rdb_hdr_slblank', 1],
     ['RDB_rdb_hdr_sspsave', 1],
     ['RDB_rdb_hdr_transpose', 1],
     ['RDB_rdb_hdr_udasave', 1],
     ['RDB_rdb_hdr_user0', 1],
     ['RDB_rdb_hdr_user1', 1],
     ['RDB_rdb_hdr_user10', 1],
     ['RDB_rdb_hdr_user11', 1],
     ['RDB_rdb_hdr_user12', 1],
     ['RDB_rdb_hdr_user13', 1],
     ['RDB_rdb_hdr_user14', 1],
     ['RDB_rdb_hdr_user15', 1],
     ['RDB_rdb_hdr_user16', 1],
     ['RDB_rdb_hdr_user17', 1],
     ['RDB_rdb_hdr_user18', 1],
     ['RDB_rdb_hdr_user19', 1],
     ['RDB_rdb_hdr_user2', 1],
     ['RDB_rdb_hdr_user20', 1],
     ['RDB_rdb_hdr_user21', 1],
     ['RDB_rdb_hdr_user22', 1],
     ['RDB_rdb_hdr_user23', 1],
     ['RDB_rdb_hdr_user24', 1],
     ['RDB_rdb_hdr_user25', 1],
     ['RDB_rdb_hdr_user26', 1],
     ['RDB_rdb_hdr_user27', 1],
     ['RDB_rdb_hdr_user28', 1],
     ['RDB_rdb_hdr_user29', 1],
     ['RDB_rdb_hdr_user3', 1],
     ['RDB_rdb_hdr_user30', 1],
     ['RDB_rdb_hdr_user31', 1],
     ['RDB_rdb_hdr_user32', 1],
     ['RDB_rdb_hdr_user33', 1],
     ['RDB_rdb_hdr_user34', 1],
     ['RDB_rdb_hdr_user35', 1],
     ['RDB_rdb_hdr_user36', 1],
     ['RDB_rdb_hdr_user37', 1],
     ['RDB_rdb_hdr_user38', 1],
     ['RDB_rdb_hdr_user39', 1],
     ['RDB_rdb_hdr_user4', 1],
     ['RDB_rdb_hdr_user40', 1],
     ['RDB_rdb_hdr_user41', 1],
     ['RDB_rdb_hdr_user42', 1],
     ['RDB_rdb_hdr_user43', 1],
     ['RDB_rdb_hdr_user44', 1],
     ['RDB_rdb_hdr_user45', 1],
     ['RDB_rdb_hdr_user46', 1],
     ['RDB_rdb_hdr_user47', 1],
     ['RDB_rdb_hdr_user48', 1],
     ['RDB_rdb_hdr_user5', 1],
     ['RDB_rdb_hdr_user6', 1],
     ['RDB_rdb_hdr_user7', 1],
     ['RDB_rdb_hdr_user8', 1],
     ['RDB_rdb_hdr_user9', 1],
     ['RDB_rdb_hdr_user_fill_mapLSW', 1],
     ['RDB_rdb_hdr_user_fill_mapMSW', 1],
     ['RDB_rdb_hdr_user_usage_tag', 1],
     ['RDB_rdb_hdr_ut_ctrl', 1],
     ['RDB_rdb_hdr_v_coefxa', 1],
     ['RDB_rdb_hdr_v_coefxb', 1],
     ['RDB_rdb_hdr_v_coefxc', 1],
     ['RDB_rdb_hdr_v_coefxd', 1],
     ['RDB_rdb_hdr_v_coefya', 1],
     ['RDB_rdb_hdr_v_coefyb', 1],
     ['RDB_rdb_hdr_v_coefyc', 1],
     ['RDB_rdb_hdr_v_coefyd', 1],
     ['RDB_rdb_hdr_v_coefza', 1],
     ['RDB_rdb_hdr_v_coefzb', 1],
     ['RDB_rdb_hdr_v_coefzc', 1],
     ['RDB_rdb_hdr_v_coefzd', 1],
     ['RDB_rdb_hdr_vm_coef1', 1],
     ['RDB_rdb_hdr_vm_coef2', 1],
     ['RDB_rdb_hdr_vm_coef3', 1],
     ['RDB_rdb_hdr_vm_coef4', 1],
     ['RDB_rdb_hdr_vps', 1],
     ['RDB_rdb_hdr_vquant', 1],
     ['RDB_rdb_hdr_vrgf', 1],
     ['RDB_rdb_hdr_vrgfxres', 1],
     ['RDB_rdb_hdr_v_type', 1],
     ['RDB_rdb_hdr_v_venc', 1],
     ['RDB_rdb_hdr_vvsaimgs', 1],
     ['RDB_rdb_hdr_vvsgender', 1],
     ['RDB_rdb_hdr_vvsmode', 1],
     ['RDB_rdb_hdr_vvstr', 1],
     ['RDB_rdb_hdr_xoff', 1],
     ['RDB_rdb_hdr_yoff', 1],
     ['RDB_rdb_hdr_zip_factor', 1],
     ['RDB_roilenx', 1],
     ['RDB_roileny', 1],
     ['RDB_roilenz', 1],
     ['RDB_roilocx', 1],
     ['RDB_roilocy', 1],
     ['RDB_roilocz', 1],
     ['RDB_spectral_width', 1],
     ['RDB_xcsi', 1],
     ['RDB_ycsi', 1],
     ['RDB_zcsi', 1],
     ['RDB_rdb_hdr_df', 1],
    );
}

sub getexorder {
  return
    (
     ['EX_cellspace', 1],
     ['EX_dastyp', 1],
     ['EX_dcn_density', 1],
     ['EX_dcn_len', 1],
     ['EX_dcn_shiftcnt', 1],
     ['EX_dcn_stepsize', 1],
     ['EX_detect', 1],
     ['EX_diagrad', 1],
     ['EX_ex_alloc_key', 1],
     ['EX_ex_checksum', 1],
     ['EX_ex_complete', 1],
     ['EX_ex_datetime', 1],
     ['EX_ex_delta_cnt', 1],
     ['EX_ex_desc', 1],
     ['EX_ex_diskid', 1],
     ['EX_ex_format', 1],
     ['EX_ex_lastmod', 1],
     ['EX_ex_modelcnt', 1],
     ['EX_ex_modelnum', 1],
     ['EX_ex_models_d', 1],
     ['EX_ex_models_l', 1],
     ['EX_ex_no', 1],
     ['EX_ex_numarch', 1],
     ['EX_ex_numseries', 1],
     ['EX_ex_numunser', 1],
     ['EX_ex_padding', 1],
     ['EX_ex_prospcnt', 1],
     ['EX_ex_prosp_d', 1],
     ['EX_ex_prosp_l', 1],
     ['EX_ex_seriesct', 1],
     ['EX_ex_series_d', 1],
     ['EX_ex_series_l', 1],
     ['EX_ex_stat', 1],
     ['EX_ex_suid', 1],
     ['EX_ex_sysid', 1],
     ['EX_ex_toarchcnt', 1],
     ['EX_ex_toarchive_d', 1],
     ['EX_ex_toarchive_l', 1],
     ['EX_ex_typ', 1],
     ['EX_ex_uniq', 1],
     ['EX_ex_unseries_d', 1],
     ['EX_ex_unseries_l', 1],
     ['EX_ex_verscre', 1],
     ['EX_ex_verscur', 1],
     ['EX_firstaxtime', 1],
     ['EX_hist', 1],
     ['EX_hospname', 1],
     ['EX_magstrength', 1],
     ['EX_mobile_loc', 1],
     ['EX_numcells', 1],
     ['EX_num_dcnk', 1],
     ['EX_op', 1],
     ['EX_patage', 1],
     ['EX_patian', 1],
     ['EX_patid', 1],
     ['EX_patname', 1],
     ['EX_patsex', 1],
     ['EX_patweight', 1],
     ['EX_protocolflag', 1],
     ['EX_refphy', 1],
     ['EX_reqnum', 1],
     ['EX_service_id', 1],
     ['EX_srctodet', 1],
     ['EX_srctoiso', 1],
     ['EX_study_status', 1],
     ['EX_study_uid', 1],
     ['EX_trauma', 1],
     ['EX_tubetyp', 1],
     ['EX_uniq_sys_id', 1],
     ['EX_zerocell', 1],

     # from ver11 pfile
     ['EX_dateofbirth', 1],
     ['EX_mwlstudyid', 1],
     ['EX_mwlstudyuid', 1],
     ['EX_padding', 3],
     ['EX_patidff', 1],
     ['EX_patnameff', 1],
     ['EX_refsopcuid', 1],
     ['EX_refsopiuid', 1],
     ['EX_reqnumff', 1],
    );
}

sub getseorder {
  return
    (
     ['SE_anref', 1],
     ['SE_echo1_alpha', 1],
     ['SE_echo1_beta', 1],
     ['SE_echo1_level', 1],
     ['SE_echo1_window', 1],
     ['SE_echo2_alpha', 1],
     ['SE_echo2_beta', 1],
     ['SE_echo2_level', 1],
     ['SE_echo2_window', 1],
     ['SE_echo3_alpha', 1],
     ['SE_echo3_beta', 1],
     ['SE_echo3_level', 1],
     ['SE_echo3_window', 1],
     ['SE_echo4_alpha', 1],
     ['SE_echo4_beta', 1],
     ['SE_echo4_level', 1],
     ['SE_echo4_window', 1],
     ['SE_echo5_alpha', 1],
     ['SE_echo5_beta', 1],
     ['SE_echo5_level', 1],
     ['SE_echo5_window', 1],
     ['SE_echo6_alpha', 1],
     ['SE_echo6_beta', 1],
     ['SE_echo6_level', 1],
     ['SE_echo6_window', 1],
     ['SE_echo7_alpha', 1],
     ['SE_echo7_beta', 1],
     ['SE_echo7_level', 1],
     ['SE_echo7_window', 1],
     ['SE_echo8_alpha', 1],
     ['SE_echo8_beta', 1],
     ['SE_echo8_level', 1],
     ['SE_echo8_window', 1],
     ['SE_end_loc', 1],
     ['SE_end_ras', 1],
     ['SE_entry', 1],
     ['SE_equipmnt_uid', 1],
     ['SE_landmark_uid', 1],
     ['SE_lmhor', 1],
     ['SE_pansysid', 1],
     ['SE_position', 1],
     ['SE_pr_sysid', 1],
     ['SE_prtcl', 1],
     ['SE_scan_type', 1],
     ['SE_se_actual_dt', 1],
     ['SE_se_alloc_key', 1],
     ['SE_se_checksum', 1],
     ['SE_se_complete', 1],
     ['SE_se_contrast', 1],
     ['SE_se_datetime', 1],
     ['SE_se_delta_cnt', 1],
     ['SE_se_desc', 1],
     ['SE_se_diskid', 1],
     ['SE_se_exno', 1],
     ['SE_se_imagect', 1],
     ['SE_se_images_d', 1],
     ['SE_se_images_l', 1],
     ['SE_se_lastmod', 1],
     ['SE_se_lndmrkcnt', 1],
     ['SE_se_nacq', 1],
     ['SE_se_no', 1],
     ['SE_se_numarch', 1],
     ['SE_se_numimages', 1],
     ['SE_se_numunimg', 1],
     ['SE_se_padding', 1],
     ['SE_se_pds_a', 1],
     ['SE_se_pds_c', 1],
     ['SE_se_pds_u', 1],
     ['SE_se_plane', 1],
     ['SE_se_pseq', 1],
     ['SE_series_uid', 1],
     ['SE_se_sortorder', 1],
     ['SE_se_source', 1],
     ['SE_se_suid', 1],
     ['SE_se_toarchcnt', 1],
     ['SE_se_toarchive_d', 1],
     ['SE_se_toarchive_l', 1],
     ['SE_se_typ', 1],
     ['SE_se_unimages_d', 1],
     ['SE_se_unimages_l', 1],
     ['SE_se_uniq', 1],
     ['SE_se_verscre', 1],
     ['SE_se_verscur', 1],
     ['SE_start_loc', 1],
     ['SE_start_ras', 1],
     ['SE_xbaseend', 1],
     ['SE_xbasest', 1],
     ['SE_xenhend', 1],
     ['SE_xenhst', 1],

     # from ver11 pfile
     ['SE_ApplName', 1],
     ['SE_ApplVer', 1],
     ['SE_asset_appl', 1],
     ['SE_assetcal_scnno', 1],
     ['SE_assetcal_serno', 1],
     ['SE_BWRT', 1],
     ['SE_content_qualifn', 1],
     ['SE_DumAcq', 1],
     ['SE_ExptTimePts', 1],
     ['SE_ExpType', 1],
     ['SE_GradientCoil', 1],
     ['SE_LateralOffset', 1],
     ['SE_PdgmStr', 1],
     ['SE_PdgmUID', 1],
     ['SE_perprocstdesc', 1],
     ['SE_perprocstid', 1],
     ['SE_purecal_scnno', 1],
     ['SE_purecal_serno', 1],
     ['SE_pure_cfg_params', 1],
     ['SE_refImgUID', 1],
     ['SE_refsopcuids', 1],
     ['SE_refsopiuids', 1],
     ['SE_reqprocstid', 1],
     ['SE_reqprocstid2', 1],
     ['SE_reqprocstid3', 1],
     ['SE_schacitdesc', 1],
     ['SE_schacitmea', 1],
     ['SE_schacitval', 1],
     ['SE_schprocstdesc', 1],
     ['SE_schprocstid', 1],
     ['SE_schprocstid2', 1],
     ['SE_schprocstid3', 1],
     ['SE_scic_a', 1],
     ['SE_scic_c', 1],
     ['SE_scic_s', 1],
     ['SE_se_subtype', 1],
     ['SE_short_padding', 33],
     ['SE_SwingAngle', 1],
     ['SE_table_entry', 1],
     ['SE_TrActive', 1],
     ['SE_TrRest', 1],
    );
}

sub getmrorder {
  return
    (
     ['MR_asoffsetx', 1],
     ['MR_asoffsety', 1],
     ['MR_asoffsetz', 1],
     ['MR_autoxmtfreq', 1],
     ['MR_autoxmtgain', 1],
     ['MR_brhc_A', 1],
     ['MR_brhc_R', 1],
     ['MR_brhc_S', 1],
     ['MR_cal_fldstr', 1],
     ['MR_cenfreq', 1],
     ['MR_cname', 1],
     ['MR_contig', 1],
     ['MR_contmode', 1],
     ['MR_contrastIV', 1],
     ['MR_contrastOral', 1],
     ['MR_cphase', 1],
     ['MR_cphasenum', 1],
     ['MR_ctr_A', 1],
     ['MR_ctr_R', 1],
     ['MR_ctr_S', 1],
     ['MR_ctyp', 1],
     ['MR_dbdt', 1],
     ['MR_dbdtper', 1],
     ['MR_dfov', 1],
     ['MR_dfov_rect', 1],
     ['MR_dim_X', 1],
     ['MR_dim_Y', 1],
     ['MR_dont_use_1', 1],
     ['MR_dont_use_2', 1],
     ['MR_dont_use_3', 1],
     ['MR_echonum', 1],
     ['MR_echo_trn_len', 1],
     ['MR_effechospace', 1],
     ['MR_estdbdtper', 1],
     ['MR_estdbdtts', 1],
     ['MR_flax', 1],
     ['MR_forimgrev', 1],
     ['MR_fphase', 1],
     ['MR_frac_echo', 1],
     ['MR_freq_dir', 1],
     ['MR_gpre', 1],
     ['MR_hrtrate', 1],
     ['MR_im_actual_dt', 1],
     ['MR_image_type', 1],
     ['MR_image_uid', 1],
     ['MR_im_alloc_key', 1],
     ['MR_im_archived', 1],
     ['MR_imatrix_X', 1],
     ['MR_imatrix_Y', 1],
     ['MR_im_checksum', 1],
     ['MR_im_complete', 1],
     ['MR_im_compress', 1],
     ['MR_im_datetime', 1],
     ['MR_im_diskid', 1],
     ['MR_im_exno', 1],
     ['MR_img_level', 1],
     ['MR_imgpcyc', 1],
     ['MR_imgrx', 1],
     ['MR_img_window', 1],
     ['MR_im_lastmod', 1],
     ['MR_im_no', 1],
     ['MR_imode', 1],
     ['MR_im_pds_a', 1],
     ['MR_im_pds_c', 1],
     ['MR_im_pds_u', 1],
     ['MR_im_scouttype', 1],
     ['MR_im_seno', 1],
     ['MR_im_suid', 1],
     ['MR_im_uniq', 1],
     ['MR_im_verscre', 1],
     ['MR_im_verscur', 1],
     ['MR_integrity', 1],
     ['MR_interleaves', 1],
     ['MR_intr_del', 1],
     ['MR_iopt', 1],
     ['MR_loc', 1],
     ['MR_loc_ras', 1],
     ['MR_mindat', 1],
     ['MR_monsar', 1],
     ['MR_mr_flip', 1],
     ['MR_mr_padding', 1],
     ['MR_neg_scanspacing', 1],
     ['MR_nex', 1],
     ['MR_norm_A', 1],
     ['MR_norm_R', 1],
     ['MR_norm_S', 1],
     ['MR_numecho', 1],
     ['MR_obplane', 1],
     ['MR_offsetfreq', 1],
     ['MR_pauseint', 1],
     ['MR_pausetime', 1],
     ['MR_pdid', 1],
     ['MR_pixsize_X', 1],
     ['MR_pixsize_Y', 1],
     ['MR_plane', 1],
     ['MR_prep_pulse', 1],
     ['MR_prescan_r1', 1],
     ['MR_prescan_r2', 1],
     ['MR_proj_alg', 1],
     ['MR_proj_name', 1],
     ['MR_pscopts', 1],
     ['MR_psd_datetime', 1],
     ['MR_psd_iname', 1],
     ['MR_psdname', 1],
     ['MR_pseq', 1],
     ['MR_pseqmode', 1],
     ['MR_ps_flag', 1],
     ['MR_ps_status', 1],
     ['MR_rawrunnum', 1],
     ['MR_rbpm', 1],
     ['MR_rcvgain1', 1],
     ['MR_rcvgain2', 1],
     ['MR_rcvrtype', 1],
     ['MR_ref_img', 1],
     ['MR_reptime', 1],
     ['MR_rtpoint', 1],
     ['MR_saravg', 1],
     ['MR_saravghead', 1],
     ['MR_sarpeak', 1],
     ['MR_satbits', 1],
     ['MR_satxloc1', 1],
     ['MR_satxloc2', 1],
     ['MR_satxthick', 1],
     ['MR_satyloc1', 1],
     ['MR_satyloc2', 1],
     ['MR_satythick', 1],
     ['MR_satzloc1', 1],
     ['MR_satzloc2', 1],
     ['MR_satzthick', 1],
     ['MR_scanactno', 1],
     ['MR_scanspacing', 1],
     ['MR_scic', 1],
     ['MR_screenformat', 1],
     ['MR_sctime', 1],
     ['MR_serrx', 1],
     ['MR_slocfov', 1],
     ['MR_slop_float_1', 1],
     ['MR_slop_float_2', 1],
     ['MR_slop_float_3', 1],
     ['MR_slop_float_4', 1],
     ['MR_slop_float_5', 1],
     ['MR_slop_int_1', 1],
     ['MR_slop_int_2', 1],
     ['MR_slop_int_3', 1],
     ['MR_slop_int_4', 1],
     ['MR_slop_int_5', 1],
     ['MR_slop_int_6', 1],
     ['MR_slop_int_7', 1],
     ['MR_slop_int_8', 1],
     ['MR_slop_int_9', 1],
     ['MR_slop_str_1', 1],
     ['MR_slop_str_2', 1],
     ['MR_slquant', 1],
     ['MR_slthick', 1],
     ['MR_sop_uid', 1],
     ['MR_sum_img', 1],
     ['MR_supp_tech', 1],
     ['MR_surfcext', 1],
     ['MR_surfctyp', 1],
     ['MR_swappf', 1],
     ['MR_tbldlta', 1],
     ['MR_tdel', 1],
     ['MR_te', 1],
     ['MR_te2', 1],
     ['MR_thk_disclmr', 1],
     ['MR_thresh_max1', 1],
     ['MR_thresh_max2', 1],
     ['MR_thresh_min1', 1],
     ['MR_thresh_min2', 1],
     ['MR_ti', 1],
     ['MR_tlhc_A', 1],
     ['MR_tlhc_R', 1],
     ['MR_tlhc_S', 1],
     ['MR_tr', 1],
     ['MR_trgwindow', 1],
     ['MR_trhc_A', 1],
     ['MR_trhc_R', 1],
     ['MR_trhc_S', 1],
     ['MR_unoriginal', 1],
     ['MR_user0', 1],
     ['MR_user1', 1],
     ['MR_user10', 1],
     ['MR_user11', 1],
     ['MR_user12', 1],
     ['MR_user13', 1],
     ['MR_user14', 1],
     ['MR_user15', 1],
     ['MR_user16', 1],
     ['MR_user17', 1],
     ['MR_user18', 1],
     ['MR_user19', 1],
     ['MR_user2', 1],
     ['MR_user20', 1],
     ['MR_user21', 1],
     ['MR_user22', 1],
     ['MR_user23', 1],
     ['MR_user23n', 1],
     ['MR_user24', 1],
     ['MR_user24n', 1],
     ['MR_user25', 1],
     ['MR_user26', 1],
     ['MR_user27', 1],
     ['MR_user28', 1],
     ['MR_user29', 1],
     ['MR_user3', 1],
     ['MR_user30', 1],
     ['MR_user31', 1],
     ['MR_user32', 1],
     ['MR_user33', 1],
     ['MR_user34', 1],
     ['MR_user35', 1],
     ['MR_user36', 1],
     ['MR_user37', 1],
     ['MR_user38', 1],
     ['MR_user39', 1],
     ['MR_user4', 1],
     ['MR_user40', 1],
     ['MR_user41', 1],
     ['MR_user42', 1],
     ['MR_user43', 1],
     ['MR_user44', 1],
     ['MR_user45', 1],
     ['MR_user46', 1],
     ['MR_user47', 1],
     ['MR_user48', 1],
     ['MR_user5', 1],
     ['MR_user6', 1],
     ['MR_user7', 1],
     ['MR_user8', 1],
     ['MR_user9', 1],
     ['MR_user_bitmap', 1],
     ['MR_user_fill_mapLSW', 1],
     ['MR_user_fill_mapMSW', 1],
     ['MR_user_usage_tag', 1],
     ['MR_var_echo', 1],
     ['MR_vas_collapse', 1],
     ['MR_vasflags', 1],
     ['MR_vas_mode', 1],
     ['MR_vbw', 1],
     ['MR_venc', 1],
     ['MR_vencscale', 1],
     ['MR_viewsperseg', 1],
     ['MR_x_axis_rot', 1],
     ['MR_xmtfreq', 1],
     ['MR_xmtgain', 1],
     ['MR_y_axis_rot', 1],
     ['MR_z_axis_rot', 1],

     # from ver11 pfile
     ['MR_astcalseriesuid', 1],
     ['MR_averages', 1],
     ['MR_b_value', 1],
     ['MR_concat_sat', 1],
     ['MR_dBdtMode', 1],
     ['MR_delAcq', 1],
     ['MR_dfax', 1],
     ['MR_filter_mode', 1],
     ['MR_fps', 1],
     ['MR_GEcname', 1],
     ['MR_govBody', 1],
     ['MR_hole', 1],
     ['MR_ihbspti', 1],
     ['MR_ihfcineim', 1],
     ['MR_ihfcinent', 1],
     ['MR_ihtagfa', 1],
     ['MR_ihtagging', 1],
     ['MR_ihtagor', 1],
     ['MR_ihtagspc', 1],
     ['MR_img_hdr_padding', 1],
     ['MR_iopt2', 1],
     ['MR_iopt3', 1],
     ['MR_locsperslab', 1],
     ['MR_no_shimvol', 1],
     ['MR_not_used_1', 1],
     ['MR_num_seg', 1],
     ['MR_numslabs', 1],
     ['MR_oprtarr', 1],
     ['MR_overlaps', 1],
     ['MR_PhaseAsset', 1],
     ['MR_proj_ang', 1],
     ['MR_purecalseriesuid', 1],
     ['MR_RegressorVal', 1],
     ['MR_rtia_timer', 1],
     ['MR_sarDefinition', 1],
     ['MR_sarMode', 1],
     ['MR_sarValues', 4],
     ['MR_shim_ctr_A', 2],
     ['MR_shim_ctr_R', 2],
     ['MR_shim_ctr_S', 2],
     ['MR_shim_fov', 2],
     ['MR_shim_vol_type', 1],
     ['MR_SliceAsset', 1],
     ['MR_station_index', 1],
     ['MR_station_total', 1],
     ['MR_sys_type', 1],
     ['MR_unused_monsar', 1],
     ['MR_usedCoilData', 1],
     ['MR_xml_psc_shm_vol', 1],
    );
}

