<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
  xmlns="http://www.biac.duke.edu/bxh"
  xmlns:bxh="http://www.biac.duke.edu/bxh"
  xmlns:xcede="http://nbirn.net/Resources/Users/Applications/xcede/"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  exclude-result-prefixes="xcede"
  version="1.0">

  <!-- This style sheet converts XCEDE series-level XML files to a BIAC XML Header -->

  <xsl:output
    method="xml"
    indent="yes"
    omit-xml-declaration="no"
    />

  <xsl:template match="/">
    <bxh>
      <xsl:attribute name="version">1.0</xsl:attribute>
      <xsl:for-each select="xcede:serieslevel">
        <xsl:call-template name="dodatarec"/>
        <xsl:call-template name="doacquisitiondata"/>
        <xsl:call-template name="dosubject"/>
        <xsl:call-template name="dohistory"/>
      </xsl:for-each>
    </bxh>
  </xsl:template>

  <xsl:template name="convertNSattributes">
    <xsl:choose>
      <xsl:when test="namespace-uri()='http://nbirn.net/Resources/Users/Applications/xcede/'">
        <xsl:attribute name="{local-name()}" namespace="http://www.biac.duke.edu/bxh">
	  <xsl:copy/>
        </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="{local-name()}">
	  <xsl:copy/>
        </xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="convertNSaux">
    <xsl:choose>
      <!-- element -->
      <xsl:when test="self::*">
        <xsl:call-template name="convertNS"/>
      </xsl:when>
      <!-- attribute -->
      <xsl:when test="count(.|../@*)=count(../@*)">
        <xsl:call-template name="convertNSattributes"/>
      </xsl:when>
      <!-- everything else -->
      <xsl:otherwise>
        <xsl:copy/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="convertNS">
    <xsl:choose>
      <xsl:when test="namespace-uri()='http://nbirn.net/Resources/Users/Applications/xcede/'">
        <xsl:element name="{local-name()}" namespace="http://www.biac.duke.edu/bxh">
          <xsl:for-each select="@*|*|text()">
            <xsl:call-template name="convertNSaux"/>
          </xsl:for-each>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:for-each select="@*|*|text()">
            <xsl:call-template name="convertNSaux"/>
          </xsl:for-each>
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--
       /bxh/datarec
    -->
  <xsl:template name="dodatarec">
    <xsl:for-each select="xcede:datarec">
      <xsl:call-template name="createdatarec"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="createdatarec">
    <datarec>
      <xsl:if test="@type">
        <xsl:attribute name="type">
          <xsl:value-of select="@type"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@subtype">
        <xsl:attribute name="subtype">
          <xsl:value-of select="@subtype"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="xcede:rasorigin">
        <xsl:element name="rasorigin">
          <xsl:value-of select="xcede:rasorigin"/>
        </xsl:element>
      </xsl:if>

      <xsl:for-each select="xcede:dimension">
        <dimension>
          <xsl:attribute name="type">
            <xsl:value-of select="@type"/>
          </xsl:attribute>
          <xsl:if test="@outputselect">
            <xsl:attribute name="outputselect">
              <xsl:value-of select="@outputselect"/>
            </xsl:attribute>
          </xsl:if>
	  <xsl:if test="xcede:units">
            <units><xsl:value-of select="xcede:units"/></units>
	  </xsl:if>
	  <xsl:if test="xcede:size">
            <size><xsl:value-of select="xcede:size"/></size>
	  </xsl:if>
	  <xsl:if test="xcede:origin">
            <origin><xsl:value-of select="xcede:origin"/></origin>
	  </xsl:if>
	  <xsl:if test="xcede:gap">
            <gap><xsl:value-of select="xcede:gap"/></gap>
	  </xsl:if>
	  <xsl:if test="xcede:spacing">
            <spacing><xsl:value-of select="xcede:spacing"/></spacing>
	  </xsl:if>
	  <xsl:for-each select="xcede:datapoints">
	    <xsl:call-template name="convertNS" select="xcede:datapoints"/>
	  </xsl:for-each>
	  <xsl:for-each select="xcede:direction">
	    <xsl:call-template name="convertNS" select="xcede:direction"/>
	  </xsl:for-each>
	  <xsl:for-each select="xcede:measurementframe">
	    <xsl:call-template name="convertNS" select="xcede:measurementframe"/>
	  </xsl:for-each>
        </dimension>
      </xsl:for-each>
      <xsl:if test="xcede:compression">
        <compression><xsl:value-of select="xcede:compression"/></compression>
      </xsl:if>
      <xsl:if test="xcede:byteorder">
        <byteorder><xsl:value-of select="xcede:byteorder"/></byteorder>
      </xsl:if>
      <elementtype><xsl:value-of select="xcede:elementtype"/></elementtype>
      <xsl:variable name="filenames" select="xcede:filename"/>
      <xsl:variable name="fileoffsets" select="xcede:fileoffset"/>
      <xsl:variable name="filerecordsizes" select="xcede:filerecordsize"/>
      <xsl:for-each select="xcede:filename">
	<xsl:variable name="filenum" select="position()"/>
        <filename><xsl:value-of select="."/></filename>
        <!-- grab fileoffset with same rank as current filename -->
        <xsl:if test="$fileoffsets">
          <fileoffset>
            <xsl:value-of select="$fileoffsets[$filenum]"/>
          </fileoffset>
        </xsl:if>
        <!-- grab fileoffset with same rank as current filename -->
        <xsl:if test="$filerecordsizes">
          <filerecordsize>
            <xsl:value-of select="$filerecordsizes[$filenum]"/>
          </filerecordsize>
        </xsl:if>
      </xsl:for-each>
    </datarec>
  </xsl:template>

  <!--
      /bxh/subject
    -->
  <xsl:template name="dosubject">
    <subject>
      <xsl:for-each select="xcede:visit/xcede:subjectVar">
        <age>
          <xsl:choose>
            <xsl:when test="xcede:age/@agetype = 'postnatal' and xcede:age/@units = 'years'">
              <xsl:value-of select="xcede:age"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:message terminate='yes'>Age types other than "postnatal" and units other than "years" are not supported by this version of the converter.</xsl:message>
            </xsl:otherwise>
          </xsl:choose>
        </age>
      </xsl:for-each>
      <xsl:for-each select="xcede:subject">
        <name><xsl:value-of select="xcede:name"/></name>
        <sex>
          <xsl:choose>
            <xsl:when test="xcede:sex = 'male'">M</xsl:when>
            <xsl:when test="xcede:sex = 'female'">F</xsl:when>
            <xsl:otherwise>O</xsl:otherwise>
          </xsl:choose>
        </sex>
      </xsl:for-each>
    </subject>
  </xsl:template>

  <!--
      /bxh/acquisitiondata
    -->
  <xsl:template name="doacquisitiondata">
    <acquisitiondata>
      <scanner><xsl:value-of select="xcede:scanner/xcede:model"/></scanner>
      <xsl:choose>
        <xsl:when test="contains(xcede:acqProtocol/xcede:name, ' (') and contains(xcede:acqProtocol/xcede:name, ')')">
          <psdname><xsl:value-of select="substring-before(xcede:acqProtocol/xcede:name, ' (')"/></psdname>
          <psdinternalname><xsl:value-of select="substring-before(substring-after(xcede:acqProtocol/xcede:name, '('), ')')"/></psdinternalname>
        </xsl:when>
        <xsl:otherwise>
          <psdname><xsl:value-of select="xcede:acqProtocol/xcede:name"/></psdname>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:for-each select="xcede:acqProtocol/xcede:acqParam">
        <xsl:choose>
          <xsl:when test="@name = 'examnumber'">
            <examnumber><xsl:value-of select="."/></examnumber>
          </xsl:when>
          <xsl:when test="@name = 'studyid'">
            <studyid><xsl:value-of select="."/></studyid>
          </xsl:when>
          <xsl:when test="@name = 'seriesnumber'">
            <seriesnumber><xsl:value-of select="."/></seriesnumber>
          </xsl:when>
          <xsl:when test="@name = 'runnumber'">
            <runnumber><xsl:value-of select="."/></runnumber>
          </xsl:when>
          <xsl:when test="@name = 'scanningsequence'">
            <scanningsequence><xsl:value-of select="."/></scanningsequence>
          </xsl:when>
          <xsl:when test="@name = 'sequencevariant'">
            <sequencevariant><xsl:value-of select="."/></sequencevariant>
          </xsl:when>
          <xsl:when test="@name = 'magneticfield'">
            <magneticfield><xsl:value-of select="."/></magneticfield>
          </xsl:when>
          <xsl:when test="@name = 'description'">
            <description><xsl:value-of select="."/></description>
          </xsl:when>
          <xsl:when test="@name = 'scandate'">
            <scandate><xsl:value-of select="."/></scandate>
          </xsl:when>
          <xsl:when test="@name = 'scantime'">
            <scantime><xsl:value-of select="."/></scantime>
          </xsl:when>
          <xsl:when test="@name = 'tr'">
            <tr><xsl:value-of select="."/></tr>
          </xsl:when>
          <xsl:when test="@name = 'te'">
            <te><xsl:value-of select="."/></te>
          </xsl:when>
          <xsl:when test="@name = 'echospacing'">
            <echospacing><xsl:value-of select="."/></echospacing>
          </xsl:when>
          <xsl:when test="@name = 'nechos'">
            <nechos><xsl:value-of select="."/></nechos>
          </xsl:when>
          <xsl:when test="@name = 'echonumber'">
            <echonumber><xsl:value-of select="."/></echonumber>
          </xsl:when>
          <xsl:when test="@name = 'nshots'">
            <nshots><xsl:value-of select="."/></nshots>
          </xsl:when>
          <xsl:when test="@name = 'sensefactor'">
            <sensefactor><xsl:value-of select="."/></sensefactor>
          </xsl:when>
          <xsl:when test="@name = 'operator'">
            <operator><xsl:value-of select="."/></operator>
          </xsl:when>
          <xsl:when test="@name = 'flipangle'">
            <flipangle><xsl:value-of select="."/></flipangle>
          </xsl:when>
          <xsl:when test="@name = 'prescribedslicespacing'">
            <prescribedslicespacing><xsl:value-of select="."/></prescribedslicespacing>
          </xsl:when>
          <xsl:when test="@name = 'frequencydirection'">
            <frequencydirection><xsl:value-of select="."/></frequencydirection>
          </xsl:when>
          <xsl:when test="@name = 'acquisitionmatrix'">
            <acquisitionmatrix><xsl:value-of select="."/></acquisitionmatrix>
          </xsl:when>
          <xsl:when test="@name = 'bandwidth'">
            <bandwidth><xsl:value-of select="."/></bandwidth>
          </xsl:when>
          <xsl:when test="@name = 'pixelbandwidth'">
            <pixelbandwidth><xsl:value-of select="."/></pixelbandwidth>
          </xsl:when>
          <xsl:when test="@name = 'receivecoilname'">
            <receivecoilname><xsl:value-of select="."/></receivecoilname>
          </xsl:when>
          <xsl:when test="@name = 'transmitcoilname'">
            <transmitcoilname><xsl:value-of select="."/></transmitcoilname>
          </xsl:when>
          <xsl:when test="@name = 'institution'">
            <institution><xsl:value-of select="."/></institution>
          </xsl:when>
          <xsl:when test="@name = 'institutionaddress'">
            <institutionaddress><xsl:value-of select="."/></institutionaddress>
          </xsl:when>
          <xsl:when test="@name = 'institutionaldepartmentname'">
            <institutionaldepartmentname><xsl:value-of select="."/></institutionaldepartmentname>
          </xsl:when>
          <xsl:when test="@name = 'examdescription'">
            <examdescription><xsl:value-of select="."/></examdescription>
          </xsl:when>
          <xsl:when test="@name = 'scanner'">
            <scanner><xsl:value-of select="."/></scanner>
          </xsl:when>
          <xsl:when test="@name = 'scannermanufacturer'">
            <scannermanufacturer><xsl:value-of select="."/></scannermanufacturer>
          </xsl:when>
          <xsl:when test="@name = 'scannermodelname'">
            <scannermodelname><xsl:value-of select="."/></scannermodelname>
          </xsl:when>
          <xsl:when test="@name = 'fieldofview'">
            <fieldofview><xsl:value-of select="."/></fieldofview>
          </xsl:when>
          <xsl:when test="@name = 'ti'">
            <ti><xsl:value-of select="."/></ti>
          </xsl:when>
          <xsl:when test="@name = 'psdname'">
            <psdname><xsl:value-of select="."/></psdname>
          </xsl:when>
          <xsl:when test="@name = 'psdinternalname'">
            <psdinternalname><xsl:value-of select="."/></psdinternalname>
          </xsl:when>
          <xsl:when test="@name = 'psddate'">
            <psddate><xsl:value-of select="."/></psddate>
          </xsl:when>
          <xsl:when test="@name = 'psdtime'">
            <psdtime><xsl:value-of select="."/></psdtime>
          </xsl:when>
          <xsl:when test="@name = 'protocolname'">
            <protocolname><xsl:value-of select="."/></protocolname>
          </xsl:when>
          <xsl:when test="@name = 'sliceorder'">
            <sliceorder><xsl:value-of select="."/></sliceorder>
          </xsl:when>
          <xsl:when test="@name = 'bvalues'">
            <bvalues><xsl:value-of select="."/></bvalues>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="acqParam">
              <xsl:for-each select="@*|node()">
                <xsl:copy-of select=".">
                </xsl:copy-of>
              </xsl:for-each>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </acquisitiondata>
  </xsl:template>

  <!--
       /bxh/history
    -->
  <xsl:template name="dohistory">
    <history>
      <xsl:for-each select="xcede:provenance/xcede:processStep">
        <entry>
          <date><xsl:value-of select="xcede:timeStamp"/></date>
          <description>
            <processStep>
              <programName><xsl:value-of select="xcede:programName"/></programName>
              <programArgument><xsl:value-of select="xcede:programArgument"/></programArgument>
              <version><xsl:value-of select="xcede:version"/></version>
              <timeStamp><xsl:value-of select="xcede:timeStamp"/></timeStamp>
              <cvs><xsl:value-of select="xcede:cvs"/></cvs>
              <user><xsl:value-of select="xcede:user"/></user>
              <machine><xsl:value-of select="xcede:machine"/></machine>
              <platform><xsl:value-of select="xcede:platform"/></platform>
              <platformVersion><xsl:value-of select="xcede:platormVersion"/></platformVersion>
            </processStep>
          </description>
        </entry>
      </xsl:for-each>
    </history>
  </xsl:template>

</xsl:stylesheet>


<!--
  $Log: In-line log eliminated on transition to SVN; use svn log instead. $
  Revision 1.1  2008/03/07 18:21:59  gadde
  Add preliminary XCEDE 2 support

  Revision 1.10  2008/01/22 18:02:32  gadde
  Add protocolname.

  Revision 1.9  2007/02/27 18:04:38  gadde
  Add more acquisition data parameters.

  Revision 1.8  2007/02/21 21:49:15  gadde
  Make sure all acquisitiondata and acqParam elements are translated BXH->XCEDE and vice-versa

  Revision 1.7  2007/02/01 15:39:22  gadde
  Add compression field

  Revision 1.6  2006/02/09 21:40:36  gadde
  Write bxh rasorigin field.

  Revision 1.5  2006/01/03 17:14:33  gadde
  Add CVS log.

  -->
