static const char rcsid[] = "$Id: bxh2analyze.c,v 1.87 2008-04-16 17:47:39 gadde Exp $";

/*
 * bxh2analyze.c --
 * 
 * Creates an Analyze 7.5/SPM file from a BXH file 
 */

#include "bxh_utils.h"
#include "bxh_datarec.h"
#include "opts.h"

#include "bxh_niftilib.h"

#include <string.h>

#ifndef XMLH_VERSIONSTR
#define XMLH_VERSIONSTR "(no version specified)"
#endif

int
main(int argc, char *argv[])
{
    int numoptargs;
    const int numopts = 24;
    struct bxh2analyze_opts globalopts;
    memset(&globalopts, '\0', sizeof(globalopts));

    {
	opt_data myOpts[24] = { 
	    { 0x0, OPT_VAL_NONE, NULL, 0, "",
	      "Usage:\n"
	      "  bxh2analyze [opts] input.bxh outputprefix\n\n"
	      "  xcede2analyze [opts] input.bxh outputprefix\n\n"
	      "Both programs create Analyze 7.5, SPM, or NIfTI-1 images from "
	      "BXH- or XCEDE- wrapped images (both programs support both formats).  "
	      "NOTE: XCEDE is only supported if this program was compiled with XSLT "
	      "support "
#ifdef HAVE_LIBXSLT
	      "(which in this case, it has; congratulations!)"
#else
	      "(which in this case, it has not; sorry!)"
#endif
	      "." },
	    { 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.version, 1, "version",
	      "Print version string and exit." },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.overwrite, 1, "overwrite",
	      "Overwrite files if they exist." },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.bxh, 1, "bxh",
	      "This option forces output XML file to be BXH "
	      "(this option is ignored by [and is the default behavior of] "
	      "bxh2analyze)" },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.xcede, 1, "xcede",
	      "This option forces output XML file to be XCEDE "
	      "(this option is ignored by [and is the default behavior of] "
	      "xcede2analyze)" },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.xcede, 1, "xcede2",
	      "This option forces output XML file to be XCEDE2." },
	    { OPT_FLAGS_STD, OPT_VAL_BOOL, &globalopts.dontWriteBxh, 1, "b",
	      "This option suppresses the writing of a BXH/XCEDE header "
	      "for every Analyze header and image file. " },
	    { OPT_FLAGS_STD, OPT_VAL_BOOL, &globalopts.dontWriteMat, 1, "s",
	      "This option suppresses the writing of an SPM .mat file "
	      "for every Analyze header and image file. " },
	    { OPT_FLAGS_STD, OPT_VAL_BOOL, &globalopts.dontWriteImg, 1, "i",
	      "This option suppresses the writing of the image (.img) files."
	    },
	    { OPT_FLAGS_STD, OPT_VAL_BOOL, &globalopts.dontWriteHdr, 1, "h",
	      "This option suppresses the writing of the Analyze header "
	      "(.hdr) files."
	    },
	    { OPT_FLAGS_STD, OPT_VAL_BOOL, &globalopts.splitBxh, 1, "B",
	      "If writing BXH/XCEDE headers, instead of writing one header, "
	      "this option forces the writing of several BXH/XCEDE headers, "
	      "one per Analyze header and image file. " },
	    { OPT_FLAGS_STD, OPT_VAL_BOOL, &globalopts.dontSplitVols, 1, "v",
	      "This option suppresses the splitting a time series into "
	      "separate volumes.  If not specified, then each "
	      "image file will contain the data for one volume.  If specified, "
	      "then each time series will be output as one large file." },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.niftihdr, 1, "niftihdr",
	      "Generate NIfTI-1 format header (default is to attempt to generate a "
	      "maximally compatible header)."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.nii, 1, "nii",
	      "Use NIfTI-1 one-file convention (header and data in same file).  "
	      "Output image files will have the .nii extension.  "
	      "This option automatically turns on --niftihdr and -v."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.niigz, 1, "niigz",
	      "Same as (and overrides) --nii, but the output will be "
	      "compressed and will have the .nii.gz extension.  "
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.spmhdr, 1, "spmhdr",
	      "Assume header will only be read by SPM, using SPM-specific "
	      "values when possible (default is to attempt to generate a "
	      "maximally compatible header)."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.analyzehdr, 1, "analyzehdr",
	      "Generate \"pure\" Analyze 7.5 header, whatever that means.  "
	      "(default is to attempt to generate a maximally compatible header)."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.preferanalyzetypes, 1, "preferanalyzetypes",
	      "Prefer the use of only Analyze 7.5 pixel types if we are "
	      "writing SPM or NIfTI headers; non-Analyze 7.5 pixel types will be "
	      "used if overflow/underflow is detected.  This option requires either "
	      "the --spmhdr or --niftihdr options."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.analyzetypes, 1, "analyzetypes",
	      "Force the use of only Analyze 7.5 pixel types, even if we are "
	      "writing SPM or NIfTI headers.  If necessary, this will cause "
	      "conversion to a data type with higher range."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.nosform, 1, "nosform",
	      "For NIfTI headers, do not write orientation information into the "
	      "sform fields.  Default is to write both qform and sform."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_STR, &globalopts.spatialunits, 1, "spatialunits",
	      "Force spatial units to a given value.  Must be 'm', 'mm', or 'um'.  "
	      "Output metadata will not be converted if this does not correctly "
	      "represent the input metadata."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_STR, &globalopts.temporalunits, 1, "temporalunits",
	      "Force temporal units to a given value.  Must be 's', 'ms', or 'us'.  "
	      "Output metadata will not be converted if this does not correctly "
	      "represent the input metadata."
	    },
	    { OPT_FLAGS_FULL, OPT_VAL_BOOL, &globalopts.zeroorigin, 1, "zeroorigin",
	      "Force the origin fields in the output images to be [0,0,0] "
	      "(this is useful if your analysis software uses 0,0,0 to mean "
	      "'unspecified', and you don't want to specify the origin)."
	    }
	};

	numoptargs = opt_parse(argc, argv, numopts, &myOpts[0], 0);
	argc -= numoptargs;

	if (globalopts.version) {
	    fprintf(stdout, "%s\n", XMLH_VERSIONSTR);
	    exit(0);
	}

	if (argc != 3) {
	    opt_usage(numopts, &myOpts[0]);
	    return -1;
	}
    }

    {
	size_t arg0len = 0;
	size_t testlen = 0;
	char * teststr = "xcede2analyze";
	char * progfile = NULL;
#ifdef WIN32
	if ((progfile = strrchr(argv[0], '\\')) != NULL) {
	  progfile++;
	} else if ((progfile = strrchr(argv[0], ':')) != NULL) {
	  progfile++;
	} else {
	  progfile = argv[0];
	}
#define EXE ".exe"
#else
	if ((progfile = strrchr(argv[0], '/')) != NULL) {
	  progfile++;
	} else {
	  progfile = argv[0];
	}
#define EXE ""
#endif
	arg0len = strlen(progfile) - strlen(EXE);
	testlen = strlen(teststr);
	if (arg0len >= testlen &&
	    strncmp(&(progfile[arg0len-testlen]), teststr, testlen) == 0) {
#ifdef HAVE_LIBXSLT
	    bxh_doXCEDE = 1;
#else
	    fprintf(stderr, "Sorry, this program was not compiled with XSLT support, so XCEDE support is not available!\n");
	    return -1;
#endif /* #ifdef HAVE_LIBXSLT #else */
	    /* opt_xcede is ignored for xcede2analyze */
	}
    }

    return convertBXHToAnalyze(argv[1], argv[2], NULL, NULL, &globalopts);
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.86  2007/12/10 16:37:37  gadde
 * Move Analyze/NIFTI generation to bxh_niftilib.c
 *
 * Revision 1.85  2007/12/05 18:28:42  gadde
 * Allow other programs (like bxh_epochavg) to use this code to write
 * out NIFTI files along with BXH or XCEDE files.
 *
 * Revision 1.84  2007/10/08 15:53:02  gadde
 * Fix NIFTI origin values.
 *
 * Revision 1.83  2007/08/29 20:19:24  gadde
 * Deal better with return value of gzwrite.
 *
 * Revision 1.82  2007/08/29 20:12:21  gadde
 * Add .nii.gz output support.
 *
 * Revision 1.81  2007/07/19 19:26:25  gadde
 * Fix issue where non-time 4th (and higher) dimensions were resulting
 * in a 4th dimension size of 0 for -v (4-D output).
 *
 * Revision 1.80  2007/02/07 22:21:21  gadde
 * Fix last fix.
 *
 * Revision 1.79  2007/02/07 22:19:48  gadde
 * Fix magic number for single-file NIfTI-1.
 *
 * Revision 1.78  2007/02/05 20:46:55  gadde
 * fix for non-XSLT installations
 *
 * Revision 1.77  2007/01/26 19:10:12  gadde
 * Make sure data in .nii files starts at 352 (not 348!).
 *
 * Revision 1.76  2007/01/25 18:14:28  gadde
 * Update help.
 *
 * Revision 1.75  2007/01/25 18:13:45  gadde
 * Add --nii option.
 *
 * Revision 1.74  2007/01/11 20:17:03  gadde
 * Add some xcede programs
 *
 * Revision 1.73  2006/11/01 22:12:45  gadde
 * Add --preferanalyzetypes option.
 *
 * Revision 1.72  2006/11/01 19:15:38  gadde
 * Add --zeroorigin option.
 *
 * Revision 1.71  2006/08/07 19:46:02  gadde
 * For NIFTI, don't change input time units to seconds automatically.
 *
 * Revision 1.70  2006/08/07 17:36:00  gadde
 * update qform/sform calculation.
 *
 * Revision 1.69  2006/08/01 20:44:27  gadde
 * Add new options --spatialunits and --temporalunits.
 *
 * Revision 1.68  2006/08/01 16:22:24  gadde
 * Fix srow order
 *
 * Revision 1.67  2006/07/14 14:01:15  gadde
 * Correct calculation of slice duration.
 *
 * Revision 1.66  2006/05/18 22:30:08  gadde
 * Add option to turn off population of sform.
 *
 * Revision 1.65  2006/04/12 18:00:57  gadde
 * Add overwrite option.
 *
 * Revision 1.64  2006/04/07 14:46:59  gadde
 * Make sure relative pathnames are written correctly in .bxh files.
 *
 * Revision 1.63  2006/01/03 22:33:27  gadde
 * Don't erase pixdim4 for 3-D images.
 *
 * Revision 1.62  2005/12/02 20:40:06  gadde
 * Don't bomb if 't' dimension units are missing (--niftihdr).
 *
 * Revision 1.61  2005/09/20 18:37:54  gadde
 * Updates to versioning, help and documentation, and dependency checking
 *
 * Revision 1.60  2005/09/19 16:31:55  gadde
 * Documentation and help message updates.
 *
 * Revision 1.59  2005/09/15 14:34:45  gadde
 * Add history entry and reset frags for each split BXH file.
 *
 * Revision 1.58  2005/09/14 14:49:28  gadde
 * Type conversion updates to fix win32 warnings
 *
 * Revision 1.57  2005/08/12 18:29:13  gadde
 * Don't use dimension units field unless it's non-NULL.
 *
 * Revision 1.56  2005/08/11 18:55:59  gadde
 * Add pixdim[4] for t-dimension spacing.
 *
 * Revision 1.55  2005/04/28 16:33:42  gadde
 * Add option to force only strict Analyze pixel types.
 *
 * Revision 1.54  2005/04/26 18:40:16  gadde
 * Update for new version of NIfTI library and also add orientation info
 * to sform.
 *
 * Revision 1.53  2005/04/19 15:30:47  gadde
 * Update warning message condition.
 *
 * Revision 1.52  2005/04/08 16:16:39  gadde
 * Don't fix elemtype if we don't need to.
 *
 * Revision 1.51  2004/11/12 14:50:52  gadde
 * Don't exit after warning.
 *
 * Revision 1.50  2004/11/12 14:45:16  gadde
 * Warn if not writing image data and machine byte order is different than
 * BXH file byte order.
 *
 * Revision 1.49  2004/08/19 22:00:30  gadde
 * Fix bug that occurs with -v and only three dimensions in the input.
 *
 * Revision 1.48  2004/08/16 13:17:03  gadde
 * Continue fix of last commit.
 *
 * Revision 1.47  2004/08/16 13:14:45  gadde
 * Fix last commit.
 *
 * Revision 1.46  2004/08/16 13:12:39  gadde
 * Fix filenames in BXH file too, if -v is specified.
 *
 * Revision 1.45  2004/08/16 13:11:01  gadde
 * Fix last commit.
 *
 * Revision 1.44  2004/08/16 13:09:12  gadde
 * Don't use numeric suffix on filenames if -v is specified.
 *
 * Revision 1.43  2004/08/06 15:27:33  gadde
 * Change default from NIfTI to "an attempt to be maximally compatible".
 *
 * Revision 1.42  2004/06/18 15:21:51  gadde
 * Standardize frag creation (redux)
 *
 * Revision 1.41  2004/06/18 14:09:30  gadde
 * Standardize frag creation
 *
 * Revision 1.40  2004/06/15 16:16:11  gadde
 * Several -Wall fixes and addition of bxh_datarec_addfrag()
 *
 * Revision 1.39  2004/04/14 16:39:03  gadde
 * Remove duplicate #define.
 *
 * Revision 1.38  2004/04/07 19:03:49  gadde
 * Add commented out diagnostic.
 *
 * Revision 1.37  2004/04/07 17:28:30  gadde
 * *** empty log message ***
 *
 * Revision 1.36  2004/04/07 16:31:33  gadde
 * Add (default) NIfTI-1 support.
 *
 * Revision 1.33  2004/03/19 15:13:31  gadde
 * Major changes in datarec support, include a new 'prepare' stage
 * that initiates filtering, permutation.
 * bxh_datarec_readData has been changed to bxh_datarec_readRawData
 * to reflect this.
 * Added some fMRI QA measures.
 *
 * Revision 1.32  2004/02/23 19:23:54  gadde
 * Update messages.
 *
 * Revision 1.31  2004/02/23 19:22:31  gadde
 * Don't force XML file to end in .bxh.
 *
 * Revision 1.30  2003/09/26 18:49:56  gadde
 * Offer more options to suppress particular output files.
 *
 * Revision 1.29  2003/09/24 16:28:00  gadde
 * Fix matrix multiplication error.
 *
 * Revision 1.28  2003/09/22 15:55:11  gadde
 * Check to see if output .img and .mat files exist too.
 *
 * Revision 1.27  2003/08/25 18:32:26  gadde
 * Make output frag filenames relative.
 *
 * Revision 1.26  2003/08/19 16:43:44  gadde
 * Fix buffer overflow.
 *
 * Revision 1.25  2003/08/18 19:54:29  gadde
 * Fix comment.
 *
 * Revision 1.24  2003/08/12 21:36:40  gadde
 * Fix overflow detection.
 *
 * Revision 1.23  2003/08/12 20:54:00  gadde
 * Fix integer overflow.
 *
 * Revision 1.22  2003/08/12 20:41:22  gadde
 * SPM extensions.
 * Push XYZT data permutation to datarec_* functions.
 *
 * Revision 1.21  2003/08/08 19:28:22  gadde
 * Fix declaration.
 *
 * Revision 1.20  2003/08/08 19:26:34  gadde
 * Found some real documentation for the Analyze orient field.
 *
 * Revision 1.19  2003/08/08 18:08:14  gadde
 * Fix some SPM .mat file issues.
 * Permute data if needed to get it into x,y,z,t order.
 *
 * Revision 1.18  2003/08/07 21:25:28  gadde
 * Swap row/column (because MatFileWrite does it too!)
 *
 * Revision 1.17  2003/08/06 22:05:53  gadde
 * Update BXH file for byte-order.
 *
 * Revision 1.16  2003/08/06 22:01:20  gadde
 * Write one BXH file for all volumes unless otherwise specified.
 *
 * Revision 1.15  2003/08/06 21:23:23  gadde
 * Write out SPM .mat file unless otherwise specified, and fix some
 * buffer overflows.
 *
 * Revision 1.14  2003/07/31 18:52:25  gadde
 * Fix bug that occurs when some BXH fields don't exist
 *
 * Revision 1.13  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.12  2003/07/10 12:03:35  gadde
 * Update dimension sizes for output BXH headers.
 *
 * Revision 1.11  2003/07/10 11:48:20  gadde
 * Make 4th dimension size 1 if splitting into Volumes.
 *
 * Revision 1.10  2003/07/08 17:05:32  gadde
 * Add log.
 * Fix check for 4th dimension to be "t" or "T" ("te" will be an extra
 * non-special dimension).
 * Allow for more than four dimensions (e.g. if "te" or "tr" are dimensions)
 *
 */
