#!/usr/bin/perl -w

use strict;

use FindBin;
use lib "$FindBin::Bin";

use XML::DOM;
use XML::DOM::XPath;
use Digest::MD5 qw/ md5_hex /;
use File::Spec;

my $printcanonical = 0;

if (grep { $_ =~ /^--printcanonical$/ } @ARGV) {
  @ARGV = grep { $_ !~ /^--printcanonical$/ } @ARGV;
  $printcanonical = 1;
}

my $infilename;
while ($infilename = shift) {
  my $parser = XML::DOM::Parser->new();
  my $doc = $parser->parsefile($infilename);
  my $bxh = $doc->getDocumentElement();
  my $xpresult = $bxh->findnodes("*");
  for my $node (@$xpresult) {
    if ($node->getNodeName() eq "history" || $node->getNodeName() eq "provenance") {
      $node->getParentNode()->removeChild($node);
    } elsif ($node->getNodeName() eq "datarec") {
      my $filenamenodes = $node->findnodes("filename");
      for my $filenamenode (@$filenamenodes) {
        my $content = '';
        for (my $curnode = $filenamenode->getFirstChild();
             defined($curnode);
             $curnode = $curnode->getNextSibling()) {
          if ($curnode->getNodeType() eq XML::DOM::TEXT_NODE) {
            $content .= $curnode->getNodeValue();
          } else {
            next;
          }
        }
        my ($vol, $dirs, $file) = File::Spec->splitpath($content);
        while ($filenamenode->getFirstChild()) {
          $filenamenode->removeChild($filenamenode->getFirstChild());
        }
        my $newtextnode = $doc->createTextNode($file);
        $filenamenode->appendChild($newtextnode);
      }
    } elsif ($node->getNodeName() eq "acquisitiondata") {
        my $swapped = 1;
        while ($swapped) {
            $swapped = 0;
            my $lastnode = undef;
            for (my $curnode = $node->getFirstChild();
                 defined($curnode);
                 $curnode = $curnode->getNextSibling()) {
                 if ($curnode->getNodeType() != XML::DOM::ELEMENT_NODE) {
                     next;
                 }
                 my $doswap = 0;
                 my $prevnode = $lastnode;
                 $lastnode = $curnode;
                 if (defined($prevnode)) {
                     my $prevname = $prevnode->getNodeName();
                     my $curname = $curnode->getNodeName();
                     if ($prevname gt $curname) {
                         $doswap = 1;
                     } elsif ($prevname eq $curname && $curnode->getNodeType() eq XML::DOM::ELEMENT_NODE) {
                         my $prevname = $prevnode->getAttribute("name");
                         my $curname = $curnode->getAttribute("name");
                         if (defined($prevname) && defined($curname) && $prevname gt $curname) {
                             $doswap = 1;
                         }
                     }
                 }
                 if ($doswap) {
                     $swapped = 1;
                     my $nextnode = $curnode->getNextSibling();
                     $node->replaceChild($curnode, $prevnode);
                     $node->insertBefore($prevnode, $nextnode);
                     my $swap = $curnode;
                     $curnode = $prevnode;
                     $prevnode = $swap;
                 }
            }
        }
    }
  }
  my $canon_xml = $doc->toString();
  if ($printcanonical) {
    print $canon_xml;
    exit 0;
  }
  my $digest = md5_hex($canon_xml);
  print "$digest\t$infilename\n";
}
