static const char rcsid[] = "$Id: extractimagedata.c,v 1.13 2005-09-20 18:37:56 gadde Exp $";

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef WIN32
#include <unistd.h>
#endif

#include "bxh_datarec.h"
#include "opts.h"

#ifndef XMLH_VERSIONSTR
#define XMLH_VERSIONSTR "(no version specified)"
#endif

#define PROGNAME "extractimagedata"

int opt_msbfirst = 0;

int
main(int argc, char *argv[])
{
    bxhrawdatarec * datarec;
    BXHDocPtr docp;
    BXHElementPtr imagedatap;
    struct stat statbuf;
    FILE * fp;
    off_t curpos = 0;
    void * buf = NULL;
    int opt_version = 0;
    const int numopts = 4;
    opt_data opts[4] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  " PROGNAME " [opts] xmlfile outputfile\n\n"
	  "This program extracts the image data pointed to by the input "
	  "BXH or XCEDE file and writes it to outputfile." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_version, 1, "version",
	  "Print version string and exit." },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_msbfirst, 1, "msbfirst",
	  "Extract data as big-endian (default: little-endian)." },
    };
    int numoptargs;

    numoptargs = opt_parse(argc, argv, numopts, &opts[0], 0);
    argc -= numoptargs;

    if (opt_version) {
	fprintf(stdout, "%s\n", XMLH_VERSIONSTR);
	exit(0);
    }
    if (argc < 3) {
	fprintf(stderr, "Usage: %s [opts] inputfile outputfile\n", argv[0]);
	fprintf(stderr, "Use --help for more info.\n");
	return -1;
    }

    if (stat(argv[2], &statbuf) == 0) {
	fprintf(stderr, "%s: '%s' exists.\n", argv[0], argv[2]);
	return -1;
    }

    if ((docp = bxh_readFile(argv[1])) == NULL) {
	fprintf(stderr, "Reading XML file failed.\n");
	return -1;
    }
    if ((imagedatap = bxh_getDatarec(docp, "image", NULL)) == NULL) {
	fprintf(stderr, "Getting 'image' datarec failed.\n");
	return -1;
    }
    if ((datarec = bxh_datarec_createFromElement(imagedatap, argv[1])) == NULL) {
	fprintf(stderr, "Creating raw datarec failed.\n");
	return -1;
    }

    fp = fopen(argv[2], "wb");
    buf = malloc(sizeof(char) * 1024 * 1024);
    while (curpos < datarec->datasize) {
	size_t readsize = datarec->datasize - curpos;
	if (readsize > 1024 * 1024)
	    readsize = 1024 * 1024;
	if (bxh_datarec_readRawData(datarec, buf, curpos, readsize, opt_msbfirst) == -1) {
	    fprintf(stderr, "Error reading data at position %lu", (unsigned long)curpos);
	    return -1;
	}
	fwrite(buf, readsize, 1, fp);
	curpos += readsize;
    }
    free(buf);
    fclose(fp);

    bxh_datarec_free(datarec);
    return 0;
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.12  2005/09/19 16:31:58  gadde
 * Documentation and help message updates.
 *
 * Revision 1.11  2004/06/18 13:54:24  gadde
 * Add to usage message
 *
 * Revision 1.10  2004/03/19 15:13:32  gadde
 * Major changes in datarec support, include a new 'prepare' stage
 * that initiates filtering, permutation.
 * bxh_datarec_readData has been changed to bxh_datarec_readRawData
 * to reflect this.
 * Added some fMRI QA measures.
 *
 * Revision 1.9  2004/03/12 16:29:04  gadde
 * Minor updates
 *
 * Revision 1.8  2003/06/18 16:12:16  gadde
 * win32 fixes
 *
 * Revision 1.7  2003/06/18 16:06:55  gadde
 * fopen in binary mode
 *
 * Revision 1.6  2003/05/16 19:58:16  gadde
 * Require basepath for datarec.
 *
 * Revision 1.5  2002/12/03 20:41:04  gadde
 * Big update --
 *  add new datarec module, convert more programs from domutil_ to bxh_,
 *  add new bxh_getElement* functions, and domutil_prettify.
 *
 * Revision 1.4  2002/08/20 20:59:18  gadde
 * Added --msbfirst option to extractimagedata.
 *
 * Revision 1.3  2002/08/20 20:12:29  gadde
 * Function name changes.
 *
 */
