static const char rcsid[] = "$Id";

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef WIN32
#include <unistd.h>
#endif

#include "bxh_datarec.h"
#include "opts.h"

#ifndef XMLH_VERSIONSTR
#define XMLH_VERSIONSTR "(no version specified)"
#endif

#define PROGNAME "extractxyztdata"

int opt_msbfirst = 0;

int
main(int argc, char *argv[])
{
    bxhrawdatarec * datarec;
    bxhrawdatarec * newdatarec;
    BXHDocPtr docp;
    BXHElementPtr imagedatap;
    struct stat statbuf;
    FILE * fp;
    void * buf = NULL;
    int opt_version = 0;
    const int numopts = 4;
    opt_data opts[4] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  " PROGNAME " [opts] xmlfile outputfile\n\n"
	  "This program extracts the image data pointed to by the input "
	  "BXH or XCEDE file and writes it to outputfile.  The data is "
	  "reordered so that the dimensions labeled 'x', 'y', 'z', and 't' "
	  "are in that order." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_version, 1, "version",
	  "Print version string and exit." },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_msbfirst, 1, "msbfirst",
	  "Extract data as big-endian (default: little-endian)." },
    };
    int numoptargs;

    numoptargs = opt_parse(argc, argv, numopts, &opts[0], 0);
    argc -= numoptargs;

    if (opt_version) {
	fprintf(stdout, "%s\n", XMLH_VERSIONSTR);
	exit(0);
    }
    if (argc < 3) {
	fprintf(stderr, "Usage: %s xmlfile outputfile\n", argv[0]);
	fprintf(stderr, "Use --help for more info.\n");
	return -1;
    }

    if (stat(argv[2], &statbuf) == 0) {
	fprintf(stderr, "%s: '%s' exists.\n", argv[0], argv[2]);
	return -1;
    }

    if ((docp = bxh_readFile(argv[1])) == NULL) {
	fprintf(stderr, "Reading BXH file failed.\n");
	return -1;
    }
    if ((imagedatap = bxh_getDatarec(docp, "image", NULL)) == NULL) {
	fprintf(stderr, "Getting 'image' datarec failed.\n");
	return -1;
    }
    if ((datarec = bxh_datarec_createFromElement(imagedatap, argv[1])) == NULL) {
	fprintf(stderr, "Creating raw datarec failed.\n");
	return -1;
    }

    buf = malloc(sizeof(char) * datarec->datasize);
    if ((newdatarec = bxh_datarec_readXYZTData(datarec, buf, opt_msbfirst)) == NULL) {
	fprintf(stderr, "Error reading data!\n");
	return -1;
    }
    bxh_datarec_free(datarec);
    datarec = newdatarec;
    fp = fopen(argv[2], "wb");
    fwrite(buf, datarec->datasize, 1, fp);
    free(buf);
    fclose(fp);

    bxh_datarec_free(datarec);
    return 0;
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.5  2005/09/19 16:31:58  gadde
 * Documentation and help message updates.
 *
 * Revision 1.4  2004/06/18 13:54:24  gadde
 * Add to usage message
 *
 * Revision 1.3  2004/03/19 15:13:32  gadde
 * Major changes in datarec support, include a new 'prepare' stage
 * that initiates filtering, permutation.
 * bxh_datarec_readData has been changed to bxh_datarec_readRawData
 * to reflect this.
 * Added some fMRI QA measures.
 *
 * Revision 1.2  2003/10/22 16:08:48  gadde
 * Fix some compiler warnings
 *
 * Revision 1.1  2003/10/21 22:09:47  gadde
 * *** empty log message ***
 *
 *
 */
