static const char rcsid[] = "$Id: printfrags.c,v 1.8 2005-09-19 16:31:59 gadde Exp $";

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "bxh_utils.h"
#include "bxh_datarec.h"

extern char * domutil_errorbuf;

int
main(int argc, char *argv[])
{
    BXHDocPtr docp = NULL;
    BXHElementPtr imagedatap = NULL;
    bxhrawdatarec * datarec = NULL;
    int fragnum;
    int retval = 0;

    if (argc < 2 || strcmp(argv[1], "--help") == 0) {
	fprintf(stderr, "Usage:\n  %s xmlfile\n\nThis program prints out the 'frags' in a BXH/XCEDE file.", argv[0]);
	goto FAIL;
    }

    if ((docp = bxh_readFile(argv[1])) == NULL) {
	fprintf(stderr, "Reading BXH file failed.\n");
	goto FAIL;
    }
    if ((imagedatap = bxh_getDatarec(docp, "image", NULL)) == NULL) {
	fprintf(stderr, "Getting 'image' datarec failed.\n");
	goto FAIL;
    }
    if ((datarec = bxh_datarec_createFromElement(imagedatap, argv[1])) == NULL) {
	fprintf(stderr, "Creating raw datarec failed.\n");
	goto FAIL;
    }

    for (fragnum = 0; fragnum < datarec->numfrags; fragnum++) {
	fprintf(stdout, "---\n");
	fprintf(stdout, "Filename: %s\n", datarec->frags[fragnum]->filename);
	fprintf(stdout, "File offset: %d\n", (int)datarec->frags[fragnum]->fileoffset);
	fprintf(stdout, "Frag size: %d\n", (int)datarec->frags[fragnum]->fragsize);
    }
    goto EXIT;
    
FAIL:
    if (domutil_errorbuf[0]) {
	fprintf(stderr, "%s", domutil_errorbuf);
    }
    retval = -1;
    
EXIT:
    bxh_datarec_free(datarec);
    if (imagedatap) bxh_element_unref(imagedatap);
    if (docp) bxh_freeDocument(docp);
    return retval;
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.7  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.6  2003/05/16 19:58:23  gadde
 * Require basepath for datarec.
 *
 * Revision 1.5  2002/12/03 20:41:05  gadde
 * Big update --
 *  add new datarec module, convert more programs from domutil_ to bxh_,
 *  add new bxh_getElement* functions, and domutil_prettify.
 *
 * Revision 1.4  2002/08/23 16:51:05  gadde
 * Avoid compiler warnings.
 *
 * Revision 1.3  2002/08/20 20:07:27  gadde
 * Fixed include.
 *
 * Revision 1.2  2002/08/20 15:32:33  gadde
 * Everything moved from libxml to libgdome (DOM).  All utility functions
 * prefixed with domutil_.  XPath support still shaky in gdome, but dom_utils.c
 * accounts for this, and extra code can be removed when gdome fully supports
 * the DOM level 3 XPath specification.
 *
 * Revision 1.1  2002/08/16 20:36:00  gadde
 * Initial import.
 *
 */
