/*
//
//  Copyright 2009-2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 5436 $
//
//  $LastChangedDate: 2018-12-10 22:01:20 -0500 (Mon, 10 Dec 2018) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include "cmtkImageOperationHistogramEqualization.h"

#include <Base/cmtkTypedArrayFunctionHistogramEqualization.h>
#include <System/cmtkCommandLine.h>

void
cmtk::ImageOperationHistogramEqualization::New()
{
  ImageOperation::m_ImageOperationList.push_back( SmartPtr( new ImageOperationHistogramEqualization( ImageOperationHistogramEqualization::DefaultNumberOfBins ) ) );
}

void
cmtk::ImageOperationHistogramEqualization::NewBins( const long int nBins )
{
  ImageOperation::m_ImageOperationList.push_back( SmartPtr( new ImageOperationHistogramEqualization( nBins ) ) );
}

cmtk::UniformVolume::SmartPtr
cmtk::ImageOperationHistogramEqualization::Apply( cmtk::UniformVolume::SmartPtr& volume )
{
  cmtk::TypedArray::SmartPtr volumeData = volume->GetData();
  volumeData->ApplyFunctionObject( TypedArrayFunctionHistogramEqualization( *volumeData, this->m_NumberOfBins ) );
//  volumeData->HistogramEqualization( this->m_NumberOfBins );
  return volume;
}
