/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 5436 $
//
//  $LastChangedDate: 2018-12-10 22:01:20 -0500 (Mon, 10 Dec 2018) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include "cmtkSegmentationLabel.h"

#include <stdio.h>

namespace cmtk
{

/** \addtogroup Base */
//@{

void CreateSystemLabelColorMap( SegmentationLabelMap& map )
{
  // table of random label RGB color mappings.
  const byte labelRGB[][3] =
    {
      { 000, 000, 000 }, { 255, 128, 255 }, { 177,  18, 255 }, {  45, 255,  47 }, { 106, 209, 255 }, { 122, 255, 158 }, { 255,  87, 186 }, { 183, 150,  54 }, 
      { 216, 255, 159 }, { 181, 169,  80 }, { 255, 152,   0 }, {  42, 255, 255 }, { 116, 255,  77 }, {   6, 253, 234 }, { 218, 108, 255 }, {  24, 255, 108 }, 
      {  59, 255,  91 }, { 255, 127,  14 }, { 255, 196, 142},  { 191,  80, 135 }, { 252,  83,  71 }, { 208, 255,  10 }, { 243, 124, 220 }, {  55, 255, 107 }, 
      {  64,  63, 255 }, {  23, 255, 232 }, { 179, 138, 255 }, { 126, 147, 255 }, { 255, 255, 129 }, { 185,  94, 190 }, { 255, 127, 211 }, { 255,  92, 138 }, 
      { 255, 132, 255 }, {  50, 255, 146 }, { 245,  79, 139 }, { 255,  16,  74 }, { 255,  72, 190 }, { 142, 178, 255 }, { 100, 255,  83 }, { 221, 248, 124 },
      { 165, 255, 223 }, { 252, 186, 133 }, { 209,   5,255 },  { 142, 127, 255 }, {  97, 255, 116 }, {  94, 133, 212 }, { 200, 160, 255 }, { 186, 182,  41 },
      { 255, 141, 165 }, { 255, 255, 148 }, { 188,  96, 255 }, {  40,  64, 255 }, { 192, 152,  66 }, { 255, 163, 123 }, { 255, 100, 255 }, { 255, 212, 174 }, 
      { 163, 245,  21 }, { 255, 173, 175 }, { 255, 223, 183 }, { 100, 131, 212 }, {  27, 255, 135 }, {  93, 255, 118 }, {  50, 223, 146 }, {  48, 192, 255 }, 
      { 255, 106, 116 }, { 110,  53, 231 }, { 193,  52, 255 }, { 255,  54, 255 }, { 185,  33, 255 }, {  74,  74, 255 }, { 192,  20, 199 }, { 133, 145, 255 },
      { 161, 255,  58 }, {  91, 230,  89 }, { 138, 159, 255 }, {   6, 226, 255 }, {  46, 150, 229 }, { 107, 255, 255 }, { 140, 255, 241 }, { 128, 218, 167 },
      {  33, 109, 255 }, { 103,  96, 255 }, {  76, 255,  50 }, { 132, 151, 255 }, { 111,  77, 255 }, { 138, 255, 146 }, {  53,  94, 255 }, { 217, 163, 255 },
      {  77,  61, 255 }, { 115, 170, 196 }, { 219,  49, 148 }, { 255, 201, 117 }, {  61, 129, 255 }, { 168, 105, 234 }, { 164, 216,   2 }, { 178,  91, 184 }, 
      {  14, 255, 228 }, { 132,  49, 247 }, { 146, 129, 255 }, { 255,  27, 135 }, { 222, 255,  50 }, { 100, 255,  31 }, { 255, 100, 214 }, { 255, 255, 150 }, 
      { 123, 255, 255 }, {  93, 180, 176 }, {  62,  46, 255 }, { 118, 184, 255 }, { 131, 105, 230 }, { 101, 167, 166 }, { 148, 255, 172 }, { 255,  96, 209 },
      { 200,  85, 224 }, {  78, 255, 147 }, { 122, 193,  94 }, { 255, 170,  68 }, { 106, 227,  83 }, {  18, 255, 173 }, { 170, 255,  85 }, { 164, 255, 255 },
      {  75, 104, 255 }, { 127, 231, 255 }, { 109, 255, 142 }, { 186, 100, 255 }, {  20, 255,  25 }, { 170, 255, 210 }, { 140,  88, 197 }, { 204,  43, 152 }, 
      {   4, 255, 226 }, { 249, 255, 122 }, { 235, 168, 125 }, { 128, 255,  88 }, { 163, 141,  98 }, {  58, 255, 234 }, { 142, 255, 201 }, {  97, 181, 255 }, 
      { 148, 255, 172 }, { 139, 251, 224 }, {  84, 235, 255 }, { 125, 254,  29 }, { 255, 134,  15 }, { 152, 255, 255 }, { 178, 255, 140 }, {  49, 255,  65 }, 
      { 255, 171, 144 }, {  35,  83, 255 }, { 206, 255, 137 }, { 255, 225,  83 }, { 147, 119, 255 }, {  96, 255,  85 }, {  70, 255, 106 }, { 131, 176, 220 }, 
      { 136, 255, 173 }, { 156, 255,  77 }, { 255,  82, 189 }, { 151, 128, 255 }, { 255, 118, 112 }, {  76, 127, 255 }, { 128, 255, 183 }, { 167,  53, 220 }, 
      { 255, 173, 155 }, { 255, 255,  89 }, {  96, 124, 163 }, { 153, 255, 134 }, { 210, 115, 186 }, {  35,  34, 255 }, {  46, 255,  23 }, { 255, 255, 116 },
      {  30,  19, 255 }, {  81, 255, 167 }, {  76, 255, 255 }, { 180, 255,  20 }, { 255,  99, 158 }, { 255,  57, 152 }, {  97, 199, 255 }, { 255, 144, 199 },
      {  89, 183, 255 }, { 158,  41, 255 }, {  77, 117, 251 }, { 255,  42, 255 }, { 114, 115, 255 }, {  76, 151, 255 }, { 180, 156,  58 }, { 150, 113, 255 },
      { 133, 210, 225 }, { 169, 255, 255 }, {  73, 255, 125 }, { 208, 179,  88 }, { 162, 255, 199 }, {  47, 176, 255 }, { 130, 255, 255 }, { 255, 181, 150 },
      { 102, 135, 229 }, {  23,  88, 255 }, { 127, 255, 253 }, { 255,  17, 113 }, { 188, 117, 255 }, { 251, 255, 127 }, {  39, 255, 255 }, { 255, 255, 119 },
      { 146,  20, 255 }, { 146,   8, 255 }, {  90, 255, 157 }, { 126, 151, 255 }, {  94, 255, 130 }, { 252, 255, 100 }, { 218, 152,  88 }, {  92, 114, 255 },
      { 144, 179, 255 }, {  83, 126, 179 }, { 183, 255, 188 }, {  67, 169, 255 }, { 255, 125, 160 }, {  53, 255, 255 }, { 252, 113, 129 }, { 255, 140, 248 }, 
      { 140,  83, 255 }, { 255, 166, 200 }, {  80, 145, 255 }, { 167, 185,  93 }, { 165, 223,  61 }, { 255, 255, 162 }, { 227, 103,  97 }, {  95, 255, 255 }, 
      { 223, 129,  56 }, {  92, 255, 141 }, { 188, 255, 157 }, {  88, 127, 179 }, {  52, 255, 204 }, {   0, 255,  27 }, { 141, 232, 255 }, { 173, 145, 255 }, 
      {  79,  89, 232 }, { 200,  53, 255 }, {  41,  21, 255 }, { 210, 142, 255 }, { 156, 187,  58 }, { 212, 154, 108 }, { 193, 152,  58 }, { 255,  10, 133 },
      { 255,  83, 135 }, { 137, 183, 255 }, {  57, 255, 255 }, {  97, 252, 255 }, { 206, 255, 132 }, { 183, 255, 255 }, { 128, 255, 137 }, { 131, 255, 181 }, 
      {  86, 101, 255 }, { 113,  92, 255 }, { 201, 137, 255 }, { 255,  74,  47 }, { 128, 178, 255 }, {  31, 192, 254 }, { 176, 255, 139 }, { 255,  81, 194 } };

  for ( size_t i = 0; i < 256; ++i )
    {
    char name[9];
    sprintf( name, "label%03d", static_cast<int>( i ) );
    map[i].SetName( name );
    map[i].SetRGB( labelRGB[i][0], labelRGB[i][1], labelRGB[i][2] );
    }
}

}
