/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.Polygon;

public class Straightener
implements PlugIn {
    static boolean processStack;

    public void run(String arg) {
        int type;
        int width;
        ImagePlus imp = IJ.getImage();
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isLine()) {
            IJ.error("Straightener", "Line selection required");
            return;
        }
        int originalWidth = width = Math.round(roi.getStrokeWidth());
        boolean isMacro = IJ.macroRunning() && Macro.getOptions() != null;
        int stackSize = imp.getStackSize();
        if (stackSize == 1) {
            processStack = false;
        }
        if (width == 1 || isMacro || stackSize > 1) {
            if (width == 1) {
                width = 20;
            }
            GenericDialog gd = new GenericDialog("Straightener");
            gd.addNumericField("Line Width:", width, 0, 3, "pixels");
            if (stackSize > 1) {
                gd.addCheckbox("Process Entire Stack", processStack);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            width = (int)gd.getNextNumber();
            Line.setWidth(width);
            if (stackSize > 1) {
                processStack = gd.getNextBoolean();
            }
        }
        if ((type = (roi = (Roi)imp.getRoi().clone()).getType()) == 7) {
            IJ.run(imp, "Fit Spline", "");
        }
        ImageProcessor ip2 = null;
        ImagePlus imp2 = null;
        if (processStack) {
            ImageStack stack2 = this.straightenStack(imp, roi, width);
            imp2 = new ImagePlus(WindowManager.getUniqueName(imp.getTitle()), stack2);
        } else {
            ip2 = this.straighten(imp, roi, width);
            imp2 = new ImagePlus(WindowManager.getUniqueName(imp.getTitle()), ip2);
        }
        if (imp2 == null) {
            return;
        }
        Calibration cal = imp.getCalibration();
        if (cal.pixelWidth == cal.pixelHeight) {
            imp2.setCalibration(cal);
        }
        imp2.show();
        if (isMacro) {
            Line.setWidth(originalWidth);
        }
    }

    public ImageProcessor straighten(ImagePlus imp, Roi roi, int width) {
        ImageProcessor ip2 = imp.getBitDepth() == 24 && roi.getType() != 5 ? this.straightenRGB(imp, width) : (imp.isComposite() && ((CompositeImage)imp).getMode() == 1 ? this.straightenComposite(imp, width) : (roi.getType() == 5 ? this.rotateLine(imp, width) : this.straightenLine(imp, width)));
        return ip2;
    }

    public ImageStack straightenStack(ImagePlus imp, Roi roi, int width) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        ImageStack stack2 = null;
        for (int i = 1; i <= n; ++i) {
            IJ.showProgress(i, n);
            imp.setSlice(i);
            ImageProcessor ip2 = this.straighten(imp, roi, width);
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight());
            }
            stack2.addSlice(null, ip2);
        }
        imp.setSlice(current);
        return stack2;
    }

    public ImageProcessor straightenLine(ImagePlus imp, int width) {
        PolygonRoi roi = (PolygonRoi)imp.getRoi();
        if (roi == null) {
            return null;
        }
        if (roi.getState() == 0) {
            roi.exitConstructingMode();
        }
        boolean isSpline = roi.isSplineFit();
        int type = roi.getType();
        int n = roi.getNCoordinates();
        double len = roi.getLength();
        if (!isSpline || !(Math.abs(1.0 - roi.getLength() / (double)n) < 0.5)) {
            roi.fitSplineForStraightening();
        }
        if (roi.getNCoordinates() < 2) {
            return null;
        }
        FloatPolygon p = roi.getFloatPolygon();
        n = p.npoints;
        ImageProcessor ip = imp.getProcessor();
        FloatProcessor ip2 = new FloatProcessor(n, width);
        float[] pixels = (float[])((ImageProcessor)ip2).getPixels();
        double x2 = p.xpoints[0] - (p.xpoints[1] - p.xpoints[0]);
        double y2 = p.ypoints[0] - (p.ypoints[1] - p.ypoints[0]);
        if (width == 1) {
            ((ImageProcessor)ip2).putPixelValue(0, 0, ip.getInterpolatedValue(x2, y2));
        }
        for (int i = 0; i < n; ++i) {
            if (!processStack && i % 10 == 0) {
                IJ.showProgress(i, n);
            }
            double x1 = x2;
            double y1 = y2;
            x2 = p.xpoints[i];
            y2 = p.ypoints[i];
            if (width == 1) {
                ((ImageProcessor)ip2).putPixelValue(i, 0, ip.getInterpolatedValue(x2, y2));
                continue;
            }
            double dx = x2 - x1;
            double dy = y1 - y2;
            double length = (float)Math.sqrt(dx * dx + dy * dy);
            double x = x2 - (dy /= length) * (double)width / 2.0;
            double y = y2 - (dx /= length) * (double)width / 2.0;
            int j = 0;
            int n2 = width;
            do {
                ((ImageProcessor)ip2).putPixelValue(i, j++, ip.getInterpolatedValue(x, y));
                x += dy;
                y += dx;
            } while (--n2 > 0);
        }
        if (!processStack) {
            IJ.showProgress(n, n);
        }
        if (!isSpline) {
            if (type == 7) {
                roi.removeSplineFit();
            } else {
                imp.draw();
            }
        }
        if (imp.getBitDepth() != 24) {
            ip2.setColorModel(ip.getColorModel());
            ((ImageProcessor)ip2).resetMinAndMax();
        }
        return ip2;
    }

    public ImageProcessor rotateLine(ImagePlus imp, int width) {
        Roi roi = imp.getRoi();
        float saveStrokeWidth = roi.getStrokeWidth();
        roi.setStrokeWidth(1.0f);
        Polygon p = roi.getPolygon();
        roi.setStrokeWidth(saveStrokeWidth);
        imp.setRoi(new PolygonRoi(p.xpoints, p.ypoints, 2, 6));
        ImageProcessor ip2 = imp.getBitDepth() == 24 ? this.straightenRGB(imp, width) : this.straightenLine(imp, width);
        imp.setRoi(roi);
        return ip2;
    }

    ImageProcessor straightenRGB(ImagePlus imp, int width) {
        int w = imp.getWidth();
        int h = imp.getHeight();
        int size = w * h;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ColorProcessor cp = (ColorProcessor)imp.getProcessor();
        cp.getRGB(r, g, b);
        ImagePlus imp2 = new ImagePlus("red", new ByteProcessor(w, h, r, null));
        imp2.setRoi((Roi)imp.getRoi().clone());
        ImageProcessor red = this.straightenLine(imp2, width);
        if (red == null) {
            return null;
        }
        imp2 = new ImagePlus("green", new ByteProcessor(w, h, g, null));
        imp2.setRoi((Roi)imp.getRoi().clone());
        ImageProcessor green = this.straightenLine(imp2, width);
        if (green == null) {
            return null;
        }
        imp2 = new ImagePlus("blue", new ByteProcessor(w, h, b, null));
        imp2.setRoi((Roi)imp.getRoi().clone());
        ImageProcessor blue = this.straightenLine(imp2, width);
        if (blue == null) {
            return null;
        }
        ColorProcessor cp2 = new ColorProcessor(red.getWidth(), red.getHeight());
        red = red.convertToByte(false);
        green = green.convertToByte(false);
        blue = blue.convertToByte(false);
        cp2.setRGB((byte[])red.getPixels(), (byte[])green.getPixels(), (byte[])blue.getPixels());
        imp.setRoi(imp2.getRoi());
        return cp2;
    }

    ImageProcessor straightenComposite(ImagePlus imp, int width) {
        Image img = imp.getImage();
        ImagePlus imp2 = new ImagePlus("temp", new ColorProcessor(img));
        imp2.setRoi(imp.getRoi());
        ImageProcessor ip2 = this.straightenRGB(imp2, width);
        imp.setRoi(imp2.getRoi());
        return ip2;
    }
}

