/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class SubstackMaker
implements PlugIn {
    private static boolean delete = false;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp.isHyperStack() || imp.isComposite()) {
            IJ.error("Make Substack", "This command does not currently work with hyperstacks.");
            return;
        }
        String userInput = this.showDialog();
        if (userInput == null) {
            return;
        }
        ImagePlus imp2 = this.makeSubstack(imp, userInput);
        if (imp2 != null) {
            imp2.show();
        }
    }

    public ImagePlus makeSubstack(ImagePlus imp, String userInput) {
        String stackTitle = "Substack (" + userInput + ")";
        if (stackTitle.length() > 25) {
            int idxA = stackTitle.indexOf(",", 18);
            int idxB = stackTitle.lastIndexOf(",");
            if (idxA >= 1 && idxB >= 1) {
                String strA = stackTitle.substring(0, idxA);
                String strB = stackTitle.substring(idxB + 1);
                stackTitle = strA + ", ... " + strB;
            }
        }
        ImagePlus imp2 = null;
        try {
            int idx1 = userInput.indexOf("-");
            if (idx1 >= 1) {
                String rngStart = userInput.substring(0, idx1);
                String rngEnd = userInput.substring(idx1 + 1);
                Integer obj = new Integer(rngStart);
                int first = obj;
                int inc = 1;
                int idx2 = rngEnd.indexOf("-");
                if (idx2 >= 1) {
                    String rngEndAndInc = rngEnd;
                    rngEnd = rngEndAndInc.substring(0, idx2);
                    String rngInc = rngEndAndInc.substring(idx2 + 1);
                    obj = new Integer(rngInc);
                    inc = obj;
                }
                obj = new Integer(rngEnd);
                int last = obj;
                imp2 = this.stackRange(imp, first, last, inc, stackTitle);
            } else {
                int count = 1;
                for (int j = 0; j < userInput.length(); ++j) {
                    char ch = Character.toLowerCase(userInput.charAt(j));
                    if (ch != ',') continue;
                    ++count;
                }
                int[] numList = new int[count];
                for (int i = 0; i < count; ++i) {
                    Integer obj;
                    String num;
                    int idx2 = userInput.indexOf(",");
                    if (idx2 > 0) {
                        num = userInput.substring(0, idx2);
                        obj = new Integer(num);
                        numList[i] = obj;
                        userInput = userInput.substring(idx2 + 1);
                        continue;
                    }
                    num = userInput;
                    obj = new Integer(num);
                    numList[i] = obj;
                }
                imp2 = this.stackList(imp, count, numList, stackTitle);
            }
        }
        catch (Exception e) {
            IJ.error("Substack Maker", "Invalid input string:        \n \n  \"" + userInput + "\"");
        }
        return imp2;
    }

    String showDialog() {
        GenericDialog gd = new GenericDialog("Substack Maker");
        gd.setInsets(10, 45, 0);
        gd.addMessage("Enter a range (e.g. 2-14), a range with increment\n(e.g. 1-100-2) or a list (e.g. 7,9,25,27)");
        gd.addStringField("Slices:", "", 40);
        gd.addCheckbox("Delete slices from original stack", delete);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        delete = gd.getNextBoolean();
        return gd.getNextString();
    }

    ImagePlus stackList(ImagePlus imp, int count, int[] numList, String stackTitle) throws Exception {
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        Roi roi = imp.getRoi();
        int j = 0;
        for (int i = 0; i < count; ++i) {
            int currSlice = numList[i] - j;
            ImageProcessor ip2 = stack.getProcessor(currSlice);
            ip2.setRoi(roi);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight());
            }
            stack2.addSlice(stack.getSliceLabel(currSlice), ip2);
            if (!delete) continue;
            stack.deleteSlice(currSlice);
            ++j;
        }
        if (delete) {
            imp.setStack(stack);
            ImageWindow win = imp.getWindow();
            StackWindow swin = (StackWindow)win;
            swin.updateSliceSelector();
        }
        ImagePlus impSubstack = imp.createImagePlus();
        impSubstack.setStack(stackTitle, stack2);
        return impSubstack;
    }

    ImagePlus stackRange(ImagePlus imp, int first, int last, int inc, String title) throws Exception {
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        Roi roi = imp.getRoi();
        int j = 0;
        for (int i = first; i <= last; i += inc) {
            int currSlice = i - j;
            ImageProcessor ip2 = stack.getProcessor(currSlice);
            ip2.setRoi(roi);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight());
            }
            stack2.addSlice(stack.getSliceLabel(currSlice), ip2);
            if (!delete) continue;
            stack.deleteSlice(currSlice);
            ++j;
        }
        if (delete) {
            imp.setStack(stack);
            ImageWindow win = imp.getWindow();
            StackWindow swin = (StackWindow)win;
            swin.updateSliceSelector();
        }
        ImagePlus substack = imp.createImagePlus();
        substack.setStack(title, stack2);
        substack.setCalibration(imp.getCalibration());
        return substack;
    }
}

