/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.SaveDialog;
import ij.macro.FunctionFinder;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Properties;

public class Editor
extends PlugInFrame
implements ActionListener,
ItemListener,
TextListener,
ClipboardOwner,
MacroConstants {
    public static String JavaScriptIncludes = "importPackage(Packages.ij);importPackage(Packages.ij.gui);importPackage(Packages.ij.process);importPackage(Packages.ij.measure);importPackage(Packages.ij.util);importPackage(Packages.ij.plugin);importPackage(Packages.ij.io);importPackage(Packages.ij.plugin.filter);importPackage(Packages.ij.plugin.frame);importPackage(java.lang);importPackage(java.awt);importPackage(java.awt.image);importPackage(java.awt.geom);importPackage(java.util);importPackage(java.io);function print(s) {IJ.log(s);};";
    public static String JS_NOT_FOUND = "JavaScript.jar was not found in the plugins\nfolder. It can be downloaded from:\n \nhttp://imagej.nih.gov/ij/download/tools/JavaScript.jar";
    public static final int MAX_SIZE = 28000;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final int MONOSPACED = 1;
    public static final int MENU_BAR = 2;
    public static final int MACROS_MENU_ITEMS = 8;
    static final String FONT_SIZE = "editor.font.size";
    static final String FONT_MONO = "editor.font.mono";
    static final String CASE_SENSITIVE = "editor.case-sensitive";
    static final String DEFAULT_DIR = "editor.dir";
    private TextArea ta;
    private String path;
    private boolean changes;
    private static String searchString = "";
    private static boolean caseSensitive = Prefs.get("editor.case-sensitive", true);
    private static int lineNumber = 1;
    private static int xoffset;
    private static int yoffset;
    private static int nWindows;
    private Menu fileMenu;
    private Menu editMenu;
    private Properties p = new Properties();
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb;
    private Menu macrosMenu;
    private int nMacros;
    private Program pgm;
    private int eventCount;
    private String shortcutsInUse;
    private int inUseCount;
    private MacroInstaller installer;
    private static String defaultDir;
    private boolean dontShowWindow;
    private int[] sizes = new int[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 36, 48, 60, 72};
    private int fontSize = (int)Prefs.get("editor.font.size", 6.0);
    private CheckboxMenuItem monospaced;
    private static boolean wholeWords;
    private boolean isMacroWindow;
    private int debugStart;
    private int debugEnd;
    private static TextWindow debugWindow;
    private boolean step;
    private int previousLine;
    private static Editor instance;
    private int runToLine;
    private boolean fixedLineEndings;

    public Editor() {
        this(16, 60, 0, 2);
    }

    public Editor(int rows, int columns, int fontSize, int options) {
        super("Editor");
        WindowManager.addWindow(this);
        this.addMenuBar(options);
        this.ta = new TextArea(rows, columns);
        this.ta.addTextListener(this);
        if (IJ.isLinux()) {
            this.ta.setBackground(Color.white);
        }
        this.addKeyListener(IJ.getInstance());
        this.add(this.ta);
        this.pack();
        if (fontSize < 0) {
            fontSize = 0;
        }
        if (fontSize >= this.sizes.length) {
            fontSize = this.sizes.length - 1;
        }
        this.setFont();
        this.positionWindow();
    }

    void addMenuBar(int options) {
        this.mb = new MenuBar();
        if (Menus.getFontSize() != 0) {
            // empty if block
        }
        this.mb.setFont(Menus.getFont());
        Menu m = new Menu("File");
        m.add(new MenuItem("New...", new MenuShortcut(78, true)));
        m.add(new MenuItem("Open...", new MenuShortcut(79)));
        m.add(new MenuItem("Save", new MenuShortcut(83)));
        m.add(new MenuItem("Save As..."));
        m.add(new MenuItem("Print...", new MenuShortcut(80)));
        m.addActionListener(this);
        this.fileMenu = m;
        this.mb.add(m);
        m = new Menu("Edit");
        String key = IJ.isMacintosh() ? "  Cmd " : "  Ctrl+";
        MenuItem item = new MenuItem("Undo" + key + "Z");
        item.setEnabled(false);
        m.add(item);
        m.addSeparator();
        boolean shortcutsBroken = IJ.isWindows() && (System.getProperty("java.version").indexOf("1.1.8") >= 0 || System.getProperty("java.version").indexOf("1.5.") >= 0);
        item = shortcutsBroken ? new MenuItem("Cut  Ctrl+X") : new MenuItem("Cut", new MenuShortcut(88));
        m.add(item);
        item = shortcutsBroken ? new MenuItem("Copy  Ctrl+C") : new MenuItem("Copy", new MenuShortcut(67));
        m.add(item);
        item = shortcutsBroken ? new MenuItem("Paste  Ctrl+V") : new MenuItem("Paste", new MenuShortcut(86));
        m.add(item);
        m.addSeparator();
        m.add(new MenuItem("Find...", new MenuShortcut(70)));
        m.add(new MenuItem("Find Next", new MenuShortcut(71)));
        m.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        m.addSeparator();
        m.add(new MenuItem("Select All", new MenuShortcut(65)));
        m.add(new MenuItem("Zap Gremlins"));
        m.add(new MenuItem("Copy to Image Info"));
        m.addActionListener(this);
        this.mb.add(m);
        this.editMenu = m;
        if ((options & 2) != 0) {
            this.setMenuBar(this.mb);
        }
        m = new Menu("Font");
        m.add(new MenuItem("Make Text Smaller", new MenuShortcut(78)));
        m.add(new MenuItem("Make Text Larger", new MenuShortcut(77)));
        m.addSeparator();
        this.monospaced = new CheckboxMenuItem("Monospaced Font", Prefs.get(FONT_MONO, false));
        if ((options & 1) != 0) {
            this.monospaced.setState(true);
        }
        this.monospaced.addItemListener(this);
        m.add(this.monospaced);
        m.add(new MenuItem("Save Settings"));
        m.addActionListener(this);
        this.mb.add(m);
    }

    public void positionWindow() {
        Dimension screen = IJ.getScreenSize();
        Dimension window = this.getSize();
        if (window.width == 0) {
            return;
        }
        int left = screen.width / 2 - window.width / 2;
        int top = (screen.height - window.height) / 4;
        if (top < 0) {
            top = 0;
        }
        if (nWindows <= 0 || xoffset > 80) {
            xoffset = 0;
            yoffset = 0;
        }
        this.setLocation(left + xoffset, top + yoffset);
        xoffset += 10;
        yoffset += 18;
        ++nWindows;
    }

    void setWindowTitle(String title) {
        Menus.updateWindowMenuItem(this.getTitle(), title);
        this.setTitle(title);
    }

    public void create(String name, String text) {
        boolean macroExtension;
        if (text != null && text.length() > 0) {
            this.fixedLineEndings = true;
        }
        this.ta.append(text);
        if (IJ.isMacOSX()) {
            IJ.wait(25);
        }
        this.ta.setCaretPosition(0);
        this.setWindowTitle(name);
        boolean bl = macroExtension = name.endsWith(".txt") || name.endsWith(".ijm");
        if (macroExtension || name.endsWith(".js") || name.indexOf(".") == -1) {
            this.macrosMenu = new Menu("Macros");
            this.macrosMenu.add(new MenuItem("Run Macro", new MenuShortcut(82)));
            this.macrosMenu.add(new MenuItem("Evaluate Line", new MenuShortcut(89)));
            this.macrosMenu.add(new MenuItem("Abort Macro"));
            this.macrosMenu.add(new MenuItem("Install Macros", new MenuShortcut(73)));
            this.macrosMenu.add(new MenuItem("Function Finder...", new MenuShortcut(70, true)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.add(new MenuItem("Evaluate JavaScript", new MenuShortcut(74, false)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.addActionListener(this);
            this.mb.add(this.macrosMenu);
            if (!name.endsWith(".js")) {
                Menu debugMenu = new Menu("Debug");
                debugMenu.add(new MenuItem("Debug Macro", new MenuShortcut(68)));
                debugMenu.add(new MenuItem("Step", new MenuShortcut(69)));
                debugMenu.add(new MenuItem("Trace", new MenuShortcut(84)));
                debugMenu.add(new MenuItem("Fast Trace", new MenuShortcut(84, true)));
                debugMenu.add(new MenuItem("Run"));
                debugMenu.add(new MenuItem("Run to Insertion Point", new MenuShortcut(69, true)));
                debugMenu.add(new MenuItem("Abort"));
                debugMenu.addActionListener(this);
                this.mb.add(debugMenu);
            }
            if (macroExtension && text.indexOf("macro ") != -1) {
                this.installMacros(text, false);
            }
        } else {
            this.fileMenu.addSeparator();
            this.fileMenu.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        }
        if (IJ.getInstance() != null && !this.dontShowWindow) {
            this.show();
        }
        if (this.dontShowWindow) {
            this.dispose();
            this.dontShowWindow = false;
        }
        WindowManager.setWindow(this);
        this.changes = false;
    }

    public void createMacro(String name, String text) {
        this.create(name, text);
    }

    void installMacros(String text, boolean installInPluginsMenu) {
        String functions = Interpreter.getAdditionalFunctions();
        if (functions != null && text != null) {
            text = !text.endsWith("\n") && !functions.startsWith("\n") ? text + "\n" + functions : text + functions;
        }
        this.installer = new MacroInstaller();
        this.installer.setFileName(this.getTitle());
        int nShortcutsOrTools = this.installer.install(text, this.macrosMenu);
        if (installInPluginsMenu || nShortcutsOrTools > 0) {
            this.installer.install(null);
        }
        this.dontShowWindow = this.installer.isAutoRunAndHide();
    }

    public void open(String dir, String name) {
        this.path = dir + name;
        File file = new File(this.path);
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            this.create(name, new String(sb));
            this.changes = false;
        }
        catch (Exception e) {
            IJ.handleException(e);
            return;
        }
    }

    public String getText() {
        if (this.ta == null) {
            return "";
        }
        return this.ta.getText();
    }

    public TextArea getTextArea() {
        return this.ta;
    }

    public void display(String title, String text) {
        this.ta.selectAll();
        this.ta.replaceRange(text, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setWindowTitle(title);
        this.changes = false;
        if (IJ.getInstance() != null) {
            this.show();
        }
        WindowManager.setWindow(this);
    }

    void save() {
        if (this.path == null) {
            this.saveAs();
            return;
        }
        File f = new File(this.path);
        if (f.exists() && !f.canWrite()) {
            IJ.showMessage("Editor", "Unable to save because file is write-protected. \n \n" + this.path);
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        try {
            String s;
            BufferedReader br = new BufferedReader(new CharArrayReader(chars));
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
            while ((s = br.readLine()) != null) {
                bw.write(s, 0, s.length());
                bw.newLine();
            }
            bw.close();
            IJ.showStatus(text.length() + " chars saved to " + this.path);
            this.changes = false;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            String text = this.ta.getText();
            if (text.contains("implements PlugInFilter") && text.contains("IJ.run(")) {
                IJ.log("Plugins that call IJ.run() should probably implement PlugIn, not PlugInFilter.");
            }
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    final void runMacro(boolean debug) {
        int end;
        if (this.getTitle().endsWith(".js")) {
            this.evaluateJavaScript();
            return;
        }
        int start = this.ta.getSelectionStart();
        String text = start == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        new MacroRunner(text, debug ? this : null);
    }

    void evaluateJavaScript() {
        int end;
        int start;
        String text;
        if (!this.getTitle().endsWith(".js")) {
            this.setTitle(SaveDialog.setExtension(this.getTitle(), ".js"));
        }
        if ((text = (start = this.ta.getSelectionStart()) == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText()).equals("")) {
            return;
        }
        text = Editor.getJSPrefix("") + text;
        if (IJ.isJava16() && (!IJ.isMacOSX() || IJ.is64Bit())) {
            IJ.runPlugIn("JavaScriptEvaluator", text);
        } else {
            Object js = IJ.runPlugIn("JavaScript", text);
            if (js == null) {
                IJ.error(JS_NOT_FOUND);
            }
        }
    }

    void evaluateLine() {
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        if (end > start) {
            this.runMacro(false);
            return;
        }
        String text = this.ta.getText();
        while (start > 0) {
            if (text.charAt(--start) != '\n') continue;
            ++start;
            break;
        }
        while (end < text.length() - 1 && text.charAt(++end) != '\n') {
        }
        this.ta.setSelectionStart(start);
        this.ta.setSelectionEnd(end);
        this.runMacro(false);
    }

    void print() {
        PrintJob pjob = Toolkit.getDefaultToolkit().getPrintJob(this, "Cool Stuff", this.p);
        if (pjob != null) {
            Graphics pg = pjob.getGraphics();
            if (pg != null) {
                String s = this.ta.getText();
                this.printString(pjob, pg, s);
                pg.dispose();
            }
            pjob.end();
        }
    }

    void printString(PrintJob pjob, Graphics pg, String s) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        int topMargin = 30;
        int leftMargin = 30;
        int bottomMargin = 30;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics contextt not PrintGraphics");
        }
        if (IJ.isMacintosh()) {
            topMargin = 0;
            leftMargin = 0;
            bottomMargin = 0;
        }
        StringReader sr = new StringReader(s);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height - bottomMargin;
        Font helv = new Font(this.getFontName(), 0, 10);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = topMargin;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                nextLine = this.detabLine(nextLine);
                if (curHeight + fontHeight > pageHeight) {
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = topMargin;
                }
                curHeight += fontHeight;
                if (pg == null) continue;
                pg.drawString(nextLine, leftMargin, curHeight - fontDescent);
                ++linesForThisPage;
                ++linesForThisJob;
            } while (nextLine != null);
        }
        catch (EOFException eof) {
        }
        catch (Throwable t) {
            IJ.handleException(t);
        }
    }

    String detabLine(String s) {
        if (s.indexOf(9) < 0) {
            return s;
        }
        int tabSize = 4;
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.25));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\t') {
                for (int j = 0; j < tabSize; ++j) {
                    sb.append(' ');
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    boolean copy() {
        String s = this.ta.getSelectedText();
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip != null) {
            StringSelection cont = new StringSelection(s);
            clip.setContents(cont, this);
            return true;
        }
        return false;
    }

    void cut() {
        if (this.copy()) {
            int start = this.ta.getSelectionStart();
            int end = this.ta.getSelectionEnd();
            this.ta.replaceRange("", start, end);
            if (IJ.isMacOSX()) {
                this.ta.setCaretPosition(start);
            }
        }
    }

    void paste() {
        String s = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(s);
        try {
            s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            s = e.toString();
        }
        if (!this.fixedLineEndings && IJ.isWindows()) {
            this.fixLineEndings();
        }
        this.fixedLineEndings = true;
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        this.ta.replaceRange(s, start, end);
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(start + s.length());
        }
    }

    void copyToInfo() {
        int end;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        int start = this.ta.getSelectionStart();
        String text = start == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        imp.setProperty("Info", text);
    }

    public void actionPerformed(ActionEvent e) {
        boolean altKeyDown;
        String what = e.getActionCommand();
        int flags = e.getModifiers();
        boolean bl = altKeyDown = (flags & 8) != 0;
        if (IJ.debugMode) {
            IJ.log("actionPerformed: " + e);
        }
        if ("Save".equals(what)) {
            this.save();
        } else if ("Compile and Run".equals(what)) {
            this.compileAndRun();
        } else if ("Run Macro".equals(what)) {
            if (altKeyDown) {
                this.enableDebugging();
                this.runMacro(true);
            } else {
                this.runMacro(false);
            }
        } else if ("Debug Macro".equals(what)) {
            this.enableDebugging();
            this.runMacro(true);
        } else if ("Step".equals(what)) {
            this.setDebugMode(1);
        } else if ("Trace".equals(what)) {
            this.setDebugMode(2);
        } else if ("Fast Trace".equals(what)) {
            this.setDebugMode(3);
        } else if ("Run".equals(what)) {
            this.setDebugMode(4);
        } else if ("Run to Insertion Point".equals(what)) {
            this.runToInsertionPoint();
        } else if ("Abort".equals(what) || "Abort Macro".equals(what)) {
            Interpreter.abort();
            IJ.beep();
        } else if ("Evaluate Line".equals(what)) {
            this.evaluateLine();
        } else if ("Install Macros".equals(what)) {
            this.installMacros(this.ta.getText(), true);
        } else if ("Function Finder...".equals(what)) {
            new FunctionFinder();
        } else if ("Evaluate JavaScript".equals(what)) {
            this.evaluateJavaScript();
        } else if ("Print...".equals(what)) {
            this.print();
        } else if (what.equals("Paste")) {
            this.paste();
        } else if (what.equals("Copy")) {
            this.copy();
        } else if (what.equals("Cut")) {
            this.cut();
        } else if ("Save As...".equals(what)) {
            this.saveAs();
        } else if ("Select All".equals(what)) {
            this.selectAll();
        } else if ("Find...".equals(what)) {
            this.find(null);
        } else if ("Find Next".equals(what)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(what)) {
            this.gotoLine();
        } else if ("Zap Gremlins".equals(what)) {
            this.zapGremlins();
        } else if ("Make Text Larger".equals(what)) {
            this.changeFontSize(true);
        } else if ("Make Text Smaller".equals(what)) {
            this.changeFontSize(false);
        } else if ("Save Settings".equals(what)) {
            this.saveSettings();
        } else if ("New...".equals(what)) {
            IJ.run("Text Window");
        } else if ("Open...".equals(what)) {
            IJ.open();
        } else if (what.equals("Copy to Image Info")) {
            this.copyToInfo();
        } else if (altKeyDown) {
            this.enableDebugging();
            this.installer.runMacro(what, this);
        } else {
            this.installer.runMacro(what, null);
        }
    }

    final void runToInsertionPoint() {
        Interpreter interp = Interpreter.getInstance();
        if (interp == null) {
            IJ.beep();
        } else {
            this.runToLine = this.getCurrentLine();
            this.setDebugMode(5);
        }
    }

    final int getCurrentLine() {
        int pos = this.ta.getCaretPosition();
        int currentLine = 0;
        String text = this.ta.getText();
        if (IJ.isWindows() && !IJ.isVista()) {
            text = text.replaceAll("\r\n", "\n");
        }
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 0;
        int start = 0;
        int end = 0;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] != '\n') continue;
            ++count;
            start = end;
            end = i;
            if (pos < start || pos >= end) continue;
            currentLine = count;
            break;
        }
        if (currentLine == 0 && pos > end) {
            currentLine = count;
        }
        return currentLine;
    }

    final void enableDebugging() {
        this.step = true;
        Interpreter interp = Interpreter.getInstance();
        if (interp != null && interp.getEditor() == this) {
            interp.abort();
            IJ.wait(100);
        }
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        if (start == this.debugStart && end == this.debugEnd) {
            this.ta.select(start, start);
        }
    }

    final void setDebugMode(int mode) {
        this.step = true;
        Interpreter interp = Interpreter.getInstance();
        if (interp != null) {
            interp.setEditor(this);
            interp.setDebugMode(mode);
        }
    }

    public void textValueChanged(TextEvent evt) {
        if (this.isMacroWindow) {
            return;
        }
        ++this.eventCount;
        if (this.eventCount > 2 || !IJ.isMacOSX() && this.eventCount > 1) {
            this.changes = true;
        }
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(this.ta.getCaretPosition());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem item = (CheckboxMenuItem)e.getSource();
        this.setFont();
    }

    public void windowActivated(WindowEvent e) {
        WindowManager.setWindow(this);
        instance = this;
    }

    public void close() {
        boolean okayToClose = true;
        ImageJ ij = IJ.getInstance();
        if (!this.getTitle().equals("Errors") && this.changes && !IJ.isMacro() && ij != null) {
            String msg = "Save changes to \"" + this.getTitle() + "\"?";
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "Editor", msg);
            if (d.cancelPressed()) {
                okayToClose = false;
            } else if (d.yesPressed()) {
                this.save();
            }
        }
        if (okayToClose) {
            this.dispose();
            WindowManager.removeWindow(this);
            --nWindows;
            instance = null;
            this.changes = false;
        }
    }

    public void saveAs() {
        String name1 = this.getTitle();
        if (name1.indexOf(".") == -1) {
            name1 = name1 + ".txt";
        }
        if (defaultDir == null) {
            defaultDir = name1.endsWith(".txt") || name1.endsWith(".ijm") ? Menus.getMacrosPath() : Menus.getPlugInsPath();
        }
        SaveDialog sd = new SaveDialog("Save As...", defaultDir, name1, null);
        String name2 = sd.getFileName();
        String dir = sd.getDirectory();
        if (name2 != null) {
            if (name2.endsWith(".java")) {
                this.updateClassName(name1, name2);
            }
            this.path = dir + name2;
            this.save();
            this.changes = false;
            this.setWindowTitle(name2);
            Editor.setDefaultDirectory(dir);
            if (defaultDir != null) {
                Prefs.set(DEFAULT_DIR, defaultDir);
            }
            if (Recorder.record) {
                Recorder.record("saveAs", "Text", this.path);
            }
        }
    }

    public void updateClassName(String oldName, String newName) {
        if (newName.indexOf("_") < 0) {
            IJ.showMessage("Plugin Editor", "Plugins without an underscore in their name will not\nbe automatically installed when ImageJ is restarted.");
        }
        if (oldName.equals(newName) || !oldName.endsWith(".java") || !newName.endsWith(".java")) {
            return;
        }
        oldName = oldName.substring(0, oldName.length() - 5);
        newName = newName.substring(0, newName.length() - 5);
        String text1 = this.ta.getText();
        int index = text1.indexOf("public class " + oldName);
        if (index < 0) {
            return;
        }
        String text2 = text1.substring(0, index + 13) + newName + text1.substring(index + 13 + oldName.length(), text1.length());
        this.ta.setText(text2);
    }

    void find(String s) {
        if (s == null) {
            GenericDialog gd = new GenericDialog("Find", this);
            gd.addStringField("Find: ", searchString, 20);
            String[] labels = new String[]{"Case Sensitive", "Whole Words"};
            boolean[] states = new boolean[]{caseSensitive, wholeWords};
            gd.addCheckboxGroup(1, 2, labels, states);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            s = gd.getNextString();
            caseSensitive = gd.getNextBoolean();
            wholeWords = gd.getNextBoolean();
            Prefs.set(CASE_SENSITIVE, caseSensitive);
        }
        if (s.equals("")) {
            return;
        }
        String text = this.ta.getText();
        String s2 = s;
        if (!caseSensitive) {
            text = text.toLowerCase(Locale.US);
            s = s.toLowerCase(Locale.US);
        }
        int index = -1;
        if (wholeWords) {
            int position = this.ta.getCaretPosition() + 1;
            while ((index = text.indexOf(s, position)) != -1 && !this.isWholeWordMatch(text, s, index)) {
                position = index + 1;
                if (position < text.length() - 1) continue;
                index = -1;
                break;
            }
        } else {
            index = text.indexOf(s, this.ta.getCaretPosition() + 1);
        }
        searchString = s2;
        if (index < 0) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(index);
        this.ta.setSelectionEnd(index + s.length());
    }

    boolean isWholeWordMatch(String text, String word, int index) {
        char c;
        char c2 = c = index == 0 ? (char)' ' : text.charAt(index - 1);
        if (Character.isLetterOrDigit(c) || c == '_') {
            return false;
        }
        char c3 = c = index + word.length() >= text.length() ? (char)' ' : text.charAt(index + word.length());
        return !Character.isLetterOrDigit(c) && c != 95;
    }

    void gotoLine() {
        GenericDialog gd = new GenericDialog("Go to Line", this);
        gd.addNumericField("Go to line number: ", lineNumber, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        if (n < 1) {
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 1;
        int loc = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\n') {
                ++count;
            }
            if (count != n) continue;
            loc = i + 1;
            break;
        }
        this.ta.setCaretPosition(loc);
        lineNumber = n;
    }

    void zapGremlins() {
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!(inQuotes || c != '\"' && c != '\'')) {
                inQuotes = true;
                quoteChar = c;
            } else if (inQuotes && (c == quoteChar || c == '\n')) {
                inQuotes = false;
            }
            if (inQuotes || c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f') continue;
            ++count;
            chars[i] = 32;
        }
        if (count > 0) {
            text = new String(chars);
            this.ta.setText(text);
        }
        if (count > 0) {
            IJ.showMessage("Zap Gremlins", count + " invalid characters converted to spaces");
        } else {
            IJ.showMessage("Zap Gremlins", "No invalid characters found");
        }
    }

    void selectAll() {
        this.ta.selectAll();
    }

    void changeFontSize(boolean larger) {
        int in = this.fontSize++;
        if (larger) {
            if (this.fontSize == this.sizes.length) {
                this.fontSize = this.sizes.length - 1;
            }
        } else {
            --this.fontSize;
            if (this.fontSize < 0) {
                this.fontSize = 0;
            }
        }
        IJ.showStatus(this.sizes[this.fontSize] + " point");
        this.setFont();
    }

    void saveSettings() {
        Prefs.set(FONT_SIZE, this.fontSize);
        Prefs.set(FONT_MONO, this.monospaced.getState());
        IJ.showStatus("Font settings saved (size=" + this.sizes[this.fontSize] + ", monospaced=" + this.monospaced.getState() + ")");
    }

    void setFont() {
        this.ta.setFont(new Font(this.getFontName(), 0, this.sizes[this.fontSize]));
    }

    String getFontName() {
        return this.monospaced.getState() ? "Monospaced" : "SansSerif";
    }

    public void setFont(Font font) {
        this.ta.setFont(font);
    }

    public void append(String s) {
        this.ta.append(s);
    }

    public void setIsMacroWindow(boolean mw) {
        this.isMacroWindow = mw;
    }

    public static void setDefaultDirectory(String defaultDirectory) {
        defaultDir = defaultDirectory;
        if (defaultDir != null && !defaultDir.endsWith(File.separator) && !defaultDir.endsWith("/")) {
            defaultDir = defaultDir + File.separator;
        }
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    public int debug(Interpreter interp, int mode) {
        int len;
        int n;
        if (IJ.debugMode) {
            IJ.log("debug: " + interp.getLineNumber() + "  " + mode + "  " + interp);
        }
        if (mode == 4) {
            return 0;
        }
        if (!this.isVisible()) {
            interp.abortMacro();
            return 0;
        }
        if (!this.isActive()) {
            this.toFront();
        }
        if ((n = interp.getLineNumber()) == this.previousLine) {
            this.previousLine = 0;
            return 0;
        }
        this.previousLine = n;
        if (mode == 5) {
            if (n == this.runToLine) {
                mode = 1;
                interp.setDebugMode(mode);
            } else {
                return 0;
            }
        }
        String text = this.ta.getText();
        if (IJ.isWindows() && !IJ.isVista()) {
            text = text.replaceAll("\r\n", "\n");
        }
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 1;
        this.debugStart = 0;
        this.debugEnd = len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '\n') {
                ++count;
            }
            if (count == n && this.debugStart == 0) {
                this.debugStart = i + 1;
                continue;
            }
            if (count != n + 1) continue;
            this.debugEnd = i;
            break;
        }
        if (this.debugStart == 1) {
            this.debugStart = 0;
        }
        if ((this.debugStart == 0 || this.debugStart == len) && this.debugEnd == len) {
            return 0;
        }
        this.ta.select(this.debugStart, this.debugEnd);
        if (debugWindow != null && !debugWindow.isShowing()) {
            interp.setEditor(null);
            debugWindow = null;
        } else {
            debugWindow = interp.updateDebugWindow(interp.getVariables(), debugWindow);
        }
        if (mode == 1) {
            this.step = false;
            while (!this.step && !interp.done() && this.isVisible()) {
                IJ.wait(5);
            }
        } else if (mode == 3) {
            IJ.wait(5);
        } else {
            IJ.wait(150);
        }
        return 0;
    }

    public static Editor getInstance() {
        return instance;
    }

    public static String getJSPrefix(String arg) {
        return JavaScriptIncludes + "function getArgument() {return \"" + arg + "\";};";
    }

    public void fixLineEndings() {
        String text = this.ta.getText();
        text = text.replaceAll("\r\n", "\n");
        text = text.replaceAll("\r", "\n");
        this.ta.setText(text);
    }

    public boolean fileChanged() {
        return this.changes;
    }

    static {
        defaultDir = Prefs.get(DEFAULT_DIR, null);
    }
}

