/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import colorspace.boxes.PaletteBox;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.FacilityManager;

public class PalettizedColorSpaceMapper
extends ColorSpaceMapper {
    int[] outShiftValueArray;
    int srcChannel = 0;
    private PaletteBox pbox;

    public static BlkImgDataSrc createInstance(BlkImgDataSrc src, ColorSpace csMap) throws ColorSpaceException {
        return new PalettizedColorSpaceMapper(src, csMap);
    }

    protected PalettizedColorSpaceMapper(BlkImgDataSrc src, ColorSpace csMap) throws ColorSpaceException {
        super(src, csMap);
        this.pbox = csMap.getPaletteBox();
        this.initialize();
    }

    private void initialize() throws ColorSpaceException {
        if (this.ncomps != 1 && this.ncomps != 3) {
            throw new ColorSpaceException("wrong number of components (" + this.ncomps + ") for palettized image");
        }
        int outComps = this.getNumComps();
        this.outShiftValueArray = new int[outComps];
        int i = 0;
        while (i < outComps) {
            this.outShiftValueArray[i] = 1 << this.getNomRangeBits(i) - 1;
            ++i;
        }
    }

    public DataBlk getCompData(DataBlk out, int c) {
        if (this.pbox == null) {
            return this.src.getCompData(out, c);
        }
        if (this.ncomps != 1) {
            String msg = "PalettizedColorSpaceMapper: color palette _not_ applied, incorrect number (" + String.valueOf(this.ncomps) + ") of components";
            FacilityManager.getMsgLogger().printmsg(2, msg);
            return this.src.getCompData(out, c);
        }
        int leftedgeOut = -1;
        int rightedgeOut = -1;
        int leftedgeIn = -1;
        int rightedgeIn = -1;
        int kOut = -1;
        int kIn = -1;
        PalettizedColorSpaceMapper.setInternalBuffer(out);
        switch (out.getDataType()) {
            case 3: {
                PalettizedColorSpaceMapper.copyGeometry(this.inInt[0], out);
                this.inInt[0] = (DataBlkInt)this.src.getInternCompData(this.inInt[0], 0);
                this.dataInt[0] = (int[])this.inInt[0].getData();
                int[] outdataInt = ((DataBlkInt)out).getDataInt();
                int row = 0;
                while (row < out.h) {
                    leftedgeIn = this.inInt[0].offset + row * this.inInt[0].scanw;
                    rightedgeIn = leftedgeIn + this.inInt[0].w;
                    leftedgeOut = out.offset + row * out.scanw;
                    rightedgeOut = leftedgeOut + out.w;
                    kOut = leftedgeOut;
                    kIn = leftedgeIn;
                    while (kIn < rightedgeIn) {
                        outdataInt[kOut] = this.pbox.getEntry(c, this.dataInt[0][kIn] + this.shiftValueArray[0]) - this.outShiftValueArray[c];
                        ++kIn;
                        ++kOut;
                    }
                    ++row;
                }
                out.progressive = this.inInt[0].progressive;
                break;
            }
            case 4: {
                PalettizedColorSpaceMapper.copyGeometry(this.inFloat[0], out);
                this.inFloat[0] = (DataBlkFloat)this.src.getInternCompData(this.inFloat[0], 0);
                this.dataFloat[0] = (float[])this.inFloat[0].getData();
                float[] outdataFloat = ((DataBlkFloat)out).getDataFloat();
                int row = 0;
                while (row < out.h) {
                    leftedgeIn = this.inFloat[0].offset + row * this.inFloat[0].scanw;
                    rightedgeIn = leftedgeIn + this.inFloat[0].w;
                    leftedgeOut = out.offset + row * out.scanw;
                    rightedgeOut = leftedgeOut + out.w;
                    kOut = leftedgeOut;
                    kIn = leftedgeIn;
                    while (kIn < rightedgeIn) {
                        outdataFloat[kOut] = this.pbox.getEntry(c, (int)this.dataFloat[0][kIn] + this.shiftValueArray[0]) - this.outShiftValueArray[c];
                        ++kIn;
                        ++kOut;
                    }
                    ++row;
                }
                out.progressive = this.inFloat[0].progressive;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid source datablock type");
            }
        }
        out.offset = 0;
        out.scanw = out.w;
        return out;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[PalettizedColorSpaceMapper ");
        StringBuffer body = new StringBuffer("  " + eol);
        if (this.pbox != null) {
            body.append("ncomps= ").append(this.getNumComps()).append(", scomp= ").append(this.srcChannel);
            int c = 0;
            while (c < this.getNumComps()) {
                body.append(eol).append("column= ").append(c).append(", ").append(this.pbox.getBitDepth(c)).append(" bit ").append(this.pbox.isSigned(c) ? "signed entry" : "unsigned entry");
                ++c;
            }
        } else {
            body.append("image does not contain a palette box");
        }
        rep.append(ColorSpace.indent("  ", body));
        return rep.append("]").toString();
    }

    public DataBlk getInternCompData(DataBlk out, int c) {
        return this.getCompData(out, c);
    }

    public int getNomRangeBits(int c) {
        return this.pbox == null ? this.src.getNomRangeBits(c) : (int)this.pbox.getBitDepth(c);
    }

    public int getNumComps() {
        return this.pbox == null ? this.src.getNumComps() : this.pbox.getNumColumns();
    }

    public int getCompSubsX(int c) {
        return this.imgdatasrc.getCompSubsX(this.srcChannel);
    }

    public int getCompSubsY(int c) {
        return this.imgdatasrc.getCompSubsY(this.srcChannel);
    }

    public int getTileCompWidth(int t, int c) {
        return this.imgdatasrc.getTileCompWidth(t, this.srcChannel);
    }

    public int getTileCompHeight(int t, int c) {
        return this.imgdatasrc.getTileCompHeight(t, this.srcChannel);
    }

    public int getCompImgWidth(int c) {
        return this.imgdatasrc.getCompImgWidth(this.srcChannel);
    }

    public int getCompImgHeight(int c) {
        return this.imgdatasrc.getCompImgHeight(this.srcChannel);
    }

    public int getCompULX(int c) {
        return this.imgdatasrc.getCompULX(this.srcChannel);
    }

    public int getCompULY(int c) {
        return this.imgdatasrc.getCompULY(this.srcChannel);
    }
}

